#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Reflection;
using System.Resources;

[assembly: AssemblyCompany("Subtext")]
[assembly: AssemblyProduct("Subtext Blog Engine")]
[assembly: AssemblyCopyright("Copyright  Phil Haack. 2005-2010 - BSD License")]
[assembly: AssemblyInformationalVersion("2.5.2.0")]
[assembly: AssemblyDelaySign(false)]
[assembly: NeutralResourcesLanguage("en-US")]using System;
using System.Net;
using System.Windows.Forms;

namespace Subtext.Akismet.Tester
{
	public partial class frmMain : Form
	{
		AkismetClient client;
		public frmMain()
		{
			InitializeComponent();
		}

		private void btnInsertSpamAuthor_Click(object sender, EventArgs e)
		{
			txtAuthor.Text = "viagra-test-123";
		}

		private void btnVerify_Click(object sender, EventArgs e)
		{
			try
			{
				client = new AkismetClient(this.txtApiKey.Text, new Uri(this.txtBlogUrl.Text));
				this.txtResponse.Text = client.VerifyApiKey().ToString();
			}
			catch(Exception exc)
			{
				this.txtResponse.Text = exc.Message;
			}
		}

		private void btnCheck_Click(object sender, EventArgs e)
		{
			try
			{
				if (CheckVerification())
				{
					this.txtResponse.Text = client.CheckCommentForSpam(GetComment()).ToString();
				}
			}
			catch (Exception exc)
			{
				this.txtResponse.Text = exc.Message;
			}
		}

		private void btnSpam_Click(object sender, EventArgs e)
		{
			try
			{
				client.SubmitSpam(GetComment());
			}
			catch (Exception exc)
			{
				this.txtResponse.Text = exc.Message;
			}
		}

		private void btnHam_Click(object sender, EventArgs e)
		{
			try
			{
				client.SubmitHam(GetComment());
			}
			catch (Exception exc)
			{
				this.txtResponse.Text = exc.Message;
			}
		}

		private bool CheckVerification()
		{
			if (this.client == null)
			{
				this.txtResponse.Text = "Please verify Akismet first.";
				return false;
			}
			return true;
		}
		
		private IComment GetComment()
		{
			Comment comment = new Comment(IPAddress.Parse(this.txtIP.Text), txtUserAgent.Text);

			comment.CommentType = txtCommentType.Text;
			comment.Author = txtAuthor.Text;
			comment.Content = txtContent.Text;
			
			return comment;
		}
	}
}namespace Subtext.Akismet.Tester
{
	partial class frmMain
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		/// <param name="disposing">true if managed resources should be disposed; otherwise, false.</param>
		protected override void Dispose(bool disposing)
		{
			if (disposing && (components != null))
			{
				components.Dispose();
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.grpAkismet = new System.Windows.Forms.GroupBox();
			this.btnVerify = new System.Windows.Forms.Button();
			this.txtBlogUrl = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.txtApiKey = new System.Windows.Forms.TextBox();
			this.lblKey = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.txtCommentType = new System.Windows.Forms.TextBox();
			this.lblAuthor = new System.Windows.Forms.Label();
			this.txtAuthor = new System.Windows.Forms.TextBox();
			this.btnInsertSpamAuthor = new System.Windows.Forms.Button();
			this.grpComment = new System.Windows.Forms.GroupBox();
			this.btnHam = new System.Windows.Forms.Button();
			this.btnSpam = new System.Windows.Forms.Button();
			this.btnCheck = new System.Windows.Forms.Button();
			this.txtUserAgent = new System.Windows.Forms.TextBox();
			this.txtContent = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.txtIP = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.txtResponse = new System.Windows.Forms.TextBox();
			this.label6 = new System.Windows.Forms.Label();
			this.grpAkismet.SuspendLayout();
			this.grpComment.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpAkismet
			// 
			this.grpAkismet.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
						| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAkismet.Controls.Add(this.btnVerify);
			this.grpAkismet.Controls.Add(this.txtBlogUrl);
			this.grpAkismet.Controls.Add(this.label1);
			this.grpAkismet.Controls.Add(this.txtApiKey);
			this.grpAkismet.Controls.Add(this.lblKey);
			this.grpAkismet.Location = new System.Drawing.Point(3, 50);
			this.grpAkismet.Name = "grpAkismet";
			this.grpAkismet.Size = new System.Drawing.Size(404, 82);
			this.grpAkismet.TabIndex = 1;
			this.grpAkismet.TabStop = false;
			this.grpAkismet.Text = "Akismet";
			// 
			// btnVerify
			// 
			this.btnVerify.Location = new System.Drawing.Point(303, 44);
			this.btnVerify.Name = "btnVerify";
			this.btnVerify.Size = new System.Drawing.Size(75, 23);
			this.btnVerify.TabIndex = 4;
			this.btnVerify.Text = "Verify";
			this.btnVerify.UseVisualStyleBackColor = true;
			this.btnVerify.Click += new System.EventHandler(this.btnVerify_Click);
			// 
			// txtBlogUrl
			// 
			this.txtBlogUrl.Location = new System.Drawing.Point(67, 51);
			this.txtBlogUrl.Name = "txtBlogUrl";
			this.txtBlogUrl.Size = new System.Drawing.Size(220, 20);
			this.txtBlogUrl.TabIndex = 3;
			// 
			// label1
			// 
			this.label1.AutoSize = true;
			this.label1.Location = new System.Drawing.Point(6, 54);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(44, 13);
			this.label1.TabIndex = 2;
			this.label1.Text = "Blog Url";
			// 
			// txtApiKey
			// 
			this.txtApiKey.Location = new System.Drawing.Point(67, 25);
			this.txtApiKey.Name = "txtApiKey";
			this.txtApiKey.Size = new System.Drawing.Size(220, 20);
			this.txtApiKey.TabIndex = 1;
			// 
			// lblKey
			// 
			this.lblKey.AutoSize = true;
			this.lblKey.Location = new System.Drawing.Point(6, 28);
			this.lblKey.Name = "lblKey";
			this.lblKey.Size = new System.Drawing.Size(45, 13);
			this.lblKey.TabIndex = 0;
			this.lblKey.Text = "API Key";
			// 
			// label2
			// 
			this.label2.AutoSize = true;
			this.label2.Location = new System.Drawing.Point(6, 22);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(31, 13);
			this.label2.TabIndex = 2;
			this.label2.Text = "Type";
			// 
			// txtCommentType
			// 
			this.txtCommentType.Location = new System.Drawing.Point(67, 19);
			this.txtCommentType.Name = "txtCommentType";
			this.txtCommentType.Size = new System.Drawing.Size(210, 20);
			this.txtCommentType.TabIndex = 3;
			this.txtCommentType.Text = "comment";
			// 
			// lblAuthor
			// 
			this.lblAuthor.AutoSize = true;
			this.lblAuthor.Location = new System.Drawing.Point(6, 48);
			this.lblAuthor.Name = "lblAuthor";
			this.lblAuthor.Size = new System.Drawing.Size(38, 13);
			this.lblAuthor.TabIndex = 4;
			this.lblAuthor.Text = "Author";
			// 
			// txtAuthor
			// 
			this.txtAuthor.Location = new System.Drawing.Point(67, 45);
			this.txtAuthor.Name = "txtAuthor";
			this.txtAuthor.Size = new System.Drawing.Size(210, 20);
			this.txtAuthor.TabIndex = 5;
			// 
			// btnInsertSpamAuthor
			// 
			this.btnInsertSpamAuthor.Location = new System.Drawing.Point(283, 41);
			this.btnInsertSpamAuthor.Name = "btnInsertSpamAuthor";
			this.btnInsertSpamAuthor.Size = new System.Drawing.Size(115, 23);
			this.btnInsertSpamAuthor.TabIndex = 6;
			this.btnInsertSpamAuthor.Text = "<< Test Author";
			this.btnInsertSpamAuthor.UseVisualStyleBackColor = true;
			this.btnInsertSpamAuthor.Click += new System.EventHandler(this.btnInsertSpamAuthor_Click);
			// 
			// grpComment
			// 
			this.grpComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
						| System.Windows.Forms.AnchorStyles.Right)));
			this.grpComment.Controls.Add(this.btnHam);
			this.grpComment.Controls.Add(this.btnSpam);
			this.grpComment.Controls.Add(this.btnCheck);
			this.grpComment.Controls.Add(this.txtUserAgent);
			this.grpComment.Controls.Add(this.txtContent);
			this.grpComment.Controls.Add(this.label5);
			this.grpComment.Controls.Add(this.label3);
			this.grpComment.Controls.Add(this.txtIP);
			this.grpComment.Controls.Add(this.btnInsertSpamAuthor);
			this.grpComment.Controls.Add(this.label4);
			this.grpComment.Controls.Add(this.txtAuthor);
			this.grpComment.Controls.Add(this.lblAuthor);
			this.grpComment.Controls.Add(this.txtCommentType);
			this.grpComment.Controls.Add(this.label2);
			this.grpComment.Location = new System.Drawing.Point(3, 138);
			this.grpComment.Name = "grpComment";
			this.grpComment.Size = new System.Drawing.Size(404, 319);
			this.grpComment.TabIndex = 0;
			this.grpComment.TabStop = false;
			this.grpComment.Text = "Comment";
			// 
			// btnHam
			// 
			this.btnHam.Location = new System.Drawing.Point(323, 289);
			this.btnHam.Name = "btnHam";
			this.btnHam.Size = new System.Drawing.Size(75, 23);
			this.btnHam.TabIndex = 11;
			this.btnHam.Text = "Ham";
			this.btnHam.UseVisualStyleBackColor = true;
			this.btnHam.Click += new System.EventHandler(this.btnHam_Click);
			// 
			// btnSpam
			// 
			this.btnSpam.Location = new System.Drawing.Point(242, 289);
			this.btnSpam.Name = "btnSpam";
			this.btnSpam.Size = new System.Drawing.Size(75, 23);
			this.btnSpam.TabIndex = 10;
			this.btnSpam.Text = "Spam";
			this.btnSpam.UseVisualStyleBackColor = true;
			this.btnSpam.Click += new System.EventHandler(this.btnSpam_Click);
			// 
			// btnCheck
			// 
			this.btnCheck.Location = new System.Drawing.Point(161, 289);
			this.btnCheck.Name = "btnCheck";
			this.btnCheck.Size = new System.Drawing.Size(75, 23);
			this.btnCheck.TabIndex = 9;
			this.btnCheck.Text = "Check";
			this.btnCheck.UseVisualStyleBackColor = true;
			this.btnCheck.Click += new System.EventHandler(this.btnCheck_Click);
			// 
			// txtUserAgent
			// 
			this.txtUserAgent.Location = new System.Drawing.Point(67, 262);
			this.txtUserAgent.Name = "txtUserAgent";
			this.txtUserAgent.Size = new System.Drawing.Size(220, 20);
			this.txtUserAgent.TabIndex = 8;
			this.txtUserAgent.Text = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.0.7) Gecko/20060909 Firefo" +
				"x/1.5.0.7";
			// 
			// txtContent
			// 
			this.txtContent.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtContent.Location = new System.Drawing.Point(67, 72);
			this.txtContent.Multiline = true;
			this.txtContent.Name = "txtContent";
			this.txtContent.Size = new System.Drawing.Size(331, 158);
			this.txtContent.TabIndex = 8;
			// 
			// label5
			// 
			this.label5.AutoSize = true;
			this.label5.Location = new System.Drawing.Point(6, 265);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(60, 13);
			this.label5.TabIndex = 7;
			this.label5.Text = "User Agent";
			// 
			// label3
			// 
			this.label3.AutoSize = true;
			this.label3.Location = new System.Drawing.Point(6, 75);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(31, 13);
			this.label3.TabIndex = 7;
			this.label3.Text = "Body";
			// 
			// txtIP
			// 
			this.txtIP.Location = new System.Drawing.Point(67, 236);
			this.txtIP.Name = "txtIP";
			this.txtIP.Size = new System.Drawing.Size(220, 20);
			this.txtIP.TabIndex = 6;
			this.txtIP.Text = "24.126.150.127";
			// 
			// label4
			// 
			this.label4.AutoSize = true;
			this.label4.Location = new System.Drawing.Point(6, 239);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(58, 13);
			this.label4.TabIndex = 5;
			this.label4.Text = "IP Address";
			// 
			// txtResponse
			// 
			this.txtResponse.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
						| System.Windows.Forms.AnchorStyles.Left)
						| System.Windows.Forms.AnchorStyles.Right)));
			this.txtResponse.Location = new System.Drawing.Point(12, 485);
			this.txtResponse.Multiline = true;
			this.txtResponse.Name = "txtResponse";
			this.txtResponse.Size = new System.Drawing.Size(395, 82);
			this.txtResponse.TabIndex = 2;
			// 
			// label6
			// 
			this.label6.AutoSize = true;
			this.label6.Location = new System.Drawing.Point(9, 469);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(55, 13);
			this.label6.TabIndex = 3;
			this.label6.Text = "Response";
			// 
			// frmMain
			// 
			this.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
			this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
			this.ClientSize = new System.Drawing.Size(414, 581);
			this.Controls.Add(this.label6);
			this.Controls.Add(this.txtResponse);
			this.Controls.Add(this.grpAkismet);
			this.Controls.Add(this.grpComment);
			this.Name = "frmMain";
			this.Text = "Subtext Akismet Tester";
			this.grpAkismet.ResumeLayout(false);
			this.grpAkismet.PerformLayout();
			this.grpComment.ResumeLayout(false);
			this.grpComment.PerformLayout();
			this.ResumeLayout(false);
			this.PerformLayout();

		}

		#endregion

		private System.Windows.Forms.GroupBox grpAkismet;
		private System.Windows.Forms.Button btnVerify;
		private System.Windows.Forms.TextBox txtBlogUrl;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtApiKey;
		private System.Windows.Forms.Label lblKey;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox txtCommentType;
		private System.Windows.Forms.Label lblAuthor;
		private System.Windows.Forms.TextBox txtAuthor;
		private System.Windows.Forms.Button btnInsertSpamAuthor;
		private System.Windows.Forms.GroupBox grpComment;
		private System.Windows.Forms.TextBox txtContent;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Button btnHam;
		private System.Windows.Forms.Button btnSpam;
		private System.Windows.Forms.Button btnCheck;
		private System.Windows.Forms.TextBox txtUserAgent;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox txtIP;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox txtResponse;
		private System.Windows.Forms.Label label6;
	}
}

using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace Subtext.Akismet.Tester
{
	static class Program
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new frmMain());
		}
	}
}﻿using System.Reflection;
using System.Runtime.CompilerServices;
using System.Runtime.InteropServices;

// General Information about an assembly is controlled through the following 
// set of attributes. Change these attribute values to modify the information
// associated with an assembly.
[assembly: AssemblyTitle("Subtext.Akismet.Tester")]
[assembly: AssemblyDescription("")]
[assembly: AssemblyConfiguration("")]
[assembly: AssemblyCompany("VelocIT")]
[assembly: AssemblyProduct("Subtext.Akismet.Tester")]
[assembly: AssemblyCopyright("Copyright © VelocIT 2006")]
[assembly: AssemblyTrademark("")]
[assembly: AssemblyCulture("")]

// Setting ComVisible to false makes the types in this assembly not visible 
// to COM components.  If you need to access a type in this assembly from 
// COM, set the ComVisible attribute to true on that type.
[assembly: ComVisible(false)]

// The following GUID is for the ID of the typelib if this project is exposed to COM
[assembly: Guid("9a98130d-e2e0-4c92-8ed0-0e0a96ab7f5c")]

// Version information for an assembly consists of the following four values:
//
//      Major Version
//      Minor Version 
//      Build Number
//      Revision
//
[assembly: AssemblyVersion("1.0.0.0")]
[assembly: AssemblyFileVersion("1.0.0.0")]
﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.42
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Subtext.Akismet.Tester.Properties
{


	/// <summary>
	///   A strongly-typed resource class, for looking up localized strings, etc.
	/// </summary>
	// This class was auto-generated by the StronglyTypedResourceBuilder
	// class via a tool like ResGen or Visual Studio.
	// To add or remove a member, edit your .ResX file then rerun ResGen
	// with the /str option, or rebuild your VS project.
	[global::System.CodeDom.Compiler.GeneratedCodeAttribute("System.Resources.Tools.StronglyTypedResourceBuilder", "2.0.0.0")]
	[global::System.Diagnostics.DebuggerNonUserCodeAttribute()]
	[global::System.Runtime.CompilerServices.CompilerGeneratedAttribute()]
	internal class Resources
	{

		private static global::System.Resources.ResourceManager resourceMan;

		private static global::System.Globalization.CultureInfo resourceCulture;

		[global::System.Diagnostics.CodeAnalysis.SuppressMessageAttribute("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode")]
		internal Resources()
		{
		}

		/// <summary>
		///   Returns the cached ResourceManager instance used by this class.
		/// </summary>
		[global::System.ComponentModel.EditorBrowsableAttribute(global::System.ComponentModel.EditorBrowsableState.Advanced)]
		internal static global::System.Resources.ResourceManager ResourceManager
		{
			get
			{
				if ((resourceMan == null))
				{
					global::System.Resources.ResourceManager temp = new global::System.Resources.ResourceManager("Subtext.Akismet.Tester.Properties.Resources", typeof(Resources).Assembly);
					resourceMan = temp;
				}
				return resourceMan;
			}
		}

		/// <summary>
		///   Overrides the current thread's CurrentUICulture property for all
		///   resource lookups using this strongly typed resource class.
		/// </summary>
		[global::System.ComponentModel.EditorBrowsableAttribute(global::System.ComponentModel.EditorBrowsableState.Advanced)]
		internal static global::System.Globalization.CultureInfo Culture
		{
			get
			{
				return resourceCulture;
			}
			set
			{
				resourceCulture = value;
			}
		}
	}
}
﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.42
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Subtext.Akismet.Tester.Properties
{


	[global::System.Runtime.CompilerServices.CompilerGeneratedAttribute()]
	[global::System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.VisualStudio.Editors.SettingsDesigner.SettingsSingleFileGenerator", "8.0.0.0")]
	internal sealed partial class Settings : global::System.Configuration.ApplicationSettingsBase
	{

		private static Settings defaultInstance = ((Settings)(global::System.Configuration.ApplicationSettingsBase.Synchronized(new Settings())));

		public static Settings Default
		{
			get
			{
				return defaultInstance;
			}
		}
	}
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Security.Permissions;

//
// General Information about an assembly is controlled through the following 
// set of attributes. Change these attribute values to modify the information
// associated with an assembly.
//

[assembly: AssemblyTitle("Subtext.Extensibility")]
[assembly: AssemblyDescription("Contains base providers and interfaces referenced to extend Subtext.")]
[assembly: AssemblyCulture("")]
[assembly: ComVisible(false)]
[assembly: CLSCompliant(false)]
[assembly: SecurityPermission(SecurityAction.RequestMinimum, Execution = true)]using System;
using System.Diagnostics.CodeAnalysis;

[SuppressMessage("Microsoft.Design", "CA1050:DeclareTypesInNamespaces")]
[AttributeUsage(AttributeTargets.All)]
public sealed class CoverageExcludeAttribute : Attribute
{
}// This file is used by Code Analysis to maintain SuppressMessage 
// attributes that are applied to this project. 
// Project-level suppressions either have no target or are given 
// a specific target and scoped to a namespace, type, member, etc. 
//
// To add a suppression to this file, right-click the message in the 
// Error List, point to "Suppress Message(s)", and click 
// "In Project Suppression File". 
// You do not need to add suppressions to this file manually. 

using System.Diagnostics.CodeAnalysis;

[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Extensibility")]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Extensibility.Collections")]
[assembly:
    SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Plugins",
        Scope = "namespace", Target = "Subtext.Extensibility.Plugins")]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Extensibility.Web")]
[assembly: SuppressMessage("Microsoft.Design", "CA2210:AssembliesShouldHaveValidStrongNames")]#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

// This file contains documentation for the various Namespaces within this assembly.
// These classes are only used by NDoc to generate namespace documentation.
// They should all be internal sealed classes with private constructors.
//
// http://ndoc.sourceforge.net/reference/NDoc.Core.Reflection.BaseReflectionDocumenterConfig.UseNamespaceDocSummaries.html



#if DOCUMENTATION
namespace Subtext.Extensibility
{
	/// <summary>
	/// Contains base interface and abstract classes used to extend 
	/// Subtext.
	/// </summary>
	internal sealed class NamespaceDoc
	{
		private NamespaceDoc()
		{
		}
	}
}

namespace Subtext.Extensibility.Providers
{
	/// <summary>
	/// Contains the base provider definitions for Subtext.
	/// </summary>
	internal sealed class NamespaceDoc
	{
		private NamespaceDoc()
		{
		}
	}
}
#endif#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// Provides general information about the module
	/// </summary>
	public interface IImplementationInfo
	{
		/// <summary>
		/// Name of the implementation
		/// </summary>
		string Name {get;}

		/// <summary>
		/// Name of the author
		/// </summary>
		string Author {get;}

		/// <summary>
		/// Company name
		/// </summary>
		string Company {get;}

		/// <summary>
		/// Copyright information
		/// </summary>
		string Copyright {get;}

		/// <summary>
		/// Homepage Url
		/// </summary>
		Uri HomepageUrl {get;}

		/// <summary>
		/// Version information
		/// </summary>
		Version Version {get;}
	}
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// Summary description for IModuleIdentifier.
	/// </summary>
	public interface IModuleIdentifier
	{
		string Name {get;}
	}
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// This is the starting point for the plug-in architecture.  
	/// Someone want to run with this?
	/// </summary>
	public interface IPlugin
	{
		/// <summary>
		/// Identifier of the plugin. This value has to be unique. For instance, full type name may be used.
		/// </summary>
		IPluginIdentifier Id {get;}

		/// <summary>
		/// All targets for which this implementation is intended
		/// </summary>
		ITargetIdentifierCollection Targets {get;}

		/// <summary>
		/// Information about plugin implementation
		/// </summary>
		IImplementationInfo Info {get;}
	}
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;
using System.Web;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// Summary description for IModuleContext.
	/// </summary>
	public interface IPluginContext
	{
		HttpContext HttpContext {get;}
	}
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// Summary description for IPluginFactory.
	/// </summary>
	public interface IPluginFactory : IPlugin
	{
		IPluginIdentifierCollection PluginIdentifiers {get;}
		IPlugin CreatePluginInstance(IPluginIdentifier pluginId, IPluginContext context);
	}
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// Summary description for IPluginIdentifier.
	/// </summary>
	public interface IPluginIdentifier : IModuleIdentifier
	{
	}
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;
using System.Collections;
using System.Collections.Generic;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// Summary description for IPluginIdentifierCollection.
	/// </summary>
	public interface IPluginIdentifierCollection : ICollection<IPluginIdentifier>
	{
	}
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// Summary description for ITarget.
	/// </summary>
	public interface ITarget
	{
		ITargetIdentifier Id {get;}
	}
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;
using Subtext.Extensibility.Plugins;

namespace Subtext.Extensibility.Plugins
{
    /// <summary>
    /// Summary description for ITargetIdentifier.
    /// </summary>
    public interface ITargetIdentifier : IModuleIdentifier
    {
    }
}#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext-devs@lists.sourceforge.net 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;
using System.Collections;
using System.Collections.Generic;

namespace Subtext.Extensibility.Plugins
{
	/// <summary>
	/// Summary description for ITargetIdentifierCollection.
	/// </summary>
	public interface ITargetIdentifierCollection : ICollection<ITargetIdentifier>
	{
	}
}
﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.3074
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Subtext.Extensibility.Properties {
    using System;
    
    
    /// <summary>
    ///   A strongly-typed resource class, for looking up localized strings, etc.
    /// </summary>
    // This class was auto-generated by the StronglyTypedResourceBuilder
    // class via a tool like ResGen or Visual Studio.
    // To add or remove a member, edit your .ResX file then rerun ResGen
    // with the /str option, or rebuild your VS project.
    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("System.Resources.Tools.StronglyTypedResourceBuilder", "2.0.0.0")]
    [global::System.Diagnostics.DebuggerNonUserCodeAttribute()]
    [global::System.Runtime.CompilerServices.CompilerGeneratedAttribute()]
    public class Resources {
        
        private static global::System.Resources.ResourceManager resourceMan;
        
        private static global::System.Globalization.CultureInfo resourceCulture;
        
        [global::System.Diagnostics.CodeAnalysis.SuppressMessageAttribute("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode")]
        internal Resources() {
        }
        
        /// <summary>
        ///   Returns the cached ResourceManager instance used by this class.
        /// </summary>
        [global::System.ComponentModel.EditorBrowsableAttribute(global::System.ComponentModel.EditorBrowsableState.Advanced)]
        public static global::System.Resources.ResourceManager ResourceManager {
            get {
                if (object.ReferenceEquals(resourceMan, null)) {
                    global::System.Resources.ResourceManager temp = new global::System.Resources.ResourceManager("Subtext.Extensibility.Properties.Resources", typeof(Resources).Assembly);
                    resourceMan = temp;
                }
                return resourceMan;
            }
        }
        
        /// <summary>
        ///   Overrides the current thread's CurrentUICulture property for all
        ///   resource lookups using this strongly typed resource class.
        /// </summary>
        [global::System.ComponentModel.EditorBrowsableAttribute(global::System.ComponentModel.EditorBrowsableState.Advanced)]
        public static global::System.Globalization.CultureInfo Culture {
            get {
                return resourceCulture;
            }
            set {
                resourceCulture = value;
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Invalid provider type.
        /// </summary>
        public static string Argument_InvalidProviderType {
            get {
                return ResourceManager.GetString("Argument_InvalidProviderType", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Cannot iterate a page of size zero or less.
        /// </summary>
        public static string InvalidOperation_PageSizeLessThanZero {
            get {
                return ResourceManager.GetString("InvalidOperation_PageSizeLessThanZero", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to The Connection String &apos;{0}&apos; was not found in the ConnectionStrings section..
        /// </summary>
        public static string InvalidOperationException_ConnectionStringNotFound {
            get {
                return ResourceManager.GetString("InvalidOperationException_ConnectionStringNotFound", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Unable to load default &apos;{0}&apos; provider.
        /// </summary>
        public static string Provider_UnableToLoadDefaultProvider {
            get {
                return ResourceManager.GetString("Provider_UnableToLoadDefaultProvider", resourceCulture);
            }
        }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Specialized;
using System.Configuration.Provider;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Subtext.Extensibility.Providers
{
    /// <summary>
    /// Provider for classes that implement the rich text editor 
    /// to edit text visually.
    /// </summary>
    public abstract class BlogEntryEditorProvider : ProviderBase
    {
        private static readonly GenericProviderCollection<BlogEntryEditorProvider> providers =
            ProviderConfigurationHelper.LoadProviderCollection("BlogEntryEditor", out _provider);

        private static BlogEntryEditorProvider _provider;

        protected BlogEntryEditorProvider()
        {
            Height = Unit.Empty;
            Width = Unit.Empty;
        }

        /// <summary>
        /// Returns all the configured Email Providers.
        /// </summary>
        public static GenericProviderCollection<BlogEntryEditorProvider> Providers
        {
            get { return providers; }
        }


        /// <summary>
        /// Id of the control
        /// </summary>
        public virtual string ControlId { get; set; }

        /// <summary>
        /// Width of the editor
        /// </summary>
        public Unit Width { get; set; }

        /// <summary>
        /// Height of the editor
        /// </summary>
        public Unit Height { get; set; }

        /// <summary>
        /// The content of the area
        /// </summary>
        public abstract String Text { get; set; }

        /// <summary>
        /// The content of the area, but XHTML converted
        /// </summary>
        public abstract String Xhtml { get; }

        /// <summary>
        /// Return the RichTextEditorControl to be displayed inside the page
        /// </summary>
        public abstract Control RichTextEditorControl { get; }

        /// <summary>
        /// Returns the default instance of this provider.
        /// </summary>
        /// <returns></returns>
        public static BlogEntryEditorProvider Instance()
        {
            return _provider;
        }

        public override void Initialize(string name, NameValueCollection configValue)
        {
            if(configValue["Width"] != null)
            {
                Width = ParseUnit(configValue["Width"]);
            }

            if(configValue["Height"] != null)
            {
                Height = ParseUnit(configValue["Height"]);
            }

            base.Initialize(name, configValue);
        }

        protected Unit ParseUnit(string s)
        {
            try
            {
                return Unit.Parse(s);
            }
            catch(Exception)
            {
            }
            return Unit.Empty;
        }

        /// <summary>
        /// Initializes the Control to be displayed
        /// </summary>
        public abstract void InitializeControl(object subtextContext);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Specialized;
using System.Configuration.Provider;

namespace Subtext.Extensibility.Providers
{
    /// <summary>
    /// Provides a class used to handle email.
    /// </summary>
    public abstract class EmailProvider : ProviderBase
    {
        private const int DefaultSmtpPort = 25;

        private static readonly GenericProviderCollection<EmailProvider> providers =
            ProviderConfigurationHelper.LoadProviderCollection("Email", out _provider);

        private static EmailProvider _provider;
        private string _name;
        private string _smtpServer = "localhost";

        protected EmailProvider()
        {
            Port = DefaultSmtpPort;
        }

        /// <summary>
        /// Returns all the configured Email Providers.
        /// </summary>
        public static GenericProviderCollection<EmailProvider> Providers
        {
            get { return providers; }
        }

        /// <summary>
        /// Gets or sets the admin email.  This is the email address that 
        /// emails sent to a blog owner appears to be from.  It represents 
        /// the system and might not be a real address.
        /// </summary>
        /// <value></value>
        public string AdminEmail { get; set; }

        /// <summary>
        /// Gets or sets the SMTP server.  If not specified, 
        /// defaults to "localhost";
        /// </summary>
        /// <value></value>
        public string SmtpServer
        {
            get
            {
                if(string.IsNullOrEmpty(_smtpServer))
                {
                    _smtpServer = "localhost";
                }
                return _smtpServer;
            }
            set { _smtpServer = value; }
        }


        /// <summary>
        /// Gets and sets the port.
        /// </summary>
        /// <value>The port.</value>
        public int Port { get; set; }

        /// <summary>
        /// Gets and sets the SSL protocol enable.
        /// </summary>
        /// <value>true or false.</value>
        public bool SslEnabled { get; set; }

        /// <summary>
        /// Gets and sets whether to use the Commenter's email as email notification's From address
        /// </summary>
        /// <value>true or false.</value>
        public bool UseCommentersEmailAsFromAddress { get; set; }


        /// <summary>
        /// Gets or sets the password used for SMTP servers that 
        /// require authentication.
        /// </summary>
        /// <value></value>
        public string Password { get; set; }

        /// <summary>
        /// Gets or sets the name of the user for smpt servers that require authentication.
        /// </summary>
        /// <value></value>
        public string UserName { get; set; }


        /// <summary>
        /// Returns the friendly name of the provider when the provider is initialized.
        /// </summary>
        /// <value></value>
        public override string Name
        {
            get { return _name; }
        }

        /// <summary>
        /// Initializes the specified provider.
        /// </summary>
        /// <param name="name">Friendly Name of the provider.</param>
        /// <param name="configValue">Config value.</param>
        public override void Initialize(string name, NameValueCollection configValue)
        {
            _name = name;
            AdminEmail = configValue["adminEmail"];
            SmtpServer = configValue["smtpServer"];
            Password = configValue["password"];
            UserName = configValue["username"];
            if(configValue["port"] != null)
            {
                int port;
                Port = int.TryParse(configValue["port"], out port) ? port : DefaultSmtpPort;
            }

            SslEnabled = GetBoolean(configValue, "sslEnabled", true /* defaultValue */);

            UseCommentersEmailAsFromAddress = GetBoolean(configValue, "commentersEmailAsFromAddress", true
                /* defaultValue */);
        }

        /// <summary>
        /// Returns the currently configured Email Provider.
        /// </summary>
        /// <returns></returns>
        public static EmailProvider Instance()
        {
            return _provider;
        }

        private static bool GetBoolean(NameValueCollection source, string name, bool defaultValue)
        {
            if(source[name] != null)
            {
                bool result;
                if(bool.TryParse(source[name], out result))
                {
                    return result;
                }
            }
            return defaultValue;
        }

        /// <summary>
        /// Sends an email.
        /// </summary>
        /// <param name="to"></param>
        /// <param name="from"></param>
        /// <param name="subject"></param>
        /// <param name="message"></param>
        /// <returns></returns>
        public abstract void Send(string to, string from, string subject, string message);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Configuration.Provider;
using Subtext.Extensibility.Properties;

namespace Subtext.Extensibility.Providers
{
    /// <summary>
    /// Generic collection of Providers.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class GenericProviderCollection<T> : ProviderCollection where T : ProviderBase
    {
        /// <summary>
        /// Returns a provider by the specified section key.
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public new T this[string name]
        {
            get { return (T)base[name]; }
        }

        /// <summary>
        /// Adds a new provider to the collection.
        /// </summary>
        /// <param name="provider"></param>
        public override void Add(ProviderBase provider)
        {
            if(provider == null)
            {
                throw new ArgumentNullException("provider");
            }

            if(!(provider is T))
            {
                throw new ArgumentException(Resources.Argument_InvalidProviderType, "provider");
            }

            base.Add(provider);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Specialized;
using System.Configuration;
using System.Configuration.Provider;
using System.Web.Configuration;
using Subtext.Extensibility.Properties;

namespace Subtext.Extensibility.Providers
{
    public static class ProviderConfigurationHelper
    {
        /// <summary>
        /// Helper method for populating a provider collection 
        /// from a Provider section handler.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <returns></returns>
        public static GenericProviderCollection<T> LoadProviderCollection<T>(string sectionName, out T provider)
            where T : ProviderBase
        {
            // Get a reference to the provider section
            var section = (ProviderSectionHandler)WebConfigurationManager.GetSection(sectionName);

            // Load registered providers and point _provider
            // to the default provider
            var providers = new GenericProviderCollection<T>();
            ProvidersHelper.InstantiateProviders(section.Providers, providers, typeof(T));

            provider = providers[section.DefaultProvider];
            if(provider == null)
            {
                throw new ProviderException(string.Format(Resources.Provider_UnableToLoadDefaultProvider, sectionName));
            }

            return providers;
        }

        /// <summary>
        /// Gets the setting value for the specfied setting name and configValue dictionary.
        /// </summary>
        /// <param name="settingKey">Setting Name.</param>
        /// <param name="configValue">Config value.</param>
        /// <returns></returns>
        public static string GetConnectionStringSettingValue(string settingKey, NameValueCollection configValue)
        {
            if(settingKey == null)
            {
                throw new ArgumentNullException("settingKey");
            }

            if(configValue == null)
            {
                throw new ArgumentNullException("configValue");
            }

            string settingValue = configValue[settingKey];

            if(settingKey == "connectionStringName")
            {
                if(String.IsNullOrEmpty(settingValue))
                {
                    settingValue = ConfigurationManager.AppSettings["connectionStringName"];
                }
                ConnectionStringSettings setting = ConfigurationManager.ConnectionStrings[settingValue];
                if(setting == null)
                {
                    throw new ArgumentException(Resources.InvalidOperationException_ConnectionStringNotFound,
                                                "settingKey");
                }

                return setting.ConnectionString;
            }
            return null;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Configuration;

namespace Subtext.Extensibility.Providers
{
    /// <summary>
    /// Configuration Section Handler for providers.
    /// </summary>
    public class ProviderSectionHandler : ConfigurationSection
    {
        [ConfigurationProperty("providers")]
        public ProviderSettingsCollection Providers
        {
            get { return (ProviderSettingsCollection)base["providers"]; }
        }

        [ConfigurationProperty("defaultProvider")]
        public string DefaultProvider
        {
            get { return (string)base["defaultProvider"]; }
            set { base["defaultProvider"] = value; }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;

namespace Subtext.Framework
{
    /// <summary>
    /// Static class used to get collections of archived posts 
    /// (by month and year and category) from the data provider.
    /// </summary>
    public static class Archives
    {
        /// <summary>
        /// Gets archived posts by month.
        /// </summary>
        /// <returns></returns>
        public static ICollection<ArchiveCount> GetPostCountByMonth()
        {
            return ObjectProvider.Instance().GetPostCountsByMonth();
        }

        /// <summary>
        /// Gets archived posts by year.
        /// </summary>
        /// <returns></returns>
        public static ICollection<ArchiveCount> GetPostCountByYear()
        {
            return ObjectProvider.Instance().GetPostCountsByYear();
        }

        /// <summary>
        /// Gets archived posts by category.
        /// </summary>
        /// <returns></returns>
        public static ICollection<ArchiveCount> GetPostCountByCategory()
        {
            return ObjectProvider.Instance().GetPostCountsByCategory();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Security.Permissions;

[assembly: AssemblyTitle("Subtext.Framework")]
[assembly: AssemblyDescription("Contains the core business logic for Subtext.")]
[assembly: AssemblyCulture("")]
[assembly: ComVisible(false)]
[assembly: CLSCompliant(false)]
[assembly: SecurityPermission(SecurityAction.RequestMinimum, Execution = true)]#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using Ninject;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Configuration;
using Subtext.Framework.Properties;
using Subtext.Framework.Providers;
using Subtext.Framework.Text;
using Subtext.Framework.Util;
using Subtext.Framework.Web;
using Subtext.Infrastructure;

namespace Subtext.Framework
{
    /// <summary>
    /// Represents an instance of a blog.  This was formerly known as the BlogConfig class. 
    /// We are attempting to distinguish this from settings stored in web.config. This class 
    /// is persisted via a <see cref="ObjectProvider"/>.
    /// </summary>
    [Serializable]
    public class Blog
    {
        const string DefaultLanguage = "en-US";
        const int DefaultRecentCommentsLength = 50;
        private int _categoryListPostCount = 10;
        int _commentDelayInMinutes;
        string _feedbackSpamServiceKey;
        private string _host;
        private string _language = DefaultLanguage;
        string _languageCode;
        int _numberOfRecentComments;
        private string _password;
        int _recentCommentsLength;
        string _rssProxyUrl;
        private string _subfolder;
        ITimeZone _timeZone;
        string _timeZoneId;
        private string _username;

        [Inject]
        public Blog()
        {
            Id = NullValue.NullInt32;
            ItemCount = 25;
            Author = "Subtext Weblog";
            Flag = ConfigurationFlags.None;
            DaysTillCommentsClose = Int32.MaxValue;
        }

        public Blog(bool isAggregateBlog) : this()
        {
            IsAggregateBlog = isAggregateBlog;
        }

        public bool IsAggregateBlog { get; private set; }

        /// <summary>
        /// Gets or sets the date that the blog's configuration 
        /// was last updated.
        /// </summary>
        /// <value></value>
        public DateTime LastUpdated { get; set; }

        /// <summary>
        /// Gets or sets the ID of the blog.  This is the 
        /// primary key in the blog_config table.
        /// </summary>
        /// <value></value>
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the option to show the blog owners email address in rss feeds.
        /// </summary>
        public bool ShowEmailAddressInRss
        {
            get { return FlagPropertyCheck(ConfigurationFlags.ShowAuthorEmailAddressinRss); }
            set { FlagSetter(ConfigurationFlags.ShowAuthorEmailAddressinRss, value); }
        }

        /// <summary>
        /// Gets the time zone.
        /// </summary>
        /// <value>The time zone.</value>
        public virtual ITimeZone TimeZone
        {
            get
            {
                if(_timeZone == null)
                {
                    TimeZoneInfo timeZone = TimeZones.GetTimeZones().GetById(TimeZoneId) ?? TimeZoneInfo.Local;
                    _timeZone = new TimeZoneWrapper(timeZone);
                }
                return _timeZone;
            }
        }

        /// <summary>
        /// Gets or sets the time zone for the blogger.  
        /// </summary>
        /// <value></value>
        public string TimeZoneId
        {
            get { return _timeZoneId; }
            set
            {
                if(_timeZoneId != value)
                {
                    _timeZone = null;
                    _timeZoneId = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the count of posts displayed on the front page 
        /// of the blog.
        /// </summary>
        /// <value></value>
        public int ItemCount { get; set; }

        /// <summary>
        /// Gets or sets the count of posts displayed on the category pages. 
        /// </summary>
        /// <value></value>
        public int CategoryListPostCount
        {
            get { return _categoryListPostCount; }
            set
            {
                if(value < 0)
                {
                    value = 0;
                    //needed when upgrading from versions that did not have this column ("CategoryListPostCount") in the subtext_Config table.
                }
                _categoryListPostCount = value;
            }
        }

        /// <summary>
        /// Gets or sets the story count.
        /// </summary>
        /// <value></value>
        public int StoryCount { get; set; }

        /// <summary>
        /// Gets or sets the language the blog is in..
        /// </summary>
        /// <value></value>
        public string Language
        {
            get { return _language; }
            set
            {
                _language = value ?? DefaultLanguage;
                _languageCode = null;
            }
        }

        /// <summary>
        /// Gets the two (or three) letter language without the culture code.
        /// </summary>
        /// <value>The language sans culture.</value>
        public string LanguageCode
        {
            get
            {
                if(string.IsNullOrEmpty(_languageCode))
                {
                    //Just being paranoid in making this check.
                    if(_language == null)
                    {
                        _language = "en-US";
                    }
                    _languageCode = StringHelper.LeftBefore(_language, "-");
                }
                return _languageCode;
            }
        }

        /// <summary>
        /// Gets or sets the email of the blog owner.
        /// </summary>
        /// <value></value>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the host for the blog.  For 
        /// example, www.haacked.com might be a host.
        /// </summary>
        /// <value></value>
        public string Host
        {
            get { return _host; }
            set { _host = StripPortFromHost(value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this site can 
        /// be accessed via MetaBlogAPI, XML Web Services, etc..
        /// </summary>
        /// <value>
        /// 	<c>true</c> if the blog allow service access; otherwise, <c>false</c>.
        /// </value>
        public bool AllowServiceAccess
        {
            get { return FlagPropertyCheck(ConfigurationFlags.EnableServiceAccess); }
            set { FlagSetter(ConfigurationFlags.EnableServiceAccess, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether passwords are 
        /// stored in the database as cleartext or hashed.  If true, 
        /// passwords are hashed before storage.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if passwords are hashed; otherwise, <c>false</c>.
        /// </value>
        public bool IsPasswordHashed
        {
            get { return FlagPropertyCheck(ConfigurationFlags.IsPasswordHashed); }
            set { FlagSetter(ConfigurationFlags.IsPasswordHashed, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether syndicated feeds (such as 
        /// RSS or ATOM) are compressed.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if using compression, otherwise, <c>false</c>.
        /// </value>
        public bool UseSyndicationCompression
        {
            get { return FlagPropertyCheck(ConfigurationFlags.CompressSyndicatedFeed); }
            set { FlagSetter(ConfigurationFlags.CompressSyndicatedFeed, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this blog 
        /// contains some sort of feed (such as RSS or ATOM).
        /// </summary>
        /// <value>
        /// 	<c>true</c> if it is aggregated; otherwise, <c>false</c>.
        /// </value>
        public bool IsAggregated
        {
            get { return FlagPropertyCheck(ConfigurationFlags.IsAggregated); }
            set { FlagSetter(ConfigurationFlags.IsAggregated, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether comments are enabled.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if comments are enabled, otherwise, <c>false</c>.
        /// </value>
        public bool CommentsEnabled
        {
            get { return FlagPropertyCheck(ConfigurationFlags.CommentsEnabled); }
            set { FlagSetter(ConfigurationFlags.CommentsEnabled, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether comments are enabled.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if comments are enabled, otherwise, <c>false</c>.
        /// </value>
        public bool CoCommentsEnabled
        {
            get { return FlagPropertyCheck(ConfigurationFlags.CoCommentEnabled); }
            set { FlagSetter(ConfigurationFlags.CoCommentEnabled, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether blog posts and articles 
        /// have a friendly URL generated automatically from the title.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if comments are enabled, otherwise, <c>false</c>.
        /// </value>
        public bool AutoFriendlyUrlEnabled
        {
            get { return FlagPropertyCheck(ConfigurationFlags.AutoFriendlyUrlEnabled); }
            set { FlagSetter(ConfigurationFlags.AutoFriendlyUrlEnabled, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether trackbacks and pingbacks are enabled.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if comments are enabled, otherwise, <c>false</c>.
        /// </value>
        public bool TrackbacksEnabled
        {
            get { return FlagPropertyCheck(ConfigurationFlags.TrackbacksEnabled); }
            set { FlagSetter(ConfigurationFlags.TrackbacksEnabled, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether duplicate comments are enabled.  
        /// If not, duplicate comments are not allowed.
        /// </summary>
        /// <remarks>
        /// This may cause a problem with "me too!" comments.  
        /// If that is an issue, we can tweak this to only check 
        /// comments that are larger than a certain size.
        /// </remarks>
        /// <value>
        /// 	<c>true</c> if comments are enabled, otherwise, <c>false</c>.
        /// </value>
        public bool DuplicateCommentsEnabled
        {
            get { return FlagPropertyCheck(ConfigurationFlags.DuplicateCommentsEnabled); }
            set { FlagSetter(ConfigurationFlags.DuplicateCommentsEnabled, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether 
        /// <see href="http://bobwyman.pubsub.com/main/2004/09/using_rfc3229_w.html">RFC3229 for feeds</see> 
        /// delta encoding is enabled.
        /// </summary>
        /// <remarks>
        /// This can reduce bandwidth usage for RSS feeds.  When clients request a 
        /// feed using this protocol, only items that have not been sent to the client 
        /// already are sent.
        /// </remarks>
        /// <value>
        /// 	<c>true</c> if RFC3229 delta encoding is enabled.; otherwise, <c>false</c>.
        /// </value>
        public bool RFC3229DeltaEncodingEnabled
        {
            get { return FlagPropertyCheck(ConfigurationFlags.RFC3229DeltaEncodingEnabled); }
            set { FlagSetter(ConfigurationFlags.RFC3229DeltaEncodingEnabled, value); }
        }

        /// <summary>
        /// Gets or sets the days till comments close on a post.  
        /// The count starts when a post is created.
        /// </summary>
        /// <value></value>
        public int DaysTillCommentsClose { get; set; }

        /// <summary>
        /// Gets or sets the delay in minutes, between any two successive comments from 
        /// the same IP address.  This helps prevents comment bombing attacks.
        /// </summary>
        /// <value></value>
        public int CommentDelayInMinutes
        {
            get
            {
                if(_commentDelayInMinutes < 0 || _commentDelayInMinutes == int.MaxValue)
                {
                    return 0;
                }
                return _commentDelayInMinutes;
            }
            set { _commentDelayInMinutes = value; }
        }

        /// <summary>
        /// Gets or sets the number of recent comments to display in 
        /// the RecentComments control.
        /// </summary>
        /// <value></value>
        public int NumberOfRecentComments
        {
            get
            {
                if(_numberOfRecentComments < 0 || _numberOfRecentComments == int.MaxValue)
                {
                    return 0;
                }
                return _numberOfRecentComments;
            }
            set { _numberOfRecentComments = value; }
        }

        /// <summary>
        /// Gets or sets the number of characters to use to display recent comments  
        /// in the RecentComments control.
        /// </summary>
        /// <value></value>
        public int RecentCommentsLength
        {
            get
            {
                if(_recentCommentsLength < 0 || _recentCommentsLength == int.MaxValue)
                {
                    return DefaultRecentCommentsLength;
                }
                return _recentCommentsLength;
            }
            set { _recentCommentsLength = value; }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this blog is active.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if it is active; otherwise, <c>false</c>.
        /// </value>
        public bool IsActive
        {
            get { return FlagPropertyCheck(ConfigurationFlags.IsActive); }
            set { FlagSetter(ConfigurationFlags.IsActive, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether or not comments are moderated
        /// </summary>
        /// <value>
        /// 	<c>true</c> if it is active; otherwise, <c>false</c>.
        /// </value>
        public bool ModerationEnabled
        {
            get { return FlagPropertyCheck(ConfigurationFlags.CommentModerationEnabled); }
            set { FlagSetter(ConfigurationFlags.CommentModerationEnabled, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether captcha is enabled.
        /// </summary>
        /// <value><c>true</c> if captcha is enabled; otherwise, <c>false</c>.</value>
        public bool CaptchaEnabled
        {
            get { return FlagPropertyCheck(ConfigurationFlags.CaptchaEnabled); }
            set { FlagSetter(ConfigurationFlags.CaptchaEnabled, value); }
        }

        /// <summary>
        /// Gets or sets the _subfolder the blog lives in.
        /// </summary>
        /// <value></value>
        public string Subfolder
        {
            get { return _subfolder ?? string.Empty; }
            set
            {
                if(!String.IsNullOrEmpty(value))
                {
                    value = HttpHelper.StripSurroundingSlashes(value);
                }

                _subfolder = value;
            }
        }

        /// <summary>
        /// Gets or sets the password.
        /// </summary>
        /// <value></value>
        public string Password
        {
            get { return _password; }
            set { _password = value ?? string.Empty; }
        }

        /// <summary>
        /// Gets or sets the OpenIdUrl.
        /// </summary>
        /// <value></value>
        public string OpenIdUrl
        {
            get
            {
                return _openIdUrl;
            } 
            set
            {
                if(value != null)
                {
                    if(!value.StartsWith("http://") && !value.StartsWith("https://"))
                    {
                        _openIdUrl = "http://" + value;
                    }
                    else
                    {
                        _openIdUrl = value;
                    }
                }
                else
                {
                    _openIdUrl = null;
                }
            }
        }

        string _openIdUrl;

        /// <summary>
        /// Gets or sets the OpenIdServer.
        /// </summary>
        public string OpenIdServer { get; set; }

        /// <summary>
        /// Gets or sets the OpenIdDelegate.
        /// </summary>
        public string OpenIdDelegate { get; set; }

        /// <summary>
        /// Gets or sets the CardSpaceHash.
        /// </summary>
        /// <value></value>
        public string CardSpaceHash { get; set; }

        /// <summary>
        /// Gets or sets the user name for the owner of the blog.
        /// </summary>
        /// <value></value>
        public string UserName
        {
            get { return _username; }
            set { _username = value ?? string.Empty; }
        }

        /// <summary>
        /// Gets or sets the title of the blog.
        /// </summary>
        /// <value></value>
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets the sub title of the blog.
        /// </summary>
        /// <value></value>
        public string SubTitle { get; set; }

        /// <summary>
        /// Gets or sets the <see cref="SkinConfig"/> instance 
        /// which contains information about the specified skin.
        /// </summary>
        /// <value></value>
        public SkinConfig Skin { get; set; }

        /// <summary>
        /// Gets or sets the <see cref="SkinConfig"/> instance 
        /// which contains information about the specified skin.
        /// </summary>
        /// <value></value>
        public SkinConfig MobileSkin { get; set; }

        /// <summary>
        /// Gets a value indicating whether the blog has news. 
        /// News can be entered in the Admin section.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if the blog has news; otherwise, <c>false</c>.
        /// </value>
        public bool HasNews
        {
            get { return News != null && News.Trim().Length > 0; }
        }

        /// <summary>
        /// Gets or sets the news.
        /// </summary>
        /// <value></value>
        public string News { get; set; }

        /// <summary>
        /// Gets or sets the author of the blog.
        /// </summary>
        /// <value></value>
        public string Author { get; set; }

        /// <summary>
        /// Gets or sets blog tracking code.
        /// </summary>
        /// <value></value>
        public string TrackingCode { get; set; }

        /// <summary>
        /// Gets or sets the Blog Group ID
        /// </summary>
        /// <value></value>
        public int BlogGroupId { get; set; }

        /// <summary>
        /// Gets or sets the Blog Group Title
        /// </summary>
        /// <value></value>
        public string BlogGroupTitle { get; set; }

        /// <summary>
        /// Gets or sets the license URL.  This is used to 
        /// Used to specify a license within a syndicated feed. 
        /// Does not have to be a creative commons license. 
        /// <see href="http://backend.userland.com/creativeCommonsRssModule" />
        /// </summary>
        /// <value></value>
        public string LicenseUrl { get; set; }

        /// <summary>
        /// Gets or sets the Comment Service API key. This is for a comment spam filtering 
        /// service such as http://akismet.com/
        /// </summary>
        /// <value>The akismet API key.</value>
        public string FeedbackSpamServiceKey
        {
            get { return _feedbackSpamServiceKey ?? String.Empty; }
            set { _feedbackSpamServiceKey = (value ?? string.Empty); }
        }

        /// <summary>
        /// Gets a value indicating whether [akismet enabled].
        /// </summary>
        /// <value><c>true</c> if [akismet enabled]; otherwise, <c>false</c>.</value>
        public bool FeedbackSpamServiceEnabled
        {
            get { return !String.IsNullOrEmpty(_feedbackSpamServiceKey); }
        }

        /// <summary>
        /// Gets a value indicating whether an RSS Proxy such as FeedBurner is enabled.
        /// </summary>
        public bool RssProxyEnabled
        {
            get { return !String.IsNullOrEmpty(_rssProxyUrl); }
        }

        /// <summary>
        /// Gets or sets the name of the feedburner account. This is the portion of the 
        /// feedburner URL after: http://feedproxy.google.com/ You can also specify a 
        /// full URL
        /// </summary>
        /// <value>The name of the feed burner.</value>
        public string RssProxyUrl
        {
            get { return _rssProxyUrl; }
            set
            {
                if(!String.IsNullOrEmpty(value))
                {
                    if(value.Contains("\\"))
                    {
                        throw new InvalidOperationException(Resources.InvalidOperation_BackslashesInRssProxyName);
                    }
                }
                _rssProxyUrl = value;
            }
        }

        /// <summary>
        /// Gets or sets the flags pertaining to this blog.  
        /// This is a bitmask of <see cref="ConfigurationFlags"/>s.
        /// </summary>
        /// <value></value>
        public ConfigurationFlags Flag { get; set; }

        /// <summary>
        /// Gets or sets the total number of posts.
        /// </summary>
        /// <value></value>
        public int PostCount { get; set; }

        /// <summary>
        /// Gets or sets the comment count.
        /// </summary>
        /// <value></value>
        public int CommentCount { get; set; }

        /// <summary>
        /// Gets or sets the ping track count.
        /// </summary>
        /// <value></value>
        public int PingTrackCount { get; set; }

        /// <summary>
        /// Strips the port number from the host name.
        /// </summary>
        /// <param name="host">Host.</param>
        /// <returns></returns>
        public static string StripPortFromHost(string host)
        {
            if(String.IsNullOrEmpty(host))
            {
                throw new ArgumentNullException("host");
            }

            return host.LeftBefore(":", StringComparison.Ordinal);
        }

        /// <summary>
        /// Strips www prefix from host name.
        /// </summary>
        /// <param name="host">Host.</param>
        /// <returns></returns>
        public static string StripWwwPrefixFromHost(string host)
        {
            if(String.IsNullOrEmpty(host))
            {
                throw new ArgumentNullException("host");
            }

            return host.RightAfter("www.", StringComparison.OrdinalIgnoreCase);
        }

        /// <summary>
        /// Gets the active blog count by host.
        /// </summary>
        /// <param name="host">The host.</param>
        /// <returns></returns>
        /// <param name="pageIndex">Zero based index of the page to retrieve.</param>
        /// <param name="pageSize">Number of records to display on the page.</param>
        /// <param name="flags">Configuration flags to filter blogs retrieved.</param>
        public static IPagedCollection<Blog> GetBlogsByHost(string host, int pageIndex, int pageSize,
                                                            ConfigurationFlags flags)
        {
            if(String.IsNullOrEmpty(host))
            {
                throw new ArgumentNullException("host");
            }

            return ObjectProvider.Instance().GetPagedBlogs(host, pageIndex, pageSize, flags);
        }

        public IPagedCollection<BlogAlias> GetBlogAliases(int pageIndex, int pageSize)
        {
            return ObjectProvider.Instance().GetPagedBlogDomainAlias(this, pageIndex, pageSize);
        }

        /// <summary>
        /// Returns a <see cref="IList{T}"/> containing ACTIVE the <see cref="Blog"/> 
        /// instances within the specified range.
        /// </summary>
        /// <param name="pageIndex">Page index.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <param name="flags"></param>
        /// <returns></returns>
        public static IPagedCollection<Blog> GetBlogs(int pageIndex, int pageSize, ConfigurationFlags flags)
        {
            return ObjectProvider.Instance().GetPagedBlogs(null, pageIndex, pageSize, flags);
        }

        /// <summary>
        /// Adds or removes a <see cref="ConfigurationFlags"/> to the 
        /// flags set for this blog via bitmask operations.
        /// </summary>
        /// <param name="cf">Cf.</param>
        /// <param name="select">Select.</param>
        protected void FlagSetter(ConfigurationFlags cf, bool select)
        {
            if(select)
            {
                Flag = Flag | cf;
            }
            else
            {
                Flag = Flag & ~cf;
            }
        }

        /// <summary>
        /// Checks to see if the specified <see cref="ConfigurationFlags"/> 
        /// matches a flag set for this blog.
        /// </summary>
        /// <param name="cf">Cf.</param>
        /// <returns></returns>
        protected bool FlagPropertyCheck(ConfigurationFlags cf)
        {
            return (Flag & cf) == cf;
        }

        /// <summary>
        /// Returns true if the two instances are equal
        /// </summary>
        /// <param name="obj">Obj.</param>
        /// <returns></returns>
        public override bool Equals(object obj)
        {
            if(obj == null || GetType() != obj.GetType())
            {
                return false;
            }

            return ((Blog)obj).Id == Id;
        }

        /// <summary>
        /// Serves as the hash function for the type <see cref="Blog" />, 
        /// suitable for use in hashing functions.
        /// </summary>
        /// <returns></returns>
        public override int GetHashCode()
        {
            return (Host ?? string.Empty).GetHashCode() ^ (Subfolder ?? string.Empty).GetHashCode() ^ Id.GetHashCode();
        }

        public static void ClearBlogContent(int blogId)
        {
            ObjectProvider.Instance().ClearBlogContent(blogId);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework
{
    public class BlogAlias
    {
        public BlogAlias()
        {
            Id = NullValue.NullInt32;

            BlogId = NullValue.NullInt32;
            Subfolder = string.Empty;
            Host = string.Empty;
            IsActive = true;
        }

        public int Id { get; set; }

        public bool IsActive { get; set; }

        public string Host { get; set; }

        public string Subfolder { get; set; }

        public int BlogId { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;

namespace Subtext.Framework
{
    public static class CollectionExtensions
    {
        public static bool IsNullOrEmpty<T>(this IEnumerable<T> items)
        {
            return items == null || !items.Any();
        }

        public static void AddRange<T>(this ICollection<T> source, IEnumerable<T> elements)
        {
            elements.ForEach(source.Add);
        }

        public static void ForEach<T>(this IEnumerable<T> source, Action<T> action)
        {
            foreach(T item in source)
            {
                action(item);
            }
        }

        public static bool GetBoolean(this NameValueCollection source, string name)
        {
            bool result;
            return bool.TryParse(source[name], out result) && result;
        }

        public static TEnumType GetEnum<TEnumType>(this NameValueCollection source, string name)
        {
            return (TEnumType)Enum.Parse(typeof(TEnumType), source[name], true /* ignoreCase */);
        }

        public static void Accumulate<TContainer, TKey, TItem>(this IEnumerable<TContainer> containers, IEnumerable<TItem> items, Func<TContainer, TKey> keySelector, Func<TItem, TKey> itemKeySelector, Action<TContainer, TItem> accumulator)
        {
            // Assumes that items are sorted by item key in the order corresponding to container key
            var groupedItems = from item in items
                               group item by itemKeySelector(item) into groupedByKey
                               select groupedByKey;

            foreach(var itemGroup in groupedItems)
            {
                foreach(var container in containers)
                {
                    if(!keySelector(container).Equals(itemGroup.Key))
                    {
                        continue;
                    }
                    foreach(var item in itemGroup)
                    {
                        accumulator(container, item);
                    }
                }
            }
        }

    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections;
using System.Collections.Generic;
using Subtext.Extensibility.Interfaces;
using Subtext.Extensibility.Properties;

namespace Subtext.Extensibility.Collections
{
    public class CollectionBook<T> : ICollectionBook<T>
    {
        readonly int _pageSize;
        readonly Func<int, int, IPagedCollection<T>> _pageSource;

        public CollectionBook(Func<int, int, IPagedCollection<T>> pageSource, int pageSize)
        {
            _pageSource = pageSource;
            _pageSize = pageSize;
        }

        public IEnumerator<IPagedCollection<T>> GetEnumerator()
        {
            if(_pageSize <= 0)
            {
                throw new InvalidOperationException(Resources.InvalidOperation_PageSizeLessThanZero);
            }

            int pageIndex = 0;
            int pageCount = 0;

            if(pageCount == 0)
            {
                IPagedCollection<T> page = _pageSource(pageIndex, _pageSize);
                pageCount = (int)Math.Ceiling((double)page.MaxItems / _pageSize);
                yield return page;
            }

            //We've already yielded page 0, so start at 1
            while(++pageIndex < pageCount)
            {
                yield return _pageSource(pageIndex, _pageSize);
            }
        }

        ///<summary>
        ///Returns an enumerator that iterates through a collection.
        ///</summary>
        ///<returns>
        ///An <see cref="T:System.Collections.IEnumerator"></see> object that can be used to iterate through the collection.
        ///</returns>
        ///<filterpriority>2</filterpriority>
        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }

        public IEnumerable<T> AsFlattenedEnumerable()
        {
            foreach(var page in this)
            {
                foreach(var item in page)
                {
                    yield return item;
                }
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;

namespace Subtext.Extensibility.Interfaces
{
    public interface ICollectionBook<T> : IEnumerable<IPagedCollection<T>>
    {
        IEnumerable<T> AsFlattenedEnumerable();
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;

namespace Subtext.Extensibility.Interfaces
{
    /// <summary>
    /// Base interface for generic paged collections.
    /// </summary>
    public interface IPagedCollection<T> : IList<T>
    {
        int MaxItems { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using Subtext.Framework.Components;
using Subtext.Framework.Exceptions;
using Subtext.Framework.Security;
using Subtext.Framework.Services;
using Subtext.Infrastructure;

namespace Subtext.Framework
{
    /// <summary>
    /// Class used to filter incoming comments.  This will get replaced 
    /// with a plugin once the plugin architecture is complete, but the 
    /// logic will probably get ported.
    /// </summary>
    public class CommentFilter : ICommentFilter
    {
        private const string FilterCacheKey = "COMMENT FILTER:";

        /// <summary>
        /// Initializes a new instance of the <see cref="CommentFilter"/> class.
        /// </summary>
        public CommentFilter(ISubtextContext context, ICommentSpamService spamService)
        {
            SubtextContext = context;
            SpamService = spamService;
            Blog = context.Blog;
            Cache = context.Cache;
        }

        public ISubtextContext SubtextContext { get; private set; }

        protected ICommentSpamService SpamService { get; private set; }

        protected Blog Blog { get; private set; }

        protected ICache Cache { get; private set; }

        #region ICommentFilter Members

        /// <summary>
        /// Validates the feedback before it has been persisted.
        /// </summary>
        /// <param name="feedback"></param>
        /// <exception type="CommentFrequencyException">Thrown if too many comments are received from the same source in a short period.</exception>
        /// <exception type="CommentDuplicateException">Thrown if the blog does not allow duplicate comments and too many are received in a short period of time.</exception>
        public void FilterBeforePersist(FeedbackItem feedback)
        {
            if(!SubtextContext.User.IsAdministrator())
            {
                if(!SourceFrequencyIsValid(feedback))
                {
                    throw new CommentFrequencyException(Blog.CommentDelayInMinutes);
                }

                if(!Blog.DuplicateCommentsEnabled && IsDuplicateComment(feedback))
                {
                    throw new CommentDuplicateException();
                }
            }
        }

        /// <summary>
        /// Filters the comment. Throws an exception should the comment not be allowed. 
        /// Otherwise returns true.  This interface may be changed.
        /// </summary>
        /// <remarks>
        /// <p>
        /// The first filter examines whether comments are coming in too quickly 
        /// from the same SourceUrl.  Looks at the Blog.CommentDelayInMinutes.
        /// </p>
        /// <p>
        /// The second filter checks for duplicate comments. It only looks at the body 
        /// of the comment.
        /// </p>
        /// </remarks>
        /// <param name="feedbackItem">Entry.</param>
        public void FilterAfterPersist(FeedbackItem feedbackItem)
        {
            if(!SubtextContext.User.IsAdministrator())
            {
                if(!Blog.ModerationEnabled)
                {
                    //Akismet Check...
                    if(Blog.FeedbackSpamServiceEnabled && SpamService != null)
                    {
                        if(SpamService.IsSpam(feedbackItem))
                        {
                            FlagAsSpam(feedbackItem);
                            return;
                        }
                    }
                    //Note, we need to explicitely set the status flag here.
                    //Just setting Approved = true would not reset any other bits in the flag that may be set.
                    feedbackItem.Status = FeedbackStatusFlag.Approved;
                }
                else //Moderated!
                {
                    //Note, we need to explicitely set the status flag here.
                    //Just setting NeedsModeration = true would not reset any other bits in the flag that may be set.
                    feedbackItem.Status = FeedbackStatusFlag.NeedsModeration;
                }
            }
            else
            {
                //Note, we need to explicitely set the status flag here.
                //Just setting Approved = true would not reset any other bits in the flag that may be set.
                feedbackItem.Status = FeedbackStatusFlag.Approved;
            }
            feedbackItem.DateModified = Blog.TimeZone.Now;
            SubtextContext.Repository.Update(feedbackItem);
        }

        #endregion

        private void FlagAsSpam(FeedbackItem feedbackItem)
        {
            feedbackItem.FlaggedAsSpam = true;
            feedbackItem.Approved = false;
            feedbackItem.DateModified = Blog.TimeZone.Now;
            SubtextContext.Repository.Update(feedbackItem);
        }

        // Returns true if the source of the entry is not 
        // posting too many.
        bool SourceFrequencyIsValid(FeedbackItem feedbackItem)
        {
            if(Blog.CommentDelayInMinutes <= 0)
            {
                return true;
            }

            object lastComment = Cache[FilterCacheKey + feedbackItem.IpAddress];

            if(lastComment != null)
            {
                //Comment was made too frequently.
                return false;
            }

            //Add to cache.
            Cache.Insert(FilterCacheKey + feedbackItem.IpAddress, string.Empty, null,
                         DateTime.Now.AddMinutes(Blog.CommentDelayInMinutes), TimeSpan.Zero);
            return true;
        }

        // Returns true if this entry is a duplicate.
        bool IsDuplicateComment(FeedbackItem feedbackItem)
        {
            const int recentEntryCapacity = 10;

            if(Cache == null)
            {
                return false;
            }

            // Check the cache for the last 10 comments
            // Chances are, if a spam attack is occurring, then 
            // this entry will be a duplicate of a recent entry.
            // This checks in memory before going to the database (or other persistent store).
            var recentCommentChecksums = Cache[FilterCacheKey + ".RECENT_COMMENTS"] as Queue<string>;
            if(recentCommentChecksums != null)
            {
                if(recentCommentChecksums.Contains(feedbackItem.ChecksumHash))
                {
                    return true;
                }
            }
            else
            {
                recentCommentChecksums = new Queue<string>(recentEntryCapacity);
                Cache[FilterCacheKey + ".RECENT_COMMENTS"] = recentCommentChecksums;
            }

            // Check the database
            FeedbackItem duplicate = SubtextContext.Repository.GetFeedbackByChecksumHash(feedbackItem.ChecksumHash);
            if(duplicate != null)
            {
                return true;
            }

            //Ok, this is not a duplicate... Update recent comments.
            if(recentCommentChecksums.Count == recentEntryCapacity)
            {
                recentCommentChecksums.Dequeue();
            }

            recentCommentChecksums.Enqueue(feedbackItem.ChecksumHash);
            return false;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// DTO style class for representing a count of archived posts.
    /// </summary>
    [Serializable]
    public class ArchiveCount
    {
        public String Title { get; set; }

        public int Id { get; set; }

        public DateTime Date { get; set; }

        public int Count { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for BlogGroup.
    /// </summary>
    [Serializable]
    public class BlogGroup
    {
        /// <summary>
        /// Creates a new <see cref="BlogGroup"/> instance.
        /// </summary>
        public BlogGroup()
        {
        }

        /// <summary>
        /// Creates a new <see cref="BlogGroup"/> instance.
        /// </summary>
        /// <param name="id">Blog Group ID.</param>
        /// <param name="title">Title.</param>
        public BlogGroup(int id, string title)
        {
            Title = title;
            Id = id;
        }

        public string Title { get; set; }

        public bool HasDescription
        {
            get { return Description != null && Description.Trim().Length > 0; }
        }

        public string Description { get; set; }


        public int DisplayOrder { get; set; }

        [XmlAttribute("BlogGroupID")]
        public int Id { get; set; }

        public bool IsActive { get; set; }

        public ICollection<Blog> Blogs { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Components
{
    public class BlogStatistics
    {
        public int ActivePostCount { get; set; }
        public int DraftPostCount { get; set; }
        public int ActiveArticleCount { get; set; }
        public int DraftArticleCount { get; set; }
        public int FeedbackCount { get; set; }
        public int ApprovedFeedbackCount { get; set; }
        public int ApprovedTrackbackCount { get; set; }
        public int SpamFalsePositiveFeedbackCount { get; set; }
        public int SpamFalsePositiveTrackbackCount { get; set; }
        public int AwaitingModerationFeedbackCount { get; set; }
        public int AwaitingModerationTrackbackCount { get; set; }
        public int FlaggedAsSpamFeedbackCount { get; set; }
        public int FlaggedAsSpamTrackbackCount { get; set; }
        public int DeletedFeedbackCount { get; set; }
        public int DeletedTrackbackCount { get; set; }
        public int DeletedSpamFeedbackCount { get; set; }
        public int DeletedSpamTrackbackCount { get; set; }
        public int AverageCommentsPerPost { get; set; }
        public int AveragePostsPerMonth { get; set; }
        public int AveragePostsPerWeek { get; set; }
        public int AverageCommentsPerMonth { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Xml.Serialization;
using Subtext.Extensibility.Interfaces;

namespace Subtext.Framework.Components
{
    public class Category : IIdentifiable
    {
        public string Title { get; set; }

        public int BlogId { get; set; }

        #region IIdentifiable Members

        [XmlAttribute("CategoryId")]
        public int Id { get; set; }

        #endregion
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Components
{
    public enum CategoryType : byte
    {
        None = 0,
        PostCollection = 1,
        StoryCollection = 2,
        ImageCollection = 3,
        ArchiveMonthCollection = 4,
        LinkCollection = 5,
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Xml.Serialization;
using Subtext.Framework.Properties;

namespace Subtext.Framework.Components
{
    [XmlRoot("Enclosure", Namespace = "urn-Subtext")]
    public class Enclosure
    {
        public string Url { get; set; }

        public string Title { get; set; }

        public long Size { get; set; }

        public string MimeType { get; set; }

        public int Id { get; set; }

        public int EntryId { get; set; }

        public bool AddToFeed { get; set; }

        public bool ShowWithPost { get; set; }

        public string FormattedSize
        {
            get
            {
                if(Size < 1024)
                {
                    return Size + " bytes";
                }
                if(Size < 1024 * 1024)
                {
                    return Math.Round(((double)Size / 1024), 2) + " KB";
                }
                if(Size < 1024 * 1024 * 1024)
                {
                    return Math.Round(((double)Size / (1024 * 1024)), 2) + " MB";
                }

                return Math.Round(((double)Size / (1024 * 1024 * 1024)), 2) + " GB";
            }
        }

        public bool IsValid
        {
            get
            {
                if(EntryId == 0)
                {
                    ValidationMessage = Resources.Enclosure_NeedsAnEntry;
                    return false;
                }

                if(string.IsNullOrEmpty(Url))
                {
                    ValidationMessage = Resources.Enclosure_UrlRequired;
                    return false;
                }

                if(string.IsNullOrEmpty(MimeType))
                {
                    ValidationMessage = Resources.Enclosure_MimeTypeRequired;
                    return false;
                }

                if(Size == 0)
                {
                    ValidationMessage = Resources.Enclosure_SizeGreaterThanZero;
                    return false;
                }

                ValidationMessage = null;
                return true;
            }
        }

        public string ValidationMessage { get; private set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Configuration;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for Entry.
    /// </summary>
    [Serializable]
    public class Entry : IEntryIdentity
    {
        DateTime _dateSyndicated = NullValue.NullDateTime;

        public Entry(PostType postType, Blog blog)
        {
            Categories = new List<string>();
            PostConfig = PostConfig.None;
            DateModified = NullValue.NullDateTime;
            DateCreated = NullValue.NullDateTime;
            PostType = postType;
            Blog = blog;
            Id = NullValue.NullInt32;
        }

        public Entry(PostType postType)
            : this(postType, Config.CurrentBlog)
        {
        }

        /// <summary>
        /// Gets or sets the blog ID.
        /// </summary>
        /// <value>The blog ID.</value>
        public int BlogId { get; set; }

        public Blog Blog { get; set; }

        /// <summary>
        /// Gets a value indicating whether this instance has description.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has description; otherwise, <c>false</c>.
        /// </value>
        public bool HasDescription
        {
            get { return !String.IsNullOrEmpty(Description); }
        }

        /// <summary>
        /// Gets or sets the description or excerpt for this blog post. 
        /// Some blogs like to sydicate description only.
        /// </summary>
        /// <value>The description.</value>
        public string Description
        { //todo: let's rename this property to excerpt.
            get;
            set;
        }

        /// <summary>
        /// Gets a value indicating whether this instance has entry name.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has entry name; otherwise, <c>false</c>.
        /// </value>
        public bool HasEntryName
        {
            get { return EntryName != null && EntryName.Trim().Length > 0; }
        }

        /// <summary>
        /// Gets or sets the title of this post.
        /// </summary>
        /// <value>The title.</value>
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets the body of the Entry.  This is the 
        /// main content of the entry.
        /// </summary>
        /// <value></value>
        public string Body { get; set; }

        /// <summary>
        /// Gets or sets the author name of the entry.  
        /// For comments, this is the name given by the commenter. 
        /// </summary>
        /// <value>The author.</value>
        public string Author { get; set; }

        /// <summary>
        /// Gets or sets the email of the author.
        /// </summary>
        /// <value>The email.</value>
        public string Email { get; set; }


        /// <summary>
        /// Gets or sets the date this entry was last updated.
        /// </summary>
        /// <value></value>
        public DateTime DateModified { get; set; }

        /// <summary>
        /// Gets or sets the date the item was published.
        /// </summary>
        /// <value></value>
        public DateTime DateSyndicated
        {
            get { return _dateSyndicated; }
            set
            {
                if(NullValue.IsNull(value))
                {
                    IncludeInMainSyndication = false;
                }
                _dateSyndicated = value;
            }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this entry is active.
        /// </summary>
        /// <value><c>true</c> if this instance is active; otherwise, <c>false</c>.</value>
        public bool IsActive
        {
            get { return EntryPropertyCheck(PostConfig.IsActive); }
            set { PostConfigSetter(PostConfig.IsActive, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this entry allows comments.
        /// </summary>
        /// <value><c>true</c> if [allows comments]; otherwise, <c>false</c>.</value>
        public bool AllowComments
        {
            get { return EntryPropertyCheck(PostConfig.AllowComments); }
            set { PostConfigSetter(PostConfig.AllowComments, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this entry is displayed on the home page.
        /// </summary>
        /// <value><c>true</c> if [display on home page]; otherwise, <c>false</c>.</value>
        public bool DisplayOnHomePage
        {
            get { return EntryPropertyCheck(PostConfig.DisplayOnHomepage); }
            set { PostConfigSetter(PostConfig.DisplayOnHomepage, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether the description only should be syndicated.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [syndicate description only]; otherwise, <c>false</c>.
        /// </value>
        public bool SyndicateDescriptionOnly
        {
            get { return EntryPropertyCheck(PostConfig.SyndicateDescriptionOnly); }
            set { PostConfigSetter(PostConfig.SyndicateDescriptionOnly, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether [include in main syndication].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [include in main syndication]; otherwise, <c>false</c>.
        /// </value>
        public bool IncludeInMainSyndication
        {
            get
            {
                return EntryPropertyCheck(PostConfig.IncludeInMainSyndication);
            }
            set
            {
                PostConfigSetter(PostConfig.IncludeInMainSyndication, value);
            }
        }

        /// <summary>
        /// Whether or not this entry is aggregated.
        /// </summary>
        public bool IsAggregated
        {
            get { return EntryPropertyCheck(PostConfig.IsAggregated); }
            set { PostConfigSetter(PostConfig.IsAggregated, value); }
        }

        /// <summary>
        /// True if comments have been closed. Otherwise false.  Comments are closed 
        /// either explicitly or after by global age setting which overrides explicit settings
        /// </summary>
        public bool CommentingClosed
        {
            get
            {
                return (CommentingClosedByAge || EntryPropertyCheck(PostConfig.CommentsClosed));
            }
            set
            {
                // Closing By Age overrides explicit closing
                if(!CommentingClosedByAge)
                {
                    PostConfigSetter(PostConfig.CommentsClosed, value);
                }
            }
        }

        /// <summary>
        /// Returns true if the comments for this entry are closed due 
        /// to the age of the entry.  This is related to the DaysTillCommentsClose setting.
        /// </summary>
        public bool CommentingClosedByAge
        {
            get
            {
                if(Blog.DaysTillCommentsClose == int.MaxValue)
                {
                    return false;
                }

                return Blog.TimeZone.Now > DateSyndicated.AddDays(Blog.DaysTillCommentsClose);
            }
        }

        public int FeedBackCount { get; set; }

        public PostConfig PostConfig { get; set; }

        /// <summary>
        /// Returns the categories for this entry.
        /// </summary>
        public ICollection<string> Categories { get; private set; }

        /// <summary>
        /// Gets and sets the enclosure for the entry.
        /// </summary>
        public Enclosure Enclosure { get; set; }

        /// <summary>
        /// Gets or sets the entry ID.
        /// </summary>
        /// <value>The entry ID.</value>
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the type of the post.
        /// </summary>
        /// <value>The type of the post.</value>
        public PostType PostType { get; set; }

        /// <summary>
        /// Gets or sets the name of the entry.  This is used 
        /// to create a friendly URL for this entry.
        /// </summary>
        /// <value>The name of the entry.</value>
        public string EntryName { get; set; }

        /// <summary>
        /// Gets or sets the date this item was created.
        /// </summary>
        /// <value></value>
        public DateTime DateCreated { get; set; }

        protected bool EntryPropertyCheck(PostConfig ep)
        {
            return (PostConfig & ep) == ep;
        }

        protected void PostConfigSetter(PostConfig ep, bool select)
        {
            if(select)
            {
                PostConfig = PostConfig | ep;
            }
            else
            {
                PostConfig = PostConfig & ~ep;
            }
        }

        /// <summary>
        /// Calculates a simple checksum of the specified text.  
        /// This is used for comment filtering purposes. 
        /// Once deployed, this algorithm shouldn't change.
        /// </summary>
        /// <param name="text">Text.</param>
        /// <returns></returns>
        public static int CalculateChecksum(string text)
        {
            if(text == null)
            {
                throw new ArgumentNullException("text");
            }
            int checksum = 0;
            foreach(char c in text)
            {
                checksum += c;
            }
            return checksum;
        }

        public ICollection<FeedbackItem> Comments
        {
            get
            {
                if(_comments == null)
                {
                    _comments = new List<FeedbackItem>();
                }
                return _comments;
            }
        }

        List<FeedbackItem> _comments;
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.ObjectModel;
using System.Collections.Generic;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Represents a collection of <see cref="Entry">Entry</see> Components.
    /// </summary>
    public class EntryDay : Collection<Entry>
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="EntryDay">EntryDay</see> class.
        /// </summary>
        public EntryDay(DateTime day)
        {
            BlogDay = day.Date;
        }

        public EntryDay(DateTime day, IList<Entry> entries) : base(entries)
        {
            BlogDay = day.Date;
        }

        public DateTime BlogDay { get; set; }

        public string Link { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using Subtext.Extensibility;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for EntryStatsView.
    /// </summary>
    public class EntryStatsView : Entry
    {
        /// <summary>
        /// Creates a new <see cref="EntryStatsView"/> instance.
        /// </summary>
        public EntryStatsView() : base(PostType.None)
        {
        }

        public int WebCount { get; set; }

        public int AggCount { get; set; }

        public DateTime WebLastUpdated { get; set; }

        public DateTime AggLastUpdated { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;

namespace Subtext.Framework.Components
{
    public class EntrySummary : IEntryIdentity
    {
        public int ViewCount { get; set; }

        public string Title { get; set; }

        public int Id { get; set; }

        public string EntryName { get; set; }

        public DateTime DateSyndicated { get; set; }

        public PostType PostType
        {
            get { return PostType.BlogPost; }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Represents the stats for one view of an entry.
    /// </summary>
    [Serializable]
    public class EntryView
    {
        public EntryView()
        {
            BlogId = NullValue.NullInt32;
            EntryId = NullValue.NullInt32;
        }

        public int BlogId { get; set; }

        public int EntryId { get; set; }

        public string ReferralUrl { get; set; }

        public PageViewType PageViewType { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Net;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Configuration;
using Subtext.Framework.Properties;
using Subtext.Framework.Providers;
using Subtext.Framework.Security;
using Subtext.Framework.Services;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for Entry.
    /// </summary>
    [Serializable]
    public class FeedbackItem : IIdentifiable
    {
        private string _body;
        private string _email;
        string _feedbackChecksumHash = string.Empty;
        private Entry _entry;
        DateTime _parentDateCreated = NullValue.NullDateTime;
        string _parentEntryName;
        string _referrer;
        string _userAgent;

        /// <summary>
        /// Ctor. Creates a new <see cref="FeedbackItem"/> instance.
        /// </summary>
        /// <param name="type">Ptype.</param>
        public FeedbackItem(FeedbackType type)
        {
            Id = NullValue.NullInt32;
            EntryId = NullValue.NullInt32;
            FeedbackType = type;
            Status = FeedbackStatusFlag.None;
            DateCreated = NullValue.NullDateTime;
            DateModified = NullValue.NullDateTime;
            Author = string.Empty;
        }

        /// <summary>
        /// Gets or sets the blog id for this feedback item.
        /// You can usually get this via the entry, but not 
        /// for a comment left in the contact page.
        /// </summary>
        /// <value>The blog id.</value>
        public int BlogId { get; set; }

        /// <summary>
        /// Gets or sets the parent entry ID. Feedback must be associated with an entry, 
        /// except for Contact page inquiries.
        /// </summary>
        /// <value>The parent ID.</value>
        public int EntryId { get; set; }

        /// <summary>
        /// The Entry.
        /// </summary>
        public Entry Entry
        {
            get
            {
                if(_entry == null && EntryId != NullValue.NullInt32)
                {
                    _entry = new Entry(PostType.BlogPost)
                    {
                        Id = EntryId,
                        EntryName = _parentEntryName,
                        DateCreated = _parentDateCreated,
                        DateSyndicated = _parentDateSyndicated
                    };
                }
                return _entry;
            }
            set
            {
                _entry = value;
                if(value != null)
                {
                    EntryId = value.Id;
                }
            }
        }

        /// <summary>
        /// Gets or sets the type of the post.
        /// </summary>
        /// <value>The type of the post.</value>
        public FeedbackType FeedbackType { get; set; }

        /// <summary>
        /// Gets or sets the status of this feedback item.
        /// </summary>
        /// <value>The type of the post.</value>
        public FeedbackStatusFlag Status { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this feedback was created via the CommentAPI.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [created via comment API]; otherwise, <c>false</c>.
        /// </value>
        public bool CreatedViaCommentApi { get; set; }

        /// <summary>
        /// Gets or sets the title of the feedback.
        /// </summary>
        /// <value>The title.</value>
        public string Title { get; set; }

        /// <summary>
        /// Gets or sets the body of the Feedback.  This is the 
        /// main content of the entry.
        /// </summary>
        /// <value></value>
        public string Body
        {
            get { return _body; }
            set
            {
                _body = value;
                _feedbackChecksumHash = string.Empty;
            }
        }

        /// <summary>
        /// Gets or sets the source URL.  For comments, this is the URL 
        /// to the comment form used if any. For trackbacks, this is the 
        /// url of the site making the trackback.
        /// the 
        /// </summary>
        /// <value>The source URL.</value>
        public Uri SourceUrl { get; set; }

        /// <summary>
        /// Gets or sets the author name of the entry.  
        /// For comments, this is the name given by the commenter. 
        /// </summary>
        /// <value>The author.</value>
        public string Author { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this feedback was left by an author of the blog.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this feedback was left by a blog author; otherwise, <c>false</c>.
        /// </value>
        public bool IsBlogAuthor { get; set; }

        public string Email
        {
            get { return _email ?? string.Empty; }
            set { _email = value; }
        }

        public string Referrer
        {
            get { return _referrer ?? string.Empty; }
            set { _referrer = value; }
        }

        public IPAddress IpAddress { get; set; }

        public string UserAgent
        {
            get { return _userAgent ?? string.Empty; }
            set { _userAgent = value; }
        }

        /// <summary>
        /// Gets or sets the date this item was created.
        /// </summary>
        /// <value></value>
        public DateTime DateCreated { get; set; }

        /// <summary>
        /// Gets or sets the date this entry was last updated.
        /// </summary>
        /// <value></value>
        public DateTime DateModified { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this feedback is approved for display.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is approved; otherwise, <c>false</c>.
        /// </value>
        public bool Approved
        {
            get { return IsStatusSet(FeedbackStatusFlag.Approved); }
            set { SetStatus(FeedbackStatusFlag.Approved, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this feedback is approved for display.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is approved; otherwise, <c>false</c>.
        /// </value>
        public bool FlaggedAsSpam
        {
            get { return IsStatusSet(FeedbackStatusFlag.FlaggedAsSpam); }
            set { SetStatus(FeedbackStatusFlag.FlaggedAsSpam, value); }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this feedback is approved for display.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is approved; otherwise, <c>false</c>.
        /// </value>
        public bool ConfirmedSpam
        {
            get { return IsStatusSet(FeedbackStatusFlag.ConfirmedSpam); }
            set { SetStatus(FeedbackStatusFlag.ConfirmedSpam, value); }
        }

        /// <summary>
        /// Whether or not this entry needs moderator approval.
        /// </summary>
        public bool NeedsModeratorApproval
        {
            get { return FeedbackStatusFlag.NeedsModeration == Status; }
            set { SetStatus(FeedbackStatusFlag.NeedsModeration, value); }
        }

        /// <summary>
        /// Whether or not this entry is deleted (ie in the trash can).
        /// </summary>
        public bool Deleted
        {
            get { return IsStatusSet(FeedbackStatusFlag.Deleted); }
            set { SetStatus(FeedbackStatusFlag.Deleted, value); }
        }

        /// <summary>
        /// Gets a value indicating whether this comment was approved by moderator.  
        /// </summary>
        /// <remarks>
        /// If ApprovedByModerator is true, then Approved must also be true.
        /// </remarks>
        /// <value><c>true</c> if [approved by moderator]; otherwise, <c>false</c>.</value>
        public bool ApprovedByModerator
        {
            get { return IsStatusSet(FeedbackStatusFlag.ApprovedByModerator); }
        }

        /// <summary>
        /// This is a checksum of the entry text combined with 
        /// a hash of the text like so "####.HASH". 
        /// </summary>
        /// <value></value>
        public string ChecksumHash
        {
            get
            {
                if(String.IsNullOrEmpty(_feedbackChecksumHash))
                {
                    _feedbackChecksumHash = string.Format("{0}.{1}", CalculateChecksum(Body), SecurityHelper.HashPassword(Body));
                }
                return _feedbackChecksumHash;
            }
            set { _feedbackChecksumHash = value; }
        }

        /// <summary>
        /// Gets or sets the name of the parent entry.
        /// </summary>
        /// <value>The name of the parent entry.</value>
        public string ParentEntryName
        {
            get
            {
                if(_parentEntryName == null)
                {
                    _parentEntryName = Entry != null ? Entry.EntryName : string.Empty;
                }
                return _parentEntryName;
            }
            set { _parentEntryName = value; }
        }

        /// <summary>
        /// Gets or sets the parent entry date created.
        /// </summary>
        /// <value>The parent date created.</value>
        public DateTime ParentDateCreated
        {
            get
            {
                if(_parentDateCreated == NullValue.NullDateTime)
                {
                    _parentDateCreated = Entry != null ? Entry.DateCreated : DateTime.MinValue;
                }
                return _parentDateCreated;
            }
            set { _parentDateCreated = value; }
        }

        /// <summary>
        /// Gets or sets the parent entry date created.
        /// </summary>
        /// <value>The parent date created.</value>
        public DateTime ParentDateSyndicated
        {
            get
            {
                if(_parentDateSyndicated == NullValue.NullDateTime)
                {
                    _parentDateSyndicated = Entry != null ? Entry.DateSyndicated : DateTime.MinValue;
                }
                return _parentDateSyndicated;
            }
            set { _parentDateSyndicated = value; }
        }

        DateTime _parentDateSyndicated;

        /// <summary>
        /// Gets or sets the ID for this feedback item.
        /// </summary>
        /// <value>The feedback ID.</value>
        public int Id { get; set; }

        /// <summary>
        /// Gets the specified feedback by id.
        /// </summary>
        /// <param name="feedbackId">The feedback id.</param>
        /// <returns></returns>
        public static FeedbackItem Get(int feedbackId)
        {
            return ObjectProvider.Instance().GetFeedback(feedbackId);
        }

        /// <summary>
        /// Gets the feedback counts for the various top level statuses.
        /// </summary>
        public static FeedbackCounts GetFeedbackCounts()
        {
            FeedbackCounts counts;
            ObjectProvider.Instance().GetFeedbackCounts(out counts.ApprovedCount, out counts.NeedsModerationCount,
                                                        out counts.FlaggedAsSpamCount, out counts.DeletedCount);
            return counts;
        }

        /// <summary>
        /// Returns the itemCount most recent active comments.
        /// </summary>
        /// <param name="itemCount"></param>
        /// <returns></returns>
        public static ICollection<FeedbackItem> GetRecentComments(int itemCount)
        {
            return ObjectProvider.Instance().GetPagedFeedback(0, itemCount, FeedbackStatusFlag.Approved,
                                                              FeedbackStatusFlag.None, FeedbackType.Comment);
        }

        /// <summary>
        /// Updates the specified entry in the data provider.
        /// </summary>
        /// <param name="feedbackItem">Entry.</param>
        /// <returns></returns>
        public static bool Update(FeedbackItem feedbackItem)
        {
            if(feedbackItem == null)
            {
                throw new ArgumentNullException("feedbackItem");
            }

            feedbackItem.DateModified = Config.CurrentBlog.TimeZone.Now;
            return ObjectProvider.Instance().Update(feedbackItem);
        }

        /// <summary>
        /// Approves the comment, and removes it from the SPAM folder or from the 
        /// Trash folder.
        /// </summary>
        /// <param name="feedback"></param>
        /// <param name="spamService"></param>
        /// <returns></returns>
        public static void Approve(FeedbackItem feedback, ICommentSpamService spamService)
        {
            if(feedback == null)
            {
                throw new ArgumentNullException("feedback");
            }

            feedback.SetStatus(FeedbackStatusFlag.Approved, true);
            feedback.SetStatus(FeedbackStatusFlag.Deleted, false);
            if(spamService != null)
            {
                spamService.SubmitGoodFeedback(feedback);
            }

            Update(feedback);
        }

        /// <summary>
        /// Confirms the feedback as spam and moves it to the trash.
        /// </summary>
        /// <param name="feedback">The feedback.</param>
        /// <param name="spamService"></param>
        public static void ConfirmSpam(FeedbackItem feedback, ICommentSpamService spamService)
        {
            if(feedback == null)
            {
                throw new ArgumentNullException("feedback");
            }

            feedback.SetStatus(FeedbackStatusFlag.Approved, false);
            feedback.SetStatus(FeedbackStatusFlag.ConfirmedSpam, true);

            if(spamService != null)
            {
                spamService.SubmitGoodFeedback(feedback);
            }

            Update(feedback);
        }

        /// <summary>
        /// Confirms the feedback as spam and moves it to the trash.
        /// </summary>
        /// <param name="feedback">The feedback.</param>
        public static void Delete(FeedbackItem feedback)
        {
            if(feedback == null)
            {
                throw new ArgumentNullException("feedback");
            }

            feedback.SetStatus(FeedbackStatusFlag.Approved, false);
            feedback.SetStatus(FeedbackStatusFlag.Deleted, true);

            Update(feedback);
        }


        /// <summary>
        /// Destroys all non-active emails that meet the status.
        /// </summary>
        /// <param name="feedbackStatus">The feedback.</param>
        public static void Destroy(FeedbackStatusFlag feedbackStatus)
        {
            if((feedbackStatus & FeedbackStatusFlag.Approved) == FeedbackStatusFlag.Approved)
            {
                throw new InvalidOperationException(Resources.InvalidOperation_DestroyActiveComment);
            }

            ObjectProvider.Instance().DestroyFeedback(feedbackStatus);
        }

        /// <summary>
        /// Checks to see if the specified status bit is set.
        /// </summary>
        /// <param name="status">The status.</param>
        /// <returns></returns>
        protected bool IsStatusSet(FeedbackStatusFlag status)
        {
            return (Status & status) == status;
        }

        /// <summary>
        /// Turns the specified status bit on or off depending on the setOn value.
        /// </summary>
        /// <param name="status"></param>
        /// <param name="setOn"></param>
        protected void SetStatus(FeedbackStatusFlag status, bool setOn)
        {
            if(setOn)
            {
                Status = Status | status;
            }
            else
            {
                Status = Status & ~status;
            }
        }

        /// <summary>
        /// Calculates a simple checksum of the specified text.  
        /// This is used for comment filtering purposes. 
        /// Once deployed, this algorithm shouldn't change.
        /// </summary>
        /// <param name="text">Text.</param>
        /// <returns></returns>
        public static int CalculateChecksum(string text)
        {
            if(text == null)
            {
                throw new ArgumentNullException("text");
            }
            int checksum = 0;
            foreach(char c in text)
            {
                checksum += c;
            }
            return checksum;
        }
    }

    public struct FeedbackCounts
    {
        public int ApprovedCount;
        public int DeletedCount;
        public int FlaggedAsSpamCount;
        public int NeedsModerationCount;
    }

    /// <summary>
    /// Specifies the current status of a piece of feedback.
    /// </summary>
    [Flags]
    public enum FeedbackStatusFlag
    {
        None = 0,
        Approved = 1,
        NeedsModeration = 2,
        ApprovedByModerator = Approved | NeedsModeration,
        FlaggedAsSpam = 4,
        FalsePositive = FlaggedAsSpam | Approved,
        Deleted = 8,
        ConfirmedSpam = FlaggedAsSpam | Deleted,
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Components
{
    public class HostStats
    {
        public int BlogCount { get; set; }
        public int PostCount { get; set; }
        public int CommentCount { get; set; }
        public int StoryCount { get; set; }
        public int PingTrackCount { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Extensibility.Interfaces
{
    public interface IEntryIdentity : IIdentifiable
    {
        string EntryName { get; }
        DateTime DateSyndicated { get; }
        PostType PostType { get; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Extensibility.Interfaces
{
    /// <summary>
    /// Interface for classes that can be identified by an integer ID.
    /// </summary>
    public interface IIdentifiable
    {
        int Id { get; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using System.IO;
using System.Xml.Serialization;
using Subtext.Framework.Properties;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for Link.
    /// </summary>
    [Serializable]
    public class Image
    {
        private string _localDirectoryPath;
        public int BlogId { get; set; }

        public Blog Blog { get; set; }

        [XmlAttribute]
        public int ImageID { get; set; }

        public int CategoryID { get; set; }

        //TODO: This is pure laziness and a band-aid for 
        //      aggregate blogs. Will fix later.
        public string CategoryTitle { get; set; }

        public bool IsActive { get; set; }

        public string FileName { get; set; }

        /// <summary>
        /// Gets the filepath on the local server.
        /// </summary>
        public virtual string FilePath
        {
            get { return Path.Combine(LocalDirectoryPath, FileName); }
        }

        /// <summary>
        /// The directory on the local server where the image will be saved.
        /// </summary>
        /// <remarks>
        /// Assumes the specified path is a directory path!
        /// </remarks>
        public virtual string LocalDirectoryPath
        {
            get
            {
                if(_localDirectoryPath == null)
                {
                    throw new InvalidOperationException(Resources.InvalidOperation_LocalDirectoryPathNotSet);
                }

                return _localDirectoryPath;
            }
            set
            {
                if(value != null)
                {
                    value = Path.GetFullPath(value);
                }
                _localDirectoryPath = value;
            }
        }

        public string Title { get; set; }

        public int Width { get; set; }

        public int Height { get; set; }

        public string Url { get; set; }

        public string OriginalFile
        {
            get { return string.Format("o_{0}", FileName); }
        }

        public string ThumbNailFile
        {
            get { return string.Format("t_{0}", FileName); }
        }

        public string ResizedFile
        {
            get { return string.Format("r_{0}", FileName); }
        }

        public string OriginalFilePath
        {
            get { return Path.Combine(LocalDirectoryPath, OriginalFile); }
        }

        public string ThumbNailFilePath
        {
            get { return Path.Combine(LocalDirectoryPath, ThumbNailFile); }
        }

        public string ResizedFilePath
        {
            get { return Path.Combine(LocalDirectoryPath, ResizedFile); }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.ObjectModel;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Represents a collection of <see cref="Image">Image</see> Components.
    /// </summary>
    [Serializable]
    public class ImageCollection : Collection<Image>
    {
        /// <summary>
        /// The link category for this image.
        /// </summary>
        public LinkCategory Category { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using System.Xml.Serialization;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for KeyWord.
    /// </summary>
    [Serializable]
    public class KeyWord
    {
        private string _format;

        /// <summary>
        /// Gets or sets the word or words to look for. Could also be short hand. ie, ScottW would end up <a href = "http://scottwater.com/blog">Scott Watermasysk</a>
        /// </summary>
        public string Word { get; set; }

        /// <summary>
        /// The text value of an anchor tag: <a href="#">TEXT</a>
        /// </summary>
        public string Text { get; set; }

        public bool ReplaceFirstTimeOnly { get; set; }

        public bool CaseSensitive { get; set; }

        public bool OpenInNewWindow { get; set; }

        public string Url { get; set; }

        public string Title { get; set; }

        /// <summary>
        /// Rel entries for a keyword. For instance, you could add "Friend" to a keyword, and XFN would pick it up as a Friend link
        /// </summary>
        public string Rel { get; set; }

        public int BlogId { get; set; }

        [XmlAttribute]
        public int Id { get; set; }

        public string GetFormat
        {
            get
            {
                if(_format == null)
                {
                    ProcessFormat();
                }

                return _format;
            }
        }

        private void ProcessFormat()
        {
            _format = string.Format(CultureInfo.InvariantCulture, "<a href=\"{1}\"{0}{2}{3}>{4}</a>",
                                    Title != null ? string.Format(" title=\"{0}\"", Title) : String.Empty, Url,
                                    Rel != null ? string.Format(" rel=\"{0}\"", Rel) : string.Empty,
                                    OpenInNewWindow ? " target=\"_blank\"" : string.Empty, Text);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Xml.Serialization;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for Link.
    /// </summary>
    [Serializable]
    public class Link
    {
        public Link()
        {
            PostId = NullValue.NullInt32;
        }

        public int BlogId { get; set; }

        [XmlAttribute("LinkID")]
        public int Id { get; set; }

        public int PostId { get; set; }

        public int CategoryId { get; set; }

        public bool IsActive { get; set; }

        public bool NewWindow { get; set; }

        public string Url { get; set; }

        public string Rss { get; set; }

        public string Title { get; set; }

        public string Relation { get; set; }

        public bool HasRss
        {
            get { return (Rss != null && Rss.Trim().Length > 0); }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for LinkCategory.
    /// </summary>
    [Serializable]
    public class LinkCategory : Category
    {
        ICollection<Link> _links;

        /// <summary>
        /// Creates a new <see cref="LinkCategory"/> instance.
        /// </summary>
        public LinkCategory()
        {
            CategoryType = CategoryType.LinkCollection;
        }

        /// <summary>
        /// Creates a new <see cref="LinkCategory"/> instance.
        /// </summary>
        /// <param name="categoryId"></param>
        /// <param name="title">Title.</param>
        public LinkCategory(int categoryId, string title) : this()
        {
            Title = title;
            Id = categoryId;
        }

        public bool HasDescription
        {
            get { return !String.IsNullOrEmpty(Description); }
        }

        public string Description { get; set; }


        public CategoryType CategoryType { get; set; }

        public bool IsActive { get; set; }

        public ICollection<Link> Links
        {
            get
            {
                _links = _links ?? new List<Link>();
                return _links;
            }
        }

        public ICollection<Image> Images { get; set; }

        public bool HasLinks
        {
            get { return Links.Count > 0; }
        }

        public bool HasImages
        {
            get { return Images != null; }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Components
{
    [Serializable]
    public class MetaTag
    {
        public MetaTag()
        {
        }

        public MetaTag(string content)
        {
            Content = content;
        }

        public int Id { get; set; }

        public string Content { get; set; }

        public string Name { get; set; }

        public string HttpEquiv { get; set; }

        public int BlogId { get; set; }

        public int? EntryId { get; set; }

        public DateTime DateCreated { get; set; }

        /// <summary>
        /// Validates that this MetaTag is Valid:
        /// - Content must not be null nor empty
        /// - Must have either a name or http-equiv, but not both
        /// </summary>
        public bool IsValid
        {
            get
            {
                if(string.IsNullOrEmpty(Content))
                {
                    ValidationMessage = "Meta Tag requires Content.";
                    return false;
                }

                // to be valid, a MetaTag requires etiher the Name or HttpEquiv attribute, but never both.
                if(string.IsNullOrEmpty(Name) && string.IsNullOrEmpty(HttpEquiv))
                {
                    ValidationMessage = "Meta Tag requires either a Name or Http-Equiv value.";
                    return false;
                }

                if(!string.IsNullOrEmpty(Name) && !string.IsNullOrEmpty(HttpEquiv))
                {
                    ValidationMessage = "Meta Tag can not have both a Name and Http-Equiv value.";
                    return false;
                }

                ValidationMessage = null;
                return true;
            }
        }

        public string ValidationMessage { get; private set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using Subtext.Extensibility.Interfaces;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Concrete generic base class for paged collections.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class PagedCollection<T> : List<T>, IPagedCollection<T>
    {
        public PagedCollection()
        {
        }

        public PagedCollection(IEnumerable<T> collection) : base(collection)
        {
        }

        /// <summary>
        /// Returns the max number of items to display on a page.
        /// </summary>
        public int MaxItems { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for PageType.
    /// </summary>
    public enum PageType
    {
        //0 = HomePage, 1 = RSS, 2 = Date,3 = Post, 4 = Story, 5 = Other
        HomePage = 0,
        RSS = 1,
        Date = 2,
        Post = 3,
        Story = 4,
        Other = 5,
        ImagePage = 6,
        NotSpecified = NullValue.NullInt32
    } ;
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Components
{
    public enum PageViewType : byte
    {
        AggView = 0,
        WebView = 1
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for Referrer.
    /// </summary>
    [Serializable]
    public class Referrer
    {
        private string _referrerUrl;

        public string ReferrerUrl
        {
            get
            {
                if(!_referrerUrl.StartsWith("http://"))
                {
                    return string.Format("http://{0}", _referrerUrl);
                }
                return _referrerUrl;
            }
            set { _referrerUrl = value; }
        }

        public int Count { get; set; }

        public int EntryId { get; set; }

        public string PostTitle { get; set; }

        public DateTime LastReferDate { get; set; }

        public int BlogId { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using Subtext.Framework.Util;

namespace Subtext.Framework.Components
{
    [Serializable]
    public class ServerTimeZoneInfo
    {
        public ServerTimeZoneInfo()
        {
        }

        public ServerTimeZoneInfo(string timeZoneText)
            : this(TimeZones.GetTimeZones().GetById(timeZoneText), TimeZoneInfo.Local, DateTime.Now, DateTime.UtcNow)
        {
        }

        public ServerTimeZoneInfo(TimeZoneInfo timeZone, TimeZoneInfo localTimeZone, DateTime now, DateTime utcNow)
        {
            ServerTimeZone = string.Format(CultureInfo.InvariantCulture, "{0} ({1})",
                                           localTimeZone.StandardName,
                                           localTimeZone.GetUtcOffset(now));
            ServerTime = now.ToString("yyyy/MM/dd hh:mm tt", CultureInfo.InvariantCulture);
            ServerUtcTime = utcNow.ToString("yyyy/MM/dd hh:mm tt", CultureInfo.InvariantCulture);
            CurrentTime = TimeZoneInfo.ConvertTimeFromUtc(utcNow, timeZone).ToString("yyyy/MM/dd hh:mm tt",
                                                                                     CultureInfo.InvariantCulture);
        }

        public string ServerTimeZone { get; set; }

        public string ServerTime { get; set; }

        public string ServerUtcTime { get; set; }

        public string CurrentTime { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;

namespace Subtext.Framework.Components
{
    [Serializable]
    public class Tag
    {
        public Tag(KeyValuePair<string, int> tag)
        {
            TagName = tag.Key;
            Count = tag.Value;
        }

        public string TagName { get; set; }

        public int Count { get; set; }

        public int Weight { get; set; }

        public double Factor { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using Subtext.Extensibility;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Represents a trackback within this system. This is essentially 
    /// a comment created via the Trackback/Pingback API.
    /// </summary>
    public class Trackback : FeedbackItem
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Trackback"/> class.
        /// </summary>
        /// <param name="entryId">The parent id.</param>
        /// <param name="title">The title.</param>
        /// <param name="sourceUrl">The title URL.</param>
        /// <param name="author">The author.</param>
        /// <param name="body">The body.</param>
        /// <param name="dateCreated">The date created.</param>
        public Trackback(int entryId, string title, Uri sourceUrl, string author, string body, DateTime dateCreated)
            : base(FeedbackType.PingTrack)
        {
            EntryId = entryId;
            Title = title;
            SourceUrl = sourceUrl;
            Author = author;
            Body = body;

            Approved = true;
            DateCreated = DateModified = dateCreated;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Components
{
    /// <summary>
    /// Summary description for ViewStat.
    /// </summary>
    [Serializable]
    public class ViewStat
    {
        public ViewStat()
        {
            PageType = PageType.NotSpecified;
        }

        public string PageTitle { get; set; }

        public int ViewCount { get; set; }

        public DateTime ViewDate { get; set; }

        public PageType PageType { get; set; }

        public int BlogId { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Specialized;
using System.Configuration;
using System.Xml.Serialization;

namespace Subtext.Framework.Configuration
{
    /// <summary>
    /// Contains various configuration settings stored in the 
    /// web.config file.
    /// </summary>
    [Serializable]
    public class BlogConfigurationSettings
    {
        private Tracking _tracking;
        private NameValueCollection _allowedHtmlTags;

        public BlogConfigurationSettings()
        {
            QueuedThreads = 5;
            ItemCount = 15;
            CategoryListPostCount = 10;
            ServerTimeZone = -2037797565; //PST
            GalleryImageMaxWidth = 640;
            GalleryImageMaxHeight = 480;
            GalleryImageThumbnailHeight = 120;
            GalleryImageThumbnailWidth = 120;
        }

        public Tracking Tracking
        {
            get
            {
                _tracking = _tracking ?? new Tracking();
                return _tracking;
            }
            set { _tracking = value; }
        }

        public bool UseWww { get; set; }

        public int QueuedThreads { get; set; }

        public bool AllowServiceAccess { get; set; }

        public bool AllowScriptsInPosts { get; set; }

        public bool UseHashedPasswords { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether or not to allow images.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [allow images]; otherwise, <c>false</c>.
        /// </value>
        public bool AllowImages { get; set; }

        /// <summary>
        /// Gets or sets the default number of items to display 
        /// for syndication feeds.
        /// </summary>
        /// <value></value>
        public int ItemCount { get; set; }

        /// <summary>
        /// Gets or sets the number of posts to display 
        /// on the category list pages.
        /// </summary>
        /// <value></value>
        public int CategoryListPostCount { get; set; }

        /// <summary>
        /// Gets or sets the server time zone.
        /// </summary>
        /// <value></value>
        public int ServerTimeZone { get; set; }

        public int GalleryImageMaxWidth { get; set; }
        public int GalleryImageMaxHeight { get; set; }
        public int GalleryImageThumbnailWidth { get; set; }
        public int GalleryImageThumbnailHeight { get; set; }

        /// <summary>
        /// Gets a value indicating whether invisible captcha enabled.  This is 
        /// configured within the "InvisibleCaptchaEnabled" app setting. It is not 
        /// set per blog, but system-wide. This gives hosters a way to opt-out of 
        /// this feature in case it ends up being problematci.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [invisible captcha enabled]; otherwise, <c>false</c>.
        /// </value>
        public bool InvisibleCaptchaEnabled
        {
            get
            {
                if(String.IsNullOrEmpty(ConfigurationManager.AppSettings["InvisibleCaptchaEnabled"]))
                {
                    return true;
                }

                bool enabled;
                if(bool.TryParse(ConfigurationManager.AppSettings["InvisibleCaptchaEnabled"], out enabled))
                {
                    return enabled;
                }
                return true;
            }
        }

        /// <summary>
        /// Returns a <see cref="NameValueCollection"/> containing the allowed 
        /// HTML tags within a user comment.  The value contains a comma 
        /// separated list of allowed attributes.
        /// </summary>
        /// <value>The allowed HTML tags.</value>
        [XmlIgnore]
        public NameValueCollection AllowedHtmlTags
        {
            get
            {
                if(_allowedHtmlTags == null)
                {
                    _allowedHtmlTags = ((NameValueCollection)(ConfigurationManager.GetSection("AllowableCommentHtml")));
                }
                return _allowedHtmlTags;
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Configuration;
using System.Globalization;
using System.Linq;
using System.Web;
using System.Web.Configuration;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Exceptions;
using Subtext.Framework.Properties;
using Subtext.Framework.Providers;
using Subtext.Framework.Security;
using Subtext.Framework.Web;
using Subtext.Framework.Web.HttpModules;
using Subtext.Scripting;

namespace Subtext.Framework.Configuration
{
    /// <summary>
    /// Static helper class used to access various configuration 
    /// settings.
    /// </summary>
    public static class Config
    {
        private static readonly string[] InvalidSubfolders = {
                                                                  "Tags", "Admin", "aspx", "bin", "ExternalDependencies",
                                                                  "HostAdmin", "Images", "Install", "Properties",
                                                                  "Providers", "Pages", "Scripts", "Skins", 
                                                                  "SystemMessages", "UI", "Modules", "Services", 
                                                                  "Category", "Archive", "Archives", "Comments",
                                                                  "Articles", "Posts", "Story", "Stories", "Gallery",
                                                                  "aggbug", "Sitemap", "Account"
                                                              };

        static ConnectionString _connectionString;

        /// <summary>
        /// Returns an instance of <see cref="BlogConfigurationSettings"/> which 
        /// are configured within web.config as a custom config section.
        /// </summary>
        /// <value></value>
        public static BlogConfigurationSettings Settings
        {
            get { return ((BlogConfigurationSettings)ConfigurationManager.GetSection("BlogConfigurationSettings")); }
        }

        /// <summary>
        /// Returns the Subtext connection string.
        /// </summary>
        /// <remarks>
        /// The connectionStrings section may contain multiple connection strings. 
        /// The AppSetting "connectionStringName" points to which of those strings 
        /// is the one in use.
        /// </remarks>
        public static ConnectionString ConnectionString
        {
            get
            {
                if(_connectionString == null)
                {
                    string connectionStringName = ConfigurationManager.AppSettings["connectionStringName"];
                    if(ConfigurationManager.ConnectionStrings[connectionStringName] == null)
                    {
                        throw new ConfigurationErrorsException(String.Format(CultureInfo.InvariantCulture,
                                                                             Resources.
                                                                                 ConfigurationErrros_NoConnectionString,
                                                                             connectionStringName));
                    }
                    string connectionStringText =
                        ConfigurationManager.ConnectionStrings[connectionStringName].ConnectionString;
                    _connectionString = ConnectionString.Parse(connectionStringText);
                }
                return _connectionString;
            }
        }

        /// <summary>
        /// Returns a <see cref="Blog"/> instance containing 
        /// the configuration settings for the current blog.
        /// </summary>
        /// <remarks>
        ///	<para>This property may throw an exception in a couple of cases. The reason for 
        /// this is that there are a couple different reasons why the Current Blog might 
        /// not exist and we handle those situations differently in the UI. Returning 
        /// NULL does not give us enough information.
        /// </para>
        /// </remarks>
        /// <exception type="BlogDoesNotExistException">Thrown if the blog does not exist</exception>
        /// <exception type="BlogInactiveException">Thrown if the blog is no longer active</exception>
        /// <returns>The current blog</returns>
        public static Blog CurrentBlog
        {
            get
            {
                if(HttpContext.Current == null)
                {
                    return null;
                }
                BlogRequest blogRequest = BlogRequest.Current;
                if(blogRequest == null || blogRequest.IsHostAdminRequest)
                {
                    return null;
                }

                Blog currentBlog = BlogRequest.Current.Blog;
                return currentBlog;
            }
        }

        /// <summary>
        /// Gets the count of active blogs.
        /// </summary>
        /// <value></value>
        public static int ActiveBlogCount
        {
            get
            {
                IPagedCollection<Blog> blogs = Blog.GetBlogs(1, 1, ConfigurationFlags.IsActive);
                return blogs.MaxItems;
            }
        }

        /// <summary>
        /// Gets the total blog count in the system, active or not.
        /// </summary>
        /// <value></value>
        public static int BlogCount
        {
            get
            {
                IPagedCollection<Blog> blogs = Blog.GetBlogs(1, 1, ConfigurationFlags.None);
                return blogs.MaxItems;
            }
        }

        /// <summary>
        /// Gets the file not found page from web.config.
        /// </summary>
        /// <returns></returns>
        public static string GetFileNotFoundPage()
        {
            var errorsSection =
                WebConfigurationManager.GetWebApplicationSection("system.web/customErrors") as CustomErrorsSection;
            if(errorsSection != null)
            {
                CustomError fileNotFoundError = errorsSection.Errors["404"];
                if(fileNotFoundError != null)
                {
                    return fileNotFoundError.Redirect;
                }
            }
            return null;
        }

        /// <summary>
        /// Returns a <see cref="Blog"/> instance containing 
        /// the configuration settings for the blog specified by the 
        /// Hostname and Application.
        /// </summary>
        /// <remarks>
        /// Until Subtext supports multiple blogs again (if ever), 
        /// this will always return the same instance.
        /// </remarks>
        public static Blog GetBlog(string hostName, string subfolder)
        {
            hostName = Blog.StripPortFromHost(hostName);
            return ObjectProvider.Instance().GetBlog(hostName, subfolder);
        }

        /// <summary>
        /// Creates an initial blog.  This is a convenience method for 
        /// allowing a user with a freshly installed blog to immediately gain access 
        /// to the admin section to edit the blog.
        /// </summary>
        /// <param name="title">Title of the blog</param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">Password.</param>
        /// <param name="subfolder"></param>
        /// <param name="host"></param>
        /// <returns></returns>
        public static int CreateBlog(string title, string userName, string password, string host, string subfolder)
        {
            return CreateBlog(title, userName, password, host, subfolder, 1, false);
        }

        /// <summary>
        /// Creates an initial blog.  This is a convenience method for 
        /// allowing a user with a freshly installed blog to immediately gain access 
        /// to the admin section to edit the blog.
        /// </summary>
        /// <param name="title">Title of the blog</param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">Password.</param>
        /// <param name="subfolder"></param>
        /// <param name="groupId"></param>
        /// <param name="host"></param>
        /// <returns></returns>
        public static int CreateBlog(string title, string userName, string password, string host, string subfolder,
                                     int groupId)
        {
            return CreateBlog(title, userName, password, host, subfolder, groupId, false);
        }


        /// <summary>
        /// Creates an initial blog.  This is a convenience method for 
        /// allowing a user with a freshly installed blog to immediately gain access 
        /// to the admin section to edit the blog.
        /// </summary>
        /// <param name="title">Title of the blog.</param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">Password.</param>
        /// <param name="subfolder"></param>
        /// <param name="host"></param>
        /// <param name="passwordAlreadyHashed">If true, the password has already been hashed.</param>
        /// <returns></returns>
        public static int CreateBlog(string title, string userName, string password, string host, string subfolder,
                                     bool passwordAlreadyHashed)
        {
            return CreateBlog(title, userName, password, host, subfolder, 1, passwordAlreadyHashed);
        }

        /// <summary>
        /// Creates an initial blog.  This is a convenience method for 
        /// allowing a user with a freshly installed blog to immediately gain access 
        /// to the admin section to edit the blog.
        /// </summary>
        /// <param name="title">Title of the blog.</param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">Password.</param>
        /// <param name="subfolder"></param>
        /// <param name="host"></param>
        /// <param name="blogGroupId"></param>
        /// <param name="passwordAlreadyHashed">If true, the password has already been hashed.</param>
        /// <returns></returns>
        public static int CreateBlog(string title, string userName, string password, string host, string subfolder,
                                     int blogGroupId, bool passwordAlreadyHashed)
        {
            if(subfolder != null && subfolder.EndsWith("."))
            {
                throw new InvalidSubfolderNameException(subfolder);
            }

            host = Blog.StripPortFromHost(host);

            //Check for duplicate
            Blog potentialDuplicate = GetBlog(host, subfolder);
            if(potentialDuplicate != null)
            {
                //we found a duplicate!
                throw new BlogDuplicationException(potentialDuplicate);
            }

            //If the subfolder is null, this next check is redundant as it is 
            //equivalent to the check we just made.
            if(!string.IsNullOrEmpty(subfolder))
            {
                //Check to see if we're going to end up hiding another blog.
                Blog potentialHidden = GetBlog(host, string.Empty);
                if(potentialHidden != null)
                {
                    //We found a blog that would be hidden by this one.
                    throw new BlogHiddenException(potentialHidden);
                }
            }

            subfolder = HttpHelper.StripSurroundingSlashes(subfolder);

            if(string.IsNullOrEmpty(subfolder))
            {
                //Check to see if this blog requires a Subfolder value
                //This would occur if another blog has the same host already.
                int activeBlogWithHostCount = Blog.GetBlogsByHost(host, 0, 1, ConfigurationFlags.IsActive).Count;
                if(activeBlogWithHostCount > 0)
                {
                    throw new BlogRequiresSubfolderException(host, activeBlogWithHostCount);
                }
            }
            else
            {
                if(!IsValidSubfolderName(subfolder))
                {
                    throw new InvalidSubfolderNameException(subfolder);
                }
            }

            if(!passwordAlreadyHashed && Settings.UseHashedPasswords)
            {
                password = SecurityHelper.HashPassword(password);
            }

            return (ObjectProvider.Instance().CreateBlog(title, userName, password, host, subfolder, blogGroupId));
        }

        /// <summary>
        /// Updates the database with the configuration data within 
        /// the specified <see cref="Blog"/> instance.
        /// </summary>
        public static void UpdateConfigData(this ObjectProvider repository, Blog info)
        {
            //Check for duplicate
            Blog potentialDuplicate = GetBlog(info.Host, info.Subfolder);
            if(potentialDuplicate != null && !potentialDuplicate.Equals(info))
            {
                //we found a duplicate!
                throw new BlogDuplicationException(potentialDuplicate);
            }

            //Check to see if we're going to end up hiding another blog.
            Blog potentialHidden = GetBlog(info.Host, string.Empty);
            if(potentialHidden != null && !potentialHidden.Equals(info) && potentialHidden.IsActive)
            {
                //We found a blog that would be hidden by this one.
                throw new BlogHiddenException(potentialHidden);
            }

            string subfolderName = info.Subfolder == null
                                       ? string.Empty
                                       : HttpHelper.StripSurroundingSlashes(info.Subfolder);

            if(subfolderName.Length == 0)
            {
                //Check to see if this blog requires a Subfolder value
                //This would occur if another blog has the same host already.
                IPagedCollection<Blog> blogsWithHost = Blog.GetBlogsByHost(info.Host, 0, 1, ConfigurationFlags.IsActive);
                if(blogsWithHost.Count > 0)
                {
                    if(blogsWithHost.Count > 1 || !blogsWithHost.First().Equals(info))
                    {
                        throw new BlogRequiresSubfolderException(info.Host, blogsWithHost.Count);
                    }
                }
            }
            else
            {
                if(!IsValidSubfolderName(subfolderName))
                {
                    throw new InvalidSubfolderNameException(subfolderName);
                }
            }

            info.IsPasswordHashed = Settings.UseHashedPasswords;
            info.AllowServiceAccess = Settings.AllowServiceAccess;

            repository.UpdateBlog(info);
        }

        /// <summary>
        /// Returns true if the specified subfolder name has a 
        /// valid format. It may not start, nor end with ".".  It 
        /// may not contain any of the following invalid characters 
        /// {}[]/\ @!#$%:^&*()?+|"='<>;,
        /// </summary>
        /// <param name="subfolder">subfolder.</param>
        /// <returns></returns>
        public static bool IsValidSubfolderName(string subfolder)
        {
            if(subfolder == null)
            {
                throw new ArgumentNullException("subfolder");
            }

            if(subfolder.EndsWith("."))
            {
                return false;
            }

            const string invalidChars = @"{}[]/\ @!#$%:^&*()?+|""='<>;,";

            foreach(char c in invalidChars)
            {
                if(subfolder.IndexOf(c) > -1)
                {
                    return false;
                }
            }

            foreach(string invalidSubFolder in InvalidSubfolders)
            {
                if(String.Equals(invalidSubFolder, subfolder, StringComparison.OrdinalIgnoreCase))
                {
                    return false;
                }
            }
            return true;
        }

        /// <summary>
        /// Adds the blog alias to the system.
        /// </summary>
        /// <param name="alias">The alias.</param>
        /// <returns></returns>
        public static bool AddBlogAlias(BlogAlias alias)
        {
            return ObjectProvider.Instance().CreateBlogAlias(alias);
        }

        /// <summary>
        /// Updates the blog alias.
        /// </summary>
        /// <param name="alias">The alias.</param>
        /// <returns></returns>
        public static bool UpdateBlogAlias(BlogAlias alias)
        {
            return ObjectProvider.Instance().UpdateBlogAlias(alias);
        }

        /// <summary>
        /// Deletes the blog alias.
        /// </summary>
        /// <param name="alias">The alias.</param>
        /// <returns></returns>
        public static bool DeleteBlogAlias(BlogAlias alias)
        {
            return ObjectProvider.Instance().DeleteBlogAlias(alias);
        }

        /// <summary>
        /// Gets the blog alias.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <returns></returns>
        public static BlogAlias GetBlogAlias(int id)
        {
            return ObjectProvider.Instance().GetBlogAliasById(id);
        }

        /// <summary>
        /// Gets the blog group by id.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public static BlogGroup GetBlogGroup(int id, bool activeOnly)
        {
            return ObjectProvider.Instance().GetBlogGroup(id, activeOnly);
        }

        /// <summary>
        /// Lists the blog groups in this installation.
        /// </summary>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public static ICollection<BlogGroup> ListBlogGroups(bool activeOnly)
        {
            return ObjectProvider.Instance().ListBlogGroups(activeOnly);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Configuration
{
    /// <summary>
    /// <p>Bitmask enumeration used to specify the several properties in one 
    /// value within the database.</p>
    /// </list>
    /// </summary>
    [Flags]
    public enum ConfigurationFlags
    {
        /// <summary>Nothing is set</summary>
        None = 0,
        /// <summary>The Blog is Active</summary>
        IsActive = 1,
        /// <summary>The Blog has a syndicated feed (RSS or ATOM)</summary>
        IsAggregated = 2,
        /// <summary>The Blog can be accessed via XML over HTTP APIs</summary>
        EnableServiceAccess = 4,
        /// <summary>Whether or not the password is hashed.</summary>
        IsPasswordHashed = 8,
        /// <summary>Whether or not Comments are enabled.</summary>
        CommentsEnabled = 16,
        /// <summary>Whether or not trackbacks and pingbacks are enabled.</summary>
        TrackbacksEnabled = 32,
        /// <summary>The Blog compresses its syndicated feeds.</summary>
        CompressSyndicatedFeed = 64,
        /// <summary>Whether or not duplicate comments are allowed.</summary>
        DuplicateCommentsEnabled = 128,
        /// <summary>
        /// Whether or not <see href="http://bobwyman.pubsub.com/main/2004/09/using_rfc3229_w.html">RFC3229 for feeds</see>
        /// is enabled. Enabling this can save on bandwidth by providing just updated posts in the 
        /// RSS feed.
        /// </summary>
        RFC3229DeltaEncodingEnabled = 256,
        /// <summary>
        /// Whether or not titles of blog posts and articles automatically have a friendly url generated.
        /// </summary>
        AutoFriendlyUrlEnabled = 512,
        /// <summary>Whether or not coComment is enabled</summary>
        CoCommentEnabled = 1024,
        /// <summary>The blog allows for comment moderation.</summary>
        CommentModerationEnabled = 2048,
        /// <summary>CAPTCHA is enabled on comment forms.</summary>
        CaptchaEnabled = 4096,
        /// <summary>Comment notification mails are enabled.</summary>
        CommentNotificationEnabled = 8192,
        /// <summary>Trackback notification mails are enabled.</summary>
        TrackbackNotificationEnabled = 16384,
        /// <summary>Show blog author email address in rss feed</summary>
        ShowAuthorEmailAddressinRss = 32768,
    } ;
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Specialized;
using System.Configuration;
using System.Globalization;
using log4net;
using Subtext.Framework.Logging;

namespace Subtext.Configuration
{
    /// <summary>
    /// Encapsulates settings for friendly URL generation.
    /// </summary>
    public sealed class FriendlyUrlSettings
    {
        private readonly static ILog Log = new Log();

        public static readonly FriendlyUrlSettings Settings =
            new FriendlyUrlSettings((NameValueCollection)ConfigurationManager.GetSection("FriendlyUrlSettings"));

        /// <summary>
        /// Initializes a new instance of the <see cref="FriendlyUrlSettings"/> class.
        /// </summary>
        /// <param name="config">The config.</param>
        public FriendlyUrlSettings(NameValueCollection config)
        {
            if(config == null)
            {
                return;
            }
            TextTransformation = ParseTextTransform(config["textTransform"]);
            SeparatingCharacter = config["separatingCharacter"];
            string wordCountLimitText = config["limitWordCount"];
            if(!String.IsNullOrEmpty(wordCountLimitText))
            {
                int wordCountLimit;
                int.TryParse(wordCountLimitText, out wordCountLimit);
                WordCountLimit = wordCountLimit;
            }
            Enabled = true;
        }

        public bool Enabled { get; private set; }

        /// <summary>
        /// The type of transformation to apply on the URL such 
        /// as LowerCase, UpperCase, or None.
        /// </summary>
        public TextTransform TextTransformation { get; private set; }

        /// <summary>
        /// The character used to separate words in the URL.
        /// </summary>
        public string SeparatingCharacter { get; private set; }

        public int WordCountLimit { get; private set; }

        static TextTransform ParseTextTransform(string enumValue)
        {
            if(String.IsNullOrEmpty(enumValue))
            {
                return TextTransform.None;
            }
            try
            {
                return (TextTransform)Enum.Parse(typeof(TextTransform), enumValue);
            }
            catch(FormatException)
            {
                Log.Warn(
                    "The 'textTransform' setting in the FriendlyUrlSettings section of Web.config has an incorrect value. It should be 'None', 'LowerCase', or 'UpperCase'");
                return TextTransform.None;
            }
        }

        public static string TransformString(string s, TextTransform textTransform)
        {
            switch(textTransform)
            {
                case TextTransform.None:
                    break;

                case TextTransform.LowerCase:
                    return s.ToLower(CultureInfo.InvariantCulture);

                case TextTransform.UpperCase:
                    return s.ToUpper(CultureInfo.InvariantCulture);
            }
            return s;
        }
    }

    public enum TextTransform
    {
        None,
        LowerCase,
        UpperCase
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Web;
using System.Xml.Serialization;
using Lucene.Net.Analysis;

namespace Subtext.Framework.Configuration
{
    public class FullTextSearchEngineSettings
    {
        public static readonly FullTextSearchEngineSettings Settings = (FullTextSearchEngineSettings)ConfigurationManager.GetSection("FullTextSearchEngineSettings");

        private string _stopWordsString;

        public FullTextSearchEngineSettings()
        {
            Language = "English";
            StopWords = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
            Parameters = new TuningParameters();
            MinimumScore = 0.1f;
            IndexFolderLocation = "~/App_Data";
            IsEnabled = true;
        }

        public string Language { get; set; }
        public string IndexFolderLocation { get; set; }
        public bool IsEnabled { get; set; }
        public TuningParameters Parameters { get; set; }
        [XmlElement("StopWords")]
        public string StopWordsString
        {
            set 
            { 
                _stopWordsString = value;
                String[] stopWords = _stopWordsString.Split(',');

                var stopSet = new CharArraySet(stopWords, false);
                StopWords = CharArraySet.UnmodifiableSet(stopSet);
            }
        }
        [XmlIgnore]
        public Hashtable StopWords { get; private set; }

        public float MinimumScore { get; set; }

    }

    public class TuningParameters
    {

        public TuningParameters()
        {
            TitleBoost = 2f;
            TagsBoost = 4f;
            BodyBoost = 1f;
            EntryNameBoost = 1f;
            MoreLikeThisBoost = true;
            MinimumDocumentFrequency = 5;
            MinimumTermFrequency = 2;
         }

        /// <summary>
        /// Boost to apply to the title of an entry. Default is 2.
        /// </summary>
        public Single TitleBoost { get; set; }
        /// <summary>
        /// Boost to apply to the tags of an entry. Default is 4.
        /// </summary>
        public Single TagsBoost { get; set; }
        /// <summary>
        /// Boost to apply to the body of an entry. Default is 1.
        /// </summary>
        public Single BodyBoost { get; set; }
        /// <summary>
        /// Boost to apply to the name of an entry. Default is 1.
        /// </summary>
        public Single EntryNameBoost { get; set; }
        /// <summary>
        /// Boost terms in query based on score.
        /// </summary>
        public Boolean MoreLikeThisBoost { get; set; }
        /// <summary>
        /// The frequency at which words will be ignored which do not occur in at least this
        /// many docs. Default is 5.
        /// </summary>
        public int MinimumDocumentFrequency { get; set; }
        /// <summary>
        /// The frequency below which terms will be ignored in the source doc.
        /// Default is 2.
        /// </summary>
        public int MinimumTermFrequency { get; set; }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Specialized;
using System.Configuration;
using System.IO;

namespace Subtext.Framework.Configuration
{
    public class MimeTypesMapper
    {
        public static readonly MimeTypesMapper Mappings =
            new MimeTypesMapper((NameValueCollection)ConfigurationManager.GetSection("EnclosureMimetypes"));

        public MimeTypesMapper(NameValueCollection config)
        {
            if(config == null)
            {
                throw new ArgumentNullException("config");
            }
            List = config;
            Count = config.Keys.Count;
        }

        public int Count { get; private set; }

        public NameValueCollection List { get; private set; }

        /// <summary>
        /// Returns the mimetype that corresponds to a file extension.
        /// </summary>
        /// <param name="ext">Extension of a file.</param>
        /// <returns>The MimeType</returns>
        public string GetMimeType(string ext)
        {
            if(ext == null)
            {
                throw new ArgumentNullException("ext");
            }
            if(List[ext] != null)
            {
                return List[ext];
            }
            return null;
        }

        /// <summary>
        /// Detect the mimetype of the url of a file.
        /// </summary>
        /// <param name="url">Url of the file</param>
        /// <returns>The MimeType.</returns>
        public string ParseUrl(string url)
        {
            if(url == null)
            {
                throw new ArgumentNullException("url");
            }
            Uri uri;

            if(!Uri.TryCreate(url, UriKind.Absolute, out uri))
            {
                throw new ArgumentException("Url not valid.", "url");
            }

            string path = uri.GetComponents(UriComponents.Path, UriFormat.SafeUnescaped);

            string ext = Path.GetExtension(path);

            return GetMimeType(ext);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web;
using Subtext.Framework.Services;

namespace Subtext.Framework.Configuration
{
    /// <summary>
    /// Summary description for SkinConfig.
    /// </summary>
    [Serializable]
    public class SkinConfig
    {
        public static readonly SkinConfig DefaultSkin = CreateDefaultSkin();

        /// <summary>
        /// This is the skin template folder. Note that multiple "Skins" can 
        /// share the same template folder. The template folder contains the 
        /// *.ascx files for the skins.
        /// </summary>
        public string TemplateFolder { get; set; }

        /// <summary>
        /// Gets or sets the skin's primary CSS file, if any.  
        /// Some Skins have multiple flavors based on different CSS files.  
        /// For example, Redbook, Bluebook, and Greenbook are all variations 
        /// of the skin Redbook.  They vary by the skin css file.
        /// </summary>
        /// <value>The skin CSS file.</value>
        public string SkinStyleSheet { get; set; }

        /// <summary>
        /// This is CSS text that is entered within the admin section.
        /// </summary>
        public string CustomCssText { get; set; }

        /// <summary>
        /// Returns true if the skin has a skin specific css file 
        /// that is applied after style.css (there is one style.css 
        /// per template folder).
        /// </summary>
        public bool HasStyleSheet
        {
            get { return SkinStyleSheet != null && SkinStyleSheet.Trim().Length > 0; }
        }

        /// <summary>
        /// Returns true if the user specified some custom CSS in the admin section.
        /// </summary>
        public bool HasCustomCssText
        {
            get { return CustomCssText != null && CustomCssText.Trim().Length > 0; }
        }

        /// <summary>
        /// A lookup key for a skin.
        /// </summary>
        public string SkinKey
        {
            get
            {
                if(HasStyleSheet)
                {
                    return string.Format("{0}-{1}", TemplateFolder, SkinStyleSheet);
                }
                return TemplateFolder;
            }
        }

        /// <summary>
        /// Creates the default skin to be used if none is specified.
        /// </summary>
        /// <returns></returns>
        static SkinConfig CreateDefaultSkin()
        {
            var defaultSkin = new SkinConfig {TemplateFolder = "RedBook", SkinStyleSheet = "Blue.css"};
            return defaultSkin;
        }

        /// <summary>
        /// Returns the current skin for the current context.
        /// </summary>
        /// <returns></returns>
        public static SkinConfig GetCurrentSkin(Blog blog, HttpContextBase context)
        {
            var service = new BrowserDetectionService();
            BrowserInfo capabilities = service.DetectBrowserCapabilities(context.Request);

            bool isMobile = capabilities.Mobile;

            SkinConfig skin;
            if(isMobile)
            {
                skin = blog.MobileSkin;
                if(skin.TemplateFolder != null)
                {
                    return skin;
                }
            }

            skin = blog.Skin;

            if(skin.TemplateFolder == null)
            {
                skin = DefaultSkin;
            }
            return skin;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Xml.Serialization;

namespace Subtext.Framework.Configuration
{
    /// <summary>
    /// Class used to manage the settings for various tracking systems 
    /// such as TrackBacks, PingBacks and Weblogs Pings.
    /// </summary>
    [Serializable]
    public class Tracking
    {
        public Tracking()
        {
            QueueStatsCount = 25;
            QueueStats = true;
        }

        /// <summary>
        /// Gets a value indicating whether tracking services 
        /// are being used such as Weblogs Ping, Pingbacks, and Trackbacks.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if using tracking services; otherwise, <c>false</c>.
        /// </value>
        public bool UseTrackingServices
        {
            get { return PingWeblogs || EnablePingBacks || EnableTrackBacks; }
        }

        /// <summary>
        /// Gets or sets the queue stats count. This is the number of 
        /// tracking operations that are currently in the queue.
        /// </summary>
        /// <value></value>
        [XmlAttribute("queueStatsCount")]
        public int QueueStatsCount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether or not to queue stats. 
        /// This simply indicates whether trackbacks and pings are queued 
        /// to occur asynchronously or immediately.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if queueing stats asynchronously; otherwise, <c>false</c>.
        /// </value>
        [XmlAttribute("queueStats")]
        public bool QueueStats { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether trackbaks are enabled.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if track backs are enabled; otherwise, <c>false</c>.
        /// </value>
        [XmlAttribute("enableTrackBacks")]
        public bool EnableTrackBacks { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether ping backs are enabled.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if ping backs are enabled; otherwise, <c>false</c>.
        /// </value>
        [XmlAttribute("enablePingBacks")]
        public bool EnablePingBacks { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to ping weblogs.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if weblogs are pinged; otherwise, <c>false</c>.
        /// </value>
        [XmlAttribute("pingWeblogs")]
        public bool PingWeblogs { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to enable web stats in general.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if web stats are enabled; otherwise, <c>false</c>.
        /// </value>
        [XmlAttribute("enableWebStats")]
        public bool EnableWebStats { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether aggregator bugs are enabled. 
        /// These are 1pixel images used to track the number of users who 
        /// read a particular entry in an aggregator.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if agg bugs are enabled; otherwise, <c>false</c>.
        /// </value>
        [XmlAttribute("enableAggBugs")]
        public bool EnableAggBugs { get; set; }
    }
}using System.Collections.Generic;
using System.Data;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Configuration;
using Subtext.Framework.Text;

namespace Subtext.Framework.Data
{
    public partial class DatabaseObjectProvider
    {
        /// <summary>
        /// Gets the blog by id.
        /// </summary>
        /// <param name="blogId">Blog id.</param>
        /// <returns></returns>
        public override Blog GetBlogById(int blogId)
        {
            using(IDataReader reader = _procedures.GetBlogById(blogId))
            {
                if(reader.Read())
                {
                    Blog info = reader.ReadBlog();
                    return info;
                }
            }
            return null;
        }

        /// <summary>
        /// Returns a <see cref="Blog"/> instance containing 
        /// the configuration settings for the blog specified by the 
        /// Hostname and Application.
        /// </summary>
        /// <remarks>
        /// Until Subtext supports multiple blogs again (if ever), 
        /// this will always return the same instance.
        /// </remarks>
        /// <param name="hostname">Hostname.</param>
        /// <param name="subfolder">Subfolder.</param>
        /// <returns></returns>
        public override Blog GetBlog(string hostname, string subfolder)
        {
            using(IDataReader reader = _procedures.GetConfig(hostname, subfolder ?? string.Empty))
            {
                Blog info = null;
                while(reader.Read())
                {
                    info = reader.ReadBlog();
                    break;
                }
                return info;
            }
        }

        public override BlogAlias GetBlogAliasById(int aliasId)
        {
            BlogAlias alias = null;
            using(IDataReader reader = _procedures.GetDomainAliasById(aliasId))
            {
                if(reader.Read())
                {
                    alias = reader.ReadObject<BlogAlias>();
                }
                reader.Close();
            }
            return alias;
        }

        public override Blog GetBlogByDomainAlias(string host, string subfolder, bool strict)
        {
            using(IDataReader reader = _procedures.GetBlogByDomainAlias(host, subfolder, strict))
            {
                if(reader.Read())
                {
                    return reader.ReadBlog();
                }
            }
            return null;
        }

        public override BlogStatistics GetBlogStatistics(int blogId)
        {
            BlogStatistics stats = null;
            using(IDataReader reader = _procedures.GetBlogStats(blogId))
            {
                if(reader.Read())
                {
                    stats = reader.ReadObject<BlogStatistics>();
                }
            }
            return stats;
        }

        /// <summary>
        /// Gets a pageable Collection of <see cref="Blog"/> instances.
        /// </summary>
        /// <param name="host">The host filter. Set to null to return all blogs.</param>
        /// <param name="pageIndex">Page index.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <returns></returns>
        /// <param name="flags"></param>
        public override IPagedCollection<Blog> GetPagedBlogs(string host, int pageIndex, int pageSize, ConfigurationFlags flags)
        {
            using(IDataReader reader = _procedures.GetPagedBlogs(host, pageIndex, pageSize, flags))
            {
                return reader.ReadPagedCollection(r => r.ReadBlog());
            }
        }

        public override IPagedCollection<BlogAlias> GetPagedBlogDomainAlias(Blog blog, int pageIndex, int pageSize)
        {
            using(IDataReader reader = _procedures.GetPageableDomainAliases(pageIndex, pageSize, blog.Id))
            {
                return reader.ReadPagedCollection(r => r.ReadObject<BlogAlias>());
            }
        }

        /// <summary>
        /// Adds the initial blog configuration.  This is a convenience method for 
        /// allowing a user with a freshly installed blog to immediately gain access 
        /// to the admin section to edit the blog.
        /// </summary>
        /// <param name="title"></param>
        /// <param name="host"></param>
        /// <param name="subfolder"></param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">Password.</param>
        /// <returns></returns>
        public override int CreateBlog(string title, string userName, string password, string host, string subfolder)
        {
            return CreateBlog(title, userName, password, host, subfolder, 1 /* blogGroupId */);
        }

        /// <summary>
        /// Adds the initial blog configuration.  This is a convenience method for
        /// allowing a user with a freshly installed blog to immediately gain access
        /// to the admin section to edit the blog.
        /// </summary>
        /// <param name="title"></param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">Password.</param>
        /// <param name="host"></param>
        /// <param name="subfolder"></param>
        /// <param name="blogGroupId"></param>
        /// <returns></returns>
        public override int CreateBlog(string title, string userName, string password, string host, string subfolder, int blogGroupId)
        {
            const ConfigurationFlags flag = ConfigurationFlags.IsActive
                                            | ConfigurationFlags.CommentsEnabled
                                            | ConfigurationFlags.CompressSyndicatedFeed
                                            | ConfigurationFlags.IsAggregated
                                            | ConfigurationFlags.IsPasswordHashed
                                            | ConfigurationFlags.AutoFriendlyUrlEnabled
                                            | ConfigurationFlags.CommentNotificationEnabled
                                            | ConfigurationFlags.RFC3229DeltaEncodingEnabled
                                            | ConfigurationFlags.CaptchaEnabled;

            return _procedures.UTILITYAddBlog(title, userName, password, string.Empty, host, subfolder ?? string.Empty, (int)flag, blogGroupId);
        }

        public override bool UpdateBlog(Blog info)
        {
            int? daysTillCommentsClose = null;
            if(info.DaysTillCommentsClose > -1 && info.DaysTillCommentsClose < int.MaxValue)
            {
                daysTillCommentsClose = info.DaysTillCommentsClose;
            }

            int? commentDelayInMinutes = null;
            if(info.CommentDelayInMinutes > 0 && info.CommentDelayInMinutes < int.MaxValue)
            {
                commentDelayInMinutes = info.CommentDelayInMinutes;
            }

            int? numberOfRecentComments = null;
            if(info.NumberOfRecentComments > 0 && info.NumberOfRecentComments < int.MaxValue)
            {
                numberOfRecentComments = info.NumberOfRecentComments;
            }

            int? recentCommentsLength = null;
            if(info.RecentCommentsLength > 0 && info.RecentCommentsLength < int.MaxValue)
            {
                recentCommentsLength = info.RecentCommentsLength;
            }

            return _procedures.UpdateConfig(info.UserName,
                info.Password,
                info.Email,
                info.Title,
                info.SubTitle,
                info.Skin.TemplateFolder,
                info.Subfolder,
                info.Host,
                info.Author,
                info.Language,
                info.TimeZoneId,
                info.ItemCount,
                info.CategoryListPostCount,
                info.News.NullIfEmpty(),
                info.TrackingCode.NullIfEmpty(),
                info.LastUpdated /*null*/,
                info.Skin.CustomCssText.NullIfEmpty(),
                info.Skin.SkinStyleSheet.NullIfEmpty(),
                (int)info.Flag,
                info.Id,
                info.LicenseUrl,
                daysTillCommentsClose,
                commentDelayInMinutes,
                numberOfRecentComments,
                recentCommentsLength,
                info.FeedbackSpamServiceKey.NullIfEmpty(),
                info.RssProxyUrl.NullIfEmpty(),
                info.BlogGroupId,
                info.MobileSkin.TemplateFolder.NullIfEmpty(),
                info.MobileSkin.SkinStyleSheet.NullIfEmpty(),
                info.OpenIdUrl,
                info.CardSpaceHash,
                info.OpenIdServer,
                info.OpenIdDelegate);
        }

        public override bool CreateBlogAlias(BlogAlias alias)
        {
            int aliasId = _procedures.CreateDomainAlias(alias.BlogId, alias.Host, alias.Subfolder, alias.IsActive);
            alias.Id = aliasId;
            return true;
        }

        public override bool UpdateBlogAlias(BlogAlias alias)
        {
            return _procedures.UpdateDomainAlias(alias.Id, alias.BlogId, alias.Host, alias.Subfolder, alias.IsActive);
        }

        public override bool DeleteBlogAlias(BlogAlias alias)
        {
            return _procedures.DeleteDomainAlias(alias.Id);
        }

        /// <summary>
        /// Gets the blog group.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public override BlogGroup GetBlogGroup(int id, bool activeOnly)
        {
            BlogGroup group;
            using(IDataReader reader = _procedures.GetBlogGroup(id, activeOnly))
            {
                if(!reader.Read())
                    return null;

                group = reader.ReadObject<BlogGroup>();
            }

            if(group != null)
            {
                //TODO: Make this more efficient.
                IPagedCollection<Blog> blogs =
                    Blog.GetBlogs(0, int.MaxValue, activeOnly ? ConfigurationFlags.IsActive : ConfigurationFlags.None);
                group.Blogs = new List<Blog>();
                foreach(Blog blog in blogs)
                {
                    if(blog.BlogGroupId == group.Id)
                        group.Blogs.Add(blog);
                }
            }
            return group;
        }

        /// <summary>
        /// Lists the blog groups.
        /// </summary>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public override ICollection<BlogGroup> ListBlogGroups(bool activeOnly)
        {
            using(IDataReader reader = _procedures.ListBlogGroups(activeOnly))
            {
                return reader.ReadCollection<BlogGroup>();
            }
        }

        public override ICollection<EntrySummary> GetTopEntrySummaries(int blogId, int rowCount)
        {
            using(IDataReader reader = _procedures.GetTopEntries(blogId, rowCount))
            {
                return reader.ReadCollection<EntrySummary>();
            }
        }

        public override ICollection<EntrySummary> GetRelatedEntries(int blogId, int entryId, int rowCount)
        {
            using(IDataReader reader = _procedures.GetRelatedEntries(blogId, entryId, rowCount))
            {
                return reader.ReadCollection<EntrySummary>();
            }
        }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Globalization;
using System.Web;
using System.Web.Caching;
using Subtext.Configuration;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Routing;
using Subtext.Framework.Text;
using Subtext.Framework.Util;
using Subtext.Infrastructure;
using Subtext.Framework.Web;
using Subtext.Extensibility;

namespace Subtext.Framework.Data
{
    //TODO: Refactor. Static classes like this are a pain!
    /// <summary>
    /// Encapsulates obtaining content from the cache.
    /// </summary>
    public static class Cacher
    {
        private const string EntriesByCategoryKey = "EC:Count{0}Category{1}BlogId{2}";
        private const string EntryKeyId = "Entry{0}BlogId{1}";
        private const string EntryKeyName = "EntryName{0}BlogId{1}";
        public const int LongDuration = 600;
        public const int MediumDuration = 20;
        public const int ShortDuration = 10;
        private const string EntryDayKey = "EntryDay:Date{0:yyyyMMdd}Blog{1}";
        private const string EntryMonthKey = "EntryMonth:Date{0:yyyyMM}Blog{1}";
        private const string EntriesByTagKey = "ET:Count{0}Tag{1}BlogId{2}";
        private const string CategoryKey = "LC{0}BlogId{1}";
        private const string ParentCommentEntryKey = "ParentEntry:Comments:EntryId{0}:BlogId{1}";
        private const string TagsKey = "TagsCount{0}BlogId{1}";

        public static T GetOrInsert<T>(this ICache cache, string key, Func<T> retrievalFunction, int duration, CacheDependency cacheDependency)
        {
            var item = cache[key];
            if(item == null)
            {
                item = retrievalFunction();
                if(item != null)
                {
                    cache.InsertDuration(key, item, duration, cacheDependency);
                }
            }
            return (T)item;
        }

        public static T GetOrInsertSliding<T>(this ICache cache, string key, Func<T> retrievalFunction, CacheDependency cacheDependency, int slidingDuration)
        {
            var item = cache[key];
            if(item == null)
            {
                item = retrievalFunction();
                if(item != null)
                {
                    cache.InsertDurationSliding(key, item, cacheDependency, slidingDuration);
                }
            }
            return (T)item;
        }

        public static T GetOrInsert<T>(this ICache cache, string key, Func<T> retrievalFunction, int duration)
        {
            return cache.GetOrInsert(key, retrievalFunction, duration, null);
        }
        
        public static T GetOrInsert<T>(this ICache cache, string key, Func<T> retrievalFunction)
        {
            return cache.GetOrInsert(key, retrievalFunction, ShortDuration, null);
        }

        /// <summary>
        /// Gets the entries for the specified month.
        /// </summary>
        public static ICollection<Entry> GetEntriesForMonth(DateTime dateTime, ISubtextContext context)
        {
            string key = string.Format(CultureInfo.InvariantCulture, EntryMonthKey, dateTime, context.Blog.Id);
            return context.Cache.GetOrInsert(key, () => context.Repository.GetPostsByMonth(dateTime.Month, dateTime.Year), LongDuration);
        }

        public static EntryDay GetEntriesForDay(DateTime day, ISubtextContext context)
        {
            string key = string.Format(CultureInfo.InvariantCulture, EntryDayKey, day, context.Blog.Id);
            return context.Cache.GetOrInsert(key, () => context.Repository.GetEntryDay(day), LongDuration);
        }

        public static ICollection<Entry> GetEntriesByCategory(int count, int categoryId, ISubtextContext context)
        {
            string key = string.Format(EntriesByCategoryKey, count, categoryId, context.Blog.Id);
            return context.Cache.GetOrInsert(key, () => context.Repository.GetEntriesByCategory(count, categoryId, true /* activeOnly */));
        }

        public static ICollection<Entry> GetEntriesByTag(int count, string tag, ISubtextContext context)
        {
            string key = string.Format(EntriesByTagKey, count, tag, context.Blog.Id);
            return context.Cache.GetOrInsert(key, () => context.Repository.GetEntriesByTag(count, tag));
        }

        /// <summary>
        /// Returns a LinkCategory for a single category based on the request url.
        /// </summary>
        public static LinkCategory SingleCategory(ISubtextContext context)
        {
            if(context == null)
            {
                throw new ArgumentNullException("context");
            }

            string categorySlug = context.RequestContext.GetSlugFromRequest();
            if(categorySlug.IsNumeric())
            {
                int categoryId = Int32.Parse(categorySlug, CultureInfo.InvariantCulture);
                return SingleCategory(categoryId, true, context);
            }
            return SingleCategory(categorySlug, true, context);
        }

        public static LinkCategory SingleCategory(int categoryId, bool isActive, ISubtextContext context)
        {
            return SingleCategory(() => context.Repository.GetLinkCategory(categoryId, isActive), categoryId, context);
        }

        public static LinkCategory SingleCategory(string categoryName, bool isActive, ISubtextContext context)
        {
            string singleCategoryName = categoryName;
            LinkCategory category = SingleCategory(() => context.Repository.GetLinkCategory(singleCategoryName, isActive),
                                                   categoryName, context);
            if(category != null)
            {
                return category;
            }

            if(context.Blog.AutoFriendlyUrlEnabled)
            {
                string theCategoryName = categoryName;
                categoryName = categoryName.Replace(FriendlyUrlSettings.Settings.SeparatingCharacter, " ");
                return SingleCategory(() => context.Repository.GetLinkCategory(theCategoryName, isActive), categoryName,
                                      context);
            }

            return null; //couldn't find category
        }

        private static LinkCategory SingleCategory<T>(Func<LinkCategory> retrievalDelegate, T categoryKey,
                                                      ISubtextContext context)
        {
            string key = string.Format(CultureInfo.InvariantCulture, CategoryKey, categoryKey, context.Blog.Id);
            return context.Cache.GetOrInsert(key, retrievalDelegate);
        }

        public static ICollection<EntrySummary> GetPreviousNextEntry(int entryId, PostType postType, ISubtextContext context)
        {
            string cacheKey = string.Format("PrevNext:{0}:{1}", entryId, postType);
            return context.Cache.GetOrInsertSliding(cacheKey, () => context.Repository.GetPreviousAndNextEntries(entryId, postType), null, LongDuration);
        }

        //TODO: This should only be called in one place total. And it needs to be tested.
        public static Entry GetEntryFromRequest(bool allowRedirectToEntryName, ISubtextContext context)
        {
            string slug = context.RequestContext.GetSlugFromRequest();
            if(!String.IsNullOrEmpty(slug))
            {
                return GetEntry(slug, context);
            }

            int? id = context.RequestContext.GetIdFromRequest();
            if(id != null)
            {
                Entry entry = GetEntry(id.Value, context);
                if(entry == null)
                {
                    return null;
                }

                //TODO: Violation of SRP here!
                //Second condition avoids infinite redirect loop. Should never happen.
                if(allowRedirectToEntryName && entry.HasEntryName && !entry.EntryName.IsNumeric())
                {
                    HttpResponseBase response = context.HttpContext.Response;
                    response.RedirectPermanent(context.UrlHelper.EntryUrl(entry).ToFullyQualifiedUrl(context.Blog).ToString());
                }
                return entry;
            }

            return null;
        }

        /// <summary>
        /// Retrieves a single entry from the cache by the entry name.  
        /// If it is not in the cache, gets it from the database and 
        /// inserts it into the cache.
        /// </summary>
        public static Entry GetEntry(string entryName, ISubtextContext context)
        {
            Blog blog = context.Blog;
            string key = string.Format(CultureInfo.InvariantCulture, EntryKeyName, entryName, blog.Id);

            Func<Entry> retrieval = () => context.Repository.GetEntry(entryName, true /* activeOnly */, true /* includeCategories */);
            var cachedEntry = context.Cache.GetOrInsert(key, retrieval, MediumDuration);
            if(cachedEntry == null)
            {
                return null;
            }
            cachedEntry.Blog = blog;
            return cachedEntry.DateSyndicated > blog.TimeZone.Now ? null : cachedEntry;
        }

        /// <summary>
        /// Retrieves a single entry from the cache by the id.
        /// If it is not in the cache, gets it from the database and
        /// inserts it into the cache.
        /// </summary>
        public static Entry GetEntry(int entryId, ISubtextContext context)
        {
            string key = string.Format(CultureInfo.InvariantCulture, EntryKeyId, entryId, context.Blog.Id);
            var entry = context.Cache.GetOrInsert(key, () => context.Repository.GetEntry(entryId, true /* activeOnly */, true /* includeCategories */));
            if(entry == null)
            {
                return null;
            }
            entry.Blog = context.Blog;
            return entry;
        }

        /// <summary>
        /// Retrieves the current tags from the cache based on the ItemCount and
        /// Blog Id. If it is not in the cache, it gets it from the database and 
        /// inserts it into the cache.
        /// </summary>
        public static IEnumerable<Tag> GetTopTags(int itemCount, ISubtextContext context)
        {
            string key = string.Format(CultureInfo.InvariantCulture, TagsKey, itemCount, context.Blog.Id);
            return context.Cache.GetOrInsert(key, () => context.Repository.GetMostUsedTags(itemCount), LongDuration);
        }

        /// <summary>
        /// Clears the comment cache.
        /// </summary>
        public static void ClearCommentCache(int entryId, ISubtextContext context)
        {
            string key = string.Format(CultureInfo.InvariantCulture, ParentCommentEntryKey, entryId, context.Blog.Id);
            context.Cache.Remove(key);
        }

        /// <summary>
        /// Returns all the feedback for the specified entry. Checks the cache first.
        /// </summary>
        public static ICollection<FeedbackItem> GetFeedback(Entry parentEntry, ISubtextContext context)
        {
            string key = GetFeedbackCacheKey(parentEntry, context);
            return context.Cache.GetOrInsertSliding(key, () => context.Repository.GetFeedbackForEntry(parentEntry), null, LongDuration);
        }

        private static string GetFeedbackCacheKey(IIdentifiable parentEntry, ISubtextContext context)
        {
            return string.Format(CultureInfo.InvariantCulture, ParentCommentEntryKey, parentEntry.Id, context.Blog.Id);
        }

        public static void InvalidateFeedback(IIdentifiable parentEntry, ISubtextContext context)
        {
            string key = GetFeedbackCacheKey(parentEntry, context);
            context.Cache.Remove(key);
        }

        public static void InsertDuration(this ICache cache, string key, object value, int duration, CacheDependency cacheDependency)
        {
            cache.Insert(key, value, cacheDependency, DateTime.Now.AddSeconds(duration), TimeSpan.Zero, CacheItemPriority.Normal, null);
        }

        public static void InsertDurationSliding(this ICache cache, string key, object value, CacheDependency cacheDependency, int slidingExpiration)
        {
            cache.Insert(key, value, cacheDependency, DateTime.MaxValue, TimeSpan.FromSeconds(slidingExpiration), CacheItemPriority.Normal, null);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Data;
using System.Data.SqlClient;

namespace Subtext.Framework.Data
{
    public partial class StoredProcedures
    {
        public IDataReader GetRecentImages(string host, int? groupId, int rowCount)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@GroupID", groupId),
                                   DataHelper.MakeInParam("@rowCount", rowCount),
                               };

            return GetReader("DNW_GetRecentImages", p);
        }

        public IDataReader GetRecentPosts(string host, int? groupId, DateTime currentDateTime, int? rowCount)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@GroupID", groupId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                                   DataHelper.MakeInParam("@RowCount", rowCount),
                               };

            return GetReader("DNW_GetRecentPosts", p);
        }

        public IDataReader Stats(string host, int? groupId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@GroupID", groupId),
                               };

            return GetReader("DNW_Stats", p);
        }

        public IDataReader TotalStats(string host, int? groupId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@GroupID", groupId),
                               };

            return GetReader("DNW_Total_Stats", p);
        }

        public bool AddLogEntry(DateTime date, int? blogId, string thread, string context, string level, string logger,
                                string message, string exception, string url)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Date", date),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@Thread", thread),
                                   DataHelper.MakeInParam("@Context", context),
                                   DataHelper.MakeInParam("@Level", level),
                                   DataHelper.MakeInParam("@Logger", logger),
                                   DataHelper.MakeInParam("@Message", message),
                                   DataHelper.MakeInParam("@Exception", exception),
                                   DataHelper.MakeInParam("@Url", url),
                               };


            return NonQueryBool("subtext_AddLogEntry", p);
        }

        public bool ClearBlogContent(int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_ClearBlogContent", p);
        }

        public int CreateDomainAlias(int blogId, string host, string application, bool? active)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@Id", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@Application", application),
                                   DataHelper.MakeInParam("@Active", active),
                                   outParam0,
                               };

            NonQueryInt("subtext_CreateDomainAlias", p);
            return (int)outParam0.Value;
        }

        public bool DeleteBlogGroup(int id)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                               };


            return NonQueryBool("subtext_DeleteBlogGroup", p);
        }

        public bool DeleteCategory(int categoryId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_DeleteCategory", p);
        }

        public bool DeleteDomainAlias(int id)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                               };


            return NonQueryBool("subtext_DeleteDomainAlias", p);
        }

        public bool DeleteEnclosure(int id)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                               };


            return NonQueryBool("subtext_DeleteEnclosure", p);
        }

        public bool DeleteFeedback(int id, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };


            return NonQueryBool("subtext_DeleteFeedback", p);
        }

        public bool DeleteFeedbackByStatus(int blogId, int statusFlag)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@StatusFlag", statusFlag),
                               };


            return NonQueryBool("subtext_DeleteFeedbackByStatus", p);
        }

        public bool DeleteImage(int blogId, int imageId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@ImageId", imageId),
                               };


            return NonQueryBool("subtext_DeleteImage", p);
        }

        public bool DeleteImageCategory(int categoryId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_DeleteImageCategory", p);
        }

        public bool DeleteKeyWord(int keyWordId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@KeyWordID", keyWordId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_DeleteKeyWord", p);
        }

        public bool DeleteLink(int linkId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@LinkID", linkId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_DeleteLink", p);
        }

        public bool DeleteLinksByPostID(int postId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@PostId", postId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_DeleteLinksByPostID", p);
        }

        public bool DeleteMetaTag(int id)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                               };


            return NonQueryBool("subtext_DeleteMetaTag", p);
        }

        public bool DeletePost(int id, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ID", id),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };


            return NonQueryBool("subtext_DeletePost", p);
        }

        public IDataReader GetActiveCategoriesWithLinkCollection(int? blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetActiveCategoriesWithLinkCollection", p);
        }

        public IDataReader GetBlogByDomainAlias(string host, string application, bool? strict)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@Application", application),
                                   DataHelper.MakeInParam("@Strict", strict),
                               };

            return GetReader("subtext_GetBlogByDomainAlias", p);
        }

        public IDataReader GetBlogById(int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetBlogById", p);
        }

        public IDataReader GetBlogGroup(int id, bool active)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                                   DataHelper.MakeInParam("@Active", active),
                               };

            return GetReader("subtext_GetBlogGroup", p);
        }

        public IDataReader GetBlogKeyWords(int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetBlogKeyWords", p);
        }

        public IDataReader GetBlogStats(int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetBlogStats", p);
        }

        public IDataReader GetCategory(string categoryName, int? categoryId, bool isActive, int? blogId,
                                       int? categoryType)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@CategoryName", categoryName),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@IsActive", isActive),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CategoryType", categoryType),
                               };

            return GetReader("subtext_GetCategory", p);
        }

        public IDataReader GetCommentByChecksumHash(string feedbackChecksumHash, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@FeedbackChecksumHash", feedbackChecksumHash),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetCommentByChecksumHash", p);
        }

        public IDataReader GetConditionalEntries(int itemCount, int postType, int postConfig, int? blogId,
                                                 bool includeCategories, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ItemCount", itemCount),
                                   DataHelper.MakeInParam("@PostType", postType),
                                   DataHelper.MakeInParam("@PostConfig", postConfig),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@IncludeCategories", includeCategories),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_GetConditionalEntries", p);
        }

        public IDataReader GetConfig(string host, string application)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@Application", application),
                               };

            return GetReader("subtext_GetConfig", p);
        }

        public IDataReader GetDomainAliasById(int id)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                               };

            return GetReader("subtext_GetDomainAliasById", p);
        }

        public IDataReader GetEntriesByDayRange(DateTime startDate, DateTime stopDate, int postType, bool isActive,
                                                int blogId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@StartDate", startDate),
                                   DataHelper.MakeInParam("@StopDate", stopDate),
                                   DataHelper.MakeInParam("@PostType", postType),
                                   DataHelper.MakeInParam("@IsActive", isActive),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_GetEntriesByDayRange", p);
        }

        public IDataReader GetEntriesForExport(int blogId, int pageIndex, int pageSize)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                               };

            return GetReader("subtext_GetEntriesForExport", p);
        }

        public IDataReader GetEntryPreviousNext(int id, int postType, int blogId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ID", id),
                                   DataHelper.MakeInParam("@PostType", postType),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_GetEntry_PreviousNext", p);
        }

        public IDataReader GetFeedback(int id)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                               };

            return GetReader("subtext_GetFeedback", p);
        }

        public IDataReader GetFeedbackCollection(int entryId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@EntryId", entryId),
                               };

            return GetReader("subtext_GetFeedbackCollection", p);
        }

        public void GetFeedbackCountsByStatus(int blogId, out int approvedCount, out int needsModerationCount,
                                              out int flaggedSpam, out int deleted)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@ApprovedCount", SqlDbType.Int, 4);
            SqlParameter outParam1 = DataHelper.MakeOutParam("@NeedsModerationCount", SqlDbType.Int, 4);
            SqlParameter outParam2 = DataHelper.MakeOutParam("@FlaggedSpam", SqlDbType.Int, 4);
            SqlParameter outParam3 = DataHelper.MakeOutParam("@Deleted", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   outParam0,
                                   outParam1,
                                   outParam2,
                                   outParam3,
                               };

            NonQueryBool("subtext_GetFeedbackCountsByStatus", p);
            approvedCount = (int)outParam0.Value;
            needsModerationCount = (int)outParam1.Value;
            flaggedSpam = (int)outParam2.Value;
            deleted = (int)outParam3.Value;
        }

        public IDataReader GetHost()
        {
            return GetReader("subtext_GetHost");
        }

        public IDataReader GetImageCategory(int categoryId, bool isActive, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@IsActive", isActive),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetImageCategory", p);
        }

        public IDataReader GetKeyWord(int keyWordId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@KeyWordID", keyWordId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetKeyWord", p);
        }

        public IDataReader GetLinkCollectionByPostID(int? postId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@PostId", postId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetLinkCollectionByPostID", p);
        }

        public IDataReader GetLinksByCategoryID(int categoryId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetLinksByCategoryID", p);
        }

        public IDataReader GetMetaTags(int blogId, int? entryId, int pageIndex, int pageSize)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                               };

            return GetReader("subtext_GetMetaTags", p);
        }

        public IDataReader GetPageableBlogs(int pageIndex, int pageSize, string host, int configurationFlags)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@ConfigurationFlags", configurationFlags),
                               };

            return GetReader("subtext_GetPageableBlogs", p);
        }

        public IDataReader GetPageableDomainAliases(int pageIndex, int pageSize, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetPageableDomainAliases", p);
        }
      
        public IDataReader GetEntries(int blogId, int? categoryId, int pageIndex, int pageSize,
                                                          int postType)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                                   DataHelper.MakeInParam("@PostType", postType),
                               };

            return GetReader("subtext_GetEntries", p);
        }

        public IDataReader GetPageableFeedback(int blogId, int pageIndex, int pageSize, int statusFlag,
                                               int? excludeFeedbackStatusMask, int? feedbackType)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                                   DataHelper.MakeInParam("@StatusFlag", statusFlag),
                                   DataHelper.MakeInParam("@ExcludeFeedbackStatusMask", excludeFeedbackStatusMask),
                                   DataHelper.MakeInParam("@FeedbackType", feedbackType),
                               };

            return GetReader("subtext_GetPageableFeedback", p);
        }

        public IDataReader GetPageableKeyWords(int blogId, int pageIndex, int pageSize)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                               };

            return GetReader("subtext_GetPageableKeyWords", p);
        }

        public IDataReader GetPageableLinks(int blogId, int? categoryId, int pageIndex, int pageSize)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                               };

            return GetReader("subtext_GetPageableLinks", p);
        }

        public bool GetPageableLinksByCategoryID(int blogId, int? categoryId, int pageIndex, int pageSize, bool sortDesc)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                                   DataHelper.MakeInParam("@SortDesc", sortDesc),
                               };


            return NonQueryBool("subtext_GetPageableLinksByCategoryID", p);
        }

        public IDataReader GetPageableLogEntries(int? blogId, int pageIndex, int pageSize)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                               };

            return GetReader("subtext_GetPageableLogEntries", p);
        }

        public IDataReader GetPageableReferrers(int blogId, int? entryId, int pageIndex, int pageSize)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@PageIndex", pageIndex),
                                   DataHelper.MakeInParam("@PageSize", pageSize),
                               };

            return GetReader("subtext_GetPageableReferrers", p);
        }

        public IDataReader GetPopularPosts(int blogId, DateTime? minDate)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@MinDate", minDate),
                               };

            return GetReader("subtext_GetPopularPosts", p);
        }

        public IDataReader GetPostsByCategoriesArchive(int? blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetPostsByCategoriesArchive", p);
        }

        public IDataReader GetPostsByCategoryID(int itemCount, int categoryId, bool isActive, int blogId,
                                                DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ItemCount", itemCount),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@IsActive", isActive),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_GetPostsByCategoryID", p);
        }

        public IDataReader GetPostsByDayRange(DateTime startDate, DateTime stopDate, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@StartDate", startDate),
                                   DataHelper.MakeInParam("@StopDate", stopDate),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetPostsByDayRange", p);
        }

        public IDataReader GetPostsByMonth(int month, int year, int? blogId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Month", month),
                                   DataHelper.MakeInParam("@Year", year),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_GetPostsByMonth", p);
        }

        public IDataReader GetPostsByMonthArchive(int? blogId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_GetPostsByMonthArchive", p);
        }

        public IDataReader GetPostsByTag(int itemCount, string tag, int blogId, bool? isActive, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ItemCount", itemCount),
                                   DataHelper.MakeInParam("@Tag", tag),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@IsActive", isActive),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_GetPostsByTag", p);
        }

        public IDataReader GetPostsByYearArchive(int blogId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_GetPostsByYearArchive", p);
        }

        public IDataReader GetRelatedEntries(int blogId, int entryId, int rowCount)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@RowCount", rowCount),
                               };

            return GetReader("subtext_GetRelatedEntries", p);
        }
      
        public IDataReader GetSingleEntry(int? id, string entryName, bool isActive, int? blogId, bool includeCategories)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ID", id),
                                   DataHelper.MakeInParam("@EntryName", entryName),
                                   DataHelper.MakeInParam("@IsActive", isActive),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@IncludeCategories", includeCategories),
                               };

            return GetReader("subtext_GetSingleEntry", p);
        }

        public IDataReader GetSingleImage(int imageId, bool isActive, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ImageId", imageId),
                                   DataHelper.MakeInParam("@IsActive", isActive),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetSingleImage", p);
        }

        public IDataReader GetSingleLink(int linkId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@LinkID", linkId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetSingleLink", p);
        }

        public IDataReader GetTopEntries(int blogId, int rowCount)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@RowCount", rowCount),
                               };

            return GetReader("subtext_GetTopEntries", p);
        }

        public IDataReader GetTopTags(int itemCount, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ItemCount", itemCount),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_GetTopTags", p);
        }

        public int GetUrlID(string url)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@UrlID", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Url", url),
                                   outParam0,
                               };

            NonQueryInt("subtext_GetUrlID", p);
            return (int)outParam0.Value;
        }

        public int InsertBlogGroup(string title, bool active, int? displayOrder, string description)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@Id", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Active", active),
                                   DataHelper.MakeInParam("@DisplayOrder", displayOrder),
                                   DataHelper.MakeInParam("@Description", description),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertBlogGroup", p);
            return (int)outParam0.Value;
        }

        public int InsertCategory(string title, bool active, int blogId, int categoryType, string description)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@CategoryId", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Active", active),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CategoryType", categoryType),
                                   DataHelper.MakeInParam("@Description", description),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertCategory", p);
            return (int)outParam0.Value;
        }

        public int InsertEnclosure(string title, string url, string mimeType, long size, bool addToFeed,
                                   bool showWithPost, int entryId)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@Id", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@MimeType", mimeType),
                                   DataHelper.MakeInParam("@Size", size),
                                   DataHelper.MakeInParam("@AddToFeed", addToFeed),
                                   DataHelper.MakeInParam("@ShowWithPost", showWithPost),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertEnclosure", p);
            return (int)outParam0.Value;
        }

        public int InsertEntry(string title, string text, int postType, string author, string email, string description,
                               int blogId, DateTime dateCreated, int postConfig, string entryName,
                               DateTime? dateSyndicated, DateTime currentDateTime)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@ID", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Text", text),
                                   DataHelper.MakeInParam("@PostType", postType),
                                   DataHelper.MakeInParam("@Author", author),
                                   DataHelper.MakeInParam("@Email", email),
                                   DataHelper.MakeInParam("@Description", description),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@DateCreated", dateCreated),
                                   DataHelper.MakeInParam("@PostConfig", postConfig),
                                   DataHelper.MakeInParam("@EntryName", entryName),
                                   DataHelper.MakeInParam("@DateSyndicated", dateSyndicated),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertEntry", p);
            return (int)outParam0.Value;
        }

        public bool InsertEntryTagList(int entryId, int blogId, string tagList)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@TagList", tagList),
                               };


            return NonQueryBool("subtext_InsertEntryTagList", p);
        }

        public int InsertFeedback(string title, string body, int blogId, int? entryId, string author, bool isBlogAuthor,
                                  string email, string url, int feedbackType, int statusFlag, bool commentAPI,
                                  string referrer, string ipAddress, string userAgent, string feedbackChecksumHash,
                                  DateTime dateCreated, DateTime? dateModified, DateTime currentDateTime)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@Id", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Body", body),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@Author", author),
                                   DataHelper.MakeInParam("@IsBlogAuthor", isBlogAuthor),
                                   DataHelper.MakeInParam("@Email", email),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@FeedbackType", feedbackType),
                                   DataHelper.MakeInParam("@StatusFlag", statusFlag),
                                   DataHelper.MakeInParam("@CommentAPI", commentAPI),
                                   DataHelper.MakeInParam("@Referrer", referrer),
                                   DataHelper.MakeInParam("@IpAddress", ipAddress),
                                   DataHelper.MakeInParam("@UserAgent", userAgent),
                                   DataHelper.MakeInParam("@FeedbackChecksumHash", feedbackChecksumHash),
                                   DataHelper.MakeInParam("@DateCreated", dateCreated),
                                   DataHelper.MakeInParam("@DateModified", dateModified),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertFeedback", p);
            return (int)outParam0.Value;
        }

        public int InsertImage(string title, int categoryId, int width, int height, string file, bool active, int blogId,
                               string url)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@ImageId", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@Width", width),
                                   DataHelper.MakeInParam("@Height", height),
                                   DataHelper.MakeInParam("@File", file),
                                   DataHelper.MakeInParam("@Active", active),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@Url", url),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertImage", p);
            return (int)outParam0.Value;
        }

        public int InsertKeyWord(string word, string rel, string text, bool replaceFirstTimeOnly, bool openInNewWindow,
                                 bool caseSensitive, string url, string title, int blogId)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@KeyWordID", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Word", word),
                                   DataHelper.MakeInParam("@Rel", rel),
                                   DataHelper.MakeInParam("@Text", text),
                                   DataHelper.MakeInParam("@ReplaceFirstTimeOnly", replaceFirstTimeOnly),
                                   DataHelper.MakeInParam("@OpenInNewWindow", openInNewWindow),
                                   DataHelper.MakeInParam("@CaseSensitive", caseSensitive),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertKeyWord", p);
            return (int)outParam0.Value;
        }

        public int InsertLink(string title, string url, string rss, bool active, bool newWindow, int categoryId,
                              int? postId, int blogId, string rel)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@LinkID", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@Rss", rss),
                                   DataHelper.MakeInParam("@Active", active),
                                   DataHelper.MakeInParam("@NewWindow", newWindow),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@PostId", postId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@Rel", rel),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertLink", p);
            return (int)outParam0.Value;
        }

        public bool InsertLinkCategoryList(string categoryList, int postId, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@CategoryList", categoryList),
                                   DataHelper.MakeInParam("@PostId", postId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_InsertLinkCategoryList", p);
        }

        public int InsertMetaTag(string content, string name, string httpEquiv, int blogId, int? entryId,
                                 DateTime? dateCreated)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@Id", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Content", content),
                                   DataHelper.MakeInParam("@Name", name),
                                   DataHelper.MakeInParam("@HttpEquiv", httpEquiv),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@DateCreated", dateCreated),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertMetaTag", p);
            return (int)outParam0.Value;
        }

        public int InsertPingTrackEntry(string title, string titleUrl, string text, string sourceUrl, int postType,
                                        string author, string email, string sourceName, string description, int blogId,
                                        DateTime dateAdded, int? parentId, int postConfig, string entryName,
                                        string contentChecksumHash)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@ID", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@TitleUrl", titleUrl),
                                   DataHelper.MakeInParam("@Text", text),
                                   DataHelper.MakeInParam("@SourceUrl", sourceUrl),
                                   DataHelper.MakeInParam("@PostType", postType),
                                   DataHelper.MakeInParam("@Author", author),
                                   DataHelper.MakeInParam("@Email", email),
                                   DataHelper.MakeInParam("@SourceName", sourceName),
                                   DataHelper.MakeInParam("@Description", description),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@DateAdded", dateAdded),
                                   DataHelper.MakeInParam("@ParentID", parentId),
                                   DataHelper.MakeInParam("@PostConfig", postConfig),
                                   DataHelper.MakeInParam("@EntryName", entryName),
                                   DataHelper.MakeInParam("@ContentChecksumHash", contentChecksumHash),
                                   outParam0,
                               };

            NonQueryInt("subtext_InsertPingTrackEntry", p);
            return (int)outParam0.Value;
        }

        public bool InsertReferral(int entryId, int blogId, string url)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@Url", url),
                               };


            return NonQueryBool("subtext_InsertReferral", p);
        }

        public IDataReader InsertViewStats(int blogId, int pageType, int postId, DateTime day, string url)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@PageType", pageType),
                                   DataHelper.MakeInParam("@PostId", postId),
                                   DataHelper.MakeInParam("@Day", day),
                                   DataHelper.MakeInParam("@Url", url),
                               };

            return GetReader("subtext_InsertViewStats", p);
        }

        public IDataReader ListBlogGroups(bool active)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Active", active),
                               };

            return GetReader("subtext_ListBlogGroups", p);
        }

        public bool LogClear(int? blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_LogClear", p);
        }

        public bool Maintenance()
        {
            return NonQueryBool("subtext_Maintenance", null);
        }

        public bool RefererCleanup()
        {
            return NonQueryBool("subtext_RefererCleanup", null);
        }

        public IDataReader SearchEntries(int blogId, string searchStr, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@SearchStr", searchStr),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };

            return GetReader("subtext_SearchEntries", p);
        }

        public IDataReader StatsSummary(int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };

            return GetReader("subtext_StatsSummary", p);
        }

        public bool TrackEntry(int entryId, int blogId, string url, bool isWeb)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@IsWeb", isWeb),
                               };

            return NonQueryBool("subtext_TrackEntry", p);
        }

        public bool UpdateBlogGroup(int id, string title, bool active, string description, int? displayOrder)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Active", active),
                                   DataHelper.MakeInParam("@Description", description),
                                   DataHelper.MakeInParam("@DisplayOrder", displayOrder),
                               };


            return NonQueryBool("subtext_UpdateBlogGroup", p);
        }

        public bool UpdateBlogStats(int blogId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };


            return NonQueryBool("subtext_UpdateBlogStats", p);
        }

        public bool UpdateCategory(int categoryId, string title, bool active, int categoryType, string description,
                                   int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Active", active),
                                   DataHelper.MakeInParam("@CategoryType", categoryType),
                                   DataHelper.MakeInParam("@Description", description),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_UpdateCategory", p);
        }

        public bool UpdateConfig(string userName, string password, string email, string title, string subTitle,
                                 string skin, string application, string host, string author, string language,
                                 string timeZoneId, int itemCount, int categoryListPostCount, string news,
                                 string trackingCode, DateTime? lastUpdated, string secondaryCss, string skinCssFile,
                                 int? flag, int blogId, string licenseUrl, int? daysTillCommentsClose,
                                 int? commentDelayInMinutes, int? numberOfRecentComments, int? recentCommentsLength,
                                 string akismetAPIKey, string feedBurnerName, int blogGroupId, string mobileSkin,
                                 string mobileSkinCssFile, string openIDUrl, string cardSpaceHash, string openIDServer,
                                 string openIDDelegate)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@UserName", userName),
                                   DataHelper.MakeInParam("@Password", password),
                                   DataHelper.MakeInParam("@Email", email),
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@SubTitle", subTitle),
                                   DataHelper.MakeInParam("@Skin", skin),
                                   DataHelper.MakeInParam("@Application", application),
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@Author", author),
                                   DataHelper.MakeInParam("@Language", language),
                                   DataHelper.MakeInParam("@TimeZoneId", timeZoneId),
                                   DataHelper.MakeInParam("@ItemCount", itemCount),
                                   DataHelper.MakeInParam("@CategoryListPostCount", categoryListPostCount),
                                   DataHelper.MakeInParam("@News", news),
                                   DataHelper.MakeInParam("@TrackingCode", trackingCode),
                                   DataHelper.MakeInParam("@LastUpdated", lastUpdated),
                                   DataHelper.MakeInParam("@SecondaryCss", secondaryCss),
                                   DataHelper.MakeInParam("@SkinCssFile", skinCssFile),
                                   DataHelper.MakeInParam("@Flag", flag),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@LicenseUrl", licenseUrl),
                                   DataHelper.MakeInParam("@DaysTillCommentsClose", daysTillCommentsClose),
                                   DataHelper.MakeInParam("@CommentDelayInMinutes", commentDelayInMinutes),
                                   DataHelper.MakeInParam("@NumberOfRecentComments", numberOfRecentComments),
                                   DataHelper.MakeInParam("@RecentCommentsLength", recentCommentsLength),
                                   DataHelper.MakeInParam("@AkismetAPIKey", akismetAPIKey),
                                   DataHelper.MakeInParam("@FeedBurnerName", feedBurnerName),
                                   DataHelper.MakeInParam("@BlogGroupId", blogGroupId),
                                   DataHelper.MakeInParam("@MobileSkin", mobileSkin),
                                   DataHelper.MakeInParam("@MobileSkinCssFile", mobileSkinCssFile),
                                   DataHelper.MakeInParam("@OpenIdUrl", openIDUrl),
                                   DataHelper.MakeInParam("@CardSpaceHash", cardSpaceHash),
                                   DataHelper.MakeInParam("@OpenIdServer", openIDServer),
                                   DataHelper.MakeInParam("@OpenIdDelegate", openIDDelegate),
                               };


            return NonQueryBool("subtext_UpdateConfig", p);
        }

        public bool UpdateConfigUpdateTime(int blogId, DateTime lastUpdated)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@LastUpdated", lastUpdated),
                               };


            return NonQueryBool("subtext_UpdateConfigUpdateTime", p);
        }

        public bool UpdateDomainAlias(int id, int blogId, string host, string application, bool? active)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@Application", application),
                                   DataHelper.MakeInParam("@Active", active),
                               };


            return NonQueryBool("subtext_UpdateDomainAlias", p);
        }

        public bool UpdateEnclosure(string title, string url, string mimeType, long size, bool addToFeed,
                                    bool showWithPost, int entryId, int id)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@MimeType", mimeType),
                                   DataHelper.MakeInParam("@Size", size),
                                   DataHelper.MakeInParam("@AddToFeed", addToFeed),
                                   DataHelper.MakeInParam("@ShowWithPost", showWithPost),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@Id", id),
                               };


            return NonQueryBool("subtext_UpdateEnclosure", p);
        }

        public bool UpdateEntry(int id, string title, string text, int postType, string author, string email,
                                string description, DateTime? dateUpdated, int postConfig, string entryName,
                                DateTime? dateSyndicated, int blogId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ID", id),
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Text", text),
                                   DataHelper.MakeInParam("@PostType", postType),
                                   DataHelper.MakeInParam("@Author", author),
                                   DataHelper.MakeInParam("@Email", email),
                                   DataHelper.MakeInParam("@Description", description),
                                   DataHelper.MakeInParam("@DateUpdated", dateUpdated),
                                   DataHelper.MakeInParam("@PostConfig", postConfig),
                                   DataHelper.MakeInParam("@EntryName", entryName),
                                   DataHelper.MakeInParam("@DateSyndicated", dateSyndicated),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };


            return NonQueryBool("subtext_UpdateEntry", p);
        }

        public bool UpdateFeedback(int id, string title, string body, string author, string email, string url,
                                   int statusFlag, string feedbackChecksumHash, DateTime dateModified,
                                   DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@ID", id),
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Body", body),
                                   DataHelper.MakeInParam("@Author", author),
                                   DataHelper.MakeInParam("@Email", email),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@StatusFlag", statusFlag),
                                   DataHelper.MakeInParam("@FeedbackChecksumHash", feedbackChecksumHash),
                                   DataHelper.MakeInParam("@DateModified", dateModified),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };


            return NonQueryBool("subtext_UpdateFeedback", p);
        }

        public bool UpdateFeedbackCount(int blogId, int entryId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };


            return NonQueryBool("subtext_UpdateFeedbackCount", p);
        }

        public bool UpdateFeedbackStats(int blogId, DateTime currentDateTime)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@CurrentDateTime", currentDateTime),
                               };


            return NonQueryBool("subtext_UpdateFeedbackStats", p);
        }

        public bool UpdateHost(string hostUserName, string password, string salt, string email)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@HostUserName", hostUserName),
                                   DataHelper.MakeInParam("@Password", password),
                                   DataHelper.MakeInParam("@Salt", salt),
                                   DataHelper.MakeInParam("@Email", email),
                               };


            return NonQueryBool("subtext_UpdateHost", p);
        }

        public bool UpdateImage(string title, int categoryId, int width, int height, string file, bool active,
                                int blogId, int imageId, string url)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@Width", width),
                                   DataHelper.MakeInParam("@Height", height),
                                   DataHelper.MakeInParam("@File", file),
                                   DataHelper.MakeInParam("@Active", active),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@ImageId", imageId),
                               };


            return NonQueryBool("subtext_UpdateImage", p);
        }

        public bool UpdateKeyWord(int keyWordId, string word, string rel, string text, bool replaceFirstTimeOnly,
                                  bool openInNewWindow, bool caseSensitive, string url, string title, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@KeyWordID", keyWordId),
                                   DataHelper.MakeInParam("@Word", word),
                                   DataHelper.MakeInParam("@Rel", rel),
                                   DataHelper.MakeInParam("@Text", text),
                                   DataHelper.MakeInParam("@ReplaceFirstTimeOnly", replaceFirstTimeOnly),
                                   DataHelper.MakeInParam("@OpenInNewWindow", openInNewWindow),
                                   DataHelper.MakeInParam("@CaseSensitive", caseSensitive),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_UpdateKeyWord", p);
        }

        public bool UpdateLink(int linkId, string title, string url, string rss, bool active, bool newWindow,
                               int categoryId, string rel, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@LinkID", linkId),
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@Url", url),
                                   DataHelper.MakeInParam("@Rss", rss),
                                   DataHelper.MakeInParam("@Active", active),
                                   DataHelper.MakeInParam("@NewWindow", newWindow),
                                   DataHelper.MakeInParam("@CategoryId", categoryId),
                                   DataHelper.MakeInParam("@Rel", rel),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_UpdateLink", p);
        }

        public bool UpdateMetaTag(int id, string content, string name, string httpEquiv, int blogId, int? entryId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Id", id),
                                   DataHelper.MakeInParam("@Content", content),
                                   DataHelper.MakeInParam("@Name", name),
                                   DataHelper.MakeInParam("@HttpEquiv", httpEquiv),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                                   DataHelper.MakeInParam("@EntryId", entryId),
                               };


            return NonQueryBool("subtext_UpdateMetaTag", p);
        }

        public int UTILITYAddBlog(string title, string userName, string password, string email, string host,
                                  string application, int flag, int blogGroupId)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@Id", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Title", title),
                                   DataHelper.MakeInParam("@UserName", userName),
                                   DataHelper.MakeInParam("@Password", password),
                                   DataHelper.MakeInParam("@Email", email),
                                   DataHelper.MakeInParam("@Host", host),
                                   DataHelper.MakeInParam("@Application", application),
                                   DataHelper.MakeInParam("@Flag", flag),
                                   DataHelper.MakeInParam("@BlogGroupId", blogGroupId),
                                   outParam0,
                               };

            NonQueryInt("subtext_UTILITY_AddBlog", p);
            return (int)outParam0.Value;
        }

        public IDataReader UtilityGetUnHashedPasswords()
        {
            return GetReader("subtext_Utility_GetUnHashedPasswords");
        }

        public bool UtilityUpdateToHashedPassword(string password, int blogId)
        {
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Password", password),
                                   DataHelper.MakeInParam("@BlogId", blogId),
                               };


            return NonQueryBool("subtext_Utility_UpdateToHashedPassword", p);
        }

        public int? VersionAdd(int major, int minor, int build, DateTime? dateCreated)
        {
            SqlParameter outParam0 = DataHelper.MakeOutParam("@Id", SqlDbType.Int, 4);
            SqlParameter[] p = {
                                   DataHelper.MakeInParam("@Major", major),
                                   DataHelper.MakeInParam("@Minor", minor),
                                   DataHelper.MakeInParam("@Build", build),
                                   DataHelper.MakeInParam("@DateCreated", dateCreated),
                                   outParam0,
                               };

            NonQueryInt("subtext_VersionAdd", p);
            if(outParam0.Value == null)
            {
                return null;
            }
            return (int)outParam0.Value;
        }

        public IDataReader VersionGetCurrent()
        {
            return GetReader("subtext_VersionGetCurrent");
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Data;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Configuration;
using Subtext.Framework.Properties;
using Subtext.Framework.Providers;
using Subtext.Framework.Text;
using Subtext.Framework.Util;
using Subtext.Framework.Web.HttpModules;

namespace Subtext.Framework.Data
{
    /// <summary>
    /// Concrete implementation of <see cref="ObjectProvider"/>. This 
    /// provides objects persisted to a database.
    /// </summary>
    public partial class DatabaseObjectProvider : ObjectProvider
    {
        readonly StoredProcedures _procedures = new StoredProcedures(Config.ConnectionString);

        public int BlogId
        {
            get
            {
                //Fix this up...
                return BlogRequest.Current.IsHostAdminRequest ? NullValue.NullInt32 : BlogRequest.Current.Blog.Id;
            }
        }

        public DateTime CurrentDateTime
        {
            get { return BlogRequest.Current.Blog.TimeZone.Now; }
        }

        private static void ValidateEntry(Entry e)
        {
            //TODO: The following doesn't belong here. It's verification code.
            if(!Config.Settings.AllowScriptsInPosts && HtmlHelper.HasIllegalContent(e.Body))
            {
                throw new IllegalPostCharactersException(Resources.IllegalPostCharacters);
            }

            //Never allow scripts in the title.
            if(HtmlHelper.HasIllegalContent(e.Title))
            {
                throw new IllegalPostCharactersException(Resources.IllegalPostCharacters);
            }

            if(!Config.Settings.AllowScriptsInPosts && HtmlHelper.HasIllegalContent(e.Description))
            {
                throw new IllegalPostCharactersException(Resources.IllegalPostCharacters);
            }

            //never allow scripts in the url.
            if(HtmlHelper.HasIllegalContent(e.EntryName))
            {
                throw new IllegalPostCharactersException(Resources.IllegalPostCharacters);
            }
        }

        public override bool TrackEntry(EntryView entryView)
        {
            return ThreadHelper.FireAndForget(o =>
                                              _procedures.TrackEntry(entryView.EntryId, entryView.BlogId, entryView.ReferralUrl,
                                                                     entryView.PageViewType == PageViewType.WebView), "Exception while tracking an entry");
        }

        public override ICollection<LinkCategory> GetActiveCategories()
        {
            using(IDataReader reader = _procedures.GetActiveCategoriesWithLinkCollection(BlogId.NullIfMinValue()))
            {
                return reader.ReadLinkCategories(true);
            }
        }

        public override IPagedCollection<Referrer> GetPagedReferrers(int pageIndex, int pageSize, int entryId)
        {
            using(
                IDataReader reader = _procedures.GetPageableReferrers(BlogId, entryId.NullIfMinValue(), pageIndex,
                                                                      pageSize))
            {
                return reader.ReadPagedCollection(r => DataHelper.ReadReferrer(r, Config.CurrentBlog));
            }
        }

        public override int Create(MetaTag metaTag)
        {
            return _procedures.InsertMetaTag(metaTag.Content,
                                             metaTag.Name.NullIfEmpty(),
                                             metaTag.HttpEquiv.NullIfEmpty(),
                                             BlogId,
                                             metaTag.EntryId,
                                             metaTag.DateCreated);
        }

        public override bool Update(MetaTag metaTag)
        {
            return _procedures.UpdateMetaTag(metaTag.Id,
                                             metaTag.Content,
                                             metaTag.Name.NullIfEmpty(),
                                             metaTag.HttpEquiv.NullIfEmpty(),
                                             BlogId,
                                             metaTag.EntryId);
        }

        public override IPagedCollection<MetaTag> GetMetaTagsForBlog(Blog blog, int pageIndex, int pageSize)
        {
            using(IDataReader reader = _procedures.GetMetaTags(blog.Id, null, pageIndex, pageSize))
            {
                return reader.ReadPagedCollection(r => r.ReadObject<MetaTag>());
            }
        }

        public override IPagedCollection<MetaTag> GetMetaTagsForEntry(Entry entry, int pageIndex, int pageSize)
        {
            using(IDataReader reader = _procedures.GetMetaTags(entry.BlogId, entry.Id, pageIndex, pageSize))
            {
                return reader.ReadPagedCollection(r => r.ReadObject<MetaTag>());
            }
        }

        public override bool DeleteMetaTag(int metaTagId)
        {
            return _procedures.DeleteMetaTag(metaTagId);
        }

        public override int Create(Enclosure enclosure)
        {
            return _procedures.InsertEnclosure(enclosure.Title ?? string.Empty,
                                               enclosure.Url,
                                               enclosure.MimeType,
                                               enclosure.Size,
                                               enclosure.AddToFeed,
                                               enclosure.ShowWithPost,
                                               enclosure.EntryId);
        }

        public override bool Update(Enclosure enclosure)
        {
            return _procedures.UpdateEnclosure(enclosure.Title,
                                               enclosure.Url,
                                               enclosure.MimeType,
                                               enclosure.Size,
                                               enclosure.AddToFeed,
                                               enclosure.ShowWithPost,
                                               enclosure.EntryId,
                                               enclosure.Id);
        }

        public override bool DeleteEnclosure(int enclosureId)
        {
            return _procedures.DeleteEnclosure(enclosureId);
        }

        public override KeyWord GetKeyWord(int keyWordId)
        {
            using(IDataReader reader = _procedures.GetKeyWord(keyWordId, BlogId))
            {
                KeyWord kw = null;
                while(reader.Read())
                {
                    kw = reader.ReadObject<KeyWord>();
                    break;
                }
                return kw;
            }
        }

        public override ICollection<KeyWord> GetKeyWords()
        {
            using(IDataReader reader = _procedures.GetBlogKeyWords(BlogId))
            {
                return reader.ReadCollection<KeyWord>();
            }
        }

        public override IPagedCollection<KeyWord> GetPagedKeyWords(int pageIndex, int pageSize)
        {
            using(IDataReader reader = _procedures.GetPageableKeyWords(BlogId, pageIndex, pageSize))
            {
                return reader.ReadPagedCollection(r => r.ReadObject<KeyWord>());
            }
        }

        public override bool UpdateKeyWord(KeyWord keyWord)
        {
            return _procedures.UpdateKeyWord(keyWord.Id,
                                             keyWord.Word,
                                             keyWord.Rel,
                                             keyWord.Text,
                                             keyWord.ReplaceFirstTimeOnly,
                                             keyWord.OpenInNewWindow,
                                             keyWord.CaseSensitive,
                                             keyWord.Url,
                                             keyWord.Title,
                                             BlogId);
        }

        public override int InsertKeyWord(KeyWord keyWord)
        {
            return _procedures.InsertKeyWord(keyWord.Word,
                                             keyWord.Rel,
                                             keyWord.Text,
                                             keyWord.ReplaceFirstTimeOnly,
                                             keyWord.OpenInNewWindow,
                                             keyWord.CaseSensitive,
                                             keyWord.Url,
                                             keyWord.Title,
                                             BlogId);
        }

        public override bool DeleteKeyWord(int id)
        {
            return _procedures.DeleteKeyWord(id, BlogId);
        }

        public override ImageCollection GetImagesByCategoryId(int categoryId, bool activeOnly)
        {
            using(IDataReader reader = _procedures.GetImageCategory(categoryId, activeOnly, BlogId))
            {
                var ic = new ImageCollection();
                while(reader.Read())
                {
                    ic.Category = reader.ReadLinkCategory();
                    break;
                }
                reader.NextResult();
                while(reader.Read())
                {
                    ic.Add(reader.ReadImage());
                }
                return ic;
            }
        }

        public override Image GetImage(int imageId, bool activeOnly)
        {
            using(IDataReader reader = _procedures.GetSingleImage(imageId, activeOnly, BlogId))
            {
                Image image = null;
                while(reader.Read())
                {
                    image = reader.ReadImage();
                }
                return image;
            }
        }

        public override int InsertImage(Image image)
        {
            return _procedures.InsertImage(image.Title,
                                           image.CategoryID,
                                           image.Width,
                                           image.Height,
                                           image.FileName,
                                           image.IsActive,
                                           BlogId,
                                           image.Url);
        }

        public override bool UpdateImage(Image image)
        {
            return _procedures.UpdateImage(image.Title,
                                           image.CategoryID,
                                           image.Width,
                                           image.Height,
                                           image.FileName,
                                           image.IsActive,
                                           BlogId,
                                           image.ImageID,
                                           image.Url);
        }

        public override bool DeleteImage(int imageId)
        {
            return _procedures.DeleteImage(BlogId, imageId);
        }

        private static LinkCategory ReadLinkCategory(IDataReader reader)
        {
            return !reader.Read() ? null : reader.ReadLinkCategory();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Globalization;
using System.Linq;
using System.Net;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Configuration;

//Need to remove Global.X calls ...just seems unclean
//Maybe create a another class formatter ...Format.Entry(ref Entry entry) 
//or, Instead of Globals.PostUrl(int id) --> Globals.PostUrl(ref Entry entry)
//...

namespace Subtext.Framework.Data
{
    /// <summary>
    /// Contains helper methods for getting blog entries from the database 
    /// into objects such as <see cref="Entry" />
    /// </summary>
    public static class DataHelper
    {
        public static IEnumerable<T> ReadEnumerable<T>(this IDataReader reader, Func<IDataReader, T> map)
        {
            while(reader.Read())
            {
                yield return map(reader);
            }
        }

        public static IPagedCollection<T> ReadPagedCollection<T>(this IDataReader reader, Func<IDataReader, T> map)
        {
            var collection = new PagedCollection<T>(reader.ReadEnumerable(map).ToList());
            reader.NextResult();
            reader.Read();
            collection.MaxItems = reader.ReadValue<int>("TotalRecords");
            return collection;
        }

        public static T ReadObject<T>(this IDataReader reader, params string[] exclusionList) where T : new()
        {
            var item = new T();
            reader.ReadObject(item, exclusionList);
            return item;
        }

        public static T ReadObject<T>(this IDataReader reader, T item, params string[] exclusionList)
        {
            PropertyDescriptorCollection properties = TypeDescriptor.GetProperties(item);
            foreach(PropertyDescriptor property in properties)
            {
                if(property.IsReadOnly)
                {
                    continue;
                }

                if(!property.PropertyType.IsReadablePropertyType())
                {
                    continue;
                }

                if(exclusionList != null && exclusionList.IsExcluded(property.Name))
                {
                    continue;
                }

                // We need to catch this exception in cases when we're upgrading and the column might not exist yet.
                // It'd be nice to have a cleaner way of doing this.
                try
                {
                    object value = reader[property.Name];
                    if(value != DBNull.Value)
                    {
                        if(property.PropertyType != typeof(Uri))
                        {
                            property.SetValue(item, value);    
                        }
                        else
                        {
                            var url = value as string;
                            if(!String.IsNullOrEmpty(url))
                            {
                                Uri uri;
                                if(Uri.TryCreate(url, UriKind.RelativeOrAbsolute, out uri))
                                {
                                    property.SetValue(item, uri);
                                }
                            }
                        }
                    }
                }
                catch(IndexOutOfRangeException)
                {
                    if(typeof(T) != typeof(HostInfo))
                    {
                        throw;
                    }
                }
            }
            return item;
        }

        public static T ReadValue<T>(this IDataReader reader, string columnName)
        {
            return reader.ReadValue(columnName, default(T));
        }

        public static T ReadValue<T>(this IDataReader reader, string columnName, T defaultValue)
        {
            return reader.ReadValue(columnName, value => (T)value, defaultValue);
        }

        public static T ReadValue<T>(this IDataReader reader, string columnName, Func<object, T> map, T defaultValue)
        {
            try
            {
                object value = reader[columnName];
                if(value != null && value != DBNull.Value)
                {
                    return map(value);
                }
                return defaultValue;
            }
            catch(FormatException)
            {
                return defaultValue;
            }
            catch(IndexOutOfRangeException)
            {
                return defaultValue;
            }
        }

        /// <summary>
        /// Checks the value type and returns null if the 
        /// value is "null-equivalent".
        /// </summary>
        public static int? NullIfMinValue(this int value)
        {
            if(NullValue.IsNull(value))
            {
                return null;
            }
            return value;
        }

        public static DateTime? NullIfEmpty(this DateTime dateTime)
        {
            if(NullValue.IsNull(dateTime))
            {
                return null;
            }
            return dateTime;
        }

        public static Referrer ReadReferrer(IDataReader reader, Blog blog)
        {
            var refer = reader.ReadObject<Referrer>();
            refer.BlogId = blog.Id;
            return refer;
        }

        internal static ICollection<Entry> ReadEntryCollection(this IDataReader reader)
        {
            return reader.ReadEntryCollection(true /* buildLinks */);
        }

        internal static ICollection<Entry> ReadEntryCollection(this IDataReader reader, bool buildLinks)
        {
            return reader.ReadEntryCollection<Entry, List<Entry>>(r => r.ReadEnumerable(innerReader => innerReader.ReadEntry(buildLinks)).ToList());
        }

        internal static TCollection ReadEntryCollection<TEntry, TCollection>(this IDataReader reader, Func<IDataReader, TCollection> collectionFunc) where TCollection : ICollection<TEntry> where TEntry : Entry
        {
            var entries = collectionFunc(reader);
            if(entries.Count > 0 && reader.NextResult())
            {
                var categories = reader.ReadEnumerable(r => new { EntryId = r.ReadValue<int>("PostId"), Title = r.ReadValue<string>("Title") });
                entries.Accumulate(categories, entry => entry.Id, category => category.EntryId, (entry, category) => entry.Categories.Add(category.Title));
            }
            return entries;
        }

        internal static ICollection<TItem> ReadCollection<TItem>(this IDataReader reader, Func<IDataReader, TItem> map)
        {
            return reader.ReadEnumerable(map).ToList();
        }

        internal static ICollection<TItem> ReadCollection<TItem>(this IDataReader reader) where TItem : new()
        {
            return reader.ReadCollection(r => r.ReadObject<TItem>());
        }

        //Crappy. Need to clean up all of the entry references
        public static EntryStatsView ReadEntryStatsView(this IDataReader reader)
        {
            var entry = new EntryStatsView
            {
                BlogId = reader.ReadValue("BlogId",0),
                PostType = ((PostType)reader.ReadValue<int>("PostType")),
                WebCount = reader.ReadValue("WebCount", 0),
                AggCount = reader.ReadValue("AggCount", 0),
                WebLastUpdated = reader.ReadValue<DateTime>("WebLastUpdated"),
                AggLastUpdated = reader.ReadValue<DateTime>("AggLastUpdated"),
                Author = reader.ReadValue<string>("Author"),
                Email = reader.ReadValue<string>("Email"),
                DateCreated = reader.ReadValue<DateTime>("DateCreated"),
                DateModified = reader.ReadValue<DateTime>("DateUpdated"),
                Id = reader.ReadValue<int>("ID"),
                Description = reader.ReadValue<string>("Description"),
                EntryName = reader.ReadValue<string>("EntryName"),
                FeedBackCount = reader.ReadValue<int>("FeedBackCount"),
                Body = reader.ReadValue<string>("Text"),
                Title = reader.ReadValue<string>("Title"),
                PostConfig = (PostConfig)(reader.ReadValue<int>("PostConfig")),
                DateSyndicated = reader.ReadValue<DateTime>("DateSyndicated")
            };

            return entry;
        }

        public static Entry ReadEntry(this IDataReader reader)
        {
            return ReadEntry(reader, true);
        }

        /// <summary>
        /// Only use this when loading a SINGLE entry from a reader.
        /// </summary>
        /// <param name="reader"></param>
        /// <returns></returns>
        public static Entry ReadEntryWithCategories(IDataReader reader)
        {
            Entry entry = reader.ReadEntry();
            if(reader.NextResult())
            {
                entry.Categories.AddRange(reader.ReadEnumerable(r => r.ReadValue<string>("Title")).Distinct(StringComparer.Ordinal));
            }
            return entry;
        }

        internal static FeedbackItem ReadFeedbackItem(this IDataReader reader, Entry entry)
        {
            var feedbackItem = new FeedbackItem((FeedbackType)reader.ReadValue<int>("FeedbackType"));
            ReadFeedbackItem(reader, feedbackItem);
            feedbackItem.Entry = entry;
            return feedbackItem;
        }

        internal static FeedbackItem ReadFeedbackItem(this IDataReader reader)
        {
            var feedbackItem = new FeedbackItem((FeedbackType)reader.ReadValue<int>("FeedbackType"));
            ReadFeedbackItem(reader, feedbackItem);
            return feedbackItem;
        }

        private static void ReadFeedbackItem(this IDataReader reader, FeedbackItem feedbackItem)
        {
            feedbackItem.Id = reader.ReadValue<int>("Id");
            feedbackItem.Title = reader.ReadValue<string>("Title");
            feedbackItem.Body = reader.ReadValue<string>("Body");
            feedbackItem.EntryId = reader.ReadValue<int>("EntryId");
            feedbackItem.Author = reader.ReadValue<string>("Author") ?? string.Empty;
            feedbackItem.IsBlogAuthor = reader.ReadValue<bool>("IsBlogAuthor");
            feedbackItem.Email = reader.ReadValue<string>("Email");
            feedbackItem.SourceUrl = ReadUri(reader, "Url");
            feedbackItem.FeedbackType = (FeedbackType)reader.ReadValue<int>("FeedbackType");
            feedbackItem.Status = (FeedbackStatusFlag)reader.ReadValue<int>("StatusFlag");
            feedbackItem.CreatedViaCommentApi = reader.ReadValue<bool>("CommentAPI");
            feedbackItem.Referrer = reader.ReadValue<string>("Referrer");
            feedbackItem.IpAddress = reader.ReadIpAddress("IpAddress");
            feedbackItem.UserAgent = reader.ReadValue<string>("UserAgent");
            feedbackItem.ChecksumHash = reader.ReadValue<string>("FeedbackChecksumHash");
            feedbackItem.DateCreated = reader.ReadValue<DateTime>("DateCreated");
            feedbackItem.DateModified = reader.ReadValue<DateTime>("DateModified");
            feedbackItem.ParentEntryName = reader.ReadValue<string>("ParentEntryName");
            feedbackItem.ParentDateCreated = reader.ReadValue<DateTime>("ParentEntryCreateDate");
            feedbackItem.ParentDateSyndicated = reader.ReadValue<DateTime>("ParentEntryDateSyndicated");
        }

        public static Entry ReadEntry(this IDataReader reader, bool buildLinks)
        {
            var entry = new Entry((PostType)reader.ReadValue<int>("PostType"), null);
            reader.ReadEntry(entry, buildLinks);
            return entry;
        }

        public static Entry ReadEntry(this IDataReader reader, Entry entry, bool buildLinks)
        {
            return reader.ReadEntry(entry, buildLinks, false);
        }

        public static Entry ReadEntry(this IDataReader reader, Entry entry, bool buildLinks, bool includeBlog)
        {
            entry.Author = reader.ReadValue<string>("Author");
            entry.Email = reader.ReadValue<string>("Email");
            entry.DateCreated = reader.ReadValue<DateTime>("DateCreated");
            entry.DateModified = reader.ReadValue<DateTime>("DateUpdated");

            entry.Id = reader.ReadValue<int>("ID");
            entry.Description = reader.ReadValue<string>("Description");
            entry.EntryName = reader.ReadValue<string>("EntryName");

            entry.FeedBackCount = reader.ReadValue("FeedBackCount", 0);
            entry.Body = reader.ReadValue<string>("Text");
            entry.Title = reader.ReadValue<string>("Title");
            entry.PostConfig = (PostConfig)(reader.ReadValue("PostConfig", (int)PostConfig.None));
            entry.DateSyndicated = reader.ReadValue<DateTime>("DateSyndicated");

            var withEnclosure = reader.ReadValue<bool>("EnclosureEnabled");
            if(withEnclosure)
            {
                entry.Enclosure = ReadEnclosure(reader);
            }

            if(includeBlog)
            {
                entry.Blog = ReadBlog(reader);
            }
            return entry;
        }

        public static Blog ReadBlog(this IDataReader reader)
        {
            return reader.ReadBlog(string.Empty);
        }

        public static Blog ReadBlog(this IDataReader reader, string prefix)
        {
            var info = new Blog
            {
                Author = reader.ReadValue<string>(prefix + "Author"),
                Id = reader.ReadValue<int>(prefix + "BlogId"),
                Email = reader.ReadValue<string>(prefix + "Email"),
                Password = reader.ReadValue<string>(prefix + "Password"),
                SubTitle = reader.ReadValue<string>(prefix + "SubTitle"),
                Title = reader.ReadValue<string>(prefix + "Title"),
                UserName = reader.ReadValue<string>(prefix + "UserName"),
                TimeZoneId = reader.ReadValue<string>(prefix + "TimeZoneId"),
                ItemCount = reader.ReadValue<int>(prefix + "ItemCount"),
                CategoryListPostCount = reader.ReadValue<int>(prefix + "CategoryListPostCount"),
                Language = reader.ReadValue<string>(prefix + "Language"),
                PostCount = reader.ReadValue<int>(prefix + "PostCount"),
                CommentCount = reader.ReadValue<int>(prefix + "CommentCount"),
                StoryCount = reader.ReadValue<int>(prefix + "StoryCount"),
                PingTrackCount = reader.ReadValue<int>(prefix + "PingTrackCount"),
                News = reader.ReadValue<string>(prefix + "News"),
                TrackingCode = reader.ReadValue<string>(prefix + "TrackingCode"),
                LastUpdated = reader.ReadValue(prefix + "LastUpdated", new DateTime(2003, 1, 1)),
                Host = reader.ReadValue<string>(prefix + "Host"),
                Subfolder = reader.ReadValue<string>(prefix + "Application"),
                Flag = (ConfigurationFlags)(reader.ReadValue<int>(prefix + "Flag")),
                Skin = new SkinConfig
                {
                    TemplateFolder = reader.ReadValue<string>(prefix + "Skin"),
                    SkinStyleSheet = reader.ReadValue<string>(prefix + "SkinCssFile"),
                    CustomCssText = reader.ReadValue<string>(prefix + "SecondaryCss")
                },
                MobileSkin = new SkinConfig
                {
                    TemplateFolder = reader.ReadValue<string>(prefix + "MobileSkin"),
                    SkinStyleSheet = reader.ReadValue<string>(prefix + "MobileSkinCssFile")
                },
                OpenIdUrl = reader.ReadValue<string>(prefix + "OpenIdUrl"),
                OpenIdServer = reader.ReadValue<string>(prefix + "OpenIdServer"),
                OpenIdDelegate = reader.ReadValue<string>(prefix + "OpenIdDelegate"),
                CardSpaceHash = reader.ReadValue<string>(prefix + "CardSpaceHash"),
                LicenseUrl = reader.ReadValue<string>(prefix + "LicenseUrl"),
                DaysTillCommentsClose = reader.ReadValue(prefix + "DaysTillCommentsClose", int.MaxValue),
                CommentDelayInMinutes = reader.ReadValue<int>(prefix + "CommentDelayInMinutes"),
                NumberOfRecentComments = reader.ReadValue<int>(prefix + "NumberOfRecentComments"),
                RecentCommentsLength = reader.ReadValue<int>(prefix + "RecentCommentsLength"),
                FeedbackSpamServiceKey = reader.ReadValue<string>(prefix + "AkismetAPIKey"),
                RssProxyUrl = reader.ReadValue<string>(prefix + "FeedBurnerName"),
                BlogGroupId = reader.ReadValue<int>(prefix + "BlogGroupId"),
                BlogGroupTitle = reader.ReadValue<string>(prefix + "BlogGroupTitle")
            };
            return info;
        }

        public static ICollection<ArchiveCount> ReadArchiveCount(IDataReader reader)
        {
            const string dateformat = "{0:00}/{1:00}/{2:0000}";
            var acc = new Collection<ArchiveCount>();
            while(reader.Read())
            {
                var ac = new ArchiveCount();
                string dt = string.Format(CultureInfo.InvariantCulture,
                                          dateformat,
                                          reader.ReadValue<int>("Month"),
                                          reader.ReadValue<int>("Day"),
                                          reader.ReadValue<int>("Year"));
                // FIX: BUG SF1423271 Archives Links
                DateTime parsedDate;
                if(
                    !DateTime.TryParseExact(dt, "MM/dd/yyyy", CultureInfo.InvariantCulture, DateTimeStyles.AssumeLocal,
                                            out parsedDate))
                {
                    break;
                }

                ac.Date = parsedDate;
                ac.Count = reader.ReadValue<int>("Count");
                //TODO: This broke the unit tests: ac.Title = reader.ReadValue<string>("Title");
                //TODO: This broke the unit tests: ac.Id = reader.ReadValue<int>("Id");
                acc.Add(ac);
            }
            return acc;
        }

        public static Image ReadImage(this IDataReader reader)
        {
            return ReadImage(reader, false, false);
        }

        public static Image ReadImage(this IDataReader reader, bool includeBlog, bool includeCategory)
        {
            var image = reader.ReadObject<Image>("CategoryTitle", "LocalDirectoryPath");

            if(includeBlog)
            {
                image.Blog = reader.ReadBlog("Blog.");
            }
            if(includeCategory)
            {
                image.CategoryTitle = reader.ReadValue<string>("Category.Title");
            }
            return image;
        }

        public static IDictionary<string, int> ReadTags(IDataReader reader)
        {
            var tags = new SortedDictionary<string, int>();
            while(reader.Read())
            {
                tags.Add(
                    reader.ReadValue<string>("Name"),
                    reader.ReadValue<int>("TagCount"));
            }
            return tags;
        }

        private static bool IsExcluded(this IEnumerable<string> exclusionList, string propertyName)
        {
            return exclusionList.Any(excludedProperty => excludedProperty == propertyName);
        }

        private static bool IsReadablePropertyType(this Type t)
        {
            bool isReadable = t.IsPrimitive ||
                              t == typeof(DateTime) ||
                              t == typeof(string) ||
                              t == typeof(Uri);

            if(!isReadable)
            {
                //Maybe it's a nullable.
                Type underlyingType = Nullable.GetUnderlyingType(t);
                if(underlyingType != null)
                {
                    return IsReadablePropertyType(underlyingType);
                }
            }
            return isReadable;
        }

        /// <summary>
        /// Reads the string.
        /// </summary>
        /// <param name="reader">The reader.</param>
        /// <param name="columnName">Name of the coumn.</param>
        /// <returns></returns>
        public static IPAddress ReadIpAddress(this IDataReader reader, string columnName)
        {
            return reader.ReadValue(columnName, value => IPAddress.Parse((string)value), IPAddress.None);
        }

        /// <summary>
        /// Reads an URI from the database.
        /// </summary>
        /// <param name="reader"></param>
        /// <param name="columnName"></param>
        /// <returns></returns>
        public static Uri ReadUri(this IDataReader reader, string columnName)
        {
            return reader.ReadValue(columnName, value => new Uri((string)value), null);
        }

        public static SqlParameter MakeInParam(string paramName, object value)
        {
            return new SqlParameter(paramName, value);
        }

        /// <summary>
        /// Make input param.
        /// </summary>
        public static SqlParameter MakeOutParam(string paramName, SqlDbType dbType, int size)
        {
            return MakeParam(paramName, dbType, size, ParameterDirection.Output, null);
        }

        /// <summary>
        /// Make stored procedure param.
        /// </summary>
        public static SqlParameter MakeParam(string paramName, SqlDbType dbType, Int32 size,
                                             ParameterDirection direction, object value)
        {
            SqlParameter param = size > 0 ? new SqlParameter(paramName, dbType, size) : new SqlParameter(paramName, dbType);

            param.Direction = direction;
            if(!(direction == ParameterDirection.Output && value == null))
            {
                param.Value = value;
            }

            return param;
        }

        // Expects that the caller will dispose of the reader.
        public static ICollection<LinkCategory> ReadLinkCategories(this IDataReader reader, bool includeLinks)
        {
            var categories = reader.ReadEnumerable(r => r.ReadLinkCategory()).ToList();
            
            if(includeLinks && reader.NextResult())
            {
                var links = reader.ReadEnumerable(r => r.ReadObject<Link>());
                categories.Accumulate(links, category => category.Id, link => link.CategoryId, (category, link) => category.Links.Add(link));
            }

            return categories;
        }

        public static LinkCategory ReadLinkCategory(this IDataReader reader)
        {
            var lc = new LinkCategory(reader.ReadValue<int>("CategoryId"), reader.ReadValue<string>("Title")) { IsActive = (bool)reader["Active"] };
            if(reader["CategoryType"] != DBNull.Value)
            {
                lc.CategoryType = (CategoryType)((byte)reader["CategoryType"]);
            }
            if(reader["Description"] != DBNull.Value)
            {
                lc.Description = reader.ReadValue<string>("Description");
            }
            lc.BlogId = reader["BlogId"] != DBNull.Value ? reader.ReadValue<int>("BlogId") : Config.CurrentBlog.Id;
            return lc;
        }

        public static Enclosure ReadEnclosure(this IDataReader reader)
        {
            var enclosure = new Enclosure
            {
                Id = reader.ReadValue<int>("EnclosureId"),
                Title = reader.ReadValue<string>("EnclosureTitle"),
                Url = reader.ReadValue<string>("EnclosureUrl"),
                MimeType = reader.ReadValue<string>("EnclosureMimeType"),
                Size = reader.ReadValue<long>("EnclosureSize"),
                EntryId = reader.ReadValue<int>("ID"),
                AddToFeed = reader.ReadValue<bool>("AddToFeed"),
                ShowWithPost = reader.ReadValue<bool>("ShowWithPost")
            };

            return enclosure;
        }
    }

    /// <summary>
    /// Sort direction.
    /// </summary>
    public enum SortDirection
    {
        None = 0,
        /// <summary>Sort ascending</summary>
        Ascending,
        /// <summary>Sort descending</summary>
        Descending
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.Linq;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Configuration;
using Subtext.Framework.Text;

namespace Subtext.Framework.Data
{
    public partial class DatabaseObjectProvider
    {
        /// <summary>
        /// Returns a pageable collection of entries ordered by the id descending.
        /// This is used in the admin section.
        /// </summary>
        public override IPagedCollection<EntryStatsView> GetEntries(PostType postType, int? categoryId, int pageIndex, int pageSize)
        {
            using(IDataReader reader = _procedures.GetEntries(BlogId, categoryId, pageIndex, pageSize, (int)postType))
            {
                return reader.ReadPagedCollection(r => reader.ReadEntryStatsView());
            }
        }

        /// <summary>
        /// Gets the entries that meet the specific <see cref="PostType"/> 
        /// and the <see cref="PostConfig"/> flags.
        /// </summary>
        /// <remarks>
        /// This is called to get the main syndicated entries and supports MetaWeblog API.
        /// </remarks>
        /// <param name="itemCount">Item count.</param>
        /// <param name="postType">The type of post to retrieve.</param>
        /// <param name="postConfig">Post configuration options.</param>
        /// <param name="includeCategories">Whether or not to include categories</param>
        /// <returns></returns>
        public override ICollection<Entry> GetEntries(int itemCount, PostType postType, PostConfig postConfig, bool includeCategories)
        {
            using(IDataReader reader = _procedures.GetConditionalEntries(itemCount,
                (int)postType,
                (int)postConfig,
                BlogId,
                includeCategories,
                CurrentDateTime))
            {
                return reader.ReadEntryCollection();
            }
        }

        public override ICollection<Entry> GetEntriesByCategory(int itemCount, int categoryId, bool activeOnly)
        {
            using(IDataReader reader = _procedures.GetPostsByCategoryID(itemCount, categoryId, activeOnly, BlogId, CurrentDateTime))
            {
                return reader.ReadEntryCollection();
            }
        }

        public override ICollection<Entry> GetEntriesByTag(int itemCount, string tagName)
        {
            using(IDataReader reader = _procedures.GetPostsByTag(itemCount, tagName, BlogId, true, CurrentDateTime))
            {
                return reader.ReadEntryCollection();
            }
        }

        public override ICollection<EntryStatsView> GetPopularEntries(int blogId, DateFilter filter)
        {
            DateTime? minDate = null;
            if(filter == DateFilter.LastMonth)
            {
                minDate = CurrentDateTime.AddMonths(-1);
            }
            else if(filter == DateFilter.LastWeek)
            {
                minDate = CurrentDateTime.AddDays(-7);
            }
            else if (filter == DateFilter.LastYear)
            {
                minDate = CurrentDateTime.AddYears(-1);
            }

            using(IDataReader reader = _procedures.GetPopularPosts(BlogId, minDate))
            {
                return reader.ReadCollection(r =>
                    {
                        var entry = r.ReadEntryStatsView();
                        entry.PostType = PostType.BlogPost;
                        return entry;
                    });
            }
        }

        public override IPagedCollection<EntryStatsView> GetEntriesForExport(int pageIndex, int pageSize)
        {
            using(IDataReader reader = _procedures.GetEntriesForExport(BlogId, pageIndex, pageSize))
            {
                var entries = reader.ReadEntryCollection<EntryStatsView, IPagedCollection<EntryStatsView>>(r => r.ReadPagedCollection(innerReader => innerReader.ReadEntryStatsView()));
                if(reader.NextResult())
                {
                    var comments = reader.ReadEnumerable(r => r.ReadFeedbackItem());
                    entries.Accumulate(comments, entry => entry.Id, comment => comment.EntryId, 
                        (entry, comment) => { entry.Comments.Add(comment); comment.Entry = entry;});

                    if(reader.NextResult())
                    {
                        var trackBacks = reader.ReadEnumerable(r => r.ReadFeedbackItem());
                        entries.Accumulate(trackBacks, entry => entry.Id, trackback => trackback.EntryId,
                            (entry, trackback) => { entry.Comments.Add(trackback); trackback.Entry = entry; });
                    }
                }
                return entries;
            }
        }

        public override EntryDay GetEntryDay(DateTime dateTime)
        {
            using(IDataReader reader = _procedures.GetEntriesByDayRange(dateTime.Date, dateTime.Date.AddDays(1), (int)PostType.BlogPost, true, BlogId, CurrentDateTime))
            {
                var entryDay = new EntryDay(dateTime);
                while(reader.Read())
                {
                    entryDay.Add(reader.ReadEntry());
                }
                return entryDay;
            }
        }

        /// <summary>
        /// Returns the previous and next entry to the specified entry.
        /// </summary>
        /// <param name="entryId"></param>
        /// <returns></returns>
        /// <param name="postType"></param>
        public override ICollection<EntrySummary> GetPreviousAndNextEntries(int entryId, PostType postType)
        {
            using(IDataReader reader = _procedures.GetEntryPreviousNext(entryId, (int)postType, BlogId, CurrentDateTime))
            {
                return reader.ReadCollection<EntrySummary>();
            }
        }

        /// <summary>
        /// Returns the posts for the specified month for the Month Archive section.
        /// </summary>
        /// <param name="month"></param>
        /// <param name="year"></param>
        /// <returns></returns>
        public override ICollection<Entry> GetPostsByMonth(int month, int year)
        {
            using(IDataReader reader = _procedures.GetPostsByMonth(month, year, BlogId, CurrentDateTime))
            {
                return reader.ReadEntryCollection();
            }
        }

        public override ICollection<Entry> GetPostsByDayRange(DateTime start, DateTime stop, PostType postType, bool activeOnly)
        {
            DateTime min = start;
            DateTime max = stop;

            if(stop < start)
            {
                min = stop;
                max = start;
            }

            using(IDataReader reader = _procedures.GetEntriesByDayRange(min, max, (int)postType, activeOnly, BlogId, CurrentDateTime))
            {
                return reader.ReadEntryCollection();
            }
        }

        /// <summary>
        /// Returns an <see cref="Entry" /> with the specified id.
        /// </summary>
        /// <param name="id">Id of the entry</param>
        /// <param name="activeOnly">Whether or not to only return the entry if it is active.</param>
        /// <param name="includeCategories">Whether the entry should have its Categories property populated</param>
        /// <returns></returns>
        public override Entry GetEntry(int id, bool activeOnly, bool includeCategories)
        {
            using(IDataReader reader = _procedures.GetEntryReader(BlogId, id, activeOnly, includeCategories))
            {
                if(reader.Read())
                {
                    return DataHelper.ReadEntryWithCategories(reader);
                }
                return null;
            }
        }

        /// <summary>
        /// Returns an <see cref="Entry" /> with the specified entry name.
        /// </summary>
        /// <param name="entryName">Url friendly entry name.</param>
        /// <param name="activeOnly">Whether or not to only return the entry if it is active.</param>
        /// <param name="includeCategories">Whether the entry should have its Categories property populated</param>
        /// <returns></returns>
        public override Entry GetEntry(string entryName, bool activeOnly, bool includeCategories)
        {
            using(IDataReader reader = _procedures.GetEntryReader(BlogId,
                entryName,
                activeOnly,
                includeCategories))
            {
                if(reader.Read())
                {
                    return DataHelper.ReadEntryWithCategories(reader);
                }
                return null;
            }
        }

        /// <summary>
        /// Deletes the specified entry.
        /// </summary>
        /// <param name="entryId">The entry id.</param>
        /// <returns></returns>
        public override bool DeleteEntry(int entryId)
        {
            return _procedures.DeletePost(entryId, CurrentDateTime);
        }

        /// <summary>
        /// Creates the specified entry in the back end data store attaching 
        /// the specified category ids.
        /// </summary>
        /// <param name="entry">Entry.</param>
        /// <param name="categoryIds">Category I ds.</param>
        /// <returns></returns>
        public override int Create(Entry entry, IEnumerable<int> categoryIds)
        {
            ValidateEntry(entry);

            entry.Id = _procedures.InsertEntry(entry.Title
                , entry.Body.NullIfEmpty()
                , (int)entry.PostType
                , entry.Author.NullIfEmpty()
                , entry.Email.NullIfEmpty()
                , entry.Description.NullIfEmpty()
                , BlogId
                , entry.DateCreated
                , (int)entry.PostConfig
                , entry.EntryName.NullIfEmpty()
                , entry.DateSyndicated.NullIfEmpty()
                , CurrentDateTime);

            if(categoryIds != null)
            {
                SetEntryCategoryList(entry.Id, categoryIds);
            }

            if(entry.Id > -1)
            {
                Config.CurrentBlog.LastUpdated = entry.DateCreated;
            }

            return entry.Id;
        }

        /// <summary>
        /// Saves the categories for the specified post.
        /// </summary>
        public override bool SetEntryCategoryList(int entryId, IEnumerable<int> categoryIds)
        {
            if(categoryIds == null)
            {
                return _procedures.InsertLinkCategoryList(string.Empty, entryId, BlogId);
            }

            var idsAsStrings = categoryIds.Select(id => id.ToString(CultureInfo.InvariantCulture));
            string catList = string.Join(",", idsAsStrings.ToArray());

            return _procedures.InsertLinkCategoryList(catList, entryId, BlogId);
        }

        /// <summary>
        /// Saves the tags for the specified post
        /// </summary>
        /// <param name="postId">The EntryId for the post to update</param>
        /// <param name="tags">
        /// An array of tag strings for the associated post. If there are no tags
        /// associated with the post, pass tags with length zero to remove post tags
        /// if present.
        /// </param>
        /// <returns></returns>
        public override bool SetEntryTagList(int postId, IEnumerable<string> tags)
        {
            if(tags == null)
                throw new ArgumentNullException("tags");

            string tagList = "";
            foreach(string tag in tags)
            {
                tagList += tag + ",";
            }
            if(tagList.Length > 0)
                tagList = tagList.Substring(0, tagList.Length - 1);

            return _procedures.InsertEntryTagList(postId, BlogId, tagList);
        }

        /// <summary>
        /// Saves changes to the specified entry attaching the specified categories.
        /// </summary>
        /// <param name="entry">Entry.</param>
        /// <param name="categoryIds">Category Ids.</param>
        /// <returns></returns>
        public override bool Update(Entry entry, IEnumerable<int> categoryIds)
        {
            ValidateEntry(entry);

            if(entry.IsActive && NullValue.IsNull(entry.DateSyndicated))
            {
                entry.DateSyndicated = CurrentDateTime;
            }

            bool updated = _procedures.UpdateEntry(
                entry.Id
                , entry.Title ?? string.Empty
                , entry.Body.NullIfEmpty()
                , (int)entry.PostType
                , entry.Author.NullIfEmpty()
                , entry.Email.NullIfEmpty()
                , entry.Description.NullIfEmpty()
                , entry.DateModified
                , (int)entry.PostConfig
                , entry.EntryName.NullIfEmpty()
                , entry.DateSyndicated.NullIfEmpty()
                , BlogId
                , CurrentDateTime);

            if(!updated)
            {
                return false;
            }

            if(!categoryIds.IsNullOrEmpty())
            {
                SetEntryCategoryList(entry.Id, categoryIds);
            }

            if(Config.Settings.Tracking.UseTrackingServices)
            {
                if(entry.Id > -1)
                {
                    Config.CurrentBlog.LastUpdated = entry.DateModified;
                }
            }
            return true;
        }

        public override ICollection<ArchiveCount> GetPostCountsByMonth()
        {
            using(IDataReader reader = _procedures.GetPostsByMonthArchive(BlogId, CurrentDateTime))
            {
                ICollection<ArchiveCount> acc = DataHelper.ReadArchiveCount(reader);
                return acc;
            }
        }

        public override ICollection<ArchiveCount> GetPostCountsByYear()
        {
            using(IDataReader reader = _procedures.GetPostsByYearArchive(BlogId, CurrentDateTime))
            {
                ICollection<ArchiveCount> acc = DataHelper.ReadArchiveCount(reader);
                return acc;
            }
        }

        public override ICollection<ArchiveCount> GetPostCountsByCategory()
        {
            using(IDataReader reader = _procedures.GetPostsByCategoriesArchive(BlogId))
            {
                ICollection<ArchiveCount> acc = DataHelper.ReadArchiveCount(reader);
                return acc;
            }
        }
    }
}
using System;
using System.Collections.Generic;
using System.Data;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Text;

namespace Subtext.Framework.Data
{
    public partial class DatabaseObjectProvider
    {
        /// <summary>
        /// Returns the feedback by id.
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public override FeedbackItem GetFeedback(int id)
        {
            using (IDataReader reader = _procedures.GetFeedback(id))
            {
                if (reader.Read())
                {
                    return reader.ReadFeedbackItem();
                }
            }
            return null;
        }

        /// <summary>
        /// Gets the feedback counts for the various top level statuses.
        /// </summary>
        /// <param name="approved">The approved.</param>
        /// <param name="needsModeration">The needs moderation.</param>
        /// <param name="flaggedAsSpam">The flagged as spam.</param>
        /// <param name="deleted">The deleted.</param>
        public override void GetFeedbackCounts(out int approved, out int needsModeration, out int flaggedAsSpam, out int deleted)
        {
            _procedures.GetFeedbackCountsByStatus(BlogId, out approved, out needsModeration, out flaggedAsSpam, out deleted);
        }

        /// <summary>
        /// Gets the paged feedback.
        /// </summary>
        /// <param name="pageIndex">Index of the page.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <param name="status">A flag for the status types to return.</param>
        /// <param name="excludeStatusMask">A flag for the statuses to exclude.</param>
        /// <param name="type">The type of feedback to return.</param>
        /// <returns></returns>
        public override IPagedCollection<FeedbackItem> GetPagedFeedback(int pageIndex, int pageSize, FeedbackStatusFlag status, FeedbackStatusFlag excludeStatusMask, FeedbackType type)
        {
            int? feedbackType = (type == FeedbackType.None ? null : (int?)type);
            int? excludeStatus = (excludeStatusMask == FeedbackStatusFlag.None ? null : (int?)excludeStatusMask);
            using (IDataReader reader = _procedures.GetPageableFeedback(BlogId, pageIndex, pageSize, (int)status, excludeStatus, feedbackType))
            {
                return reader.ReadPagedCollection(r => reader.ReadFeedbackItem());
            }
        }

        /// <summary>
        /// Returns all the active entries for the specified post.
        /// </summary>
        /// <param name="parentEntry"></param>
        /// <returns></returns>
        public override ICollection<FeedbackItem> GetFeedbackForEntry(Entry parentEntry)
        {
            using (IDataReader reader = _procedures.GetFeedbackCollection(parentEntry.Id))
            {
                return reader.ReadCollection(r => r.ReadFeedbackItem(parentEntry));
            }
        }

        /// <summary>
        /// Searches the data store for the first comment with a 
        /// matching checksum hash.
        /// </summary>
        /// <param name="checksumHash">Checksum hash.</param>
        /// <returns></returns>
        //TODO: This needs a unit test.
        public override FeedbackItem GetFeedbackByChecksumHash(string checksumHash)
        {
            using (IDataReader reader = _procedures.GetCommentByChecksumHash(checksumHash, BlogId))
            {
                if (reader.Read())
                {
                    return reader.ReadFeedbackItem();
                }
                return null;
            }
        }

        public override void DestroyFeedback(int id)
        {
            _procedures.DeleteFeedback(id, CurrentDateTime);
        }

        public override void DestroyFeedback(FeedbackStatusFlag status)
        {
            _procedures.DeleteFeedbackByStatus(BlogId, (int)status);
        }

        public override int Create(FeedbackItem feedbackItem)
        {
            if (feedbackItem == null)
                throw new ArgumentNullException("feedbackItem");

            string ipAddress = null;
            if (feedbackItem.IpAddress != null)
                ipAddress = feedbackItem.IpAddress.ToString();

            string sourceUrl = null;
            if (feedbackItem.SourceUrl != null)
                sourceUrl = feedbackItem.SourceUrl.ToString();

            return _procedures.InsertFeedback(feedbackItem.Title,
                feedbackItem.Body,
                BlogId,
                feedbackItem.EntryId.NullIfMinValue(),
                feedbackItem.Author,
                feedbackItem.IsBlogAuthor,
                feedbackItem.Email,
                sourceUrl,
                (int)feedbackItem.FeedbackType,
                (int)feedbackItem.Status,
                feedbackItem.CreatedViaCommentApi,
                feedbackItem.Referrer,
                ipAddress,
                feedbackItem.UserAgent,
                feedbackItem.ChecksumHash,
                feedbackItem.DateCreated,
                feedbackItem.DateModified,
                CurrentDateTime);
        }

        /// <summary>
        /// Saves changes to the specified feedback.
        /// </summary>
        /// <param name="feedbackItem">The feedback item.</param>
        /// <returns></returns>
        public override bool Update(FeedbackItem feedbackItem)
        {
            string sourceUrl = null;
            if (feedbackItem.SourceUrl != null)
                sourceUrl = feedbackItem.SourceUrl.ToString();

            return _procedures.UpdateFeedback(feedbackItem.Id,
                feedbackItem.Title,
                feedbackItem.Body.NullIfEmpty(),
                feedbackItem.Author.NullIfEmpty(),
                feedbackItem.Email.NullIfEmpty(),
                sourceUrl,
                (int)feedbackItem.Status,
                feedbackItem.ChecksumHash,
                CurrentDateTime,
                CurrentDateTime);
        }
    }
}
﻿#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using Subtext.Extensibility;
using Subtext.Framework.Components;
using Subtext.Framework.Text;

namespace Subtext.Framework.Data
{
    public partial class DatabaseObjectProvider
    {
        /// <summary>
        /// Returns the <see cref="HostInfo"/> for the Subtext installation.
        /// </summary>
        /// <returns>A <see cref="HostInfo"/> instance.</returns>
        public override HostInfo LoadHostInfo(HostInfo hostInfo)
        {
            try
            {
                using (IDataReader reader = _procedures.GetHost())
                {
                    if (reader.Read())
                    {
                        return reader.ReadObject(hostInfo);
                    }
                }
            }
            catch (IndexOutOfRangeException)
            {
                //When upgrading, this may occur because the old version of the 
                //database schema doesn't know about new properties.
                return new HostInfo();
            }
            return null;
        }

        /// <summary>
        /// Updates the <see cref="HostInfo"/> instance.  If the host record is not in the 
        /// database, one is created. There should only be one host record.
        /// </summary>
        /// <param name="host">The host information.</param>
        public override bool UpdateHost(HostInfo host)
        {
            return _procedures.UpdateHost(host.HostUserName, host.Password, host.Salt, host.Email);
        }

        /// <summary>
        /// Clears all content (Entries, Comments, Track/Ping-backs, Statistices, etc...) 
        /// for a the current blog (sans the Image Galleries).
        /// </summary>
        /// <returns>
        ///     TRUE - At least one unit of content was cleared.
        ///     FALSE - No content was cleared.
        /// </returns>
        public override void ClearBlogContent(int blogId)
        {
            _procedures.ClearBlogContent(blogId);
        }

        /// <summary>
        /// Inserts the blog group.
        /// </summary>
        /// <param name="blogGroup">The group to insert.</param>
        /// <returns>The blog group id</returns>
        public override int InsertBlogGroup(BlogGroup blogGroup)
        {
            return _procedures.InsertBlogGroup(blogGroup.Title,
                blogGroup.IsActive,
                blogGroup.DisplayOrder.NullIfMinValue(),
                blogGroup.Description.NullIfEmpty());
        }

        /// <summary>
        /// Inserts the blog group.
        /// </summary>
        /// <param name="blogGroup">The group to insert.</param>
        /// <returns>The blog group id</returns>
        public override bool UpdateBlogGroup(BlogGroup blogGroup)
        {
            return _procedures.UpdateBlogGroup(blogGroup.Id,
                blogGroup.Title,
                blogGroup.IsActive,
                blogGroup.Description.NullIfEmpty(),
                blogGroup.DisplayOrder.NullIfMinValue());
        }

        public override bool DeleteBlogGroup(int blogGroupId)
        {
            return _procedures.DeleteBlogGroup(blogGroupId);
        }

        public override ICollection<Blog> GetBlogsByGroup(string host, int? groupId)
        {
            using (var reader = _procedures.Stats(host, groupId))
            {
                return reader.ReadCollection(r => r.ReadBlog());
            }
        }

        /// <summary>
        /// Given a list of blogs, groups blogs
        /// </summary>
        /// <param name="blogs"></param>
        /// <returns></returns>
        public override ICollection<BlogGroup> GroupBlogs(IEnumerable<Blog> blogs)
        {
            return blogs.GroupBy(blog => blog.BlogGroupId,
                (blogGroupId, blogsInGroup) => new BlogGroup
                {
                    Blogs = blogsInGroup.ToList(),
                    Title = blogs.First(b => b.BlogGroupId == blogGroupId).BlogGroupTitle
                })
                .ToList();
        }

        public override HostStats GetTotalBlogStats(string host, int? groupId)
        {
            using (IDataReader reader = _procedures.TotalStats(host, groupId))
            {
                if (!reader.Read())
                {
                    return null;
                }
                return reader.ReadObject<HostStats>();
            }
        }

        public override ICollection<Entry> GetRecentEntries(string host, int? groupId, int rowCount)
        {
            using (IDataReader reader = _procedures.GetRecentPosts(host, groupId, CurrentDateTime, rowCount))
            {
                return reader.ReadCollection(r => r.ReadEntry(new Entry(PostType.BlogPost), false /* buildLinks */, true /* includeBlog */));
            }
        }

        public override ICollection<Image> GetImages(string host, int? groupId, int rowCount)
        {
            using (IDataReader reader = _procedures.GetRecentImages(host, groupId, rowCount))
            {
                return reader.ReadCollection(r => r.ReadImage(true /* includeBlog */, true/* includeCategory */));
            }
        }
    }
}
#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System.Collections.Generic;
using System.Data;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;

namespace Subtext.Framework.Data
{
    public partial class DatabaseObjectProvider
    {
        public override IPagedCollection<Link> GetPagedLinks(int? categoryId, int pageIndex, int pageSize, bool sortDescending)
        {
            //TODO: Update proc to allow for sort parameter.
            using (IDataReader reader = _procedures.GetPageableLinks(BlogId, categoryId, pageIndex, pageSize))
            {
                return reader.ReadPagedCollection(r => reader.ReadObject<Link>());
            }
        }

        public override ICollection<Link> GetLinkCollectionByPostId(int postId)
        {
            using (IDataReader reader = _procedures.GetLinkCollectionByPostID(postId, BlogId))
            {
                return reader.ReadCollection<Link>();
            }
        }

        public override Link GetLink(int linkId)
        {
            using (IDataReader reader = _procedures.GetSingleLink(linkId, BlogId))
            {
                Link link = null;
                while (reader.Read())
                {
                    link = reader.ReadObject<Link>();
                    break;
                }
                return link;
            }
        }

        /// <summary>
        /// Gets the categories for the specified category type.
        /// </summary>
        /// <param name="catType">Type of the cat.</param>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public override ICollection<LinkCategory> GetCategories(CategoryType catType, bool activeOnly)
        {
            using (IDataReader reader = _procedures.GetCategory(null, null, activeOnly, BlogId, (int)catType))
            {
                return reader.ReadCollection(r => r.ReadLinkCategory());
            }
        }

        /// <summary>
        /// Gets the link category for the specified category id.
        /// </summary>
        /// <param name="categoryId">The category id.</param>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public override LinkCategory GetLinkCategory(int? categoryId, bool activeOnly)
        {
            using (IDataReader reader = _procedures.GetCategory(null, categoryId, activeOnly, BlogId, null))
            {
                return ReadLinkCategory(reader);
            }
        }

        /// <summary>
        /// Gets the link category for the specified category name.
        /// </summary>
        /// <param name="categoryName">The category name.</param>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public override LinkCategory GetLinkCategory(string categoryName, bool activeOnly)
        {
            using (IDataReader reader = _procedures.GetCategory(categoryName, null, activeOnly, BlogId, null))
            {
                return ReadLinkCategory(reader);
            }
        }

        public override int CreateLink(Link link)
        {
            int linkId = _procedures.InsertLink(link.Title,
                link.Url,
                link.Rss ?? string.Empty,
                link.IsActive,
                link.NewWindow,
                link.CategoryId,
                link.PostId.NullIfMinValue(),
                BlogId,
                link.Relation);
            link.Id = linkId;
            return linkId;
        }

        public override bool UpdateLink(Link link)
        {
            return _procedures.UpdateLink(link.Id,
                link.Title,
                link.Url,
                link.Rss ?? string.Empty,
                link.IsActive,
                link.NewWindow,
                link.CategoryId,
                link.Relation,
                BlogId);
        }

        public override bool UpdateLinkCategory(LinkCategory category)
        {
            return _procedures.UpdateCategory(category.Id,
                category.Title,
                category.IsActive,
                (int)category.CategoryType,
                category.Description ?? string.Empty,
                BlogId);
        }

        public override int CreateLinkCategory(LinkCategory lc)
        {
            return _procedures.InsertCategory(lc.Title,
                lc.IsActive,
                BlogId,
                (int)lc.CategoryType,
                lc.Description ?? string.Empty);
        }

        public override bool DeleteLinkCategory(int categoryId)
        {
            return _procedures.DeleteCategory(categoryId, BlogId);
        }

        public override bool DeleteLink(int linkId)
        {
            return _procedures.DeleteLink(linkId, BlogId);
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Linq;
using Subtext.Extensibility;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;

namespace Subtext.Framework.Data
{
    public static class RepositoryExtensions
    {
        public static IEnumerable<EntryDay> GetBlogPostsByCategoryGroupedByDay(this ObjectProvider repository, int itemCount, int categoryId)
        {
            return repository.GetEntriesByCategory(itemCount, categoryId, true /*activeOnly*/).GroupByDayUsingDateCreated();
        }

        public static IEnumerable<EntryDay> GetBlogPostsForHomePage(this ObjectProvider repository, int itemCount, PostConfig postConfig)
        {
            return repository.GetEntries(itemCount, PostType.BlogPost, postConfig, false /*includeCategories*/).GroupByDayUsingDateCreated();
        }

        public static IEnumerable<EntryDay> GroupByDayUsingDateCreated(this IEnumerable<Entry> entries)
        {
            var groupedEntries = 
                    from entry in entries
                    group entry by entry.DateCreated.Date
                    into entriesGroupedByDay
                        select entriesGroupedByDay;
            foreach(var group in groupedEntries)
            {
                yield return new EntryDay(group.Key, group.ToList());
            }
        }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Data
{
    /// <summary>
    /// Provides constants for the common SQL messages as 
    /// listed in master.dbo.sysmessages.
    /// </summary>
    public enum SqlErrorMessage
    {
        /// <summary>
        /// Specified SQL server not found:
        /// </summary>
        SpecifiedSqlServerNotFound = 6,

        /// <summary>
        /// Sql Server does not exist or access denied.
        /// </summary>
        /// <remarks>
        /// Did not find this error in sysmessages, but did get it via 
        /// exception logging.
        /// </remarks>
        SqlServerDoesNotExistOrAccessDenied = 17,

        /// <summary>
        /// Permission is denied on an object.
        /// </summary>
        PermissionDeniedInOnObject = 229,

        /// <summary>
        /// Permission is denied on column.
        /// </summary>
        PermissionDeniedInOnColumn = 230,

        /// <summary>
        /// Permission is denied in the database.
        /// </summary>
        PermissionDeniedInDatabase = 262,

        /// <summary>
        /// Could not find the stored procedure.
        /// </summary>
        CouldNotFindStoredProcedure = 2812,

        /// <summary>
        /// User does not have permission to perform this operation on procedure.
        /// </summary>
        PermissionDeniedOnProcedure = 3704,

        /// <summary>
        /// Cannot open database requested in login '%.*ls'. Login fails.
        /// </summary>
        LoginFailsCannotOpenDatabase = 4060,

        /// <summary>
        /// Login failed for user '%ls'. Reason: Not defined as a valid user 
        /// of a trusted SQL Server connection.
        /// </summary>
        LoginFailedInvalidUserOfTrustedConnection = 18450,

        /// <summary>
        /// Login failed for user '%ls'. Reason: Not associated with a 
        /// trusted SQL Server connection.
        /// </summary>
        LoginFailedNotAssociatedWithTrustedConnection = 18452,

        /// <summary>
        /// Login failed for user '%ls'.
        /// </summary>
        LoginFailed = 18456,

        /// <summary>
        /// Login failed for user '%ls'. Reason: User name contains a 
        /// mapping character or is longer than 30 characters.
        /// </summary>
        LoginFailedUserNameInvalid = 18457,
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using log4net;
using Microsoft.ApplicationBlocks.Data;
using Subtext.Framework.Configuration;
using Subtext.Framework.Logging;

namespace Subtext.Framework.Data
{
    public partial class StoredProcedures
    {
        private readonly static ILog Log = new Log();
        
        public StoredProcedures(string connectionString)
        {
            ConnectionString = connectionString;
        }

        public StoredProcedures(SqlTransaction transaction)
        {
            _transaction = transaction;
        }

        private readonly SqlTransaction _transaction;

        private IDataReader GetReader(string sql)
        {
            return ExecuteQueryAndLogError((sqlStatement, sqlParams) =>
                SqlHelper.ExecuteReader(ConnectionString, CommandType.StoredProcedure, sqlStatement), sql, null);

        }

        private IDataReader GetReader(string sql, SqlParameter[] parameters)
        {
            return ExecuteQueryAndLogError((sqlStatement, sqlParams) => 
                SqlHelper.ExecuteReader(ConnectionString, CommandType.StoredProcedure, sqlStatement, sqlParams), sql, parameters);
        }

        private int NonQueryInt(string sql, SqlParameter[] parameters)
        {
            var transaction = _transaction;
            return ExecuteQueryAndLogError((sqlStatement, sqlParams) => 
            {
                if(transaction != null)
                {
                    return SqlHelper.ExecuteNonQuery(transaction, CommandType.StoredProcedure, sqlStatement, sqlParams);
                }
                return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, sqlStatement, sqlParams);
            }, sql, parameters);
        }

        private static TResult ExecuteQueryAndLogError<TResult>(Func<string, SqlParameter[], TResult> query, string sql, SqlParameter[] parameters)
        {
            try
            {
                return query(sql, parameters);
            }
            catch(Exception)
            {
                LogSqlStatement(sql, parameters);
                throw; // Let the caller determine how to handle the exception.
            }
        }

        private static void LogSqlStatement(string sql, IEnumerable<SqlParameter> parameters)
        {
            string sqlStatement = sql;
            if(parameters != null)
            {
                sqlStatement += " ";
                foreach(var parameter in parameters)
                {
                    sqlStatement += parameter.ParameterName + "=" + parameter.Value + ", ";
                }
            }
            Log.Error("Error executing SQL: " + sqlStatement);
        }

        private bool NonQueryBool(string sql, SqlParameter[] p)
        {
            return NonQueryInt(sql, p) > 0;
        }

        /// <summary>
        /// Gets or sets the connection string.
        /// </summary>
        /// <value></value>
        protected string ConnectionString {
            get; 
            set;
        }

        /// <summary>
        /// Returns a Data Reader pointing to the entry specified by the entry name.
        /// Only returns entries for the current blog (Config.CurrentBlog).
        /// </summary>
        public virtual IDataReader GetEntryReader(int blogId, string entryName, bool activeOnly, bool includeCategories)
        {
            int? blogIdentifier = (blogId == NullValue.NullInt32 ? null : (int?)blogId);
            return GetSingleEntry(null, entryName, activeOnly, blogIdentifier, includeCategories);
        }

        /// <summary>
        /// Returns a Data Reader pointing to the entry specified by the entry id. 
        /// Only returns entries for the current blog (Config.CurrentBlog).
        /// </summary>
        public virtual IDataReader GetEntryReader(int blogId, int id, bool activeOnly, bool includeCategories)
        {
            int? blogIdentifier = (blogId == NullValue.NullInt32 ? null : (int?)blogId);
            return GetSingleEntry(id, null, activeOnly, blogIdentifier, includeCategories);
        }

        /// <summary>
        /// Returns a Data Reader pointing to the active entry specified by the entry id no matter 
        /// which blog it belongs to.
        /// </summary>
        /// <param name="id"></param>
        /// <param name="includeCategories"></param>
        /// <returns></returns>
        public virtual IDataReader GetEntryReader(int id, bool includeCategories)
        {
            return GetSingleEntry(id, null, true, null, includeCategories);
        }

        /// <summary>
        /// Returns a list of all the blogs within the specified range.
        /// </summary>
        /// <param name="host">The hostname for this blog.</param>
        /// <param name="pageIndex">Page index.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <param name="flags">Flags for type of retrieval.</param>
        /// <returns></returns>
        public virtual IDataReader GetPagedBlogs(string host, int pageIndex, int pageSize, ConfigurationFlags flags)
        {
            try
            {
                return GetPageableBlogs(pageIndex, pageSize, host, (int)flags);
            }
            catch(SqlException)
            {
                SqlParameter[] p = {
                                       DataHelper.MakeInParam("@PageIndex", pageIndex),
                                       DataHelper.MakeInParam("@PageSize", pageSize),
                                       DataHelper.MakeInParam("@SortDesc", 0),
                                   };
                return GetReader("subtext_GetPageableBlogs", p);
            }
        }
    }
}﻿#region Disclaimer/Info
///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////
#endregion

using System.Collections.Generic;
using System.Data;

namespace Subtext.Framework.Data
{
    public partial class DatabaseObjectProvider
    {
        public override IDictionary<string, int> GetTopTags(int itemCount)
        {
            using (IDataReader reader = _procedures.GetTopTags(itemCount, BlogId))
            {
                IDictionary<string, int> tags = DataHelper.ReadTags(reader);
                return tags;
            }
        }

    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;
using Subtext.Framework.Routing;

namespace Subtext.Framework.Data
{
    /// <summary>
    /// Common Subtext object transformations
    /// </summary>
    public static class Transformer
    {
        /// <summary>
        /// Converts a LinkCategoryCollection into a single LinkCategory with its own LinkCollection.
        /// </summary>
        public static LinkCategory BuildLinks(string title, CategoryType catType, Blog blog, UrlHelper urlHelper)
        {
            ICollection<LinkCategory> links = ObjectProvider.Instance().GetCategories(catType, true /* activeOnly */);
            return MergeLinkCategoriesIntoSingleLinkCategory(title, catType, links, urlHelper, blog);
        }

        /// <summary>
        /// Converts a LinkCategoryCollection into a single LinkCategory with its own LinkCollection.
        /// </summary>
        public static LinkCategory MergeLinkCategoriesIntoSingleLinkCategory(string title, CategoryType catType,
                                                                             IEnumerable<LinkCategory> links,
                                                                             UrlHelper urlHelper, Blog blog)
        {
            if(!links.IsNullOrEmpty())
            {
                var mergedLinkCategory = new LinkCategory {Title = title};

                var merged = from linkCategory in links
                            select GetLinkFromLinkCategory(linkCategory, catType, urlHelper, blog);
                mergedLinkCategory.Links.AddRange(merged);
                return mergedLinkCategory;
            }

            return null;
        }

        private static Link GetLinkFromLinkCategory(LinkCategory linkCategory, CategoryType catType, UrlHelper urlHelper, Blog blog)
        {
            var link = new Link {Title = linkCategory.Title};

            switch(catType)
            {
                case CategoryType.StoryCollection:
                    link.Url = urlHelper.CategoryUrl(linkCategory).ToFullyQualifiedUrl(blog).ToString();
                    break;

                case CategoryType.PostCollection:
                    link.Url = urlHelper.CategoryUrl(linkCategory).ToFullyQualifiedUrl(blog).ToString();
                    link.Rss = urlHelper.CategoryRssUrl(linkCategory);
                    break;

                case CategoryType.ImageCollection:
                    link.Url = urlHelper.GalleryUrl(linkCategory.Id).ToFullyQualifiedUrl(blog).ToString();
                    break;
            }
            link.NewWindow = false;
            return link;
        }

        /// <summary>
        /// Will convert ArchiveCountCollection method from Archives.GetPostsByMonthArchive()
        /// into a <see cref="LinkCategory"/>. LinkCategory is a common item to databind to a web control.
        /// </summary>
        public static LinkCategory BuildMonthLinks(string title, UrlHelper urlHelper, Blog blog)
        {
            ICollection<ArchiveCount> archiveCounts = ObjectProvider.Instance().GetPostCountsByMonth();
            return MergeArchiveCountsIntoLinkCategory(title, archiveCounts, urlHelper, blog);
        }

        public static LinkCategory MergeArchiveCountsIntoLinkCategory(string title,
                                                                      IEnumerable<ArchiveCount> archiveCounts,
                                                                      UrlHelper urlHelper, Blog blog)
        {
            var linkCategory = new LinkCategory {Title = title};
            foreach(ArchiveCount archiveCount in archiveCounts)
            {
                var link = new Link
                {
                    NewWindow = false,
                    IsActive = true,
                    Title = archiveCount.Date.ToString("y") + " (" +
                            archiveCount.Count.ToString(CultureInfo.InvariantCulture) + ")",
                    Url = urlHelper.MonthUrl(archiveCount.Date)
                };

                linkCategory.Links.Add(link);
            }
            return linkCategory;
        }

        /// <summary>
        /// Will convert ArchiveCountCollection method from Archives.GetPostsByCategoryArchive()
        /// into a <see cref="LinkCategory"/>. LinkCategory is a common item to databind to a web control.
        /// </summary>
        public static LinkCategory BuildCategoriesArchiveLinks(string title, UrlHelper urlHelper)
        {
            ICollection<ArchiveCount> acc = Archives.GetPostCountByCategory();

            var category = new LinkCategory {Title = title};
            foreach(ArchiveCount ac in acc)
            {
                var link = new Link
                {
                    IsActive = true,
                    NewWindow = false,
                    Title = string.Format("{0} ({1})", ac.Title, ac.Count.ToString(CultureInfo.InvariantCulture)),
                    Url = urlHelper.CategoryUrl(new Category {Id = ac.Id, Title = ac.Title})
                };
                //Ugh, I hate how categories work in Subtext. So intertwined with links.

                category.Links.Add(link);
            }
            return category;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework
{
    public enum DateFilter
    {
        None = 0,
        LastWeek = 1,
        LastMonth = 2,
        LastYear = 3,
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using System.IO;
using Subtext.Framework.Properties;

namespace Subtext.Framework
{
    /// <summary>
    /// Class used for helping with date times.
    /// </summary>
    public static class DateTimeHelper
    {
        /// <summary>
        /// Tries to parse the date given in an unknown format. Returns 
        /// NullValue.NullDateTime if it cannot.
        /// </summary>
        /// <param name="dateTime">The date time.</param>
        /// <returns></returns>
        public static DateTime ParseUnknownFormatUtc(string dateTime)
        {
            DateTime dt = NullValue.NullDateTime;
            try
            {
                return DateTime.Parse(dateTime, CultureInfo.InvariantCulture, DateTimeStyles.AdjustToUniversal);
            }
            catch(FormatException)
            {
            }

            string[] formats = {"r", "s", "u", "yyyyMMddTHHmmss"};

            foreach(string dateFormat in formats)
            {
                try
                {
                    return DateTime.ParseExact(dateTime, dateFormat, CultureInfo.InvariantCulture,
                                               DateTimeStyles.AdjustToUniversal);
                }
                catch(FormatException)
                {
                }
            }
            return dt;
        }

        /// <summary>
        /// Returns a <see cref="DateTime"/> instance parsed from the url.
        /// </summary>
        /// <param name="url">URL.</param>
        /// <returns></returns>
        public static DateTime DateFromUrl(string url)
        {
            string date = Path.GetFileNameWithoutExtension(url);
            var en = new CultureInfo("en-US");
            switch(date.Length)
            {
                case 8:
                    return DateTime.ParseExact(date, "MMddyyyy", en);
                case 6:
                    return DateTime.ParseExact(date, "MMyyyy", en);
                default:
                    throw new InvalidOperationException(Resources.InvalidOperation_InvalidDateFormat);
            }
        }
    }
}using System.Collections.Generic;

namespace Subtext.Framework
{
    public static class DictionaryExtensions
    {
        public static TValue ItemOrNull<TKey, TValue>(this IDictionary<TKey, TValue> dictionary, TKey key)
        {
            TValue value;
            if(!dictionary.TryGetValue(key, out value))
            {
                return default(TValue);
            }
            return value;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;

namespace Subtext.Framework
{
    public static class Enclosures
    {
        public static int Create(Enclosure enclosure)
        {
            if(enclosure == null)
            {
                throw new ArgumentNullException("enclosure");
            }

            if(!enclosure.IsValid)
            {
                throw new ArgumentException(enclosure.ValidationMessage);
            }

            enclosure.Id = ObjectProvider.Instance().Create(enclosure);

            return enclosure.Id;
        }

        public static bool Update(Enclosure enclosure)
        {
            if(enclosure == null)
            {
                throw new ArgumentNullException("enclosure");
            }

            if(!enclosure.IsValid)
            {
                throw new ArgumentException(enclosure.ValidationMessage);
            }

            return ObjectProvider.Instance().Update(enclosure);
        }

        public static bool Delete(int enclosureId)
        {
            return ObjectProvider.Instance().DeleteEnclosure(enclosureId);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using Subtext.Extensibility;
using Subtext.Framework.Components;
using Subtext.Framework.Data;
using Subtext.Framework.Providers;
using Subtext.Framework.Text;

namespace Subtext.Framework
{
    /// <summary>
    /// Static class used to get entries (blog posts, comments, etc...) 
    /// from the data store.
    /// </summary>
    public static class Entries
    {
        public static void RebuildAllTags(this ObjectProvider repository)
        {
            foreach(var day in repository.GetBlogPostsForHomePage(0, PostConfig.None))
            {
                foreach(var entry in day)
                {
                    repository.SetEntryTagList(entry.Id, entry.Body.ParseTags());
                }
            }
        }

        /// <summary>
        /// Gets the main syndicated entries.
        /// </summary>
        public static ICollection<Entry> GetMainSyndicationEntries(this ObjectProvider repository, int itemCount)
        {
            return repository.GetEntries(itemCount, PostType.BlogPost, PostConfig.IncludeInMainSyndication | PostConfig.IsActive, true /* includeCategories */);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Base exception class for blog configuration errors.
    /// </summary>
    [Serializable]
    public abstract class BaseBlogConfigurationException : Exception
    {
        /// <summary>
        /// Creates a new <see cref="BaseBlogConfigurationException"/> instance.
        /// </summary>
        protected BaseBlogConfigurationException()
        {
        }

        /// <summary>
        /// Creates a new <see cref="BaseBlogConfigurationException"/> instance.
        /// </summary>
        /// <param name="innerException">Inner exception.</param>
        protected BaseBlogConfigurationException(Exception innerException) : base(null, innerException)
        {
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Base exception class for comment errors.
    /// </summary>
    [Serializable]
    public abstract class BaseCommentException : Exception
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CommentSpamException"/> class.
        /// </summary>
        protected BaseCommentException()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CommentSpamException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        protected BaseCommentException(string message) : base(message)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CommentSpamException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        /// <param name="innerException">The inner exception.</param>
        protected BaseCommentException(string message, Exception innerException) : base(message, innerException)
        {
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when trying to add a blog that 
    /// duplicates another blog in both host and application.
    /// </summary>
    [Serializable]
    public class BlogDuplicationException : BaseBlogConfigurationException
    {
        readonly int _blogId = NullValue.NullInt32;

        readonly Blog _duplicateBlog;

        /// <summary>
        /// Creates a new <see cref="BlogDuplicationException"/> instance.
        /// </summary>
        /// <param name="duplicate">Duplicate.</param>
        public BlogDuplicationException(Blog duplicate) : this(duplicate, NullValue.NullInt32)
        {
        }

        /// <summary>
        /// Creates a new <see cref="BlogDuplicationException"/> instance.
        /// </summary>
        /// <param name="duplicate">Duplicate.</param>
        /// <param name="blogId">Blog id of the blog we were updating.  If this is .</param>
        public BlogDuplicationException(Blog duplicate, int blogId)
        {
            _duplicateBlog = duplicate;
            _blogId = blogId;
        }

        /// <summary>
        /// Gets the message.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get
            {
                if(_blogId == NullValue.NullInt32)
                {
                    return string.Format("Oooh. A blog with the same host '{0}' and subfolder '{1}' already exists.", _duplicateBlog.Host, _duplicateBlog.Subfolder);
                }
                return string.Format("Sorry, but changing this blog to use that host '{0}' and subfolder '{1}' would conflict with another blog.", _duplicateBlog.Host, _duplicateBlog.Subfolder);
            }
        }

        /// <summary>
        /// Gets the duplicate blog.
        /// </summary>
        /// <value></value>
        public Blog DuplicateBlog
        {
            get { return _duplicateBlog; }
        }

        /// <summary>
        /// Id of the blog being updated that caused this exception.  This 
        /// would be populated if updating a blog to have the same host and 
        /// subfolder as another blog.  Otherwise this is equal to NullValue.NullInt32.
        /// </summary>
        /// <value></value>
        public int BlogId
        {
            get { return _blogId; }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when creating or updating a blog that would cause 
    /// another blog to be hidden.  This should be a rare occurrence, but 
    /// entirely possible with multiple blogs.
    /// </summary>
    /// <remarks>
    /// <p>This exception occurs when adding a blog with the same hostname as another blog, 
    /// but the original blog does not have an subfolder name defined.</p>  
    /// <p>For example, if there exists a blog with the host "www.example.com" with no 
    /// subfolder defined, and the admin adds another blog with the host "www.example.com" 
    /// and subfolder as "MyBlog", this creates a multiple blog situation in the example.com 
    /// domain.  In that situation, each example.com blog MUST have an subfolder name defined. 
    /// The URL to the example.com with no subfolder becomes the aggregate blog.
    /// </p>
    /// </remarks>
    [Serializable]
    public class BlogHiddenException : BaseBlogConfigurationException
    {
        readonly int _blogId;
        readonly Blog _hiddenBlog;

        /// <summary>
        /// Creates a new <see cref="BlogHiddenException"/> instance.
        /// </summary>
        /// <param name="hidden">Hidden.</param>
        /// <param name="blogId"></param>
        public BlogHiddenException(Blog hidden, int blogId)
        {
            _hiddenBlog = hidden;
            _blogId = blogId;
        }

        /// <summary>
        /// Creates a new <see cref="BlogHiddenException"/> instance.
        /// </summary>
        /// <param name="hidden">Hidden.</param>
        public BlogHiddenException(Blog hidden) : this(hidden, NullValue.NullInt32)
        {
        }

        /// <summary>
        /// Gets the hidden blog.
        /// </summary>
        /// <value></value>
        public Blog HiddenBlog
        {
            get { return _hiddenBlog; }
        }

        /// <summary>
        /// Gets the blog id.
        /// </summary>
        /// <value></value>
        public int BlogId
        {
            get { return _blogId; }
        }

        /// <summary>
        /// Gets the message.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get
            {
                //TODO: We need to move the message out of the exception class.

                string message = _blogId == NullValue.NullInt32 ? "<p>Creating/Activating this blog " : "<p>Sorry, but by changing this blog to use that host combination ";

                message += "would cause the blog entitled &#8220;" + _hiddenBlog.Title + "&#8221; to be hidden. "
                           + "by causing more than one blog to have the host &#8220;" + _hiddenBlog.Host +
                           "&#8221;.</p><p>"
                           + "When two or more blogs have the same host, they both need to have an subfolder defined. "
                           +
                           "The previously mentioned blog does not have a subfolder defined.  Please update it before ";

                if(_blogId == NullValue.NullInt32)
                {
                    message += "creating/activating this blog.</p>";
                }
                else
                {
                    message += "making this change.</p>";
                }
                return message;
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when a blog Import fails. This could be caused by 
    /// a BlogML failure, or any other means of importing data into a 
    /// subText blog. NOTE: this exception may need refactored/renamed 
    /// so it can be used for both import & export failures.
    /// </summary>
    [Serializable]
    public class BlogImportException : Exception
    {
        readonly string _importMessage;

        /// <summary>
        /// Creates a new <see cref="BlogImportException"/> instance.
        /// </summary>
        /// <param name="importFailureReason">This is our best guess as to why the import failed
        /// and we threw the error. i.e.- Could not find the BlogML file, The BlogML file is not 
        /// valid, etc...</param>
        public BlogImportException(string importFailureReason)
        {
            _importMessage = importFailureReason;
        }

        /// <summary>
        /// Creates a new <see cref="BlogImportException"/> instance.
        /// </summary>
        /// <param name="importFailureReason">This is our best guess as to why the import failed
        /// and we threw the error. i.e.- Could not find the BlogML file, The BlogML file is not 
        /// valid, etc...</param>
        /// <param name="innerException"></param>
        public BlogImportException(string importFailureReason, Exception innerException) : base(null, innerException)
        {
            _importMessage = importFailureReason;
        }

        /// <summary>
        /// Gets the message.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get
            {
                return string.Format(
                    CultureInfo.InvariantCulture,
                    "There was an error trying to import data into this blog. The issue is most likely due to the following: {0}",
                    ImportMessage);
            }
        }

        public string ImportMessage
        {
            get { return _importMessage; }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when attempting to visit a blog that is no longer active.
    /// </summary>
    [Serializable]
    public class BlogInactiveException : BaseBlogConfigurationException
    {
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using Subtext.Framework.Properties;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when creating a new blog, or changing an existing 
    /// blog, without a Subfolder value specified, when another blog 
    /// with the same Host name exists.
    /// </summary>
    /// <remarks>
    /// An example of this case is where a system has a blog with the host 
    /// "example.com" and the subfolder name "MyBlog".  Attempting to create 
    /// a new blog with the host name "example.com" and an empty subfolder 
    /// name will result in this exception being thrown.
    /// </remarks>
    [Serializable]
    public class BlogRequiresSubfolderException : BaseBlogConfigurationException
    {
        readonly string _host;

        /// <summary>
        /// Creates a new <see cref="BlogRequiresSubfolderException"/> instance.
        /// </summary>
        public BlogRequiresSubfolderException(string hostName, int blogsWithSameHostCount, int blogId)
        {
            _host = hostName;
            BlogsWithSameHostCount = blogsWithSameHostCount;
            BlogId = blogId;
        }

        /// <summary>
        /// Creates a new <see cref="BlogRequiresSubfolderException"/> instance.
        /// </summary>
        public BlogRequiresSubfolderException(string hostName, int blogsWithSameHostCount)
            : this(hostName, blogsWithSameHostCount, NullValue.NullInt32)
        {
        }

        /// <summary>
        /// Gets the blogs with same host count.
        /// </summary>
        /// <value></value>
        public int BlogsWithSameHostCount { get; private set; }

        /// <summary>
        /// Gets the blog id.
        /// </summary>
        /// <value></value>
        public int BlogId { get; private set; }

        /// <summary>
        /// Gets a message that describes the current exception.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get
            {
                string blogCountClause = Resources.IsAnotherBlog;
                if(BlogsWithSameHostCount >= 1)
                {
                    blogCountClause = String.Format(CultureInfo.InvariantCulture, Resources.BlogCountClause,
                                                    BlogsWithSameHostCount);
                }

                return String.Format(CultureInfo.InvariantCulture,
                                     Resources.BlogRequiresSubfolder_ThereAreBlogsWithSameHostName, blogCountClause,
                                     _host);
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when a duplicate comment occurs, but duplicates are not allowed.
    /// </summary>
    [Serializable]
    public class CommentDuplicateException : BaseCommentException
    {
        /// <summary>
        /// Gets the message.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get { return "Sorry, but this comment is a duplicate of another comment.  Duplicate comments are not allowed."; }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Properties;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when comments are posted too frequently.
    /// </summary>
    public class CommentFrequencyException : BaseCommentException
    {
        public CommentFrequencyException(int commentDelayInMinutes)
        {
            CommentDelayInMinutes = commentDelayInMinutes;
        }

        public int CommentDelayInMinutes
        {
            get; 
            private set;
        }

        /// <summary>
        /// Gets the message.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get
            {
                string minutesText = CommentDelayInMinutes > 1 ? Resources.Minutes_Plural : Resources.Minutes_Singular;
                string message = string.Format(Resources.CommentFrequencyException_Message, CommentDelayInMinutes + " " + minutesText);
                return message;
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when a comment is identified as comment spam.
    /// </summary>
    /// <summary>
    /// Exception thrown when DESCRIPTION
    /// </summary>
    /// <remarks>
    /// Contains a custom property, thus it Implements ISerializable 
    /// and the special serialization constructor.
    /// </remarks>
    [Serializable]
    public sealed class CommentSpamException : BaseCommentException
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="CommentSpamException"/> class.
        /// </summary>
        public CommentSpamException()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CommentSpamException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        public CommentSpamException(string message) : base(message)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CommentSpamException"/> class.
        /// </summary>
        /// <param name="innerException">The inner exception.</param>
        public CommentSpamException(Exception innerException) : base(null, innerException)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="CommentSpamException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        /// <param name="innerException">The inner exception.</param>
        public CommentSpamException(string message, Exception innerException) : base(message, innerException)
        {
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;

namespace Subtext.Framework.Exceptions
{
    [Serializable]
    public class DeprecatedPhysicalPathsException : Exception
    {
        readonly string _message;

        public DeprecatedPhysicalPathsException(ReadOnlyCollection<string> physicalPaths)
        {
            InvalidPhysicalPaths = physicalPaths;
            _message = "In order to complete the upgrade, please delete the following directories/files." +
                      Environment.NewLine;
            foreach(string path in physicalPaths)
            {
                _message += " " + path + Environment.NewLine;
            }
        }

        public DeprecatedPhysicalPathsException(IEnumerable<string> physicalPaths)
            : this(new ReadOnlyCollection<string>(physicalPaths.ToList()))
        {
        }

        public override string Message
        {
            get { return _message; }
        }

        public ReadOnlyCollection<string> InvalidPhysicalPaths { get; private set; }
    }
}using System;

namespace Subtext.Framework.Exceptions
{
    [Serializable]
    public class DuplicateEntryException : Exception
    {
        public DuplicateEntryException(string message) : this(message, null)
        {
        }

        public DuplicateEntryException(string message, Exception inner) : base(message, inner)
        {
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when the HostInfo table (or other backing store 
    /// depending on the data provider) does not exist.
    /// </summary>
    [Serializable]
    public class HostDataDoesNotExistException : Exception
    {
        /// <summary>
        /// Gets the message.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get { return "The HostInfo table does not exist."; }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Exceptions
{
    /// <summary>
    /// Exception thrown when creating an application
    /// </summary>
    [Serializable]
    public class InvalidSubfolderNameException : BaseBlogConfigurationException
    {
        readonly string _subfolder;

        /// <summary>
        /// Creates a new <see cref="InvalidSubfolderNameException"/> instance.
        /// </summary>
        /// <param name="subfolder">Subfolder.</param>
        public InvalidSubfolderNameException(string subfolder)
        {
            _subfolder = subfolder;
        }

        /// <summary>
        /// Gets the message.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get
            {
                return "Sorry, but the subfolder name &#8220;" + _subfolder +
                       "&#8221; you&#8217;ve chosen is not allowed.";
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework
{
    [Serializable]
    public class IllegalPostCharactersException : Exception
    {
        public IllegalPostCharactersException(String s) : base(s)
        {
        }

        public IllegalPostCharactersException(String s, Exception inner) : base(s, inner)
        {
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Diagnostics;
using System.Globalization;
using System.Text.RegularExpressions;
using Subtext.Framework.Web;

namespace Subtext.Framework.Format
{
    /// <summary>
    /// Default Implemenation of UrlFormats
    /// </summary>
    public class UrlFormats
    {
        /// <summary>
        /// Parses out the subfolder of the blog from the requested URL.  It 
        /// simply searches for the first "folder" after the host and 
        /// Request.ApplicationPath.
        /// </summary>
        /// <remarks>
        /// <p>
        /// For example, if a blog is hosted at the virtual directory http://localhost/Subtext.Web/ and 
        /// request is made for http://localhost/Subtext.Web/, the subfolder name is "" (empty string). 
        /// Howver, a request for http://localhost/Subtext.Web/MyBlog/ would return "MyBlog" as the 
        /// subfolder.
        /// </p>
        /// <p>
        /// Likewise, if a blog is hosted at http://localhost/, a request for http://localhost/MyBlog/ 
        /// would return "MyBlog" as the subfolder.
        /// </p>
        /// </remarks>
        /// <param name="rawUrl">The raw url.</param>
        /// <param name="applicationPath">The virtual application name as found in the Request.ApplicationName property.</param>
        /// <returns></returns>
        public static string GetBlogSubfolderFromRequest(string rawUrl, string applicationPath)
        {
            if(rawUrl == null)
            {
                throw new ArgumentNullException("rawUrl");
            }

            if(applicationPath == null)
            {
                throw new ArgumentNullException("applicationPath");
            }

            Debug.Assert(applicationPath.StartsWith("/"), "ApplicationPaths always start with a slash");

            if(!rawUrl.StartsWith(applicationPath, StringComparison.OrdinalIgnoreCase))
            {
                return string.Empty;
            }
            int appPathLength = applicationPath.Length;
            int startIndex = appPathLength; 
            if(appPathLength > 1)
            {
                startIndex++;
            } 
            if(startIndex > rawUrl.Length)
            {
                return string.Empty;
            }
            int endIndex = rawUrl.IndexOf('/', startIndex);
            if(endIndex < 0)
            {
                string path = rawUrl.Substring(startIndex);
                // Don't want to return default.aspx etc.
                return path.Contains(".") ? string.Empty : path;
            }
            return rawUrl.Substring(startIndex, endIndex - startIndex);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Configuration;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using Subtext.Framework.Configuration;
using Subtext.Framework.Exceptions;
using Subtext.Framework.Properties;
using Subtext.Framework.Providers;
using Subtext.Framework.Security;

namespace Subtext.Framework
{
    /// <summary>
    /// Represents the system, and its settings, that hosts the blogs within this Subtext installation.
    /// </summary>
    public sealed class HostInfo
    {
        private static HostInfo _instance;

        /// <summary>
        /// Returns an instance of <see cref="HostInfo"/> used to 
        /// describe this installation of Subtext.
        /// </summary>
        /// <returns></returns>
        public static HostInfo Instance
        {
            get
            {
                // no lock singleton.
                HostInfo instance = _instance;
                if(instance == null)
                {
                    instance = LoadHost(true);
                    // the next line might overwrite a HostInfo created by another thread,
                    // but if it does, it'll only happen once and it's not so bad. I'll measure it to be sure. 
                    // -phil Jan 18, 2009
                    _instance = instance;
                }
                return _instance;
            }
        }

        /// <summary>
        /// Gets a value indicating whether the HostInfo table exists.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if host info table exists; otherwise, <c>false</c>.
        /// </value>
        public static bool HostInfoTableExists
        {
            get
            {
                try
                {
                    LoadHost(false);
                    return true;
                }
                catch(HostDataDoesNotExistException)
                {
                    return false;
                }
            }
        }

        /// <summary>
        /// Gets or sets the name of the host user.
        /// </summary>
        /// <value></value>
        public string HostUserName { get; set; }

        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the host password.
        /// </summary>
        /// <value></value>
        public string Password { get; set; }

        /// <summary>
        /// Gets or sets the salt.
        /// </summary>
        /// <value></value>
        public string Salt { get; set; }

        /// <summary>
        /// Gets or sets the date this record was created. 
        /// This is essentially the date that Subtext was 
        /// installed.
        /// </summary>
        /// <value></value>
        public DateTime DateCreated { get; set; }

        public bool BlogAggregationEnabled { get; set; }

        public Blog AggregateBlog { get; set; }

        /// <summary>
        /// Loads the host from the Object Provider. This is provided for 
        /// those cases when we really need to hit the data strore. Calling this
        /// method will also reload the HostInfo.Instance from the data store.
        /// </summary>
        /// <param name="suppressException">If true, won't throw an exception.</param>
        /// <returns></returns>
        public static HostInfo LoadHost(bool suppressException)
        {
            try
            {
                _instance = ObjectProvider.Instance().LoadHostInfo(new HostInfo());
                if(_instance != null)
                {
                    _instance.BlogAggregationEnabled =
                        String.Equals(ConfigurationManager.AppSettings["AggregateEnabled"], "true",
                                      StringComparison.OrdinalIgnoreCase);
                    if(_instance.BlogAggregationEnabled)
                    {
                        InitAggregateBlog(_instance);
                    }
                }
                return _instance;
            }
            catch(SqlException e)
            {
                // LoadHostInfo now executes the stored proc subtext_GetHost, instead of checking the table subtext_Host 
                if(e.Message.IndexOf("Invalid object name 'subtext_Host'") >= 0 ||
                   e.Message.IndexOf("Could not find stored procedure 'subtext_GetHost'") >= 0)
                {
                    if(suppressException)
                    {
                        return null;
                    }
                    throw new HostDataDoesNotExistException();
                }
                throw;
            }
        }

        /// <summary>
        /// Updates the host in the persistent store.
        /// </summary>
        /// <param name="host">Host.</param>
        /// <returns></returns>
        public static bool UpdateHost(HostInfo host)
        {
            if(ObjectProvider.Instance().UpdateHost(host))
            {
                _instance = host;
                return true;
            }
            return false;
        }

        /// <summary>
        /// Creates the host in the persistent store.
        /// </summary>
        /// <returns></returns>
        public static bool CreateHost(string hostUserName, string hostPassword, string email)
        {
            if(Instance != null)
            {
                throw new InvalidOperationException(Resources.InvalidOperation_HostRecordAlreadyExists);
            }

            var host = new HostInfo {HostUserName = hostUserName, Email = email};

            SetHostPassword(host, hostPassword);
            _instance = host;
            return UpdateHost(host);
        }

        public static void SetHostPassword(HostInfo host, string newPassword)
        {
            host.Salt = SecurityHelper.CreateRandomSalt();
            if(Config.Settings.UseHashedPasswords)
            {
                string hashedPassword = SecurityHelper.HashPassword(newPassword, host.Salt);
                host.Password = hashedPassword;
            }
            else
            {
                host.Password = newPassword;
            }
        }

        private static void InitAggregateBlog(HostInfo hostInfo)
        {
            string aggregateHost = ConfigurationManager.AppSettings["AggregateUrl"];
            if(aggregateHost == null)
            {
                return;
            }

            // validate host.
            var regex = new Regex(@"^(https?://)?(?<host>.+?)(/.*)?$", RegexOptions.Compiled | RegexOptions.IgnoreCase);
            Match match = regex.Match(aggregateHost);

            if(match.Success)
            {
                aggregateHost = match.Groups["host"].Value;
            }

            var blog = new Blog(true /*isAggregateBlog*/)
            {
                Title = ConfigurationManager.AppSettings["AggregateTitle"],
                Skin = SkinConfig.DefaultSkin,
                Host = aggregateHost,
                Subfolder = string.Empty,
                IsActive = true
            };
            //TODO: blog.MobileSkin = ...

            if(hostInfo != null)
            {
                blog.UserName = hostInfo.HostUserName;
                hostInfo.AggregateBlog = blog;
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;
using Subtext.Framework.Util;
using Image=Subtext.Framework.Components.Image;
using Subtext.Framework.Configuration;

namespace Subtext.Framework
{
    public static class Images
    {
        /// <summary>
        /// Saves the image.
        /// </summary>
        /// <param name="buffer">The buffer.</param>
        /// <param name="fileName">Name of the file.</param>
        /// <returns></returns>
        public static bool SaveImage(byte[] buffer, string fileName)
        {
            if(buffer == null)
            {
                throw new ArgumentNullException("buffer");
            }

            if(string.IsNullOrEmpty(fileName))
            {
                throw new ArgumentNullException("fileName");
            }

            if(FileHelper.IsValidImageFilePath(fileName))
            {
                FileHelper.EnsureDirectory(Path.GetDirectoryName(fileName));
                FileHelper.WriteBytesToFile(fileName, buffer);
                return true;
            }
            return false;
        }

        /// <summary>
        /// Saves two images. A normal image for the web site and then a thumbnail.
        /// </summary>
        /// <param name="image">Original image to process.</param>
        public static void MakeAlbumImages(Image image)
        {
            if(image == null)
            {
                throw new ArgumentNullException("image");
            }

            // Indexed GIFs can cause issues.
            using(System.Drawing.Image originalImage = GraphicsHelper.FromFilePathAsUnindexedImage(image.OriginalFilePath))
            {
                var originalSize = new Size(originalImage.Width, originalImage.Height);

                /// TODO: make new sizes configurations. 
                // New Display Size
                Size displaySize = originalSize.ScaleToFit(Config.Settings.GalleryImageMaxWidth, Config.Settings.GalleryImageMaxHeight);
                image.Height = displaySize.Height;
                image.Width = displaySize.Width;
                using(System.Drawing.Image displayImage = originalImage.GetResizedImage(displaySize))
                {
                    displayImage.Save(image.ResizedFilePath, ImageFormat.Jpeg);
                }

                // smaller thumbnail
                Size thumbSize = originalSize.ScaleToFit(Config.Settings.GalleryImageThumbnailWidth, Config.Settings.GalleryImageThumbnailHeight);
                using(System.Drawing.Image thumbnailImage = originalImage.GetResizedImage(thumbSize))
                {
                    thumbnailImage.Save(image.ThumbNailFilePath, ImageFormat.Jpeg);
                }
            }
        }

        public static ImageCollection GetImagesByCategoryId(int categoryId, bool activeOnly)
        {
            return ObjectProvider.Instance().GetImagesByCategoryId(categoryId, activeOnly);
        }

        /// <summary>
        /// Inserts the image.
        /// </summary>
        /// <param name="image">The image.</param>
        /// <param name="buffer">The buffer.</param>
        /// <returns></returns>
        public static int InsertImage(Image image, byte[] buffer)
        {
            if(image == null)
            {
                throw new ArgumentNullException("image");
            }

            if(!File.Exists(image.OriginalFilePath) && SaveImage(buffer, image.OriginalFilePath))
            {
                MakeAlbumImages(image);
                return ObjectProvider.Instance().InsertImage(image);
            }
            return NullValue.NullInt32;
        }

        /// <summary>
        /// Updates the image.
        /// </summary>
        /// <param name="image">The image.</param>
        public static void UpdateImage(Image image)
        {
            if(image == null)
            {
                throw new ArgumentNullException("image");
            }
            ObjectProvider.Instance().UpdateImage(image);
        }

        // added
        public static void Update(Image image, byte[] buffer)
        {
            if(image == null)
            {
                throw new ArgumentNullException("image");
            }

            if(buffer == null)
            {
                throw new ArgumentNullException("buffer");
            }

            if(SaveImage(buffer, image.OriginalFilePath))
            {
                MakeAlbumImages(image);
                UpdateImage(image);
            }
        }

        public static void DeleteImage(Image image)
        {
            if(image == null)
            {
                throw new ArgumentNullException("image");
            }

            ObjectProvider.Instance().DeleteImage(image.ImageID);
        }
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using BlogML;
using BlogML.Xml;
using Subtext.Framework;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;
using Subtext.Framework.Routing;
using Subtext.Framework.Services;

namespace Subtext.ImportExport
{
    public class BlogImportRepository : IBlogImportRepository
    {
        public BlogImportRepository(ISubtextContext context, ICommentService commentService, IEntryPublisher entryPublisher, IBlogMLImportMapper mapper)
        {
            SubtextContext = context;
            CommentService = commentService;
            EntryPublisher = entryPublisher;
            Mapper = mapper;
        }

        protected ObjectProvider Repository
        {
            get { return SubtextContext.Repository; }
        }

        public ISubtextContext SubtextContext { get; private set; }

        public IEntryPublisher EntryPublisher { get; private set; }

        public ICommentService CommentService { get; private set; }

        public IBlogMLImportMapper Mapper { get; private set; }

        public Blog Blog
        {
            get { return SubtextContext.Blog; }
        }

        protected UrlHelper Url
        {
            get { return SubtextContext.UrlHelper; }
        }

        public void CreateCategories(BlogMLBlog blog)
        {
            foreach(BlogMLCategory bmlCategory in blog.Categories)
            {
                LinkCategory category = Mapper.ConvertCategory(bmlCategory);
                Repository.CreateLinkCategory(category);
            }
        }

        public string CreateBlogPost(BlogMLBlog blog, BlogMLPost post)
        {
            Entry newEntry = Mapper.ConvertBlogPost(post, blog, Blog);
            newEntry.BlogId = Blog.Id;
            newEntry.Blog = Blog;
            var publisher = EntryPublisher as EntryPublisher;
            if(publisher != null)
            {
                var transform = publisher.Transformation as CompositeTextTransformation;
                if(transform != null)
                {
                    transform.Clear();
                }
            }

            return EntryPublisher.Publish(newEntry).ToString(CultureInfo.InvariantCulture);

        }

        public void CreateComment(BlogMLComment comment, string newPostId)
        {
            var newComment = Mapper.ConvertComment(comment, newPostId);
            CommentService.Create(newComment, false /*runfilters*/);
        }

        public void CreateTrackback(BlogMLTrackback trackback, string newPostId)
        {
            var pingTrack = Mapper.ConvertTrackback(trackback, newPostId);
            CommentService.Create(pingTrack, false /*runfilters*/);
        }

        public void SetExtendedProperties(BlogMLBlog.ExtendedPropertiesCollection extendedProperties)
        {
            if(extendedProperties != null && extendedProperties.Count > 0)
            {
                foreach(var extProp in extendedProperties)
                {
                    if(BlogMLBlogExtendedProperties.CommentModeration.Equals(extProp.Key))
                    {
                        bool modEnabled;

                        if(bool.TryParse(extProp.Value, out modEnabled))
                        {
                            Blog.ModerationEnabled = modEnabled;
                        }
                    }
                    else if(BlogMLBlogExtendedProperties.EnableSendingTrackbacks.Equals(extProp.Key))
                    {
                        bool tracksEnabled;

                        if(bool.TryParse(extProp.Value, out tracksEnabled))
                        {
                            Blog.TrackbacksEnabled = tracksEnabled;
                        }
                    }
                }

                Repository.UpdateBlog(Blog);
            }
        }

        public IDisposable SetupBlogForImport()
        {
            return new BlogImportSetup(Blog, Repository);
        }

        /// <summary>
        /// The physical path to the attachment directory.
        /// </summary>
        /// <remarks>
        /// The attachment is passed in to give the blog engine 
        /// the opportunity to use attachment specific directories 
        /// (ex. based on mime type) should it choose.
        /// </remarks>
        public string GetAttachmentDirectoryPath()
        {
            return Url.ImageDirectoryPath(Blog);
        }

        /// <summary>
        /// The url to the attachment directory
        /// </summary>
        /// <remarks>
        /// The attachment is passed in to give the blog engine 
        /// the opportunity to use attachment specific directories 
        /// (ex. based on mime type) should it choose.
        /// </remarks>
        public string GetAttachmentDirectoryUrl()
        {
            return Url.ImageDirectoryUrl(Blog);
        }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.IO;
using System.Web;
using BlogML;
using BlogML.Xml;
using log4net;
using Subtext.Framework.Logging;
using Subtext.Framework.Properties;

namespace Subtext.ImportExport
{
    public class BlogImportService : IBlogImportService
    {
        private readonly static ILog Log = new Log();

        public BlogImportService(IBlogImportRepository repository)
        {
            Repository = repository;
        }

        public IBlogImportRepository Repository { get; private set; }

        public void ImportBlog(Stream stream)
        {
            var importedBlog = BlogMLSerializer.Deserialize(stream);
            ImportBlog(importedBlog);
        }

        public void ImportBlog(BlogMLBlog blog)
        {
            using(Repository.SetupBlogForImport())
            {
                Import(blog);
            }
        }

        public void Import(BlogMLBlog blog)
        {
            Repository.SetExtendedProperties(blog.ExtendedProperties);

            Repository.CreateCategories(blog);

            foreach(BlogMLPost bmlPost in blog.Posts)
            {
                ImportBlogPost(blog, bmlPost);
            }

        }

        private void ImportBlogPost(BlogMLBlog blog, BlogMLPost bmlPost)
        {
            if(bmlPost.Attachments.Count > 0)
            {
                //Updates the post content with new attachment urls.
                bmlPost.Content = BlogMLContent.Create(CreateFilesFromAttachments(bmlPost), ContentTypes.Base64);
            }

            string newEntryId = Repository.CreateBlogPost(blog, bmlPost);

            foreach(BlogMLComment bmlComment in bmlPost.Comments)
            {
                try
                {
                    Repository.CreateComment(bmlComment, newEntryId);
                }
                catch(Exception e)
                {
                    LogError(Resources.Import_ErrorWhileImportingComment, e);
                }
            }

            foreach(BlogMLTrackback bmlPingTrack in bmlPost.Trackbacks)
            {
                try
                {
                    Repository.CreateTrackback(bmlPingTrack, newEntryId);
                }
                catch(Exception e)
                {
                    LogError(Resources.Import_ErrorWhileImportingComment, e);
                }
            }
        }

        /// <summary>
        /// Lets the provider decide how to log errors.
        /// </summary>
        public void LogError(string message, Exception exception)
        {
            Log.Error(message, exception);
        }

        public string CreateFilesFromAttachments(BlogMLPost post)
        {
            string postContent = post.Content.UncodedText;
            foreach(BlogMLAttachment bmlAttachment in post.Attachments)
            {
                string assetDirPath = Repository.GetAttachmentDirectoryPath();
                string assetDirUrl = Repository.GetAttachmentDirectoryUrl();

                if(!String.IsNullOrEmpty(assetDirPath) && !String.IsNullOrEmpty(assetDirUrl))
                {
                    if(!Directory.Exists(assetDirPath))
                    {
                        Directory.CreateDirectory(assetDirPath);
                    }
                    postContent = CreateFileFromAttachment(bmlAttachment, assetDirPath, assetDirUrl, postContent);
                }
            }
            return postContent;
        }

        public static string CreateFileFromAttachment(BlogMLAttachment attachment, string attachmentDirectoryPath,
                                                       string attachmentDirectoryUrl, string postContent)
        {
            string fileName = Path.GetFileName(attachment.Url);
            string attachmentPath = HttpUtility.UrlDecode(Path.Combine(attachmentDirectoryPath, fileName));
            string newAttachmentUrl = attachmentDirectoryUrl + fileName;

            postContent = BlogMLWriterBase.SgmlUtil.CleanAttachmentUrls(
                postContent,
                attachment.Url,
                newAttachmentUrl);

            if(attachment.Embedded)
            {
                if(!File.Exists(attachmentPath))
                {
                    using(var fStream = new FileStream(attachmentPath, FileMode.CreateNew))
                    {
                        using(var writer = new BinaryWriter(fStream))
                        {
                            writer.Write(attachment.Data);
                        }
                    }
                }
            }
            return postContent;
        }
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using Subtext.Framework;
using Subtext.Framework.Providers;

namespace Subtext.ImportExport
{
    /// <summary>
    /// Sets up a blog for import. The Dispose method reverts blog back to its original state.
    /// </summary>
    public class BlogImportSetup : IDisposable
    {
        Action _revertAction;
        public BlogImportSetup(Blog blog, ObjectProvider repository)
        {
            Blog = blog;
            Repository = repository;
            SetupBlogForImport();
        }

        public Blog Blog
        {
            get; private set;
        }

        public ObjectProvider Repository
        {
            get; private set;
        }

        void SetupBlogForImport()
        {
            if(!Blog.DuplicateCommentsEnabled)
            {
                Blog.DuplicateCommentsEnabled = true;
                Repository.UpdateBlog(Blog);
                _revertAction = () =>
                    {
                        Blog.DuplicateCommentsEnabled = false;
                        Repository.UpdateBlog(Blog);
                    };
            }
        }

        public void Dispose()
        {
            Action revertAction = _revertAction;
            if(revertAction != null)
            {
                revertAction();
            }
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Web;
using BlogML;
using BlogML.Xml;
using log4net;
using Subtext.Extensibility;
using Subtext.Framework;
using Subtext.Framework.Components;
using Subtext.Framework.Logging;
using Subtext.Framework.Properties;
using Subtext.Framework.Routing;
using Subtext.Framework.Text;
using Subtext.Framework.Web;

namespace Subtext.ImportExport
{
    public class BlogMLExportMapper : IBlogMLExportMapper
    {
        private readonly static ILog Log = new Log();

        public BlogMLExportMapper(ISubtextContext subtextContext)
        {
            SubtextContext = subtextContext;
            Blog = subtextContext.Blog;
            Url = subtextContext.UrlHelper;
        }

        protected ISubtextContext SubtextContext { get; private set; }
        protected Blog Blog { get; private set; }
        protected UrlHelper Url { get; private set; }

        public BlogMLBlog ConvertBlog(Blog blog)
        {
            var bmlBlog = new BlogMLBlog
            {
                Title = blog.Title,
                SubTitle = blog.SubTitle,
                RootUrl = Url.BlogUrl().ToFullyQualifiedUrl(blog).ToString(),
                DateCreated = blog.TimeZone.Now
            };

            PopulateAuthors(blog, bmlBlog);
            PopulateExtendedProperties(blog, bmlBlog);

            return bmlBlog;
        }

        public IEnumerable<BlogMLCategory> ConvertCategories(IEnumerable<LinkCategory> categories)
        {
            var blogCategories = from category in categories
                                 select new BlogMLCategory
                                 {
                                    Title = category.Title,
                                    Approved = category.IsActive,
                                    Description = category.Description,
                                    ID = category.Id.ToString(CultureInfo.InvariantCulture),
                                 };
            return blogCategories;
        }

        public BlogMLPost ConvertEntry(EntryStatsView entry, bool embedAttachments)
        {
            string postUrl = null;
            var entryVirtualPath = Url.EntryUrl(entry);
            if(entryVirtualPath != null)
            {
                postUrl = entryVirtualPath.ToFullyQualifiedUrl(Blog).ToString();
            }
            var post = new BlogMLPost
            {
                Title = entry.Title,
                PostUrl = postUrl,
                PostType = (entry.PostType == PostType.Story) ? BlogPostTypes.Article : BlogPostTypes.Normal,
                Approved = entry.IsActive,
                Content = BlogMLContent.Create(entry.Body ?? string.Empty, ContentTypes.Base64),
                HasExcerpt = entry.HasDescription,
                Excerpt = BlogMLContent.Create(entry.Description ?? string.Empty, ContentTypes.Base64),
                DateCreated = Blog.TimeZone.ToUtc(entry.DateCreated),
                DateModified = Blog.TimeZone.ToUtc(entry.IsActive ? entry.DateSyndicated : entry.DateModified),
                Views = (uint)entry.WebCount
            };

            if(entry.HasEntryName)
            {
                post.PostName = entry.EntryName;
            }
            
            // When we support multiple authors, this will have to change
            post.Authors.Add(Blog.Id.ToString(CultureInfo.InvariantCulture));
            post.Attachments.AddRange(GetPostAttachments(entry.Body, embedAttachments).ToArray());
            var comments = (from c in entry.Comments where c.FeedbackType == FeedbackType.Comment select ConvertComment(c)).ToList();
            if(comments.Count > 0)
            {
                post.Comments.AddRange(comments);
            }
            var trackbacks = (from c in entry.Comments where c.FeedbackType == FeedbackType.PingTrack select ConvertTrackback(c)).ToList();
            if(trackbacks.Count > 0)
            {
                post.Trackbacks.AddRange(trackbacks);
            }
            return post;
        }

        public IEnumerable<BlogMLAttachment> GetPostAttachments(string body, bool embedAttachments)
        {
            IEnumerable<string> attachmentUrls = body.GetAttributeValues("img", "src");

            foreach(string attachmentUrl in attachmentUrls)
            {
                string blogHostUrl = ("http://" + Blog.Host + "/").ToLowerInvariant();
                string attachmentUrlLowerCase = attachmentUrl.ToLowerInvariant();
                // If the URL for the attachment is local then we'll want to build a new BlogMLAttachment 
                // add add it to the list of attachments for this post.
                if(!attachmentUrlLowerCase.StartsWith("http") || attachmentUrlLowerCase.StartsWith(blogHostUrl))
                {
                    yield return GetAttachment(blogHostUrl, attachmentUrl, attachmentUrlLowerCase, embedAttachments);
                }
            }
        }

        private BlogMLAttachment GetAttachment(string blogHostUrl, string attachmentUrl, string attachmentUrlLowerCase, bool embed)
        {
            string attachVirtualPath = attachmentUrlLowerCase.Replace(blogHostUrl, "/");

            var attachment = new BlogMLAttachment
            {
                Embedded = embed,
                MimeType = attachmentUrl.GetMimeType(),
                Path = attachVirtualPath,
                Url = attachmentUrl
            };

            if(embed)
            {
                try
                {
                    SetAttachmentData(attachVirtualPath, attachment);
                }
                catch(FileNotFoundException e)
                {
                    Log.Error("The attachment we wish to embed was not found", e);
                    attachment.Embedded = false;
                }
            }
            return attachment;
        }

        private void SetAttachmentData(string attachVirtualPath, BlogMLAttachment attachment)
        {
            string attachPhysicalPath = HttpUtility.UrlDecode(SubtextContext.HttpContext.Server.MapPath(attachVirtualPath));

            using(FileStream attachStream = File.OpenRead(attachPhysicalPath))
            {
                using(var reader = new BinaryReader(attachStream))
                {
                    reader.BaseStream.Position = 0;
                    byte[] data = reader.ReadBytes((int)attachStream.Length);
                    attachment.Data = data;
                }
            }
        }

        private static void PopulateExtendedProperties(Blog blog, BlogMLBlog bmlBlog)
        {
            var bmlExtProp = new Pair<string, string>
            {
                Key = BlogMLBlogExtendedProperties.CommentModeration,
                Value = blog.ModerationEnabled
                            ? CommentModerationTypes.Enabled.ToString()
                            : CommentModerationTypes.Disabled.ToString()
            };
            bmlBlog.ExtendedProperties.Add(bmlExtProp);

            /* TODO: The blog.TrackbasksEnabled determines if Subtext will ACCEPT and SEND trackbacks.
             * Perhaps we should separate the two out?
             * For now, we'll assume that if a BlogML blog allows sending, it will also
             * allow receiving track/pingbacks.
             */
            bmlExtProp.Key = BlogMLBlogExtendedProperties.EnableSendingTrackbacks;
            bmlExtProp.Value = blog.TrackbacksEnabled
                                   ? SendTrackbackTypes.Yes.ToString()
                                   : SendTrackbackTypes.No.ToString();
        }

        private void PopulateAuthors(Blog blog, BlogMLBlog bmlBlog)
        {
            var bmlAuthor = new BlogMLAuthor
            {
                ID = blog.Id.ToString(CultureInfo.InvariantCulture),
                Title = blog.Author,
                Approved = true,
                Email = blog.Email,
                DateCreated = Blog.TimeZone.ToUtc(blog.LastUpdated),
                DateModified = Blog.TimeZone.ToUtc(blog.LastUpdated)
            };
            bmlBlog.Authors.Add(bmlAuthor);
        }


        public BlogMLComment ConvertComment(FeedbackItem feedbackItem)
        {
            if(feedbackItem == null)
            {
                throw new ArgumentNullException("feedbackItem");
            }
            if(feedbackItem.FeedbackType != FeedbackType.Comment)
            {
                throw new ArgumentException(String.Format(Resources.ArgumentException_CommentTypeMismatch, feedbackItem.FeedbackType, FeedbackType.Comment), "feedbackItem");
            }

            return new BlogMLComment
            {
                ID = feedbackItem.Id.ToString(CultureInfo.InvariantCulture),
                Title = feedbackItem.Title,
                UserUrl = feedbackItem.SourceUrl != null ? feedbackItem.SourceUrl.ToString() : null,
                UserEMail = feedbackItem.Email,
                UserName = feedbackItem.Author,
                Approved = feedbackItem.Approved,
                Content = BlogMLContent.Create(feedbackItem.Body ?? string.Empty, ContentTypes.Base64),
                DateCreated = Blog.TimeZone.ToUtc(feedbackItem.DateCreated),
                DateModified = Blog.TimeZone.ToUtc(feedbackItem.DateModified)
            };
        }

        public BlogMLTrackback ConvertTrackback(FeedbackItem trackback)
        {
            if(trackback == null)
            {
                throw new ArgumentNullException("trackback");
            }
            if(trackback.FeedbackType != FeedbackType.PingTrack)
            {
                throw new ArgumentException(String.Format(Resources.ArgumentException_CommentTypeMismatch, trackback.FeedbackType, FeedbackType.PingTrack), "trackback");
            }

            return new BlogMLTrackback
            {
                ID = trackback.Id.ToString(CultureInfo.InvariantCulture),
                Url = trackback.SourceUrl != null ? trackback.SourceUrl.ToString() : null,
                Title = trackback.Title,
                Approved = trackback.Approved,
                DateCreated = Blog.TimeZone.ToUtc(trackback.DateCreated),
                DateModified = Blog.TimeZone.ToUtc(trackback.DateModified)
            };
        }
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using BlogML;
using BlogML.Xml;
using Subtext.Extensibility;
using Subtext.Framework.Components;
using Subtext.Framework.Text;
using Subtext.Framework;

namespace Subtext.ImportExport
{
    public class BlogMLImportMapper : IBlogMLImportMapper
    {
        private const int MaxCategoryTitleLength = 150;
        private const int AuthorTitleMaxLength = 50;
        private const int BlogPostTitleMaxLength = 255;

        public Entry ConvertBlogPost(BlogMLPost post, BlogMLBlog blogMLBlog, Blog blog)
        {
            DateTime dateModified = blog != null ? blog.TimeZone.FromUtc(post.DateModified) : post.DateModified;
            DateTime dateCreated = blog != null ? blog.TimeZone.FromUtc(post.DateCreated) : post.DateCreated;

            var newEntry = new Entry((post.PostType == BlogPostTypes.Article) ? PostType.Story : PostType.BlogPost)
            {
                Title = GetTitleFromPost(post).Left(BlogPostTitleMaxLength),
                DateCreated = dateCreated,
                DateModified = dateModified,
                DateSyndicated = post.Approved ? dateModified : DateTime.MaxValue,
                Body = post.Content.UncodedText,
                IsActive = post.Approved,
                DisplayOnHomePage = post.Approved,
                IncludeInMainSyndication = post.Approved,
                IsAggregated = post.Approved,
                AllowComments = true,
                Description = post.HasExcerpt ? post.Excerpt.UncodedText: null
            };

            if(!string.IsNullOrEmpty(post.PostName))
            {
                newEntry.EntryName = post.PostName;
            }
            else
            {
                SetEntryNameForBlogspotImport(post, newEntry);
            }

            SetEntryAuthor(post, newEntry, blogMLBlog);

            SetEntryCategories(post, newEntry, blogMLBlog);
            return newEntry;
        }

        private void SetEntryCategories(BlogMLPost post, Entry newEntry, BlogMLBlog blog)
        {
            if(post.Categories.Count > 0)
            {
                foreach(BlogMLCategoryReference categoryRef in post.Categories)
                {
                    string categoryTitle = GetCategoryTitleById(categoryRef.Ref, blog.Categories);
                    if(categoryTitle != null)
                    {
                        newEntry.Categories.Add(categoryTitle);
                    }
                }
            }
        }

        private IDictionary<string, string> _categoryIdToTitleMap;
        private string GetCategoryTitleById(string categoryId, IEnumerable<BlogMLCategory> categories)
        {
            if(_categoryIdToTitleMap == null)
            {
                _categoryIdToTitleMap = new Dictionary<string, string>();
                foreach(var category in categories)
                {
                    _categoryIdToTitleMap.Add(category.ID, category.Title);
                }
            }

            string title;
            _categoryIdToTitleMap.TryGetValue(categoryId, out title);
            return title;
        }

        private static void SetEntryAuthor(BlogMLPost post, Entry newEntry, BlogMLBlog blog)
        {
            if(post.Authors.Count > 0)
            {
                foreach(BlogMLAuthor author in blog.Authors)
                {
                    if(author.ID != post.Authors[0].Ref)
                    {
                        continue;
                    }
                    newEntry.Author = author.Title.Left(AuthorTitleMaxLength);
                    newEntry.Email = author.Email;
                    break;
                }
            }
        }

        private static string GetTitleFromPost(BlogMLPost blogPost)
        {
            if(!String.IsNullOrEmpty(blogPost.Title))
            {
                return blogPost.Title;
            }
            if(!String.IsNullOrEmpty(blogPost.PostName))
            {
                return blogPost.PostName;
            }

            return "Post #" + blogPost.ID;
        }

        private static void SetEntryNameForBlogspotImport(BlogMLPost post, Entry newEntry)
        {
            if(!String.IsNullOrEmpty(post.PostUrl) &&
               post.PostUrl.Contains("blogspot.com/", StringComparison.OrdinalIgnoreCase))
            {
                Uri postUrl = post.PostUrl.ParseUri();
                string fileName = postUrl.Segments.Last();
                newEntry.EntryName = Path.GetFileNameWithoutExtension(fileName);
                if(String.IsNullOrEmpty(post.Title) && String.IsNullOrEmpty(post.PostName))
                {
                    newEntry.Title = newEntry.EntryName.Replace("-", " ").Replace("+", " ").Replace("_", " ");
                }
            }
        }

        public LinkCategory ConvertCategory(BlogMLCategory category)
        {
            return new LinkCategory
            {
                Title = category.Title.Left(MaxCategoryTitleLength),
                Description = category.Description,
                IsActive = category.Approved,
                CategoryType = CategoryType.PostCollection
            };
        }

        public FeedbackItem ConvertComment(BlogMLComment comment, string parentPostId)
        {
            var feedback = new FeedbackItem(FeedbackType.Comment)
            {
                EntryId = int.Parse(parentPostId, CultureInfo.InvariantCulture),
                Title = comment.Title ?? string.Empty,
                DateCreated = comment.DateCreated,
                DateModified = comment.DateModified,
                Body = comment.Content.UncodedText ?? string.Empty,
                Approved = comment.Approved,
                Author = comment.UserName ?? string.Empty,
                Email = comment.UserEMail,
                SourceUrl = !String.IsNullOrEmpty(comment.UserUrl) ? ConvertUri(comment.UserUrl) : null
            };
            if(!feedback.Approved)
            {
                // Have to assume it needs moderation since that's what it most likely means in other blog systems;
                feedback.Status = FeedbackStatusFlag.NeedsModeration;
            }
            return feedback;
        }

        public FeedbackItem ConvertTrackback(BlogMLTrackback trackback, string parentPostId)
        {
            string author = null;
            Uri sourceUri = ConvertUri(trackback.Url);
            if(sourceUri != null)
            {
                author = sourceUri.Host;
            }
            return new FeedbackItem(FeedbackType.PingTrack)
            {
                EntryId = int.Parse(parentPostId, CultureInfo.InvariantCulture),
                Title = trackback.Title,
                SourceUrl = sourceUri,
                Approved = trackback.Approved,
                DateCreated = trackback.DateCreated,
                DateModified = trackback.DateModified,
                Author = author ?? string.Empty,
                Body = string.Empty
            };
        }

        private static Uri ConvertUri(string uriText)
        {
            Uri uri;
            if(!Uri.TryCreate(uriText, UriKind.Absolute, out uri))
            {
                return null;
            }
            return uri;
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using BlogML.Xml;
using Subtext.Extensibility.Collections;
using Subtext.Framework;
using Subtext.Framework.Components;

namespace Subtext.ImportExport
{
    public class BlogMLSource : IBlogMLSource
    {
        public BlogMLSource(ISubtextContext context, IBlogMLExportMapper blogMLConverter)
        {
            SubtextContext = context;
            BlogMLConverter = blogMLConverter;
        }

        protected ISubtextContext SubtextContext
        {
            get; 
            private set;
        }

        protected IBlogMLExportMapper BlogMLConverter
        {
            get; 
            private set;
        }

        public BlogMLBlog GetBlog()
        {
            BlogMLBlog blog = BlogMLConverter.ConvertBlog(SubtextContext.Blog);
            blog.Categories.AddRange(Categories);
            return blog;
        }

        protected IList<BlogMLCategory> Categories
        { 
            get
            {
                if(_categories == null)
                {
                    
                    var categories = SubtextContext.Repository.GetCategories(CategoryType.PostCollection, false /*activeOnly*/);
                    if(categories != null && categories.Count > 0)
                    {
                        _categories = BlogMLConverter.ConvertCategories(categories).ToList();
                    }
                }
                _categories = _categories ?? new List<BlogMLCategory>();
                return _categories;
            }
        }

        IList<BlogMLCategory> _categories;
                
        protected Dictionary<string, BlogMLCategory> CategoryByTitleLookup
        {
            get
            {
                // We need to build this lookup dictionary because an Entry only contains a collection
                // of Category titles and not the actual categories. :(
                if(_categoryByTitleLookup == null)
                {
                    _categoryByTitleLookup = new Dictionary<string, BlogMLCategory>();
                    foreach(var category in Categories)
                    {
                        _categoryByTitleLookup.Add(category.Title, category);
                    }
                }
                return _categoryByTitleLookup;
            }
        }

        Dictionary<string, BlogMLCategory> _categoryByTitleLookup;

        public IEnumerable<BlogMLPost> GetBlogPosts(bool embedAttachments)
        {
            const int pageSize = 100;
            var collectionBook = new CollectionBook<EntryStatsView>((pageIndex, sizeOfPage) => SubtextContext.Repository.GetEntriesForExport(pageIndex, sizeOfPage), pageSize);
            foreach(var entry in collectionBook.AsFlattenedEnumerable())
            {
                var post = BlogMLConverter.ConvertEntry(entry, embedAttachments);
                foreach(var categoryTitle in entry.Categories)
                {
                    post.Categories.Add(CategoryByTitleLookup[categoryTitle].ID.ToString(CultureInfo.InvariantCulture));
                }
                yield return post;
            }
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Xml;
using BlogML;
using BlogML.Xml;

namespace Subtext.ImportExport
{
    public class BlogMLWriter : BlogMLWriterBase, IBlogMLWriter
    {
        public BlogMLWriter(IBlogMLSource source, bool embedAttachments)
        {
            EmbedAttachments = embedAttachments;
            Source = source;
        }

        public IBlogMLSource Source
        {
            get;
            private set;
        }

        public bool EmbedAttachments
        {
            get;
            set;
        }

        protected override void InternalWriteBlog()
        {
            var blog = Source.GetBlog();
            WriteStartBlog(blog.Title, ContentTypes.Text, blog.SubTitle, ContentTypes.Text, blog.RootUrl, blog.DateCreated);

            WriteAuthors(blog.Authors);
            WriteExtendedProperties(blog.ExtendedProperties);
            WriteCategories(blog.Categories);
            WritePosts(Source.GetBlogPosts(EmbedAttachments));

            WriteEndElement();
            Writer.Flush();
        }

        void IBlogMLWriter.Write(XmlWriter writer)
        {
            Write(writer);
        }

        private void WriteAuthors(IEnumerable<BlogMLAuthor> authors)
        {
            WriteStartAuthors();
            foreach(BlogMLAuthor bmlAuthor in authors)
            {
                WriteAuthor(
                    bmlAuthor.ID,
                    bmlAuthor.Title,
                    bmlAuthor.Email,
                    bmlAuthor.DateCreated,
                    bmlAuthor.DateModified,
                    bmlAuthor.Approved);
            }
            WriteEndElement(); // </authors>
        }

        private void WriteExtendedProperties(ICollection<Pair<string, string>> extendedProperties)
        {
            if(extendedProperties.Count > 0)
            {
                WriteStartExtendedProperties();
                foreach(var extProp in extendedProperties)
                {
                    WriteExtendedProperty(extProp.Key, extProp.Value);
                }
                WriteEndElement();
            }
        }

        private void WriteCategories(IEnumerable<BlogMLCategory> categories)
        {
            WriteStartCategories();
            foreach(BlogMLCategory category in categories)
            {
                WriteCategory(category.ID, category.Title, ContentTypes.Text, category.DateCreated, category.DateModified, category.Approved, category.Description, category.ParentRef);
            }
            WriteEndElement();
        }

        private void WritePosts(IEnumerable<BlogMLPost> posts)
        {
            WriteStartPosts();
            foreach(var post in posts)
            {
                WriteStartBlogMLPost(post);
                WritePostCategories(post.Categories);
                WritePostComments(post.Comments);
                WritePostTrackbacks(post.Trackbacks);
                WritePostAttachments(post.Attachments);
                WritePostAuthors(post.Authors);

                WriteEndElement(); // </post>
                Writer.Flush();
            }
            WriteEndElement();
        }

        protected void WriteStartBlogMLPost(BlogMLPost post)
        {
            WriteStartElement("post");
            WriteNodeAttributes(post.ID, post.DateCreated, post.DateModified, post.Approved);
            WriteAttributeString("post-url", post.PostUrl);
            WriteAttributeStringRequired("type", "normal");
            WriteAttributeStringRequired("hasexcerpt", post.HasExcerpt.ToString().ToLowerInvariant());
            WriteAttributeStringRequired("views", post.Views.ToString());
            WriteContent("title", BlogMLContent.Create(post.Title, ContentTypes.Text));
            WriteBlogMLContent("content", post.Content);
            if(!String.IsNullOrEmpty(post.PostName))
            {
                WriteContent("post-name", BlogMLContent.Create(post.PostName, ContentTypes.Text));
            }
            if(post.HasExcerpt)
            {
                WriteBlogMLContent("excerpt", post.Excerpt);
            }
        }

        protected void WriteBlogMLContent(string elementName, BlogMLContent content)
        {
            WriteContent(elementName, content);
        }

        protected void WritePostCategories(BlogMLPost.CategoryReferenceCollection categoryRefs)
        {
            if(categoryRefs.Count > 0)
            {
                WriteStartCategories();
                foreach(BlogMLCategoryReference categoryRef in categoryRefs)
                {
                    WriteCategoryReference(categoryRef.Ref);
                }
                WriteEndElement();
            }
        }

        private void WritePostComments(BlogMLPost.CommentCollection comments)
        {
            if(comments.Count > 0)
            {
                WriteStartComments();
                foreach(BlogMLComment comment in comments)
                {
                    string userName = string.IsNullOrEmpty(comment.UserName) ? "Anonymous" : comment.UserName;
                    WriteComment(comment.ID, BlogMLContent.Create(comment.Title, ContentTypes.Text), comment.DateCreated, comment.DateModified,
                                 comment.Approved, userName, comment.UserEMail, comment.UserUrl,
                                 comment.Content);
                }
                WriteEndElement();
            }
        }

        private void WritePostTrackbacks(BlogMLPost.TrackbackCollection trackbacks)
        {
            if(trackbacks.Count > 0)
            {
                WriteStartTrackbacks();
                foreach(BlogMLTrackback trackback in trackbacks)
                {
                    if(!String.IsNullOrEmpty(trackback.Url))
                    {
                        WriteTrackback(trackback.ID, trackback.Title, ContentTypes.Text, trackback.DateCreated, trackback.DateModified, trackback.Approved, trackback.Url);
                    }
                }
                WriteEndElement();
            }
        }

        private void WritePostAttachments(BlogMLPost.AttachmentCollection attachments)
        {
            if(attachments.Count > 0)
            {
                WriteStartAttachments();
                foreach(BlogMLAttachment attachment in attachments)
                {
                    if(attachment.Embedded)
                    {
                        WriteAttachment(attachment.Url, attachment.Data.Length, attachment.MimeType, attachment.Path, attachment.Embedded, attachment.Data);
                    }
                    else
                    {
                        WriteAttachment(attachment.Path, attachment.MimeType, attachment.Url);
                    }
                }
                WriteEndElement(); // End Attachments Element
                Writer.Flush();
            }
        }

        private void WritePostAuthors(BlogMLPost.AuthorReferenceCollection authorsRefs)
        {
            if(authorsRefs.Count > 0)
            {
                WriteStartAuthors();
                foreach(BlogMLAuthorReference authorRef in authorsRefs)
                {
                    WriteAuthorReference(authorRef.Ref);
                }
                WriteEndElement();
            }
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using BlogML.Xml;

namespace Subtext.ImportExport
{
    public interface IBlogImportRepository
    {
        /// <summary>
        /// Creates categories from the blog ml.
        /// </summary>
        /// <param name="blog"></param>
        void CreateCategories(BlogMLBlog blog);

        /// <summary>
        /// Creates a blog post and returns the id.
        /// </summary>
        string CreateBlogPost(BlogMLBlog blog, BlogMLPost post);

        /// <summary>
        /// Creates a comment in the system.
        /// </summary>
        void CreateComment(BlogMLComment comment, string newPostId);

        /// <summary>
        /// Creates a trackback for the post.
        /// </summary>
        void CreateTrackback(BlogMLTrackback trackback, string newPostId);

        /// <summary>
        /// Sets the extended properties stored in the BlogML that Subtext supports
        /// </summary>
        /// <param name="extendedProperties"></param>
        void SetExtendedProperties(BlogMLBlog.ExtendedPropertiesCollection extendedProperties);

        /// <summary>
        /// The physical path to the attachment directory.
        /// </summary>
        /// <remarks>
        /// The attachment is passed in to give the blog engine 
        /// the opportunity to use attachment specific directories 
        /// (ex. based on mime type) should it choose.
        /// </remarks>
        string GetAttachmentDirectoryPath();

        /// <summary>
        /// The url to the attachment directory
        /// </summary>
        /// <remarks>
        /// The attachment is passed in to give the blog engine 
        /// the opportunity to use attachment specific directories 
        /// (ex. based on mime type) should it choose.
        /// </remarks>
        string GetAttachmentDirectoryUrl();

        /// <summary>
        /// Sets up the blog for import by allowing duplicate comments, turning off moderation, etc...
        /// </summary>
        /// <returns></returns>
        IDisposable SetupBlogForImport();
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.IO;

namespace Subtext.ImportExport
{
    public interface IBlogImportService
    {
        void ImportBlog(Stream stream);
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using BlogML.Xml;
using Subtext.Framework;
using Subtext.Framework.Components;

namespace Subtext.ImportExport
{
    public interface IBlogMLExportMapper
    {
        BlogMLBlog ConvertBlog(Blog blog);
        IEnumerable<BlogMLCategory> ConvertCategories(IEnumerable<LinkCategory> categories);
        BlogMLPost ConvertEntry(EntryStatsView entry, bool embedAttachments);
        BlogMLComment ConvertComment(FeedbackItem comment);
        BlogMLTrackback ConvertTrackback(FeedbackItem trackback);
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using BlogML.Xml;
using Subtext.Framework;
using Subtext.Framework.Components;

namespace Subtext.ImportExport
{
    public interface IBlogMLImportMapper
    {
        Entry ConvertBlogPost(BlogMLPost post, BlogMLBlog blogMLBlog, Blog blog);
        LinkCategory ConvertCategory(BlogMLCategory category);
        FeedbackItem ConvertComment(BlogMLComment comment, string parentPostId);
        FeedbackItem ConvertTrackback(BlogMLTrackback trackback, string parentPostId);
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using BlogML.Xml;
using System.Collections.Generic;

namespace Subtext.ImportExport
{
    public interface IBlogMLSource
    {
        BlogMLBlog GetBlog();
        IEnumerable<BlogMLPost> GetBlogPosts(bool embedAttachments);
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Xml;

namespace Subtext.ImportExport
{
    public interface IBlogMLWriter
    {
        void Write(XmlWriter writer);
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web;
using System.Web.Mvc;

namespace Subtext.Infrastructure.ActionResults
{
    /// <summary>
    /// Just like a FileContentResult, but allows for setting cache parameters.
    /// </summary>
    public class CacheableFileContentResult : FileContentResult
    {
        public CacheableFileContentResult(byte[] fileContents, string contentType, DateTime lastModifed,
                                          HttpCacheability cacheability)
            : base(fileContents, contentType)
        {
            LastModified = lastModifed;
            Cacheability = cacheability;
        }

        public DateTime LastModified { get; private set; }

        public HttpCacheability Cacheability { get; private set; }

        public override void ExecuteResult(ControllerContext context)
        {
            HttpCachePolicyBase cache = context.HttpContext.Response.Cache;
            cache.SetCacheability(Cacheability);
            cache.SetLastModified(LastModified);

            base.ExecuteResult(context);
        }
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Threading;
using System.Web;
using System.Web.Mvc;
using System.Xml;
using Subtext.ImportExport;
using System.IO;

namespace Subtext.Infrastructure.ActionResults
{
    public class ExportActionResult : FileResult
    {
        public ExportActionResult(IBlogMLWriter blogMLWriter, string fileName) : base("text/xml")
        {
            BlogMLWriter = blogMLWriter;
            FileDownloadName = fileName;
        }

        public IBlogMLWriter BlogMLWriter
        {
            get; 
            private set;
        }

        protected override void WriteFile(HttpResponseBase response)
        {
            var writer = new XmlTextWriter(response.Output);
            BlogMLWriter.Write(writer);
        }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using System.Web.Mvc;

namespace Subtext.Infrastructure.ActionResults
{
    public class NotModifiedResult : ActionResult
    {
        public override void ExecuteResult(ControllerContext context)
        {
            HttpResponseBase response = context.HttpContext.Response;
            response.StatusCode = 304;
            response.SuppressContent = true;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using System.Web.Routing;
using Ninject;
using Ninject.Modules;

namespace Subtext.Infrastructure
{
    public static class Bootstrapper
    {
        public static IServiceLocator ServiceLocator { get; set; }

        public static RequestContext RequestContext
        {
            get
            {
                if(HttpContext.Current != null && HttpContext.Current.Items != null)
                {
                    return HttpContext.Current.Items["__Subtext_RequestContext"] as RequestContext;
                }
                return null;
            }
            set
            {
                if(HttpContext.Current != null && HttpContext.Current.Items != null)
                {
                    HttpContext.Current.Items["__Subtext_RequestContext"] = value;
                }
            }
        }

        public static void InitializeKernel(params INinjectModule[] modules)
        {
            var kernel = new StandardKernel(modules);
            ServiceLocator = kernel.Get<IServiceLocator>();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections;
using System.Web.Caching;

namespace Subtext.Infrastructure
{
    public interface ICache : IEnumerable
    {
        object this[string key] { get; set; }
        void Insert(string key, object value);
        void Insert(string key, object value, CacheDependency dependency);

        void Insert(string key, object value, CacheDependency dependency, DateTime absoluteExpiration,
                    TimeSpan slidingExpiration);

        void Insert(string key, object value, CacheDependency dependencies, DateTime absoluteExpiration,
                    TimeSpan slidingExpiration, CacheItemPriority priority, CacheItemRemovedCallback onRemoveCallback);

        void Remove(string key);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using Subtext.Framework.Services;

namespace Subtext.Framework.Infrastructure.Installation
{
    public interface IInstallationManager
    {
        void Install(Version currentAssemblyVersion);
        void CreateWelcomeContent(ISubtextContext context, IEntryPublisher entryPublisher, Blog blog);
        void Upgrade(Version currentAssemblyVersion);
        bool InstallationActionRequired(Version assemblyVersion, Exception unhandledException);
        void ResetInstallationStatusCache();
        InstallationState GetInstallationStatus(Version currentAssemblyVersion);
        bool IsPermissionDeniedException(Exception exception);
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Infrastructure.Installation
{
    public interface IInstaller
    {
        void Install(Version assemblyVersion);

        /// <summary>
        /// Upgrades this instance. Returns true if it was successful.
        /// </summary>
        /// <returns></returns>
        void Upgrade(Version assemblyVersion);

        /// <summary>
        /// Gets the <see cref="Version"/> of the current Subtext data store (ie. SQL Server). 
        /// This is the value stored in the database. If it does not match the actual 
        /// assembly version, we may need to run an upgrade.
        /// </summary>
        /// <returns></returns>
        Version GetCurrentInstallationVersion();

        /// <summary>
        /// Gets a value indicating whether the subtext installation needs an upgrade 
        /// to occur.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [needs upgrade]; otherwise, <c>false</c>.
        /// </value>
        bool NeedsUpgrade(Version installationVersion, Version currentAssemblyVersion);
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Data;
using Subtext.Framework.Exceptions;
using Subtext.Framework.Providers;
using Subtext.Framework.Routing;
using Subtext.Framework.Services;
using Subtext.Infrastructure;

namespace Subtext.Framework.Infrastructure.Installation
{
    /// <summary>
    /// Class used to help make determine whether an installation is required or not.
    /// </summary>
    public class InstallationManager : IInstallationManager
    {
        public InstallationManager(IInstaller installer, ICache cache)
        {
            Installer = installer;
            Cache = cache;
        }

        protected ICache Cache { get; set; }
        protected IInstaller Installer { get; set; }

        public void Install(Version assemblyVersion)
        {
            Installer.Install(assemblyVersion);
            ResetInstallationStatusCache();
        }

        public void CreateWelcomeContent(ISubtextContext context, IEntryPublisher entryPublisher, Blog blog)
        {
            var repository = context.Repository;
            CreateWelcomeCategories(repository, blog);

            var adminUrlHelper = new AdminUrlHelper(context.UrlHelper);
            Entry article = CreateWelcomeArticle(blog, entryPublisher, adminUrlHelper);
            Entry entry = CreateWelcomeBlogPost(context, blog, entryPublisher, adminUrlHelper, article);
            CreateWelcomeComment(repository, adminUrlHelper, entry);
            
        }

        private static void CreateWelcomeComment(ObjectProvider repository, AdminUrlHelper adminUrlHelper, Entry entry)
        {
            string commentBody = ScriptHelper.UnpackEmbeddedScriptAsString("WelcomeComment.htm");
            string feedbackUrl = adminUrlHelper.FeedbackList();
            commentBody = string.Format(commentBody, feedbackUrl);
            var comment = new FeedbackItem(FeedbackType.Comment)
            {
                Title = "re: Welcome to Subtext!",
                Entry = entry,
                Author = "Subtext",
                DateCreated = DateTime.Now,
                DateModified = DateTime.Now,
                Approved = true,
                Body = commentBody
            };
            repository.Create(comment);
        }

        private static Entry CreateWelcomeBlogPost(ISubtextContext context, Blog blog, IEntryPublisher entryPublisher, AdminUrlHelper adminUrlHelper, IEntryIdentity article)
        {
            string body = ScriptHelper.UnpackEmbeddedScriptAsString("WelcomePost.htm");
            string articleUrl = context.UrlHelper.EntryUrl(article);
            body = String.Format(body, articleUrl, adminUrlHelper.Home(), context.UrlHelper.HostAdminUrl("default.aspx"));

            var entry = new Entry(PostType.BlogPost)
            {
                Title = "Welcome to Subtext!",
                EntryName = "welcome-to-subtext",
                BlogId = blog.Id,
                Author = blog.Author,
                Body = body,
                DateCreated = DateTime.Now,
                DateModified = DateTime.Now,
                DateSyndicated = DateTime.Now,
                IsActive = true,
                IncludeInMainSyndication = true,
                DisplayOnHomePage = true,
                AllowComments = true
            };

            entryPublisher.Publish(entry);
            return entry;
        }

        private static Entry CreateWelcomeArticle(Blog blog, IEntryPublisher entryPublisher, AdminUrlHelper adminUrlHelper)
        {
            string body = ScriptHelper.UnpackEmbeddedScriptAsString("WelcomeArticle.htm");
            body = String.Format(body, adminUrlHelper.ArticlesList());

            var article = new Entry(PostType.Story)
            {
                EntryName = "welcome-to-subtext-article",
                Title = "Welcome to Subtext!",
                BlogId = blog.Id,
                Author = blog.Author,
                Body = body,
                DateCreated = DateTime.Now,
                DateModified = DateTime.Now,
                IsActive = true,
            };

            entryPublisher.Publish(article);
            return article;
        }

        private static void CreateWelcomeCategories(ObjectProvider repository, Blog blog)
        {
            repository.CreateLinkCategory(new LinkCategory
            {
                Title = "Programming", 
                Description = "Blog posts related to programming", 
                BlogId = blog.Id, 
                IsActive = true, 
                CategoryType = CategoryType.PostCollection,
            });
            repository.CreateLinkCategory(new LinkCategory
            {
                Title = "Personal", 
                Description = "Personal musings, random thoughts.", 
                BlogId = blog.Id, 
                IsActive = true, 
                CategoryType = CategoryType.PostCollection
            });
        }

        public void Upgrade(Version currentAssemblyVersion)
        {
            Installer.Upgrade(currentAssemblyVersion);
            ResetInstallationStatusCache();
        }

        /// <summary>
        /// Determines whether an installation action is required by 
        /// examining the specified unhandled Exception.
        /// </summary>
        /// <param name="unhandledException">Unhandled exception.</param>
        /// <param name="assemblyVersion">The version of the currently installed assembly.</param>
        /// <returns>
        /// 	<c>true</c> if an installation action is required; otherwise, <c>false</c>.
        /// </returns>
        public bool InstallationActionRequired(Version assemblyVersion, Exception unhandledException)
        {
            if(unhandledException is HostDataDoesNotExistException)
            {
                return true;
            }

            if(IsInstallationException(unhandledException))
            {
                return true;
            }

            InstallationState status = GetInstallationStatus(assemblyVersion);
            switch(status)
            {
                case InstallationState.NeedsInstallation:
                case InstallationState.NeedsUpgrade:
                {
                    return true;
                }
            }

            return false;
        }

        private static bool IsInstallationException(Exception exception)
        {
            var tableRegex = new Regex("Invalid object name '.*?'", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            bool isSqlException = exception is SqlException;

            if(isSqlException && tableRegex.IsMatch(exception.Message))
            {
                return true;
            }

            var spRegex = new Regex("'Could not find stored procedure '.*?'", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            if(isSqlException && spRegex.IsMatch(exception.Message))
            {
                return true;
            }

            return false;
        }

        public virtual InstallationState GetInstallationStatus(Version currentAssemblyVersion)
        {
            object cachedInstallationState = Cache["NeedsInstallation"];
            if(cachedInstallationState != null)
            {
                return (InstallationState)cachedInstallationState;
            }

            var status = GetInstallationState(currentAssemblyVersion);
            Cache.Insert("NeedsInstallation", status);
            return status;
        }

        private InstallationState GetInstallationState(Version currentAssemblyVersion)
        {
            Version installationVersion = Installer.GetCurrentInstallationVersion();
            if(installationVersion == null)
            {
                return InstallationState.NeedsInstallation;
            }

            if(Installer.NeedsUpgrade(installationVersion, currentAssemblyVersion))
            {
                return InstallationState.NeedsUpgrade;
            }

            return InstallationState.Complete;
        }

        public bool InstallationActionRequired(InstallationState currentState)
        {
            bool needsUpgrade = (currentState == InstallationState.NeedsInstallation
                                 || currentState == InstallationState.NeedsUpgrade);

            return needsUpgrade;
        }

        public void ResetInstallationStatusCache()
        {
            object cachedInstallationState = Cache["NeedsInstallation"];
            if(cachedInstallationState != null)
            {
                Cache.Remove("NeedsInstallation");
            }
        }

        /// <summary>
        /// Determines whether the specified exception is due to a permission 
        /// denied error.
        /// </summary>
        /// <param name="exception"></param>
        /// <returns></returns>
        public bool IsPermissionDeniedException(Exception exception)
        {
            var sqlexc = exception.InnerException as SqlException;
            return sqlexc != null
                   &&
                   (
                       sqlexc.Number == (int)SqlErrorMessage.PermissionDeniedInDatabase
                       || sqlexc.Number == (int)SqlErrorMessage.PermissionDeniedOnProcedure
                       || sqlexc.Number == (int)SqlErrorMessage.PermissionDeniedInOnColumn
                       || sqlexc.Number == (int)SqlErrorMessage.PermissionDeniedInOnObject
                   );
        }

    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Text.RegularExpressions;

namespace Subtext.Framework.Infrastructure.Installation
{
    internal class InstallationScriptInfo
    {
        //Have the compiled regex as static to get the full benefit of compilation
        private static readonly Regex ScriptParseRegex =
            new Regex(@"(?<ScriptName>Installation\.(?<version>\d+\.\d+\.\d+)\.sql)$",
                      RegexOptions.Compiled | RegexOptions.IgnoreCase);

        private InstallationScriptInfo(string scriptName, Version version)
        {
            Version = version;
            ScriptName = scriptName;
        }

        public string ScriptName { get; set; }

        public Version Version { get; set; }

        internal static InstallationScriptInfo Parse(string resourceName)
        {
            Match match = ScriptParseRegex.Match(resourceName);
            if(!match.Success)
            {
                return null;
            }
            var version = new Version(match.Groups["version"].Value);
            string scriptName = match.Groups["ScriptName"].Value;
            return new InstallationScriptInfo(scriptName, version);
        }
    }

}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Infrastructure.Installation
{
    /// <summary>
    /// Returns the current state of the installation.
    /// </summary>
    public enum InstallationState
    {
        /// <summary>No information available</summary>
        None = 0,
        /// <summary>Subtext is installed, but needs to be upgraded.</summary>
        NeedsUpgrade = 1,
        /// <summary>Subtext needs to be installed.</summary>
        NeedsInstallation = 3,
        /// <summary>Subtext is installed and seems to be working properly.</summary>
        Complete = 4,
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Data.SqlClient;
using System.IO;
using System.Reflection;
using System.Text;
using Subtext.Scripting;

namespace Subtext.Framework.Infrastructure.Installation
{
    /// <summary>
    /// Helper class used to execute SQL Scripts.
    /// </summary>
    public static class ScriptHelper
    {
        /// <summary>
        /// Executes the script.
        /// </summary>
        /// <remarks>
        /// Use script.Execute(transaction) to do the work. We will also pull the
        /// status of our script exection from here.
        /// </remarks>
        /// <param name="scriptName">Name of the script.</param>
        /// <param name="transaction">The current transaction.</param>
        public static void ExecuteScript(string scriptName, SqlTransaction transaction)
        {
            ExecuteScript(scriptName, transaction, null);
        }

        /// <summary>
        /// Executes the script.
        /// </summary>
        /// <remarks>
        /// Use script.Execute(transaction) to do the work. We will also pull the
        /// status of our script exection from here.
        /// </remarks>
        /// <param name="scriptName">Name of the script.</param>
        /// <param name="transaction">The current transaction.</param>
        /// <param name="dbUserName">Name of the DB owner.</param>
        public static void ExecuteScript(string scriptName, SqlTransaction transaction, string dbUserName)
        {
            var scriptRunner = new SqlScriptRunner(UnpackEmbeddedScript(scriptName), Encoding.UTF8);
            if(!string.IsNullOrEmpty(dbUserName))
            {
                scriptRunner.TemplateParameters.SetValue("dbUser", dbUserName);
            }
            scriptRunner.Execute(transaction);
        }

        /// <summary>
        /// Unpacks an embedded script into a string.
        /// </summary>
        /// <param name="scriptName">The file name of the script to run.</param>
        public static string UnpackEmbeddedScriptAsString(string scriptName)
        {
            Stream stream = UnpackEmbeddedScript(scriptName);
            using(var reader = new StreamReader(stream))
            {
                return reader.ReadToEnd();
            }
        }

        /// <summary>
        /// Unpacks an embedded script into a Stream.
        /// </summary>
        /// <param name="scriptName">Name of the script.</param>
        public static Stream UnpackEmbeddedScript(string scriptName)
        {
            Assembly assembly = Assembly.GetExecutingAssembly();
            return assembly.GetManifestResourceStream(typeof(ScriptHelper), string.Format("Scripts.{0}", scriptName));
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Text.RegularExpressions;

namespace Subtext.Scripting
{
    /// <summary>
    /// Class for parsing connection strings.  Will add the ability to 
    /// change connection string properties and have the full string work properly.
    /// </summary>
    [Serializable]
    public class ConnectionString
    {
        private static readonly ConnectionString EmptyConnectionString = new ConnectionString();

        //readonly string _connectionFormatString = "{0}={1};{2}={3};User ID={4};Password={5};{6}";
        //readonly string _trustedConnectionFormatString = "{0}={1};{2}={3};{4}";
        string _securityType;

        /// <summary>
        /// Initializes a new instance of the <see cref="ConnectionString"/> class.
        /// </summary>
        private ConnectionString()
        {
        }

        private ConnectionString(string connectionString)
        {
            RawOriginal = connectionString;
            ParseServer(connectionString);
            ParseDatabase(connectionString);
            ParseUserId(connectionString);
            ParsePassword(connectionString);
            ParseSecurityType(connectionString);
        }

        /// <summary>
        /// Return an empty instance of connection string
        /// </summary>
        public static ConnectionString Empty
        {
            get { return EmptyConnectionString; }
        }

        /// <summary>
        /// Gets the server.
        /// </summary>
        /// <value>The server.</value>
        public string Server { get; set; }


        /// <summary>
        /// Gets or sets the database this connection string connects to.
        /// </summary>
        /// <value>The database.</value>
        public string Database { get; set; }

        /// <summary>
        /// Gets or sets the user id.
        /// </summary>
        /// <value>The user id.</value>
        public string UserId { get; set; }

        /// <summary>
        /// Gets or sets the password.
        /// </summary>
        /// <value>The password.</value>
        public string Password { get; set; }

        /// <summary>
        /// Gets a value indicating whether [trusted connection].
        /// </summary>
        /// <value><c>true</c> if [trusted connection]; otherwise, <c>false</c>.</value>
        public bool TrustedConnection
        {
            get
            {
                return String.Equals(_securityType, "sspi", StringComparison.OrdinalIgnoreCase)
                       || String.Equals(_securityType, "true", StringComparison.OrdinalIgnoreCase);
            }

            set {
                _securityType = value ? "true" : String.Empty;
            }
        }

        public string RawOriginal { get; private set; }

        /// <summary>
        /// Parses the specified connection string.
        /// </summary>
        /// <param name="connectionString">The connection string.</param>
        /// <returns></returns>
        public static ConnectionString Parse(string connectionString)
        {
            return new ConnectionString(connectionString);
        }

        public static implicit operator string(ConnectionString connectionString)
        {
            return connectionString.ToString();
        }

        /// <summary>
        /// Returns a <see cref="T:System.String"/> that represents the current <see cref="T:System.Object"/>.
        /// </summary>
        /// <returns>
        /// A <see cref="T:System.String"/> that represents the current <see cref="T:System.Object"/>.
        /// </returns>
        public override string ToString()
        {
            return RawOriginal;
            //if(TrustedConnection)
            //    return string.Format(CultureInfo.InvariantCulture, _trustedConnectionFormatString, _serverFieldName, Server, _databaseFieldName, Database, _securityTypeText);
            //else
            //    return string.Format(CultureInfo.InvariantCulture, _connectionFormatString, _serverFieldName, Server, _databaseFieldName, Database, UserId, Password, _securityTypeText);
        }

        private void ParseServer(string connectionString)
        {
            var regex = new Regex(@"(?<serverField>Data\s+Source|Server)\s*=\s*(?<server>.*?)(;|$|\s)",
                                  RegexOptions.IgnoreCase);
            Match match = regex.Match(connectionString);
            if(match.Success)
            {
                Server = match.Groups["server"].Value;
            }
        }

        private void ParseDatabase(string connectionString)
        {
            var regex = new Regex(@"(?<databaseField>Database|Initial Catalog)\s*=\s*(?<database>.*?)(;|$|\s)",
                                  RegexOptions.IgnoreCase);
            Match match = regex.Match(connectionString);
            if(match.Success)
            {
                Database = match.Groups["database"].Value;
                if(!String.IsNullOrEmpty(Database))
                {
                    return;
                }
            }

            if(String.IsNullOrEmpty(Database))
            {
                regex = new Regex(@"AttachDbFilename\s*=\s*\|DataDirectory\|\\(?<database>.*?)(;|$|\s)",
                                  RegexOptions.IgnoreCase);
                match = regex.Match(connectionString);
                if(match.Success)
                {
                    Database = match.Groups["database"].Value;
                    if(!String.IsNullOrEmpty(Database))
                    {
                        return;
                    }
                }
            }
        }

        private void ParseUserId(string connectionString)
        {
            var regex = new Regex(@"User\s+Id\s*=\s*(?<userId>.*?)(;|$|\s)", RegexOptions.IgnoreCase);
            Match match = regex.Match(connectionString);
            if(match.Success)
            {
                UserId = match.Groups["userId"].Value;
            }
        }

        private void ParsePassword(string connectionString)
        {
            var regex = new Regex(@"Password\s*=\s*(?<password>.*?)(;|$|\s)", RegexOptions.IgnoreCase);
            Match match = regex.Match(connectionString);
            if(match.Success)
            {
                Password = match.Groups["password"].Value;
            }
        }

        private void ParseSecurityType(string connectionString)
        {
            var regex =
                new Regex(
                    @"(?<securityTypeField>Integrated\s+Security|Trusted_Connection)\s*=\s*(?<securityType>.*?)(;|$|\s)",
                    RegexOptions.IgnoreCase);
            Match match = regex.Match(connectionString);
            if(match.Success)
            {
                _securityType = match.Groups["securityType"].Value;
            }
        }

        /// <summary>
        /// Implicitly converts the string to a connection string.
        /// </summary>
        /// <remarks>
        /// Got the idea from here.  
        /// http://developer810.blogspot.com/2006/02/good-way-to-create-custom-value-type.html
        /// It's not as clear to me as doing .Parse... I'll think about this one.
        /// </remarks>
        /// <param name="connectionString">The state.</param>
        /// <returns></returns>
        public static implicit operator ConnectionString(string connectionString)
        {
            return new ConnectionString(connectionString);
        }
    }
}using System;
using System.Runtime.Serialization;
using System.Security.Permissions;

namespace Subtext.Scripting.Exceptions
{
    [Serializable]
    public class SqlParseException : Exception
    {
        public SqlParseException()
        {
        }

        public SqlParseException(string message) : base(message)
        {
        }

        public SqlParseException(string message, Exception exception)
            : base(message, exception)
        {
        }

        protected SqlParseException(SerializationInfo info, StreamingContext context) : base(info, context)
        {
        }

        [SecurityPermission(SecurityAction.LinkDemand, Flags = SecurityPermissionFlag.SerializationFormatter)]
        public override void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            base.GetObjectData(info, context);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using System.Runtime.Serialization;
using System.Security.Permissions;

namespace Subtext.Scripting.Exceptions
{
    /// <summary>
    /// Exception thrown when an error occurs during the execution of a script.
    /// </summary>
    /// <remarks>
    /// Contains a custom property, thus it Implements ISerializable 
    /// and the special serialization constructor.
    /// </remarks>
    [Serializable]
    public sealed class SqlScriptExecutionException : Exception, ISerializable
    {
        readonly int _returnValue;
        readonly Script _script;

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptExecutionException"/> class.
        /// </summary>
        public SqlScriptExecutionException()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptExecutionException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        public SqlScriptExecutionException(string message) : base(message)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptExecutionException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        /// <param name="innerException">The inner exception.</param>
        public SqlScriptExecutionException(string message, Exception innerException) : base(message, innerException)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptExecutionException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        /// <param name="script">The script.</param>
        /// <param name="returnValue">The return value.</param>
        public SqlScriptExecutionException(string message, Script script, int returnValue) : base(message)
        {
            _script = script;
            _returnValue = returnValue;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptExecutionException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        /// <param name="script">The script.</param>
        /// <param name="returnValue">The return value.</param>
        /// <param name="innerException">The inner exception.</param>
        public SqlScriptExecutionException(string message, Script script, int returnValue, Exception innerException)
            : base(message, innerException)
        {
            _script = script;
            _returnValue = returnValue;
        }

        // Because this class is sealed, this constructor is private. 
        // if this class is not sealed, this constructor should be protected.
        private SqlScriptExecutionException(SerializationInfo info, StreamingContext context) : base(info, context)
        {
            _script = info.GetValue("Script", typeof(string)) as Script;
        }

        /// <summary>
        /// Gets the script.
        /// </summary>
        public Script Script
        {
            get { return _script; }
        }

        /// <summary>
        /// Gets the return value.
        /// </summary>
        /// <value>The return value.</value>
        public int ReturnValue
        {
            get { return _returnValue; }
        }

        /// <summary>
        /// Gets a message that describes the current exception.
        /// </summary>
        /// <value></value>
        public override string Message
        {
            get
            {
                string message = base.Message;
                if(Script != null)
                {
                    message += string.Format(CultureInfo.InvariantCulture, "{0}ScriptName: {1}", Environment.NewLine,
                                             _script);
                }
                message += string.Format("Return Value: {0}", ReturnValue);
                return message;
            }
        }

        #region ISerializable Members

        /// <summary>
        /// When overridden in a derived class, sets the <see cref="T:System.Runtime.Serialization.SerializationInfo"/>
        /// with information about the exception.
        /// </summary>
        /// <param name="info">The <see cref="T:System.Runtime.Serialization.SerializationInfo"/> that holds the serialized object data about the exception being thrown.</param>
        /// <param name="context">The <see cref="T:System.Runtime.Serialization.StreamingContext"/> that contains contextual information about the source or destination.</param>
        /// <exception 
        [SecurityPermission(SecurityAction.LinkDemand, Flags = SecurityPermissionFlag.SerializationFormatter)]
        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("Script", _script);
            GetObjectData(info, context);
        }

        #endregion
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Data.SqlClient;

namespace Subtext.Scripting
{
    /// <summary>
    /// Interface implemented by a script.
    /// </summary>
    public interface IScript
    {
        int Execute(SqlTransaction transaction);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Scripting
{
    /// <summary>
    /// Template scripts contain template parameters that require user supplied values. 
    /// Defaults may be specified.  This works the same way as template parameters in 
    /// SQL Server.
    /// </summary>
    /// <remarks>
    /// For more information about template parameters, see
    /// <see href="http://haacked.com/archive/2005/07/01/7433.aspx" /> this post.
    /// </remarks>
    public interface ITemplateScript
    {
        /// <summary>
        /// Gets the template parameters embedded in the script.
        /// </summary>
        /// <returns></returns>
        TemplateParameterCollection TemplateParameters { get; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Scripting
{
    /// <summary>
    /// Contains information about when a template parameter value changes.
    /// </summary>
    public class ParameterValueChangedEventArgs : EventArgs
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ParameterValueChangedEventArgs"/> class.
        /// </summary>
        /// <param name="parameterName">Name of the parameter.</param>
        /// <param name="oldValue">The old value.</param>
        /// <param name="newValue">The new value.</param>
        public ParameterValueChangedEventArgs(string parameterName, string oldValue, string newValue)
        {
            OldValue = oldValue;
            NewValue = newValue;
            ParameterName = parameterName;
        }

        /// <summary>
        /// Gets the name of the parameter.
        /// </summary>
        /// <value>The name of the parameter.</value>
        public string ParameterName { get; private set; }

        /// <summary>
        /// Gets the old value.
        /// </summary>
        /// <value>The old value.</value>
        public string OldValue { get; private set; }

        /// <summary>
        /// Gets the new value.
        /// </summary>
        /// <value>The new value.</value>
        public string NewValue { get; private set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Data;
using System.Data.SqlClient;
using System.Globalization;
using System.Text;
using System.Text.RegularExpressions;
using Microsoft.ApplicationBlocks.Data;
using Subtext.Scripting.Exceptions;
using Subtext.Framework.Properties;

namespace Subtext.Scripting
{
    /// <summary>
    /// Represents a single executable script within the full SQL script.
    /// </summary>
    public class Script : IScript, ITemplateScript
    {
        TemplateParameterCollection _parameters;
        ScriptToken _scriptTokens;

        /// <summary>
        /// Creates a new <see cref="TemplateParameter"/> instance.
        /// </summary>
        /// <param name="scriptText">Script text.</param>
        public Script(string scriptText)
        {
            OriginalScriptText = scriptText;
        }

        /// <summary>
        /// Gets the script text after applying template parameter replacements. 
        /// This is the text of the script that will actually get executed.
        /// </summary>
        /// <value></value>
        public string ScriptText
        {
            get { return ApplyTemplateReplacements(); }
        }

        /// <summary>
        /// Gets the original script text.
        /// </summary>
        /// <value>The original script text.</value>
        public string OriginalScriptText { get; private set; }

        /// <summary>
        /// Executes this script.
        /// </summary>
        public int Execute(SqlTransaction transaction)
        {
            if(transaction == null)
            {
                throw new ArgumentNullException("transaction");
            }

            int returnValue = 0;
            try
            {
                returnValue = SqlHelper.ExecuteNonQuery(transaction, CommandType.Text, ScriptText);
                return returnValue;
            }
            catch(SqlException e)
            {
                throw new SqlScriptExecutionException(
                    String.Format(CultureInfo.InvariantCulture, Resources.SqlScriptExecutionError_ErrorInScript,
                                  ScriptText), this, returnValue, e);
            }
        }

        /// <summary>
        /// Gets the template parameters embedded in the script.
        /// </summary>
        /// <returns></returns>
        public TemplateParameterCollection TemplateParameters
        {
            get
            {
                if(_parameters == null)
                {
                    _parameters = new TemplateParameterCollection();

                    if(String.IsNullOrEmpty(OriginalScriptText))
                    {
                        return _parameters;
                    }

                    var regex =
                        new Regex(@"<\s*(?<name>[^()\[\]>,]*)\s*,\s*(?<type>[^>,]*)\s*,\s*(?<default>[^>,]*)\s*>",
                                  RegexOptions.Compiled);
                    MatchCollection matches = regex.Matches(OriginalScriptText);

                    _scriptTokens = new ScriptToken();

                    int lastIndex = 0;
                    foreach(Match match in matches)
                    {
                        if(match.Index > 0)
                        {
                            string textBeforeMatch = OriginalScriptText.Substring(lastIndex, match.Index - lastIndex);
                            _scriptTokens.Append(textBeforeMatch);
                        }

                        lastIndex = match.Index + match.Length;
                        TemplateParameter parameter = _parameters.Add(match);
                        _scriptTokens.Append(parameter);
                    }
                    string textAfterLastMatch = OriginalScriptText.Substring(lastIndex);
                    if(textAfterLastMatch.Length > 0)
                    {
                        _scriptTokens.Append(textAfterLastMatch);
                    }
                }
                return _parameters;
            }
        }

        /// <summary>
        /// Helper method which given a full SQL script, returns 
        /// a <see cref="ScriptCollection"/> of individual <see cref="TemplateParameter"/> 
        /// using "GO" as the delimiter.
        /// </summary>
        /// <param name="fullScriptText">Full script text.</param>
        public static ScriptCollection ParseScripts(string fullScriptText)
        {
            var scripts = new ScriptCollection(fullScriptText);
            var splitter = new ScriptSplitter(fullScriptText);

            foreach(string script in splitter)
            {
                scripts.Add(new Script(script));
            }

            return scripts;
        }

        string ApplyTemplateReplacements()
        {
            var builder = new StringBuilder();
            if(_scriptTokens == null && TemplateParameters == null)
            {
                throw new InvalidOperationException(Resources.InvalidOperation_TemplateParametersNull);
            }
            if(_scriptTokens != null)
            {
                _scriptTokens.AggregateText(builder);
            }
            return builder.ToString();
        }

        /// <summary>
        /// Returns the text of the script.
        /// </summary>
        /// <returns>
        /// A <see cref="T:System.String"/> that represents the current <see cref="T:System.Object"/>.
        /// </returns>
        public override string ToString()
        {
            if(_scriptTokens != null)
            {
                return _scriptTokens.ToString();
            }
            return Resources.ScriptHasNoTokens;
        }


        /// <summary>
        /// Implements a linked list representing the script.  This maps the structure 
        /// of a script making it trivial to replace template parameters with their 
        /// values.
        /// </summary>
        class ScriptToken
        {
            /// <summary>
            /// Initializes a new instance of the <see cref="ScriptToken"/> class.
            /// </summary>
            internal ScriptToken()
            {
            }

            /// <summary>
            /// Initializes a new instance of the <see cref="ScriptToken"/> class.
            /// </summary>
            /// <param name="text">The text.</param>
            private ScriptToken(string text)
            {
                Text = text;
            }

            /// <summary>
            /// Gets the text.
            /// </summary>
            /// <value>The text.</value>
            protected virtual string Text { get; set; }

            /// <summary>
            /// Gets or sets the next node.
            /// </summary>
            /// <value>The next.</value>
            protected ScriptToken Next { get; private set; }

            /// <summary>
            /// Gets the last node.
            /// </summary>
            /// <value>The last.</value>
            private ScriptToken Last
            {
                get
                {
                    ScriptToken last = this;
                    ScriptToken next = Next;

                    while(next != null)
                    {
                        last = next;
                        next = last.Next;
                    }
                    return last;
                }
            }

            /// <summary>
            /// Appends the specified text.
            /// </summary>
            /// <param name="text">The text.</param>
            internal void Append(string text)
            {
                Last.Next = new ScriptToken(text);
            }

            internal void Append(TemplateParameter parameter)
            {
                Last.Next = new TemplateParameterToken(parameter);
            }

            internal void AggregateText(StringBuilder builder)
            {
                builder.Append(Text);
                if(Next != null)
                {
                    Next.AggregateText(builder);
                }
            }

            /// <summary>
            /// Returns a <see cref="T:System.String"/> that represents the current <see cref="ScriptToken"/>.
            /// </summary>
            /// <returns>
            /// A <see cref="T:System.String"/> that represents the current <see cref="T:System.Object"/>.
            /// </returns>
            public override string ToString()
            {
                int length = 0;
                if(Text != null)
                {
                    length = Text.Length;
                }
                string result = string.Format(CultureInfo.InvariantCulture, @"<ScriptToken length=""{0}"">{1}", length,
                                              Environment.NewLine);
                if(Next != null)
                {
                    result += Next.ToString();
                }
                return result;
            }
        }

        #region Nested type: TemplateParameterToken

        /// <summary>
        /// Represents a template parameter within a script.  This is specialized node 
        /// within the ScriptToken linked list.
        /// </summary>
        class TemplateParameterToken : ScriptToken
        {
            readonly TemplateParameter _parameter;

            internal TemplateParameterToken(TemplateParameter parameter)
            {
                _parameter = parameter;
            }

            /// <summary>
            /// Gets the text of this node.
            /// </summary>
            /// <value>The text.</value>
            protected override string Text
            {
                get { return _parameter.Value; }
            }

            /// <summary>
            /// Returns a <see cref="T:System.String"/> that represents the current <see cref="TemplateParameterToken"/>.
            /// </summary>
            /// <returns>
            /// A <see cref="T:System.String"/> that represents the current <see cref="T:System.Object"/>.
            /// </returns>
            public override string ToString()
            {
                string result = "<TemplateParameter";
                if(_parameter != null)
                {
                    result += string.Format(CultureInfo.InvariantCulture, @" name=""{0}"" value=""{1}"" type=""{2}""",
                                            _parameter.Name, _parameter.Value, _parameter.DataType);
                }
                result += string.Format(" />{0}", Environment.NewLine);
                if(Next != null)
                {
                    result += Next.ToString();
                }
                return result;
            }
        }

        #endregion
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;

namespace Subtext.Scripting
{
    /// <summary>
    /// A collection of <see cref="Script"/>s.
    /// </summary>
    public class ScriptCollection : Collection<Script>, ITemplateScript
    {
        readonly string _fullScriptText; //Original unexpanded script.
        TemplateParameterCollection _templateParameters;

        /// <summary>
        /// Initializes a new instance of the <see cref="ScriptCollection"/> class.
        /// </summary>
        /// <param name="fullScriptText">The full script text.</param>
        internal ScriptCollection(string fullScriptText)
        {
            _fullScriptText = fullScriptText;
        }

        /// <summary>
        /// Gets the original full unexpanded script text.
        /// </summary>
        /// <value>The full script text.</value>
        public string FullScriptText
        {
            get { return _fullScriptText; }
        }

        /// <summary>
        /// Gets the expanded script text.
        /// </summary>
        /// <value>The expanded script text.</value>
        public string ExpandedScriptText
        {
            get
            {
                var builder = new StringBuilder();
                ApplyTemplatesToScripts();
                foreach(Script script in this)
                {
                    builder.Append(script.ScriptText);
                    builder.Append(Environment.NewLine);
                    builder.Append("GO");
                    builder.Append(Environment.NewLine);
                    builder.Append(Environment.NewLine);
                }
                return builder.ToString();
            }
        }

        #region ITemplateScript Members

        /// <summary>
        /// Gets the template parameters embedded in the script.
        /// </summary>
        /// <returns></returns>
        public TemplateParameterCollection TemplateParameters
        {
            get
            {
                if(_templateParameters == null)
                {
                    _templateParameters = new TemplateParameterCollection();
                    foreach(Script script in this)
                    {
                        _templateParameters.AddRange(script.TemplateParameters);
                    }
                    _templateParameters.ValueChanged += TemplateParametersValueChanged;
                }

                return _templateParameters;
            }
        }

        #endregion

        /// <summary>
        /// Adds the contents of another <see cref="ScriptCollection">ScriptCollection</see> 
        /// to the end of the collection.
        /// </summary>
        /// <param name="value">A <see cref="ScriptCollection">ScriptCollection</see> containing the <see cref="Script"/>s to add to the collection. </param>
        public void AddRange(IEnumerable<Script> value)
        {
            if(value == null)
            {
                throw new ArgumentNullException("value");
            }

            foreach(Script script in value)
            {
                Add(script);
            }
        }

        internal void ApplyTemplatesToScripts()
        {
            foreach(TemplateParameter parameter in TemplateParameters)
            {
                foreach(Script script in this)
                {
                    if(script.TemplateParameters.Contains(parameter.Name))
                    {
                        script.TemplateParameters[parameter.Name].Value = parameter.Value;
                    }
                }
            }
        }

        private void TemplateParametersValueChanged(object sender, ParameterValueChangedEventArgs args)
        {
            ApplyTemplatesToScripts();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using Subtext.Scripting.Exceptions;
using Subtext.Framework.Properties;

namespace Subtext.Scripting
{
    public class ScriptSplitter : IEnumerable<string>
    {
        private readonly TextReader _reader;
        private StringBuilder _builder = new StringBuilder();
        private char _current;
        private char _lastChar;
        private ScriptReader _scriptReader;

        public ScriptSplitter(string script)
        {
            _reader = new StringReader(script);
            _scriptReader = new SeparatorLineReader(this);
        }

        internal bool HasNext
        {
            get { return _reader.Peek() != -1; }
        }

        internal char Current
        {
            get { return _current; }
        }

        internal char LastChar
        {
            get { return _lastChar; }
        }

        #region IEnumerable<string> Members

        public IEnumerator<string> GetEnumerator()
        {
            while(Next())
            {
                if(Split())
                {
                    string script = _builder.ToString().Trim();
                    if(script.Length > 0)
                    {
                        yield return (script);
                    }
                    Reset();
                }
            }
            if(_builder.Length > 0)
            {
                string scriptRemains = _builder.ToString().Trim();
                if(scriptRemains.Length > 0)
                {
                    yield return (scriptRemains);
                }
            }
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }

        #endregion

        internal bool Next()
        {
            if(!HasNext)
            {
                return false;
            }

            _lastChar = _current;
            _current = (char)_reader.Read();
            return true;
        }

        internal int Peek()
        {
            return _reader.Peek();
        }

        private bool Split()
        {
            return _scriptReader.ReadNextSection();
        }

        internal void SetParser(ScriptReader newReader)
        {
            _scriptReader = newReader;
        }

        internal void Append(string text)
        {
            _builder.Append(text);
        }

        internal void Append(char c)
        {
            _builder.Append(c);
        }

        void Reset()
        {
            _current = _lastChar = char.MinValue;
            _builder = new StringBuilder();
        }
    }

    abstract class ScriptReader
    {
        protected readonly ScriptSplitter Splitter;

        protected ScriptReader(ScriptSplitter splitter)
        {
            Splitter = splitter;
        }

        /// <summary>
        /// This acts as a template method. Specific Reader instances 
        /// override the component methods.
        /// </summary>
        public bool ReadNextSection()
        {
            if(IsQuote)
            {
                ReadQuotedString();
                return false;
            }

            if(BeginDashDashComment)
            {
                return ReadDashDashComment();
            }

            if(BeginSlashStarComment)
            {
                ReadSlashStarComment();
                return false;
            }

            return ReadNext();
        }

        protected virtual bool ReadDashDashComment()
        {
            Splitter.Append(Current);
            while(Splitter.Next())
            {
                Splitter.Append(Current);
                if(EndOfLine)
                {
                    break;
                }
            }
            //We should be EndOfLine or EndOfScript here.
            Splitter.SetParser(new SeparatorLineReader(Splitter));
            return false;
        }

        protected virtual void ReadSlashStarComment()
        {
            if(ReadSlashStarCommentWithResult())
            {
                Splitter.SetParser(new SeparatorLineReader(Splitter));
                return;
            }
        }

        private bool ReadSlashStarCommentWithResult()
        {
            Splitter.Append(Current);
            while(Splitter.Next())
            {
                if(BeginSlashStarComment)
                {
                    ReadSlashStarCommentWithResult();
                    continue;
                }
                Splitter.Append(Current);

                if(EndSlashStarComment)
                {
                    return true;
                }
            }
            return false;
        }

        protected virtual void ReadQuotedString()
        {
            Splitter.Append(Current);
            while(Splitter.Next())
            {
                Splitter.Append(Current);
                if(IsQuote)
                {
                    return;
                }
            }
        }

        protected abstract bool ReadNext();

        #region Helper methods and properties

        protected bool HasNext
        {
            get { return Splitter.HasNext; }
        }

        protected bool WhiteSpace
        {
            get { return char.IsWhiteSpace(Splitter.Current); }
        }

        protected bool EndOfLine
        {
            get { return '\n' == Splitter.Current; }
        }

        protected bool IsQuote
        {
            get { return '\'' == Splitter.Current; }
        }

        protected char Current
        {
            get { return Splitter.Current; }
        }

        protected char LastChar
        {
            get { return Splitter.LastChar; }
        }

        bool BeginDashDashComment
        {
            get { return Current == '-' && Peek() == '-'; }
        }

        bool BeginSlashStarComment
        {
            get { return Current == '/' && Peek() == '*'; }
        }

        bool EndSlashStarComment
        {
            get { return LastChar == '*' && Current == '/'; }
        }

        protected static bool CharEquals(char expected, char actual)
        {
            return Char.ToLowerInvariant(expected) == Char.ToLowerInvariant(actual);
        }

        protected bool CharEquals(char compare)
        {
            return CharEquals(Current, compare);
        }

        protected char Peek()
        {
            if(!HasNext)
            {
                return char.MinValue;
            }
            return (char)Splitter.Peek();
        }

        #endregion
    }

    class SeparatorLineReader : ScriptReader
    {
        private StringBuilder _builder = new StringBuilder();
        private bool _foundGo;
        private bool _gFound;

        public SeparatorLineReader(ScriptSplitter splitter)
            : base(splitter)
        {
        }

        void Reset()
        {
            _foundGo = false;
            _gFound = false;
            _builder = new StringBuilder();
        }

        protected override bool ReadDashDashComment()
        {
            if(!_foundGo)
            {
                base.ReadDashDashComment();
                return false;
            }
            base.ReadDashDashComment();
            return true;
        }

        protected override void ReadSlashStarComment()
        {
            if(_foundGo)
            {
                throw new SqlParseException(Resources.SqlParseException_IncorrectSyntaxNearGo);
            }
            base.ReadSlashStarComment();
        }

        protected override bool ReadNext()
        {
            if(EndOfLine) //End of line or script
            {
                if(!_foundGo)
                {
                    _builder.Append(Current);
                    Splitter.Append(_builder.ToString());
                    Splitter.SetParser(new SeparatorLineReader(Splitter));
                    return false;
                }
                Reset();
                return true;
            }

            if(WhiteSpace)
            {
                _builder.Append(Current);
                return false;
            }

            if(!CharEquals('g') && !CharEquals('o'))
            {
                FoundNonEmptyCharacter(Current);
                return false;
            }

            if(CharEquals('o'))
            {
                if(CharEquals('g', LastChar) && !_foundGo)
                {
                    _foundGo = true;
                }
                else
                {
                    FoundNonEmptyCharacter(Current);
                }
            }

            if(CharEquals('g', Current))
            {
                if(_gFound || (!Char.IsWhiteSpace(LastChar) && LastChar != char.MinValue))
                {
                    FoundNonEmptyCharacter(Current);
                    return false;
                }

                _gFound = true;
            }

            if(!HasNext && _foundGo)
            {
                Reset();
                return true;
            }

            _builder.Append(Current);
            return false;
        }

        void FoundNonEmptyCharacter(char c)
        {
            _builder.Append(c);
            Splitter.Append(_builder.ToString());
            Splitter.SetParser(new SqlScriptReader(Splitter));
        }
    }

    class SqlScriptReader : ScriptReader
    {
        public SqlScriptReader(ScriptSplitter splitter)
            : base(splitter)
        {
        }

        protected override bool ReadNext()
        {
            if(EndOfLine) //end of line
            {
                Splitter.Append(Current);
                Splitter.SetParser(new SeparatorLineReader(Splitter));
                return false;
            }

            Splitter.Append(Current);
            return false;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Data.SqlClient;
using System.IO;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using Subtext.Scripting.Exceptions;
using Subtext.Framework.Properties;

namespace Subtext.Scripting
{
    /// <summary>
    /// Class used to manage and execute SQL scripts.  
    /// Can also be used to hand
    /// </summary>
    public class SqlScriptRunner : IScript, ITemplateScript
    {
        readonly ScriptCollection _scripts;

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptRunner"/> class.  
        /// Initializes the script to execute.
        /// </summary>
        /// <p>
        /// Suppose an assembly Foo.dll contains an embedded resource "Bar.sql" in a folder 
        /// named "Scripts".  To execute the embedded script, pass in any type within the 
        /// namespace "Foo" and pass the scriptname of "Scripts.Bar.sql".  Or pass in a type 
        /// in the namespace "Foo.Scripts" and pass in the scriptname of "Bar.sql".
        /// </p>
        /// <param name="scopingType">
        ///	A type whose assembly contains the script as an embedded resource. 
        ///	Also used to scope the script name. See remarks.
        /// </param>
        /// <param name="scriptName">Name of the script.</param>
        /// <param name="encoding">The encoding.</param>
        public SqlScriptRunner(Type scopingType, string scriptName, Encoding encoding)
            : this(UnpackEmbeddedScript(scopingType, scriptName), encoding)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptRunner"/> class.
        /// </summary>
        /// <p>
        /// Suppose an assembly Foo.dll contains an embedded resource "Bar.sql" in a folder 
        /// named "Scripts".  To execute the embedded script, pass in any type within the 
        /// namespace "Foo" and pass the scriptname of "Scripts.Bar.sql".  Or pass in a type 
        /// in the namespace "Foo.Scripts" and pass in the scriptname of "Bar.sql".
        /// </p>
        /// <param name="assemblyWithEmbeddedScript">The assembly containing the script as an embedded resource.</param>
        /// <param name="scopingType">
        ///	Used to scope the script name within the embedded resource.
        /// </param>
        /// <param name="scriptName">Name of the script.</param>
        /// <param name="encoding">The encoding.</param>
        public SqlScriptRunner(Assembly assemblyWithEmbeddedScript, Type scopingType, string scriptName,
                               Encoding encoding)
            : this(UnpackEmbeddedScript(assemblyWithEmbeddedScript, scopingType, scriptName), encoding)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptRunner"/> class.
        /// Initializes the script to execute.
        /// </summary>
        /// <param name="assemblyWithEmbeddedScript">The assembly with the script as an embedded resource.</param>
        /// <param name="fullScriptName">Fully qualified resource name of the script.</param>
        /// <param name="encoding">The encoding.</param>
        public SqlScriptRunner(Assembly assemblyWithEmbeddedScript, string fullScriptName, Encoding encoding)
            : this(UnpackEmbeddedScript(assemblyWithEmbeddedScript, fullScriptName), encoding)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptRunner"/> class.
        /// </summary>
        /// <param name="scriptStream">The stream containing the script to execute.</param>
        /// <param name="encoding">The encoding.</param>
        public SqlScriptRunner(Stream scriptStream, Encoding encoding) : this(ReadStream(scriptStream, encoding))
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptRunner"/> class.
        /// </summary>
        /// <param name="scriptText">The full script text to execute.</param>
        public SqlScriptRunner(string scriptText) : this(Script.ParseScripts(scriptText))
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="SqlScriptRunner"/> class.
        /// </summary>
        /// <param name="scripts">The scripts.</param>
        public SqlScriptRunner(ScriptCollection scripts)
        {
            _scripts = scripts;
        }

        /// <summary>
        /// Gets the script collection this runner is executing.
        /// </summary>
        /// <value>The script collection.</value>
        public ScriptCollection ScriptCollection
        {
            get { return _scripts; }
        }

        #region IScript Members

        /// <summary>
        /// Executes the script.
        /// </summary>
        /// <remarks>
        /// Use script.Execute(transaction) to do the work. We will also pull the
        /// status of our script exection from here.
        /// </remarks>
        /// <param name="transaction">The current transaction.</param>
        public int Execute(SqlTransaction transaction)
        {
            int recordsAffectedTotal = 0;
            SetNoCountOff(transaction);

            // the following reg exp will be used to determine if each script is an
            // INSERT, UPDATE, or DELETE operation. The reg exp is also only looking
            // for these actions on the SubtextData database. <- do we need this last part?
            const string regextStr = @"(INSERT\sINTO\s[\s\w\d\)\(\,\.\]\[\>\<]+)|(UPDATE\s[\s\w\d\)\(\,\.\]\[\>\<]+SET\s)|(DELETE\s[\s\w\d\)\(\,\.\]\[\>\<]+FROM\s[\s\w\d\)\(\,\.\]\[\>\<]+WHERE\s)";
            var regex = new Regex(regextStr,
                                  RegexOptions.IgnorePatternWhitespace | RegexOptions.IgnoreCase | RegexOptions.Compiled |
                                  RegexOptions.Multiline);

            _scripts.ApplyTemplatesToScripts();
            foreach(Script script in _scripts)
            {
                int returnValue = script.Execute(transaction);

                Match match = regex.Match(script.ScriptText);
                if(match.Success)
                {
                    /* 
					 * For UPDATE, INSERT, and DELETE statements, the return value is the 
					 * number of rows affected by the command. For all other types of statements, 
					 * the return value is -1. If a rollback occurs, the return value is also -1. 
					 */
                    if(!IsCrudScript(script))
                    {
                        continue;
                    }

                    if(returnValue > -1)
                    {
                        recordsAffectedTotal += returnValue;
                    }
                    else
                    {
                        throw new SqlScriptExecutionException(Resources.SqlScriptExecutionError_ErrorOccurred, script,
                                                              returnValue);
                    }
                }
            }
            return recordsAffectedTotal;
        }

        #endregion

        #region ITemplateScript Members

        /// <summary>
        /// Gets the template parameters embedded in the script.
        /// </summary>
        /// <returns></returns>
        public TemplateParameterCollection TemplateParameters
        {
            get { return _scripts.TemplateParameters; }
        }

        #endregion

        private static bool IsCrudScript(Script script)
        {
            return script.ScriptText.IndexOf("TRIGGER", StringComparison.OrdinalIgnoreCase) == -1
                   && script.ScriptText.IndexOf("PROC", StringComparison.OrdinalIgnoreCase) == -1;
        }

        /// <summary>
        /// Temporarily set NOCOUNT OFF on the connection. We must do this b/c the SqlScriptRunner 
        /// depends on all CRUD statements returning the number of effected rows to determine if an 
        /// error occured. This isn't a perfect solution, but it's what we've got.
        /// </summary>
        /// <param name="transaction"></param>
        private static void SetNoCountOff(SqlTransaction transaction)
        {
            var noCount = new Script("SET NOCOUNT OFF");
            noCount.Execute(transaction);
        }

        static string ReadStream(Stream stream, Encoding encoding)
        {
            using(var reader = new StreamReader(stream, encoding))
            {
                return reader.ReadToEnd();
            }
        }

        static Stream UnpackEmbeddedScript(Type scopingType, string scriptName)
        {
            Assembly assembly = scopingType.Assembly;
            return assembly.GetManifestResourceStream(scopingType, scriptName);
        }

        static Stream UnpackEmbeddedScript(Assembly assembly, Type scopingType, string scriptName)
        {
            return assembly.GetManifestResourceStream(scopingType, scriptName);
        }

        static Stream UnpackEmbeddedScript(Assembly assembly, string fullScriptName)
        {
            return assembly.GetManifestResourceStream(fullScriptName);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Scripting
{
    /// <summary>
    /// Summary description for TemplateParameter.
    /// </summary>
    [Serializable]
    public class TemplateParameter
    {
        string _value;

        /// <summary>
        /// Initializes a new instance of the <see cref="TemplateParameter"/> class.
        /// </summary>
        /// <param name="name">The name.</param>
        /// <param name="type">The type.</param>
        /// <param name="defaultValue">The default value.</param>
        public TemplateParameter(string name, string type, string defaultValue)
        {
            Name = name;
            DataType = type;
            _value = defaultValue;
        }

        /// <summary>
        /// Gets or sets the name of the parameter.
        /// </summary>
        /// <value>The name.</value>
        public string Name { get; private set; }

        /// <summary>
        /// Gets the type of the data.
        /// </summary>
        /// <value>The type of the data.</value>
        public string DataType { get; private set; }

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        /// <value>The value.</value>
        public string Value
        {
            get { return _value; }
            set
            {
                if(value != _value)
                {
                    OnValueChanged(_value, value);
                }
                _value = value;
            }
        }

        protected void OnValueChanged(string oldValue, string newValue)
        {
            EventHandler<ParameterValueChangedEventArgs> changeEvent = ValueChanged;
            if(changeEvent != null)
            {
                changeEvent(this, new ParameterValueChangedEventArgs(Name, oldValue, newValue));
            }
        }

        /// <summary>
        /// Event raised when the parameter's value changes.
        /// </summary>
        public event EventHandler<ParameterValueChangedEventArgs> ValueChanged;
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Subtext.Scripting
{
    /// <summary>
    /// A collection of <see cref="TemplateParameter"/> instances.
    /// </summary>
    public class TemplateParameterCollection : ICollection<TemplateParameter>
    {
        readonly List<TemplateParameter> _list = new List<TemplateParameter>();

        /// <summary>
        /// Gets the <see cref="TemplateParameter"/> at the specified index.
        /// </summary>
        /// <value></value>
        public TemplateParameter this[int index]
        {
            get { return _list[index]; }
        }

        /// <summary>
        /// Gets the <see cref="TemplateParameter"/> with the specified name.
        /// </summary>
        /// <value></value>
        public TemplateParameter this[string name]
        {
            get
            {
                foreach(TemplateParameter parameter in _list)
                {
                    if(String.Equals(parameter.Name, name, StringComparison.OrdinalIgnoreCase))
                    {
                        return parameter;
                    }
                }
                return null;
            }
        }

        #region ICollection<TemplateParameter> Members

        void ICollection<TemplateParameter>.Add(TemplateParameter item)
        {
            Add(item);
        }

        public void Clear()
        {
            _list.Clear();
        }

        /// <summary>
        /// Gets a value indicating whether the collection contains the specified 
        /// <see cref="TemplateParameter">Script</see>.
        /// </summary>
        public bool Contains(TemplateParameter item)
        {
            if(item == null)
            {
                throw new ArgumentNullException("item");
            }

            return Contains(item.Name);
        }

        public void CopyTo(TemplateParameter[] array, int arrayIndex)
        {
            _list.CopyTo(array, arrayIndex);
        }

        public int Count
        {
            get { return _list.Count; }
        }

        public bool IsReadOnly
        {
            get { return false; }
        }

        /// <summary>
        /// Removes the specified value.
        /// </summary>
        public bool Remove(TemplateParameter item)
        {
            return _list.Remove(item);
        }

        #endregion

        #region IEnumerable<TemplateParameter> Members

        IEnumerator<TemplateParameter> IEnumerable<TemplateParameter>.GetEnumerator()
        {
            return _list.GetEnumerator();
        }

        public IEnumerator GetEnumerator()
        {
            return _list.GetEnumerator();
        }

        #endregion

        /// <summary>
        /// Determines whether [contains] [the specified name].
        /// </summary>
        /// <param name="name">The name.</param>
        /// <returns>
        /// 	<c>true</c> if [contains] [the specified name]; otherwise, <c>false</c>.
        /// </returns>
        public bool Contains(string name)
        {
            return this[name] != null;
        }

        /// <summary>
        /// Creates a template parameter from a match.
        /// </summary>
        /// <param name="match">The match.</param>
        /// <returns></returns>
        public TemplateParameter Add(Match match)
        {
            if(match == null)
            {
                throw new ArgumentNullException("match");
            }

            if(this[match.Groups["name"].Value] != null)
            {
                return this[match.Groups["name"].Value];
            }

            var parameter = new TemplateParameter(match.Groups["name"].Value, match.Groups["type"].Value,
                                                  match.Groups["default"].Value);
            Add(parameter);
            return parameter;
        }

        /// <summary>
        /// Adds the specified value. If it already exists, returns 
        /// the existing one, otherwise just returns the one you added.
        /// </summary>
        /// <param name="value">Value.</param>
        /// <returns></returns>
        public TemplateParameter Add(TemplateParameter value)
        {
            if(value == null)
            {
                throw new ArgumentNullException("value");
            }

            if(Contains(value))
            {
                return this[value.Name];
            }
            _list.Add(value);
            value.ValueChanged += OnValueChanged;
            return value;
        }

        /// <summary>
        /// Adds the contents of another <see cref="ScriptCollection">ScriptCollection</see> 
        /// to the end of the collection.
        /// </summary>
        /// <param name="value">A <see cref="ScriptCollection">ScriptCollection</see> containing the <see cref="TemplateParameter"/>s to add to the collection. </param>
        public void AddRange(IEnumerable<TemplateParameter> value)
        {
            foreach(TemplateParameter parameter in value)
            {
                Add(parameter);
            }
        }

        /// <summary>
        /// Gets the index in the collection of the specified 
        /// <see cref="TemplateParameter">Script</see>, if it exists in the collection.
        /// </summary>
        /// <param name="value">The <see cref="TemplateParameter">Script</see> 
        /// to locate in the collection.</param>
        /// <returns>The index in the collection of the specified object, if found; otherwise, -1.</returns>
        public int IndexOf(TemplateParameter value)
        {
            return _list.IndexOf(value);
        }

        /// <summary>
        /// Provides a shortcut to set a value.
        /// </summary>
        /// <param name="name">The name.</param>
        /// <param name="value">The value.</param>
        public void SetValue(string name, string value)
        {
            if(this[name] != null)
            {
                this[name].Value = value;
            }
        }

        private void OnValueChanged(object sender, ParameterValueChangedEventArgs args)
        {
            OnValueChanged(args);
        }

        protected void OnValueChanged(ParameterValueChangedEventArgs args)
        {
            EventHandler<ParameterValueChangedEventArgs> changeEvent = ValueChanged;
            if(changeEvent != null)
            {
                changeEvent(this, args);
            }
        }

        /// <summary>
        /// Event raised when any parameter within this collection changes 
        /// its values.
        /// </summary>
        public event EventHandler<ParameterValueChangedEventArgs> ValueChanged;
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data.SqlClient;
using System.Reflection;
using Subtext.Framework.Data;

namespace Subtext.Framework.Infrastructure.Installation
{
    public class SqlInstaller : IInstaller
    {
        private readonly string _connectionString;

        public SqlInstaller(string connectionString)
        {
            _connectionString = connectionString;
        }

        public string DBUser { get; set; }

        public void Install(Version assemblyVersion)
        {
            using(var connection = new SqlConnection(_connectionString))
            {
                connection.Open();
                using(SqlTransaction transaction = connection.BeginTransaction())
                {
                    try
                    {
                        ReadOnlyCollection<string> scripts = ListInstallationScripts(GetCurrentInstallationVersion(),
                                                                                     VersionInfo.CurrentAssemblyVersion);
                        foreach(string scriptName in scripts)
                        {
                            ScriptHelper.ExecuteScript(scriptName, transaction, DBUser);
                        }

                        ScriptHelper.ExecuteScript("StoredProcedures.sql", transaction, DBUser);
                        UpdateInstallationVersionNumber(assemblyVersion, transaction);
                        transaction.Commit();
                    }
                    catch(Exception)
                    {
                        transaction.Rollback();
                        throw;
                    }
                }
            }
        }

        /// <summary>
        /// Upgrades this instance. Returns true if it was successful.
        /// </summary>
        /// <returns></returns>
        public void Upgrade(Version currentAssemblyVersion)
        {
            using(var connection = new SqlConnection(_connectionString))
            {
                connection.Open();
                using(SqlTransaction transaction = connection.BeginTransaction())
                {
                    try
                    {
                        Version installationVersion = GetCurrentInstallationVersion() ?? new Version(1, 0, 0, 0);
                        ReadOnlyCollection<string> scripts = ListInstallationScripts(installationVersion, currentAssemblyVersion);
                        foreach(string scriptName in scripts)
                        {
                            ScriptHelper.ExecuteScript(scriptName, transaction, DBUser);
                        }
                        ScriptHelper.ExecuteScript("StoredProcedures.sql", transaction, DBUser);

                        UpdateInstallationVersionNumber(currentAssemblyVersion, transaction);
                        transaction.Commit();
                    }
                    catch(Exception)
                    {
                        transaction.Rollback();
                        throw;
                    }
                }
            }
        }

        /// <summary>
        /// Returns a collection of installation script names with a version 
        /// less than or equal to the max version.
        /// </summary>
        /// <param name="minVersionExclusive">The min verison exclusive.</param>
        /// <param name="maxVersionInclusive">The max version inclusive.</param>
        /// <returns></returns>
        public static ReadOnlyCollection<string> ListInstallationScripts(Version minVersionExclusive,
                                                                         Version maxVersionInclusive)
        {
            Assembly assembly = Assembly.GetExecutingAssembly();
            string[] resourceNames = assembly.GetManifestResourceNames();
            var collection = new List<string>();
            foreach(string resourceName in resourceNames)
            {
                InstallationScriptInfo scriptInfo = InstallationScriptInfo.Parse(resourceName);
                if(scriptInfo == null)
                {
                    continue;
                }

                if((minVersionExclusive == null || scriptInfo.Version > minVersionExclusive)
                   && (maxVersionInclusive == null || scriptInfo.Version <= maxVersionInclusive))
                {
                    collection.Add(scriptInfo.ScriptName);
                }
            }

            var scripts = new string[collection.Count];
            collection.CopyTo(scripts, 0);
            Array.Sort(scripts);

            return new ReadOnlyCollection<string>(new List<string>(scripts));
        }

        /// <summary>
        /// Updates the value of the current installed version within the subtext_Version table.
        /// </summary>
        /// <param name="newVersion">New version.</param>
        /// <param name="transaction">The transaction to perform this action within.</param>
        public static void UpdateInstallationVersionNumber(Version newVersion, SqlTransaction transaction)
        {
            var procedures = new StoredProcedures(transaction);
            procedures.VersionAdd(newVersion.Major, newVersion.Minor, newVersion.Build, DateTime.Now);
        }

        /// <summary>
        /// Gets the <see cref="Version"/> of the current Subtext data store (ie. SQL Server). 
        /// This is the value stored in the database. If it does not match the actual 
        /// assembly version, we may need to run an upgrade.
        /// </summary>
        /// <returns></returns>
        public Version GetCurrentInstallationVersion()
        {
            var procedures = new StoredProcedures(_connectionString);
            try
            {
                using(var reader = procedures.VersionGetCurrent())
                {
                    if(reader.Read())
                    {
                        var version = new Version((int)reader["Major"], (int)reader["Minor"], (int)reader["Build"]);
                        reader.Close();
                        return version;
                    }
                }
            }
            catch(SqlException exception)
            {
                if(exception.Number != (int)SqlErrorMessage.CouldNotFindStoredProcedure)
                {
                    throw;
                }
            }
            return null;
        }

        /// <summary>
        /// Gets a value indicating whether the subtext installation needs an upgrade 
        /// to occur.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [needs upgrade]; otherwise, <c>false</c>.
        /// </value>
        public bool NeedsUpgrade(Version installationVersion, Version currentAssemblyVersion)
        {
            if(installationVersion >= currentAssemblyVersion)
            {
                return false;
            }

            if(installationVersion == null)
            {
                //This is the base version.  We need to hardcode this 
                //because Subtext 1.0 didn't write the assembly version 
                //into the database.
                installationVersion = new Version(1, 0, 0, 0);
            }
            ReadOnlyCollection<string> scripts = ListInstallationScripts(installationVersion, currentAssemblyVersion);
            return scripts.Count > 0;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web;

namespace Subtext.Infrastructure
{
    public interface IServiceLocator
    {
        TService GetService<TService>();
        object GetService(Type type);
        void DisposeRequestScoped(HttpContext httpContext);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Infrastructure
{
    public interface ITimeZone
    {
        /// <summary>
        /// This is the current date and time in this time zone
        /// </summary>
        DateTime Now { get; }

        /// <summary>
        /// This is the current UTC date and time
        /// </summary>
        DateTime UtcNow { get; }

        /// <summary>
        /// This is the current date and time based on the server's time zone.
        /// </summary>
        DateTime ServerNow { get; }

        /// <summary>
        /// Converts the specified DateTime instance to UTC
        /// </summary>
        /// <param name="dateTime"></param>
        /// <returns></returns>
        DateTime ToUtc(DateTime dateTime);

        /// <summary>
        /// Converts the specified UTC DateTime to this timezone.
        /// </summary>
        /// <param name="dateTime"></param>
        /// <returns></returns>
        DateTime FromUtc(DateTime dateTime);

        /// <summary>
        /// Converts the specified DateTime instance to the server's (local) time zone
        /// </summary>
        /// <param name="dateTime"></param>
        /// <returns></returns>
        DateTime ToServerDateTime(DateTime dateTime);

        /// <summary>
        /// Converts the specified DateTime instance to this time zone from the specified time zone.
        /// </summary>
        /// <param name="dateTime"></param>
        /// <param name="sourceTimeZone"></param>
        /// <returns></returns>
        DateTime FromTimeZone(DateTime dateTime, TimeZoneInfo sourceTimeZone);

        /// <summary>
        /// Returns true if the specified date is in the past, otherwise false.
        /// </summary>
        /// <param name="dateTime"></param>
        /// <param name="sourceTimeZone"></param>
        /// <returns></returns>
        bool IsInPast(DateTime dateTime, TimeZoneInfo sourceTimeZone);

        /// <summary>
        /// Returns true if the specified date is in the future, otherwise false.
        /// </summary>
        /// <param name="dateTime"></param>
        /// <param name="sourceTimeZone"></param>
        /// <returns></returns>
        bool IsInFuture(DateTime dateTime, TimeZoneInfo sourceTimeZone);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web;
using System.Web.Mvc;
using System.Xml;
using Subtext.Framework.Properties;

namespace Subtext.Framework.ModelBinders
{
    public class XmlModelBinder : IModelBinder
    {
        public object BindModel(ControllerContext controllerContext, ModelBindingContext bindingContext)
        {
            HttpRequestBase request = controllerContext.HttpContext.Request;
            if(request.ContentType != "text/xml")
            {
                throw new InvalidOperationException(Resources.InvalidOperation_ContentTypeMustBeXml);
            }

            var doc = new XmlDocument();
            doc.Load(controllerContext.HttpContext.Request.InputStream);
            return doc;
        }
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web;
using Ninject;
using Ninject.Activation.Caching;
using Subtext.Infrastructure;

namespace Subtext.Framework.Infrastructure
{
    public class NinjectServiceLocator : IServiceLocator
    {
        public NinjectServiceLocator(IKernel kernel)
        {
            Kernel = kernel;
        }

        public IKernel Kernel
        {
            get; 
            private set;
        }

        public TService GetService<TService>()
        {
            return Kernel.Get<TService>();
        }

        public object GetService(Type type)
        {
            return Kernel.Get(type);
        }

        public void DisposeRequestScoped(HttpContext httpContext)
        {
            var cache = Kernel.Components.Get<Ninject.Activation.Caching.ICache>() as Cache;
            if(cache != null)
            {
                cache.DisposeRequestScoped(httpContext);
            }
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using System.Web.Routing;
using Subtext.Framework.Routing;

namespace Subtext.Infrastructure
{
    public class PipelineService
    {
        public PipelineService(HttpContextBase httpContext, IServiceLocator serviceProvider)
        {
            HttpContext = httpContext;
            ServiceProvider = serviceProvider;
        }

        protected HttpContextBase HttpContext { get; private set; }
        protected IServiceLocator ServiceProvider { get; private set; }

        public void ProcessRootRequest(RootRoute route, IRouteHandler routeHandler)
        {
            // todo: unit test this method
            var request = HttpContext.Request;
            RouteData routeData = route.GetRouteData(HttpContext);
            var requestContext = new RequestContext(HttpContext, routeData);
            string originalPath = request.Path;
            HttpContext.RewritePath(request.ApplicationPath, false);
            IHttpHandler httpHandler = routeHandler.GetHttpHandler(requestContext);
            httpHandler.ProcessRequest(System.Web.HttpContext.Current);
            HttpContext.RewritePath(originalPath);
        }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web.Routing;
using Subtext.Framework.Components;

namespace Subtext.Framework.Routing
{
    public class AdminUrlHelper
    {
        public AdminUrlHelper(UrlHelper urlHelper)
        {
            Url = urlHelper;
        }

        public UrlHelper Url { get; private set; }

        public VirtualPath Home()
        {
            return Url.AdminUrl("");
        }

        public VirtualPath Rss()
        {
            return Url.AdminUrl("adminRss.axd");
        }

        public VirtualPath ImportExport()
        {
            return Url.AdminUrl("ImportExport.aspx");
        }

        public VirtualPath Export(bool embedAttachments)
        {
            return Url.GetVirtualPath("export", new RouteValueDictionary{ {"embed", embedAttachments }});
        }

        public VirtualPath PostsList()
        {
            return Url.AdminUrl("posts");
        }

        public VirtualPath PostsEdit()
        {
            return Url.AdminUrl("posts/edit.aspx");
        }

        //TODO: Unit test
        public VirtualPath PostsEdit(int id)
        {
            return Url.AdminUrl("posts/edit.aspx", new {PostId = id});
        }

        public VirtualPath ArticlesList()
        {
            return Url.AdminUrl("articles");
        }

        public VirtualPath ArticlesEdit()
        {
            return Url.AdminUrl("articles/edit.aspx");
        }

        public VirtualPath ArticlesEdit(int id)
        {
            return Url.AdminUrl("articles/edit.aspx", new { PostId = id });
        }

        public VirtualPath FeedbackList()
        {
            return Url.AdminUrl("feedback");
        }

        //TODO: Unit test
        public VirtualPath FeedbackEdit(int id)
        {
            var routeValues = new RouteValueDictionary {{"return-to-post", "true"}, {"FeedbackID", id}};
            return Url.AdminUrl("feedback/edit.aspx", routeValues);
        }

        public VirtualPath LinksEdit()
        {
            return Url.AdminUrl("EditLinks.aspx");
        }

        public VirtualPath GalleriesEdit()
        {
            return Url.AdminUrl("EditGalleries.aspx");
        }

        public VirtualPath Referrers(int id)
        {
            return Url.AdminUrl("Referrers.aspx", new { EntryId = id });
        }

        public VirtualPath Statistics()
        {
            return Url.AdminUrl("Statistics.aspx");
        }

        public VirtualPath Options()
        {
            return Url.AdminUrl("Options.aspx");
        }

        public VirtualPath Credits()
        {
            return Url.AdminUrl("Credits.aspx");
        }

        public VirtualPath EditCategories()
        {
            return Url.AdminUrl("EditCategories.aspx");
        }

        public VirtualPath EditCategories(CategoryType categoryType)
        {
            return Url.AdminUrl("EditCategories.aspx", new {catType = categoryType});
        }

        public VirtualPath EditGalleries()
        {
            return Url.AdminUrl("EditGalleries.aspx");
        }

        public VirtualPath EditLinks()
        {
            return Url.AdminUrl("EditLinks.aspx");
        }

        public VirtualPath ErrorLog()
        {
            return Url.AdminUrl("ErrorLog.aspx");
        }

        public VirtualPath FullTextSearch()
        {
            return Url.AdminUrl("FullTextSearch.aspx");
        }

        public VirtualPath AjaxServices()
        {
            return Url.GetVirtualPath("ajax-services", null);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using System.Web.Routing;

namespace Subtext.Framework.Routing
{
    /// <summary>
    /// Aggregate blogs enablement must match this constraint for the route to match.
    /// </summary>
    public class AggregateEnabledConstraint : IRouteConstraint
    {
        public AggregateEnabledConstraint(HostInfo host, bool matchWhenAggregateBlogsEnabled)
        {
            MatchWhenAggregateBlogsEnabled = matchWhenAggregateBlogsEnabled;
            Host = host;
        }

        protected HostInfo Host { get; private set; }

        public bool MatchWhenAggregateBlogsEnabled { get; private set; }

        //Should always return true for non root requests...

        #region IRouteConstraint Members

        public bool Match(HttpContextBase httpContext, Route route, string parameterName, RouteValueDictionary values,
                          RouteDirection routeDirection)
        {
            if(routeDirection == RouteDirection.UrlGeneration)
            {
                return true;
            }

            return Match(Host.BlogAggregationEnabled);
        }

        #endregion

        public bool Match(bool aggregateBlogsEnabled)
        {
            return (aggregateBlogsEnabled == MatchWhenAggregateBlogsEnabled);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public class DirectoryRoute : SubtextRoute, IDirectoryRoute
    {
        public DirectoryRoute(string directoryName, IServiceLocator serviceLocator) :
            base(directoryName + "/{*pathInfo}", new DirectoryRouteHandler(serviceLocator.GetService<ISubtextPageBuilder>(), serviceLocator))
        {
            DirectoryName = directoryName;
        }
        
        public string DirectoryName
        {
            get; 
            private set;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.IO;
using System.Web;
using System.Web.Routing;
using Subtext.Framework.Properties;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public class DirectoryRouteHandler : PageRouteHandler
    {
        public DirectoryRouteHandler(ISubtextPageBuilder pageBuilder, IServiceLocator serviceLocator)
            : base(null, pageBuilder, serviceLocator)
        {
        }

        protected override IHttpHandler GetHandler(RequestContext requestContext)
        {
            RouteData routeData = requestContext.RouteData;
            var route = routeData.Route as IDirectoryRoute;
            if(route == null)
            {
                throw new InvalidOperationException(
                    Resources.InvalidOperation_DirectoryRouteHandlerWorksWithDirectoryRoutes);
            }

            string virtualPath = string.Format("~/aspx/{0}/{1}", route.DirectoryName, routeData.Values["pathinfo"]);
            if(String.IsNullOrEmpty(Path.GetExtension(virtualPath)))
            {
                if(!virtualPath.EndsWith("/"))
                {
                    virtualPath += "/";
                }
                virtualPath += "Default.aspx";
            }
            VirtualPath = virtualPath;
            return base.GetHandler(requestContext);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using System.Web.Routing;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public class HttpRouteHandler<THandler> : RouteHandlerBase where THandler : IHttpHandler
    {
        public HttpRouteHandler(IServiceLocator serviceLocator)
            : base(serviceLocator)
        {
        }

        protected override IHttpHandler GetHandler(RequestContext requestContext)
        {
            Bootstrapper.RequestContext = requestContext;
            return ServiceLocator.GetService<THandler>();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Routing
{
    public interface IDirectoryRoute
    {
        string DirectoryName { get; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web.Routing;

namespace Subtext.Framework.Routing
{
    /// <summary>
    /// When ignoring routes, we also want to ignore for rendering 
    /// the virtual path. Unfortunately, routing doesn't do this 
    /// yet.
    /// </summary>
    public class IgnoreRoute : Route
    {
        public IgnoreRoute(string url) : base(url, new StopRoutingHandler())
        {
        }

        public override VirtualPathData GetVirtualPath(RequestContext requestContext, RouteValueDictionary values)
        {
            return null;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using System.Web.Routing;

namespace Subtext.Framework.Routing
{
    /// <summary>
    /// Special route for gallery images. It's used to generate URLs, but never to 
    /// match incoming requests.
    /// </summary>
    public class ImageRoute : Route
    {
        public ImageRoute(string url) : base(url, null)
        {
            Defaults = new RouteValueDictionary(new {filename = string.Empty, id = string.Empty});
        }

        public override RouteData GetRouteData(HttpContextBase httpContext)
        {
            return null;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Web;

namespace Subtext.Framework.Routing
{
    public interface IPageWithControls : IHttpHandler
    {
        void SetControls(IEnumerable<string> controls);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using Ninject;
using Subtext.Framework.Providers;

namespace Subtext.Framework.Routing
{
    public interface ISubtextHandler : IHttpHandler
    {
        [Inject]
        ISubtextContext SubtextContext { get; }

        UrlHelper Url { get; }

        ObjectProvider Repository { get; }

        AdminUrlHelper AdminUrl { get; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Routing
{
    public interface ISubtextPageBuilder
    {
        object CreateInstanceFromVirtualPath(string virtualPath, Type type);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Linq;
using System.Web.Routing;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public class PageRoute : SubtextRoute
    {
        public const string ControlNamesKey = "controls";

        public PageRoute(string url, string virtualPath, IEnumerable<string> controls, IServiceLocator serviceLocator)
            : this(url, virtualPath, controls, serviceLocator.GetService<ISubtextPageBuilder>(), serviceLocator)
        {
        }

        public PageRoute(string url, string virtualPath, IEnumerable<string> controls, ISubtextPageBuilder pageBuilder,
                         IServiceLocator serviceLocator)
            : base(url, new PageRouteHandler(virtualPath, pageBuilder, serviceLocator))
        {
            DataTokens = new RouteValueDictionary {{ControlNamesKey, controls.AsEnumerable()}};
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Routing;
using System.Web.UI;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public class PageRouteHandler : RouteHandlerBase
    {
        public PageRouteHandler(string virtualPath, ISubtextPageBuilder pageBuilder, IServiceLocator serviceLocator)
            : base(serviceLocator)
        {
            VirtualPath = virtualPath;
            PageBuilder = pageBuilder;
        }

        protected ISubtextPageBuilder PageBuilder { get; set; }

        public string VirtualPath { get; protected set; }

        protected override IHttpHandler GetHandler(RequestContext requestContext)
        {
            Bootstrapper.RequestContext = requestContext;
            var page = PageBuilder.CreateInstanceFromVirtualPath(VirtualPath, typeof(Page)) as IHttpHandler;

            if(page != null)
            {
                var pageWithControls = page as IPageWithControls;
                if(pageWithControls != null)
                {
                    if(requestContext.RouteData.DataTokens != null)
                    {
                        IEnumerable<string> controls = requestContext.RouteData.GetControlNames();
                        pageWithControls.SetControls(controls);
                    }
                }
            }
            return page;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Linq;
using System.Web;
using System.Web.Routing;
using Subtext.Framework.Web.HttpModules;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    // We need special handling of requests for the root due 
    // to the whole aggregate blog situation.
    public class RootRoute : RouteBase
    {
        Route _subfolderAppRootRoute;
        Route _subfolderDefaultRoute;

        public RootRoute(bool blogAggregationEnabled, IServiceLocator serviceLocator)
            : this(blogAggregationEnabled, null, null, serviceLocator)
        {
        }

        public RootRoute(bool blogAggregationEnabled, IRouteHandler normalRouteHandler, IRouteHandler aggRouteHandler,
                         IServiceLocator serviceLocator)
        {
            BlogAggregationEnabled = blogAggregationEnabled;
            NormalRouteHandler = normalRouteHandler ??
                                 new PageRouteHandler("~/aspx/Dtp.aspx", serviceLocator.GetService<ISubtextPageBuilder>(), serviceLocator);
            AggregateRouteHandler = aggRouteHandler ??
                                    new PageRouteHandler("~/aspx/AggDefault.aspx", serviceLocator.GetService<ISubtextPageBuilder>(), serviceLocator);
        }

        protected bool BlogAggregationEnabled { get; private set; }

        private Route SubfolderDefaultRoute
        {
            get
            {
                if(_subfolderDefaultRoute == null)
                {
                    _subfolderDefaultRoute = new Route("{subfolder}/default.aspx", NormalRouteHandler)
                    {
                        DataTokens =
                            new RouteValueDictionary {{PageRoute.ControlNamesKey, new[] {"homepage"}.AsEnumerable()}}
                    };
                }
                return _subfolderDefaultRoute;
            }
        }

        private Route SubfolderAppRootRoute
        {
            get
            {
                if(_subfolderAppRootRoute == null)
                {
                    _subfolderAppRootRoute = new Route("{subfolder}", NormalRouteHandler)
                    {
                        DataTokens =
                            new RouteValueDictionary {{PageRoute.ControlNamesKey, new[] {"homepage"}.AsEnumerable()}}
                    };
                }
                return _subfolderAppRootRoute;
            }
        }

        public IRouteHandler AggregateRouteHandler { get; private set; }

        public IRouteHandler NormalRouteHandler { get; private set; }

        private IRouteHandler GetHandler()
        {
            return BlogAggregationEnabled ? AggregateRouteHandler : NormalRouteHandler;
        }

        public override RouteData GetRouteData(HttpContextBase httpContext)
        {
            string appExecutionPath = httpContext.Request.AppRelativeCurrentExecutionFilePath;

            if(appExecutionPath == "~/" ||
               String.Equals(appExecutionPath, "~/default.aspx", StringComparison.OrdinalIgnoreCase))
            {
                var appRootRouteData = new RouteData
                {
                    Route = this,
                    RouteHandler = GetHandler(),
                };
                if(!BlogAggregationEnabled)
                {
                    appRootRouteData.DataTokens.Add(PageRoute.ControlNamesKey, new[] {"homepage"}.AsEnumerable());
                }
                return appRootRouteData;
            }

            var blogRequest = httpContext.Items[BlogRequest.BlogRequestKey] as BlogRequest;
            if(blogRequest == null || String.IsNullOrEmpty(blogRequest.Subfolder))
            {
                return null;
            }

            RouteData routeData = SubfolderAppRootRoute.GetRouteData(httpContext) ??
                                  SubfolderDefaultRoute.GetRouteData(httpContext);
            if(routeData != null)
            {
                routeData.Route = this;
                if(!String.Equals(blogRequest.Subfolder, routeData.GetSubfolder(), StringComparison.OrdinalIgnoreCase))
                {
                    return null;
                }
            }
            return routeData;
        }

        public override VirtualPathData GetVirtualPath(RequestContext requestContext, RouteValueDictionary values)
        {
            object subfolderValue;
            if(values == null || !values.TryGetValue("subfolder", out subfolderValue))
            {
                requestContext.RouteData.Values.TryGetValue("subfolder", out subfolderValue);
            }

            var subfolder = subfolderValue as string;

            if(!String.IsNullOrEmpty(subfolder))
            {
                VirtualPathData vpd = SubfolderAppRootRoute.GetVirtualPath(requestContext,
                                                                           new RouteValueDictionary(new {subfolder}));
                vpd.Route = this;
                return vpd;
            }

            if(values == null || values.Count == 0)
            {
                return new VirtualPathData(this, string.Empty);
            }
            return null;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using System.Web.Routing;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public abstract class RouteHandlerBase : IRouteHandler
    {
        protected RouteHandlerBase(IServiceLocator serviceLocator)
        {
            ServiceLocator = serviceLocator;
        }

        public IServiceLocator ServiceLocator
        {
            get; 
            private set;
        }

        IHttpHandler IRouteHandler.GetHttpHandler(RequestContext requestContext)
        {
            Bootstrapper.RequestContext = requestContext;
            return GetHandler(requestContext);
        }

        protected abstract IHttpHandler GetHandler(RequestContext requestContext);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web;
using System.Web.Routing;

namespace Subtext.Framework.Routing
{
    class SubfolderRoute : Route
    {
        readonly Route _parent;

        public SubfolderRoute(Route parent) : base("{subfolder}/" + parent.Url, parent.RouteHandler)
        {
            _parent = parent;
            Constraints = parent.Constraints;
            Defaults = parent.Defaults;
            DataTokens = parent.DataTokens;
        }

        public RouteData GetRouteData(HttpContextBase httpContext, string subfolder)
        {
            RouteData routeData = GetRouteData(httpContext);
            if(routeData != null)
            {
                if(!String.Equals(subfolder, routeData.GetSubfolder(), StringComparison.OrdinalIgnoreCase))
                {
                    return null;
                }
            }
            return routeData;
        }

        public override RouteData GetRouteData(HttpContextBase httpContext)
        {
            RouteData routeData = base.GetRouteData(httpContext);
            if(routeData != null)
            {
                routeData.Route = _parent;
            }
            return routeData;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web.Compilation;
using Ninject;

namespace Subtext.Framework.Routing
{
    public class SubtextPageBuilder : ISubtextPageBuilder
    {
        public SubtextPageBuilder(IKernel kernel)
        {
            Kernel = kernel;
        }

        public IKernel Kernel { get; private set; }

        #region ISubtextPageBuilder Members

        public object CreateInstanceFromVirtualPath(string virtualPath, Type type)
        {
            object instance = BuildManager.CreateInstanceFromVirtualPath(virtualPath, type);
            Kernel.Inject(instance);
            return instance;
        }

        #endregion
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web;
using System.Web.Routing;
using Subtext.Framework.Web.HttpModules;

namespace Subtext.Framework.Routing
{
    public class SubtextRoute : Route
    {
        SubfolderRoute _subfolderRoute;

        public SubtextRoute(string url, IRouteHandler routeHandler)
            : base(url, routeHandler)
        {
        }

        private SubfolderRoute RouteForSubfolder
        {
            get
            {
                SubfolderRoute subfolderRoute = _subfolderRoute;
                //Not going to lock...
                if(subfolderRoute == null)
                {
                    subfolderRoute = new SubfolderRoute(this);
                    _subfolderRoute = subfolderRoute;
                }
                return subfolderRoute;
            }
        }

        public virtual RouteData GetRouteData(HttpContextBase httpContext, BlogRequest blogRequest)
        {
            RouteData routeData;
            if(String.IsNullOrEmpty(blogRequest.Subfolder))
            {
                routeData = base.GetRouteData(httpContext);
                if(routeData != null)
                {
                    //Add current subfolder info.
                    routeData.Values.Add("subfolder", string.Empty);
                }
            }
            else
            {
                routeData = RouteForSubfolder.GetRouteData(httpContext, blogRequest.Subfolder);
            }

            return routeData;
        }

        public override RouteData GetRouteData(HttpContextBase httpContext)
        {
            var request = (BlogRequest)httpContext.Items[BlogRequest.BlogRequestKey];
            return GetRouteData(httpContext, request);
        }

        public override VirtualPathData GetVirtualPath(RequestContext requestContext, RouteValueDictionary values)
        {
            var subfolderInRouteData = requestContext.RouteData.Values["subfolder"] as string;
            if(String.IsNullOrEmpty(subfolderInRouteData) && values != null)
            {
                subfolderInRouteData = values["subfolder"] as string;
            }
            if(String.IsNullOrEmpty(subfolderInRouteData))
            {
                return base.GetVirtualPath(requestContext, values);
            }
            return RouteForSubfolder.GetVirtualPath(requestContext, values);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web.Routing;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public class SubtextRouteMapper
    {
        public SubtextRouteMapper(RouteCollection routes, IServiceLocator serviceLocator)
        {
            Routes = routes;
            ServiceLocator = serviceLocator;
        }

        public IServiceLocator ServiceLocator
        {
            get; 
            private set;
        }

        protected RouteCollection Routes { get; private set; }

        public void Add(string routeName, RouteBase route)
        {
            Routes.Add(routeName, route);
        }

        public void Add(RouteBase route)
        {
            Routes.Add(route);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using Subtext.Framework.XmlRpc;

namespace Subtext.Framework.Routing
{
    public static class SubtextRouteExtensions
    {
        public static IEnumerable<string> GetControlNames(this RouteData routeData)
        {
            if(routeData.DataTokens == null)
            {
                return null;
            }
            return routeData.DataTokens[PageRoute.ControlNamesKey] as IEnumerable<string>;
        }

        public static void MapDirectory(this SubtextRouteMapper routes, string directoryName)
        {
            routes.Add(directoryName, new DirectoryRoute(directoryName, routes.ServiceLocator));
        }

        public static void MapSystemDirectories(this SubtextRouteMapper routes, params string[] directoryNames)
        {
            foreach(var directoryName in directoryNames)
            {
                routes.MapSystemDirectory(directoryName);
            }
        }

        public static void MapSystemDirectory(this SubtextRouteMapper routes, string directoryName)
        {
            routes.Add(directoryName, new SystemDirectoryRoute(directoryName, routes.ServiceLocator));
        }

        public static void MapControls(this SubtextRouteMapper routes, string url, object constraints,
                                       IEnumerable<string> controls)
        {
            routes.MapControls(null, url, ToRouteValueDictionary(constraints), controls, null);
        }

        public static void MapControls(this SubtextRouteMapper routes, string url, RouteValueDictionary constraints,
                                       IEnumerable<string> controls)
        {
            routes.MapControls(null, url, constraints, controls, null);
        }

        public static void MapControls(this SubtextRouteMapper routes, string name, string url, object constraints,
                                       IEnumerable<string> controls)
        {
            routes.MapControls(name, url, ToRouteValueDictionary(constraints), controls, null);
        }

        public static void MapControls(this SubtextRouteMapper routes, string name, string url,
                                       RouteValueDictionary constraints, IEnumerable<string> controls)
        {
            routes.MapControls(name, url, constraints, controls, null);
        }

        public static void MapControls(this SubtextRouteMapper routes, string name, string url,
                                       RouteValueDictionary constraints, IEnumerable<string> controls, RouteValueDictionary defaults)
        {
            var pageRoute = 
            new PageRoute(url, "~/aspx/Dtp.aspx", controls, routes.ServiceLocator)
            {
                Constraints = constraints,
                Defaults = defaults
            };
            routes.Add(name, pageRoute);
        }

        public static void MapControls(this SubtextRouteMapper routes, string url, IEnumerable<string> controls)
        {
            routes.MapControls(url, null, controls);
        }

        public static void MapPagesToControlOfSameName(this SubtextRouteMapper routes, params string[] controlNames)
        {
            foreach(var controlName in controlNames)
            {
                routes.MapPageToControl(controlName);
            }
        }

        public static void MapPageToControl(this SubtextRouteMapper routes, string controlName)
        {
            routes.MapControls(controlName, controlName + ".aspx", null, new[] {controlName});
        }

        /// <summary>
        /// We need special handling here because of Aggregate blogs.
        /// </summary>
        /// <param name="routes"></param>
        public static void MapRoot(this SubtextRouteMapper routes)
        {
            routes.Add("root",
                       new RootRoute(
                           String.Equals(ConfigurationManager.AppSettings["AggregateEnabled"], "true",
                                         StringComparison.OrdinalIgnoreCase), routes.ServiceLocator));
        }

        public static void MapPage(this SubtextRouteMapper routes, string name)
        {
            string url = string.Format("{0}.aspx", name);
            routes.Add(name, new SubtextRoute(url, new PageRouteHandler(string.Format("~/aspx/{0}", url), routes.ServiceLocator.GetService<ISubtextPageBuilder>(), routes.ServiceLocator)));
        }

        public static void MapSystemPage(this SubtextRouteMapper routes, string name)
        {
            string url = string.Format("{0}.aspx", name);
            routes.Add(name,
                       new Route(url,
                                 new PageRouteHandler(string.Format("~/aspx/{0}", url), routes.ServiceLocator.GetService<ISubtextPageBuilder>(),
                                                      routes.ServiceLocator)));
        }

        public static void MapHttpHandler<THttpHandler>(this SubtextRouteMapper routes, string name, string url)
            where THttpHandler : IHttpHandler
        {
            routes.Add(name, new SubtextRoute(url, new HttpRouteHandler<THttpHandler>(routes.ServiceLocator)));
        }

        public static void MapHttpHandler<THttpHandler>(this SubtextRouteMapper routes, string url)
            where THttpHandler : IHttpHandler
        {
            routes.MapHttpHandler<THttpHandler>(null, url);
        }

        public static void MapXmlRpcHandler<TXmlRpcHandler>(this SubtextRouteMapper routes, string url,
                                                            object constraints)
            where TXmlRpcHandler : SubtextXmlRpcService
        {
            routes.Add(new SubtextRoute(url, new XmlRpcRouteHandler<TXmlRpcHandler>(routes.ServiceLocator)));
        }

        public static void MapXmlRpcHandler<TXmlRpcHandler>(this SubtextRouteMapper routes, string name, string url,
                                                            object constraints)
            where TXmlRpcHandler : SubtextXmlRpcService
        {
            routes.Add(name, new SubtextRoute(url, new XmlRpcRouteHandler<TXmlRpcHandler>(routes.ServiceLocator)));
        }

        public static void MapHttpHandler<THttpHandler>(this SubtextRouteMapper routes, string name, string url,
                                                        object constraints) where THttpHandler : IHttpHandler
        {
            var route = new SubtextRoute(url, new HttpRouteHandler<THttpHandler>(routes.ServiceLocator))
            {
                Constraints = ToRouteValueDictionary(constraints)
            };
            routes.Add(name, route);
        }

        public static void MapHttpHandler<THttpHandler>(this SubtextRouteMapper routes, string url, object constraints)
            where THttpHandler : IHttpHandler
        {
            routes.MapHttpHandler<THttpHandler>(null, url, constraints);
        }

        public static void MapImageRoute(this SubtextRouteMapper routes, string routeName, string url)
        {
            routes.Add(routeName, new ImageRoute(url));
        }
        
        public static void MapRoute(this SubtextRouteMapper routes, string routeName, string url, object defaults)
        {
            routes.MapRoute(routeName, url, defaults, null);
        }

        public static void MapRoute(this SubtextRouteMapper routes, string routeName, string url, object defaults,
                                    object constraints)
        {
            routes.Add(routeName, new SubtextRoute(url, new MvcRouteHandler())
            {
                Defaults = ToRouteValueDictionary(defaults),
                Constraints = ToRouteValueDictionary(constraints)
            });
        }

        public static void Ignore(this SubtextRouteMapper routes, string url)
        {
            routes.Add(new IgnoreRoute(url));
        }

        public static string GetSubfolder(this RouteData routeData)
        {
            return routeData.Values["subfolder"] as string;
        }

        private static RouteValueDictionary ToRouteValueDictionary(object anonymousDictionary)
        {
            if(anonymousDictionary == null)
            {
                return null;
            }
            if(anonymousDictionary is RouteValueDictionary)
            {
                return (RouteValueDictionary)anonymousDictionary;
            }
            return new RouteValueDictionary(anonymousDictionary);
        }

        public static Uri ToFullyQualifiedUrl(this VirtualPath virtualPath, Blog blog)
        {
            if(virtualPath == null)
            {
                return null;
            }

            if(blog == null)
            {
                throw new ArgumentNullException("blog");
            }

            var builder = new UriBuilder {Scheme = "http", Host = blog.Host};
            if(HttpContext.Current != null && HttpContext.Current.Request != null && HttpContext.Current.Request.Url.Port != 80)
            {
                builder.Port = HttpContext.Current.Request.Url.Port;
            }
            return new Uri(builder.Uri, virtualPath);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web.Routing;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public class SystemDirectoryRoute : Route, IDirectoryRoute
    {
        public SystemDirectoryRoute(string directoryName, IServiceLocator serviceLocator)
            : base(directoryName + "/{*pathInfo}", new DirectoryRouteHandler(serviceLocator.GetService<ISubtextPageBuilder>(), serviceLocator))
        {
            DirectoryName = directoryName;
        }

        public string DirectoryName { get; private set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Configuration;
using System.Globalization;
using System.Text.RegularExpressions;
using System.Web;
using System.Web.Routing;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Properties;
using Subtext.Framework.Web;

namespace Subtext.Framework.Routing
{
    public class UrlHelper
    {
        protected UrlHelper()
        {
        }

        public UrlHelper(RequestContext context, RouteCollection routes)
        {
            RequestContext = context ??
                             new RequestContext(new HttpContextWrapper(System.Web.HttpContext.Current), new RouteData());
            Routes = routes ?? RouteTable.Routes;
        }

        public HttpContextBase HttpContext
        {
            get { return RequestContext.HttpContext; }
        }

        protected RequestContext RequestContext { get; private set; }

        public RouteCollection Routes { get; private set; }

        public virtual VirtualPath AppRoot()
        {
            return new VirtualPath(GetNormalizedAppPath());
        }

        private string GetNormalizedAppPath()
        {
            string appRoot = HttpContext.Request.ApplicationPath;
            if(!appRoot.EndsWith("/"))
            {
                appRoot += "/";
            }
            return appRoot;
        }

        public virtual VirtualPath CommentUpdateStatus()
        {
            return GetVirtualPath("comments-admin", 
                new RouteValueDictionary {{"action", "updatestatus"}, {"controller", "comment"}});
        }

        public virtual VirtualPath CommentDestroy()
        {
            return GetVirtualPath("comments-admin",
                new RouteValueDictionary { { "action", "destroy" }, { "controller", "comment" } });
        }

        public virtual VirtualPath FeedbackUrl(FeedbackItem comment)
        {
            if(comment == null)
            {
                throw new ArgumentNullException("comment");
            }
            if(comment.FeedbackType == FeedbackType.ContactPage || comment.Entry == null)
            {
                return null;
            }
            string entryUrl = EntryUrl(comment.Entry);
            if(string.IsNullOrEmpty(entryUrl))
            {
                return null;
            }
            return string.Format("{0}#{1}", entryUrl, comment.Id);
        }

        public virtual VirtualPath EntryUrl(IEntryIdentity entry)
        {
            return EntryUrl(entry, null);
        }

        public virtual VirtualPath EntryUrl(IEntryIdentity entry, Blog entryBlog)
        {
            if(entry == null)
            {
                throw new ArgumentNullException("entry");
            }
            if(entry.PostType == PostType.None)
            {
                throw new ArgumentException(Resources.Argument_EntryMustHaveValidPostType, "entry");
            }

            if(NullValue.IsNull(entry.Id))
            {
                return null;
            }

            string routeName;
            var routeValues = new RouteValueDictionary();

            if(entry.PostType == PostType.BlogPost)
            {
#if DEBUG
                var blogEntry = entry as Entry;
                if(blogEntry != null && blogEntry.IsActive && blogEntry.DateSyndicated.Year == 1)
                {
                    throw new InvalidOperationException("DateSyndicated was not properly set.");
                }
#endif
                routeValues.Add("year", entry.DateSyndicated.ToString("yyyy", CultureInfo.InvariantCulture));
                routeValues.Add("month", entry.DateSyndicated.ToString("MM", CultureInfo.InvariantCulture));
                routeValues.Add("day", entry.DateSyndicated.ToString("dd", CultureInfo.InvariantCulture));
                routeName = "entry-";
            }
            else
            {
                routeName = "article-";
            }

            if(string.IsNullOrEmpty(entry.EntryName))
            {
                routeValues.Add("id", entry.Id);
                routeName += "by-id";
            }
            else
            {
                routeValues.Add("slug", entry.EntryName);
                routeName += "by-slug";
            }
            if(entryBlog != null)
            {
                routeValues.Add("subfolder", entryBlog.Subfolder);
            }

            VirtualPathData virtualPath = Routes.GetVirtualPath(RequestContext, routeName, routeValues);
            if(virtualPath != null)
            {
                return virtualPath.VirtualPath;
            }
            return null;
        }

        private static string NormalizeFileName(string filename)
        {
            if(filename.StartsWith("/"))
            {
                return filename.Substring(1);
            }
            return filename;
        }

        private string GetImageDirectoryTildePath(Blog blog)
        {
            string host = blog.Host.Replace(":", "_").Replace(".", "_");
            string appPath = GetNormalizedAppPath().Replace(".", "_");
            string subfolder = String.IsNullOrEmpty(blog.Subfolder) ? String.Empty : blog.Subfolder + "/";
            return string.Format("~/images/{0}{1}{2}", host, appPath, subfolder);
        }

        private string GetImageTildePath(Blog blog, string filename)
        {
            return GetImageDirectoryTildePath(blog) + NormalizeFileName(filename);
        }

        private string GetGalleryImageTildePath(Image image, string filename)
        {
            return string.Format("{0}{1}/{2}", GetImageDirectoryTildePath(image.Blog), image.CategoryID, filename);
        }

        /// <summary>
        /// Returns the URL for an image that was uploaded to a blog via MetaWeblog API. The image 
        /// is not associated with an image gallery.
        /// </summary>
        /// <param name="blog"></param>
        /// <param name="filename"></param>
        /// <returns></returns>
        public virtual VirtualPath ImageUrl(Blog blog, string filename)
        {
            return ResolveUrl(GetImageTildePath(blog, filename));
        }

        /// <summary>
        /// Returns the URL for a system image that's directly in the images directory.
        /// </summary>
        /// <param name="filename"></param>
        /// <returns></returns>
        public virtual VirtualPath ImageUrl(string filename)
        {
            return ResolveUrl(string.Format("~/images/{0}", filename));
        }

        /// <summary>
        /// Returns the direct URL to an image within a gallery.
        /// </summary>
        /// <param name="image"></param>
        /// <returns></returns>
        public virtual VirtualPath GalleryImageUrl(Image image)
        {
            return GalleryImageUrl(image, image.OriginalFile);
        }

        public VirtualPath GalleryImageUrl(Image image, string fileName)
        {
            if(image == null)
            {
                throw new ArgumentNullException("image");
            }

            if(!String.IsNullOrEmpty(image.Url))
            {
                return ResolveUrl(image.Url + fileName);
            }
            return ResolveUrl(GetGalleryImageTildePath(image, fileName));
        }

        public virtual VirtualPath ImageDirectoryUrl(Blog blog)
        {
            return ResolveUrl(GetImageDirectoryTildePath(blog));
        }

        /// <summary>
        /// Returns the physical gallery path for the specified category.
        /// </summary>
        public virtual string GalleryDirectoryPath(Blog blog, int categoryId)
        {
            string path = ImageGalleryDirectoryUrl(blog, categoryId);
            return HttpContext.Server.MapPath(path);
        }

        public virtual string ImageDirectoryPath(Blog blog)
        {
            return HttpContext.Server.MapPath(ImageDirectoryUrl(blog));
        }

        /// <summary>
        /// Returns the URL to a page that displays an image within a gallery.
        /// </summary>
        /// <param name="image"></param>
        /// <returns></returns>
        public virtual VirtualPath GalleryImagePageUrl(Image image)
        {
            if(image == null)
            {
                throw new ArgumentNullException("image");
            }
            var routeValues = GetRouteValuesWithSubfolder(image.Blog.Subfolder) ?? new RouteValueDictionary();
            routeValues.Add("id", image.ImageID);

            return GetVirtualPath("gallery-image", routeValues);
        }

        public virtual VirtualPath ImageGalleryDirectoryUrl(Blog blog, int galleryId)
        {
            var image = new Image {Blog = blog, CategoryID = galleryId};
            string imageUrl = GalleryImageUrl(image, string.Empty);
            if(!imageUrl.EndsWith("/"))
            {
                imageUrl += "/";
            }
            return imageUrl;
        }

        public virtual VirtualPath GalleryUrl(int id)
        {
            return GetVirtualPath("gallery", new RouteValueDictionary{{"id", id}});
        }

        public virtual VirtualPath GalleryUrl(Image image)
        {
            var routeValues = GetRouteValuesWithSubfolder(image.Blog.Subfolder) ?? new RouteValueDictionary();
            routeValues.Add("id", image.CategoryID);

            return GetVirtualPath("gallery", routeValues);
        }

        public virtual VirtualPath AggBugUrl(int id)
        {
            return GetVirtualPath("aggbug", new RouteValueDictionary { { "id", id } });
        }

        public virtual VirtualPath ResolveUrl(string virtualPath)
        {
            return RequestContext.HttpContext.ExpandTildePath(virtualPath);
        }

        public virtual VirtualPath BlogUrl()
        {
            string vp = GetVirtualPath("root", null);
            return BlogUrl(vp);
        }

        public virtual VirtualPath BlogUrl(Blog blog)
        {
            if(String.IsNullOrEmpty(blog.Subfolder))
            {
                return BlogUrl();
            }
            string vp = GetVirtualPath("root", GetRouteValuesWithSubfolder(blog.Subfolder));
            return BlogUrl(vp);
        }

        private static VirtualPath BlogUrl(string virtualPath)
        {
            if(!(virtualPath ?? string.Empty).EndsWith("/"))
            {
                virtualPath += "/";
            }
            if(!HttpRuntime.UsingIntegratedPipeline)
            {
                virtualPath += "default.aspx";
            }
            return virtualPath;
        }

        public virtual VirtualPath ContactFormUrl()
        {
            return GetVirtualPath("contact", null);
        }

        public virtual VirtualPath SearchPageUrl()
        {
            return GetVirtualPath("search", null);
        }

        public virtual VirtualPath SearchPageUrl(string keywords)
        {
            return GetVirtualPath("search", new { q = keywords });
        }

        public virtual VirtualPath MonthUrl(DateTime dateTime)
        {
            var routeValues = new RouteValueDictionary
            {
                { "year", dateTime.ToString("yyyy", CultureInfo.InvariantCulture) }, 
                { "month", dateTime.ToString("MM", CultureInfo.InvariantCulture) }
            };
            return GetVirtualPath("entries-by-month", routeValues);
        }

        public virtual VirtualPath CommentApiUrl(int entryId)
        {
            return GetVirtualPath("comment-api", new RouteValueDictionary { { "id", entryId } });
        }

        public virtual VirtualPath CommentRssUrl(int entryId)
        {
            return GetVirtualPath("comment-rss", new RouteValueDictionary { { "id", entryId } });
        }

        public virtual VirtualPath TrackbacksUrl(int entryId)
        {
            return GetVirtualPath("trackbacks", new RouteValueDictionary { { "id", entryId } });
        }

        public virtual VirtualPath CategoryUrl(Category category)
        {
            var routeValues = new RouteValueDictionary {{"slug", category.Id}, {"categoryType", "category"}};
            return GetVirtualPath("category", routeValues);
        }

        public virtual VirtualPath CategoryRssUrl(Category category)
        {
            return GetVirtualPath("rss", new RouteValueDictionary {{"catId", category.Id}});
        }

        /// <summary>
        /// Returns the url for all posts on the day specified by the date
        /// </summary>
        /// <param name="date"></param>
        /// <returns></returns>
        public virtual VirtualPath DayUrl(DateTime date)
        {
            var routeValues = new RouteValueDictionary
            {
                { "year", date.ToString("yyyy", CultureInfo.InvariantCulture) }, 
                { "month", date.ToString("MM", CultureInfo.InvariantCulture) }, 
                { "day", date.ToString("dd", CultureInfo.InvariantCulture) }
            };

            return GetVirtualPath("entries-by-day", routeValues);
        }

        /// <summary>
        /// Returns the url for all posts on the day specified by the date
        /// </summary>
        public virtual Uri RssUrl(Blog blog)
        {
            if(blog.RssProxyEnabled)
            {
                return RssProxyUrl(blog);
            }

            RouteValueDictionary routeValues = GetRouteValuesWithSubfolder(blog.Subfolder);
            return GetVirtualPath("rss", routeValues).ToFullyQualifiedUrl(blog);
        }

        /// <summary>
        /// Returns the url for all posts on the day specified by the date
        /// </summary>
        public virtual Uri AtomUrl(Blog blog)
        {
            if(blog.RssProxyEnabled)
            {
                return RssProxyUrl(blog);
            }

            return GetVirtualPath("atom", null).ToFullyQualifiedUrl(blog);
        }

        public virtual Uri RssProxyUrl(Blog blog)
        {
            //TODO: Store this in db.
            string feedburnerUrl = ConfigurationManager.AppSettings["FeedBurnerUrl"];
            feedburnerUrl = String.IsNullOrEmpty(feedburnerUrl) ? "http://feedproxy.google.com/" : feedburnerUrl;
            return new Uri(new Uri(feedburnerUrl), blog.RssProxyUrl);
        }

        public virtual VirtualPath GetVirtualPath(string routeName, object routeValues)
        {
            RouteValueDictionary routeValueDictionary = null;

            if(routeValues is RouteValueDictionary)
            {
                routeValueDictionary = (RouteValueDictionary)routeValues;
            }

            if(routeValues != null)
            {
                routeValueDictionary = new RouteValueDictionary(routeValues);
            }
            return GetVirtualPath(routeName, routeValueDictionary);
        }

        public virtual VirtualPath GetVirtualPath(string routeName, RouteValueDictionary routeValues)
        {
            VirtualPathData virtualPath = Routes.GetVirtualPath(RequestContext, routeName, routeValues);
            if(virtualPath == null)
            {
                return null;
            }
            return virtualPath.VirtualPath;
        }

        public virtual VirtualPath LoginUrl()
        {
            return LoginUrl(null);
        }

        public virtual VirtualPath LoginUrl(string returnUrl)
        {
            RouteValueDictionary routeValues = null;
            if(!String.IsNullOrEmpty(returnUrl))
            {
                routeValues = new RouteValueDictionary {{"ReturnUrl", returnUrl}};
            }
            return GetVirtualPath("login", routeValues);
        }

        public virtual VirtualPath LogoutUrl()
        {
            return GetVirtualPath("logout", null);
        }

        public virtual VirtualPath ArchivesUrl()
        {
            return GetVirtualPath("archives", null);
        }

        public virtual VirtualPath AdminUrl(string path)
        {
            return AdminUrl(path, null);
        }

        public virtual VirtualPath AdminUrl(string path, object routeValues)
        {
            RouteValueDictionary routeValueDict = (routeValues as RouteValueDictionary) ??
                                                  new RouteValueDictionary(routeValues);
            return AdminUrl(path, routeValueDict);
        }

        public virtual VirtualPath HostAdminUrl(string path)
        {
            return ResolveUrl(string.Format("~/hostadmin/{0}", EnsureDefaultAspx(path)));
        }

        public virtual VirtualPath AdminUrl(string path, RouteValueDictionary routeValues)
        {
            return GetUrl("admin", path, routeValues);
        }

        private VirtualPath GetUrl(string directory, string path, RouteValueDictionary routeValues)
        {
            routeValues = routeValues ?? new RouteValueDictionary();
            if(!HttpRuntime.UsingIntegratedPipeline)
            {
                path = EnsureDefaultAspx(path);
            }
            else
            {
                path = EnsureTrailingSlash(path);
            }
            routeValues.Add("pathinfo", path);
            return GetVirtualPath(directory, routeValues);
        }

        private static string EnsureDefaultAspx(string path)
        {
            if(!path.EndsWith(".aspx", StringComparison.OrdinalIgnoreCase))
            {
                if(path.Length > 0 && !path.EndsWith("/", StringComparison.Ordinal))
                {
                    path += "/";
                }
                path += "default.aspx";
            }
            return path;
        }

        private static string EnsureTrailingSlash(string path)
        {
            if(!path.EndsWith(".aspx", StringComparison.OrdinalIgnoreCase) && 
                !path.EndsWith("/", StringComparison.Ordinal))
            {
                return path + "/";
            }
            return path;
        }

        public virtual VirtualPath AdminRssUrl(string feedName)
        {
            return GetVirtualPath("admin-rss", new RouteValueDictionary{{"feedName", feedName}});
        }

        public virtual Uri MetaWeblogApiUrl(Blog blog)
        {
            VirtualPath vp = GetVirtualPath("metaweblogapi", null);
            return vp.ToFullyQualifiedUrl(blog);
        }

        public virtual Uri RsdUrl(Blog blog)
        {
            VirtualPath vp = GetVirtualPath("rsd", null);
            return vp.ToFullyQualifiedUrl(blog);
        }

        public virtual VirtualPath WlwManifestUrl()
        {
            VirtualPath vp = GetVirtualPath("wlwmanifest", null);
            return vp;
        }

        public virtual VirtualPath OpenSearchDescriptorUrl()
        {
            VirtualPath vp = GetVirtualPath("opensearchdesc", null);
            return vp;
        }

        public virtual VirtualPath CustomCssUrl()
        {
            return GetVirtualPath("customcss", null);
        }

        public virtual VirtualPath EditIconUrl()
        {
            return AppRoot() + "images/icons/edit.gif";
        }

        public virtual VirtualPath TagUrl(string tagName)
        {
            return GetVirtualPath("tag", new RouteValueDictionary{{"tag", tagName.Replace("#", "{:#:}")}});
        }

        public virtual VirtualPath TagCloudUrl()
        {
            return GetVirtualPath("tag-cloud", null);
        }

        public virtual VirtualPath IdenticonUrl(int code)
        {
            return GetVirtualPath("identicon", new RouteValueDictionary{{"code", code}});
        }

        private static RouteValueDictionary GetRouteValuesWithSubfolder(string subfolder)
        {
            if(String.IsNullOrEmpty(subfolder))
            {
                return null;
            }
            return new RouteValueDictionary {{"subfolder", subfolder}};
        }

        public virtual VirtualPath Logout()
        {
            return GetVirtualPath("logout", new RouteValueDictionary {{"action", "logout"}, {"controller", "account"}});
        }

        // Code inspidered from this article: http://dotnetperls.com/google-query
        public static string ExtractKeywordsFromReferrer(Uri referrer, Uri currentPath)
        {
            if(referrer.Host == currentPath.Host)
                return string.Empty;

            string u = referrer.OriginalString.ToLower();

            //This looks for parameters named q (Google, Bing, possibly others)
            int start = u.IndexOf("&q=", StringComparison.Ordinal);
            int length = 3;

            if (start == -1)
            {
                start = u.IndexOf("q=", StringComparison.Ordinal);
                length = 2;
            }

            //This looks for parameters named p (Yahoo)
            if (start == -1)
            {
                start = u.IndexOf("p=", StringComparison.Ordinal);
                length = 2;
            }

            //Nothing found
            if (start == -1)
            {
                return string.Empty;
            }


            //Get Keywords
            start += length;

            int end = u.IndexOf('&', start);

            if (end == -1)
            {
                end = u.Length;
            }

            string sub = u.Substring(start, end - start);

            string result = HttpUtility.UrlDecode(sub);

            result = StripUnwantedClauses(result);

            return result;
        }

        private static string StripUnwantedClauses(string result)
        {
            Regex regex = new Regex(@"(^|\s)site:http(s?)://[\w|.|/|?]*(\s|$)", RegexOptions.IgnoreCase | RegexOptions.Compiled);
            return regex.Replace(result, "");
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Routing
{
    public class VirtualPath
    {
        readonly Uri _virtualPath;

        public VirtualPath(string virtualPath)
        {
            if(virtualPath == null)
            {
                throw new ArgumentNullException("virtualPath");
            }
            virtualPath = virtualPath.Replace("%7B:#:%7D", "%23");
            _virtualPath = new Uri(virtualPath, UriKind.Relative);
        }

        public static implicit operator String(VirtualPath vp)
        {
            if(vp == null)
            {
                return null;
            }
            return vp.ToString();
        }

        public static implicit operator VirtualPath(string virtualPath)
        {
            if(String.IsNullOrEmpty(virtualPath))
            {
                return null;
            }
            return new VirtualPath(virtualPath);
        }

        public override string ToString()
        {
            return _virtualPath.ToString();
        }

        public Uri ToUri()
        {
            return _virtualPath;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using System.Web.Routing;
using Subtext.Framework.XmlRpc;
using Subtext.Infrastructure;

namespace Subtext.Framework.Routing
{
    public class XmlRpcRouteHandler<THandler> : IRouteHandler where THandler : SubtextXmlRpcService
    {
        public XmlRpcRouteHandler(IServiceLocator serviceLocator)
        {
            ServiceLocator = serviceLocator;
        }

        protected IServiceLocator ServiceLocator { get; private set; }

        public IHttpHandler GetHttpHandler(RequestContext requestContext)
        {
            Bootstrapper.RequestContext = requestContext;
            return ServiceLocator.GetService<THandler>();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections;
using System.Web.Caching;

namespace Subtext.Infrastructure
{
    public class SubtextCache : ICache
    {
        public SubtextCache(Cache cache)
        {
            Cache = cache;
        }

        protected Cache Cache { get; set; }

        public object this[string key]
        {
            get { return Cache.Get(key); }
            set { Cache[key] = value; }
        }

        public void Insert(string key, object value)
        {
            Cache.Insert(key, value);
        }

        public void Insert(string key, object value, CacheDependency dependency)
        {
            Cache.Insert(key, value, dependency);
        }

        public void Insert(string key, object value, CacheDependency dependency, DateTime absoluteExpiration,
                           TimeSpan slidingExpiration)
        {
            Cache.Insert(key, value, dependency, absoluteExpiration, slidingExpiration);
        }

        public void Remove(string key)
        {
            Cache.Remove(key);
        }

        public void Insert(string key, object value, CacheDependency dependencies, DateTime absoluteExpiration,
                           TimeSpan slidingExpiration, CacheItemPriority priority,
                           CacheItemRemovedCallback onRemoveCallback)
        {
            Cache.Insert(key, value, dependencies, absoluteExpiration, slidingExpiration, priority, onRemoveCallback);
        }

        public IEnumerator GetEnumerator()
        {
            return Cache.GetEnumerator();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Infrastructure
{
    // TimeZoneInfo is sealed. :(
    public class TimeZoneWrapper : ITimeZone
    {
        readonly Func<DateTime> _utcNowFactory;

        public TimeZoneWrapper(TimeZoneInfo timeZone)
            : this(timeZone, TimeZoneInfo.Local, () => DateTime.UtcNow)
        {
        }

        public TimeZoneWrapper(TimeZoneInfo timeZone, TimeZoneInfo serverTimeZone, Func<DateTime> utcNowFactory)
        {
            TimeZoneInfo = timeZone;
            ServerTimeZoneInfo = serverTimeZone;
            _utcNowFactory = utcNowFactory;
        }

        protected TimeZoneInfo TimeZoneInfo { get; private set; }

        protected TimeZoneInfo ServerTimeZoneInfo { get; private set; }

        #region ITimeZone Members

        public DateTime UtcNow
        {
            get { return _utcNowFactory(); }
        }

        public DateTime Now
        {
            get { return TimeZoneInfo.ConvertTimeFromUtc(UtcNow, TimeZoneInfo); }
        }

        public DateTime ServerNow
        {
            get { return TimeZoneInfo.ConvertTimeFromUtc(UtcNow, ServerTimeZoneInfo); }
        }

        public DateTime ToUtc(DateTime dateTime)
        {
            return TimeZoneInfo.ConvertTime(dateTime, TimeZoneInfo, TimeZoneInfo.Utc);
        }

        public DateTime FromUtc(DateTime dateTime)
        {
            if(dateTime.Kind != DateTimeKind.Utc)
            {
                dateTime = new DateTime(dateTime.Year, dateTime.Month, dateTime.Day, dateTime.Hour, dateTime.Minute, dateTime.Second, dateTime.Millisecond, DateTimeKind.Unspecified);
            }
            return FromTimeZone(dateTime, TimeZoneInfo.Utc);
        }

        public DateTime FromTimeZone(DateTime dateTime, TimeZoneInfo sourceTimeZone)
        {
            return TimeZoneInfo.ConvertTime(dateTime, sourceTimeZone, TimeZoneInfo);
        }

        public DateTime ToServerDateTime(DateTime dateTime)
        {
            return TimeZoneInfo.ConvertTime(dateTime, TimeZoneInfo, ServerTimeZoneInfo);
        }

        public bool IsInPast(DateTime dateTime, TimeZoneInfo sourceTimeZone)
        {
            return FromTimeZone(dateTime, sourceTimeZone) < Now;
        }

        public bool IsInFuture(DateTime dateTime, TimeZoneInfo sourceTimeZone)
        {
            return FromTimeZone(dateTime, sourceTimeZone) > Now;
        }

        #endregion
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Security.Principal;
using System.Web;
using System.Web.Routing;
using Subtext.Framework.Providers;
using Subtext.Framework.Routing;
using Subtext.Framework.Services.SearchEngine;
using Subtext.Infrastructure;

namespace Subtext.Framework
{
    public interface ISubtextContext
    {
        Blog Blog { get; }
        ObjectProvider Repository { get; }
        RequestContext RequestContext { get; }
        HttpContextBase HttpContext { get; }
        UrlHelper UrlHelper { get; }
        IPrincipal User { get; }
        ICache Cache { get; }
        IServiceLocator ServiceLocator { get; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;

namespace Subtext.Framework
{
    /// <summary>
    /// Summary description for Links.
    /// </summary>
    public static class Links
    {
        public static ICollection<LinkCategory> GetCategories(CategoryType catType, ActiveFilter status)
        {
            return ObjectProvider.Instance().GetCategories(catType, status == ActiveFilter.ActiveOnly);
        }

        public static ICollection<LinkCategory> GetLinkCategoriesByPostId(int postId)
        {
            var links = new List<Link>(ObjectProvider.Instance().GetLinkCollectionByPostId(postId));
            ICollection<LinkCategory> postCategories =
                ObjectProvider.Instance().GetCategories(CategoryType.PostCollection, true /* activeOnly */);
            var categories = new LinkCategory[postCategories.Count];
            postCategories.CopyTo(categories, 0);

            foreach(LinkCategory category in categories)
            {
                LinkCategory innerCategory = category;
                if(!links.Exists(link => innerCategory.Id == link.CategoryId))
                {
                    postCategories.Remove(category);
                }
            }
            return postCategories;
        }

        public static int CreateLink(Link link)
        {
            return ObjectProvider.Instance().CreateLink(link);
        }

        public static int CreateLinkCategory(LinkCategory lc)
        {
            lc.Id = ObjectProvider.Instance().CreateLinkCategory(lc);
            return lc.Id;
        }

        public static bool DeleteLinkCategory(int categoryId)
        {
            return ObjectProvider.Instance().DeleteLinkCategory(categoryId);
        }

        public static bool DeleteLink(int linkId)
        {
            return ObjectProvider.Instance().DeleteLink(linkId);
        }
    }

    public enum ActiveFilter
    {
        None,
        ActiveOnly,
        InactiveOnly,
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Data;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Configuration;
using Subtext.Framework.Data;
using Subtext.Framework.Web.HttpModules;

namespace Subtext.Framework.Logging
{
    /// <summary>
    /// Summary description for DatabaseLoggingProvider.
    /// </summary>
    public class DatabaseLoggingProvider : LoggingProvider
    {
        readonly StoredProcedures _procedures = new StoredProcedures(Config.ConnectionString);

        public int BlogId
        {
            get { return BlogRequest.Current.IsHostAdminRequest ? NullValue.NullInt32 : Config.CurrentBlog.Id; }
        }

        /// <summary>
        /// Gets a pageable collection of log entries.
        /// </summary>
        /// <param name="pageIndex">Index of the page.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <returns></returns>
        public override IPagedCollection<LogEntry> GetPagedLogEntries(int pageIndex, int pageSize)
        {
            using(IDataReader reader = _procedures.GetPageableLogEntries(BlogId, pageIndex, pageSize))
            {
                return reader.ReadPagedCollection(r => r.ReadObject<LogEntry>());
            }
        }

        /// <summary>
        /// Clears the log.
        /// </summary>
        public override void ClearLog()
        {
            _procedures.LogClear(BlogId.NullIfMinValue());
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Diagnostics;
using System.Globalization;
using System.Runtime.CompilerServices;
using System.Web;
using log4net;
using log4net.Core;
using Subtext.Framework.Web.HttpModules;

namespace Subtext.Framework.Logging
{
    /// <summary>
    /// Provides logging for the Subtext framework. This class is typically instantiated as a 
    /// <c>private static readonly</c> member of a class in order to handle logging inside of 
    /// the class. This class is a specialized wrapper for the log4net framework.
    /// </summary>
    /// <para>
    /// The class provides methods to log messages at the following levels:
    /// </para>
    /// <remarks>
    /// <list type="definition">
    ///	<item>
    ///	<term>DEBUG</term>
    ///	<description>
    ///	The <see cref="M:Subtext.Framework.Logging.Log.Debug(System.Object)"/> and 
    ///	<see cref="M:Subtext.Framework.Logging.Log.DebugFormat(System.String,System.Object[])"/> methods log messages
    ///	at the <c>DEBUG</c> level. That is the level with that name defined in the log4net
    ///	repositories. The <see cref="P:Subtext.Framework.Logging.Log.IsDebugEnabled"/>
    ///	property tests if this level is enabled for logging.
    ///	</description>
    ///	</item>
    ///	<item>
    ///	<term>INFO</term>
    ///	<description>
    ///	The <see cref="M:Subtext.Framework.Logging.Log.Info(System.Object)"/> and 
    ///	<see cref="M:Subtext.Framework.Logging.Log.InfoFormat(System.String,System.Object[])"/> methods log messages
    ///	at the <c>INFO</c> level. That is the level with that name defined in the log4net
    ///	repositories. The <see cref="P:Subtext.Framework.Logging.Log.IsInfoEnabled"/>
    ///	property tests if this level is enabled for logging.
    ///	</description>
    ///	</item>
    ///	<item>
    ///	<term>WARN</term>
    ///	<description>
    ///	The <see cref="M:Subtext.Framework.Logging.Log.Warn(System.Object)"/> and 
    ///	<see cref="M:Subtext.Framework.Logging.Log.WarnFormat(System.String,System.Object[])"/> methods log messages
    ///	at the <c>WARN</c> level. That is the level with that name defined in the log4net
    ///	repositories. The <see cref="P:Subtext.Framework.Logging.Log.IsWarnEnabled"/>
    ///	property tests if this level is enabled for logging.
    ///	</description>
    ///	</item>
    ///	<item>
    ///	<term>ERROR</term>
    ///	<description>
    ///	The <see cref="M:Subtext.Framework.Logging.Log.Error(System.Object)"/> and 
    ///	<see cref="M:Subtext.Framework.Logging.Log.ErrorFormat(System.String,System.Object[])"/> methods log messages
    ///	at the <c>ERROR</c> level. That is the level with that name defined in the log4net
    ///	repositories. The <see cref="P:Subtext.Framework.Logging.Log.IsErrorEnabled"/>
    ///	property tests if this level is enabled for logging.
    ///	</description>
    ///	</item>
    ///	<item>
    ///	<term>FATAL</term>
    ///	<description>
    ///	The <see cref="M:Subtext.Framework.Logging.Log.Fatal(System.Object)"/> and 
    ///	<see cref="M:Subtext.Framework.Logging.Log.FatalFormat(System.String,System.Object[])"/> methods log messages
    ///	at the <c>FATAL</c> level. That is the level with that name defined in the log4net
    ///	repositories. The <see cref="P:Subtext.Framework.Logging.Log.IsFatalEnabled"/>
    ///	property tests if this level is enabled for logging.
    ///	</description>
    ///	</item>
    ///	</list>
    /// </remarks>
    /// <example>
    /// An example of using the Log class
    /// <code lang="C#">
    /// public class Subtext.Framework.Wigdetry
    /// {
    ///		<b>private static readonly Log __log = new Log();</b>
    ///		...
    ///		public void DoSomething()
    ///		{
    ///			try
    ///			{
    ///			}
    ///			catch(Exception e)
    ///			{
    ///				<b>__log.Error("Something had gone terribly wrong", e);</b>
    ///			}
    ///		}
    /// }
    /// </code>
    /// </example>
    public class Log : ILog
    {
        private static readonly ILog __nullLog = new NullLog();
        private readonly ILog _log;

        /// <summary>
        /// Default constructor. Uses <see cref="T:System.Diagnostics.StackFrame"/> to discover the class it is being called from 
        /// and automatically establishes log name as the <see cref="P:System.Type.FullName"/> of the class type.
        /// </summary>
        [MethodImpl(MethodImplOptions.NoInlining)]
        public Log() : this(GetCallerType())
        {
        }

        /// <summary>
        /// Instantiates a log using the <see cref="P:System.Type.FullName"/> of the suppled type of the class as the name.
        /// </summary>
        /// <param name="type"><see cref="T:System.Type"/> of the class to create a log for</param>
        public Log(Type type)
        {
            _log = CreateInnerLogger(type);
        }

        /// <summary>
        /// Instantiates a log which wraps the specified inner logger.
        /// </summary>
        /// <param name="innerLogger"><see cref="T:System.Type"/> of the class to create a log for</param>
        public Log(ILog innerLogger)
        {
            _log = innerLogger;
        }

        #region ILog Members

        /// <summary>
        /// Checks if the log is enabled for the <c>ERROR</c> level.
        /// </summary>
        /// <value>
        /// <c>true</c> if this log is enabled for the <c>ERROR</c> events, <c>false</c> otherwise
        /// </value>
        /// <remarks>
        /// <para>
        /// This function is intended to lessen the computational cost of disabled log debug statements.
        /// </para>
        /// </remarks>
        public bool IsErrorEnabled
        {
            get { return _log.IsErrorEnabled; }
        }

        /// <summary>
        /// Checks if the log is enabled for the <c>FATAL</c> level.
        /// </summary>
        /// <value>
        /// <c>true</c> if this log is enabled for the <c>FATAL</c> events, <c>false</c> otherwise
        /// </value>
        /// <remarks>
        /// <para>
        /// This function is intended to lessen the computational cost of disabled log debug statements.
        /// </para>
        /// </remarks>
        public bool IsFatalEnabled
        {
            get { return _log.IsFatalEnabled; }
        }

        /// <summary>
        /// Checks if the log is enabled for the <c>WARN</c> level.
        /// </summary>
        /// <value>
        /// <c>true</c> if this log is enabled for the <c>WARN</c> events, <c>false</c> otherwise
        /// </value>
        /// <remarks>
        /// <para>
        /// This function is intended to lessen the computational cost of disabled log debug statements.
        /// </para>
        /// </remarks>
        public bool IsWarnEnabled
        {
            get { return _log.IsWarnEnabled; }
        }

        /// <summary>
        /// Checks if the log is enabled for the <c>INFO</c> level.
        /// </summary>
        /// <value>
        /// <c>true</c> if this log is enabled for the <c>INFO</c> events, <c>false</c> otherwise
        /// </value>
        /// <remarks>
        /// <para>
        /// This function is intended to lessen the computational cost of disabled log debug statements.
        /// </para>
        /// </remarks>
        public bool IsInfoEnabled
        {
            get { return _log.IsInfoEnabled; }
        }

        /// <summary>
        /// Checks if the log is enabled for the <c>DEBUG</c> level.
        /// </summary>
        /// <value>
        /// <c>true</c> if this log is enabled for the <c>DEBUG</c> events, <c>false</c> otherwise
        /// </value>
        /// <remarks>
        /// <para>
        /// This function is intended to lessen the computational cost of disabled log debug statements.
        /// </para>
        /// </remarks>
        public bool IsDebugEnabled
        {
            get { return _log.IsDebugEnabled; }
        }

        /// <summary>
        /// Logs a message with the <c>ERROR</c> level.
        /// </summary>
        /// <param name="provider">An <see cref="T:System.IFormatProvider"/> that supplies culture-specific formatting information</param>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// See <see cref="M:System.String.Format(System.String,System.Object)"/> for details of the syntax 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Error(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void ErrorFormat(IFormatProvider provider, string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.ErrorFormat(provider, format, args);
        }

        /// <summary>
        /// Logs a message with the <c>ERROR</c> level.
        /// </summary>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// See <see cref="M:System.String.Format(System.String,System.Object)"/> for details of the syntax 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Error(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void ErrorFormat(string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.ErrorFormat(CultureInfo.InvariantCulture, format, args);
        }

        /// <summary>
        /// Logs a message object with the <c>INFO</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <param name="exception">The exception to log, including its stack trace</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>INFO</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// </remarks>
        public void Info(object message, Exception exception)
        {
            SetBlogRequestContext();
            _log.Info(message, exception);
        }

        /// <summary>
        /// Logs a message object with the <c>INFO</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>INFO</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// <para>
        /// <b>WARNING</b> Note that passing an <see cref="T:System.Exception"/> to this method 
        /// will print the name of the <see cref="T:System.Exception"/> but no stack trace. 
        /// To print a stack trace use the <see cref="M:Subtext.Framework.Logging.Log.Info(System.Object,System.Exception)"/> form 
        /// instead.
        /// </para>
        /// </remarks>
        public void Info(object message)
        {
            SetBlogRequestContext();
            _log.Info(message);
        }

        /// <summary>
        /// Logs a message object with the <c>DEBUG</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <param name="exception">The exception to log, including its stack trace</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>DEBUG</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// <para>
        /// This method is compiled to nothing if DEBUG compilation constant is not set (production build).
        /// </para>
        /// </remarks>
        public void Debug(object message, Exception exception)
        {
            SetBlogRequestContext();
            _log.Debug(message, exception);
        }

        /// <summary>
        /// Logs a message object with the <c>DEBUG</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>DEBUG</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// <para>
        /// <b>WARNING</b> Note that passing an <see cref="T:System.Exception"/> to this method 
        /// will print the name of the <see cref="T:System.Exception"/> but no stack trace. 
        /// To print a stack trace use the <see cref="M:Subtext.Framework.Logging.Log.Debug(System.Object,System.Exception)"/> form 
        /// instead.
        /// </para>
        /// <para>
        /// This method is compiled to nothing if DEBUG compilation constant is not set (production build).
        /// </para>
        /// </remarks>
        public void Debug(object message)
        {
            SetBlogRequestContext();
            _log.Debug(message);
        }

        /// <summary>
        /// Logs a message object with the <c>WARN</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <param name="exception">The exception to log, including its stack trace</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>WARN</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// </remarks>
        public void Warn(object message, Exception exception)
        {
            SetBlogRequestContext();
            _log.Warn(message, exception);
        }

        /// <summary>
        /// Logs a message object with the <c>WARN</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>WARN</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// <para>
        /// <b>WARNING</b> Note that passing an <see cref="T:System.Exception"/> to this method 
        /// will print the name of the <see cref="T:System.Exception"/> but no stack trace. 
        /// To print a stack trace use the <see cref="M:Subtext.Framework.Logging.Log.Warn(System.Object,System.Exception)"/> form 
        /// instead.
        /// </para>
        /// </remarks>
        public void Warn(object message)
        {
            SetBlogRequestContext();
            _log.Warn(message);
        }

        /// <summary>
        /// Logs a message with the <c>WARN</c> level.
        /// </summary>
        /// <param name="provider">An <see cref="T:System.IFormatProvider"/> that supplies culture-specific formatting information</param>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// See <see cref="M:System.String.Format(System.String,System.Object)"/> for details of the syntax 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Warn(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void WarnFormat(IFormatProvider provider, string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.WarnFormat(provider, format, args);
        }

        /// <summary>
        /// Logs a message with the <c>WARN</c> level.
        /// </summary>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// See <see cref="M:System.String.Format(System.String,System.Object)"/> for details of the syntax 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Warn(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void WarnFormat(string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.WarnFormat(CultureInfo.InvariantCulture, format, args);
        }

        /// <summary>
        /// Logs a message object with the <c>FATAL</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <param name="exception">The exception to log, including its stack trace</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>FATAL</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// </remarks>
        public void Fatal(object message, Exception exception)
        {
            SetBlogRequestContext();
            _log.Fatal(message, exception);
        }

        /// <summary>
        /// Logs a message object with the <c>FATAL</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>FATAL</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// <para>
        /// <b>WARNING</b> Note that passing an <see cref="T:System.Exception"/> to this method 
        /// will print the name of the <see cref="T:System.Exception"/> but no stack trace. 
        /// To print a stack trace use the <see cref="M:Subtext.Framework.Logging.Log.Fatal(System.Object,System.Exception)"/> form 
        /// instead.
        /// </para>
        /// </remarks>
        public void Fatal(object message)
        {
            SetBlogRequestContext();
            _log.Fatal(message);
        }

        /// <summary>
        /// Logs a message object with the <c>ERROR</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <param name="exception">The exception to log, including its stack trace</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>ERROR</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// </remarks>
        public void Error(object message, Exception exception)
        {
            SetBlogRequestContext();
            _log.Error(message, exception);
        }

        /// <summary>
        /// Logs a message object with the <c>ERROR</c> level.
        /// </summary>
        /// <param name="message">The message object to log</param>
        /// <remarks>
        /// <para>
        ///  This method first checks if this logger is <c>ERROR</c> enabled. If so, 
        ///  it converts the message object (passed as parameter) to a string 
        ///  by invoking the appropriate <see cref="T:log4net.ObjectRenderer.IObjectRenderer"/>. 
        ///  It then proceeds to call all the registered appenders in this logger and also 
        ///  higher in the hierarchy depending on the value of the additivity flag.
        /// </para>
        /// <para>
        /// <b>WARNING</b> Note that passing an <see cref="T:System.Exception"/> to this method 
        /// will print the name of the <see cref="T:System.Exception"/> but no stack trace. 
        /// To print a stack trace use the <see cref="M:Subtext.Framework.Logging.Log.Error(System.Object,System.Exception)"/> form 
        /// instead.
        /// </para>
        /// </remarks>
        public void Error(object message)
        {
            SetBlogRequestContext();
            _log.Error(message);
        }

        /// <summary>
        /// Logs a message with the <c>INFO</c> level.
        /// </summary>
        /// <param name="provider">An <see cref="T:System.IFormatProvider"/> that supplies culture-specific formatting information</param>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// See <see cref="M:System.String.Format(System.String,System.Object)"/> for details of the syntax 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Info(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void InfoFormat(IFormatProvider provider, string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.InfoFormat(provider, format, args);
        }

        /// <summary>
        /// Logs a message with the <c>INFO</c> level.
        /// </summary>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Info(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void InfoFormat(string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.InfoFormat(CultureInfo.InvariantCulture, format, args);
        }

        /// <summary>
        /// Logs a message with the <c>FATAL</c> level.
        /// </summary>
        /// <param name="provider">An <see cref="T:System.IFormatProvider"/> that supplies culture-specific formatting information</param>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// See <see cref="M:System.String.Format(System.String,System.Object)"/> for details of the syntax 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Fatal(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void FatalFormat(IFormatProvider provider, string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.FatalFormat(provider, format, args);
        }

        /// <summary>
        /// Logs a message with the <c>FATAL</c> level.
        /// </summary>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Fatal(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void FatalFormat(string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.FatalFormat(CultureInfo.InvariantCulture, format, args);
        }

        /// <summary>
        /// Logs a message with the <c>DEBUG</c> level.
        /// </summary>
        /// <param name="provider">An <see cref="T:System.IFormatProvider"/> that supplies culture-specific formatting information</param>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// See <see cref="M:System.String.Format(System.String,System.Object)"/> for details of the syntax 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Debug(System.Object)"/> methods instead.
        /// </para>
        /// <para>
        /// This method is compiled to nothing if DEBUG compilation constant is not set (production build).
        /// </para>
        /// </remarks>
        public void DebugFormat(IFormatProvider provider, string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.DebugFormat(provider, format, args);
        }

        /// <summary>
        /// Logs a message with the <c>DEBUG</c> level.
        /// </summary>
        /// <param name="format">A <see cref="T:System.String"/> containing zero or more format items</param>
        /// <param name="args">An <see cref="T:System.Array"/> containing zero or more objects to format</param>
        /// <remarks>
        /// <para>
        /// The message is formatted using the <c>String.Format</c> method. 
        /// See <see cref="M:System.String.Format(System.String,System.Object)"/> for details of the syntax 
        /// of the format string and the behavior of the formatting.
        /// </para>
        /// <para>
        /// This method does not take an <see cref="T:System.Exception"/> object to include in the log event. 
        /// To pass an <see cref="T:System.Exception"/> use
        /// one of the <see cref="M:Subtext.Framework.Logging.Log.Debug(System.Object)"/> methods instead.
        /// </para>
        /// </remarks>
        public void DebugFormat(string format, params object[] args)
        {
            SetBlogRequestContext();
            _log.DebugFormat(CultureInfo.InvariantCulture, format, args);
        }

        public ILogger Logger
        {
            get { return _log.Logger; }
        }

        public void DebugFormat(string format, object arg0, object arg1, object arg2)
        {
            SetBlogRequestContext();
            _log.DebugFormat(format, arg0, arg1, arg2);
        }

        public void DebugFormat(string format, object arg0, object arg1)
        {
            SetBlogRequestContext();
            _log.DebugFormat(format, arg0, arg1);
        }

        public void DebugFormat(string format, object arg0)
        {
            SetBlogRequestContext();
            _log.DebugFormat(format, arg0);
        }

        public void ErrorFormat(string format, object arg0, object arg1, object arg2)
        {
            SetBlogRequestContext();
            _log.ErrorFormat(format, arg0, arg1, arg2);
        }

        public void ErrorFormat(string format, object arg0, object arg1)
        {
            SetBlogRequestContext();
            _log.ErrorFormat(format, arg0, arg1);
        }

        public void ErrorFormat(string format, object arg0)
        {
            SetBlogRequestContext();
            _log.ErrorFormat(format, arg0);
        }

        public void FatalFormat(string format, object arg0, object arg1, object arg2)
        {
            SetBlogRequestContext();
            _log.FatalFormat(format, arg0, arg1, arg2);
        }

        public void FatalFormat(string format, object arg0, object arg1)
        {
            SetBlogRequestContext();
            _log.FatalFormat(format, arg0, arg1);
        }

        public void FatalFormat(string format, object arg0)
        {
            SetBlogRequestContext();
            _log.FatalFormat(format, arg0);
        }

        public void InfoFormat(string format, object arg0, object arg1, object arg2)
        {
            SetBlogRequestContext();
            _log.InfoFormat(format, arg0, arg1, arg2);
        }

        public void InfoFormat(string format, object arg0, object arg1)
        {
            SetBlogRequestContext();
            _log.InfoFormat(format, arg0, arg1);
        }

        public void InfoFormat(string format, object arg0)
        {
            SetBlogRequestContext();
            _log.InfoFormat(format, arg0);
        }

        public void WarnFormat(string format, object arg0, object arg1, object arg2)
        {
            SetBlogRequestContext();
            _log.WarnFormat(format, arg0, arg1, arg2);
        }

        public void WarnFormat(string format, object arg0, object arg1)
        {
            SetBlogRequestContext();
            _log.WarnFormat(format, arg0, arg1);
        }

        public void WarnFormat(string format, object arg0)
        {
            SetBlogRequestContext();
            _log.WarnFormat(format, arg0);
        }

        #endregion

        #region private class NulLog : ILog

        private class NullLog : ILog
        {
            #region ILog Members

            public void ErrorFormat(IFormatProvider provider, string format, params object[] args)
            {
            }

            void ILog.ErrorFormat(string format, params object[] args)
            {
            }

            public void Info(object message, Exception exception)
            {
            }

            void ILog.Info(object message)
            {
            }

            public void Debug(object message, Exception exception)
            {
            }

            void ILog.Debug(object message)
            {
            }

            public bool IsErrorEnabled
            {
                get { return false; }
            }

            public bool IsFatalEnabled
            {
                get { return false; }
            }

            public bool IsWarnEnabled
            {
                get { return false; }
            }

            public void Warn(object message, Exception exception)
            {
            }

            void ILog.Warn(object message)
            {
            }

            public bool IsInfoEnabled
            {
                get { return false; }
            }

            public bool IsDebugEnabled
            {
                get { return false; }
            }

            public void WarnFormat(IFormatProvider provider, string format, params object[] args)
            {
            }

            void ILog.WarnFormat(string format, params object[] args)
            {
            }

            public void Fatal(object message, Exception exception)
            {
            }

            void ILog.Fatal(object message)
            {
            }

            public void Error(object message, Exception exception)
            {
            }

            void ILog.Error(object message)
            {
            }

            public void InfoFormat(IFormatProvider provider, string format, params object[] args)
            {
            }

            void ILog.InfoFormat(string format, params object[] args)
            {
            }

            public void FatalFormat(IFormatProvider provider, string format, params object[] args)
            {
            }

            void ILog.FatalFormat(string format, params object[] args)
            {
            }

            public void DebugFormat(IFormatProvider provider, string format, params object[] args)
            {
            }

            void ILog.DebugFormat(string format, params object[] args)
            {
            }

            public ILogger Logger
            {
                get { return null; }
            }

            public void DebugFormat(string format, object arg0, object arg1, object arg2)
            {
            }

            public void DebugFormat(string format, object arg0, object arg1)
            {
            }

            public void DebugFormat(string format, object arg0)
            {
            }

            public void ErrorFormat(string format, object arg0, object arg1, object arg2)
            {
            }

            public void ErrorFormat(string format, object arg0, object arg1)
            {
            }

            public void ErrorFormat(string format, object arg0)
            {
            }

            public void FatalFormat(string format, object arg0, object arg1, object arg2)
            {
            }

            public void FatalFormat(string format, object arg0, object arg1)
            {
            }

            public void FatalFormat(string format, object arg0)
            {
            }

            public void InfoFormat(string format, object arg0, object arg1, object arg2)
            {
            }

            public void InfoFormat(string format, object arg0, object arg1)
            {
            }

            public void InfoFormat(string format, object arg0)
            {
            }

            public void WarnFormat(string format, object arg0, object arg1, object arg2)
            {
            }

            public void WarnFormat(string format, object arg0, object arg1)
            {
            }

            public void WarnFormat(string format, object arg0)
            {
            }

            #endregion
        }

        #endregion

        private static ILog CreateInnerLogger(Type type)
        {
            ILog log = LogManager.GetLogger(type);
            return log ?? __nullLog;
        }

        [MethodImpl(MethodImplOptions.NoInlining)]
        private static Type GetCallerType()
        {
            return new StackFrame(2, false).GetMethod().DeclaringType;
        }

        /// <summary>
        /// Sets the blog id context in the Log4net ThreadContext.
        /// </summary>
        /// <param name="blogId">Blog id.</param>
        static void SetBlogIdContext(int blogId)
        {
            if(blogId == NullValue.NullInt32 && ThreadContext.Properties["BlogId"] != null)
            {
                return;
            }

            ThreadContext.Properties["BlogId"] = blogId;
        }

        static void SetBlogRequestContext()
        {
            if(HttpContext.Current != null)
            {
                try
                {
                    Uri url = HttpContext.Current.Request.Url;
                    if (url != null && ThreadContext.Properties != null)
                    {
                        ThreadContext.Properties["Url"] = url.ToString();
                    }
                }
                catch (HttpException) { 
                
                }

                if(HttpContext.Current.Items != null && BlogRequest.Current != null)
                {
                    var blog = BlogRequest.Current.Blog;
                    if(blog != null)
                    {
                        SetBlogIdContext(blog.Id);
                    }
                }
            }
        }

        /// <summary>
        /// Resets blog id context in the Log4net ThreadContext.
        /// </summary>
        public static void ResetBlogIdContext()
        {
            ThreadContext.Properties["BlogId"] = NullValue.NullInt32;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Logging
{
    /// <summary>
    /// Represents an entry within the Subtext log.
    /// </summary>
    /// <remarks>
    /// These entries as of now are added by Log4Net.
    /// </remarks>
    [Serializable]
    public class LogEntry
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LogEntry"/> class.
        /// </summary>
        public LogEntry()
        {
            BlogId = NullValue.NullInt32;
        }

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>The id.</value>
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets the blog id.
        /// </summary>
        /// <value>The blog id.</value>
        public int BlogId { get; set; }

        /// <summary>
        /// Gets or sets the date of the log entry.
        /// </summary>
        /// <value>The date.</value>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the id or name of thread on which 
        /// this log message was logged.
        /// </summary>
        /// <value>The thread.</value>
        public string Thread { get; set; }

        /// <summary>
        /// Gets or sets the context of the message if any was set.
        /// </summary>
        /// <value>The context.</value>
        public string Context { get; set; }

        /// <summary>
        /// Gets or sets the level of the log message.
        /// </summary>
        /// <value>The level.</value>
        public string Level { get; set; }

        /// <summary>
        /// Gets or sets the logger that logged this message.
        /// </summary>
        /// <value>The logger.</value>
        public string Logger { get; set; }

        /// <summary>
        /// Gets or sets the log message.
        /// </summary>
        /// <value>The message.</value>
        public string Message { get; set; }

        /// <summary>
        /// Gets or sets the exception type and stack trace 
        /// if an exception was logged.
        /// </summary>
        /// <value>The exception.</value>
        public string Exception { get; set; }

        /// <summary>
        /// Gets or sets the Url that of the request that caused this 
        /// exception.
        /// </summary>
        /// <value>The URL.</value>
        public Uri Url { get; set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Configuration.Provider;
using Subtext.Extensibility.Interfaces;

namespace Subtext.Framework.Logging
{
    /// <summary>
    /// Provider for retrieving log entries.
    /// </summary>
    public abstract class LoggingProvider : ProviderBase
    {
        /// <summary>
        /// Returns the configured concrete instance of a <see cref="LoggingProvider"/>.
        /// </summary>
        /// <returns></returns>
        public static LoggingProvider Instance()
        {
            //TODO: Make this a service.
            return new DatabaseLoggingProvider();
        }

        /// <summary>
        /// Gets a pageable collection of log entries.
        /// </summary>
        /// <param name="pageIndex">Index of the page.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <returns></returns>
        public abstract IPagedCollection<LogEntry> GetPagedLogEntries(int pageIndex, int pageSize);

        /// <summary>
        /// Clears the log.
        /// </summary>
        public abstract void ClearLog();
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;

namespace Subtext.Framework
{
    /// <summary>
    /// Static class used to retrieve meta tags from the data store. MetaTags are simple enough 
    /// that generic collections are used instead of custom MetaTag objects.
    /// </summary>
    public static class MetaTags
    {
        public static int Create(MetaTag metaTag)
        {
            if(metaTag == null)
            {
                throw new ArgumentNullException("metaTag");
            }

            if(!metaTag.IsValid)
            {
                throw new ArgumentException(metaTag.ValidationMessage);
            }
            metaTag.Id = ObjectProvider.Instance().Create(metaTag);

            return metaTag.Id;
        }

        public static bool Update(MetaTag metaTag)
        {
            if(metaTag == null)
            {
                throw new ArgumentNullException("metaTag");
            }

            if(!metaTag.IsValid)
            {
                throw new ArgumentException(metaTag.ValidationMessage);
            }

            return ObjectProvider.Instance().Update(metaTag);
        }

        public static bool Delete(int metaTagId)
        {
            return ObjectProvider.Instance().DeleteMetaTag(metaTagId);
        }

        public static IPagedCollection<MetaTag> GetMetaTagsForBlog(Blog blog, int pageIndex, int pageSize)
        {
            return ObjectProvider.Instance().GetMetaTagsForBlog(blog, pageIndex, pageSize);
        }

        public static IPagedCollection<MetaTag> GetMetaTagsForEntry(Entry entry, int pageIndex, int pageSize)
        {
            return ObjectProvider.Instance().GetMetaTagsForEntry(entry, pageIndex, pageSize);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

#if DOCUMENTATION
using System.Diagnostics.CodeAnalysis;

namespace Subtext
{
	/// <summary>
	/// Subtext is a blogging engine built on the .NET Framework.  
	/// For more information, check out SubtextProject.com.
	/// </summary>
    [SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Justification = "This class is used to generate namespace summary documentation.")]
	internal sealed class NamespaceDoc
	{
		private NamespaceDoc()
		{
		}
	}
}

namespace Subtext.Framework
{
	/// <summary>
	/// Contains the primary framework classes used by 
	/// the Subtext blogging engine.
	/// </summary>
    [SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Justification = "This class is used to generate namespace summary documentation.")]
	internal sealed class NamespaceDoc
	{
		private NamespaceDoc()
		{
		}
	}
}

namespace Subtext.Framework.Configuration
{
	/// <summary>
	/// <p>
	/// Contains classes used to read various configuration data 
	/// for Subtext.  Configuration data is generally stored in two places, 
	/// Web.config or the blog_config table.</p>
	/// <p>
	/// Either way, the class to use when accessing any configuration setting 
	/// is the <see cref="Subtext.Framework.Configuration.Config" /> class.  
	/// </p>
	/// <p>
	/// The <see cref="Config.Settings"/> returns an instance of <see cref="BlogConfigurationSettings"/> 
	/// which contains settings configured in a custom section of Web.config (see the &lt;BlogConfigurationSettings&gt; 
	/// tag in Web.config).
	/// </p>
	/// <p>
	/// The <see cref="Config.CurrentBlog"/> method returns an instance of <see cref="Blog"/> 
	/// contains settings stored in the blog_config table.  This can be used to save settings to 
	/// the configuration as well.
	/// </p>
	/// </summary>
    [SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Justification = "This class is used to generate namespace summary documentation.")]
	internal sealed class NamespaceDoc
	{
		private NamespaceDoc()
		{
		}
	}
}

namespace Subtext.Framework.Components
{
	/// <summary>
	/// Contains the primary business layer classes such as <see cref="Entry"/>, 
	/// <see cref="Image"/>, <see cref="KeyWord"/>.
	/// </summary>
    [SuppressMessage("Microsoft.Performance", "CA1812:AvoidUninstantiatedInternalClasses", Justification = "This class is used to generate namespace summary documentation.")]
	internal sealed class NamespaceDoc
	{
		private NamespaceDoc()
		{
		}
	}
}
#endif#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework
{
    /// <summary>
    /// Constants used to represent null value type.
    /// </summary>
    public static class NullValue
    {
        /// <summary>Represents a null double.</summary>
        public const double NullDouble = double.NaN;

        /// <summary>Represents a null integer.</summary>
        public const int NullInt32 = Int32.MinValue;

        /// <summary>Represents a null DateTime</summary>
        public static DateTime NullDateTime
        {
            get { return DateTime.MinValue; }
        }

        /// <summary>
        /// Determines whether the specified value is null.
        /// </summary>
        /// <param name="number">The value.</param>
        /// <returns>
        /// 	<c>true</c> if the specified value is null; otherwise, <c>false</c>.
        /// </returns>
        public static bool IsNull(int number)
        {
            return number == NullInt32;
        }

        public static bool IsNull(Guid guid)
        {
            return guid == Guid.Empty;
        }

        /// <summary>
        /// Determines whether the specified number is null.
        /// </summary>
        /// <param name="number">The number.</param>
        /// <returns>
        /// 	<c>true</c> if the specified number is null; otherwise, <c>false</c>.
        /// </returns>
        public static bool IsNull(double number)
        {
            return number.Equals(NullDouble);
        }

        /// <summary>
        /// Determines whether the specified date time is null.
        /// </summary>
        /// <param name="dateTime">The date time.</param>
        /// <returns>
        /// 	<c>true</c> if the specified date time is null; otherwise, <c>false</c>.
        /// </returns>
        public static bool IsNull(DateTime dateTime)
        {
            return dateTime == NullDateTime;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Diagnostics.CodeAnalysis;

namespace Subtext.Extensibility
{
    /// <summary>
    /// Think of PostConfig items as filters. These values are often used in the 
    /// WHERE clause of stored procedures, for example.
    /// </summary>
    [SuppressMessage("Microsoft.Naming", "CA1714:FlagsEnumsShouldHavePluralNames")]
    [Flags]
    public enum PostConfig
    {
        None = 0, //no filter. Therefore if getting items, all items will be gotten.
        IsActive = 1, //filter returns only the active items
        IsXhtml = 2,
        AllowComments = 4,
        DisplayOnHomepage = 8,
        IncludeInMainSyndication = 16,
        SyndicateDescriptionOnly = 32,
        IsAggregated = 64,
        CommentsClosed = 128,
        NeedsModeratorApproval = 256,
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Extensibility
{
    /// <summary>
    /// Enumerates the various types of entries within the 
    /// subtext_Content table.  A record in that table 
    /// might be any one of the following enumerations.
    /// </summary>
    public enum PostType
    {
        None = 0,
        BlogPost = 1,
        Story = 2,
    }

    /// <summary>
    /// Enumates the various types of comments within the subtext content table.
    /// </summary>
    public enum FeedbackType
    {
        None = 0,
        Comment = 1,
        PingTrack = 2,
        ContactPage = 3, //Only applies if "ContactToFeedback" is set to true.
    }
}// ---------------------------------------------------------------------------
// GlobalSuppressions.cs
//
// Provides assembly level (global) CodeAnalysis suppressions for FxCop.
//
// While static code analysis with FxCop is excellent for catching many common
// and not so common code errors, there are some things that it flags that
// do not always apply to the project at hand. For those cases, FxCop allows
// you to exclude the message (and optionally give a justification reason for
// excluding it). However, those exclusions are stored only in the FxCop
// project file. In the 2.0 version of the .NET framework, Microsoft introduced
// SuppressMessageAttribute, which is used primarily by the version of FxCop
// that is built in to Visual Studio. As this built-in functionality is not
// included in all versions of Visual Studio, we have opted to continue
// using the standalone version of FxCop. 
//
// In order for this version to recognize SupressMessageAttribute, the
// CODE_ANALYSIS symbol must be defined.
//
// ---------------------------------------------------------------------------
using System.Diagnostics.CodeAnalysis;

[assembly:
    SuppressMessage("Microsoft.Design", "CA2210:AssembliesShouldHaveValidStrongNames", Scope = "assembly",
        Justification = "Assemblies are not currently being signed.")]

// FxCop says that namespaces should generally have more than five types.
// Unfortunately, not all of these namespaces currently have more than five
// types but we still want the namespace so we can expand the library in the
// future without moving types around. 

#region CA1020:AvoidNamespacesWithFewTypes

[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Web.Handlers",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.ImportExport.Conversion",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.ImportExport",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Providers",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Syndication.Compression",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Format",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Web",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Services",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Text",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Security",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Web.HttpModules",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Web.HttpModules",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.UI",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Net",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly:
    SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace",
        Target = "Subtext.Framework.Search",
        Justification =
            "Ignoring this warning...we want this namespace, but don't have enough classes to go in it right now to satisfy the rule."
        )]
[assembly: SuppressMessage("Microsoft.Design", "CA1020:AvoidNamespacesWithFewTypes", Scope = "namespace", Target = "Subtext.Scripting.Exceptions")]
#endregion

// We could use a CustomDictionary.xml file to handle the spelling and case
// rules, but VS2005 Code Analysis doesn't support them and the FxCop add-ins
// and custom external tools don't rely on a project file, so we can't specify
// the location of the CustomDictionary.xml file. We don't want to modify the
// default file that ships with the FxCop distribution either. This does make
// more work for us, but it is the safest solution.

#region CA1704:IdentifiersShouldBeSpelledCorrectly

//[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "Subtext.BlogML.Interfaces.IBlogMLProvider.CreatePostTrackback(BlogML.Xml.BlogMLTrackback,System.String):System.Void", MessageId = "0#trackback")]
//[assembly: SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "member", Target = "Subtext.BlogML.Interfaces.IBlogMLProvider.CreatePostTrackback(BlogML.Xml.BlogMLTrackback,System.String):System.Void", MessageId = "Trackback")]

#endregion﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.4927
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Subtext.Framework.Properties {
    using System;
    
    
    /// <summary>
    ///   A strongly-typed resource class, for looking up localized strings, etc.
    /// </summary>
    // This class was auto-generated by the StronglyTypedResourceBuilder
    // class via a tool like ResGen or Visual Studio.
    // To add or remove a member, edit your .ResX file then rerun ResGen
    // with the /str option, or rebuild your VS project.
    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("System.Resources.Tools.StronglyTypedResourceBuilder", "2.0.0.0")]
    [global::System.Diagnostics.DebuggerNonUserCodeAttribute()]
    [global::System.Runtime.CompilerServices.CompilerGeneratedAttribute()]
    public class Resources {
        
        private static global::System.Resources.ResourceManager resourceMan;
        
        private static global::System.Globalization.CultureInfo resourceCulture;
        
        [global::System.Diagnostics.CodeAnalysis.SuppressMessageAttribute("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode")]
        internal Resources() {
        }
        
        /// <summary>
        ///   Returns the cached ResourceManager instance used by this class.
        /// </summary>
        [global::System.ComponentModel.EditorBrowsableAttribute(global::System.ComponentModel.EditorBrowsableState.Advanced)]
        public static global::System.Resources.ResourceManager ResourceManager {
            get {
                if (object.ReferenceEquals(resourceMan, null)) {
                    global::System.Resources.ResourceManager temp = new global::System.Resources.ResourceManager("Subtext.Framework.Properties.Resources", typeof(Resources).Assembly);
                    resourceMan = temp;
                }
                return resourceMan;
            }
        }
        
        /// <summary>
        ///   Overrides the current thread's CurrentUICulture property for all
        ///   resource lookups using this strongly typed resource class.
        /// </summary>
        [global::System.ComponentModel.EditorBrowsableAttribute(global::System.ComponentModel.EditorBrowsableState.Advanced)]
        public static global::System.Globalization.CultureInfo Culture {
            get {
                return resourceCulture;
            }
            set {
                resourceCulture = value;
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Entry must have a title.
        /// </summary>
        public static string Argument_EntryHasNoTitle {
            get {
                return ResourceManager.GetString("Argument_EntryHasNoTitle", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Entry must have a valid PostType.
        /// </summary>
        public static string Argument_EntryMustHaveValidPostType {
            get {
                return ResourceManager.GetString("Argument_EntryMustHaveValidPostType", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to String cannot be of zero length..
        /// </summary>
        public static string Argument_StringZeroLength {
            get {
                return ResourceManager.GetString("Argument_StringZeroLength", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Cannot convert a comment of type &apos;{0}&apos; to &apos;{1}&apos;.
        /// </summary>
        public static string ArgumentException_CommentTypeMismatch {
            get {
                return ResourceManager.GetString("ArgumentException_CommentTypeMismatch", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to We will not shorten a URL to less than 5 characters. Come on now!.
        /// </summary>
        public static string ArgumentException_TooShortUrl {
            get {
                return ResourceManager.GetString("ArgumentException_TooShortUrl", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Length must not be negative..
        /// </summary>
        public static string ArgumentOutOfRange_LengthMustNotBeNegative {
            get {
                return ResourceManager.GetString("ArgumentOutOfRange_LengthMustNotBeNegative", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Cannot request negative tags. Pass in 0 to get all tags..
        /// </summary>
        public static string ArgumentOutOfRange_NegativeTagItemCount {
            get {
                return ResourceManager.GetString("ArgumentOutOfRange_NegativeTagItemCount", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Semaphore must have a count of at least 0..
        /// </summary>
        public static string ArgumentOutOfRange_SemaphoreCount {
            get {
                return ResourceManager.GetString("ArgumentOutOfRange_SemaphoreCount", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to We&apos;d all like to be able to go back in time, but this is not allowed. Please choose a positive timeout.
        /// </summary>
        public static string ArgumentOutOfRange_StackTraceTimeout {
            get {
                return ResourceManager.GetString("ArgumentOutOfRange_StackTraceTimeout", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to StartIndex cannot be less than zero..
        /// </summary>
        public static string ArgumentOutOfRange_StartIndex {
            get {
                return ResourceManager.GetString("ArgumentOutOfRange_StartIndex", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Length cannot be less than zero..
        /// </summary>
        public static string ArgumnetOutOfRange_Length {
            get {
                return ResourceManager.GetString("ArgumnetOutOfRange_Length", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to are {0} blogs.
        /// </summary>
        public static string BlogCountClause {
            get {
                return ResourceManager.GetString("BlogCountClause", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Sorry, but there {0} with the specified hostname &apos;{1}&apos;.  To set up another blog with the same hostname, you must provide an subfolder name.  Please click on &apos;Host Domain&apos; below for more information..
        /// </summary>
        public static string BlogRequiresSubfolder_ThereAreBlogsWithSameHostName {
            get {
                return ResourceManager.GetString("BlogRequiresSubfolder_ThereAreBlogsWithSameHostName", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Sorry, but there is a delay between allowing comments originating from the same source. Please wait for {0} and try again..
        /// </summary>
        public static string CommentFrequencyException_Message {
            get {
                return ResourceManager.GetString("CommentFrequencyException_Message", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to No connection string matches the key &apos;{0}&apos;..
        /// </summary>
        public static string Configuration_KeyNotFound {
            get {
                return ResourceManager.GetString("Configuration_KeyNotFound", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to There is no connectionString entry associated with the connectionStringName &apos;{0}&apos;..
        /// </summary>
        public static string ConfigurationErrros_NoConnectionString {
            get {
                return ResourceManager.GetString("ConfigurationErrros_NoConnectionString", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to An entry with that EntryName already exists..
        /// </summary>
        public static string DuplicateEntryException_EntryNameAlreadyExists {
            get {
                return ResourceManager.GetString("DuplicateEntryException_EntryNameAlreadyExists", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Comment: {0} (via {1}).
        /// </summary>
        public static string Email_CommentVia {
            get {
                return ResourceManager.GetString("Email_CommentVia", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Enclosure must have a mime type..
        /// </summary>
        public static string Enclosure_MimeTypeRequired {
            get {
                return ResourceManager.GetString("Enclosure_MimeTypeRequired", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Enclosure requires to be bound to a Entry..
        /// </summary>
        public static string Enclosure_NeedsAnEntry {
            get {
                return ResourceManager.GetString("Enclosure_NeedsAnEntry", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Enclosure size must be greater than zero..
        /// </summary>
        public static string Enclosure_SizeGreaterThanZero {
            get {
                return ResourceManager.GetString("Enclosure_SizeGreaterThanZero", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Enclosure must have an URL..
        /// </summary>
        public static string Enclosure_UrlRequired {
            get {
                return ResourceManager.GetString("Enclosure_UrlRequired", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to ExtendedProperties bytes overflow. The ExtendedProperties is limited to 7800 bytes.
        /// </summary>
        public static string ExtendedPropertiesOverflow_Generic {
            get {
                return ResourceManager.GetString("ExtendedPropertiesOverflow_Generic", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to File Not Found.
        /// </summary>
        public static string FileNotFound {
            get {
                return ResourceManager.GetString("FileNotFound", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to String was not recognized as a valid DateTime..
        /// </summary>
        public static string Format_BadDateTime {
            get {
                return ResourceManager.GetString("Format_BadDateTime", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not format &apos;{0}:{1}&apos;.
        /// </summary>
        public static string Format_CouldNotFormatExpression {
            get {
                return ResourceManager.GetString("Format_CouldNotFormatExpression", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Invalid blog id &apos;{0}&apos; specified.
        /// </summary>
        public static string Format_InvalidBlogId {
            get {
                return ResourceManager.GetString("Format_InvalidBlogId", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Invalid Expression.
        /// </summary>
        public static string Format_InvalidExpression {
            get {
                return ResourceManager.GetString("Format_InvalidExpression", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Invalid Post ID..
        /// </summary>
        public static string Format_InvalidPostId {
            get {
                return ResourceManager.GetString("Format_InvalidPostId", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Missing attribute &apos;{0}&apos;..
        /// </summary>
        public static string HttpException_MissingAttribute {
            get {
                return ResourceManager.GetString("HttpException_MissingAttribute", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Illegal Characters Found.
        /// </summary>
        public static string IllegalPostCharacters {
            get {
                return ResourceManager.GetString("IllegalPostCharacters", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to An exception occurred while importing a comment.
        /// </summary>
        public static string Import_ErrorWhileImportingComment {
            get {
                return ResourceManager.GetString("Import_ErrorWhileImportingComment", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Backslashes are not allowed in the rss proxy name..
        /// </summary>
        public static string InvalidOperation_BackslashesInRssProxyName {
            get {
                return ResourceManager.GetString("InvalidOperation_BackslashesInRssProxyName", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Cannot destroy an approved comment. Please flag it as spam or trash it first..
        /// </summary>
        public static string InvalidOperation_CannotDestroyApprovedComment {
            get {
                return ResourceManager.GetString("InvalidOperation_CannotDestroyApprovedComment", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to ContentRegion with ID &apos;{0}&apos; must be Defined.
        /// </summary>
        public static string InvalidOperation_ContentRegionNotFound {
            get {
                return ResourceManager.GetString("InvalidOperation_ContentRegionNotFound", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Content Type must be text/xml.
        /// </summary>
        public static string InvalidOperation_ContentTypeMustBeXml {
            get {
                return ResourceManager.GetString("InvalidOperation_ContentTypeMustBeXml", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Cannot destroy an active comment..
        /// </summary>
        public static string InvalidOperation_DestroyActiveComment {
            get {
                return ResourceManager.GetString("InvalidOperation_DestroyActiveComment", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to DirectoryRouteHandler only works with IDirectoryRoutes.
        /// </summary>
        public static string InvalidOperation_DirectoryRouteHandlerWorksWithDirectoryRoutes {
            get {
                return ResourceManager.GetString("InvalidOperation_DirectoryRouteHandlerWorksWithDirectoryRoutes", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to A Host record already exists.
        /// </summary>
        public static string InvalidOperation_HostRecordAlreadyExists {
            get {
                return ResourceManager.GetString("InvalidOperation_HostRecordAlreadyExists", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Cannot create a Host record.  One already exists..
        /// </summary>
        public static string InvalidOperation_HostRecordExists {
            get {
                return ResourceManager.GetString("InvalidOperation_HostRecordExists", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to There were invalid characetres in the file name &apos;{0}&apos;.
        /// </summary>
        public static string InvalidOperation_InvalidCharactersInFileName {
            get {
                return ResourceManager.GetString("InvalidOperation_InvalidCharactersInFileName", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Invalid Date Format.
        /// </summary>
        public static string InvalidOperation_InvalidDateFormat {
            get {
                return ResourceManager.GetString("InvalidOperation_InvalidDateFormat", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Invalid Feedback Status supplied &apos;{0}&apos;.
        /// </summary>
        public static string InvalidOperation_InvalidFeedbackStatus {
            get {
                return ResourceManager.GetString("InvalidOperation_InvalidFeedbackStatus", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to The LocalDirectoryPath has not been set yet..
        /// </summary>
        public static string InvalidOperation_LocalDirectoryPathNotSet {
            get {
                return ResourceManager.GetString("InvalidOperation_LocalDirectoryPathNotSet", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to PostType must not be set to PostType.None.
        /// </summary>
        public static string InvalidOperation_PostTypeIsNone {
            get {
                return ResourceManager.GetString("InvalidOperation_PostTypeIsNone", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to TemplateFile Property for MasterPage must be Defined.
        /// </summary>
        public static string InvalidOperation_TemplateFileIsNull {
            get {
                return ResourceManager.GetString("InvalidOperation_TemplateFileIsNull", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to The Template parameters are null. This should is impossible..
        /// </summary>
        public static string InvalidOperation_TemplateParametersNull {
            get {
                return ResourceManager.GetString("InvalidOperation_TemplateParametersNull", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Akismet returned an empty response.
        /// </summary>
        public static string InvalidResponse_EmptyResponse {
            get {
                return ResourceManager.GetString("InvalidResponse_EmptyResponse", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Received the response &apos;{0}&apos; from Akismet. Probably a bad API key..
        /// </summary>
        public static string InvalidResponse_PossiblyBadApiKey {
            get {
                return ResourceManager.GetString("InvalidResponse_PossiblyBadApiKey", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to The service was not able to handle our request. Http Status &apos;{0}&apos;..
        /// </summary>
        public static string InvalidResponse_ServiceUnableToHandleRequest {
            get {
                return ResourceManager.GetString("InvalidResponse_ServiceUnableToHandleRequest", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to is another blog.
        /// </summary>
        public static string IsAnotherBlog {
            get {
                return ResourceManager.GetString("IsAnotherBlog", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Approve.
        /// </summary>
        public static string Label_Approve {
            get {
                return ResourceManager.GetString("Label_Approve", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Comments.
        /// </summary>
        public static string Label_Comments {
            get {
                return ResourceManager.GetString("Label_Comments", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Comments Flagged as SPAM.
        /// </summary>
        public static string Label_CommentsFlaggedAsSpam {
            get {
                return ResourceManager.GetString("Label_CommentsFlaggedAsSpam", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Comments In The Trash Bin.
        /// </summary>
        public static string Label_CommentsInTrash {
            get {
                return ResourceManager.GetString("Label_CommentsInTrash", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Comments Pending Moderator Approval.
        /// </summary>
        public static string Label_CommentsPendingModeratorApproval {
            get {
                return ResourceManager.GetString("Label_CommentsPendingModeratorApproval", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Destroy all spam, not just checked.
        /// </summary>
        public static string Label_DestroySpamTooltip {
            get {
                return ResourceManager.GetString("Label_DestroySpamTooltip", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Destroy all trash, not just checked.
        /// </summary>
        public static string Label_DestroyTrashTooltip {
            get {
                return ResourceManager.GetString("Label_DestroyTrashTooltip", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to &lt;em&gt;There are no approved comments to display.&lt;/em&gt;.
        /// </summary>
        public static string Label_NoApprovedComments {
            get {
                return ResourceManager.GetString("Label_NoApprovedComments", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to &lt;em&gt;No Entries Flagged as SPAM.&lt;/em&gt;.
        /// </summary>
        public static string Label_NoCommentsFlaggedAsSpam {
            get {
                return ResourceManager.GetString("Label_NoCommentsFlaggedAsSpam", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to &lt;em&gt;No Entries in the Trash.&lt;/em&gt;.
        /// </summary>
        public static string Label_NoCommentsInTrash {
            get {
                return ResourceManager.GetString("Label_NoCommentsInTrash", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to &lt;em&gt;No Entries Need Moderation.&lt;/em&gt;.
        /// </summary>
        public static string Label_NoCommentsNeedModeration {
            get {
                return ResourceManager.GetString("Label_NoCommentsNeedModeration", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Trashes checked spam.
        /// </summary>
        public static string Label_TrashesSpam {
            get {
                return ResourceManager.GetString("Label_TrashesSpam", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Undelete.
        /// </summary>
        public static string Label_Undelete {
            get {
                return ResourceManager.GetString("Label_Undelete", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not extract entry id from incoming URL &apos;{0}.
        /// </summary>
        public static string Log_CouldNotExtractEntryId {
            get {
                return ResourceManager.GetString("Log_CouldNotExtractEntryId", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to {1} referrals from &lt;a href=\&quot;{0}\&quot;&gt;{0}&lt;/a&gt;.
        /// </summary>
        public static string Message_ReferrersForm {
            get {
                return ResourceManager.GetString("Message_ReferrersForm", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to minutes.
        /// </summary>
        public static string Minutes_Plural {
            get {
                return ResourceManager.GetString("Minutes_Plural", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to minute.
        /// </summary>
        public static string Minutes_Singular {
            get {
                return ResourceManager.GetString("Minutes_Singular", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not find the private instance field &apos;{0}&apos;.
        /// </summary>
        public static string ReflectionArgument_CouldNotFindInstanceField {
            get {
                return ResourceManager.GetString("ReflectionArgument_CouldNotFindInstanceField", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not find a method with the name &apos;{0}&apos;.
        /// </summary>
        public static string ReflectionArgument_CouldNotFindMethod {
            get {
                return ResourceManager.GetString("ReflectionArgument_CouldNotFindMethod", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not find a property with the name &apos;{0}&apos;.
        /// </summary>
        public static string ReflectionArgument_CouldNotFindProperty {
            get {
                return ResourceManager.GetString("ReflectionArgument_CouldNotFindProperty", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not find the static field &apos;{0}&apos;.
        /// </summary>
        public static string ReflectionArgument_CouldNotFindsStaticField {
            get {
                return ResourceManager.GetString("ReflectionArgument_CouldNotFindsStaticField", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Script has no tokens..
        /// </summary>
        public static string ScriptHasNoTokens {
            get {
                return ResourceManager.GetString("ScriptHasNoTokens", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not load this Skin control.
        /// </summary>
        public static string SkinControlLoadException_Message {
            get {
                return ResourceManager.GetString("SkinControlLoadException_Message", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Incorrect syntax was encountered while parsing GO. Cannot have a slash star /* comment */ after a GO statement..
        /// </summary>
        public static string SqlParseException_IncorrectSyntaxNearGo {
            get {
                return ResourceManager.GetString("SqlParseException_IncorrectSyntaxNearGo", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Error in executing the script: {0}.
        /// </summary>
        public static string SqlScriptExecutionError_ErrorInScript {
            get {
                return ResourceManager.GetString("SqlScriptExecutionError_ErrorInScript", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to An error occurred while executing the script..
        /// </summary>
        public static string SqlScriptExecutionError_ErrorOccurred {
            get {
                return ResourceManager.GetString("SqlScriptExecutionError_ErrorOccurred", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Timeout waiting for lock.
        /// </summary>
        public static string TimeoutWaitingForLock {
            get {
                return ResourceManager.GetString("TimeoutWaitingForLock", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to EntryId is invalid or missing.
        /// </summary>
        public static string TrackbackResponse_EntryIdMissing {
            get {
                return ResourceManager.GetString("TrackbackResponse_EntryIdMissing", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Sorry couldn&apos;t find a relevant link in {0}.
        /// </summary>
        public static string TrackbackResponse_NoRelevantLink {
            get {
                return ResourceManager.GetString("TrackbackResponse_NoRelevantLink", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to no url parameter found, please try harder!.
        /// </summary>
        public static string TrackbackResponse_NoUrl {
            get {
                return ResourceManager.GetString("TrackbackResponse_NoUrl", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to &lt;!--
        ///   &lt;rdf:RDF 
        ///      xmlns:rdf=&quot;http://www.w3.org/1999/02/22-rdf-syntax-ns#&quot;
        ///      xmlns:dc=&quot;http://purl.org/dc/elements/1.1/&quot;
        ///      xmlns:trackback=&quot;http://madskills.com/public/xml/rss/module/trackback/&quot;&gt;
        ///
        ///      &lt;rdf:Description
        ///         rdf:about=&quot;{0}&quot;
        ///         dc:identifier=&quot;{1}&quot;
        ///         dc:title=&quot;{2}&quot;
        ///         trackback:ping=&quot;{3}services/trackbacks/{4}.aspx&quot; 
        ///      /&gt;
        ///   &lt;/rdf:RDF&gt;
        ///--&gt;.
        /// </summary>
        public static string TrackbackTag {
            get {
                return ResourceManager.GetString("TrackbackTag", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Undisposed Lock.
        /// </summary>
        public static string UndisposedLock {
            get {
                return ResourceManager.GetString("UndisposedLock", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to You did not link to a permalink.
        /// </summary>
        public static string XmlRcpFault_DidNotLinkToPermalink {
            get {
                return ResourceManager.GetString("XmlRcpFault_DidNotLinkToPermalink", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Not a valid link.
        /// </summary>
        public static string XmlRcpFault_InvalidLink {
            get {
                return ResourceManager.GetString("XmlRcpFault_InvalidLink", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Error while connecting to the Community Credit webservice.
        /// </summary>
        public static string XmlRpcError_CommunityCredits {
            get {
                return ResourceManager.GetString("XmlRpcError_CommunityCredits", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to The post could not be added.
        /// </summary>
        public static string XmlRpcFault_AddPostFailed {
            get {
                return ResourceManager.GetString("XmlRpcFault_AddPostFailed", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not delete page:{0}.
        /// </summary>
        public static string XmlRpcFault_CannotDeletePage {
            get {
                return ResourceManager.GetString("XmlRpcFault_CannotDeletePage", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Could not delete post: {0}.
        /// </summary>
        public static string XmlRpcFault_CannotDeletePost {
            get {
                return ResourceManager.GetString("XmlRpcFault_CannotDeletePost", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to The entry could not be found.
        /// </summary>
        public static string XmlRpcFault_CouldNotFindEntry {
            get {
                return ResourceManager.GetString("XmlRpcFault_CouldNotFindEntry", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Error saving file..
        /// </summary>
        public static string XmlRpcFault_ErrorSavingFile {
            get {
                return ResourceManager.GetString("XmlRpcFault_ErrorSavingFile", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to No categories exist.
        /// </summary>
        public static string XmlRpcFault_NoCategories {
            get {
                return ResourceManager.GetString("XmlRpcFault_NoCategories", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Username and password denied..
        /// </summary>
        public static string XmlRpcFault_UsernameAndPasswordInvalid {
            get {
                return ResourceManager.GetString("XmlRpcFault_UsernameAndPasswordInvalid", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Web Service Access is not enabled..
        /// </summary>
        public static string XmlRpcFault_WebServiceNotEnabled {
            get {
                return ResourceManager.GetString("XmlRpcFault_WebServiceNotEnabled", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to thanks for the pingback on {0}.
        /// </summary>
        public static string XmlRpcMessage_ThanksForThePingback {
            get {
                return ResourceManager.GetString("XmlRpcMessage_ThanksForThePingback", resourceCulture);
            }
        }
        
        /// <summary>
        ///   Looks up a localized string similar to Community Credit ws returned the following response while notifying for the url {0}: {1}.
        /// </summary>
        public static string XmlRpcWarn_CommunityCredits {
            get {
                return ResourceManager.GetString("XmlRpcWarn_CommunityCredits", resourceCulture);
            }
        }
    }
}
﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Runtime Version:2.0.50727.3053
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace Subtext.Framework.Properties {
    
    
    [global::System.Runtime.CompilerServices.CompilerGeneratedAttribute()]
    [global::System.CodeDom.Compiler.GeneratedCodeAttribute("Microsoft.VisualStudio.Editors.SettingsDesigner.SettingsSingleFileGenerator", "9.0.0.0")]
    internal sealed partial class Settings : global::System.Configuration.ApplicationSettingsBase {
        
        private static Settings defaultInstance = ((Settings)(global::System.Configuration.ApplicationSettingsBase.Synchronized(new Settings())));
        
        public static Settings Default {
            get {
                return defaultInstance;
            }
        }
        
        [global::System.Configuration.ApplicationScopedSettingAttribute()]
        [global::System.Diagnostics.DebuggerNonUserCodeAttribute()]
        [global::System.Configuration.SpecialSettingAttribute(global::System.Configuration.SpecialSetting.WebServiceUrl)]
        [global::System.Configuration.DefaultSettingValueAttribute("http://www.community-credit.com/services/affiliateservices.asmx")]
        public string Subtext_Framework_com_community_credit_www_AffiliateServices {
            get {
                return ((string)(this["Subtext_Framework_com_community_credit_www_AffiliateServices"]));
            }
        }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration.Provider;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Components;
using Subtext.Framework.Configuration;
using Subtext.Framework.Data;

namespace Subtext.Framework.Providers
{
    /// <summary>
    /// This is the API for interacting with the data in Subtext. This is essentially the repository.
    /// </summary>
    public abstract class ObjectProvider : ProviderBase
    {
        private static readonly ObjectProvider Provider = new DatabaseObjectProvider();

        /// <summary>
        /// Returns the currently configured ObjectProvider.
        /// </summary>
        /// <returns></returns>
        public static ObjectProvider Instance()
        {
            return Provider;
        }

        public abstract void ClearBlogContent(int blogId);

        /// <summary>
        /// Returns the <see cref="HostInfo"/> for the Subtext installation.
        /// </summary>
        /// <returns>A <see cref="HostInfo"/> instance.</returns>
        public abstract HostInfo LoadHostInfo(HostInfo info);

        /// <summary>
        /// Updates the <see cref="HostInfo"/> instance.  If the host record is not in the 
        /// database, one is created. There should only be one host record.
        /// </summary>
        /// <param name="hostInfo">The host information.</param>
        public abstract bool UpdateHost(HostInfo hostInfo);

        /// <summary>
        /// Inserts the blog group.
        /// </summary>
        /// <param name="blogGroup">The group to insert.</param>
        /// <returns>The blog group id</returns>
        public abstract int InsertBlogGroup(BlogGroup blogGroup);

        /// <summary>
        /// Update the blog group.
        /// </summary>
        /// <param name="blogGroup">The group to insert.</param>
        /// <returns>The blog group id</returns>
        public abstract bool UpdateBlogGroup(BlogGroup blogGroup);

        public abstract bool DeleteBlogGroup(int blogGroupId);

        /// <summary>
        /// Gets a pageable <see cref="ICollection"/> of <see cref="Blog"/> instances.
        /// </summary>
        /// <param name="host">The host to filter by.</param>
        /// <param name="pageIndex">Page index.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <returns></returns>
        /// <param name="flags"></param>
        public abstract IPagedCollection<Blog> GetPagedBlogs(string host, int pageIndex, int pageSize,
                                                             ConfigurationFlags flags);

        /// <summary>
        /// Gets the blog by id.
        /// </summary>
        /// <param name="blogId">Blog id.</param>
        /// <returns></returns>
        public abstract Blog GetBlogById(int blogId);

        public abstract Blog GetBlogByDomainAlias(string host, string subfolder, bool strict);

        public abstract IPagedCollection<BlogAlias> GetPagedBlogDomainAlias(Blog blog, int pageIndex, int pageSize);

        /// <summary>
        /// Gets the blog group by id.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public abstract BlogGroup GetBlogGroup(int id, bool activeOnly);

        /// <summary>
        /// Lists the blog groups.
        /// </summary>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public abstract ICollection<BlogGroup> ListBlogGroups(bool activeOnly);

        public abstract bool CreateBlogAlias(BlogAlias alias);

        public abstract bool UpdateBlogAlias(BlogAlias alias);

        public abstract bool DeleteBlogAlias(BlogAlias alias);

        /// <summary>
        /// Gets the paged feedback.
        /// </summary>
        /// <param name="pageIndex">Index of the page.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <param name="status">A flag for the status types to return.</param>
        /// <param name="excludeStatusMask">A flag for the statuses to exclude.</param>
        /// <param name="type">The type of feedback to return.</param>
        /// <returns></returns>
        public abstract IPagedCollection<FeedbackItem> GetPagedFeedback(int pageIndex, int pageSize,
                                                                        FeedbackStatusFlag status,
                                                                        FeedbackStatusFlag excludeStatusMask,
                                                                        FeedbackType type);


        public abstract EntryDay GetEntryDay(DateTime dt);

        /// <summary>
        /// Returns the previous and next entry to the specified entry.
        /// </summary>
        /// <param name="entryId"></param>
        /// <param name="postType"></param>
        /// <returns></returns>
        public abstract ICollection<EntrySummary> GetPreviousAndNextEntries(int entryId, PostType postType);

        /// <summary>
        /// Returns a pageable collection of entries ordered by the id descending.
        /// This is used in the admin section.
        /// </summary>
        /// <param name="postType">Type of the post.</param>
        /// <param name="categoryId">The category ID.</param>
        /// <param name="pageIndex">Index of the page.</param>
        /// <param name="pageSize">Size of the page.</param>
        /// <returns></returns>
        public abstract IPagedCollection<EntryStatsView> GetEntries(PostType postType, int? categoryId, int pageIndex, int pageSize);

        /// <summary>
        /// Gets the entries that meet the <see cref="PostType"/> and 
        /// <see cref="PostConfig"/> flags.
        /// </summary>
        /// <param name="itemCount">Item count.</param>
        /// <param name="postType">The type of entry to return.</param>
        /// <param name="postConfig">Post Configuration options.</param>
        /// <param name="includeCategories">Whether or not to include categories</param>
        /// <returns></returns>
        public abstract ICollection<Entry> GetEntries(int itemCount, PostType postType, PostConfig postConfig, bool includeCategories);
        public abstract ICollection<Entry> GetEntriesByCategory(int itemCount, int categoryId, bool activeOnly);
        public abstract ICollection<Entry> GetEntriesByTag(int itemCount, string tagName);
        public abstract ICollection<Entry> GetPostsByMonth(int month, int year);
        public abstract ICollection<Entry> GetPostsByDayRange(DateTime start, DateTime stop, PostType postType, bool activeOnly);
        public abstract IPagedCollection<EntryStatsView> GetEntriesForExport(int pageIndex, int pageSize);

        public abstract ICollection<EntryStatsView> GetPopularEntries(int blogId, DateFilter filter);

        /// <summary>
        /// Gets the <see cref="FeedbackItem" /> items for the specified entry.
        /// </summary>
        /// <param name="parentEntry">The parent entry.</param>
        /// <returns></returns>
        public abstract ICollection<FeedbackItem> GetFeedbackForEntry(Entry parentEntry);

        /// <summary>
        /// Gets the feedback by the specified id.
        /// </summary>
        /// <param name="id">The id.</param>
        /// <returns></returns>
        public abstract FeedbackItem GetFeedback(int id);

        /// <summary>
        /// Gets the feedback counts for the various top level statuses.
        /// </summary>
        /// <param name="approved">The approved.</param>
        /// <param name="needsModeration">The needs moderation.</param>
        /// <param name="flaggedAsSpam">The flagged as spam.</param>
        /// <param name="deleted">The deleted.</param>
        public abstract void GetFeedbackCounts(out int approved, out int needsModeration, out int flaggedAsSpam,
                                               out int deleted);

        /// <summary>
        /// Searches the data store for the first comment with a 
        /// matching checksum hash.
        /// </summary>
        /// <param name="checksumHash">Checksum hash.</param>
        /// <returns></returns>
        public abstract FeedbackItem GetFeedbackByChecksumHash(string checksumHash);

        /// <summary>
        /// Returns an <see cref="Entry" /> with the specified id as long as it is 
        /// within the current blog (Config.CurrentBlog).
        /// </summary>
        /// <param name="id">Id of the entry</param>
        /// <param name="activeOnly">Whether or not to only return the entry if it is active.</param>
        /// <param name="includeCategories">Whether the entry should have its Categories property populated</param>
        /// <returns></returns>
        public abstract Entry GetEntry(int id, bool activeOnly, bool includeCategories);

        /// <summary>
        /// Returns an <see cref="Entry" /> with the specified entry name as long as it is 
        /// within the current blog (Config.CurrentBlog).
        /// </summary>
        /// <param name="entryName">Url friendly entry name.</param>
        /// <param name="activeOnly">Whether or not to only return the entry if it is active.</param>
        /// <param name="includeCategories">Whether the entry should have its Categories property populated</param>
        /// <returns></returns>
        public abstract Entry GetEntry(string entryName, bool activeOnly, bool includeCategories);

        /// <summary>
        /// Deletes the specified entry.
        /// </summary>
        /// <param name="entryId">The entry id.</param>
        /// <returns></returns>
        public abstract bool DeleteEntry(int entryId);

        /// <summary>
        /// Completely deletes the specified feedback as 
        /// opposed to moving it to the trash.
        /// </summary>
        /// <param name="id">The id.</param>
        public abstract void DestroyFeedback(int id);

        /// <summary>
        /// Destroys the feedback with the given status.
        /// </summary>
        /// <param name="status">The status.</param>
        public abstract void DestroyFeedback(FeedbackStatusFlag status);

        /// <summary>
        /// Creates a feedback record and returs the id of the newly created item.
        /// </summary>
        /// <param name="feedbackItem"></param>
        /// <returns></returns>
        public abstract int Create(FeedbackItem feedbackItem);

        /// <summary>
        /// Creates the specified entry attaching the specified categories.
        /// </summary>
        /// <param name="entry">Entry.</param>
        /// <param name="categoryIds">Category Ids.</param>
        /// <returns></returns>
        public abstract int Create(Entry entry, IEnumerable<int> categoryIds);

        /// <summary>
        /// Saves changes to the specified entry attaching the specified categories.
        /// </summary>
        /// <param name="entry">Entry.</param>
        /// <param name="categoryIds">Category Ids.</param>
        /// <returns></returns>
        public abstract bool Update(Entry entry, IEnumerable<int> categoryIds);

        /// <summary>
        /// Saves changes to the specified feedback.
        /// </summary>
        /// <param name="feedbackItem">The feedback item.</param>
        /// <returns></returns>
        public abstract bool Update(FeedbackItem feedbackItem);

        public abstract bool SetEntryCategoryList(int entryId, IEnumerable<int> categoryIds);

        /// <summary>
        /// Sets the tags for the entry.
        /// </summary>
        /// <param name="entryId"></param>
        /// <param name="tags"></param>
        /// <returns></returns>
        public abstract bool SetEntryTagList(int entryId, IEnumerable<string> tags);

        public abstract IPagedCollection<Link> GetPagedLinks(int? categoryTypeId, int pageIndex, int pageSize,
                                                             bool sortDescending);

        public abstract ICollection<Link> GetLinkCollectionByPostId(int postId);
        public abstract Link GetLink(int linkId);
        public abstract ICollection<LinkCategory> GetCategories(CategoryType categoryType, bool activeOnly);
        public abstract ICollection<LinkCategory> GetActiveCategories();

        /// <summary>
        /// Gets the link category for the specified category id.
        /// </summary>
        /// <param name="categoryId">The category id.</param>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public abstract LinkCategory GetLinkCategory(int? categoryId, bool activeOnly);

        /// <summary>
        /// Gets the link category for the specified category name.
        /// </summary>
        /// <param name="categoryName">The category name.</param>
        /// <param name="activeOnly">if set to <c>true</c> [active only].</param>
        /// <returns></returns>
        public abstract LinkCategory GetLinkCategory(string categoryName, bool activeOnly);

        public abstract bool UpdateLink(Link link);
        public abstract int CreateLink(Link link);
        public abstract bool UpdateLinkCategory(LinkCategory linkCategory);
        public abstract int CreateLinkCategory(LinkCategory linkCategory);
        public abstract bool DeleteLinkCategory(int categoryId);
        public abstract bool DeleteLink(int linkId);

        public abstract IPagedCollection<Referrer> GetPagedReferrers(int pageIndex, int pageSize, int entryId);
        public abstract bool TrackEntry(EntryView ev);

        /// <summary>
        /// Adds the initial blog configuration.  This is a convenience method for 
        /// allowing a user with a freshly installed blog to immediately gain access 
        /// to the admin section to edit the blog.
        /// </summary>
        /// <param name="title"></param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">Password.</param>
        /// <param name="host"></param>
        /// <param name="subfolder"></param>
        /// <returns></returns>
        public abstract int CreateBlog(string title, string userName, string password, string host, string subfolder);

        /// <summary>
        /// Adds the initial blog configuration.  This is a convenience method for 
        /// allowing a user with a freshly installed blog to immediately gain access 
        /// to the admin section to edit the blog.
        /// </summary>
        /// <param name="title"></param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">Password.</param>
        /// <param name="host"></param>
        /// <param name="subfolder"></param>
        /// <param name="blogGroupId"></param>
        /// <returns>The id of the created blog.</returns>
        public abstract int CreateBlog(string title, string userName, string password, string host, string subfolder,
                                       int blogGroupId);

        /// <summary>
        /// Updates the specified blog configuration.
        /// </summary>
        /// <param name="info">Config.</param>
        /// <returns></returns>
        public abstract bool UpdateBlog(Blog info);

        /// <summary>
        /// Returns a <see cref="Blog"/> instance containing 
        /// the configuration settings for the blog specified by the 
        /// Hostname and Application.
        /// </summary>
        /// <remarks>
        /// Until Subtext supports multiple blogs again (if ever), 
        /// this will always return the same instance.
        /// </remarks>
        /// <param name="hostname">Hostname.</param>
        /// <param name="subfolder">Subfolder Name.</param>
        /// <returns></returns>
        public abstract Blog GetBlog(string hostname, string subfolder);

        /// <summary>
        /// Gets the top tags from the database sorted by tag name.
        /// </summary>
        /// <param name="itemCount">The number of tags to return.</param>
        /// <returns>
        /// A sorted dictionary with the tag name as key and entry count
        /// as value.
        /// </returns>
        public abstract IDictionary<string, int> GetTopTags(int itemCount);

        /// <summary>
        /// Adds the given MetaTag to the data store.
        /// </summary>
        /// <param name="metaTag"></param>
        /// <returns></returns>
        public abstract int Create(MetaTag metaTag);

        /// <summary>
        /// Updates the given MetaTag in the data store.
        /// </summary>
        /// <param name="metaTag"></param>
        /// <returns></returns>
        public abstract bool Update(MetaTag metaTag);

        /// <summary>
        /// Gets a collection of MetaTags for the given Blog.
        /// </summary>
        /// <returns></returns>
        public abstract IPagedCollection<MetaTag> GetMetaTagsForBlog(Blog blog, int pageIndex, int pageSize);

        /// <summary>
        /// Gets a collection of MetaTags for the given Entry
        /// </summary>
        /// <returns></returns>
        public abstract IPagedCollection<MetaTag> GetMetaTagsForEntry(Entry entry, int pageIndex, int pageSize);

        /// <summary>
        /// Deletes the MetaTag with the given metaTagId.
        /// </summary>
        /// <param name="metaTagId"></param>
        /// <returns></returns>
        public abstract bool DeleteMetaTag(int metaTagId);

        /// <summary>
        /// Adds the given enclosure to the data store
        /// </summary>
        /// <param name="enclosure"></param>
        /// <returns>Id of the enclosure created</returns>
        public abstract int Create(Enclosure enclosure);

        public abstract bool Update(Enclosure metaTag);
        public abstract bool DeleteEnclosure(int enclosureId);

        public abstract KeyWord GetKeyWord(int id);
        public abstract ICollection<KeyWord> GetKeyWords();
        public abstract IPagedCollection<KeyWord> GetPagedKeyWords(int pageIndex, int pageSize);
        public abstract bool UpdateKeyWord(KeyWord keyWord);
        public abstract int InsertKeyWord(KeyWord keyWord);
        public abstract bool DeleteKeyWord(int id);

        public abstract ImageCollection GetImagesByCategoryId(int categoryId, bool activeOnly);
        public abstract Image GetImage(int imageId, bool activeOnly);
        public abstract int InsertImage(Image image);
        public abstract bool UpdateImage(Image image);
        public abstract bool DeleteImage(int imageId);

        public abstract ICollection<ArchiveCount> GetPostCountsByYear();
        public abstract ICollection<ArchiveCount> GetPostCountsByMonth();
        public abstract ICollection<ArchiveCount> GetPostCountsByCategory();

        public abstract BlogStatistics GetBlogStatistics(int blogId);
        public abstract BlogAlias GetBlogAliasById(int aliasId);
        public abstract ICollection<Blog> GetBlogsByGroup(string host, int? groupId);
        public abstract ICollection<BlogGroup> GroupBlogs(IEnumerable<Blog> blogs);
        public abstract HostStats GetTotalBlogStats(string host, int? groupId);
        public abstract ICollection<Entry> GetRecentEntries(string host, int? groupId, int rowCount);
        public abstract ICollection<Image> GetImages(string host, int? groupId, int rowCount);
        public abstract ICollection<EntrySummary> GetTopEntrySummaries(int blogId, int rowCount);
        public abstract ICollection<EntrySummary> GetRelatedEntries(int blogId, int entryId, int rowCount);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Data;
using Subtext.Framework.Components;
using Subtext.Framework.Data;
using Subtext.Framework.Routing;

namespace Subtext.Framework.Providers
{
    public class SearchEngine
    {
        readonly Blog _blog;
        readonly StoredProcedures _procedures;
        readonly UrlHelper _urlHelper;

        public SearchEngine(Blog blog, UrlHelper urlHelper, string connectionString)
        {
            _blog = blog;
            _procedures = new StoredProcedures(connectionString);
            _urlHelper = urlHelper;
        }

        /// <summary>
        /// Searches the specified blog for items that match the search term.
        /// </summary>
        /// <param name="blogId"></param>
        /// <param name="searchTerm"></param>
        /// <returns></returns>
        public virtual ICollection<SearchResult> Search(int blogId, string searchTerm)
        {
            ICollection<SearchResult> results = new List<SearchResult>();

            using(IDataReader reader = _procedures.SearchEntries(blogId, searchTerm, _blog.TimeZone.Now))
            {
                while(reader.Read())
                {
                    Entry foundEntry = reader.ReadEntry(true);
                    results.Add(new SearchResult(foundEntry.Title, _urlHelper.EntryUrl(foundEntry).ToUri()));
                }
            }
            return results;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Providers
{
    public class SearchResult
    {
        public SearchResult(string title, Uri url)
        {
            Title = title;
            Url = url;
        }

        public string Title { get; private set; }

        public Uri Url { get; private set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Diagnostics.CodeAnalysis;
using System.Globalization;
using System.Net;
using System.Web;
using Subtext.Framework.Properties;

namespace Subtext.Akismet
{
    /// <summary>
    /// The client class used to communicate with the 
    /// <see href="http://akismet.com/">Akismet</see> service.
    /// </summary>
    [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Akismet")]
    [Serializable]
    public class AkismetClient
    {
        const string CheckUrlFormat = "http://{0}.rest.akismet.com/1.1/comment-check";
        const string SubmitHamUrlFormat = "http://{0}.rest.akismet.com/1.1/submit-ham";
        const string SubmitSpamUrlFormat = "http://{0}.rest.akismet.com/1.1/submit-spam";
        static readonly Uri VerifyUrl = new Uri("http://rest.akismet.com/1.1/verify-key");
        static readonly string Version = typeof(HttpClient).Assembly.GetName().Version.ToString();
        string _apiKey;
        Uri _checkUrl;
        [NonSerialized] private readonly HttpClient _httpClient;
        Uri _submitHamUrl;
        Uri _submitSpamUrl;
        string _userAgent;

        protected AkismetClient()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AkismetClient"/> class.
        /// </summary>
        /// <param name="apiKey">The Akismet API key.</param>
        /// <param name="blogUrl">The root url of the blog.</param>
        public AkismetClient(string apiKey, Uri blogUrl)
            : this(apiKey, blogUrl, new HttpClient())
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="AkismetClient"/> class.
        /// </summary>
        /// <remarks>
        /// This constructor takes in all the dependencies to allow for 
        /// dependency injection and unit testing. Seems like overkill, 
        /// but it's worth it.
        /// </remarks>
        /// <param name="apiKey">The Akismet API key.</param>
        /// <param name="blogUrl">The root url of the blog.</param>
        /// <param name="httpClient">Client class used to make the underlying requests.</param>
        public AkismetClient(string apiKey, Uri blogUrl, HttpClient httpClient)
        {
            if(apiKey == null)
            {
                throw new ArgumentNullException("apiKey");
            }

            if(blogUrl == null)
            {
                throw new ArgumentNullException("blogUrl");
            }

            if(httpClient == null)
            {
                throw new ArgumentNullException("httpClient");
            }

            _apiKey = apiKey;
            BlogUrl = blogUrl;
            _httpClient = httpClient;
            Timeout = 5000; /* default */
            SetServiceUrls();
        }

        /// <summary>
        /// Gets or sets the Akismet API key.
        /// </summary>
        /// <value>The API key.</value>
        public string ApiKey
        {
            get { return _apiKey ?? string.Empty; }
            set
            {
                _apiKey = value ?? string.Empty;
                SetServiceUrls();
            }
        }

        /// <summary>
        /// Gets or sets the Usera Agent for the Akismet Client.  
        /// Do not confuse this with the user agent for the comment 
        /// being checked.
        /// </summary>
        /// <value>The API key.</value>
        public string UserAgent
        {
            get { return _userAgent ?? BuildUserAgent("Subtext", Version); }
            set { _userAgent = value; }
        }

        /// <summary>
        /// Gets or sets the timeout in milliseconds for the http request to Akismet. 
        /// By default 5000 (5 seconds).
        /// </summary>
        /// <value>The timeout.</value>
        public int Timeout { get; set; }

        /// <summary>
        /// Gets or sets the root URL to the blog.
        /// </summary>
        /// <value>The blog URL.</value>
        public Uri BlogUrl { get; set; }

        /// <summary>
        /// Gets or sets the proxy to use.
        /// </summary>
        /// <value>The proxy.</value>
        public IWebProxy Proxy { get; set; }

        void SetServiceUrls()
        {
            _submitHamUrl = new Uri(String.Format(CultureInfo.InvariantCulture, SubmitHamUrlFormat, _apiKey));
            _submitSpamUrl = new Uri(String.Format(CultureInfo.InvariantCulture, SubmitSpamUrlFormat, _apiKey));
            _checkUrl = new Uri(String.Format(CultureInfo.InvariantCulture, CheckUrlFormat, _apiKey));
        }

        /// <summary>
        /// Helper method for building a user agent string in the format 
        /// preferred by Akismet.
        /// </summary>
        /// <param name="applicationName">Name of the application.</param>
        /// <param name="appVersion">The version of the app.</param>
        /// <returns></returns>
        public static string BuildUserAgent(string applicationName, string appVersion)
        {
            return string.Format(CultureInfo.InvariantCulture, "{0}/{1} | Akismet/1.11", applicationName, appVersion);
        }

        /// <summary>
        /// Verifies the API key.  You really only need to
        /// call this once, perhaps at startup.
        /// </summary>
        /// <returns></returns>
        /// <exception type="Sytsem.Web.WebException">If it cannot make a request of Akismet.</exception>
        public bool VerifyApiKey()
        {
            string parameters = "key=" + HttpUtility.UrlEncode(ApiKey) + "&blog=" +
                                HttpUtility.UrlEncode(BlogUrl.ToString());
            string result = _httpClient.PostRequest(VerifyUrl, UserAgent, Timeout, parameters, Proxy);

            if(String.IsNullOrEmpty(result))
            {
                throw new InvalidResponseException(Resources.InvalidResponse_EmptyResponse);
            }

            return String.Equals("valid", result, StringComparison.OrdinalIgnoreCase);
        }

        /// <summary>
        /// Checks the comment and returns true if it is spam, otherwise false.
        /// </summary>
        /// <param name="comment"></param>
        /// <returns></returns>
        public bool CheckCommentForSpam(IComment comment)
        {
            if(comment == null)
            {
                throw new ArgumentNullException("comment");
            }
            string result = SubmitComment(comment, _checkUrl);

            if(String.IsNullOrEmpty(result))
            {
                throw new InvalidResponseException(Resources.InvalidResponse_EmptyResponse);
            }

            if(result != "true" && result != "false")
            {
                throw new InvalidResponseException(string.Format(CultureInfo.InvariantCulture,
                                                                 Resources.InvalidResponse_PossiblyBadApiKey, result));
            }

            return bool.Parse(result);
        }

        /// <summary>
        /// Submits a comment to Akismet that should have been 
        /// flagged as SPAM, but was not flagged by Akismet.
        /// </summary>
        /// <param name="comment"></param>
        /// <returns></returns>
        public virtual void SubmitSpam(IComment comment)
        {
            SubmitComment(comment, _submitSpamUrl);
        }

        /// <summary>
        /// Submits a comment to Akismet that should not have been 
        /// flagged as SPAM (a false positive).
        /// </summary>
        /// <param name="comment"></param>
        /// <returns></returns>
        public void SubmitHam(IComment comment)
        {
            SubmitComment(comment, _submitHamUrl);
        }

        [SuppressMessage("Microsoft.Globalization", "CA1308:NormalizeStringsToUppercase")]
        string SubmitComment(IComment comment, Uri url)
        {
            //Not too many concatenations.  Might not need a string builder.
            string parameters = "blog=" + HttpUtility.UrlEncode(BlogUrl.ToString())
                                + "&user_ip=" + comment.IPAddress
                                + "&user_agent=" + HttpUtility.UrlEncode(comment.UserAgent);

            if(!String.IsNullOrEmpty(comment.Referrer))
            {
                parameters += "&referer=" + HttpUtility.UrlEncode(comment.Referrer);
            }

            if(comment.Permalink != null)
            {
                parameters += "&permalink=" + HttpUtility.UrlEncode(comment.Permalink.ToString());
            }

            if(!String.IsNullOrEmpty(comment.CommentType))
            {
                parameters += "&comment_type=" + HttpUtility.UrlEncode(comment.CommentType);
            }

            if(!String.IsNullOrEmpty(comment.Author))
            {
                parameters += "&comment_author=" + HttpUtility.UrlEncode(comment.Author);
            }

            if(!String.IsNullOrEmpty(comment.AuthorEmail))
            {
                parameters += "&comment_author_email=" + HttpUtility.UrlEncode(comment.AuthorEmail);
            }

            if(comment.AuthorUrl != null)
            {
                parameters += "&comment_author_url=" + HttpUtility.UrlEncode(comment.AuthorUrl.ToString());
            }

            if(!String.IsNullOrEmpty(comment.Content))
            {
                parameters += "&comment_content=" + HttpUtility.UrlEncode(comment.Content);
            }

            if(comment.ServerEnvironmentVariables != null)
            {
                foreach(string key in comment.ServerEnvironmentVariables)
                {
                    parameters += "&" + key + "=" + HttpUtility.UrlEncode(comment.ServerEnvironmentVariables[key]);
                }
            }

            return _httpClient.PostRequest(url, UserAgent, Timeout, parameters).ToLowerInvariant();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Specialized;
using System.Net;

namespace Subtext.Akismet
{
    public class Comment : IComment
    {
        NameValueCollection _serverEnvironmentVariables;

        /// <summary>
        /// Initializes a new instance of the <see cref="Comment"/> class.
        /// </summary>
        /// <param name="authorIpAddress">The author IP address.</param>
        /// <param name="authorUserAgent">The author user agent.</param>
        public Comment(IPAddress authorIpAddress, string authorUserAgent)
        {
            IPAddress = authorIpAddress;
            UserAgent = authorUserAgent;
        }

        /// <summary>
        /// The name submitted with the comment.
        /// </summary>
        public string Author { get; set; }

        /// <summary>
        /// The email submitted with the comment.
        /// </summary>
        public string AuthorEmail { get; set; }

        /// <summary>
        /// The url submitted if provided.
        /// </summary>
        public Uri AuthorUrl { get; set; }

        /// <summary>
        /// Content of the comment
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// The HTTP_REFERER header value of the 
        /// originating comment.
        /// </summary>
        public string Referrer { get; set; }

        /// <summary>
        /// Permanent location of the entry the comment was 
        /// submitted to.
        /// </summary>
        public Uri Permalink { get; set; }

        /// <summary>
        /// User agent of the requester. (Required)
        /// </summary>
        public string UserAgent { get; private set; }

        /// <summary>
        /// May be one of the following: {blank}, "comment", "trackback", "pingback", or a made-up value 
        /// like "registration".
        /// </summary>
        public string CommentType { get; set; }

        /// <summary>
        /// IPAddress of the submitter
        /// </summary>
        public IPAddress IPAddress { get; private set; }

        /// <summary>
        /// Optional collection of various server environment variables. 
        /// </summary>
        public NameValueCollection ServerEnvironmentVariables
        {
            get
            {
                _serverEnvironmentVariables = _serverEnvironmentVariables ?? new NameValueCollection();
                return _serverEnvironmentVariables;
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using System.IO;
using System.Net;
using System.Text;
using Subtext.Framework.Properties;

namespace Subtext.Akismet
{
    /// <summary>
    /// Class used to make the actual HTTP requests.
    /// </summary>
    /// <remarks>
    /// Yeah, I know you're thinking this is overkill, but it makes it 
    /// easier to write tests to have this layer of abstraction from the 
    /// underlying Http request.
    /// </remarks>
    public class HttpClient
    {
        /// <summary>
        /// Posts the request and returns a text response.  
        /// This is all that is needed for Akismet.
        /// </summary>
        /// <param name="url">The URL.</param>
        /// <param name="userAgent">The user agent.</param>
        /// <param name="timeout">The timeout.</param>
        /// <param name="formParameters">The properly formatted parameters.</param>
        /// <returns></returns>
        public virtual string PostRequest(Uri url, string userAgent, int timeout, string formParameters)
        {
            return PostRequest(url, userAgent, timeout, formParameters, null);
        }

        /// <summary>
        /// Posts the request.
        /// </summary>
        /// <param name="url">The URL.</param>
        /// <param name="userAgent">The user agent.</param>
        /// <param name="timeout">The timeout.</param>
        /// <param name="formParameters">The form parameters.</param>
        /// <param name="proxy">The proxy.</param>
        /// <returns></returns>
        public virtual string PostRequest(Uri url, string userAgent, int timeout, string formParameters, IWebProxy proxy)
        {
            ServicePointManager.Expect100Continue = false;
            var request = WebRequest.Create(url) as HttpWebRequest;

            if(proxy != null)
            {
                request.Proxy = proxy;
            }

            if(null != request)
            {
                request.UserAgent = userAgent;
                request.Timeout = timeout;
                request.Method = "POST";
                request.ContentLength = formParameters.Length;
                request.ContentType = "application/x-www-form-urlencoded; charset=utf-8";
                request.KeepAlive = true;

                using(var myWriter = new StreamWriter(request.GetRequestStream()))
                {
                    myWriter.Write(formParameters);
                }
            }

            var response = (HttpWebResponse)request.GetResponse();
            if(response.StatusCode < HttpStatusCode.OK && response.StatusCode >= HttpStatusCode.Ambiguous)
            {
                throw new InvalidResponseException(
                    string.Format(CultureInfo.InvariantCulture, Resources.InvalidResponse_ServiceUnableToHandleRequest,
                                  response.StatusCode), response.StatusCode);
            }

            string responseText;
            using(var reader = new StreamReader(response.GetResponseStream(), Encoding.ASCII))
                //They only return "true" or "false"
            {
                responseText = reader.ReadToEnd();
            }

            return responseText;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Specialized;
using System.Diagnostics.CodeAnalysis;
using System.Net;

namespace Subtext.Akismet
{
    /// <summary>
    /// Defines the base information about a comment submitted to 
    /// Akismet.
    /// </summary>
    public interface IComment
    {
        /// <summary>
        /// The name submitted with the comment.
        /// </summary>
        string Author { get; }

        /// <summary>
        /// The email submitted with the comment.
        /// </summary>
        string AuthorEmail { get; }

        /// <summary>
        /// The url submitted if provided.
        /// </summary>
        Uri AuthorUrl { get; }

        /// <summary>
        /// Content of the comment
        /// </summary>
        string Content { get; }

        /// <summary>
        /// The HTTP_REFERER header value of the 
        /// originating comment.
        /// </summary>
        string Referrer { get; }

        /// <summary>
        /// Permanent location of the entry the comment was 
        /// submitted to.
        /// </summary>
        [SuppressMessage("Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", MessageId = "Permalink")]
        Uri Permalink { get; }

        /// <summary>
        /// User agent of the requester. (Required)
        /// </summary>
        string UserAgent { get; }

        /// <summary>
        /// May be one of the following: {blank}, "comment", "trackback", "pingback", or a made-up value 
        /// like "registration".
        /// </summary>
        string CommentType { get; }

        /// <summary>
        /// IPAddress of the submitter
        /// </summary>
        IPAddress IPAddress { get; }

        /// <summary>
        /// Optional collection of various server environment variables. 
        /// </summary>
        NameValueCollection ServerEnvironmentVariables { get; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Net;
using System.Runtime.Serialization;
using System.Security.Permissions;

namespace Subtext.Akismet
{
    /// <summary>
    /// Exception thrown when a response other than 200 is returned.
    /// </summary>
    /// <remarks>
    /// This exception does not have any custom properties, 
    /// thus it does not implement ISerializable.
    /// </remarks>
    [Serializable]
    public sealed class InvalidResponseException : Exception
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="InvalidResponseException"/> class.
        /// </summary>
        public InvalidResponseException()
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="InvalidResponseException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        public InvalidResponseException(string message) : base(message)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="InvalidResponseException"/> class.
        /// </summary>
        /// <param name="message">The message.</param>
        /// <param name="innerException">The inner exception.</param>
        public InvalidResponseException(string message, Exception innerException) : base(message, innerException)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="InvalidResponseException"/> class.
        /// </summary>
        public InvalidResponseException(string message, HttpStatusCode status) : base(message)
        {
            HttpStatus = status;
        }

        private InvalidResponseException(SerializationInfo info, StreamingContext context) : base(info, context)
        {
            HttpStatus = (HttpStatusCode)info.GetInt32("HttpStatus");
        }

        /// <summary>
        /// Gets the HTTP status returned by the service.
        /// </summary>
        /// <value>The HTTP status.</value>
        public HttpStatusCode HttpStatus { get; private set; }

        [SecurityPermission(SecurityAction.LinkDemand, Flags = SecurityPermissionFlag.SerializationFormatter)]
        public override void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("HttpStatus", (int)HttpStatus);
            base.GetObjectData(info, context);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using System.Net;
using log4net;
using Subtext.Akismet;
using Subtext.Framework.Components;
using Subtext.Framework.Logging;
using Subtext.Framework.Routing;
using Subtext.Framework.Web;

namespace Subtext.Framework.Services
{
    [Serializable]
    public class AkismetSpamService : ICommentSpamService
    {
        private readonly static ILog Log = new Log();
        readonly AkismetClient _akismet;
        readonly Blog _blog;
        readonly UrlHelper _urlHelper;

        /// <summary>
        /// Initializes a new instance of the <see cref="AkismetSpamService"/> class.
        /// </summary>
        /// <param name="apiKey">The API key.</param>
        /// <param name="blog">The blog.</param>
        public AkismetSpamService(string apiKey, Blog blog) : this(apiKey, blog, null, null)
        {
        }

        public AkismetSpamService(string apiKey, Blog blog, AkismetClient akismetClient, UrlHelper urlHelper)
        {
            _blog = blog;
            _akismet = akismetClient ?? new AkismetClient(apiKey, urlHelper.BlogUrl().ToFullyQualifiedUrl(blog));
            IWebProxy proxy = HttpHelper.GetProxy();
            if(proxy != null)
            {
                _akismet.Proxy = proxy;
            }
            _urlHelper = urlHelper ?? new UrlHelper(null, null);
        }

        /// <summary>
        /// Examines the item and determines whether or not it is spam.
        /// </summary>
        /// <param name="feedback"></param>
        /// <returns></returns>
        public bool IsSpam(FeedbackItem feedback)
        {
            Comment comment = ConvertToAkismetItem(feedback);

            try
            {
                if(_akismet.CheckCommentForSpam(comment))
                {
                    _akismet.SubmitSpam(comment);
                    return true;
                }
            }
            catch(InvalidResponseException e)
            {
                Log.Error(e.Message, e);
            }
            return false;
        }

        /// <summary>
        /// Submits the item to the service as a false positive. 
        /// Something that should not have been marked as spam.
        /// </summary>
        /// <param name="feedback"></param>
        public void SubmitGoodFeedback(FeedbackItem feedback)
        {
            Comment comment = ConvertToAkismetItem(feedback);
            _akismet.SubmitHam(comment);
        }

        /// <summary>
        /// Submits the item to the service as a piece of SPAM that got through 
        /// the filter. Something that should've been marked as SPAM.
        /// </summary>
        /// <param name="feedback"></param>
        public void SubmitSpam(FeedbackItem feedback)
        {
            Comment comment = ConvertToAkismetItem(feedback);
            _akismet.SubmitSpam(comment);
        }

        /// <summary>
        /// Verifies the api key.
        /// </summary>
        /// <returns></returns>
        public bool VerifyApiKey()
        {
            try
            {
                return _akismet.VerifyApiKey();
            }
            catch(WebException e)
            {
                Log.Error("Error occured while verifying Akismet.", e);
                return false;
            }
        }

        public Comment ConvertToAkismetItem(FeedbackItem feedback)
        {
            var comment = new Comment(feedback.IpAddress, feedback.UserAgent) {Author = feedback.Author ?? string.Empty, AuthorEmail = feedback.Email};
            if(feedback.SourceUrl != null)
            {
                comment.AuthorUrl = feedback.SourceUrl;
            }
            comment.Content = feedback.Body;
            comment.Referrer = feedback.Referrer;

            var feedbackUrl = _urlHelper.FeedbackUrl(feedback);
            if(feedbackUrl != null)
            {
                Uri permalink = feedbackUrl.ToFullyQualifiedUrl(_blog);
                if(permalink != null)
                {
                    comment.Permalink = permalink;
                }
            }

            comment.CommentType = feedback.FeedbackType.ToString().ToLower(CultureInfo.InvariantCulture);
            return comment;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;

namespace Subtext.Framework.Services
{
    public class BlogLookupResult
    {
        public BlogLookupResult(Blog blog, Uri alternateUrl)
        {
            Blog = blog;
            AlternateUrl = alternateUrl;
        }

        /// <summary>
        /// The found blog. Null if not found.
        /// </summary>
        public Blog Blog { get; private set; }

        /// <summary>
        /// No blog was found, redirect to this alternate URL instead.
        /// </summary>
        public Uri AlternateUrl { get; private set; }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Linq;
using Subtext.Extensibility.Interfaces;
using Subtext.Framework.Configuration;
using Subtext.Framework.Providers;
using Subtext.Framework.Web.HttpModules;

namespace Subtext.Framework.Services
{
    public class BlogLookupService : IBlogLookupService
    {
        HostInfo _host;

        public BlogLookupService(ObjectProvider repository, HostInfo host)
        {
            Repository = repository;
            _host = host;
        }

        protected ObjectProvider Repository { get; private set; }

        protected HostInfo Host
        {
            get
            {
                if(_host == null)
                {
                    _host = HostInfo.LoadHost(true);
                }
                return _host;
            }
        }

        public BlogLookupResult Lookup(BlogRequest blogRequest)
        {
            if(Host == null)
            {
                return new BlogLookupResult(null, null);
            }

            string host = blogRequest.Host;
            Blog blog = Repository.GetBlog(host, blogRequest.Subfolder);
            if(blog != null)
            {
                if(!String.Equals(host, blog.Host, StringComparison.OrdinalIgnoreCase)
                   || !String.Equals(blogRequest.Subfolder, blog.Subfolder, StringComparison.OrdinalIgnoreCase))
                {
                    UriBuilder alternateUrl = ReplaceHost(blogRequest.RawUrl, blog.Host);
                    alternateUrl = ReplaceSubfolder(alternateUrl, blogRequest, blog.Subfolder);
                    return new BlogLookupResult(null, alternateUrl.Uri);
                }
                return new BlogLookupResult(blog, null);
            }

            IPagedCollection<Blog> pagedBlogs = Repository.GetPagedBlogs(null, 0, 10, ConfigurationFlags.None);
            int totalBlogCount = pagedBlogs.MaxItems;
            if(Host.BlogAggregationEnabled && totalBlogCount > 0)
            {
                if(!String.IsNullOrEmpty(blogRequest.Subfolder))
                {
                    return null;
                }
                return new BlogLookupResult(Host.AggregateBlog, null);
            }

            if(totalBlogCount == 1)
            {
                Blog onlyBlog = pagedBlogs.First();
                if(onlyBlog.Host == blogRequest.Host)
                {
                    Uri onlyBlogUrl =
                        ReplaceSubfolder(new UriBuilder(blogRequest.RawUrl), blogRequest, onlyBlog.Subfolder).Uri;
                    return new BlogLookupResult(null, onlyBlogUrl);
                }

                //Extra special case to deal with a common deployment problem where dev uses "localhost" on 
                //dev machine. But deploys to real domain.
                if(OnlyBlogIsLocalHostNotCurrentHost(host, onlyBlog))
                {
                    onlyBlog.Host = host;
                    Repository.UpdateBlog(onlyBlog);

                    if(onlyBlog.Subfolder != blogRequest.Subfolder)
                    {
                        Uri onlyBlogUrl =
                            ReplaceSubfolder(new UriBuilder(blogRequest.RawUrl), blogRequest, onlyBlog.Subfolder).Uri;
                        return new BlogLookupResult(null, onlyBlogUrl);
                    }
                    return new BlogLookupResult(onlyBlog, null);
                }

                //TODO: What about case where you've pulled the prod blog down to localhost?
            }

            return null;
        }

        //private bool CurrentRequestIsForBlogAlias(BlogRequest blogRequest)
        //{
        //    !String.Equals(blogRequest.Host, blog.Host, StringComparison.OrdinalIgnoreCase)
        //           || !String.Equals(blogRequest.Subfolder, blog.Subfolder, StringComparison.OrdinalIgnoreCase)
        //}

        private static bool OnlyBlogIsLocalHostNotCurrentHost(string host, Blog onlyBlog)
        {
            return (
                       !String.Equals("localhost", host, StringComparison.OrdinalIgnoreCase)
                       && String.Equals("localhost", onlyBlog.Host, StringComparison.OrdinalIgnoreCase)
                   )
                   || (
                          !String.Equals("127.0.0.1", host, StringComparison.OrdinalIgnoreCase)
                          && String.Equals("127.0.0.1", onlyBlog.Host, StringComparison.OrdinalIgnoreCase)
                      );
        }

        private static UriBuilder ReplaceHost(Uri originalUrl, string newHost)
        {
            var builder = new UriBuilder(originalUrl) {Host = newHost};
            return builder;
        }

        private static UriBuilder ReplaceSubfolder(UriBuilder originalUrl, BlogRequest blogRequest, string newSubfolder)
        {
            if(!String.Equals(blogRequest.Subfolder, newSubfolder, StringComparison.OrdinalIgnoreCase))
            {
                string appPath = blogRequest.ApplicationPath;
                if(!appPath.EndsWith("/"))
                {
                    appPath += "/";
                }

                int indexAfterAppPath = appPath.Length;
                if(!String.IsNullOrEmpty(blogRequest.Subfolder))
                {
                    originalUrl.Path = originalUrl.Path.Remove(indexAfterAppPath, blogRequest.Subfolder.Length + 1);
                }
                if(!String.IsNullOrEmpty(newSubfolder))
                {
                    originalUrl.Path = originalUrl.Path.Substring(0, indexAfterAppPath) + newSubfolder + "/" +
                                       originalUrl.Path.Substring(indexAfterAppPath);
                }
            }
            return originalUrl;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Globalization;
using System.Web;
using System.Web.Mobile;
using Subtext.Framework.Configuration;

namespace Subtext.Framework.Services
{
    public class BrowserDetectionService : IHttpHandler
    {
        private static int BlogId
        {
            get
            {
                if(Config.CurrentBlog != null)
                {
                    return Config.CurrentBlog.Id;
                }
                return 0;
            }
        }

        public bool IsReusable
        {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context)
        {
            string mobileQuery = context.Request.QueryString["mobile"];
            bool isMobile;
            if(!bool.TryParse(mobileQuery, out isMobile))
            {
                isMobile = false;
            }
            SetMobile(isMobile);

            string returnUrl = context.Request.QueryString["returnUrl"] ?? string.Empty;
            if(returnUrl.Length == 0)
            {
                returnUrl = "~/";
            }

            //Security so people can't use this for phishing.
            if(returnUrl.StartsWith("http:")
               || returnUrl.StartsWith("https:")
               || (!returnUrl.StartsWith("/") && !returnUrl.StartsWith("~/")))
            {
                returnUrl = "~/";
            }
            context.Response.Redirect(returnUrl);
        }

        public BrowserInfo DetectBrowserCapabilities(HttpRequestBase request)
        {
            bool? isMobile = UserSpecifiedMobile();
            if(isMobile == null)
            {
                var mobileCaps = request.Browser;
                isMobile = mobileCaps != null && mobileCaps.IsMobileDevice;
            }
            return new BrowserInfo(isMobile.Value);
        }

        static bool? UserSpecifiedMobile()
        {
            HttpCookie cookie = HttpContext.Current.Request.Cookies.Get("MobileDeviceInfo_" + BlogId);
            if(cookie == null)
            {
                return null;
            }
            return (cookie.Value == "True");
        }

        public void SetMobile(bool isMobile)
        {
            var cookie = new HttpCookie("MobileDeviceInfo_" + BlogId, isMobile.ToString(CultureInfo.InvariantCulture))
            {Value = isMobile.ToString(CultureInfo.InvariantCulture)};
            HttpContext.Current.Response.Cookies.Add(cookie);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Services
{
    public class BrowserInfo
    {
        readonly bool _mobile;

        public BrowserInfo(bool mobile)
        {
            _mobile = mobile;
        }

        public bool Mobile
        {
            get { return _mobile; }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Web;
using Subtext.Framework.Components;
using Subtext.Framework.Data;
using Subtext.Framework.Providers;
using Subtext.Framework.Text;
using Subtext.Framework.Web;

namespace Subtext.Framework.Services
{
    public class CommentService : ICommentService
    {
        public CommentService(ISubtextContext context, ICommentFilter filter)
        {
            SubtextContext = context;
            Filter = filter;
        }

        protected ISubtextContext SubtextContext { get; private set; }

        protected ObjectProvider Repository
        {
            get { return SubtextContext.Repository; }
        }

        protected ICommentFilter Filter { get; private set; }

        public int Create(FeedbackItem comment, bool runFilters)
        {
            Entry entry = Cacher.GetEntry(comment.EntryId, SubtextContext);
            if(entry != null && entry.CommentingClosed)
            {
                return NullValue.NullInt32;
            }

            ISubtextContext context = SubtextContext;
            HttpContextBase httpContext = context.HttpContext;

            if(httpContext != null && httpContext.Request != null)
            {
                comment.UserAgent = httpContext.Request.UserAgent;
                comment.IpAddress = HttpHelper.GetUserIpAddress(httpContext);
            }

            if(runFilters)
            {
                comment.FlaggedAsSpam = true; //We're going to start with this assumption.
            }
            comment.Author = HtmlHelper.SafeFormat(comment.Author, context.HttpContext.Server);
            comment.Body = HtmlHelper.ConvertUrlsToHyperLinks(HtmlHelper.ConvertToAllowedHtml(comment.Body));
            comment.Title = HtmlHelper.SafeFormat(comment.Title, context.HttpContext.Server);

            // If we are creating this feedback item as part of an import, we want to 
            // be sure to use the item's datetime, and not set it to the current time.
            if(NullValue.NullDateTime.Equals(comment.DateCreated))
            {
                comment.DateCreated = context.Blog.TimeZone.Now;
                comment.DateModified = comment.DateCreated;
            }
            else if(NullValue.NullDateTime.Equals(comment.DateModified))
            {
                comment.DateModified = comment.DateCreated;
            }

            comment.Entry = entry;

            if(runFilters)
            {
                OnBeforeCreate(comment);
            }
            
            comment.Id = Repository.Create(comment);

            if(runFilters)
            {
                OnAfterCreate(comment);
            }

            return comment.Id;
        }

        protected virtual void OnBeforeCreate(FeedbackItem feedback)
        {
            if(Filter != null)
            {
                Filter.FilterBeforePersist(feedback);
            }
        }

        protected virtual void OnAfterCreate(FeedbackItem feedback)
        {
            if(Filter != null)
            {
                Filter.FilterAfterPersist(feedback);
            }
        }

        public FeedbackItem Get(int id)
        {
            return Repository.GetFeedback(id);
        }

        public void UpdateStatus(FeedbackItem comment, FeedbackStatusFlag status)
        {
            comment.Status = status;
            Repository.Update(comment);
        }

        public void Destroy(int id)
        {
            Repository.DestroyFeedback(id);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.ObjectModel;
using System.Linq;

namespace Subtext.Framework.Services
{
    public class CompositeTextTransformation : Collection<ITextTransformation>, ITextTransformation
    {
        public string Transform(string original)
        {
            return this.Aggregate(original,
                                  (resultFromLastTransform, transformation) =>
                                  transformation.Transform(resultFromLastTransform));
        }

        /// <summary>
        /// Removes the text transformation of the given type.
        /// </summary>
        /// <typeparam name="TTextTransformation"></typeparam>
        public void Remove<TTextTransformation>() where TTextTransformation : ITextTransformation
        {
            foreach(ITextTransformation textTransform in this)
            {
                if(textTransform.GetType() == typeof(TTextTransformation))
                {
                    Remove(textTransform);
                    return;
                }
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using Subtext.Extensibility;
using Subtext.Extensibility.Providers;
using Subtext.Framework.Components;
using Subtext.Framework.Properties;
using Subtext.Framework.Routing;
using Subtext.Framework.Security;

namespace Subtext.Framework.Email
{
    public class EmailService : IEmailService
    {
        public EmailService(EmailProvider provider, ITemplateEngine templateEngine, ISubtextContext context)
        {
            EmailProvider = provider;
            TemplateEngine = templateEngine;
            Url = context.UrlHelper;
            Blog = context.Blog;
            Context = context;
        }

        protected EmailProvider EmailProvider { get; private set; }

        protected ITemplateEngine TemplateEngine { get; private set; }

        protected Blog Blog { get; private set; }

        protected UrlHelper Url { get; private set; }

        protected ISubtextContext Context { get; private set; }

        public void EmailCommentToBlogAuthor(FeedbackItem comment)
        {
            if(String.IsNullOrEmpty(Blog.Email)
               || comment.FeedbackType == FeedbackType.PingTrack
               || Context.User.IsAdministrator())
            {
                return;
            }

            string fromEmail = comment.Email;
            if(String.IsNullOrEmpty(fromEmail))
            {
                fromEmail = null;
            }

            var commentForTemplate = new
            {
                blog = Blog,
                comment = new
                {
                    author = comment.Author,
                    title = comment.Title,
                    source = Url.FeedbackUrl(comment).ToFullyQualifiedUrl(Blog),
                    email = fromEmail ?? "none given",
                    authorUrl = comment.SourceUrl,
                    ip = comment.IpAddress,
                    // we're sending plain text email by default, but body includes <br />s for crlf
                    body =
                        (comment.Body ?? string.Empty).Replace("<br />", Environment.NewLine).Replace("&lt;br /&gt;",
                                                                                                      Environment.
                                                                                                          NewLine)
                },
                spamFlag = comment.FlaggedAsSpam ? "Spam Flagged " : ""
            };

            ITextTemplate template = TemplateEngine.GetTemplate("CommentReceived");
            string message = template.Format(commentForTemplate);
            string subject = String.Format(CultureInfo.InvariantCulture, Resources.Email_CommentVia, comment.Title,
                                           Blog.Title);
            if(comment.FlaggedAsSpam)
            {
                subject = "[SPAM Flagged] " + subject;
            }
            string from = EmailProvider.UseCommentersEmailAsFromAddress
                              ? (fromEmail ?? EmailProvider.AdminEmail)
                              : EmailProvider.AdminEmail;

            EmailProvider.Send(Blog.Email, from, subject, message);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Text;
using Subtext.Framework.Util;

namespace Subtext.Framework.Email
{
    public class EmbeddedTemplateEngine : ITemplateEngine
    {
        public ITextTemplate GetTemplate(string templateName)
        {
            string resourceName = "Subtext.Framework.Services.Email.Templates." + templateName + ".template";
            string templateText = ResourceHelper.UnpackEmbeddedResource(resourceName, Encoding.UTF8);
            return new NamedFormatTextTemplate(templateText);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Components;

namespace Subtext.Framework.Email
{
    public interface IEmailService
    {
        void EmailCommentToBlogAuthor(FeedbackItem comment);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Email
{
    public interface ITemplateEngine
    {
        ITextTemplate GetTemplate(string templateName);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Email
{
    public interface ITextTemplate
    {
        string Format(object data);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Text;

namespace Subtext.Framework.Email
{
    public class NamedFormatTextTemplate : ITextTemplate
    {
        public NamedFormatTextTemplate(string template)
        {
            Template = template;
        }

        public string Template { get; private set; }

        #region ITextTemplate Members

        public string Format(object data)
        {
            return Template.NamedFormat(data);
        }

        #endregion

        public override string ToString()
        {
            return Template;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Net;
using System.Net.Mail;
using System.Text;
using log4net;
using Subtext.Extensibility.Providers;
using Subtext.Framework.Logging;

namespace Subtext.Framework.Email
{
    /// <summary>
    /// Default implementation of the <see cref="EmailProvider"/>.  This uses 
    /// the new (introduced in .NET 2.0) System.Net.SmtpClient class which uses SMTP.
    /// </summary>
    public class SystemMailProvider : EmailProvider
    {
        private readonly static ILog Log = new Log();

        /// <summary>
        /// Sends an email.
        /// </summary>
        public override void Send(string to, string from, string subject, string message)
        {
            SendAsync(to, from, subject, message);
        }

        private void SendAsync(string toStr, string fromStr, string subject, string message)
        {
            try
            {
                var from = new MailAddress(fromStr);
                var to = new MailAddress(toStr);

                var em = new MailMessage(from, to) {BodyEncoding = Encoding.UTF8, Subject = subject, Body = message, ReplyTo = from};

                var client = new SmtpClient(SmtpServer) {Port = Port, EnableSsl = SslEnabled};

                if(UserName != null && Password != null)
                {
                    client.UseDefaultCredentials = false;
                    client.Credentials = new NetworkCredential(UserName, Password);
                }

                client.Send(em);
            }
            catch(Exception e)
            {
                Log.Error("Could not send email.", e);
                //Swallow as this was on an async thread.
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Globalization;
using System.Text.RegularExpressions;

namespace Subtext.Framework.Emoticons
{
    public class Emoticon
    {
        private readonly Regex _regex;

        public Emoticon(string emoticonText, string imageTag)
        {
            EmoticonText = emoticonText;
            ImageTag = imageTag;
            string regexText = Regex.Escape(emoticonText);
            _regex = new Regex(regexText, RegexOptions.IgnoreCase | RegexOptions.Compiled | RegexOptions.Multiline);
        }

        public string EmoticonText { get; private set; }

        public string ImageTag { get; set; }

        public string Replace(string text, string appRootUrl)
        {
            return _regex.Replace(text, string.Format(CultureInfo.InvariantCulture, ImageTag, appRootUrl));
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace Subtext.Framework.Emoticons
{
    public class EmoticonsFileSource : IEmoticonsSource, IDisposable
    {
        readonly string _path;
        readonly StreamReader _reader;

        private readonly ISubtextContext _subtextContext;

        public EmoticonsFileSource(ISubtextContext context)
        {
            _subtextContext = context;
        }

        public EmoticonsFileSource(string path)
        {
            _path = path ?? _subtextContext.RequestContext.HttpContext.Request.MapPath("~/emoticons.txt");
            if(!String.IsNullOrEmpty(_path))
            {
                _reader = File.OpenText(_path);
            }
        }

        public EmoticonsFileSource(StreamReader reader)
        {
            _reader = reader ?? File.OpenText(_path);
        }

        #region IDisposable Members

        public void Dispose()
        {
            if(_reader != null)
            {
                _reader.Dispose();
            }
        }

        #endregion

        #region IEmoticonsSource Members

        public IEnumerable<Emoticon> GetEmoticons()
        {
            if(_reader == null)
            {
                return new List<Emoticon>();
            }
            return GetEnumerable().ToList();
        }

        #endregion

        private IEnumerable<Emoticon> GetEnumerable()
        {
            string emoticonText = _reader.ReadLine();
            while(emoticonText != null)
            {
                string imageTag = _reader.ReadLine();
                yield return new Emoticon(emoticonText, imageTag);
                emoticonText = _reader.ReadLine();
            }
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;

namespace Subtext.Framework.Emoticons
{
    public interface IEmoticonsSource
    {
        IEnumerable<Emoticon> GetEmoticons();
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Linq;
using Ninject;
using Subtext.Framework.Services;

namespace Subtext.Framework.Emoticons
{
    /// <summary>
    /// Converts emoticons to img tags.
    /// </summary>
    public class EmoticonsTransformation : ITextTransformation
    {
        readonly ISubtextContext _subtextContext;

        string _appRootUrl;

        [Inject]
        public EmoticonsTransformation(ISubtextContext context)
            : this(new EmoticonsFileSource(context), null)
        {
            _subtextContext = context;
        }

        public EmoticonsTransformation(IEmoticonsSource emoticonsSource, string appRootUrl)
        {
            EmoticonsTable = emoticonsSource.GetEmoticons();
            _appRootUrl = appRootUrl;
        }

        protected IEnumerable<Emoticon> EmoticonsTable { get; private set; }

        public string Transform(string original)
        {
            if(_appRootUrl == null && _subtextContext != null && _subtextContext.UrlHelper != null)
            {
                //TODO: Temporary Hack.
                _appRootUrl = _subtextContext.UrlHelper.AppRoot();
            }
            return EmoticonsTable.Aggregate(original, (input, transform) => transform.Replace(input, _appRootUrl));
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Services
{
    public class EmptyTextTransformation : ITextTransformation
    {
        public static readonly ITextTransformation Instance = new EmptyTextTransformation();

        private EmptyTextTransformation()
        {
        }

        public string Transform(string original)
        {
            return original;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Data.Common;
using System.Linq;
using Subtext.Configuration;
using Subtext.Extensibility;
using Subtext.Framework.Components;
using Subtext.Framework.Configuration;
using Subtext.Framework.Exceptions;
using Subtext.Framework.Properties;
using Subtext.Framework.Services.SearchEngine;
using Subtext.Framework.Text;

namespace Subtext.Framework.Services
{
    public class EntryPublisher : IEntryPublisher
    {
        public EntryPublisher(ISubtextContext context, ITextTransformation transformation, ISlugGenerator slugGenerator,
            IIndexingService indexingService)
        {
            if(context == null)
            {
                throw new ArgumentNullException("context");
            }
            if (indexingService == null)
            {
                throw new ArgumentNullException("indexingService");
            }
            SubtextContext = context;
            Transformation = transformation ?? EmptyTextTransformation.Instance;
            SlugGenerator = slugGenerator ?? new SlugGenerator(FriendlyUrlSettings.Settings, context.Repository);
            IndexingService = indexingService;
        }

        public ITextTransformation Transformation { get; private set; }

        public ISubtextContext SubtextContext { get; private set; }

        public ISlugGenerator SlugGenerator { get; private set; }

        public IIndexingService IndexingService { get; private set; }

        #region IEntryPublisher Members

        public int Publish(Entry entry)
        {
            if(entry == null)
            {
                throw new ArgumentNullException("entry");
            }

            if(entry.PostType == PostType.None)
            {
                throw new ArgumentException(Resources.InvalidOperation_PostTypeIsNone, "entry");
            }

            entry.Body = Transformation.Transform(entry.Body);

            if(String.IsNullOrEmpty(entry.EntryName))
            {
                entry.EntryName = SlugGenerator.GetSlugFromTitle(entry);
            }
            if(entry.EntryName.IsNumeric())
            {
                entry.EntryName = "n_" + entry.EntryName;
            }
            if(NullValue.IsNull(entry.DateCreated))
            {
                entry.DateCreated = SubtextContext.Blog.TimeZone.Now;
            }
            if(NullValue.IsNull(entry.DateModified))
            {
                entry.DateModified = SubtextContext.Blog.TimeZone.Now;
            }
            if(entry.IsActive)
            {
                if(NullValue.IsNull(entry.DateSyndicated) && entry.IncludeInMainSyndication)
                {
                    entry.DateSyndicated = SubtextContext.Blog.TimeZone.Now;
                }
            }
            else
            {
                entry.DateSyndicated = NullValue.NullDateTime;
            }

            IEnumerable<int> categoryIds = null;
            if(entry.Categories.Count > 0)
            {
                categoryIds = GetCategoryIdsFromCategoryTitles(entry);
            }

            try
            {
                if(NullValue.IsNull(entry.Id))
                {
                    SubtextContext.Repository.Create(entry, categoryIds);
                }
                else
                {
                    SubtextContext.Repository.Update(entry, categoryIds);
                }
            }
            catch(DbException e)
            {
                if(e.Message.Contains("pick a unique EntryName"))
                {
                    throw new DuplicateEntryException(Resources.DuplicateEntryException_EntryNameAlreadyExists, e);
                }
                throw;
            }

            ValidateEntry(entry);
            IList<string> tags = entry.Body.ParseTags();
            SubtextContext.Repository.SetEntryTagList(entry.Id, tags);
            IndexingService.AddPost(entry, tags);
            return entry.Id;
        }

        #endregion

        private static void ValidateEntry(Entry e)
        {
            //TODO: The following doesn't belong here. It's verification code.
            if(!Config.Settings.AllowScriptsInPosts && HtmlHelper.HasIllegalContent(e.Body))
            {
                throw new IllegalPostCharactersException(Resources.IllegalPostCharacters);
            }

            //Never allow scripts in the title.
            if(HtmlHelper.HasIllegalContent(e.Title))
            {
                throw new IllegalPostCharactersException(Resources.IllegalPostCharacters);
            }

            if(!Config.Settings.AllowScriptsInPosts && HtmlHelper.HasIllegalContent(e.Description))
            {
                throw new IllegalPostCharactersException(Resources.IllegalPostCharacters);
            }

            //never allow scripts in the url.
            if(HtmlHelper.HasIllegalContent(e.EntryName))
            {
                throw new IllegalPostCharactersException(Resources.IllegalPostCharacters);
            }

            return;
        }

        private IEnumerable<int> GetCategoryIdsFromCategoryTitles(Entry entry)
        {
            IEnumerable<int> categoryIds = from categoryName in entry.Categories
                                           let category = SubtextContext.Repository.GetLinkCategory(categoryName, true)
                                           where category != null
                                           select category.Id;

            return categoryIds;
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Services
{
    public enum GravatarEmailFormat
    {
        Plain,
        Md5
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Specialized;
using System.Globalization;
using System.Web;
using System.Web.Security;

namespace Subtext.Framework.Services
{
    //TODO: This service is a bit hard to use. We should refactor it so it has 
    //      a bit more smarts about Subtext. Such as it can figure out the default image FQDN URL
    public class GravatarService
    {
        public GravatarService(NameValueCollection settings)
            : this(
                settings["GravatarUrlFormatString"], settings.GetEnum<GravatarEmailFormat>("GravatarEmailFormat"),
                settings.GetBoolean("GravatarEnabled"))
        {
        }

        public GravatarService(string urlFormatString, GravatarEmailFormat emailFormat, bool enabled)
        {
            UrlFormatString = urlFormatString;
            EmailFormat = emailFormat;
            Enabled = enabled;
        }

        public bool Enabled { get; private set; }

        public string UrlFormatString { get; private set; }

        public GravatarEmailFormat EmailFormat { get; private set; }

        public string GenerateUrl(string email, Uri defaultImage)
        {
            return GenerateUrl(email, defaultImage != null ? defaultImage.ToString(): string.Empty);
        }

        public string GenerateUrl(string email, string defaultImage)
        {
            if(String.IsNullOrEmpty(email))
            {
                return defaultImage ?? string.Empty;
            }
            defaultImage = defaultImage ?? "identicon";
            string emailForUrl = email.ToLowerInvariant();
            if(EmailFormat == GravatarEmailFormat.Md5)
            {
                emailForUrl = (FormsAuthentication.HashPasswordForStoringInConfigFile(emailForUrl, "md5") ?? string.Empty).ToLowerInvariant();
            }

            emailForUrl = HttpUtility.UrlEncode(emailForUrl);

            return String.Format(CultureInfo.InvariantCulture, UrlFormatString, emailForUrl, defaultImage);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Web.HttpModules;

namespace Subtext.Framework.Services
{
    public interface IBlogLookupService
    {
        BlogLookupResult Lookup(BlogRequest blogRequest);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Components;

namespace Subtext.Framework.Services
{
    public interface ICommentFilter
    {
        void FilterAfterPersist(FeedbackItem feedbackItem);
        void FilterBeforePersist(FeedbackItem feedback);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Components;

namespace Subtext.Framework.Services
{
    public interface ICommentService
    {
        FeedbackItem Get(int id);
        int Create(FeedbackItem feedback, bool runFilters);
        void UpdateStatus(FeedbackItem feedback, FeedbackStatusFlag status);
        void Destroy(int id);
    }
}using System;
using System.Linq;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;

namespace Docuverse.Identicon
{
    /// <summary>
    /// Code borrowed from http://identicon.codeplex.com/
    /// </summary>
    public class IdenticonRenderer
    {
        // Each "patch" in an Identicon is a polygon created from a list of vertices on a 5 by 5 grid.
        // Vertices are numbered from 0 to 24, starting from top-left corner of
        // the grid, moving left to right and top to bottom.
        private const int MaxSize = 128;
        private const int MinSize = 16;
        private const int PatchCells = 4;
        private const int PatchGrids = PatchCells + 1;
        private const byte PatchInverted = 2;
        private const byte PatchSymmetric = 1;
        private static readonly int[] CenterPatchTypes = new[] {0, 4, 8, 15};

        private static readonly byte[] Patch0 = new byte[] {0, 4, 24, 20, 0};
        private static readonly byte[] Patch1 = new byte[] {0, 4, 20, 0};
        private static readonly byte[] Patch10 = new byte[] {0, 2, 12, 10, 0};
        private static readonly byte[] Patch11 = new byte[] {10, 14, 22, 10};
        private static readonly byte[] Patch12 = new byte[] {20, 12, 24, 20};
        private static readonly byte[] Patch13 = new byte[] {10, 2, 12, 10};
        private static readonly byte[] Patch14 = new byte[] {0, 2, 10, 0};
        private static readonly byte[] Patch2 = new byte[] {2, 24, 20, 2};
        private static readonly byte[] Patch3 = new byte[] {2, 10, 14, 22, 2};
        private static readonly byte[] Patch4 = new byte[] {2, 14, 22, 10, 2};
        private static readonly byte[] Patch5 = new byte[] {0, 14, 24, 22, 0};
        private static readonly byte[] Patch6 = new byte[] {2, 24, 22, 13, 11, 22, 20, 2};
        private static readonly byte[] Patch7 = new byte[] {0, 14, 22, 0};
        private static readonly byte[] Patch8 = new byte[] {6, 8, 18, 16, 6};
        private static readonly byte[] Patch9 = new byte[] {4, 20, 10, 12, 2, 4};

        private static readonly byte[] PatchFlags =
            new byte[]
            {
                PatchSymmetric, 0, 0, 0, PatchSymmetric, 0, 0, 0, PatchSymmetric, 0, 0, 0, 0, 0, 0,
                (PatchSymmetric + PatchInverted)
            };

        private static readonly byte[][] PatchTypes =
            new[]
            {
                Patch0, Patch1, Patch2, Patch3, Patch4, Patch5, Patch6, Patch7, Patch8, Patch9, Patch10, Patch11, Patch12, Patch13,
                Patch14, Patch0
            };

        private int _patchOffset; // used to center patch shape at origin because shape rotation works correctly.

        private GraphicsPath[] _patchShapes;

        /// <summary>
        /// The size in pixels at which each patch will be rendered interally before they
        /// are scaled down to the requested identicon size. Default size is 20 pixels
        /// which means, for 9-block identicon, a 60x60 image will be rendered and
        /// scaled down.
        /// </summary>
        public int PatchSize
        {
            get;
            set;
        }

        private IEnumerable<GraphicsPath> CalculatePatchShapes()
        {
            _patchOffset = PatchSize / 2; // used to center patch shape at origin.
            int scale = PatchSize / PatchCells;
            foreach(var patchVertices in PatchTypes)
            {
                var patch = new GraphicsPath();
                foreach(int vertex in patchVertices)
                {
                    int xVertex = (vertex % PatchGrids * scale) - _patchOffset;
                    int yVertex = (vertex / PatchGrids * scale) - _patchOffset;
                    AddPointToGraphicsPath(patch, xVertex, yVertex);
                }
                yield return patch;
            }
        }

        /// <summary>
        /// Adds the X and Y coordinates to the current graphics path.
        /// </summary>
        /// <param name="path"> The current Graphics path</param>
        /// <param name="x">The x coordinate to be added</param>
        /// <param name="y">The y coordinate to be added</param>
        private static void AddPointToGraphicsPath(GraphicsPath path, int x, int y)
        {
            // increment by one.
            var points = new PointF[path.PointCount + 1];
            var pointTypes = new byte[path.PointCount + 1];

            if(path.PointCount == 0)
            {
                points[0] = new PointF(x, y);
                var newPath = new GraphicsPath(points, new[] {(byte)PathPointType.Start});
                path.AddPath(newPath, false);
            }
            else
            {
                path.PathPoints.CopyTo(points, 0);
                points[path.PointCount] = new Point(x, y);

                path.PathTypes.CopyTo(pointTypes, 0);
                pointTypes[path.PointCount] = (byte)PathPointType.Line;

                var tempGraphics = new GraphicsPath(points, pointTypes);
                path.Reset();
                path.AddPath(tempGraphics, false);
            }
        }

        /// <summary>
        /// Returns rendered identicon bitmap for a given identicon code.
        /// </summary>
        /// <param name="code">Identicon code</param>
        /// <param name="size">desired image size</param>
        public Bitmap Render(int code, int size)
        {
            // enforce size limits
            size = Math.Min(size, MaxSize);
            size = Math.Max(size, MinSize);

            // set patch size appropriately to avoid scaling artifacts
            if(size <= 24)
            {
                PatchSize = 16;
            }
            else if(size <= 40)
            {
                PatchSize = 20;
            }
            else if(size <= 64)
            {
                PatchSize = 32;
            }
            else if(size <= 128)
            {
                PatchSize = 48;
            }
            _patchShapes = CalculatePatchShapes().ToArray();

            // decode the code into parts:            
            // bit 0-1: middle patch type
            int centerType = CenterPatchTypes[code & 0x3];
            // bit 2: middle invert
            bool centerInvert = ((code >> 2) & 0x1) != 0;
            // bit 3-6: corner patch type
            int cornerType = (code >> 3) & 0x0f;
            // bit 7: corner invert
            bool cornerInvert = ((code >> 7) & 0x1) != 0;
            // bit 8-9: corner turns
            int cornerTurn = (code >> 8) & 0x3;
            // bit 10-13: side patch type
            int sideType = (code >> 10) & 0x0f;
            // bit 14: side invert
            bool sideInvert = ((code >> 14) & 0x1) != 0;
            // bit 15: corner turns
            int sideTurn = (code >> 15) & 0x3;
            // bit 16-20: blue color component
            int blue = (code >> 16) & 0x01f;
            // bit 21-26: green color component
            int green = (code >> 21) & 0x01f;
            // bit 27-31: red color component
            int red = (code >> 27) & 0x01f;

            // color components are used at top of the range for color difference
            // use white background for now. TODO: support transparency.
            Color foreColor = Color.FromArgb(red << 3, green << 3, blue << 3);
            Color backColor = Color.White;

            // outline shapes with a noticeable color (complementary will do) if
            // shape color and background color are too similar (measured by color
            // distance).
            Color strokeColor = Color.Empty;
            if(ColorDistance(ref foreColor, ref backColor) < 32f)
            {
                strokeColor = ComplementaryColor(ref foreColor);
            }

            // render at larger source size (to be scaled down later)
            int sourceSize = PatchSize * 3;
            using(var sourceImage = new Bitmap(sourceSize, sourceSize, PixelFormat.Format32bppRgb))
            {
                using(Graphics graphics = Graphics.FromImage(sourceImage))
                {
                    // center patch
                    DrawPatch(graphics, PatchSize, PatchSize, centerType, 0, centerInvert, ref foreColor, ref backColor,
                              ref strokeColor);

                    // side patch (top)
                    DrawPatch(graphics, PatchSize, 0, sideType, sideTurn++, sideInvert, ref foreColor, ref backColor,
                              ref strokeColor);
                    // side patch (right)
                    DrawPatch(graphics, PatchSize * 2, PatchSize, sideType, sideTurn++, sideInvert, ref foreColor, ref backColor,
                              ref strokeColor);
                    // side patch (bottom)
                    DrawPatch(graphics, PatchSize, PatchSize * 2, sideType, sideTurn++, sideInvert, ref foreColor, ref backColor,
                              ref strokeColor);
                    // side patch (left)
                    DrawPatch(graphics, 0, PatchSize, sideType, sideTurn, sideInvert, ref foreColor, ref backColor, ref strokeColor);

                    // corner patch (top left)
                    DrawPatch(graphics, 0, 0, cornerType, cornerTurn++, cornerInvert, ref foreColor, ref backColor, ref strokeColor);
                    // corner patch (top right)
                    DrawPatch(graphics, PatchSize * 2, 0, cornerType, cornerTurn++, cornerInvert, ref foreColor, ref backColor,
                              ref strokeColor);
                    // corner patch (bottom right)
                    DrawPatch(graphics, PatchSize * 2, PatchSize * 2, cornerType, cornerTurn++, cornerInvert, ref foreColor,
                              ref backColor, ref strokeColor);
                    // corner patch (bottom left)
                    DrawPatch(graphics, 0, PatchSize * 2, cornerType, cornerTurn, cornerInvert, ref foreColor, ref backColor,
                              ref strokeColor);
                }
                // scale source image to target size with bicubic smoothing
                return ScaleImage(size, sourceImage);
            }
        }

        private static Bitmap ScaleImage(int size, Image sourceImage)
        {
            var bitmap = new Bitmap(size, size, PixelFormat.Format32bppRgb);
            using(Graphics g = Graphics.FromImage(bitmap))
            {
                var fudge = (int)(size * 0.016); // this is necessary to prevent scaling artifacts at larger sizes
                g.DrawImage(sourceImage, 0, 0, size + fudge, size + fudge);
            }
            return bitmap;
        }

        private void DrawPatch(Graphics g, int x, int y, int patch, int turn, bool invert, ref Color fore, ref Color back, ref Color stroke)
        {
            patch %= PatchTypes.Length;
            turn %= 4;
            if((PatchFlags[patch] & PatchInverted) != 0)
            {
                invert = !invert;
            }

            // paint the background
            g.FillRegion(new SolidBrush(invert ? fore : back), new Region(new Rectangle(x, y, PatchSize, PatchSize)));

            // offset and rotate coordinate space by patch position (x, y) and
            // 'turn' before rendering patch shape
            Matrix m = g.Transform;
            g.TranslateTransform((x + _patchOffset), (y + _patchOffset));
            g.RotateTransform(turn * 90);

            // if stroke color was specified, apply stroke
            // stroke color should be specified if fore color is too close to the back color.
            if(!stroke.IsEmpty)
            {
                g.DrawPath(new Pen(stroke), _patchShapes[patch]);
            }

            // render rotated patch using fore color (back color if inverted)
            g.FillPath(new SolidBrush(invert ? back : fore), _patchShapes[patch]);

            // restore previous rotation
            g.Transform = m;
        }

        /// <summary>Returns distance between two colors</summary>		
        private static float ColorDistance(ref Color c1, ref Color c2)
        {
            float dx = c1.R - c2.R;
            float dy = c1.G - c2.G;
            float dz = c1.B - c2.B;
            return (float)Math.Sqrt(dx * dx + dy * dy + dz * dz);
        }

        /// <summary>Returns complementary color</summary>
        private static Color ComplementaryColor(ref Color c)
        {
            return Color.FromArgb(c.ToArgb() ^ 0x00FFFFFF);
        }
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Web;
using System.Web.Mvc;
using Docuverse.Identicon;

namespace Subtext.Framework.Services.Identicon
{
    public class IdenticonResult : FileResult
    {
        public IdenticonResult(int code, int size, string etag) : base("image/png")
        {
            Code = code;
            Size = size;
            Etag = etag;
        }

        public string Etag
        {
            get; 
            private set;
        }
        
        public int Code
        {
            get; 
            private set;
        }
        public int Size
        {
            get; 
            private set;
        }

        protected override void WriteFile(HttpResponseBase response)
        {
            response.Clear();
            if(!string.IsNullOrEmpty(Etag))
            {
                response.AppendHeader("ETag", Etag);
            }
            response.ContentType = "image/png";

            var renderer = new IdenticonRenderer();
            using(Bitmap b = renderer.Render(Code, Size))
            {
                using(var stream = new MemoryStream())
                {
                    b.Save(stream, ImageFormat.Png);
                    stream.WriteTo(response.OutputStream);
                }
            }
        }
    }
}
using System;
using System.Security.Cryptography;
using System.Text;
using System.Text.RegularExpressions;

namespace Subtext.Identicon
{
    /// <summary>
    /// Code borrowed from http://identicon.codeplex.com/
    /// </summary>
    public class IdenticonUtil
    {
        /// <summary>Sets or returns current IP address mask. Default is 0xffffffff.</summary>
        public static int Mask = unchecked((int)0xffffffff);

        /// <summary>Sets or returns current salt string value.</summary>
        public static String Salt;

        /// <summary>
        /// Returns Identicon code for given IP address as an integer.
        /// </summary>
        public static int Code(string ipAddress)
        {
            if(ipAddress == null)
            {
                throw new ArgumentNullException("ipAddress", "Must specify a non-null ip address.");
            }

            if(Salt == null)
            {
                // if not set manually, salt is automatically set to some machine-specific stuff 
                // Removed Environment.ProcessorCount because it requires elevated privileges.
                Salt = Environment.MachineName;
            }

            byte[] ip = GetAddressBytes(ipAddress);

            var s = new StringBuilder();
            /// Current implementation uses first four bytes of SHA1(int(mask(ip))+salt)
            /// where mask(ip) uses inetMask to remove unwanted bits from IP address.
            s.Append((((ip[0] & 0xFF) << 24) | ((ip[1] & 0xFF) << 16) | ((ip[2] & 0xFF) << 8) | (ip[3] & 0xFF)) & Mask);
            s.Append('+');
            /// Also, since salt is a string for convenience sake, int(mask(ip)) is
            /// converetd into a string and combined with inetSalt prior to hashing.
            s.Append(Salt);

            SHA1 md = new SHA1CryptoServiceProvider();
            byte[] hashedIp = md.ComputeHash(new UTF8Encoding().GetBytes(s.ToString()));

            return ((hashedIp[0] & 0xFF) << 24) | ((hashedIp[1] & 0xFF) << 16) | ((hashedIp[2] & 0xFF) << 8) | (hashedIp[3] & 0xFF);
        }

        /// <summary>
        /// Translates IP string into 4-byte array
        /// </summary>
        private static byte[] GetAddressBytes(string ipAddress)
        {
            var b = new byte[] {0, 0, 0, 0};
            if(!String.IsNullOrEmpty(ipAddress))
            {
                string s = Regex.Match(ipAddress, @"^(?:[0-9]{1,3}\.){3}[0-9]{1,3}").ToString();
                int i = 0;
                foreach(Match m in Regex.Matches(s, @"\d+"))
                {
                    Byte.TryParse(m.ToString(), out b[i]);
                    i++;
                }
            }
            return b;
        }

        /// <summary>
        /// returns unique string tag for an Identicon code at a specific size. 
        /// Used to track browser caching of specific images
        /// </summary>		
        public static String ETag(int code, int size)
        {
            return "W/\"" + Convert.ToString(code, 16) + "@" + size + "\"";
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Components;

namespace Subtext.Framework.Services
{
    public interface IEntryPublisher
    {
        int Publish(Entry entry);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Components;

namespace Subtext.Framework.Services
{
    /// <summary>
    /// Base interface for comment spam services such as Akismet.
    /// </summary>
    public interface ICommentSpamService
    {
        /// <summary>
        /// Examines the item and determines whether or not it is spam.
        /// </summary>
        /// <param name="feedback"></param>
        /// <returns></returns>
        bool IsSpam(FeedbackItem feedback);

        /// <summary>
        /// Submits the item to the service as a false positive. 
        /// Something that should not have been marked as spam.
        /// </summary>
        /// <param name="feedback"></param>
        void SubmitGoodFeedback(FeedbackItem feedback);

        /// <summary>
        /// Submits the item to the service as a piece of SPAM that got through 
        /// the filter. Something that should've been marked as SPAM.
        /// </summary>
        /// <param name="feedback"></param>
        void SubmitSpam(FeedbackItem feedback);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Components;

namespace Subtext.Framework.Services
{
    public interface ISlugGenerator
    {
        string GetSlugFromTitle(Entry entry);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using Subtext.Framework.Components;

namespace Subtext.Framework.Services
{
    public interface IStatisticsService
    {
        void RecordWebView(EntryView view);
        void RecordAggregatorView(EntryView view);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Services
{
    public interface ITextTransformation
    {
        string Transform(string original);
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;

namespace Subtext.Framework.Services
{
    /// <summary>
    /// Expands keywords into links.
    /// </summary>
    public class KeywordExpander : ITextTransformation
    {
        public KeywordExpander(ObjectProvider repository)
        {
            _repository = repository;
        }

        readonly ObjectProvider _repository;

        public KeywordExpander(IEnumerable<KeyWord> keyWords)
        {
            _keywords = keyWords;
        }

        public IEnumerable<KeyWord> Keywords
        {
            get
            {
                if(_keywords == null)
                {
                    if(_repository != null)
                    {
                        _keywords = _repository.GetKeyWords();
                    }
                }
                return _keywords;
            }
        }

        IEnumerable<KeyWord> _keywords;

        public string Transform(string original)
        {
            return Keywords != null ? Keywords.Aggregate(original, ReplaceFormat) : original;
        }

        /// <summary>
        /// Preforms a forward scan and replace for a given pattern. 
        /// Can specify only to match first fine and if the pattern is CaseSensitive
        /// </summary>
        private static string ReplaceFormat(string source, KeyWord keyword)
        {
            return Scan(source, keyword.Word, keyword.GetFormat, true, keyword.ReplaceFirstTimeOnly,
                        keyword.CaseSensitive);
        }

        private static string Scan(string source, string oldValue, string newValue, bool isFormat, bool onlyFirstMatch,
                                   bool caseSensitive)
        {
            const char tagOpen = '<';
            const char tagClose = '>';
            const string anchorOpen = "<a ";
            const string anchorClose = "</a";

            source += " ";

            bool lastIterMatched = false;

            ScanState state = ScanState.Replace;
            var outputBuffer = new StringBuilder(source.Length);

            var tagstack = new Queue<char>(anchorOpen.Length);

            for(int i = 0; i < source.Length; i++)
            {
                char nextChar = source[i];
                tagstack.Enqueue(nextChar);

                switch(state)
                {
                    case ScanState.Replace:
                        if(anchorOpen == new string(tagstack.ToArray()))
                        {
                            state = ScanState.InAnchor;
                            break;
                        }
                        if(tagOpen == nextChar)
                        {
                            state = ScanState.InTag;
                            break;
                        }
                        if(source.Length - (i + oldValue.Length) > 0)
                        {
                            // peek a head the next target length chunk + 1 boundary char
                            string matchTarget = source.Substring(i, oldValue.Length);

                            if(String.Equals(matchTarget, oldValue,
                                             caseSensitive
                                                 ? StringComparison.Ordinal
                                                 : StringComparison.OrdinalIgnoreCase))
                            {
                                int index = 0 - i;
                                if(index != 0) //Skip if we are at the start of the block
                                {
                                    char prevBeforeMatch = source[(i) - 1];
                                    if(prevBeforeMatch != '>' && prevBeforeMatch != '"' &&
                                       !Char.IsWhiteSpace(prevBeforeMatch))
                                    {
                                        break;
                                    }
                                }

                                // check for word boundary
                                char nextAfterMatch = source[i + oldValue.Length];
                                if(!CharIsWordBoundary(nextAfterMatch))
                                {
                                    break;
                                }

                                // format old with specifier else it's a straight replace
                                if(isFormat)
                                {
                                    outputBuffer.AppendFormat(newValue, oldValue);
                                }
                                else
                                {
                                    outputBuffer.Append(newValue);
                                }

                                // if we're onlyFirstMatch, tack on remainder of source and return
                                if(onlyFirstMatch)
                                {
                                    outputBuffer.Append(source.Substring(i + oldValue.Length,
                                                                               source.Length -
                                                                               (i + oldValue.Length + 1)));
                                    return outputBuffer.ToString();
                                }
                                i += oldValue.Length - 1;

                                lastIterMatched = true;
                                break;
                            }
                        }

                        break;

                    case ScanState.InAnchor:
                        if(anchorClose == new string(tagstack.ToArray()))
                        {
                            state = ScanState.Replace;
                        }
                        break;

                    case ScanState.InTag:
                        if(anchorOpen == new string(tagstack.ToArray()))
                        {
                            state = ScanState.InAnchor;
                        }
                        else if(tagClose == nextChar)
                        {
                            state = ScanState.Replace;
                        }
                        break;

                    default:
                        break;
                }

                if(!lastIterMatched)
                {
                    outputBuffer.Append(nextChar);
                }
                else
                {
                    lastIterMatched = false;
                }
            }

            outputBuffer.Length--;
            return outputBuffer.ToString();
        }


        // cursory testing for word boundaries. there are still some cracks here for html,
        // e.g., &nbsp; and other boundary entities
        private static bool CharIsWordBoundary(char value)
        {
            switch(value)
            {
                case '_':
                    return false;
                default:
                    return !Char.IsLetterOrDigit(value);
            }
        }

        private enum ScanState
        {
            Replace,
            InTag,
            InAnchor
        }
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using Subtext.Framework.Components;
using Subtext.Framework.Text;

namespace Subtext.Framework.Services.SearchEngine
{
    public static class EntryExtensionMethods
    {
        /// <summary>
        /// Converts a blog entry to the document ready for being indexed.
        /// </summary>
        /// <param name="entry">the <see cref="Entry"/> to convert</param>
        /// <param name="tags">list of tags</param>
        /// <returns>the model in the format required by the indexing service</returns>
        public static SearchEngineEntry ConvertToSearchEngineEntry(this Entry entry, IEnumerable<string> tags)
        {
            return new SearchEngineEntry()
                       {
                           BlogId = entry.BlogId,
                           BlogName = entry.Blog.Title,
                           Body = HtmlHelper.RemoveHtml(entry.Body),
                           GroupId = entry.Blog.BlogGroupId,
                           IsPublished = entry.IsActive,
                           EntryId = entry.Id,
                           PublishDate = entry.DateSyndicated,
                           Tags = String.Join(",",tags.ToArray()),
                           Title = entry.Title,
                           EntryName = entry.EntryName
                       };
        }

        /// <summary>
        /// Converts a blog entry to the document ready for being indexed.
        /// Parses the body of the entry looking for tags.
        /// </summary>
        /// <param name="entry">the <see cref="Entry"/> to convert</param>
        /// <returns>the model in the format required by the indexing service</returns>
        public static SearchEngineEntry ConvertToSearchEngineEntry(this Entry entry)
        {
            return entry.ConvertToSearchEngineEntry(entry.Body.ParseTags());
        }
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using Subtext.Framework.Components;

namespace Subtext.Framework.Services.SearchEngine
{
    public interface IIndexingService
    {
        /// <summary>
        /// Rebuilds the index for the current blog. This is done spinning another thread.
        /// </summary>
        void RebuildIndexAsync();
        /// <summary>
        /// Rebuilds the index for the current blog.
        /// </summary>
        IEnumerable<IndexingError> RebuildIndex();
        /// <summary>
        /// Adds a entry to the full text index
        /// </summary>
        /// <param name="entry">The Entry to be added</param>
        /// <returns>A list of possible errors</returns>
        IEnumerable<IndexingError> AddPost(Entry entry);
        /// <summary>
        /// Adds a entry to the full text index
        /// </summary>
        /// <param name="entry">The Entry to be added</param>
        /// <param name="tags">The List of tags</param>
        /// <returns>A list of possible errors</returns>
        IEnumerable<IndexingError> AddPost(Entry entry, IList<string> tags);
    }
}using System;

namespace Subtext.Framework.Services.SearchEngine
{
    public class IndexingError
    {
        public IndexingError(SearchEngineEntry entry, Exception exception)
        {
            Entry = entry;
            Exception = exception;
        }

        public SearchEngineEntry Entry { get; set; }
        public Exception Exception { get; set; }
    }
}﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System.Collections.Generic;
using System.Threading;
using Subtext.Extensibility;
using Subtext.Extensibility.Collections;
using Subtext.Framework.Components;
using Subtext.Framework.Providers;
using Subtext.Framework.Util;

namespace Subtext.Framework.Services.SearchEngine
{
    public class IndexingService : IIndexingService
    {
        public IndexingService(ISubtextContext subtextContext, ISearchEngineService searchEngine)
        {
            SubtextContext = subtextContext;
            SearchEngineService = searchEngine;
        }

        protected ObjectProvider Repository
        {
            get { return SubtextContext.Repository; }
        }

        public ISearchEngineService SearchEngineService { get; private set; }
        public ISubtextContext SubtextContext { get; private set; }

        public void RebuildIndexAsync()
        {
            ThreadHelper.FireAndForget(o => RebuildIndex(), "Error while rebuilding index");
        }

        public IEnumerable<IndexingError> RebuildIndex()
        {
            return SearchEngineService.AddPosts(GetBlogPosts());
        }

        private IEnumerable<SearchEngineEntry> GetBlogPosts()
        {
            const int pageSize = 100;
            var collectionBook = new CollectionBook<EntryStatsView>((pageIndex, sizeOfPage) => Repository.GetEntries(PostType.BlogPost,null, pageIndex, sizeOfPage), pageSize);
            foreach (var entry in collectionBook.AsFlattenedEnumerable())
            {
                if(entry.IsActive)
                    yield return entry.ConvertToSearchEngineEntry();
            }
        }

        public IEnumerable<IndexingError> AddPost(Entry entry)
        {
            return ExecuteAddPost(entry.ConvertToSearchEngineEntry());
        }

        public IEnumerable<IndexingError> AddPost(Entry entry, IList<string> tags)
        {
            return ExecuteAddPost(entry.ConvertToSearchEngineEntry(tags));
        }

        private IEnumerable<IndexingError> ExecuteAddPost(SearchEngineEntry entry)
        {
            if (entry.IsPublished)
                return SearchEngineService.AddPost(entry);
            SearchEngineService.RemovePost(entry.EntryId);
            return new List<IndexingError>();
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using Subtext.Framework.Configuration;

namespace Subtext.Framework.Services.SearchEngine
{
    public interface ISearchEngineService: IDisposable
    {
        /// <summary>
        /// Adds an entry to the full text index
        /// </summary>
        /// <param name="post">The Entry</param>
        IEnumerable<IndexingError> AddPost(SearchEngineEntry post);
        /// <summary>
        /// Adds many entries to the full text index.
        /// This optimizes the index after adding the posts.
        /// </summary>
        /// <param name="posts">List of entries</param>
        IEnumerable<IndexingError> AddPosts(IEnumerable<SearchEngineEntry> posts);
        /// <summary>
        /// Adds many entries to the full text index
        /// </summary>
        /// <param name="posts">List of entries</param>
        /// <param name="optimize">False to not optimize the index after adding the posts</param>
        IEnumerable<IndexingError> AddPosts(IEnumerable<SearchEngineEntry> posts, bool optimize);
        /// <summary>
        /// Search the full text index by query string
        /// </summary>
        /// <param name="queryString">the query string</param>
        /// <param name="max">Max number of results to retrieve</param>
        /// <param name="blogId">The id of the blog being searched</param>
        /// <returns></returns>
        IEnumerable<SearchEngineResult> Search(string queryString, int max, int blogId);
        /// <summary>
        /// Search the full text index by query string
        /// </summary>
        /// <param name="queryString">the query string</param>
        /// <param name="max">Max number of results to retrieve</param>
        /// <param name="blogId">The id of the blog being searched</param>
        /// <param name="entryId">The id of the entry that must be filtered out of the results (-1 if none)</param>
        /// <returns></returns>
        IEnumerable<SearchEngineResult> Search(string queryString, int max, int blogId, int entryId);
        /// <summary>
        /// Removes an entry from the index.
        /// </summary>
        /// <param name="postId">Id of the entry</param>
        void RemovePost(int postId);
        /// <summary>
        /// Gets the number of entries indexed for a blog.
        /// </summary>
        /// <param name="blogId">Id of the blog</param>
        /// <returns></returns>
        int GetIndexedEntryCount(int blogId);
        /// <summary>
        /// Gets the number of entries available in the whole index
        /// </summary>
        /// <returns></returns>
        int GetTotalIndexedEntryCount();
        /// <summary>
        /// Returns all entries "similar" to the entry specified by the id.
        /// </summary>
        /// <param name="entryId">The id of the Entry</param>
        /// <param name="max">The maximum number of results to return</param>
        /// <param name="blogId">The id of the blog being searched</param>
        /// <returns></returns>
        IEnumerable<SearchEngineResult> RelatedContents(int entryId, int max, int blogId);

    }
}﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Subtext.Framework.Services.SearchEngine
{
    public class NoOpIndexingService: IIndexingService
    {
        #region IIndexingService Members

        public void RebuildIndexAsync()
        {
            
        }

        public IEnumerable<IndexingError> RebuildIndex()
        {
            var errors = new List<IndexingError>();
            errors.Add(new IndexingError(new SearchEngineEntry() { EntryId=0 }, new NotSupportedException("The Search Engine has been disabled. Please contact the webmaster if you need further assistence")));
            return errors;
        }

        public IEnumerable<IndexingError> AddPost(Subtext.Framework.Components.Entry entry)
        {
            return new List<IndexingError>();
        }

        public IEnumerable<IndexingError> AddPost(Subtext.Framework.Components.Entry entry, IList<string> tags)
        {
            return new List<IndexingError>();
        }

        #endregion
    }
}
﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Subtext.Framework.Services.SearchEngine
{
    public class NoOpSearchEngineService: ISearchEngineService
    {
        #region ISearchEngineService Members

        public IEnumerable<IndexingError> AddPost(SearchEngineEntry post)
        {
            return AddPosts(new[] { post }, false);
        }

        public IEnumerable<IndexingError> AddPosts(IEnumerable<SearchEngineEntry> posts)
        {
            return AddPosts(posts, true);
        }

        public IEnumerable<IndexingError> AddPosts(IEnumerable<SearchEngineEntry> posts, bool optimize)
        {
            return new List<IndexingError>();
        }

        public IEnumerable<SearchEngineResult> Search(string queryString, int max, int blogId)
        {
            return Search(queryString, max, blogId, -1);
        }

        public IEnumerable<SearchEngineResult> Search(string queryString, int max, int blogId, int entryId)
        {
            return new List<SearchEngineResult>();
        }

        public void RemovePost(int postId)
        {
            
        }

        public int GetIndexedEntryCount(int blogId)
        {
            return 0;
        }

        public int GetTotalIndexedEntryCount()
        {
            return 0;
        }

        public IEnumerable<SearchEngineResult> RelatedContents(int entryId, int max, int blogId)
        {
            return new List<SearchEngineResult>();
        }

        #endregion

        #region IDisposable Members

        public void Dispose()
        {
            
        }

        #endregion
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;

namespace Subtext.Framework.Services.SearchEngine
{
    public class SearchEngineEntry
    {
        public int EntryId { get; set; }
        public string EntryName { get; set; }
        public string Title { get; set; }
        public string Body { get; set; }
        public string Tags { get; set; }
        public int BlogId { get; set; }
        public bool IsPublished { get; set; }
        public DateTime PublishDate { get; set; }
        public string BlogName { get; set; }
        public int GroupId { get; set; }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using Subtext.Extensibility;
using Subtext.Extensibility.Interfaces;

namespace Subtext.Framework.Services.SearchEngine
{
    public class SearchEngineResult : IEntryIdentity
    {
        public int EntryId { get; set; }
        public string Title { get; set; }
        public DateTime PublishDate { get; set; }
        public string BlogName { get; set; }
        public float Score { get; set; }

        #region IEntryIdentity Members

        public string EntryName { get; set; }

        public DateTime DateSyndicated
        {
            get { return PublishDate; }
        }

        public PostType PostType
        {
            get { return PostType.BlogPost; }
        }

        #endregion

        #region IIdentifiable Members

        public int Id
        {
            get { return EntryId; }
        }

        #endregion
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using Lucene.Net.Analysis;
using Lucene.Net.Documents;
using Lucene.Net.Index;
using Lucene.Net.QueryParsers;
using Lucene.Net.Search;
using Lucene.Net.Store;
using Lucene.Net.Util;
using Similarity.Net;
using Subtext.Framework.Configuration;
using Subtext.Framework.Logging;

namespace Subtext.Framework.Services.SearchEngine
{

    public class SearchEngineService : ISearchEngineService
    {
        private readonly Directory _directory;
        private readonly Analyzer _analyzer;
        private static IndexWriter _writer;
        private readonly FullTextSearchEngineSettings _settings;

        private const string Title = "Title";
        private const string Body = "Body";
        private const string Tags = "Tags";
        private const string Pubdate = "PubDate";
        private const string Blogid = "BlogId";
        private const string Groupid = "GroupId";
        private const string BlogName = "BlogName";
        private const string Entryid = "PostId";
        private const string Published = "IsPublished";
        private const string EntryName = "EntryName";

        private static readonly Object WriterLock = new Object();

        private static readonly Log Log = new Log();
        private bool _disposed;

        public SearchEngineService(Directory directory, Analyzer analyzer, FullTextSearchEngineSettings settings)
        {
            _directory = directory;
            _analyzer = analyzer;
            _settings = settings;
        }

        private void DoWriterAction(Action<IndexWriter> action)
        {
            lock(WriterLock)
            {
                EnsureIndexWriter();
            }
            action(_writer);
        }

        private T DoWriterAction<T>(Func<IndexWriter,T> action)
        {
            lock (WriterLock)
            {
                EnsureIndexWriter();
            }
            return action(_writer);
        }
      
        // Method should only be called from within a lock.
        void EnsureIndexWriter()
        {
            if(_writer == null)
            {
                if(IndexWriter.IsLocked(_directory))
                {
                    Log.Error("Something left a lock in the index folder: deleting it");
                    IndexWriter.Unlock(_directory);
                    Log.Info("Lock Deleted... can proceed");
                }
                _writer = new IndexWriter(_directory, _analyzer,IndexWriter.MaxFieldLength.UNLIMITED);
                _writer.SetMergePolicy(new LogDocMergePolicy(_writer));
                _writer.SetMergeFactor(5);
            }
        }

        private IndexSearcher Searcher { 
            get {return DoWriterAction(writer => new IndexSearcher(writer.GetReader())); }
        }


        private QueryParser BuildQueryParser()
        {
            var parser = new QueryParser(Lucene.Net.Util.Version.LUCENE_29, Body, _analyzer);
            parser.SetDefaultOperator(QueryParser.Operator.AND);
            return parser;
        }

        public IEnumerable<IndexingError> AddPost(SearchEngineEntry post)
        {
            return AddPosts(new[] { post }, false);
        }

        public IEnumerable<IndexingError> AddPosts(IEnumerable<SearchEngineEntry> posts)
        {
            return AddPosts(posts, true);
        }

        public IEnumerable<IndexingError> AddPosts(IEnumerable<SearchEngineEntry> posts, bool optimize)
        {
            IList<IndexingError> errors = new List<IndexingError>();
            foreach (var post in posts)
            {
                ExecuteRemovePost(post.EntryId);
                try
                {
                    var currentPost = post;
                    DoWriterAction(writer => writer.AddDocument(CreateDocument(currentPost)));
                }
                catch(Exception ex)
                {
                    errors.Add(new IndexingError(post, ex));
                }
            }
            DoWriterAction(writer =>
            {
                writer.Commit();
                if(optimize)
                {
                    writer.Optimize();
                }

            });
            
            return errors;
        }

        public void RemovePost(int postId)
        {
            ExecuteRemovePost(postId);
            DoWriterAction(writer => writer.Commit());
        }

        public int GetIndexedEntryCount(int blogId)
        {
            var query = GetBlogIdSearchQuery(blogId);
            TopDocs hits = Searcher.Search(query,1);
            return hits.totalHits;
        }

        public int GetTotalIndexedEntryCount()
        {
            return DoWriterAction(writer => writer.GetReader().NumDocs());
        }

        private void ExecuteRemovePost(int entryId)
        {
            Query searchQuery = GetIdSearchQuery(entryId);
            DoWriterAction(writer => writer.DeleteDocuments(searchQuery));
        }

        private static Query GetIdSearchQuery(int id)
        {
            return new TermQuery(new Term(Entryid, NumericUtils.IntToPrefixCoded(id)));
        }

        private static Query GetBlogIdSearchQuery(int id)
        {
            return new TermQuery(new Term(Blogid, NumericUtils.IntToPrefixCoded(id)));
        }

        protected virtual Document CreateDocument(SearchEngineEntry post)
        {
            var doc = new Document();

            var postId = new Field(Entryid,
                NumericUtils.IntToPrefixCoded(post.EntryId),
                Field.Store.YES,
                Field.Index.NOT_ANALYZED,
                Field.TermVector.NO);

            var title = new Field(Title,
                post.Title,
                Field.Store.YES,
                Field.Index.ANALYZED,
                Field.TermVector.YES);
            title.SetBoost(_settings.Parameters.TitleBoost);

            var body = new Field(Body,
                post.Body,
                Field.Store.NO,
                Field.Index.ANALYZED,
                Field.TermVector.YES);
            body.SetBoost(_settings.Parameters.BodyBoost);

            var tags = new Field(Tags,
                post.Tags,
                Field.Store.NO,
                Field.Index.ANALYZED,
                Field.TermVector.YES);
            tags.SetBoost(_settings.Parameters.TagsBoost);

            var blogId = new Field(Blogid,
                NumericUtils.IntToPrefixCoded(post.BlogId),
                Field.Store.NO,
                Field.Index.NOT_ANALYZED,
                Field.TermVector.NO);


            var published = new Field(Published,
                post.IsPublished.ToString(),
                Field.Store.NO,
                Field.Index.NOT_ANALYZED,
                Field.TermVector.NO);

            var pubDate = new Field(Pubdate,
                DateTools.DateToString(post.PublishDate, DateTools.Resolution.MINUTE),
                Field.Store.YES,
                Field.Index.NOT_ANALYZED,
                Field.TermVector.NO);

            var groupId = new Field(Groupid,
                NumericUtils.IntToPrefixCoded(post.GroupId),
                Field.Store.NO,
                Field.Index.NOT_ANALYZED,
                Field.TermVector.NO);

            var blogName = new Field(BlogName,
                post.BlogName,
                Field.Store.YES,
                Field.Index.NO,
                Field.TermVector.NO);

            var postName = new Field(EntryName,
                post.EntryName ?? "",
                Field.Store.YES,
                Field.Index.NO,
                Field.TermVector.NO);
            postName.SetBoost(_settings.Parameters.EntryNameBoost);


            doc.Add(postId);
            doc.Add(title);
            doc.Add(body);
            doc.Add(tags);
            doc.Add(blogId);
            doc.Add(published);
            doc.Add(pubDate);
            doc.Add(groupId);
            doc.Add(blogName);
            doc.Add(postName);

            return doc;
        }

        protected virtual SearchEngineResult CreateSearchResult(Document doc, float score)
        {
            var result = new SearchEngineResult
            {
                BlogName = doc.Get(BlogName),
                EntryId = NumericUtils.PrefixCodedToInt(doc.Get(Entryid)),
                PublishDate = DateTools.StringToDate(doc.Get(Pubdate)),
                Title = doc.Get(Title),
                Score = score
            };
            string entryName = doc.Get(EntryName);
            result.EntryName = !String.IsNullOrEmpty(entryName) ? entryName : null;
            
            return result;
        }

        public IEnumerable<SearchEngineResult> RelatedContents(int entryId, int max, int blogId)
        {
            var list = new List<SearchEngineResult>();

            //First look for the original doc
            Query query = GetIdSearchQuery(entryId);
            TopDocs hits = Searcher.Search(query, max);

            if(hits.scoreDocs.Length <= 0) 
            {
                return list;
            }

            int docNum = hits.scoreDocs[0].doc;

            //Setup MoreLikeThis searcher
            var reader = DoWriterAction(w => w.GetReader());
            var mlt = new MoreLikeThis(reader);
            mlt.SetAnalyzer(_analyzer);
            mlt.SetFieldNames(new[] { Title, Body, Tags });
            mlt.SetMinDocFreq(_settings.Parameters.MinimumDocumentFrequency);
            mlt.SetMinTermFreq(_settings.Parameters.MinimumTermFrequency);
            mlt.SetBoost(_settings.Parameters.MoreLikeThisBoost);

            var moreResultsQuery = mlt.Like(docNum);
            return PerformQuery(list, moreResultsQuery, max+1, blogId, entryId);
        }

        public IEnumerable<SearchEngineResult> Search(string queryString, int max, int blogId)
        {
            return Search(queryString, max, blogId, -1);
        }

        public IEnumerable<SearchEngineResult> Search(string queryString, int max, int blogId, int entryId)
        {
            var list = new List<SearchEngineResult>();
            if (String.IsNullOrEmpty(queryString)) return list;
            QueryParser parser = BuildQueryParser();
            Query bodyQuery = parser.Parse(queryString);

            
            string queryStringMerged = String.Format("({0}) OR ({1}) OR ({2})",
                                                     bodyQuery,
                                                     bodyQuery.ToString().Replace("Body", "Title"),
                                                     bodyQuery.ToString().Replace("Body", "Tags"));

            Query query = parser.Parse(queryStringMerged);
            

            return PerformQuery(list, query, max, blogId, entryId);
        }

        private IEnumerable<SearchEngineResult> PerformQuery(ICollection<SearchEngineResult> list, Query queryOrig, int max, int blogId, int idToFilter)
        {
            Query isPublishedQuery = new TermQuery(new Term(Published, true.ToString()));
            Query isBlogQuery = GetBlogIdSearchQuery(blogId);
            
            var query = new BooleanQuery();
            query.Add(isPublishedQuery, BooleanClause.Occur.MUST);
            query.Add(queryOrig, BooleanClause.Occur.MUST);
            query.Add(isBlogQuery, BooleanClause.Occur.MUST);
            IndexSearcher searcher = Searcher;
            TopDocs hits = searcher.Search(query, max);
            int length = hits.scoreDocs.Length;
            int resultsAdded = 0;
            float minScore = _settings.MinimumScore;
            float scoreNorm = 1.0f / hits.GetMaxScore(); 
            for (int i = 0; i < length && resultsAdded < max; i++)
            {
                float score = hits.scoreDocs[i].score * scoreNorm;
                SearchEngineResult result = CreateSearchResult(searcher.Doc(hits.scoreDocs[i].doc), score);
                if (idToFilter != result.EntryId && result.Score > minScore && result.PublishDate < DateTime.Now)
                {
                    list.Add(result);
                    resultsAdded++;
                }
                    
            }
            return list;
        }

        ~SearchEngineService()
        {
            Dispose();
        }

        public void Dispose()
        {
            lock(WriterLock)
            {
                if(!_disposed)
                {
                    //Never checking for disposing = true because there are
                    //no managed resources to dispose

                    var writer = _writer;

                    if(writer != null)
                    {
                        try
                        {
                            writer.Close();
                        }
                        catch(ObjectDisposedException e)
                        {
                           Log.Error("Exception while disposing SearchEngineService", e); 
                        }
                        _writer = null;
                    }

                    var directory = _directory;
                    if(directory != null)
                    {
                        try
                        {
                            directory.Close();
                        }
                        catch(ObjectDisposedException e)
                        {
                            Log.Error("Exception while disposing SearchEngineService", e);
                        }
                    }

                    _disposed = true;
                }
            }
            GC.SuppressFinalize(this);
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Web;
using System.Web.Security;
using log4net;
using Subtext.Framework.Logging;
using Subtext.Framework.Security;

namespace Subtext.Framework.Services.Account
{
    public class AccountService : IAccountService
    {
        private readonly static ILog Log = new Log();

        public void Logout(ISubtextContext context)
        {
            var request = context.HttpContext.Request;
            var response = context.HttpContext.Response;
            var authCookie = new HttpCookie(request.GetFullCookieName(context.Blog)) { Expires = DateTime.Now.AddYears(-30) };
            response.Cookies.Add(authCookie);

            if(Log.IsDebugEnabled)
            {
                string username = context.HttpContext.User.Identity.Name;
                if(Log.IsDebugEnabled)
                {
                    Log.Debug("Logging out " + username);
                    Log.Debug("the code MUST call a redirect after this");
                }
            }

            FormsAuthentication.SignOut();
        }
    }
}
﻿#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

namespace Subtext.Framework.Services.Account
{
    public interface IAccountService
    {
        void Logout(ISubtextContext context);
    }
}
#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Globalization;
using System.Security.Cryptography;
using System.Security.Principal;
using System.Text;
using System.Web;
using System.Web.Security;
using log4net;
using Subtext.Framework.Configuration;
using Subtext.Framework.Logging;
using Subtext.Framework.Providers;
using Subtext.Framework.Text;
using Subtext.Framework.Web;

namespace Subtext.Framework.Security
{
    /// <summary>
    /// Handles blog logins/passwords/tickets
    /// </summary>
    public static class SecurityHelper
    {
        private readonly static ILog Log = new Log();

        /// <summary>
        /// Gets a value indicating whether the current 
        /// user is the admin for the current blog.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [is admin]; otherwise, <c>false</c>.
        /// </value>
        public static bool IsAdmin
        {
            get { return IsInRole("Admins"); }
        }

        /// <summary>
        /// Gets a value indicating whether the current user is a 
        /// Host Admin for the entire installation.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [is host admin]; otherwise, <c>false</c>.
        /// </value>
        public static bool IsHostAdmin
        {
            get { return IsInRole("HostAdmins"); }
        }

        /// <summary>
        /// Gets the name of the current user.
        /// </summary>
        /// <value></value>
        public static string CurrentUserName
        {
            get
            {
                if(HttpContext.Current.Request.IsAuthenticated)
                {
                    try
                    {
                        return HttpContext.Current.User.Identity.Name;
                    }
                    catch
                    {
                    }
                }
                return null;
            }
        }

        /// <summary>
        /// If true, then the user is connecting to the blog via "localhost" 
        /// on the same server as this is installed.  In other words, we're 
        /// pretty sure the user is a developer.
        /// </summary>
        public static bool UserIsConnectingLocally
        {
            get
            {
                var httpContext = new HttpContextWrapper(HttpContext.Current);
                return String.Equals(httpContext.Request.Url.Host, "localhost",
                                     StringComparison.InvariantCultureIgnoreCase)
                       &&
                       HttpHelper.GetUserIpAddress(httpContext).ToString() ==
                       HttpContext.Current.Request.ServerVariables["LOCAL_ADDR"]
                       && HttpHelper.GetUserIpAddress(httpContext).ToString() == "127.0.0.1";
            }
        }

        /// <summary>
        /// Check to see if the supplied credentials are valid for the current blog. If so, 
        /// Set the user's FormsAuthentication Ticket This method will handle passwords for 
        /// both hashed and non-hashed configurations
        /// </summary>
        public static bool Authenticate(this HttpContextBase httpContext, Blog blog, string username, string password,
                                        bool persist)
        {
            if(!IsValidUser(blog, username, password))
            {
                return false;
            }

            httpContext.SetAuthenticationTicket(blog, username, persist, "Admins");
            return true;
        }

        /// <summary>
        /// Check to see if the supplied OpenID claim is valid for the current blog. If so, 
        /// Set the user's FormsAuthentication Ticket This method will handle passwords for 
        /// both hashed and non-hashed configurations
        /// We're comparing URI objects rather than using simple string compare because
        /// functionally equivalent URI's may not pass string comparaisons, e.g.
        /// such as http://example.myopenid.com/ and http://example.myopenid.com (trailing /)
        /// </summary>
        public static bool Authenticate(string claimedIdentifier, bool persist)
        {
            Blog currentBlog = Config.CurrentBlog;
            if(currentBlog == null)
            {
                return false;
            }

            //If the current blog doesn't have a valid OpenID URI, must fail
            if(!Uri.IsWellFormedUriString(currentBlog.OpenIdUrl, UriKind.Absolute))
            {
                return false;
            }

            //If the cliamed identifier isn't a valid OpenID URI, must fail
            if(!Uri.IsWellFormedUriString(claimedIdentifier, UriKind.Absolute))
            {
                return false;
            }

            var currentBlogClaimUri = new Uri(currentBlog.OpenIdUrl);
            var claimedUri = new Uri(claimedIdentifier);

            if(claimedUri.Host != currentBlogClaimUri.Host ||
               claimedUri.AbsolutePath != currentBlogClaimUri.AbsolutePath ||
               claimedUri.Query != currentBlogClaimUri.Query)
            {
                return false;
            }

            if(Log.IsDebugEnabled)
            {
                Log.Debug("SetAuthenticationTicket-Admins via OpenID for " + currentBlog.UserName);
            }
            HttpContextBase httpContext = new HttpContextWrapper(HttpContext.Current);
            httpContext.SetAuthenticationTicket(currentBlog, currentBlog.UserName, persist, "Admins");
            return true;
        }

        /// <summary>
        /// Authenticates the host admin.
        /// </summary>
        /// <param name="username">The username.</param>
        /// <param name="password">The password.</param>
        /// <param name="persist">if set to <c>true</c> [persist].</param>
        /// <returns></returns>
        public static bool AuthenticateHostAdmin(string username, string password, bool persist)
        {
            if(!String.Equals(username, HostInfo.Instance.HostUserName, StringComparison.InvariantCultureIgnoreCase))
            {
                return false;
            }

            if(Config.Settings.UseHashedPasswords)
            {
                password = HashPassword(password, HostInfo.Instance.Salt);
            }

            if(!String.Equals(HostInfo.Instance.Password, password, StringComparison.InvariantCultureIgnoreCase))
            {
                return false;
            }

            if(Log.IsDebugEnabled)
            {
                Log.Debug("SetAuthenticationTicket-HostAdmins for " + username);
            }
            HttpContextBase httpContext = new HttpContextWrapper(HttpContext.Current);
            httpContext.SetAuthenticationTicket(null, username, persist, true, "HostAdmins");

            return true;
        }

        /// <summary>
        /// Used to remove a cookie from the client.
        /// </summary>
        /// <returns>a correctly named cookie with Expires date set 30 years ago</returns>
        public static HttpCookie GetExpiredCookie(this HttpRequestBase request, Blog blog)
        {
            var expiredCookie = new HttpCookie(request.GetFullCookieName(blog)) {Expires = DateTime.Now.AddYears(-30)};
            return expiredCookie;
        }

        /// <summary>
        /// Obtains the correct cookie for the current blog
        /// </summary>
        /// <returns>null if correct cookie was not found</returns>
        public static HttpCookie SelectAuthenticationCookie(this HttpRequestBase request, Blog blog)
        {
            HttpCookie authCookie = null;
            HttpCookie c;
            int count = request.Cookies.Count;

            for(int i = 0; i < count; i++)
            {
                c = request.Cookies[i];

                if(c.Name == request.GetFullCookieName(blog))
                {
                    authCookie = c;
                    break;
                }
            }
            return authCookie;
        }

        /// <summary>
        /// Identifies cookies by unique BlogHost names (rather than a single
        /// name for all cookies in multiblog setups as the old code did).
        /// </summary>
        /// <returns></returns>
        public static string GetFullCookieName(this HttpRequestBase request, Blog blog)
        {
            return request.GetFullCookieName(blog, (blog == null || blog.IsAggregateBlog)/*forceHostAdmin*/);
        }

        public static string GetFullCookieName(this HttpRequestBase request, Blog blog, bool forceHostAdmin)
        {
            var name = new StringBuilder(FormsAuthentication.FormsCookieName);
            name.Append(".");

            //See if we need to authenticate the HostAdmin
            string path = request.Path;
            string returnUrl = request.QueryString["ReturnURL"];
            if(forceHostAdmin
               || (path + returnUrl).Contains("HostAdmin", StringComparison.OrdinalIgnoreCase))
            {
                name.Append("HA.");
            }

            if(!forceHostAdmin && blog != null)
            {
                name.Append(blog.Id.ToString(CultureInfo.InvariantCulture));
            }
            else
            {
                name.Append("null");
            }
            if(Log.IsDebugEnabled)
            {
                Log.Debug("GetFullCookieName selected cookie named " + name);
            }
            return name.ToString();
        }

        public static void SetAuthenticationTicket(this HttpContextBase httpContext, Blog blog, string username,
                                                   bool persist, params string[] roles)
        {
            httpContext.SetAuthenticationTicket(blog, username, persist, false, roles);
        }

        /// <summary>
        /// Used by methods in this class plus Install.Step02_ConfigureHost
        /// </summary>
        public static void SetAuthenticationTicket(this HttpContextBase httpContext, Blog blog, string username,
                                                   bool persist, bool forceHostAdmin, params string[] roles)
        {
            //Getting a cookie this way and using a temp auth ticket 
            //allows us to access the timeout value from web.config in partial trust.
            HttpCookie authCookie = FormsAuthentication.GetAuthCookie(username, persist);
            FormsAuthenticationTicket tempTicket = FormsAuthentication.Decrypt(authCookie.Value);
            string userData = string.Join("|", roles);

            var authTicket = new FormsAuthenticationTicket(
                tempTicket.Version,
                tempTicket.Name,
                tempTicket.IssueDate,
                tempTicket.Expiration, //this is how we access the configured timeout value
                persist,
                //the configured persistence value in web.config is not used. We use the checkbox value on the login page.
                userData, //roles
                tempTicket.CookiePath);
            authCookie.Value = FormsAuthentication.Encrypt(authTicket);
            authCookie.Name = httpContext.Request.GetFullCookieName(blog, forceHostAdmin);
            //prevents login problems with some multiblog setups

            httpContext.Response.Cookies.Add(authCookie);
        }

        /// <summary>
        /// Get MD5 hashed/encrypted representation of the password and 
        /// returns a Base64 encoded string of the hash.
        /// This is a one-way hash.
        /// </summary>
        /// <remarks>
        /// Passwords are case sensitive now. Before they weren't.
        /// </remarks>
        /// <param name="password">Supplied Password</param>
        /// <returns>Encrypted (Hashed) value</returns>
        public static string HashPassword(string password)
        {
            Byte[] clearBytes = new UnicodeEncoding().GetBytes(password);
            Byte[] hashedBytes = new MD5CryptoServiceProvider().ComputeHash(clearBytes);

            return Convert.ToBase64String(hashedBytes);
        }

        /// <summary>
        /// Get MD5 hashed/encrypted representation of the password and a 
        /// salt value combined in the proper manner.  
        /// Returns a Base64 encoded string of the hash.
        /// This is a one-way hash.
        /// </summary>
        /// <remarks>
        /// Passwords are case sensitive now. Before they weren't.
        /// </remarks>
        public static string HashPassword(string password, string salt)
        {
            string preHash = CombinePasswordAndSalt(password, salt);
            return HashPassword(preHash);
        }

        /// <summary>
        /// Creates a random salt value.
        /// </summary>
        /// <returns></returns>
        public static string CreateRandomSalt()
        {
            return Convert.ToBase64String(Guid.NewGuid().ToByteArray());
        }

        /// <summary>
        /// Returns a string with a password and salt combined.
        /// </summary>
        /// <param name="password">Password.</param>
        /// <param name="salt">Salt.</param>
        /// <returns></returns>
        public static string CombinePasswordAndSalt(string password, string salt)
        {
            //TODO: return salt + "." + password;
            //We're not ready to do this yet till we do it to the blog_content table too.
            return password;
        }

        /// <summary>
        /// Validates if the supplied credentials match the current blog
        /// </summary>
        public static bool IsValidUser(Blog blog, string username, string password)
        {
            if(String.Equals(username, blog.UserName, StringComparison.OrdinalIgnoreCase))
            {
                return IsValidPassword(blog, password);
            }
            Log.DebugFormat("The supplied username '{0}' does not equal the configured username of '{1}'.", username,
                            blog.UserName);
            return false;
        }

        /// <summary>
        /// Check to see if the supplied password matches the password 
        /// for the current blog. This method will check the 
        /// BlogConfigurationSettings to see if the password should be 
        /// Encrypted/Hashed
        /// </summary>
        public static bool IsValidPassword(Blog blog, string password)
        {
            if(blog.IsPasswordHashed)
            {
                password = HashPassword(password);
            }
            string storedPassword = blog.Password;

            if(storedPassword.IndexOf('-') > 0)
            {
                // NOTE: This is necessary because I want to change how 
                // we store the password.  Maybe changing the password 
                // storage is dumb.  Let me know. -Phil
                //	This is an old password created from BitConverter 
                // string.  Converting to a Base64 hash.
                string[] hashBytesStrings = storedPassword.Split('-');
                var hashedBytes = new byte[hashBytesStrings.Length];
                for(int i = 0; i < hashBytesStrings.Length; i++)
                {
                    hashedBytes[i] = byte.Parse(hashBytesStrings[i].ToString(CultureInfo.InvariantCulture),
                                                NumberStyles.HexNumber, CultureInfo.InvariantCulture);
                    storedPassword = Convert.ToBase64String(hashedBytes);
                }
            }

            return String.Equals(password, storedPassword, StringComparison.Ordinal);
        }

        /// <summary>
        /// When we Encrypt/Hash the password, we can not un-Encrypt/Hash the password. If user's need to retrieve this value, all we can
        /// do is reset the passowrd to a new value and send it.
        /// </summary>
        /// <returns>A New Password</returns>
        public static string ResetPassword()
        {
            string password = RandomPassword();

            UpdatePassword(password);

            return password;
        }

        /// <summary>
        /// Updates the current users password to the supplied value. 
        /// Handles hashing (or not hashing of the password)
        /// </summary>
        /// <param name="password">Supplied Password</param>
        public static void UpdatePassword(string password)
        {
            Blog info = Config.CurrentBlog;
            info.Password = Config.CurrentBlog.IsPasswordHashed ? HashPassword(password) : password;
            //Save new password.
            ObjectProvider.Instance().UpdateConfigData(info);
        }

        public static void UpdateHostAdminPassword(string password)
        {
            HostInfo hostInfo = HostInfo.Instance;
            hostInfo.Password = Config.Settings.UseHashedPasswords ? HashPassword(password, HostInfo.Instance.Salt) : password;
            HostInfo.UpdateHost(hostInfo);
        }

        public static string ResetHostAdminPassword()
        {
            string password = RandomPassword();
            UpdateHostAdminPassword(password);
            return password;
        }

        /// <summary>
        /// Generates a "Random Enough" password. :)
        /// </summary>
        /// <returns></returns>
        public static string RandomPassword()
        {
            return Guid.NewGuid().ToString().Substring(0, 8);
        }

        public static bool IsAdministrator(this IPrincipal user)
        {
            if(user == null)
            {
                return false;
            }
            return user.IsInRole("Admins");
        }

        /// <summary>
        /// Returns true if the user is in the specified role.
        /// It's a wrapper to calling the IsInRole method of 
        /// IPrincipal.
        /// </summary>
        /// <param name="role">Role.</param>
        /// <returns></returns>
        public static bool IsInRole(string role)
        {
            if(HttpContext.Current.User == null)
            {
                return false;
            }
            return HttpContext.Current.User.IsInRole(role);
        }

        /// <summary>
        /// Generates the symmetric key.
        /// </summary>
        /// <returns></returns>
        public static byte[] GenerateSymmetricKey()
        {
            SymmetricAlgorithm rijaendel = Rijndael.Create();
            rijaendel.GenerateKey();
            return rijaendel.Key;
        }

        /// <summary>
        /// Generates the symmetric key.
        /// </summary>
        /// <returns></returns>
        public static byte[] GenerateInitializationVector()
        {
            SymmetricAlgorithm rijaendel = Rijndael.Create();
            rijaendel.GenerateIV();
            return rijaendel.IV;
        }

        /// <summary>
        /// Generates the symmetric key.
        /// </summary>
        /// <param name="clearText">The clear text.</param>
        /// <param name="encoding">The encoding.</param>
        /// <param name="key">The key.</param>
        /// <param name="initializationVendor">The initialization vendor.</param>
        /// <returns></returns>
        public static string EncryptString(string clearText, Encoding encoding, byte[] key, byte[] initializationVendor)
        {
            SymmetricAlgorithm rijaendel = Rijndael.Create();
            ICryptoTransform encryptor = rijaendel.CreateEncryptor(key, initializationVendor);
            byte[] clearTextBytes = encoding.GetBytes(clearText);
            byte[] encrypted = encryptor.TransformFinalBlock(clearTextBytes, 0, clearTextBytes.Length);
            return Convert.ToBase64String(encrypted);
        }

        /// <summary>
        /// Decrypts the string.
        /// </summary>
        /// <param name="encryptedBase64EncodedString">The encrypted base64 encoded string.</param>
        /// <param name="encoding">The encoding.</param>
        /// <param name="key">The key.</param>
        /// <param name="initializationVendor">The initialization vendor.</param>
        /// <returns></returns>
        public static string DecryptString(string encryptedBase64EncodedString, Encoding encoding, byte[] key,
                                           byte[] initializationVendor)
        {
            SymmetricAlgorithm rijaendel = Rijndael.Create();
            ICryptoTransform decryptor = rijaendel.CreateDecryptor(key, initializationVendor);
            byte[] encrypted = Convert.FromBase64String(encryptedBase64EncodedString);
            byte[] decrypted = decryptor.TransformFinalBlock(encrypted, 0, encrypted.Length);
            return encoding.GetString(decrypted);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using Ninject;
using Subtext.Configuration;
using Subtext.Framework.Components;
using Subtext.Framework.Properties;
using Subtext.Framework.Providers;
using Subtext.Framework.Text;

namespace Subtext.Framework.Services
{
    public class SlugGenerator : ISlugGenerator
    {
        private const string DefaultWordSeparator = "-";

        private static readonly FriendlyUrlSettings DefaultSettings = GetDefaultSettings();
        static readonly Regex TrailingPeriodRegex = new Regex(@"\.+$", RegexOptions.Compiled);
        static readonly Regex WordCharRegex = new Regex(@"[^\w\d\.\- ]+", RegexOptions.Compiled);

        public SlugGenerator(FriendlyUrlSettings slugSettings)
            : this(slugSettings, null)
        {
        }

        [Inject]
        public SlugGenerator(FriendlyUrlSettings slugSettings, ObjectProvider repository)
        {
            SlugSettings = slugSettings ?? DefaultSettings;
            Repository = repository;
        }

        public FriendlyUrlSettings SlugSettings { get; private set; }

        protected ObjectProvider Repository { get; private set; }

        #region ISlugGenerator Members

        public string GetSlugFromTitle(Entry entry)
        {
            if(entry == null)
            {
                throw new ArgumentNullException("entry");
            }
            if(String.IsNullOrEmpty(entry.Title))
            {
                throw new ArgumentException(Resources.Argument_EntryHasNoTitle, "entry");
            }

            string separator = SlugSettings.SeparatingCharacter;
            if(separator != "_" && separator != "." && separator != "-" && separator != string.Empty)
            {
                separator = DefaultWordSeparator;
            }

            string slug = RemoveNonWordCharacters(entry.Title);
            slug = RemoveTrailingPeriods(slug);

            if(SlugSettings.WordCountLimit > 0)
            {
                IEnumerable<string> words = slug.SplitIntoWords().Take(SlugSettings.WordCountLimit);
                IEnumerable<string> encodedWords = words.Select(word => ReplaceUnicodeCharacters(word));
                if(!String.IsNullOrEmpty(separator))
                {
                    slug = String.Join(separator, encodedWords.ToArray());
                    slug = slug.Trim(new[] { separator[0] });
                }
                else
                {
                    //special case for back compati
                    slug = slug.ToPascalCase();
                }
            }

            if(slug.IsNumeric())
            {
                slug = "n_" + slug;
            }
            slug = EnsureUniqueness(slug, SlugSettings.SeparatingCharacter);
            slug = FriendlyUrlSettings.TransformString(slug, SlugSettings.TextTransformation);

            return slug;
        }

        #endregion

        private static FriendlyUrlSettings GetDefaultSettings()
        {
            var config = new NameValueCollection
            {
                {"textTransform", "LowerCase"},
                {"separatingCharacter", DefaultWordSeparator},
                {"limitWordCount", "10"}
            };
            return new FriendlyUrlSettings(config);
        }

        string EnsureUniqueness(string originalSlug, string separator)
        {
            if(Repository == null)
            {
                return originalSlug;
            }
            var suffixFormats = new[]
            {
                string.Empty, "{0}Again", "{0}Yet{0}Again", "{0}And{0}Again", "{0}Once{0}Again", "{0}Once{0}More",
                "{0}To{0}Beat{0}A{0}Dead{0}Horse"
            };
            IEnumerable<string> slugs =
                suffixFormats.Select(s => originalSlug + String.Format(CultureInfo.InvariantCulture, s, separator));
            string uniqueSlug = slugs.First(slug => Repository.GetEntry(slug, false, false) == null);
            return uniqueSlug;
        }

        private static string RemoveNonWordCharacters(string text)
        {
            return WordCharRegex.Replace(text, string.Empty);
        }

        private static string ReplaceUnicodeCharacters(string text)
        {
            string normalized = text.Normalize(NormalizationForm.FormKD);
            Encoding removal = Encoding.GetEncoding(Encoding.ASCII.CodePage,
                                                    new EncoderReplacementFallback(string.Empty),
                                                    new DecoderReplacementFallback(string.Empty));
            byte[] bytes = removal.GetBytes(normalized);

            string encoded = Encoding.ASCII.GetString(bytes);
            if(String.IsNullOrEmpty(encoded))
            {
                return HttpUtility.UrlEncode(text);
            }
            return encoded;
        }

        private static string RemoveTrailingPeriods(string text)
        {
            return TrailingPeriodRegex.Replace(text, string.Empty);
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.Data.SqlClient;
using System.Web;
using log4net;
using Subtext.Framework.Components;
using Subtext.Framework.Logging;
using Subtext.Framework.Routing;
using Subtext.Framework.Web;

namespace Subtext.Framework.Services
{
    public class StatisticsService : IStatisticsService
    {
        private readonly static ILog Log = new Log();

        public StatisticsService(ISubtextContext context, Configuration.Tracking settings)
        {
            SubtextContext = context;
            Settings = settings;
        }

        public ISubtextContext SubtextContext { get; private set; }

        public Configuration.Tracking Settings { get; private set; }

        public void RecordAggregatorView(EntryView entryView)
        {
            if(!Settings.EnableAggBugs || SubtextContext.HttpContext.Request.HttpMethod == "POST")
            {
                return;
            }

            entryView.PageViewType = PageViewType.AggView;

            try
            {
                SubtextContext.Repository.TrackEntry(entryView);
            }
            catch(SqlException e)
            {
                Log.Error("Could not record Aggregator view", e);
            }
        }

        public void RecordWebView(EntryView entryView)
        {
            if(!Settings.EnableWebStats || SubtextContext.HttpContext.Request.HttpMethod == "POST")
            {
                return;
            }

            entryView.ReferralUrl = GetReferral(SubtextContext);

            entryView.PageViewType = PageViewType.WebView;
            try
            {
                SubtextContext.Repository.TrackEntry(entryView);
            }
            catch(Exception e)
            {
                // extra precautions for web view because it's not done via image bug.
                Log.Error("Could not record Web view", e);
            }
        }

        private static string GetReferral(ISubtextContext context)
        {
            HttpRequestBase request = context.HttpContext.Request;
            Uri uri = request.GetUriReferrerSafe();

            if(uri == null)
            {
                return null;
            }

            string referrerDomain = Blog.StripWwwPrefixFromHost(uri.Host);
            string blogDomain =
                Blog.StripWwwPrefixFromHost(context.UrlHelper.BlogUrl().ToFullyQualifiedUrl(context.Blog).Host);

            if(String.Equals(referrerDomain, blogDomain, StringComparison.OrdinalIgnoreCase))
            {
                return null;
            }

            if(referrerDomain.Length == 0)
            {
                Log.Warn("Somehow the referral was an empty string and not null.");
                return null;
            }

            return uri.ToString();
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Google Code at http://code.google.com/p/subtext/
// The development mailing list is at subtext@googlegroups.com 
//
// This project is licensed under the BSD license.  See the License.txt file for more information.
///////////////////////////////////////////////////////////////////////////////////////////////////

#endregion

using System;
using System.IO;
using System.Text.RegularExpressions;
using System.Web;
using System.Xml;
using Ninject;
using Sgml;

namespace Subtext.Framework.Services
{
    public class XhtmlConverter : ITextTransformation
    {
        static readonly Regex NewLineStripperRegex = new Regex(@">(\r\n)+<!\[CDATA\[", RegexOptions.Compiled);
        private readonly Converter<string, string> _innerTextConverter;
        private readonly SgmlReader _reader;

        [Inject]
        public XhtmlConverter() : this(null, new SgmlReader())
        {
        }

        public XhtmlConverter(Converter<string, string> innerTextConverter) : this(innerTextConverter, new SgmlReader())
        {
        }

        public XhtmlConverter(Converter<string, string> innerTextConverter, SgmlReader sgmlReader)
        {
            _innerTextConverter = innerTextConverter;
            _reader = sgmlReader;
        }

        public string Transform(string original)
        {
            if(string.IsNullOrEmpty(original))
            {
                return string.Empty;
            }
            return ConvertHtmlToXHtml(original, _innerTextConverter);
        }

        /// <summary>
        /// Converts the specified html into XHTML compliant text.
        /// </summary>
        /// <param name="html">html to convert.</param>
        /// <param name="converter">The converter.</param>
        /// <returns></returns>
        private string ConvertHtmlToXHtml(string html, Converter<string, string> converter)
        {
            _reader.DocType = "html";
            _reader.WhitespaceHandling = WhitespaceHandling.All;
            // Hack to fix SF bug #1678030
            html = RemoveNewLineBeforeCdata(html);
            _reader.InputStream = new StringReader(string.Format("<html>{0}</html>", html));
            _reader.CaseFolding = CaseFolding.ToLower;
            var writer = new StringWriter();
            XmlWriter xmlWriter = null;
            try
            {
                xmlWriter = new XmlTextWriter(writer);

                bool insideAnchor = false;
                bool skipRead = false;
                while((skipRead || _reader.Read()) && !_reader.EOF)
                {
                    skipRead = false;
                    switch(_reader.NodeType)
                    {
                        case XmlNodeType.Element:
                            //Special case for anchor tags for the time being. 
                            //We need some way to communicate which elements the current node is nested within 
                            if(_reader.IsEmptyElement)
                            {
                                xmlWriter.WriteStartElement(_reader.LocalName);
                                xmlWriter.WriteAttributes(_reader, true);
                                if(_reader.LocalName == "a" || _reader.LocalName == "script" ||
                                   _reader.LocalName == "iframe" || _reader.LocalName == "object")
                                {
                                    xmlWriter.WriteFullEndElement();
                                }
                                else
                                {
                                    xmlWriter.WriteEndElement();
                                }
                            }
                            else
                            {
                                if(_reader.LocalName == "a")
                                {
                                    insideAnchor = true;
                                }
                                xmlWriter.WriteStartElement(_reader.LocalName);
                                xmlWriter.WriteAttributes(_reader, true);
                            }
                            break;

                        case XmlNodeType.Text:
                            string text = _reader.Value;

                            if(converter != null && !insideAnchor)
                            {
                                xmlWriter.WriteRaw(converter(HttpUtility.HtmlEncode(text)));
                            }
                            else
                            {
                                xmlWriter.WriteString(text);
                            }
                            break;

                        case XmlNodeType.EndElement:
                            if(_reader.LocalName == "a")
                            {
                                insideAnchor = false;
                            }

                            if(_reader.LocalName == "a" || 
                                _reader.LocalName == "script" ||
                               _reader.LocalName == "iframe" || 
                               _reader.LocalName == "object")
                            {
                                xmlWriter.WriteFullEndElement();
                            }
                            else
                            {
                                xmlWriter.WriteEndElement();
                            }
                            break;

                        default:
                            xmlWriter.WriteNode(_reader, true);
                            skipRead = true;
                            break;
                    }
                }
            }
            finally
            {
                if(xmlWriter != null)
                {
                    xmlWriter.Close();
                }
            }

            string xml = writer.ToString();
            return xml.Substring("<html>".Length, xml.Length - "<html></html>".Length);
        }

        // Ugly hack to remove any new line that sits between a tag end
        // and the beginning of a CDATA section.
        // This to make sure the Xhtml is well formatted before processing it
        private static string RemoveNewLineBeforeCdata(string text)
        {
            if(String.IsNullOrEmpty(text))
            {
                return string.Empty;
            }
            return NewLineStripperRegex.Replace(text, "><![CDATA[");
        }
    }
}#region Disclaimer/Info

///////////////////////////////////////////////////////////////////////////////////////////////////
// Subtext WebLog
// 
// Subtext is an open source weblog system that is a fork of the .TEXT
// weblog system.
//
// For updated news and information please visit http://subtextproject.com/
// Subtext is hosted at Go