/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.crypto.CryptoAllPermission;
import javax.crypto.CryptoPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CryptoPolicyParser {
    private Vector<GrantEntry> grantEntries = new Vector();
    private StreamTokenizer st;
    private int lookahead;

    CryptoPolicyParser() {
    }

    void read(Reader reader) throws ParsingException, IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(46, 46);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(47);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.ordinaryChar(47);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.st.parseNumbers();
        Hashtable<String, Vector<String>> hashtable = null;
        this.lookahead = this.st.nextToken();
        while (this.lookahead != -1) {
            if (this.peek("grant")) {
                GrantEntry grantEntry = this.parseGrantEntry(hashtable);
                if (grantEntry != null) {
                    this.grantEntries.addElement(grantEntry);
                }
            } else {
                throw new ParsingException(this.st.lineno(), "expected grant statement");
            }
            this.match(";");
        }
    }

    private GrantEntry parseGrantEntry(Hashtable<String, Vector<String>> hashtable) throws ParsingException, IOException {
        GrantEntry grantEntry = new GrantEntry();
        this.match("grant");
        this.match("{");
        while (!this.peek("}")) {
            if (this.peek("Permission")) {
                CryptoPermissionEntry cryptoPermissionEntry = this.parsePermissionEntry(hashtable);
                grantEntry.add(cryptoPermissionEntry);
                this.match(";");
                continue;
            }
            throw new ParsingException(this.st.lineno(), "expected permission entry");
        }
        this.match("}");
        return grantEntry;
    }

    private CryptoPermissionEntry parsePermissionEntry(Hashtable<String, Vector<String>> hashtable) throws ParsingException, IOException {
        CryptoPermissionEntry cryptoPermissionEntry = new CryptoPermissionEntry();
        this.match("Permission");
        cryptoPermissionEntry.cryptoPermission = this.match("permission type");
        if (cryptoPermissionEntry.cryptoPermission.equals("javax.crypto.CryptoAllPermission")) {
            cryptoPermissionEntry.alg = "CryptoAllPermission";
            cryptoPermissionEntry.maxKeySize = Integer.MAX_VALUE;
            return cryptoPermissionEntry;
        }
        if (this.peek("\"")) {
            cryptoPermissionEntry.alg = this.match("quoted string").toUpperCase(Locale.ENGLISH);
        } else if (this.peek("*")) {
            this.match("*");
            cryptoPermissionEntry.alg = "*";
        } else {
            throw new ParsingException(this.st.lineno(), "Missing the algorithm name");
        }
        this.peekAndMatch(",");
        if (this.peek("\"")) {
            cryptoPermissionEntry.exemptionMechanism = this.match("quoted string").toUpperCase(Locale.ENGLISH);
        }
        this.peekAndMatch(",");
        if (!this.isConsistent(cryptoPermissionEntry.alg, cryptoPermissionEntry.exemptionMechanism, hashtable)) {
            throw new ParsingException(this.st.lineno(), "Inconsistent policy");
        }
        if (this.peek("number")) {
            cryptoPermissionEntry.maxKeySize = this.match();
        } else if (this.peek("*")) {
            this.match("*");
            cryptoPermissionEntry.maxKeySize = Integer.MAX_VALUE;
        } else {
            if (!this.peek(";")) {
                throw new ParsingException(this.st.lineno(), "Missing the maximum allowable key size");
            }
            cryptoPermissionEntry.maxKeySize = Integer.MAX_VALUE;
        }
        this.peekAndMatch(",");
        if (this.peek("\"")) {
            String string = this.match("quoted string");
            Vector<Integer> vector = new Vector<Integer>(1);
            while (this.peek(",")) {
                this.match(",");
                if (this.peek("number")) {
                    vector.addElement(new Integer(this.match()));
                    continue;
                }
                if (this.peek("*")) {
                    this.match("*");
                    vector.addElement(new Integer(Integer.MAX_VALUE));
                    continue;
                }
                throw new ParsingException(this.st.lineno(), "Expecting an integer");
            }
            Object[] objectArray = new Integer[vector.size()];
            vector.copyInto(objectArray);
            cryptoPermissionEntry.checkParam = true;
            cryptoPermissionEntry.algParamSpec = CryptoPolicyParser.getInstance(string, (Integer[])objectArray);
        }
        return cryptoPermissionEntry;
    }

    private static final AlgorithmParameterSpec getInstance(String string, Integer[] integerArray) throws ParsingException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                classArray[i] = Integer.TYPE;
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            algorithmParameterSpec = (AlgorithmParameterSpec)constructor.newInstance(integerArray);
        }
        catch (Exception exception) {
            throw new ParsingException("Cannot call the constructor of " + string + exception);
        }
        return algorithmParameterSpec;
    }

    private boolean peekAndMatch(String string) throws ParsingException, IOException {
        if (this.peek(string)) {
            this.match(string);
            return true;
        }
        return false;
    }

    private boolean peek(String string) {
        boolean bl = false;
        switch (this.lookahead) {
            case -3: {
                if (!string.equalsIgnoreCase(this.st.sval)) break;
                bl = true;
                break;
            }
            case -2: {
                if (!string.equalsIgnoreCase("number")) break;
                bl = true;
                break;
            }
            case 44: {
                if (!string.equals(",")) break;
                bl = true;
                break;
            }
            case 123: {
                if (!string.equals("{")) break;
                bl = true;
                break;
            }
            case 125: {
                if (!string.equals("}")) break;
                bl = true;
                break;
            }
            case 34: {
                if (!string.equals("\"")) break;
                bl = true;
                break;
            }
            case 42: {
                if (!string.equals("*")) break;
                bl = true;
                break;
            }
            case 59: {
                if (!string.equals(";")) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int match() throws ParsingException, IOException {
        int n = -1;
        int n2 = this.st.lineno();
        String string = null;
        switch (this.lookahead) {
            case -2: {
                n = (int)this.st.nval;
                if (n < 0) {
                    string = String.valueOf(this.st.nval);
                }
                this.lookahead = this.st.nextToken();
                break;
            }
            default: {
                string = this.st.sval;
            }
        }
        if (n <= 0) {
            throw new ParsingException(n2, "a non-negative number", string);
        }
        return n;
    }

    private String match(String string) throws ParsingException, IOException {
        String string2 = null;
        switch (this.lookahead) {
            case -2: {
                throw new ParsingException(this.st.lineno(), string, "number " + String.valueOf(this.st.nval));
            }
            case -1: {
                throw new ParsingException("expected " + string + ", read end of file");
            }
            case -3: {
                if (string.equalsIgnoreCase(this.st.sval)) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, this.st.sval);
            }
            case 34: {
                if (string.equalsIgnoreCase("quoted string")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, this.st.sval);
            }
            case 44: {
                if (string.equals(",")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, ",");
            }
            case 123: {
                if (string.equals("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "{");
            }
            case 125: {
                if (string.equals("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "}");
            }
            case 59: {
                if (string.equals(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, ";");
            }
            case 42: {
                if (string.equals("*")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "*");
            }
            default: {
                throw new ParsingException(this.st.lineno(), string, new String(new char[]{(char)this.lookahead}));
            }
        }
        return string2;
    }

    CryptoPermission[] getPermissions() {
        Object[] objectArray;
        Vector<CryptoPermission> vector = new Vector<CryptoPermission>();
        Enumeration<GrantEntry> enumeration = this.grantEntries.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = enumeration.nextElement();
            Enumeration<CryptoPermissionEntry> enumeration2 = objectArray.permissionElements();
            while (enumeration2.hasMoreElements()) {
                CryptoPermissionEntry cryptoPermissionEntry = enumeration2.nextElement();
                if (cryptoPermissionEntry.cryptoPermission.equals("javax.crypto.CryptoAllPermission")) {
                    vector.addElement(CryptoAllPermission.INSTANCE);
                    continue;
                }
                if (cryptoPermissionEntry.checkParam) {
                    vector.addElement(new CryptoPermission(cryptoPermissionEntry.alg, cryptoPermissionEntry.maxKeySize, cryptoPermissionEntry.algParamSpec, cryptoPermissionEntry.exemptionMechanism));
                    continue;
                }
                vector.addElement(new CryptoPermission(cryptoPermissionEntry.alg, cryptoPermissionEntry.maxKeySize, cryptoPermissionEntry.exemptionMechanism));
            }
        }
        objectArray = new CryptoPermission[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private boolean isConsistent(String string, String string2, Hashtable<String, Vector<String>> hashtable) {
        Vector<String> vector;
        String string3;
        String string4 = string3 = string2 == null ? "none" : string2;
        if (hashtable == null) {
            hashtable = new Hashtable();
            Vector<String> vector2 = new Vector<String>(1);
            vector2.addElement(string3);
            hashtable.put(string, vector2);
            return true;
        }
        if (hashtable.containsKey("CryptoAllPermission")) {
            return false;
        }
        if (hashtable.containsKey(string)) {
            vector = hashtable.get(string);
            if (vector.contains(string3)) {
                return false;
            }
        } else {
            vector = new Vector(1);
        }
        vector.addElement(string3);
        hashtable.put(string, vector);
        return true;
    }

    static final class ParsingException
    extends GeneralSecurityException {
        private static final long serialVersionUID = 7147241245566588374L;

        ParsingException(String string) {
            super(string);
        }

        ParsingException(int n, String string) {
            super("line " + n + ": " + string);
        }

        ParsingException(int n, String string, String string2) {
            super("line " + n + ": expected '" + string + "', found '" + string2 + "'");
        }
    }

    private static class CryptoPermissionEntry {
        String cryptoPermission;
        String alg = null;
        String exemptionMechanism = null;
        int maxKeySize = 0;
        boolean checkParam = false;
        AlgorithmParameterSpec algParamSpec = null;

        CryptoPermissionEntry() {
        }

        public int hashCode() {
            int n = this.cryptoPermission.hashCode();
            if (this.alg != null) {
                n ^= this.alg.hashCode();
            }
            if (this.exemptionMechanism != null) {
                n ^= this.exemptionMechanism.hashCode();
            }
            n ^= this.maxKeySize;
            if (this.checkParam) {
                n ^= 0x64;
            }
            if (this.algParamSpec != null) {
                n ^= this.algParamSpec.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CryptoPermissionEntry)) {
                return false;
            }
            CryptoPermissionEntry cryptoPermissionEntry = (CryptoPermissionEntry)object;
            if (this.cryptoPermission == null ? cryptoPermissionEntry.cryptoPermission != null : !this.cryptoPermission.equals(cryptoPermissionEntry.cryptoPermission)) {
                return false;
            }
            if (this.alg == null ? cryptoPermissionEntry.alg != null : !this.alg.equalsIgnoreCase(cryptoPermissionEntry.alg)) {
                return false;
            }
            if (this.maxKeySize != cryptoPermissionEntry.maxKeySize) {
                return false;
            }
            if (this.checkParam != cryptoPermissionEntry.checkParam) {
                return false;
            }
            return !(this.algParamSpec == null ? cryptoPermissionEntry.algParamSpec != null : !this.algParamSpec.equals(cryptoPermissionEntry.algParamSpec));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrantEntry {
        private Vector<CryptoPermissionEntry> permissionEntries = new Vector();

        GrantEntry() {
        }

        void add(CryptoPermissionEntry cryptoPermissionEntry) {
            this.permissionEntries.addElement(cryptoPermissionEntry);
        }

        boolean remove(CryptoPermissionEntry cryptoPermissionEntry) {
            return this.permissionEntries.removeElement(cryptoPermissionEntry);
        }

        boolean contains(CryptoPermissionEntry cryptoPermissionEntry) {
            return this.permissionEntries.contains(cryptoPermissionEntry);
        }

        Enumeration<CryptoPermissionEntry> permissionElements() {
            return this.permissionEntries.elements();
        }
    }
}

