/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.extObjectInputStream;
import sun.misc.JavaxCryptoSealedObjectAccess;
import sun.misc.SharedSecrets;

public class SealedObject
implements Serializable {
    static final long serialVersionUID = 4482838265551344752L;
    private byte[] encryptedContent = null;
    private String sealAlg = null;
    private String paramsAlg = null;
    protected byte[] encodedParams = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SealedObject(Serializable serializable, Cipher cipher) throws IOException, IllegalBlockSizeException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        try {
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        finally {
            objectOutputStream.close();
        }
        try {
            this.encryptedContent = cipher.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        if (cipher.getParameters() != null) {
            this.encodedParams = cipher.getParameters().getEncoded();
            this.paramsAlg = cipher.getParameters().getAlgorithm();
        }
        this.sealAlg = cipher.getAlgorithm();
    }

    protected SealedObject(SealedObject sealedObject) {
        this.encryptedContent = (byte[])sealedObject.encryptedContent.clone();
        this.sealAlg = sealedObject.sealAlg;
        this.paramsAlg = sealedObject.paramsAlg;
        this.encodedParams = (byte[])(sealedObject.encodedParams != null ? (byte[])sealedObject.encodedParams.clone() : null);
    }

    public final String getAlgorithm() {
        return this.sealAlg;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        try {
            return this.unseal(key, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("algorithm not found");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getObject(Cipher cipher) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        ObjectInputStream objectInputStream = this.getExtObjectInputStream(cipher);
        try {
            Object object;
            Object object2 = object = objectInputStream.readObject();
            return object2;
        }
        finally {
            objectInputStream.close();
        }
    }

    public final Object getObject(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            return this.unseal(key, string);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unseal(Key key, String string) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        AlgorithmParameters algorithmParameters = null;
        if (this.encodedParams != null) {
            try {
                algorithmParameters = string != null ? AlgorithmParameters.getInstance(this.paramsAlg, string) : AlgorithmParameters.getInstance(this.paramsAlg);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (string == null) {
                    throw new NoSuchAlgorithmException(this.paramsAlg + " not found");
                }
                throw new NoSuchProviderException(noSuchProviderException.getMessage());
            }
            algorithmParameters.init(this.encodedParams);
        }
        try {
            cipher = string != null ? Cipher.getInstance(this.sealAlg, string) : Cipher.getInstance(this.sealAlg);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new NoSuchAlgorithmException("Padding that was used in sealing operation not available");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            if (string == null) {
                throw new NoSuchAlgorithmException(this.sealAlg + " not found");
            }
            throw new NoSuchProviderException(noSuchProviderException.getMessage());
        }
        try {
            if (algorithmParameters != null) {
                cipher.init(2, key, algorithmParameters);
            } else {
                cipher.init(2, key);
            }
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException.getMessage());
        }
        ObjectInputStream objectInputStream = this.getExtObjectInputStream(cipher);
        try {
            Object object;
            Object object2 = object = objectInputStream.readObject();
            return object2;
        }
        finally {
            objectInputStream.close();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.encryptedContent != null) {
            this.encryptedContent = (byte[])this.encryptedContent.clone();
        }
        if (this.encodedParams != null) {
            this.encodedParams = (byte[])this.encodedParams.clone();
        }
    }

    private ObjectInputStream getExtObjectInputStream(Cipher cipher) throws BadPaddingException, IllegalBlockSizeException, IOException {
        byte[] byArray = cipher.doFinal(this.encryptedContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return new extObjectInputStream(byteArrayInputStream);
    }

    static {
        SharedSecrets.setJavaxCryptoSealedObjectAccess((JavaxCryptoSealedObjectAccess)new JavaxCryptoSealedObjectAccess(){

            public ObjectInputStream getExtObjectInputStream(SealedObject sealedObject, Cipher cipher) throws BadPaddingException, IllegalBlockSizeException, IOException {
                return sealedObject.getExtObjectInputStream(cipher);
            }
        });
    }
}

