/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsPrfParameterSpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_TLS_PRF_PARAMS;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11TlsPrfGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "TlsPrfGenerator must be initialized using a TlsPrfParameterSpec";
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private TlsPrfParameterSpec spec;
    private P11Key p11Key;
    private static final SecretKey NULL_KEY = new SecretKey(){
        private static final long serialVersionUID = -8090049519656411362L;

        public byte[] getEncoded() {
            return new byte[0];
        }

        public String getFormat() {
            return "RAW";
        }

        public String getAlgorithm() {
            return "Generic";
        }
    };

    P11TlsPrfGenerator(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        this.mechanism = l;
    }

    protected void engineInit(SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof TlsPrfParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsPrfParameterSpec)algorithmParameterSpec;
        SecretKey secretKey = this.spec.getSecret();
        if (secretKey == null) {
            secretKey = NULL_KEY;
        }
        try {
            this.p11Key = P11SecretKeyFactory.convertKey(this.token, secretKey, null);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidAlgorithmParameterException("init() failed", invalidKeyException);
        }
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new InvalidParameterException(MSG);
    }

    protected SecretKey engineGenerateKey() {
        if (this.spec == null) {
            throw new IllegalStateException("TlsPrfGenerator must be initialized");
        }
        byte[] byArray = P11Util.getBytesUTF8(this.spec.getLabel());
        byte[] byArray2 = this.spec.getSeed();
        if (this.mechanism == 2147484531L) {
            Session session = null;
            try {
                session = this.token.getOpSession();
                this.token.p11.C_SignInit(session.id(), new CK_MECHANISM(this.mechanism), this.p11Key.keyID);
                this.token.p11.C_SignUpdate(session.id(), 0L, byArray, 0, byArray.length);
                this.token.p11.C_SignUpdate(session.id(), 0L, byArray2, 0, byArray2.length);
                byte[] byArray3 = this.token.p11.C_SignFinal(session.id(), this.spec.getOutputLength());
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "TlsPrf");
                return secretKeySpec;
            }
            catch (PKCS11Exception pKCS11Exception) {
                throw new ProviderException("Could not calculate PRF", pKCS11Exception);
            }
            finally {
                this.token.releaseSession(session);
            }
        }
        byte[] byArray4 = new byte[this.spec.getOutputLength()];
        CK_TLS_PRF_PARAMS cK_TLS_PRF_PARAMS = new CK_TLS_PRF_PARAMS(byArray2, byArray, byArray4);
        Session session = null;
        try {
            session = this.token.getOpSession();
            long l = this.token.p11.C_DeriveKey(session.id(), new CK_MECHANISM(this.mechanism, cK_TLS_PRF_PARAMS), this.p11Key.keyID, null);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, "TlsPrf");
            return secretKeySpec;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("Could not calculate PRF", pKCS11Exception);
        }
        finally {
            this.token.releaseSession(session);
        }
    }
}

