/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import sun.tools.jconsole.inspector.TableSorter;
import sun.tools.jconsole.inspector.Utils;

public abstract class XTable
extends JTable {
    static final int NAME_COLUMN = 0;
    static final int VALUE_COLUMN = 1;
    private Color defaultColor;
    private Color editableColor;
    private Color errorColor;
    private Font normalFont;
    private Font boldFont;

    public XTable() {
        TableSorter tableSorter = new TableSorter();
        this.setModel(tableSorter);
        tableSorter.addMouseListenerToHeaderInTable(this);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setAutoResizeMode(3);
    }

    Color getDefaultColor() {
        return this.defaultColor;
    }

    Color getEditableColor() {
        return this.editableColor;
    }

    public int getSelectedIndex() {
        return this.convertRowToIndex(this.getSelectedRow());
    }

    public int convertRowToIndex(int n) {
        if (n == -1) {
            return n;
        }
        if (this.getModel() instanceof TableSorter) {
            return ((TableSorter)this.getModel()).getInvertedIndex()[n];
        }
        return n;
    }

    public void emptyTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
    }

    public abstract boolean isTableEditable();

    public abstract boolean isColumnEditable(int var1);

    public abstract boolean isReadable(int var1);

    public abstract boolean isWritable(int var1);

    public abstract boolean isCellError(int var1, int var2);

    public abstract boolean isAttributeViewable(int var1, int var2);

    public abstract void setTableValue(Object var1, int var2);

    public abstract Object getValue(int var1);

    public abstract String getClassName(int var1);

    public abstract String getValueName(int var1);

    public boolean isReadWrite(int n) {
        return this.isReadable(n) && this.isWritable(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.isTableEditable() && this.isColumnEditable(n2) && this.isWritable(n) && Utils.isEditableType(this.getClassName(n));
    }

    public boolean isCellDroppable(int n, int n2) {
        return this.isTableEditable() && this.isColumnEditable(n2) && this.isWritable(n);
    }

    public String getToolTip(int n, int n2) {
        return null;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getCellRenderer(n, n2);
        defaultTableCellRenderer.setToolTipText(this.getToolTip(n, n2));
        if (this.defaultColor == null) {
            this.defaultColor = defaultTableCellRenderer.getForeground();
            this.editableColor = Color.blue;
            this.errorColor = Color.red;
            if (this.defaultColor == null) {
                return defaultTableCellRenderer;
            }
        }
        if (n2 != 1) {
            defaultTableCellRenderer.setForeground(this.defaultColor);
            return defaultTableCellRenderer;
        }
        if (this.isCellError(n, n2)) {
            defaultTableCellRenderer.setForeground(this.errorColor);
        } else if (this.isCellEditable(n, n2)) {
            defaultTableCellRenderer.setForeground(this.editableColor);
        } else {
            defaultTableCellRenderer.setForeground(this.defaultColor);
        }
        return defaultTableCellRenderer;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (this.normalFont == null) {
            this.normalFont = component.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }
        if (n2 == 1 && this.isAttributeViewable(n, 1)) {
            component.setFont(this.boldFont);
        } else {
            component.setFont(this.normalFont);
        }
        return component;
    }
}

