/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XObject;
import sun.tools.jconsole.inspector.XOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XTextField
extends JPanel
implements DocumentListener,
ActionListener {
    private XObject selectedObject;
    protected JTextField textField;
    private static boolean allowNullSelection = false;
    protected static final int COMPATIBLE_VALUE = 1;
    protected static final int CURRENT_VALUE = 2;
    protected static final int NULL_VALUE = 3;
    private JButton button;
    private XOperations operation;

    public XTextField() {
        super(new BorderLayout());
        this.textField = new JTextField();
        this.add((Component)this.textField, "Center");
        this.textField.addActionListener(this);
    }

    public XTextField(Object object) {
        this(object, object.toString().length());
    }

    public XTextField(Object object, int n) {
        this(object, object.getClass(), n, true, null, null);
    }

    public XTextField(Object object, Class<?> clazz, int n, boolean bl, JButton jButton, XOperations xOperations) {
        super(new BorderLayout());
        boolean bl2;
        this.button = jButton;
        this.operation = xOperations;
        this.textField = new JTextField(object.toString(), n);
        this.add((Component)this.textField, "Center");
        if (bl) {
            this.textField.addActionListener(this);
        }
        if ((bl2 = Utils.isEditableType(clazz.getName())) && bl) {
            this.textField.setEditable(true);
        } else {
            this.textField.setEditable(false);
        }
    }

    public static void setNullSelectionAllowed(boolean bl) {
        allowNullSelection = bl;
    }

    public static boolean getNullSelectionAllowed() {
        return allowNullSelection;
    }

    protected void init(Object object, Class<?> clazz) {
        boolean bl = Utils.isEditableType(clazz.getName());
        this.clearObject();
        if (object != null) {
            this.textField.setText(object.toString());
        } else {
            this.textField.setText("");
        }
        this.textField.setToolTipText(null);
        if (bl) {
            if (!this.textField.isEditable()) {
                this.textField.setEditable(true);
            }
        } else if (this.textField.isEditable()) {
            this.textField.setEditable(false);
        }
    }

    private synchronized void clearObject() {
        this.textField.getDocument().removeDocumentListener(this);
        this.selectedObject = null;
        this.setDefaultColors();
    }

    private synchronized void setDefaultColors() {
    }

    public void setHorizontalAlignment(int n) {
        this.textField.setHorizontalAlignment(n);
    }

    protected JMenuItem buildJMenuItem(XObject xObject, int n) {
        if (n == 1) {
            return new JMenuItem(xObject.getText());
        }
        if (n == 2) {
            return new JMenuItem("> " + xObject.getText());
        }
        if (n == 3) {
            return new JMenuItem("null");
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField && this.operation != null) {
            this.operation.performInvokeRequest(this.button);
        }
    }

    public Object getValue() {
        if (this.selectedObject != null) {
            if (this.selectedObject == XObject.NULL_OBJECT) {
                return null;
            }
            return this.selectedObject;
        }
        return this.textField.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.clearObject();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.clearObject();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.clearObject();
    }
}

