/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.EventQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanInfo;
import sun.tools.jconsole.inspector.XNodeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XTree
extends JTree {
    private static final List<String> orderedKeyPropertyList = new ArrayList<String>();
    private MBeansTab mbeansTab;
    private Map<String, DefaultMutableTreeNode> nodes = new HashMap<String, DefaultMutableTreeNode>();
    private boolean treeView;
    private boolean treeViewInit = false;
    private boolean keyValueView = Boolean.getBoolean("keyValueView");

    public XTree(MBeansTab mBeansTab) {
        this((TreeNode)new DefaultMutableTreeNode("MBeanTreeRootNode"), mBeansTab);
    }

    public XTree(TreeNode treeNode, MBeansTab mBeansTab) {
        super(treeNode);
        this.mbeansTab = mBeansTab;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private synchronized void removeChildNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
    }

    private synchronized void addChildNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        boolean bl = defaultMutableTreeNode3.isLeaf();
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
        if (bl) {
            defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode3);
        }
    }

    private synchronized void addChildNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        int n = defaultMutableTreeNode.getChildCount();
        if (n == 0) {
            this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, 0);
        } else if (defaultMutableTreeNode2 instanceof ComparableDefaultMutableTreeNode) {
            int n2;
            ComparableDefaultMutableTreeNode comparableDefaultMutableTreeNode = (ComparableDefaultMutableTreeNode)defaultMutableTreeNode2;
            for (n2 = 0; n2 < n; ++n2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
                if (comparableDefaultMutableTreeNode.compareTo(defaultMutableTreeNode3) < 0) {
                    this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n2);
                    break;
                }
                if (comparableDefaultMutableTreeNode.compareTo(defaultMutableTreeNode3) != 0) continue;
                this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n2);
                break;
            }
            if (n2 == n) {
                this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n);
            }
        } else {
            this.addChildNode(defaultMutableTreeNode, defaultMutableTreeNode2, n);
        }
    }

    @Override
    public synchronized void removeAll() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        defaultMutableTreeNode.removeAllChildren();
        defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
        this.nodes.clear();
    }

    public void delMBeanFromView(final ObjectName objectName) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                XTree xTree = XTree.this;
                synchronized (xTree) {
                    DefaultMutableTreeNode defaultMutableTreeNode = null;
                    Dn dn = XTree.this.buildDn(objectName);
                    if (dn.size() > 0) {
                        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)XTree.this.getModel();
                        Token token = dn.getToken(0);
                        String string = dn.getHashKey(token);
                        defaultMutableTreeNode = (DefaultMutableTreeNode)XTree.this.nodes.get(string);
                        if (defaultMutableTreeNode != null && !defaultMutableTreeNode.isRoot()) {
                            if (XTree.this.hasMBeanChildren(defaultMutableTreeNode)) {
                                XTree.this.removeNonMBeanChildren(defaultMutableTreeNode);
                                String string2 = token.getValue().toString();
                                XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.NONMBEAN, string2, string2, token.toString());
                                XTree.this.changeNodeValue(defaultMutableTreeNode, xNodeInfo);
                            } else {
                                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                                defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
                                XTree.this.nodes.remove(string);
                                XTree.this.delParentFromView(dn, 1, defaultMutableTreeNode2);
                            }
                        }
                    }
                }
            }
        });
    }

    private boolean hasMBeanChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!((XNodeInfo)defaultMutableTreeNode2.getUserObject()).getType().equals((Object)XNodeInfo.Type.MBEAN)) continue;
            return true;
        }
        return false;
    }

    private void removeNonMBeanChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        HashSet<DefaultMutableTreeNode> hashSet = new HashSet<DefaultMutableTreeNode>();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (((XNodeInfo)defaultMutableTreeNode2.getUserObject()).getType().equals((Object)XNodeInfo.Type.MBEAN)) continue;
            hashSet.add(defaultMutableTreeNode2);
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode2 : hashSet) {
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    private DefaultMutableTreeNode delParentFromView(Dn dn, int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (!defaultMutableTreeNode.isRoot() && defaultMutableTreeNode.isLeaf() && !((XNodeInfo)defaultMutableTreeNode.getUserObject()).getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this.removeChildNode(defaultMutableTreeNode);
            String string = dn.getHashKey(dn.getToken(n));
            this.nodes.remove(string);
            this.delParentFromView(dn, n + 1, defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public synchronized void addMBeanToView(final ObjectName objectName) {
        XMBean xMBean;
        try {
            xMBean = new XMBean(objectName, this.mbeansTab);
            if (xMBean == null) {
                return;
            }
        }
        catch (Exception exception) {
            if (JConsole.isDebug()) {
                exception.printStackTrace();
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                XTree xTree = XTree.this;
                synchronized (xTree) {
                    Object object;
                    Object object2;
                    Dn dn = XTree.this.buildDn(objectName);
                    if (dn.size() == 0) {
                        return;
                    }
                    Token token = dn.getToken(0);
                    Object object3 = null;
                    boolean bl = true;
                    String string = dn.getHashKey(token);
                    if (XTree.this.nodes.containsKey(string)) {
                        object3 = (DefaultMutableTreeNode)XTree.this.nodes.get(string);
                        Object object4 = XTree.this.createNodeValue(xMBean, token);
                        object2 = object4.toString();
                        object = new XNodeInfo(XNodeInfo.Type.MBEAN, object4, (String)object2, objectName.toString());
                        XTree.this.changeNodeValue((DefaultMutableTreeNode)object3, (XNodeInfo)object);
                        bl = false;
                    } else {
                        object3 = XTree.this.createDnNode(dn, token, xMBean);
                        if (object3 != null) {
                            XTree.this.nodes.put(string, object3);
                            bl = true;
                        } else {
                            return;
                        }
                    }
                    for (int i = 1; i < dn.size(); ++i) {
                        object2 = null;
                        token = dn.getToken(i);
                        string = dn.getHashKey(token);
                        if (XTree.this.nodes.containsKey(string)) {
                            if (bl) {
                                object2 = (DefaultMutableTreeNode)XTree.this.nodes.get(string);
                                XTree.this.addChildNode((DefaultMutableTreeNode)object2, (DefaultMutableTreeNode)object3);
                                return;
                            }
                            return;
                        }
                        if (token.getKeyDn().equals("domain")) {
                            object2 = XTree.this.createDomainNode(dn, token);
                            if (object2 != null) {
                                object = (DefaultMutableTreeNode)XTree.this.getModel().getRoot();
                                XTree.this.addChildNode((DefaultMutableTreeNode)object, (DefaultMutableTreeNode)object2);
                            }
                        } else {
                            object2 = XTree.this.createSubDnNode(dn, token);
                            if (object2 == null) continue;
                        }
                        XTree.this.nodes.put(string, object2);
                        XTree.this.addChildNode((DefaultMutableTreeNode)object2, (DefaultMutableTreeNode)object3);
                        bl = true;
                        object3 = object2;
                    }
                }
            }
        });
    }

    private synchronized void changeNodeValue(DefaultMutableTreeNode defaultMutableTreeNode, XNodeInfo xNodeInfo) {
        Serializable serializable;
        if (defaultMutableTreeNode instanceof ComparableDefaultMutableTreeNode) {
            serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
            ((DefaultMutableTreeNode)serializable).setUserObject(xNodeInfo);
            if (((ComparableDefaultMutableTreeNode)defaultMutableTreeNode).compareTo((DefaultMutableTreeNode)serializable) == 0) {
                defaultMutableTreeNode.setUserObject(xNodeInfo);
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
                defaultTreeModel.nodeChanged(defaultMutableTreeNode);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                this.removeChildNode(defaultMutableTreeNode);
                defaultMutableTreeNode.setUserObject(xNodeInfo);
                this.addChildNode(defaultMutableTreeNode2, defaultMutableTreeNode);
            }
        } else {
            defaultMutableTreeNode.setUserObject(xNodeInfo);
            serializable = (DefaultTreeModel)this.getModel();
            ((DefaultTreeModel)serializable).nodeChanged(defaultMutableTreeNode);
        }
        if (xNodeInfo.getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            XMBeanInfo.loadInfo(defaultMutableTreeNode);
            serializable = (DefaultTreeModel)this.getModel();
            ((DefaultTreeModel)serializable).nodeStructureChanged(defaultMutableTreeNode);
        }
        if (defaultMutableTreeNode == this.getLastSelectedPathComponent()) {
            serializable = this.getSelectionPath();
            this.clearSelection();
            this.setSelectionPath((TreePath)serializable);
        }
    }

    private DefaultMutableTreeNode createDomainNode(Dn dn, Token token) {
        ComparableDefaultMutableTreeNode comparableDefaultMutableTreeNode = new ComparableDefaultMutableTreeNode();
        String string = dn.getDomain();
        XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.NONMBEAN, string, string, string);
        comparableDefaultMutableTreeNode.setUserObject(xNodeInfo);
        return comparableDefaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createDnNode(Dn dn, Token token, XMBean xMBean) {
        ComparableDefaultMutableTreeNode comparableDefaultMutableTreeNode = new ComparableDefaultMutableTreeNode();
        Object object = this.createNodeValue(xMBean, token);
        String string = object.toString();
        XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.MBEAN, object, string, xMBean.getObjectName().toString());
        comparableDefaultMutableTreeNode.setUserObject(xNodeInfo);
        XMBeanInfo.loadInfo(comparableDefaultMutableTreeNode);
        return comparableDefaultMutableTreeNode;
    }

    private DefaultMutableTreeNode createSubDnNode(Dn dn, Token token) {
        ComparableDefaultMutableTreeNode comparableDefaultMutableTreeNode = new ComparableDefaultMutableTreeNode();
        String string = this.isKeyValueView() ? token.toString() : token.getValue().toString();
        XNodeInfo xNodeInfo = new XNodeInfo(XNodeInfo.Type.NONMBEAN, string, string, token.toString());
        comparableDefaultMutableTreeNode.setUserObject(xNodeInfo);
        return comparableDefaultMutableTreeNode;
    }

    private Object createNodeValue(XMBean xMBean, Token token) {
        String string = this.isKeyValueView() ? token.toString() : token.getValue().toString();
        xMBean.setText(string);
        return xMBean;
    }

    private Map<String, String> extractKeyValuePairs(String string, ObjectName objectName) {
        String string2 = string;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n = string2.indexOf("=");
        while (n != -1) {
            String string3 = string2.substring(0, n);
            String string4 = objectName.getKeyProperty(string3);
            linkedHashMap.put(string3, string4);
            string2 = string2.substring(string3.length() + 1 + string4.length());
            if (string2.startsWith(",")) {
                string2 = string2.substring(1);
            }
            n = string2.indexOf("=");
        }
        return linkedHashMap;
    }

    private String getKeyPropertyListString(ObjectName objectName) {
        String string = objectName.getKeyPropertyListString();
        Map<String, String> map = this.extractKeyValuePairs(string, objectName);
        StringBuilder stringBuilder = new StringBuilder();
        for (String object : orderedKeyPropertyList) {
            if (!map.containsKey(object)) continue;
            stringBuilder.append(object + "=" + map.get(object) + ",");
            map.remove(object);
        }
        for (Map.Entry entry : map.entrySet()) {
            stringBuilder.append((String)entry.getKey() + "=" + (String)entry.getValue() + ",");
        }
        Object object = stringBuilder.toString();
        object = ((String)object).substring(0, ((String)object).length() - 1);
        return object;
    }

    private Dn buildDn(ObjectName objectName) {
        String string = objectName.getDomain();
        String string2 = this.getKeyPropertyListString(objectName);
        Dn dn = this.buildDn(string, string2, objectName);
        dn.updateDn();
        dn.reverseOrder();
        dn.computeHashDn();
        return dn;
    }

    private Dn buildDn(String string, String string2, ObjectName objectName) {
        Dn dn = new Dn(string, string2);
        String string3 = "no_key";
        if (this.isTreeView()) {
            String string4 = string2;
            Map<String, String> map = this.extractKeyValuePairs(string4, objectName);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                dn.addToken(new Token(string3, entry.getKey() + "=" + entry.getValue()));
            }
        } else {
            dn.addToken(new Token(string3, "properties=" + string2));
        }
        return dn;
    }

    public boolean isTreeView() {
        if (!this.treeViewInit) {
            this.treeView = this.getTreeViewValue();
            this.treeViewInit = true;
        }
        return this.treeView;
    }

    private boolean getTreeViewValue() {
        String string = System.getProperty("treeView");
        return string == null ? true : !string.equals("false");
    }

    public boolean isKeyValueView() {
        return this.keyValueView;
    }

    static {
        String string = System.getProperty("com.sun.tools.jconsole.mbeans.keyPropertyList");
        if (string == null) {
            orderedKeyPropertyList.add("type");
            orderedKeyPropertyList.add("j2eeType");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                orderedKeyPropertyList.add(stringTokenizer.nextToken());
            }
        }
    }

    public static class Token {
        private String keyDn;
        private String token;
        private String hashToken;
        private String key;
        private String value;

        public Token(String string, String string2) {
            this.keyDn = string;
            this.token = string2;
            this.buildKeyValue();
        }

        public Token(String string, String string2, String string3) {
            this.keyDn = string;
            this.token = string2;
            this.hashToken = string3;
            this.buildKeyValue();
        }

        public String getKeyDn() {
            return this.keyDn;
        }

        public String getToken() {
            return this.token;
        }

        public void setValue(String string) {
            this.value = string;
            this.token = this.key + "=" + string;
        }

        public void setKey(String string) {
            this.key = string;
            this.token = string + "=" + this.value;
        }

        public void setKeyDn(String string) {
            this.keyDn = string;
        }

        public void setHashToken(String string) {
            this.hashToken = string;
        }

        public String getHashToken() {
            return this.hashToken;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getToken();
        }

        public boolean equals(Object object) {
            if (object instanceof Token) {
                return this.token.equals((Token)object);
            }
            return false;
        }

        private void buildKeyValue() {
            int n = this.token.indexOf("=");
            if (n < 0) {
                this.key = this.token;
                this.value = this.token;
            } else {
                this.key = this.token.substring(0, n);
                this.value = this.token.substring(n + 1, this.token.length());
            }
        }
    }

    public static class Dn {
        private String domain;
        private String dn;
        private String hashDn;
        private ArrayList<Token> tokens = new ArrayList();

        public Dn(String string, String string2) {
            this.domain = string;
            this.dn = string2;
        }

        public void clearTokens() {
            this.tokens.clear();
        }

        public void addToken(Token token) {
            this.tokens.add(token);
        }

        public void addToken(int n, Token token) {
            this.tokens.add(n, token);
        }

        public void setToken(int n, Token token) {
            this.tokens.set(n, token);
        }

        public void removeToken(int n) {
            this.tokens.remove(n);
        }

        public Token getToken(int n) {
            return this.tokens.get(n);
        }

        public void reverseOrder() {
            ArrayList<Token> arrayList = new ArrayList<Token>(this.tokens.size());
            for (int i = this.tokens.size() - 1; i >= 0; --i) {
                arrayList.add(this.tokens.get(i));
            }
            this.tokens = arrayList;
        }

        public int size() {
            return this.tokens.size();
        }

        public String getDomain() {
            return this.domain;
        }

        public String getDn() {
            return this.dn;
        }

        public String getHashDn() {
            return this.hashDn;
        }

        public String getHashKey(Token token) {
            int n = this.getHashDn().indexOf(token.getHashToken());
            return this.getHashDn().substring(n, this.getHashDn().length());
        }

        public void computeHashDn() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.tokens.size();
            for (int i = 0; i < n; ++i) {
                Token token = this.tokens.get(i);
                String string = token.getHashToken();
                if (string == null) {
                    string = token.getToken() + (n - i);
                    token.setHashToken(string);
                }
                stringBuilder.append(string);
                stringBuilder.append(",");
            }
            this.hashDn = n > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : "";
        }

        public void updateDn() {
            this.addToken(0, new Token("domain", "domain=" + this.getDomain()));
        }

        public String toString() {
            return this.tokens.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComparableDefaultMutableTreeNode
    extends DefaultMutableTreeNode
    implements Comparable<DefaultMutableTreeNode> {
        @Override
        public int compareTo(DefaultMutableTreeNode defaultMutableTreeNode) {
            return this.toString().compareTo(defaultMutableTreeNode.toString());
        }
    }
}

