/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.ServicePermission;
import sun.security.action.GetPropertyAction;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtendedMasterSecretExtension;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.RenegotiationInfoExtension;
import sun.security.ssl.SSLAlgorithmDecomposer;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SupportedEllipticCurvesExtension;
import sun.security.util.AlgorithmConstraints;
import sun.security.util.KeyUtil;
import sun.security.util.LegacyAlgorithmConstraints;

final class ServerHandshaker
extends Handshaker {
    private byte doClientAuth;
    private X509Certificate[] certs;
    private PrivateKey privateKey;
    private KerberosKey[] kerberosKeys;
    private boolean needClientVerify = false;
    private PrivateKey tempPrivateKey;
    private PublicKey tempPublicKey;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private ProtocolVersion clientRequestedVersion;
    private SupportedEllipticCurvesExtension requestedCurves;
    private static final AlgorithmConstraints legacyAlgorithmConstraints = new LegacyAlgorithmConstraints("jdk.tls.legacyAlgorithms", new SSLAlgorithmDecomposer());
    private static final boolean useSmartEphemeralDHKeys;
    private static final boolean useLegacyEphemeralDHKeys;
    private static final int customizedDHKeySize;

    ServerHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, byte by, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, by != 0, false, protocolVersion, bl, bl2, byArray, byArray2);
        this.doClientAuth = by;
    }

    ServerHandshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, byte by, ProtocolVersion protocolVersion, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) {
        super(sSLEngineImpl, sSLContextImpl, protocolList, by != 0, false, protocolVersion, bl, bl2, byArray, byArray2);
        this.doClientAuth = by;
    }

    void setClientAuth(byte by) {
        this.doClientAuth = by;
    }

    void processMessage(byte by, int n) throws IOException {
        if (this.state >= by && this.state != 16 && by != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + this.state + ", type = " + by);
        }
        switch (by) {
            case 1: {
                HandshakeMessage.ClientHello clientHello = new HandshakeMessage.ClientHello(this.input, n);
                this.clientHello(clientHello);
                break;
            }
            case 11: {
                if (this.doClientAuth == 0) {
                    this.fatalSE((byte)10, "client sent unsolicited cert chain");
                }
                this.clientCertificate(new HandshakeMessage.CertificateMsg(this.input));
                break;
            }
            case 16: {
                SecretKey secretKey;
                switch (this.keyExchange) {
                    case K_RSA: 
                    case K_RSA_EXPORT: {
                        RSAClientKeyExchange rSAClientKeyExchange = new RSAClientKeyExchange(this.protocolVersion, this.clientRequestedVersion, this.sslContext.getSecureRandom(), this.input, n, this.privateKey);
                        secretKey = this.clientKeyExchange(rSAClientKeyExchange);
                        break;
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        secretKey = this.clientKeyExchange(new KerberosClientKeyExchange(this.protocolVersion, this.clientRequestedVersion, this.sslContext.getSecureRandom(), this.input, this.kerberosKeys));
                        break;
                    }
                    case K_DHE_RSA: 
                    case K_DHE_DSS: 
                    case K_DH_ANON: {
                        secretKey = this.clientKeyExchange(new DHClientKeyExchange(this.input));
                        break;
                    }
                    case K_ECDH_RSA: 
                    case K_ECDH_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDHE_ECDSA: 
                    case K_ECDH_ANON: {
                        secretKey = this.clientKeyExchange(new ECDHClientKeyExchange(this.input));
                        break;
                    }
                    default: {
                        throw new SSLProtocolException("Unrecognized key exchange: " + (Object)((Object)this.keyExchange));
                    }
                }
                if (this.session.getUseExtendedMasterSecret()) {
                    this.input.digestNow();
                }
                this.calculateKeys(secretKey, this.clientRequestedVersion);
                break;
            }
            case 15: {
                this.clientCertificateVerify(new HandshakeMessage.CertificateVerify(this.input));
                break;
            }
            case 20: {
                if (!this.receivedChangeCipherSpec()) {
                    this.fatalSE((byte)40, "Received Finished message before ChangeCipherSpec");
                }
                this.clientFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by);
            }
        }
        if (this.state < by) {
            this.state = by == 15 ? by + 2 : (int)by;
        }
    }

    private void clientHello(HandshakeMessage.ClientHello clientHello) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        RenegotiationInfoExtension renegotiationInfoExtension;
        if (debug != null && Debug.isOn("handshake")) {
            clientHello.print(System.out);
        }
        boolean bl = false;
        CipherSuiteList cipherSuiteList = clientHello.getCipherSuites();
        if (cipherSuiteList.contains(CipherSuite.C_SCSV)) {
            bl = true;
            if (this.isInitialHandshake) {
                this.secureRenegotiation = true;
            } else if (this.secureRenegotiation) {
                this.fatalSE((byte)40, "The SCSV is present in a secure renegotiation");
            } else {
                this.fatalSE((byte)40, "The SCSV is present in a insecure renegotiation");
            }
        }
        if ((renegotiationInfoExtension = (RenegotiationInfoExtension)clientHello.extensions.get(ExtensionType.EXT_RENEGOTIATION_INFO)) != null) {
            bl = true;
            if (this.isInitialHandshake) {
                if (!renegotiationInfoExtension.isEmpty()) {
                    this.fatalSE((byte)40, "The renegotiation_info field is not empty");
                }
                this.secureRenegotiation = true;
            } else {
                if (!this.secureRenegotiation) {
                    this.fatalSE((byte)40, "The renegotiation_info is present in a insecure renegotiation");
                }
                if (!MessageDigest.isEqual(this.clientVerifyData, renegotiationInfoExtension.getRenegotiatedConnection())) {
                    this.fatalSE((byte)40, "Incorrect verify data in ClientHello renegotiation_info message");
                }
            }
        } else if (!this.isInitialHandshake && this.secureRenegotiation) {
            this.fatalSE((byte)40, "Inconsistent secure renegotiation indication");
        }
        if (!bl || !this.secureRenegotiation) {
            if (this.isInitialHandshake) {
                if (!allowLegacyHelloMessages) {
                    this.fatalSE((byte)40, "Failed to negotiate the use of secure renegotiation");
                }
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Warning: No renegotiation indication in ClientHello, allow legacy ClientHello");
                }
            } else if (!allowUnsafeRenegotiation) {
                if (this.activeProtocolVersion.v >= ProtocolVersion.TLS10.v) {
                    this.warningSE((byte)100);
                    this.invalidated = true;
                    if (this.input.available() > 0) {
                        this.fatalSE((byte)10, "ClientHello followed by an unexpected  handshake message");
                    }
                    return;
                }
                this.fatalSE((byte)40, "Renegotiation is not allowed");
            } else if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Warning: continue with insecure renegotiation");
            }
        }
        if (useExtendedMasterSecret) {
            object4 = (ExtendedMasterSecretExtension)clientHello.extensions.get(ExtensionType.EXT_EXTENDED_MASTER_SECRET);
            if (object4 != null) {
                this.requestedToUseEMS = true;
            } else if (clientHello.protocolVersion.v >= ProtocolVersion.TLS10.v && !allowLegacyMasterSecret) {
                this.fatalSE((byte)40, "Extended Master Secret extension is required");
            }
        }
        this.input.digestNow();
        object4 = new HandshakeMessage.ServerHello();
        this.clientRequestedVersion = clientHello.protocolVersion;
        ProtocolVersion protocolVersion = this.selectProtocolVersion(this.clientRequestedVersion);
        if (protocolVersion == null || protocolVersion.v == ProtocolVersion.SSL20Hello.v) {
            this.fatalSE((byte)40, "Client requested protocol " + this.clientRequestedVersion + " not enabled or not supported");
        }
        this.setVersion(protocolVersion);
        ((HandshakeMessage.ServerHello)object4).protocolVersion = this.protocolVersion;
        this.clnt_random = clientHello.clnt_random;
        ((HandshakeMessage.ServerHello)object4).svr_random = this.svr_random = new RandomCookie(this.sslContext.getSecureRandom());
        this.session = null;
        if (clientHello.sessionId.length() != 0 && (object3 = ((SSLSessionContextImpl)this.sslContext.engineGetServerSessionContext()).get(clientHello.sessionId.getId())) != null) {
            this.resumingSession = ((SSLSessionImpl)object3).isRejoinable();
            if (this.resumingSession && (object2 = ((SSLSessionImpl)object3).getProtocolVersion()) != clientHello.protocolVersion) {
                this.resumingSession = false;
            }
            if (this.resumingSession && useExtendedMasterSecret) {
                if (this.requestedToUseEMS && !((SSLSessionImpl)object3).getUseExtendedMasterSecret()) {
                    this.resumingSession = false;
                } else if (!this.requestedToUseEMS && ((SSLSessionImpl)object3).getUseExtendedMasterSecret()) {
                    this.fatalSE((byte)40, "Missing Extended Master Secret extension on session resumption");
                } else if (!this.requestedToUseEMS && !((SSLSessionImpl)object3).getUseExtendedMasterSecret()) {
                    if (!allowLegacyResumption) {
                        this.fatalSE((byte)40, "Missing Extended Master Secret extension on session resumption");
                    } else {
                        this.resumingSession = false;
                    }
                }
            }
            if (this.resumingSession && this.doClientAuth == 2) {
                try {
                    ((SSLSessionImpl)object3).getPeerPrincipal();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    this.resumingSession = false;
                }
            }
            if (this.resumingSession) {
                object2 = ((SSLSessionImpl)object3).getSuite();
                if (((CipherSuite)object2).keyExchange == CipherSuite.KeyExchange.K_KRB5 || ((CipherSuite)object2).keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    Subject subject;
                    block92: {
                        object = ((SSLSessionImpl)object3).getLocalPrincipal();
                        subject = null;
                        try {
                            subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Util.getSubject((GSSCaller)GSSCaller.CALLER_SSL_SERVER, (AccessControlContext)ServerHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            subject = null;
                            if (debug == null || !Debug.isOn("session")) break block92;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<KerberosPrincipal> set = subject.getPrincipals(KerberosPrincipal.class);
                        if (!set.contains(object)) {
                            this.resumingSession = false;
                            if (debug != null && Debug.isOn("session")) {
                                System.out.println("Subject identity is not the same");
                            }
                        } else if (debug != null && Debug.isOn("session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        this.resumingSession = false;
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                    }
                }
            }
            object2 = this.getEndpointIdentificationAlgorithmSE();
            if (this.resumingSession && object2 != null && !ServerHandshaker.objectsEquals(object2, object = ((SSLSessionImpl)object3).getEndpointIdentificationAlgorithm())) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, endpoint id algorithm does not match, requested: " + (String)object2 + ", cached: " + (String)object);
                }
                this.resumingSession = false;
            }
            if (this.resumingSession) {
                object = ((SSLSessionImpl)object3).getSuite();
                if (!this.isNegotiable((CipherSuite)object) || !clientHello.getCipherSuites().contains((CipherSuite)object)) {
                    this.resumingSession = false;
                } else {
                    this.setCipherSuite((CipherSuite)object);
                }
            }
            if (this.resumingSession) {
                this.session = object3;
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Resuming " + this.session);
                }
            }
        }
        if (this.session == null) {
            if (!this.enableNewSession) {
                throw new SSLException("Client did not resume a session");
            }
            this.requestedCurves = (SupportedEllipticCurvesExtension)clientHello.extensions.get(ExtensionType.EXT_ELLIPTIC_CURVES);
            this.chooseCipherSuite(clientHello);
            this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, this.sslContext.getSecureRandom(), this.getHostAddressSE(), this.getPortSE(), this.requestedToUseEMS && this.protocolVersion.v >= ProtocolVersion.TLS10.v, this.getEndpointIdentificationAlgorithmSE());
            this.session.setLocalPrivateKey(this.privateKey);
        }
        ((HandshakeMessage.ServerHello)object4).cipherSuite = this.cipherSuite;
        ((HandshakeMessage.ServerHello)object4).sessionId = this.session.getSessionId();
        ((HandshakeMessage.ServerHello)object4).compression_method = this.session.getCompression();
        if (this.secureRenegotiation) {
            object3 = new RenegotiationInfoExtension(this.clientVerifyData, this.serverVerifyData);
            ((HandshakeMessage.ServerHello)object4).extensions.add((HelloExtension)object3);
        }
        if (this.session.getUseExtendedMasterSecret()) {
            ((HandshakeMessage.ServerHello)object4).extensions.add(new ExtendedMasterSecretExtension());
        }
        if (debug != null && Debug.isOn("handshake")) {
            ((HandshakeMessage.ServerHello)object4).print(System.out);
            System.out.println("Cipher suite:  " + this.session.getSuite());
        }
        ((HandshakeMessage)object4).write(this.output);
        if (this.resumingSession) {
            this.calculateConnectionKeys(this.session.getMasterSecret());
            this.sendChangeCipherAndFinish(false);
            return;
        }
        if (this.keyExchange != CipherSuite.KeyExchange.K_KRB5 && this.keyExchange != CipherSuite.KeyExchange.K_KRB5_EXPORT) {
            if (this.keyExchange != CipherSuite.KeyExchange.K_DH_ANON && this.keyExchange != CipherSuite.KeyExchange.K_ECDH_ANON) {
                if (this.certs == null) {
                    throw new RuntimeException("no certificates");
                }
                object3 = new HandshakeMessage.CertificateMsg(this.certs);
                this.session.setLocalCertificates(this.certs);
                if (debug != null && Debug.isOn("handshake")) {
                    ((HandshakeMessage.CertificateMsg)object3).print(System.out);
                }
                ((HandshakeMessage)object3).write(this.output);
            } else if (this.certs != null) {
                throw new RuntimeException("anonymous keyexchange with certs");
            }
        }
        switch (this.keyExchange) {
            case K_RSA: 
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                object3 = null;
                break;
            }
            case K_RSA_EXPORT: {
                if (JsseJce.getRSAKeyLength(this.certs[0].getPublicKey()) > 512) {
                    try {
                        object3 = new HandshakeMessage.RSA_ServerKeyExchange(this.tempPublicKey, this.privateKey, this.clnt_random, this.svr_random, this.sslContext.getSecureRandom());
                        this.privateKey = this.tempPrivateKey;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        ServerHandshaker.throwSSLException("Error generating RSA server key exchange", generalSecurityException);
                        object3 = null;
                    }
                    break;
                }
                object3 = null;
                break;
            }
            case K_DHE_RSA: 
            case K_DHE_DSS: {
                try {
                    object3 = new HandshakeMessage.DH_ServerKeyExchange(this.dh, this.privateKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.sslContext.getSecureRandom());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    ServerHandshaker.throwSSLException("Error generating DH server key exchange", generalSecurityException);
                    object3 = null;
                }
                break;
            }
            case K_DH_ANON: {
                object3 = new HandshakeMessage.DH_ServerKeyExchange(this.dh);
                break;
            }
            case K_ECDHE_RSA: 
            case K_ECDHE_ECDSA: 
            case K_ECDH_ANON: {
                try {
                    object3 = new HandshakeMessage.ECDH_ServerKeyExchange(this.ecdh, this.privateKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.sslContext.getSecureRandom());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    ServerHandshaker.throwSSLException("Error generating ECDH server key exchange", generalSecurityException);
                    object3 = null;
                }
                break;
            }
            case K_ECDH_RSA: 
            case K_ECDH_ECDSA: {
                object3 = null;
                break;
            }
            default: {
                throw new RuntimeException("internal error: " + (Object)((Object)this.keyExchange));
            }
        }
        if (object3 != null) {
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)object3).print(System.out);
            }
            ((HandshakeMessage)object3).write(this.output);
        }
        if (this.keyExchange != CipherSuite.KeyExchange.K_KRB5 && this.keyExchange != CipherSuite.KeyExchange.K_KRB5_EXPORT && this.doClientAuth != 0 && this.keyExchange != CipherSuite.KeyExchange.K_DH_ANON && this.keyExchange != CipherSuite.KeyExchange.K_ECDH_ANON) {
            object = this.sslContext.getX509TrustManager().getAcceptedIssuers();
            object2 = new HandshakeMessage.CertificateRequest((X509Certificate[])object, this.keyExchange);
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateRequest)object2).print(System.out);
            }
            ((HandshakeMessage)object2).write(this.output);
        }
        object2 = new HandshakeMessage.ServerHelloDone();
        if (debug != null && Debug.isOn("handshake")) {
            ((HandshakeMessage.ServerHelloDone)object2).print(System.out);
        }
        ((HandshakeMessage)object2).write(this.output);
        this.output.flush();
    }

    private void chooseCipherSuite(HandshakeMessage.ClientHello clientHello) throws IOException {
        ArrayList<CipherSuite> arrayList = new ArrayList<CipherSuite>();
        for (CipherSuite cipherSuite : clientHello.getCipherSuites().collection()) {
            if (!this.isNegotiable(cipherSuite) || this.doClientAuth == 2 && (cipherSuite.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || cipherSuite.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON)) continue;
            if (!legacyAlgorithmConstraints.permits(null, cipherSuite.name, null)) {
                arrayList.add(cipherSuite);
                continue;
            }
            if (!this.trySetCipherSuite(cipherSuite)) continue;
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Standard ciphersuite chosen: " + cipherSuite);
            }
            return;
        }
        for (CipherSuite cipherSuite : arrayList) {
            if (!this.trySetCipherSuite(cipherSuite)) continue;
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Legacy ciphersuite chosen: " + cipherSuite);
            }
            return;
        }
        this.fatalSE((byte)40, "no cipher suites in common");
    }

    boolean trySetCipherSuite(CipherSuite cipherSuite) {
        if (this.resumingSession) {
            return true;
        }
        if (!cipherSuite.isNegotiable()) {
            return false;
        }
        if (this.protocolVersion.v >= cipherSuite.obsoleted) {
            return false;
        }
        CipherSuite.KeyExchange keyExchange = cipherSuite.keyExchange;
        this.privateKey = null;
        this.certs = null;
        this.dh = null;
        this.tempPrivateKey = null;
        this.tempPublicKey = null;
        switch (keyExchange) {
            case K_RSA: {
                if (this.setupPrivateKeyAndChain("RSA")) break;
                return false;
            }
            case K_RSA_EXPORT: {
                if (!this.setupPrivateKeyAndChain("RSA")) {
                    return false;
                }
                try {
                    if (JsseJce.getRSAKeyLength(this.certs[0].getPublicKey()) > 512 && !this.setupEphemeralRSAKeys(cipherSuite.exportable)) {
                        return false;
                    }
                    break;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }
            case K_DHE_RSA: {
                if (!this.setupPrivateKeyAndChain("RSA")) {
                    return false;
                }
                this.setupEphemeralDHKeys(cipherSuite.exportable, this.privateKey);
                break;
            }
            case K_ECDHE_RSA: {
                if (!this.setupPrivateKeyAndChain("RSA")) {
                    return false;
                }
                if (this.setupEphemeralECDHKeys()) break;
                return false;
            }
            case K_DHE_DSS: {
                if (!this.setupPrivateKeyAndChain("DSA")) {
                    return false;
                }
                this.setupEphemeralDHKeys(cipherSuite.exportable, this.privateKey);
                break;
            }
            case K_ECDHE_ECDSA: {
                if (!this.setupPrivateKeyAndChain("EC_EC")) {
                    return false;
                }
                if (this.setupEphemeralECDHKeys()) break;
                return false;
            }
            case K_ECDH_RSA: {
                if (!this.setupPrivateKeyAndChain("EC_RSA")) {
                    return false;
                }
                this.setupStaticECDHKeys();
                break;
            }
            case K_ECDH_ECDSA: {
                if (!this.setupPrivateKeyAndChain("EC_EC")) {
                    return false;
                }
                this.setupStaticECDHKeys();
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                if (this.setupKerberosKeys()) break;
                return false;
            }
            case K_DH_ANON: {
                this.setupEphemeralDHKeys(cipherSuite.exportable, null);
                break;
            }
            case K_ECDH_ANON: {
                if (this.setupEphemeralECDHKeys()) break;
                return false;
            }
            default: {
                throw new RuntimeException("Unrecognized cipherSuite: " + cipherSuite);
            }
        }
        this.setCipherSuite(cipherSuite);
        return true;
    }

    private boolean setupEphemeralRSAKeys(boolean bl) {
        KeyPair keyPair = this.sslContext.getEphemeralKeyManager().getRSAKeyPair(bl, this.sslContext.getSecureRandom());
        if (keyPair == null) {
            return false;
        }
        this.tempPublicKey = keyPair.getPublic();
        this.tempPrivateKey = keyPair.getPrivate();
        return true;
    }

    private void setupEphemeralDHKeys(boolean bl, Key key) {
        int n;
        int n2 = n = bl ? 512 : 1024;
        if (!bl) {
            if (useLegacyEphemeralDHKeys) {
                n = 768;
            } else if (useSmartEphemeralDHKeys) {
                if (key != null) {
                    int n3 = KeyUtil.getKeySize(key);
                    n = n3 <= 1024 ? 1024 : 2048;
                }
            } else if (customizedDHKeySize > 0) {
                n = customizedDHKeySize;
            }
        }
        this.dh = new DHCrypt(n, this.sslContext.getSecureRandom());
    }

    private boolean setupEphemeralECDHKeys() {
        int n;
        int n2 = n = this.requestedCurves != null ? this.requestedCurves.getPreferredCurve(this.algorithmConstraints) : SupportedEllipticCurvesExtension.getActiveCurves(this.algorithmConstraints);
        if (n < 0) {
            return false;
        }
        this.ecdh = new ECDHCrypt(n, this.sslContext.getSecureRandom());
        return true;
    }

    private void setupStaticECDHKeys() {
        this.ecdh = new ECDHCrypt(this.privateKey, this.certs[0].getPublicKey());
    }

    private boolean setupPrivateKeyAndChain(String string) {
        X509ExtendedKeyManager x509ExtendedKeyManager = this.sslContext.getX509KeyManager();
        String string2 = this.conn != null ? x509ExtendedKeyManager.chooseServerAlias(string, null, this.conn) : x509ExtendedKeyManager.chooseEngineServerAlias(string, null, this.engine);
        if (string2 == null) {
            return false;
        }
        PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string2);
        if (privateKey == null) {
            return false;
        }
        X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return false;
        }
        String string3 = string.split("_")[0];
        PublicKey publicKey = x509CertificateArray[0].getPublicKey();
        if (!privateKey.getAlgorithm().equals(string3) || !publicKey.getAlgorithm().equals(string3)) {
            return false;
        }
        if (string3.equals("EC")) {
            if (!(publicKey instanceof ECPublicKey)) {
                return false;
            }
            ECParameterSpec eCParameterSpec = ((ECPublicKey)publicKey).getParams();
            int n = SupportedEllipticCurvesExtension.getCurveIndex(eCParameterSpec);
            if (n <= 0 || !SupportedEllipticCurvesExtension.isSupported(n) || this.requestedCurves != null && !this.requestedCurves.contains(n)) {
                return false;
            }
        }
        this.privateKey = privateKey;
        this.certs = x509CertificateArray;
        return true;
    }

    private boolean setupKerberosKeys() {
        if (this.kerberosKeys != null) {
            return true;
        }
        try {
            final AccessControlContext accessControlContext = this.getAccSE();
            this.kerberosKeys = AccessController.doPrivileged(new PrivilegedExceptionAction<KerberosKey[]>(){

                @Override
                public KerberosKey[] run() throws Exception {
                    KerberosKey[] kerberosKeyArray = Krb5Util.getKeys((GSSCaller)GSSCaller.CALLER_SSL_SERVER, null, (AccessControlContext)accessControlContext);
                    return kerberosKeyArray != null ? kerberosKeyArray : new KerberosKey[]{};
                }
            });
            if (this.kerberosKeys != null) {
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Using Kerberos key: " + this.kerberosKeys[0]);
                }
                String string = this.kerberosKeys[0].getPrincipal().getName();
                SecurityManager securityManager = System.getSecurityManager();
                try {
                    if (securityManager != null) {
                        securityManager.checkPermission(new ServicePermission(string, "accept"), accessControlContext);
                    }
                }
                catch (SecurityException securityException) {
                    this.kerberosKeys = null;
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("Permission to access Kerberos secret key denied");
                    }
                    return false;
                }
            }
            return this.kerberosKeys != null && this.kerberosKeys.length > 0;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Attempt to obtain Kerberos key failed: " + privilegedActionException.toString());
            }
            return false;
        }
    }

    private SecretKey clientKeyExchange(KerberosClientKeyExchange kerberosClientKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            kerberosClientKeyExchange.print(System.out);
        }
        this.session.setPeerPrincipal(kerberosClientKeyExchange.getPeerPrincipal());
        this.session.setLocalPrincipal(kerberosClientKeyExchange.getLocalPrincipal());
        byte[] byArray = kerberosClientKeyExchange.getPreMasterSecret().getUnencrypted();
        return new SecretKeySpec(byArray, "TlsPremasterSecret");
    }

    private SecretKey clientKeyExchange(DHClientKeyExchange dHClientKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            dHClientKeyExchange.print(System.out);
        }
        BigInteger bigInteger = dHClientKeyExchange.getClientPublicKey();
        this.dh.checkConstraints(this.algorithmConstraints, bigInteger);
        return this.dh.getAgreedSecret(bigInteger, false);
    }

    private SecretKey clientKeyExchange(ECDHClientKeyExchange eCDHClientKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            eCDHClientKeyExchange.print(System.out);
        }
        byte[] byArray = eCDHClientKeyExchange.getEncodedPoint();
        this.ecdh.checkConstraints(this.algorithmConstraints, byArray);
        return this.ecdh.getAgreedSecret(byArray);
    }

    private void clientCertificateVerify(HandshakeMessage.CertificateVerify certificateVerify) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            certificateVerify.print(System.out);
        }
        try {
            PublicKey publicKey = this.session.getPeerCertificates()[0].getPublicKey();
            boolean bl = certificateVerify.verify(this.protocolVersion, this.handshakeHash, publicKey, this.session.getMasterSecret());
            if (!bl) {
                this.fatalSE((byte)42, "certificate verify message signature error");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.fatalSE((byte)42, "certificate verify format error", generalSecurityException);
        }
        this.needClientVerify = false;
    }

    private void clientFinished(HandshakeMessage.Finished finished) throws IOException {
        boolean bl;
        if (debug != null && Debug.isOn("handshake")) {
            finished.print(System.out);
        }
        if (this.doClientAuth == 2) {
            this.session.getPeerPrincipal();
        }
        if (this.needClientVerify) {
            this.fatalSE((byte)40, "client did not send certificate verify message");
        }
        if (!(bl = finished.verify(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret()))) {
            this.fatalSE((byte)40, "client 'finished' message doesn't verify");
        }
        if (this.secureRenegotiation) {
            this.clientVerifyData = finished.getVerifyData();
        }
        if (!this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession && this.session.isRejoinable()) {
            ((SSLSessionContextImpl)this.sslContext.engineGetServerSessionContext()).put(this.session);
            if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + this.session);
            }
        } else if (!this.resumingSession && debug != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + this.session);
        }
    }

    private void sendChangeCipherAndFinish(boolean bl) throws IOException {
        this.output.flush();
        HandshakeMessage.Finished finished = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 2, this.session.getMasterSecret());
        this.sendChangeCipherSpec(finished, bl);
        if (this.secureRenegotiation) {
            this.serverVerifyData = finished.getVerifyData();
        }
        if (bl) {
            this.state = 20;
        }
    }

    HandshakeMessage getKickstartMessage() {
        return new HandshakeMessage.HelloRequest();
    }

    void handshakeAlert(byte by) throws SSLProtocolException {
        String string = Alerts.alertDescription(by);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + string);
        }
        if (by == 41 && this.doClientAuth == 1) {
            return;
        }
        throw new SSLProtocolException("handshake alert: " + string);
    }

    private SecretKey clientKeyExchange(RSAClientKeyExchange rSAClientKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            rSAClientKeyExchange.print(System.out);
        }
        return rSAClientKeyExchange.preMaster;
    }

    private void clientCertificate(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (debug != null && Debug.isOn("handshake")) {
            certificateMsg.print(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            if (this.doClientAuth == 1) {
                return;
            }
            this.fatalSE((byte)42, "null cert chain");
        }
        X509TrustManager x509TrustManager = this.sslContext.getX509TrustManager();
        try {
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            String string = publicKey.getAlgorithm();
            String string2 = string.equals("RSA") ? "RSA" : (string.equals("DSA") ? "DSA" : (string.equals("EC") ? "EC" : "UNKNOWN"));
            String string3 = this.getHostnameVerificationSE();
            if (x509TrustManager instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)x509TrustManager).checkClientTrusted(x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : null, string2, this.getHostSE(), string3);
            } else {
                if (string3 != null) {
                    throw new RuntimeException("trust manager does not support peer identification");
                }
                x509TrustManager.checkClientTrusted(x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : x509CertificateArray, string2);
            }
        }
        catch (CertificateException certificateException) {
            this.fatalSE((byte)46, certificateException);
        }
        this.needClientVerify = true;
        this.session.setPeerCertificates(x509CertificateArray);
    }

    private static int parseUnsignedInt(String string, int n) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        int n2 = string.length();
        if (n2 > 0) {
            char c = string.charAt(0);
            if (c == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", string));
            }
            if (n2 <= 5 || n == 10 && n2 <= 9) {
                return Integer.parseInt(string, n);
            }
            long l = Long.parseLong(string, n);
            if ((l & 0xFFFFFFFF00000000L) == 0L) {
                return (int)l;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", string));
        }
        throw new NumberFormatException("For input string: \"" + string + "\"");
    }

    private static int parseUnsignedInt(String string) throws NumberFormatException {
        return ServerHandshaker.parseUnsignedInt(string, 10);
    }

    private static boolean objectsEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.tls.ephemeralDHKeySize"));
        if (string == null || string.length() == 0) {
            useLegacyEphemeralDHKeys = false;
            useSmartEphemeralDHKeys = false;
            customizedDHKeySize = -1;
        } else if ("matched".equals(string)) {
            useLegacyEphemeralDHKeys = false;
            useSmartEphemeralDHKeys = true;
            customizedDHKeySize = -1;
        } else if ("legacy".equals(string)) {
            useLegacyEphemeralDHKeys = true;
            useSmartEphemeralDHKeys = false;
            customizedDHKeySize = -1;
        } else {
            useLegacyEphemeralDHKeys = false;
            useSmartEphemeralDHKeys = false;
            try {
                customizedDHKeySize = ServerHandshaker.parseUnsignedInt(string);
                if (customizedDHKeySize < 1024 || customizedDHKeySize > 8192 || (customizedDHKeySize & 0x3F) != 0) {
                    throw new IllegalArgumentException("Unsupported customized DH key size: " + customizedDHKeySize + ". " + "The key size must be multiple of 64, " + "and can only range from 1024 to 8192 (inclusive)");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid system property jdk.tls.ephemeralDHKeySize");
            }
        }
    }
}

