/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Iterator;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NoSuchSymbolException;
import sun.jvm.hotspot.types.CIntegerType;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.basic.BasicCIntegerField;
import sun.jvm.hotspot.types.basic.BasicCIntegerType;
import sun.jvm.hotspot.types.basic.BasicField;
import sun.jvm.hotspot.types.basic.BasicJBooleanField;
import sun.jvm.hotspot.types.basic.BasicJByteField;
import sun.jvm.hotspot.types.basic.BasicJCharField;
import sun.jvm.hotspot.types.basic.BasicJDoubleField;
import sun.jvm.hotspot.types.basic.BasicJFloatField;
import sun.jvm.hotspot.types.basic.BasicJIntField;
import sun.jvm.hotspot.types.basic.BasicJLongField;
import sun.jvm.hotspot.types.basic.BasicJShortField;
import sun.jvm.hotspot.types.basic.BasicOopField;
import sun.jvm.hotspot.types.basic.BasicPointerType;
import sun.jvm.hotspot.types.basic.BasicType;
import sun.jvm.hotspot.types.basic.BasicTypeDataBase;
import sun.jvm.hotspot.types.basic.VtblAccess;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class HotSpotTypeDataBase
extends BasicTypeDataBase {
    private Debugger symbolLookup;
    private String[] jvmLibNames;
    private static final int UNINITIALIZED_SIZE = -1;
    private static final int C_INT8_SIZE = 1;
    private static final int C_INT32_SIZE = 4;
    private static final int C_INT64_SIZE = 8;
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.HotSpotTypeDataBase.DEBUG") != null;

    public HotSpotTypeDataBase(MachineDescription machDesc, VtblAccess vtblAccess, Debugger symbolLookup, String[] jvmLibNames) throws NoSuchSymbolException {
        super(machDesc, vtblAccess);
        this.symbolLookup = symbolLookup;
        this.jvmLibNames = jvmLibNames;
        this.readVMTypes();
        this.initializePrimitiveTypes();
        this.readVMStructs();
        this.readVMIntConstants();
        this.readVMLongConstants();
        this.readExternalDefinitions();
    }

    public Type lookupType(String cTypeName, boolean throwException) {
        Type fieldType = super.lookupType(cTypeName, false);
        if (fieldType == null && cTypeName.startsWith("const ")) {
            fieldType = (BasicType)this.lookupType(cTypeName.substring(6), false);
        }
        if (fieldType == null && cTypeName.endsWith(" const")) {
            fieldType = (BasicType)this.lookupType(cTypeName.substring(0, cTypeName.length() - 6), false);
        }
        if (fieldType == null && cTypeName.startsWith("GrowableArray<") && cTypeName.endsWith(">")) {
            String ttype = cTypeName.substring("GrowableArray<".length(), cTypeName.length() - 1);
            Type templateType = this.lookupType(ttype, false);
            if (templateType == null && this.typeNameIsPointerType(ttype)) {
                templateType = this.recursiveCreateBasicPointerType(ttype);
            }
            if (templateType == null) {
                this.lookupOrFail(ttype);
            }
            BasicType basicTargetType = this.createBasicType(cTypeName, false, false, false);
            BasicType generic = this.lookupOrFail("GenericGrowableArray");
            BasicType specific = this.lookupOrFail("GrowableArray<int>");
            basicTargetType.setSize(specific.getSize());
            Iterator fields = generic.getFields();
            while (fields.hasNext()) {
                Field f = (Field)fields.next();
                basicTargetType.addField(this.internalCreateField(basicTargetType, f.getName(), f.getType(), f.isStatic(), f.getOffset(), null));
            }
            fieldType = basicTargetType;
        }
        if (fieldType == null && this.typeNameIsPointerType(cTypeName)) {
            fieldType = this.recursiveCreateBasicPointerType(cTypeName);
        }
        if (fieldType == null && throwException) {
            super.lookupType(cTypeName, true);
        }
        return fieldType;
    }

    private void readVMTypes() {
        Address entryAddr = this.lookupInProcess("gHotSpotVMTypes");
        if ((entryAddr = entryAddr.getAddressAt(0L)) == null) {
            throw new RuntimeException("gHotSpotVMTypes was not initialized properly in the remote process; can not continue");
        }
        long typeEntryTypeNameOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntryTypeNameOffset");
        long typeEntrySuperclassNameOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntrySuperclassNameOffset");
        long typeEntryIsOopTypeOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntryIsOopTypeOffset");
        long typeEntryIsIntegerTypeOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntryIsIntegerTypeOffset");
        long typeEntryIsUnsignedOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntryIsUnsignedOffset");
        long typeEntrySizeOffset = this.getLongValueFromProcess("gHotSpotVMTypeEntrySizeOffset");
        long typeEntryArrayStride = this.getLongValueFromProcess("gHotSpotVMTypeEntryArrayStride");
        Address typeNameAddr = null;
        do {
            if ((typeNameAddr = entryAddr.getAddressAt(typeEntryTypeNameOffset)) != null) {
                String typeName = CStringUtilities.getString(typeNameAddr);
                String superclassName = null;
                Address superclassNameAddr = entryAddr.getAddressAt(typeEntrySuperclassNameOffset);
                if (superclassNameAddr != null) {
                    superclassName = CStringUtilities.getString(superclassNameAddr);
                }
                boolean isOopType = entryAddr.getCIntegerAt(typeEntryIsOopTypeOffset, 4L, false) != 0L;
                boolean isIntegerType = entryAddr.getCIntegerAt(typeEntryIsIntegerTypeOffset, 4L, false) != 0L;
                boolean isUnsigned = entryAddr.getCIntegerAt(typeEntryIsUnsignedOffset, 4L, false) != 0L;
                long size = entryAddr.getCIntegerAt(typeEntrySizeOffset, 8L, true);
                this.createType(typeName, superclassName, isOopType, isIntegerType, isUnsigned, size);
            }
            entryAddr = entryAddr.addOffsetTo(typeEntryArrayStride);
        } while (typeNameAddr != null);
    }

    private void initializePrimitiveTypes() {
        this.setJBooleanType(this.lookupPrimitiveType("jboolean"));
        this.setJByteType(this.lookupPrimitiveType("jbyte"));
        this.setJCharType(this.lookupPrimitiveType("jchar"));
        this.setJDoubleType(this.lookupPrimitiveType("jdouble"));
        this.setJFloatType(this.lookupPrimitiveType("jfloat"));
        this.setJIntType(this.lookupPrimitiveType("jint"));
        this.setJLongType(this.lookupPrimitiveType("jlong"));
        this.setJShortType(this.lookupPrimitiveType("jshort"));
        ((BasicType)this.getJBooleanType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJByteType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJCharType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJDoubleType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJFloatType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJIntType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJLongType()).setIsJavaPrimitiveType(true);
        ((BasicType)this.getJShortType()).setIsJavaPrimitiveType(true);
    }

    private Type lookupPrimitiveType(String typeName) {
        Type type = this.lookupType(typeName, false);
        if (type == null) {
            throw new RuntimeException("Error initializing the HotSpotDataBase: could not find the primitive type \"" + typeName + "\" in the remote VM's VMStructs table. This type is required in " + "order to determine the size of Java primitive types. Can not continue.");
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readExternalDefinitions() {
        String file = System.getProperty("sun.jvm.hotspot.typedb");
        if (file == null) return;
        System.out.println("Reading " + file);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StreamTokenizer t = new StreamTokenizer(in);
            t.resetSyntax();
            t.wordChars(0, 65535);
            t.whitespaceChars(32, 32);
            t.whitespaceChars(10, 10);
            t.whitespaceChars(13, 13);
            t.quoteChar(34);
            t.eolIsSignificant(true);
            while (t.nextToken() != -1) {
                if (t.ttype == 10) continue;
                if (t.sval.equals("field")) {
                    t.nextToken();
                    BasicType containingType = (BasicType)this.lookupType(t.sval);
                    t.nextToken();
                    String fieldName = t.sval;
                    t.nextToken();
                    Type fieldType = this.lookupType(t.sval);
                    t.nextToken();
                    boolean isStatic = Boolean.valueOf(t.sval);
                    t.nextToken();
                    long offset = Long.parseLong(t.sval);
                    t.nextToken();
                    Address staticAddress = null;
                    if (isStatic) {
                        throw new InternalError("static fields not supported");
                    }
                    Iterator i = containingType.getFields();
                    boolean defined = false;
                    while (i.hasNext()) {
                        Field f = (Field)i.next();
                        if (!f.getName().equals(fieldName)) continue;
                        if (f.isStatic() != isStatic) {
                            throw new RuntimeException("static/nonstatic mismatch: " + fieldName);
                        }
                        if (!isStatic) {
                            if (f.getOffset() != offset) {
                                throw new RuntimeException("bad redefinition of field offset: " + fieldName);
                            }
                        } else if (!((Object)f.getStaticFieldAddress()).equals(staticAddress)) {
                            throw new RuntimeException("bad redefinition of field location: " + fieldName);
                        }
                        if (f.getType() != fieldType) {
                            System.out.println(fieldType);
                            System.out.println(f.getType());
                            throw new RuntimeException("bad redefinition of field type: " + fieldName);
                        }
                        defined = true;
                        break;
                    }
                    if (defined) continue;
                    this.createField(containingType, fieldName, fieldType, isStatic, offset, staticAddress);
                    continue;
                }
                if (!t.sval.equals("type")) throw new InternalError("\"" + t.sval + "\"");
                t.nextToken();
                String typeName = t.sval;
                t.nextToken();
                String superclassName = t.sval;
                if (superclassName.equals("null")) {
                    superclassName = null;
                }
                t.nextToken();
                boolean isOop = Boolean.valueOf(t.sval);
                t.nextToken();
                boolean isInteger = Boolean.valueOf(t.sval);
                t.nextToken();
                boolean isUnsigned = Boolean.valueOf(t.sval);
                t.nextToken();
                long size = Long.parseLong(t.sval);
                BasicType type = null;
                try {
                    type = (BasicType)this.lookupType(typeName);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                if (type != null) {
                    if (type.isOopType() != isOop) {
                        throw new RuntimeException("oop mismatch in type definition: " + typeName);
                    }
                    if (type.isCIntegerType() != isInteger) {
                        throw new RuntimeException("integer type mismatch in type definition: " + typeName);
                    }
                    if (type.isCIntegerType() && ((CIntegerType)((Object)type)).isUnsigned() != isUnsigned) {
                        throw new RuntimeException("unsigned mismatch in type definition: " + typeName);
                    }
                    if (type.getSuperclass() == null) {
                        if (superclassName != null) {
                            if (type.getSize() != -1L) throw new RuntimeException("unexpected superclass in type definition: " + typeName);
                            type.setSuperclass(this.lookupType(superclassName));
                        }
                    } else {
                        if (superclassName == null) {
                            throw new RuntimeException("missing superclass in type definition: " + typeName);
                        }
                        if (!type.getSuperclass().getName().equals(superclassName)) {
                            throw new RuntimeException("incorrect superclass in type definition: " + typeName);
                        }
                    }
                    if (type.getSize() != size) {
                        if (type.getSize() != -1L && type.getSize() != 0L) throw new RuntimeException("size mismatch in type definition: " + typeName + ": " + type.getSize() + " != " + size);
                        type.setSize(size);
                    }
                }
                if (this.lookupType(typeName, false) != null) continue;
                this.createType(typeName, superclassName, isOop, isInteger, isUnsigned, size);
            }
            return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    private void readVMStructs() {
        long structEntryTypeNameOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryTypeNameOffset");
        long structEntryFieldNameOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryFieldNameOffset");
        long structEntryTypeStringOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryTypeStringOffset");
        long structEntryIsStaticOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryIsStaticOffset");
        long structEntryOffsetOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryOffsetOffset");
        long structEntryAddressOffset = this.getLongValueFromProcess("gHotSpotVMStructEntryAddressOffset");
        long structEntryArrayStride = this.getLongValueFromProcess("gHotSpotVMStructEntryArrayStride");
        Address entryAddr = this.lookupInProcess("gHotSpotVMStructs");
        if ((entryAddr = entryAddr.getAddressAt(0L)) == null) {
            throw new RuntimeException("gHotSpotVMStructs was not initialized properly in the remote process; can not continue");
        }
        Address fieldNameAddr = null;
        String typeName = null;
        String fieldName = null;
        String typeString = null;
        boolean isStatic = false;
        long offset = 0L;
        Address staticFieldAddr = null;
        long size = 0L;
        long index = 0L;
        String opaqueName = "<opaque>";
        this.lookupOrCreateClass(opaqueName, false, false, false);
        do {
            if ((fieldNameAddr = entryAddr.getAddressAt(structEntryFieldNameOffset)) != null) {
                fieldName = CStringUtilities.getString(fieldNameAddr);
                Address addr = entryAddr.getAddressAt(structEntryTypeNameOffset);
                if (addr == null) {
                    throw new RuntimeException("gHotSpotVMStructs unexpectedly had a NULL type name at index " + index);
                }
                typeName = CStringUtilities.getString(addr);
                addr = entryAddr.getAddressAt(structEntryTypeStringOffset);
                typeString = addr == null ? opaqueName : CStringUtilities.getString(addr);
                boolean bl = isStatic = entryAddr.getCIntegerAt(structEntryIsStaticOffset, 4L, false) != 0L;
                if (isStatic) {
                    staticFieldAddr = entryAddr.getAddressAt(structEntryAddressOffset);
                    offset = 0L;
                } else {
                    offset = entryAddr.getCIntegerAt(structEntryOffsetOffset, 8L, true);
                    staticFieldAddr = null;
                }
                BasicType containingType = this.lookupOrFail(typeName);
                BasicType fieldType = (BasicType)this.lookupType(typeString);
                this.createField(containingType, fieldName, fieldType, isStatic, offset, staticFieldAddr);
            }
            ++index;
            entryAddr = entryAddr.addOffsetTo(structEntryArrayStride);
        } while (fieldNameAddr != null);
    }

    private void readVMIntConstants() {
        long intConstantEntryNameOffset = this.getLongValueFromProcess("gHotSpotVMIntConstantEntryNameOffset");
        long intConstantEntryValueOffset = this.getLongValueFromProcess("gHotSpotVMIntConstantEntryValueOffset");
        long intConstantEntryArrayStride = this.getLongValueFromProcess("gHotSpotVMIntConstantEntryArrayStride");
        Address entryAddr = this.lookupInProcess("gHotSpotVMIntConstants");
        if ((entryAddr = entryAddr.getAddressAt(0L)) == null) {
            throw new RuntimeException("gHotSpotVMIntConstants was not initialized properly in the remote process; can not continue");
        }
        Address nameAddr = null;
        do {
            if ((nameAddr = entryAddr.getAddressAt(intConstantEntryNameOffset)) != null) {
                String name = CStringUtilities.getString(nameAddr);
                int value = (int)entryAddr.getCIntegerAt(intConstantEntryValueOffset, 4L, false);
                Integer oldValue = this.lookupIntConstant(name, false);
                if (oldValue == null) {
                    this.addIntConstant(name, value);
                } else {
                    if (oldValue != value) {
                        throw new RuntimeException("Error: the integer constant \"" + name + "\" had its value redefined (old was " + oldValue + ", new is " + value + ". Aborting.");
                    }
                    System.err.println("Warning: the int constant \"" + name + "\" (declared in the remote VM in VMStructs::localHotSpotVMIntConstants) " + "had its value declared as " + value + " twice. Continuing.");
                }
            }
            entryAddr = entryAddr.addOffsetTo(intConstantEntryArrayStride);
        } while (nameAddr != null);
    }

    private void readVMLongConstants() {
        long longConstantEntryNameOffset = this.getLongValueFromProcess("gHotSpotVMLongConstantEntryNameOffset");
        long longConstantEntryValueOffset = this.getLongValueFromProcess("gHotSpotVMLongConstantEntryValueOffset");
        long longConstantEntryArrayStride = this.getLongValueFromProcess("gHotSpotVMLongConstantEntryArrayStride");
        Address entryAddr = this.lookupInProcess("gHotSpotVMLongConstants");
        if ((entryAddr = entryAddr.getAddressAt(0L)) == null) {
            throw new RuntimeException("gHotSpotVMLongConstants was not initialized properly in the remote process; can not continue");
        }
        Address nameAddr = null;
        do {
            if ((nameAddr = entryAddr.getAddressAt(longConstantEntryNameOffset)) != null) {
                String name = CStringUtilities.getString(nameAddr);
                int value = (int)entryAddr.getCIntegerAt(longConstantEntryValueOffset, 8L, true);
                Long oldValue = this.lookupLongConstant(name, false);
                if (oldValue == null) {
                    this.addLongConstant(name, value);
                } else {
                    if (oldValue != (long)value) {
                        throw new RuntimeException("Error: the long constant \"" + name + "\" had its value redefined (old was " + oldValue + ", new is " + value + ". Aborting.");
                    }
                    System.err.println("Warning: the long constant \"" + name + "\" (declared in the remote VM in VMStructs::localHotSpotVMLongConstants) " + "had its value declared as " + value + " twice. Continuing.");
                }
            }
            entryAddr = entryAddr.addOffsetTo(longConstantEntryArrayStride);
        } while (nameAddr != null);
    }

    private BasicType lookupOrFail(String typeName) {
        BasicType type = (BasicType)this.lookupType(typeName, false);
        if (type == null) {
            throw new RuntimeException("Type \"" + typeName + "\", referenced in VMStructs::localHotSpotVMStructs in the remote VM, " + "was not present in the remote VMStructs::localHotSpotVMTypes table (should have been caught " + "in the debug build of that VM). Can not continue.");
        }
        return type;
    }

    private long getLongValueFromProcess(String symbol) {
        return this.lookupInProcess(symbol).getCIntegerAt(0L, 8L, true);
    }

    private Address lookupInProcess(String symbol) throws NoSuchSymbolException {
        for (int i = 0; i < this.jvmLibNames.length; ++i) {
            Address addr = this.symbolLookup.lookup(this.jvmLibNames[i], symbol);
            if (addr == null) continue;
            return addr;
        }
        String errStr = "(";
        for (int i = 0; i < this.jvmLibNames.length; ++i) {
            errStr = errStr + this.jvmLibNames[i];
            if (i >= this.jvmLibNames.length - 1) continue;
            errStr = errStr + ", ";
        }
        errStr = errStr + ")";
        throw new NoSuchSymbolException(symbol, "Could not find symbol \"" + symbol + "\" in any of the known library names " + errStr);
    }

    private BasicType lookupOrCreateClass(String typeName, boolean isOopType, boolean isIntegerType, boolean isUnsigned) {
        BasicType type = (BasicType)this.lookupType(typeName, false);
        if (type == null) {
            type = this.createBasicType(typeName, isOopType, isIntegerType, isUnsigned);
        }
        return type;
    }

    private BasicType createBasicType(String typeName, boolean isOopType, boolean isIntegerType, boolean isUnsigned) {
        BasicType type = null;
        if (isIntegerType) {
            type = new BasicCIntegerType((BasicTypeDataBase)this, typeName, isUnsigned);
        } else {
            type = this.typeNameIsPointerType(typeName) ? this.recursiveCreateBasicPointerType(typeName) : new BasicType(this, typeName);
            if (isOopType) {
                if (typeName.equals("markOop")) {
                    type = new BasicCIntegerType((BasicTypeDataBase)this, typeName, true);
                } else {
                    type.setIsOopType(true);
                }
            }
        }
        type.setSize(-1L);
        this.addType(type);
        return type;
    }

    private BasicPointerType recursiveCreateBasicPointerType(String typeName) {
        BasicPointerType result = (BasicPointerType)super.lookupType(typeName, false);
        if (result != null) {
            return result;
        }
        String targetTypeName = typeName.substring(0, typeName.lastIndexOf(42)).trim();
        Type targetType = null;
        if (this.typeNameIsPointerType(targetTypeName)) {
            targetType = this.lookupType(targetTypeName, false);
            if (targetType == null) {
                targetType = this.recursiveCreateBasicPointerType(targetTypeName);
            }
        } else {
            targetType = this.lookupType(targetTypeName, false);
            if (targetType == null) {
                if (targetTypeName.equals("char") || targetTypeName.equals("const char")) {
                    BasicType basicTargetType = this.createBasicType(targetTypeName, false, true, false);
                    basicTargetType.setSize(1L);
                    targetType = basicTargetType;
                } else if (targetTypeName.equals("u_char")) {
                    BasicType basicTargetType = this.createBasicType(targetTypeName, false, true, true);
                    basicTargetType.setSize(1L);
                    targetType = basicTargetType;
                } else {
                    if (DEBUG) {
                        System.err.println("WARNING: missing target type \"" + targetTypeName + "\" for pointer type \"" + typeName + "\"");
                    }
                    targetType = this.createBasicType(targetTypeName, false, false, false);
                }
            }
        }
        result = new BasicPointerType(this, typeName, targetType);
        result.setSize(-1L);
        this.addType(result);
        return result;
    }

    private boolean typeNameIsPointerType(String typeName) {
        int i;
        for (i = typeName.length() - 1; i >= 0 && Character.isWhitespace(typeName.charAt(i)); --i) {
        }
        return i >= 0 && typeName.charAt(i) == '*';
    }

    public void createType(String typeName, String superclassName, boolean isOopType, boolean isIntegerType, boolean isUnsigned, long size) {
        BasicType superclass = null;
        if (superclassName != null) {
            superclass = this.lookupOrCreateClass(superclassName, false, false, false);
        }
        BasicType curType = this.lookupOrCreateClass(typeName, isOopType, isIntegerType, isUnsigned);
        if (superclass != null) {
            if (curType.getSuperclass() == null) {
                curType.setSuperclass(superclass);
            }
            if (curType.getSuperclass() != superclass) {
                throw new RuntimeException("Error: the type \"" + typeName + "\" (declared in the remote VM in VMStructs::localHotSpotVMTypes) " + "had its superclass redefined (old was " + curType.getSuperclass().getName() + ", new is " + superclass.getName() + ").");
            }
        }
        if (curType.getSize() == -1L || curType.getSize() == 0L) {
            curType.setSize(size);
        } else {
            if (curType.getSize() != size) {
                throw new RuntimeException("Error: the type \"" + typeName + "\" (declared in the remote VM in VMStructs::localHotSpotVMTypes) " + "had its size redefined (old was " + curType.getSize() + ", new is " + size + ").");
            }
            System.err.println("Warning: the type \"" + typeName + "\" (declared in the remote VM in VMStructs::localHotSpotVMTypes) " + "had its size declared as " + size + " twice. Continuing.");
        }
    }

    public void createField(BasicType containingType, String name, Type type, boolean isStatic, long offset, Address staticFieldAddress) {
        containingType.addField(this.internalCreateField(containingType, name, type, isStatic, offset, staticFieldAddress));
    }

    Field internalCreateField(BasicType containingType, String name, Type type, boolean isStatic, long offset, Address staticFieldAddress) {
        if (type.isOopType()) {
            return new BasicOopField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type instanceof CIntegerType) {
            return new BasicCIntegerField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJBooleanType())) {
            return new BasicJBooleanField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJByteType())) {
            return new BasicJByteField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJCharType())) {
            return new BasicJCharField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJDoubleType())) {
            return new BasicJDoubleField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJFloatType())) {
            return new BasicJFloatField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJIntType())) {
            return new BasicJIntField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJLongType())) {
            return new BasicJLongField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        if (type.equals(this.getJShortType())) {
            return new BasicJShortField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
        }
        return new BasicField(this, containingType, name, type, isStatic, offset, staticFieldAddress);
    }

    private void dumpMemory(Address addr, int len) {
        int i = 0;
        while (i < len) {
            System.err.print(addr.addOffsetTo(i) + ":");
            for (int j = 0; j < 8 && i < len; ++i, ++j) {
                String s = Long.toHexString(addr.getCIntegerAt(i, 1L, true));
                System.err.print(" 0x");
                for (int k = 0; k < 2 - s.length(); ++k) {
                    System.err.print("0");
                }
                System.err.print(s);
            }
            System.err.println();
        }
    }
}

