/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.ia64;

import sun.jvm.hotspot.asm.ia64.IA64FloatRegisters;
import sun.jvm.hotspot.asm.ia64.IA64Register;

public class IA64FloatRegister
extends IA64Register {
    public static final int SINGLE_PRECISION = 1;
    public static final int DOUBLE_PRECISION = 2;
    public static final int QUAD_PRECISION = 3;
    private static final int nofRegisters = 128;

    public IA64FloatRegister(int number) {
        super(number);
    }

    public int getNumber() {
        return this.number;
    }

    public int getNumber(int width) {
        return this.number;
    }

    public int getNumberOfRegisters() {
        return 128;
    }

    public boolean isFloat() {
        return true;
    }

    public boolean isFramePointer() {
        return false;
    }

    public boolean isStackPointer() {
        return false;
    }

    public boolean isValid() {
        return this.number >= 0 && this.number < 128;
    }

    public String toString() {
        return IA64FloatRegisters.getRegisterName(this.number);
    }
}

