/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.x86;

import sun.jvm.hotspot.asm.Disassembler;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.InstructionVisitor;
import sun.jvm.hotspot.asm.x86.ArithmeticDecoder;
import sun.jvm.hotspot.asm.x86.BranchDecoder;
import sun.jvm.hotspot.asm.x86.CallDecoder;
import sun.jvm.hotspot.asm.x86.ConditionalJmpDecoder;
import sun.jvm.hotspot.asm.x86.FloatDecoder;
import sun.jvm.hotspot.asm.x86.GRPDecoder;
import sun.jvm.hotspot.asm.x86.InstructionDecoder;
import sun.jvm.hotspot.asm.x86.JmpDecoder;
import sun.jvm.hotspot.asm.x86.LogicalDecoder;
import sun.jvm.hotspot.asm.x86.MoveDecoder;
import sun.jvm.hotspot.asm.x86.SSEArithmeticDecoder;
import sun.jvm.hotspot.asm.x86.SSEInstructionDecoder;
import sun.jvm.hotspot.asm.x86.SSELogicalDecoder;
import sun.jvm.hotspot.asm.x86.SSEMoveDecoder;
import sun.jvm.hotspot.asm.x86.SSEShiftDecoder;
import sun.jvm.hotspot.asm.x86.X86InstructionFactory;
import sun.jvm.hotspot.asm.x86.X86InstructionFactoryImpl;
import sun.jvm.hotspot.asm.x86.X86Opcodes;

public class X86Disassembler
extends Disassembler
implements X86Opcodes {
    private int byteIndex;
    protected final X86InstructionFactory factory;
    private static final InstructionDecoder[] oneByteTable = new InstructionDecoder[]{new ArithmeticDecoder("addb", 1, 1, 5, 1, 0), new ArithmeticDecoder("addS", 1, 2, 5, 2, 0), new ArithmeticDecoder("addb", 5, 1, 1, 1, 0), new ArithmeticDecoder("addS", 5, 2, 1, 2, 0), new ArithmeticDecoder("addb", 6, 16, 2, 1, 0), new ArithmeticDecoder("addS", 6, 0, 2, 2, 0), new InstructionDecoder("pushl", 6, 24), new InstructionDecoder("popl", 6, 24), new LogicalDecoder("orb", 1, 1, 5, 1, 9), new LogicalDecoder("orS", 1, 2, 5, 2, 9), new LogicalDecoder("orb", 5, 1, 1, 1, 9), new LogicalDecoder("orS", 5, 2, 1, 2, 9), new LogicalDecoder("orb", 6, 16, 2, 1, 9), new LogicalDecoder("orS", 6, 0, 2, 2, 9), new InstructionDecoder("pushl", 6, 25), null, new ArithmeticDecoder("adcb", 1, 1, 5, 1, 1), new ArithmeticDecoder("adcS", 1, 2, 5, 2, 1), new ArithmeticDecoder("adcb", 5, 1, 1, 1, 1), new ArithmeticDecoder("adcS", 5, 2, 1, 2, 1), new ArithmeticDecoder("adcb", 6, 16, 2, 1, 1), new ArithmeticDecoder("adcS", 6, 0, 2, 2, 1), new InstructionDecoder("pushl", 6, 26), new InstructionDecoder("popl", 6, 26), new ArithmeticDecoder("sbbb", 1, 1, 5, 1, 3), new ArithmeticDecoder("sbbS", 1, 2, 5, 2, 3), new ArithmeticDecoder("sbbb", 5, 1, 1, 1, 3), new ArithmeticDecoder("sbbS", 5, 2, 1, 2, 3), new ArithmeticDecoder("sbbb", 6, 16, 2, 1, 3), new ArithmeticDecoder("sbbS", 6, 0, 2, 2, 3), new InstructionDecoder("pushl", 6, 27), new InstructionDecoder("popl", 6, 27), new LogicalDecoder("andb", 1, 1, 5, 1, 8), new LogicalDecoder("andS", 1, 2, 5, 2, 8), new LogicalDecoder("andb", 5, 1, 1, 1, 8), new LogicalDecoder("andS", 5, 2, 1, 2, 8), new LogicalDecoder("andb", 6, 16, 2, 1, 8), new LogicalDecoder("andS", 6, 0, 2, 2, 8), null, new InstructionDecoder("daa"), new ArithmeticDecoder("subb", 1, 1, 5, 1, 2), new ArithmeticDecoder("subS", 1, 2, 5, 2, 2), new ArithmeticDecoder("subb", 5, 1, 1, 1, 2), new ArithmeticDecoder("subS", 5, 2, 1, 2, 2), new ArithmeticDecoder("subb", 6, 16, 2, 1, 2), new ArithmeticDecoder("subS", 6, 0, 2, 2, 2), null, new InstructionDecoder("das"), new LogicalDecoder("xorb", 1, 1, 5, 1, 13), new LogicalDecoder("xorS", 1, 2, 5, 2, 13), new LogicalDecoder("xorb", 5, 1, 1, 1, 13), new LogicalDecoder("xorS", 5, 2, 1, 2, 13), new LogicalDecoder("xorb", 6, 16, 2, 1, 13), new LogicalDecoder("xorS", 6, 0, 2, 2, 13), null, new InstructionDecoder("aaa"), new InstructionDecoder("cmpb", 1, 1, 5, 1), new InstructionDecoder("cmpS", 1, 2, 5, 2), new InstructionDecoder("cmpb", 5, 1, 1, 1), new InstructionDecoder("cmpS", 5, 2, 1, 2), new InstructionDecoder("cmpb", 6, 16, 2, 1), new InstructionDecoder("cmpS", 6, 0, 2, 2), null, new InstructionDecoder("aas"), new ArithmeticDecoder("incS", 6, 0, 0), new ArithmeticDecoder("incS", 6, 1, 0), new ArithmeticDecoder("incS", 6, 2, 0), new ArithmeticDecoder("incS", 6, 3, 0), new ArithmeticDecoder("incS", 6, 4, 0), new ArithmeticDecoder("incS", 6, 5, 0), new ArithmeticDecoder("incS", 6, 6, 0), new ArithmeticDecoder("incS", 6, 7, 0), new ArithmeticDecoder("decS", 6, 0, 2), new ArithmeticDecoder("decS", 6, 1, 2), new ArithmeticDecoder("decS", 6, 2, 2), new ArithmeticDecoder("decS", 6, 3, 2), new ArithmeticDecoder("decS", 6, 4, 2), new ArithmeticDecoder("decS", 6, 5, 2), new ArithmeticDecoder("decS", 6, 6, 2), new ArithmeticDecoder("decS", 6, 7, 2), new InstructionDecoder("pushS", 6, 0), new InstructionDecoder("pushS", 6, 1), new InstructionDecoder("pushS", 6, 2), new InstructionDecoder("pushS", 6, 3), new InstructionDecoder("pushS", 6, 4), new InstructionDecoder("pushS", 6, 5), new InstructionDecoder("pushS", 6, 6), new InstructionDecoder("pushS", 6, 7), new InstructionDecoder("popS", 6, 0), new InstructionDecoder("popS", 6, 1), new InstructionDecoder("popS", 6, 2), new InstructionDecoder("popS", 6, 3), new InstructionDecoder("popS", 6, 4), new InstructionDecoder("popS", 6, 5), new InstructionDecoder("popS", 6, 6), new InstructionDecoder("popS", 6, 7), new InstructionDecoder("pusha"), new InstructionDecoder("popa"), new InstructionDecoder("boundS", 5, 2, 1, 2), new InstructionDecoder("arpl", 1, 3, 5, 3), null, null, null, null, new InstructionDecoder("pushS", 2, 2), new ArithmeticDecoder("imulS", 5, 2, 1, 2, 2, 2, 4), new InstructionDecoder("pushl", 2, 1), new ArithmeticDecoder("imulS", 5, 2, 1, 2, 2, 1, 4), new InstructionDecoder("insb", 7, 1, 11, 10), new InstructionDecoder("insS", 7, 2, 11, 10), new InstructionDecoder("outsb", 11, 10, 8, 1), new InstructionDecoder("outsS", 11, 10, 8, 2), new ConditionalJmpDecoder("jo", 4, 1), new ConditionalJmpDecoder("jno", 4, 1), new ConditionalJmpDecoder("jb", 4, 1), new ConditionalJmpDecoder("jae", 4, 1), new ConditionalJmpDecoder("je", 4, 1), new ConditionalJmpDecoder("jne", 4, 1), new ConditionalJmpDecoder("jbe", 4, 1), new ConditionalJmpDecoder("ja", 4, 1), new ConditionalJmpDecoder("js", 4, 1), new ConditionalJmpDecoder("jns", 4, 1), new ConditionalJmpDecoder("jp", 4, 1), new ConditionalJmpDecoder("jnp", 4, 1), new ConditionalJmpDecoder("jl", 4, 1), new ConditionalJmpDecoder("jnl", 4, 1), new ConditionalJmpDecoder("jle", 4, 1), new ConditionalJmpDecoder("jg", 4, 1), new GRPDecoder(null, 0), new GRPDecoder(null, 1), null, new GRPDecoder(null, 2), new InstructionDecoder("testb", 1, 1, 5, 1), new InstructionDecoder("testS", 1, 2, 5, 2), new MoveDecoder("xchgb", 1, 1, 5, 1), new MoveDecoder("xchgS", 1, 2, 5, 2), new MoveDecoder("movb", 1, 1, 5, 1), new MoveDecoder("movS", 1, 2, 5, 2), new MoveDecoder("movb", 5, 1, 1, 1), new MoveDecoder("movS", 5, 2, 1, 2), new MoveDecoder("movw", 1, 3, 9, 3), new InstructionDecoder("leaS", 5, 2, 1, 0), new MoveDecoder("movw", 9, 3, 1, 3), new InstructionDecoder("popS", 1, 2), new InstructionDecoder("nop"), new MoveDecoder("xchgS", 6, 1, 6, 0), new MoveDecoder("xchgS", 6, 2, 6, 0), new MoveDecoder("xchgS", 6, 3, 6, 0), new MoveDecoder("xchgS", 6, 4, 6, 0), new MoveDecoder("xchgS", 6, 5, 6, 0), new MoveDecoder("xchgS", 6, 6, 6, 0), new MoveDecoder("xchgS", 6, 7, 6, 0), new InstructionDecoder("cwtl"), new InstructionDecoder("cltd"), new CallDecoder("lcall", 3, 5), null, new InstructionDecoder("pushf"), new InstructionDecoder("popf"), new InstructionDecoder("sahf"), new InstructionDecoder("lahf"), new MoveDecoder("movb", 6, 16, 10, 1), new MoveDecoder("movS", 6, 0, 10, 2), new MoveDecoder("movb", 10, 1, 6, 16), new MoveDecoder("movS", 10, 2, 6, 0), new MoveDecoder("movsb", 7, 1, 8, 1), new MoveDecoder("movsS", 7, 2, 8, 2), new InstructionDecoder("cmpsb", 7, 1, 8, 1), new InstructionDecoder("cmpsS", 7, 2, 8, 2), new InstructionDecoder("testb", 6, 16, 2, 1), new InstructionDecoder("testS", 6, 0, 2, 2), new InstructionDecoder("stosb", 7, 1, 6, 16), new InstructionDecoder("stosS", 7, 2, 6, 0), new InstructionDecoder("lodsb", 6, 16, 8, 1), new InstructionDecoder("lodsS", 6, 0, 8, 2), new InstructionDecoder("scasb", 6, 16, 7, 1), new InstructionDecoder("scasS", 6, 0, 7, 2), new MoveDecoder("movb", 6, 16, 2, 1), new MoveDecoder("movb", 6, 17, 2, 1), new MoveDecoder("movb", 6, 18, 2, 1), new MoveDecoder("movb", 6, 19, 2, 1), new MoveDecoder("movb", 6, 20, 2, 1), new MoveDecoder("movb", 6, 21, 2, 1), new MoveDecoder("movb", 6, 22, 2, 1), new MoveDecoder("movb", 6, 23, 2, 1), new MoveDecoder("movS", 6, 0, 2, 2), new MoveDecoder("movS", 6, 1, 2, 2), new MoveDecoder("movS", 6, 2, 2, 2), new MoveDecoder("movS", 6, 3, 2, 2), new MoveDecoder("movS", 6, 4, 2, 2), new MoveDecoder("movS", 6, 5, 2, 2), new MoveDecoder("movS", 6, 6, 2, 2), new MoveDecoder("movS", 6, 7, 2, 2), new GRPDecoder(null, 3), new GRPDecoder(null, 4), new BranchDecoder("ret", 2, 3), new BranchDecoder("ret"), new InstructionDecoder("lesS", 5, 2, 1, 0), new InstructionDecoder("ldsS", 5, 2, 1, 0), new MoveDecoder("movb", 1, 1, 2, 1), new MoveDecoder("movS", 1, 2, 2, 2), new InstructionDecoder("enter", 2, 3, 2, 1), new InstructionDecoder("leave"), new InstructionDecoder("lret", 2, 3), new InstructionDecoder("lret"), new InstructionDecoder("int3"), new InstructionDecoder("int", 2, 1), new InstructionDecoder("into"), new InstructionDecoder("iret"), new GRPDecoder(null, 5), new GRPDecoder(null, 6), new GRPDecoder(null, 7), new GRPDecoder(null, 8), new InstructionDecoder("aam", 2, 1), new InstructionDecoder("aad", 2, 1), null, new InstructionDecoder("xlat"), new FloatDecoder(), new FloatDecoder(), new FloatDecoder(), new FloatDecoder(), new FloatDecoder(), new FloatDecoder(), new FloatDecoder(), new FloatDecoder(), new BranchDecoder("loopne", 4, 1), new BranchDecoder("loope", 4, 1), new BranchDecoder("loop", 4, 1), new ConditionalJmpDecoder("jCcxz", 4, 1), new InstructionDecoder("inb", 6, 16, 2, 1), new InstructionDecoder("inS", 6, 0, 2, 1), new InstructionDecoder("outb", 2, 1, 6, 16), new InstructionDecoder("outS", 2, 1, 6, 0), new CallDecoder("call", 4, 2), new JmpDecoder("jmp", 4, 2), new JmpDecoder("ljmp", 3, 5), new JmpDecoder("jmp", 4, 1), new InstructionDecoder("inb", 6, 16, 11, 10), new InstructionDecoder("inS", 6, 0, 11, 10), new InstructionDecoder("outb", 11, 10, 6, 16), new InstructionDecoder("outS", 11, 10, 6, 0), new InstructionDecoder("lock"), null, new InstructionDecoder("repne"), new InstructionDecoder("rep"), new InstructionDecoder("hlt"), new InstructionDecoder("cmc"), new GRPDecoder(null, 9), new GRPDecoder(null, 10), new InstructionDecoder("clc"), new InstructionDecoder("stc"), new InstructionDecoder("cli"), new InstructionDecoder("sti"), new InstructionDecoder("cld"), new InstructionDecoder("std"), new GRPDecoder(null, 11), new GRPDecoder(null, 12)};
    private static final InstructionDecoder[] twoByteTable = new InstructionDecoder[]{new GRPDecoder(null, 13), new GRPDecoder(null, 14), new InstructionDecoder("larS", 5, 2, 1, 3), new InstructionDecoder("lslS", 5, 2, 1, 3), null, null, new InstructionDecoder("clts"), null, new InstructionDecoder("invd"), new InstructionDecoder("wbinvd"), null, null, null, null, null, null, new SSEMoveDecoder("movups", 21, 8, 19, 8), new SSEMoveDecoder("movups", 19, 8, 21, 8), new SSEMoveDecoder("movlps", 19, 11, 21, 11), new SSEMoveDecoder("movlps", 21, 11, 19, 11), new SSEInstructionDecoder("unpcklps", 21, 8, 19, 11), new SSEInstructionDecoder("unpckhps", 21, 8, 19, 11), new SSEMoveDecoder("movhps", 21, 11, 19, 11), new SSEMoveDecoder("movhps", 19, 11, 21, 11), new GRPDecoder(null, 21), null, null, null, null, null, null, null, new MoveDecoder("movl", 13, 4, 14, 4), new MoveDecoder("movl", 13, 4, 15, 4), new MoveDecoder("movl", 14, 4, 13, 4), new MoveDecoder("movl", 15, 4, 13, 4), new MoveDecoder("movl", 13, 4, 16, 4), null, new MoveDecoder("movl", 16, 4, 13, 4), null, new SSEMoveDecoder("movaps", 21, 8, 19, 8), new SSEMoveDecoder("movaps", 19, 8, 21, 8), new SSEInstructionDecoder("cvtpi2ps", 21, 8, 20, 11), new SSEMoveDecoder("movntps", 19, 8, 21, 8), new SSEInstructionDecoder("cvttps2pi", 20, 11, 19, 8), new SSEInstructionDecoder("cvtps2pi", 20, 11, 19, 8), new SSEInstructionDecoder("ucomiss", 21, 12, 19, 12), new SSEInstructionDecoder("comiss", 21, 8, 19, 8), new SSEInstructionDecoder("wrmsr"), new SSEInstructionDecoder("rtdsc"), new SSEInstructionDecoder("rdmsr"), new SSEInstructionDecoder("rdpmc"), new SSEInstructionDecoder("sysenter"), new SSEInstructionDecoder("sysexit"), null, null, null, null, null, null, new SSEMoveDecoder("movnti", 5, 2, 1, 2), null, null, null, new MoveDecoder("cmovo", 5, 2, 1, 2), new MoveDecoder("cmovno", 5, 2, 1, 2), new MoveDecoder("cmovb", 5, 2, 1, 2), new MoveDecoder("cmovae", 5, 2, 1, 2), new MoveDecoder("cmove", 5, 2, 1, 2), new MoveDecoder("cmovne", 5, 2, 1, 2), new MoveDecoder("cmovbe", 5, 2, 1, 2), new MoveDecoder("cmova", 5, 2, 1, 2), new MoveDecoder("cmovs", 5, 2, 1, 2), new MoveDecoder("cmovns", 5, 2, 1, 2), new MoveDecoder("cmovp", 5, 2, 1, 2), new MoveDecoder("cmovnp", 5, 2, 1, 2), new MoveDecoder("cmovl", 5, 2, 1, 2), new MoveDecoder("cmovge", 5, 2, 1, 2), new MoveDecoder("cmovle", 5, 2, 1, 2), new MoveDecoder("cmovg", 5, 2, 1, 2), new SSEMoveDecoder("movmskps", 1, 4, 21, 8), new SSEInstructionDecoder("sqrtps", 21, 8, 19, 8), new SSEInstructionDecoder("rsqrtps", 21, 8, 19, 8), new SSEInstructionDecoder("rcpps", 21, 8, 19, 8), new SSELogicalDecoder("andps", 21, 8, 19, 8, 8), new SSELogicalDecoder("andnps", 21, 8, 19, 8, 8), new SSELogicalDecoder("orps", 21, 8, 19, 8, 9), new SSELogicalDecoder("xorps", 21, 8, 19, 8, 13), new SSEArithmeticDecoder("addps", 21, 8, 19, 8, 0), new SSEArithmeticDecoder("mulps", 21, 8, 19, 8, 4), new SSEInstructionDecoder("cvtps2pd", 21, 9, 19, 8), new SSEInstructionDecoder("cvtdq2ps", 21, 8, 19, 6), new SSEArithmeticDecoder("subps", 21, 8, 19, 8, 2), new SSEInstructionDecoder("minps", 21, 8, 19, 8), new SSEArithmeticDecoder("divps", 21, 8, 19, 8, 6), new SSEInstructionDecoder("maxps", 21, 8, 19, 8), new SSEInstructionDecoder("punpcklbw", 22, 11, 20, 4), new SSEInstructionDecoder("punpcklwd", 22, 11, 20, 4), new SSEInstructionDecoder("punpckldq", 22, 11, 20, 4), new SSEInstructionDecoder("packsswb", 22, 11, 20, 11), new SSEInstructionDecoder("pcmpgtb", 22, 11, 20, 11), new SSEInstructionDecoder("pcmpgtw", 22, 11, 20, 11), new SSEInstructionDecoder("pcmpgtd", 22, 11, 20, 11), new SSEInstructionDecoder("packuswb", 22, 11, 20, 11), new SSEInstructionDecoder("punpckhbw", 22, 11, 20, 4), new SSEInstructionDecoder("punpckhwd", 22, 11, 20, 4), new SSEInstructionDecoder("punpckhdq", 22, 11, 20, 4), new SSEInstructionDecoder("packssdw", 22, 11, 20, 4), null, null, new SSEMoveDecoder("movd", 22, 4, 1, 4), new SSEMoveDecoder("movq", 22, 11, 1, 11), new SSEInstructionDecoder("pshufw", 22, 11, 20, 11, 2, 1), new GRPDecoder(null, 17), new GRPDecoder(null, 18), new GRPDecoder(null, 19), new SSEInstructionDecoder("pcmpeqb", 22, 11, 20, 11), new SSEInstructionDecoder("pcmpeqw", 22, 11, 20, 11), new SSEInstructionDecoder("pcmpeqd", 22, 11, 20, 11), new SSEInstructionDecoder("emms"), null, null, null, null, null, null, new SSEMoveDecoder("movd", 1, 4, 22, 4), new SSEMoveDecoder("movq", 20, 11, 22, 11), new ConditionalJmpDecoder("jo", 4, 2), new ConditionalJmpDecoder("jno", 4, 2), new ConditionalJmpDecoder("jb", 4, 2), new ConditionalJmpDecoder("jae", 4, 2), new ConditionalJmpDecoder("je", 4, 2), new ConditionalJmpDecoder("jne", 4, 2), new ConditionalJmpDecoder("jbe", 4, 2), new ConditionalJmpDecoder("ja", 4, 2), new ConditionalJmpDecoder("js", 4, 2), new ConditionalJmpDecoder("jns", 4, 2), new ConditionalJmpDecoder("jp", 4, 2), new ConditionalJmpDecoder("jnp", 4, 2), new ConditionalJmpDecoder("jl", 4, 2), new ConditionalJmpDecoder("jge", 4, 2), new ConditionalJmpDecoder("jle", 4, 2), new ConditionalJmpDecoder("jg", 4, 2), new InstructionDecoder("seto", 1, 1), new InstructionDecoder("setno", 1, 1), new InstructionDecoder("setb", 1, 1), new InstructionDecoder("setae", 1, 1), new InstructionDecoder("sete", 1, 1), new InstructionDecoder("setne", 1, 1), new InstructionDecoder("setbe", 1, 1), new InstructionDecoder("seta", 1, 1), new InstructionDecoder("sets", 1, 1), new InstructionDecoder("setns", 1, 1), new InstructionDecoder("setp", 1, 1), new InstructionDecoder("setnp", 1, 1), new InstructionDecoder("setl", 1, 1), new InstructionDecoder("setge", 1, 1), new InstructionDecoder("setle", 1, 1), new InstructionDecoder("setg", 1, 1), new InstructionDecoder("pushl", 6, 28), new InstructionDecoder("popl", 6, 28), null, new InstructionDecoder("btS", 1, 2, 5, 2), new InstructionDecoder("shldS", 1, 2, 5, 2, 2, 1), new InstructionDecoder("shldS", 1, 2, 5, 2, 6, 17), null, null, new InstructionDecoder("pushl", 6, 29), new InstructionDecoder("popl", 6, 29), new SSEInstructionDecoder("rsm"), new InstructionDecoder("btsS", 1, 2, 5, 2), new InstructionDecoder("shrdS", 1, 2, 5, 2, 2, 1), new InstructionDecoder("shrdS", 1, 2, 5, 2, 6, 17), new GRPDecoder(null, 20), new ArithmeticDecoder("imulS", 5, 2, 1, 2, 4), new InstructionDecoder("cmpxchgb", 1, 1, 5, 1), new InstructionDecoder("cmpxchgS", 1, 2, 5, 2), new InstructionDecoder("lssS", 5, 2, 17, 5), new InstructionDecoder("btrS", 1, 2, 5, 2), new InstructionDecoder("lfsS", 5, 2, 17, 5), new InstructionDecoder("lgsS", 5, 2, 17, 5), new MoveDecoder("movzbS", 5, 2, 1, 1), new MoveDecoder("movzwS", 5, 2, 1, 3), null, null, new GRPDecoder(null, 15), new InstructionDecoder("btcS", 1, 2, 5, 2), new InstructionDecoder("bsfS", 5, 2, 1, 2), new InstructionDecoder("bsrS", 5, 2, 1, 2), new MoveDecoder("movsbS", 5, 2, 1, 1), new MoveDecoder("movswS", 5, 2, 1, 3), new ArithmeticDecoder("xaddb", 1, 1, 5, 1, 0), new ArithmeticDecoder("xaddS", 1, 2, 5, 2, 0), new SSEInstructionDecoder("cmpps", 21, 8, 19, 8, 2, 1), new SSEMoveDecoder("movnti", 1, 4, 5, 4), new SSEInstructionDecoder("pinsrw", 22, 11, 1, 4, 2, 1), new SSEInstructionDecoder("pextrw", 5, 4, 22, 11, 2, 1), new SSEInstructionDecoder("shufps", 21, 8, 19, 8, 2, 1), new GRPDecoder(null, 16), new InstructionDecoder("bswap", 6, 0), new InstructionDecoder("bswap", 6, 1), new InstructionDecoder("bswap", 6, 2), new InstructionDecoder("bswap", 6, 3), new InstructionDecoder("bswap", 6, 4), new InstructionDecoder("bswap", 6, 5), new InstructionDecoder("bswap", 6, 6), new InstructionDecoder("bswap", 6, 7), null, new SSEShiftDecoder("psrlw", 22, 11, 20, 11, 15), new SSEShiftDecoder("psrld", 22, 11, 20, 11, 15), new SSEShiftDecoder("psrlq", 22, 11, 20, 11, 15), new SSEArithmeticDecoder("paddq", 22, 11, 20, 11, 0), new SSEArithmeticDecoder("pmullw", 22, 11, 20, 11, 4), null, new SSEMoveDecoder("pmovmskb", 5, 4, 22, 11), new SSEArithmeticDecoder("psubusb", 22, 11, 20, 11, 2), new SSEArithmeticDecoder("psubusw", 22, 11, 20, 11, 2), new SSEInstructionDecoder("pminub", 22, 11, 20, 11), new SSELogicalDecoder("pand", 22, 11, 20, 11, 8), new SSEArithmeticDecoder("paddusb", 22, 11, 20, 11, 0), new SSEArithmeticDecoder("paddusw", 22, 11, 20, 11, 0), new SSEInstructionDecoder("pmaxub", 22, 11, 20, 11), new SSELogicalDecoder("pandn", 22, 11, 20, 11, 8), new SSEInstructionDecoder("pavgb", 22, 11, 20, 11), new SSEInstructionDecoder("psraw", 22, 11, 20, 11), new SSEInstructionDecoder("psrad", 22, 11, 20, 11), new SSEInstructionDecoder("pavgw", 22, 11, 20, 11), new SSEArithmeticDecoder("pmulhuw", 22, 11, 20, 11, 5), new SSEArithmeticDecoder("pmulhw", 22, 11, 20, 11, 4), null, new SSEMoveDecoder("movntq", 19, 11, 21, 11), new SSEArithmeticDecoder("psubsb", 22, 11, 20, 11, 2), new SSEArithmeticDecoder("psubsw", 22, 11, 20, 11, 2), new SSEInstructionDecoder("pminsw", 22, 11, 20, 11), new SSELogicalDecoder("por", 22, 11, 20, 11, 9), new SSEArithmeticDecoder("paddsb", 22, 11, 20, 11, 0), new SSEArithmeticDecoder("paddsw", 22, 11, 20, 11, 0), new SSEInstructionDecoder("pmaxsw", 22, 11, 20, 11), new SSELogicalDecoder("pxor", 22, 11, 20, 11, 13), null, new SSEShiftDecoder("psllw", 22, 11, 20, 11, 17), new SSEShiftDecoder("pslld", 22, 11, 20, 11, 17), new SSEShiftDecoder("psllq", 22, 11, 20, 11, 17), new SSEArithmeticDecoder("pmuludq", 22, 11, 20, 11, 5), new SSEArithmeticDecoder("pmaddwd", 22, 11, 20, 11, 0), new SSEArithmeticDecoder("psadbw", 22, 11, 20, 11, 0), new SSEMoveDecoder("maskmoveq", 22, 7, 20, 7), new SSEArithmeticDecoder("psubb", 22, 11, 20, 11, 2), new SSEArithmeticDecoder("psubw", 22, 11, 20, 11, 2), new SSEArithmeticDecoder("psubd", 22, 11, 20, 11, 2), new SSEArithmeticDecoder("psubq", 22, 11, 20, 11, 2), new SSEArithmeticDecoder("paddb", 22, 11, 20, 11, 0), new SSEArithmeticDecoder("paddw", 22, 11, 20, 11, 0), new SSEArithmeticDecoder("paddd", 22, 11, 20, 11, 0), null};
    private static final InstructionDecoder[] twoBytePrefixF2Table = new InstructionDecoder[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movsd", 21, 10, 19, 10), new SSEMoveDecoder("movsd", 21, 10, 19, 10), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("cvtsi2sd", 21, 10, 1, 4), null, new SSEInstructionDecoder("cvttsd2si", 5, 4, 19, 10), new SSEInstructionDecoder("cvtsd2si", 5, 4, 19, 10), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("sqrtsd", 21, 10, 19, 10), null, null, null, null, null, null, new SSEArithmeticDecoder("addsd", 21, 10, 19, 10, 0), new SSEArithmeticDecoder("mulsd", 21, 10, 19, 10, 4), new SSEInstructionDecoder("cvtsd2ss", 21, 10, 19, 10), null, new SSEArithmeticDecoder("subsd", 21, 10, 19, 10, 2), new SSEInstructionDecoder("minsd", 21, 10, 19, 10), new SSEArithmeticDecoder("divsd", 21, 10, 19, 10, 6), new SSEInstructionDecoder("maxsd", 21, 10, 19, 10), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("pshuflw", 21, 6, 19, 6, 2, 1), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("cmpsd", 21, 10, 19, 10, 2, 1), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movdq2q", 22, 11, 19, 11), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("cvtpd2dq", 21, 6, 19, 9), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final InstructionDecoder[] twoBytePrefixF3Table = new InstructionDecoder[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movss", 21, 12, 19, 12), new SSEMoveDecoder("movss", 19, 12, 21, 12), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("cvtsi2ss", 21, 12, 1, 4), null, new SSEInstructionDecoder("cvttss2si", 5, 4, 19, 12), new SSEInstructionDecoder("cvtss2si", 5, 4, 19, 12), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("sqrtss", 21, 12, 19, 12), new SSEInstructionDecoder("rsqrtss", 21, 12, 19, 12), new SSEInstructionDecoder("rcpss", 21, 12, 19, 12), null, null, null, null, new SSEArithmeticDecoder("addss", 21, 12, 19, 12, 0), new SSEArithmeticDecoder("mulss", 21, 12, 19, 12, 4), new SSEInstructionDecoder("cvtss2sd", 21, 12, 19, 12), new SSEInstructionDecoder("cvttps2dq", 21, 6, 19, 8), new SSEArithmeticDecoder("subss", 21, 12, 19, 12, 2), new SSEInstructionDecoder("minss", 21, 12, 19, 12), new SSEArithmeticDecoder("divss", 21, 12, 19, 12, 6), new SSEInstructionDecoder("maxss", 21, 12, 19, 12), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movdqu", 21, 6, 19, 6), new SSEInstructionDecoder("pshufhw", 21, 6, 19, 6, 2, 1), null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movq", 21, 11, 19, 11), new SSEMoveDecoder("movdqu", 19, 6, 21, 6), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("cmpss", 21, 12, 19, 12, 2, 1), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movq2dq", 21, 6, 20, 11), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("cvtdq2pd", 21, 9, 19, 6), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final InstructionDecoder[] twoBytePrefix66Table = new InstructionDecoder[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movupd", 21, 9, 19, 9), new SSEMoveDecoder("movupd", 19, 9, 21, 9), new SSEMoveDecoder("movlpd", 21, 11, 19, 14), new SSEMoveDecoder("movlpd", 21, 11, 19, 11), new SSEInstructionDecoder("unpcklpd", 21, 9, 19, 11), new SSEInstructionDecoder("unpckhpd", 21, 9, 19, 11), new SSEMoveDecoder("movhpd", 21, 11, 19, 11), new SSEMoveDecoder("movhpd", 19, 11, 21, 11), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movapd", 21, 9, 19, 9), new SSEMoveDecoder("movapd", 19, 9, 21, 9), new SSEInstructionDecoder("cvtpi2pd", 21, 9, 20, 6), new SSEMoveDecoder("movntpd", 19, 9, 21, 9), new SSEInstructionDecoder("cvttpd2pi", 20, 6, 19, 9), new SSEInstructionDecoder("cvtpd2pi", 20, 6, 19, 9), new SSEInstructionDecoder("ucomisd", 21, 10, 19, 10), new SSEInstructionDecoder("comisd", 21, 10, 19, 10), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEMoveDecoder("movmskpd", 1, 4, 21, 9), new SSEInstructionDecoder("sqrtpd", 21, 9, 19, 9), null, null, new SSELogicalDecoder("andpd", 21, 9, 19, 9, 8), new SSELogicalDecoder("andnpd", 21, 9, 19, 9, 8), new SSELogicalDecoder("orpd", 21, 9, 19, 9, 9), new SSELogicalDecoder("xorpd", 21, 9, 19, 9, 13), new SSEArithmeticDecoder("addpd", 21, 9, 19, 9, 0), new SSEArithmeticDecoder("mulpd", 21, 9, 19, 9, 4), new SSEInstructionDecoder("cvtpd2ps", 21, 8, 19, 9), new SSEInstructionDecoder("cvtps2dq", 21, 6, 19, 8), new SSEArithmeticDecoder("subpd", 21, 9, 19, 9, 2), new SSEInstructionDecoder("minpd", 21, 9, 19, 9), new SSEArithmeticDecoder("divpd", 21, 9, 19, 9, 6), new SSEInstructionDecoder("maxpd", 21, 9, 19, 9), new SSEInstructionDecoder("punpcklbw", 21, 6, 19, 6), new SSEInstructionDecoder("punpcklwd", 21, 6, 19, 6), new SSEInstructionDecoder("punpckldq", 21, 6, 19, 6), new SSEInstructionDecoder("packsswb", 21, 6, 19, 6), new SSEInstructionDecoder("pcmpgtb", 21, 6, 19, 6), new SSEInstructionDecoder("pcmpgtw", 21, 6, 19, 6), new SSEInstructionDecoder("pcmpgtd", 21, 6, 19, 6), new SSEInstructionDecoder("packuswb", 21, 6, 19, 6), new SSEInstructionDecoder("punpckhbw", 22, 6, 20, 6), new SSEInstructionDecoder("punpckhwd", 22, 6, 20, 6), new SSEInstructionDecoder("punpckhdq", 22, 6, 20, 6), new SSEInstructionDecoder("packssdw", 22, 6, 20, 6), new SSEInstructionDecoder("punpcklqdq", 21, 6, 19, 6), new SSEInstructionDecoder("punpckhqdq", 21, 6, 19, 6), new SSEMoveDecoder("movd", 21, 6, 1, 4), new SSEMoveDecoder("movdqa", 21, 6, 19, 6), new SSEInstructionDecoder("pshufd", 21, 6, 19, 6, 2, 1), new GRPDecoder(null, 22), new GRPDecoder(null, 23), new GRPDecoder(null, 24), new SSEInstructionDecoder("pcmpeqb", 21, 6, 19, 6), new SSEInstructionDecoder("pcmpeqw", 21, 6, 19, 6), new SSEInstructionDecoder("pcmpeqd", 21, 6, 19, 6), null, null, null, null, null, null, null, new SSEMoveDecoder("movd", 1, 4, 21, 6), new SSEMoveDecoder("movdqa", 19, 6, 21, 6), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new SSEInstructionDecoder("cmppd", 21, 9, 19, 9, 2, 1), null, new SSEInstructionDecoder("pinsrw", 21, 6, 1, 4, 2, 1), new SSEInstructionDecoder("pextrw", 5, 4, 21, 6, 2, 1), new SSEInstructionDecoder("shufpd", 21, 9, 19, 9, 2, 1), null, null, null, null, null, null, null, null, null, null, new SSEShiftDecoder("psrlw", 21, 6, 19, 6, 15), new SSEShiftDecoder("psrld", 21, 6, 19, 6, 15), new SSEShiftDecoder("psrlq", 21, 6, 19, 6, 15), new SSEArithmeticDecoder("paddq", 21, 6, 19, 6, 0), new SSEArithmeticDecoder("pmullw", 21, 6, 19, 6, 4), new SSEMoveDecoder("movq", 19, 11, 21, 11), new SSEMoveDecoder("pmovmskb", 5, 4, 21, 6), new SSEArithmeticDecoder("psubusb", 21, 6, 19, 6, 2), new SSEArithmeticDecoder("psubusw", 21, 6, 19, 6, 2), new SSEInstructionDecoder("pminub", 21, 6, 19, 6), new SSELogicalDecoder("pand", 21, 6, 19, 6, 8), new SSEArithmeticDecoder("paddusb", 21, 6, 19, 6, 0), new SSEArithmeticDecoder("paddusw", 21, 6, 19, 6, 0), new SSEInstructionDecoder("pmaxub", 21, 6, 19, 6), new SSELogicalDecoder("pandn", 21, 6, 19, 6, 8), new SSEInstructionDecoder("pavgb", 21, 6, 19, 6), new SSEInstructionDecoder("psraw", 21, 6, 19, 6), new SSEInstructionDecoder("psrad", 21, 6, 19, 6), new SSEInstructionDecoder("pavgw", 21, 6, 19, 6), new SSEArithmeticDecoder("pmulhuw", 21, 6, 19, 6, 5), new SSEArithmeticDecoder("pmulhw", 21, 6, 19, 6, 4), new SSEInstructionDecoder("cvttpd2dq", 21, 6, 19, 9), new SSEMoveDecoder("movntdq", 19, 6, 21, 6), new SSEArithmeticDecoder("psubusb", 21, 6, 19, 6, 2), new SSEArithmeticDecoder("psubusw", 21, 6, 19, 6, 2), new SSEInstructionDecoder("pminsw", 21, 6, 19, 6), new SSELogicalDecoder("por", 21, 6, 19, 6, 9), new SSEArithmeticDecoder("paddsb", 21, 6, 19, 6, 0), new SSEArithmeticDecoder("paddsw", 21, 6, 19, 6, 0), new SSEInstructionDecoder("pmaxsw", 21, 6, 19, 6), new SSELogicalDecoder("pxor", 21, 6, 19, 6, 13), null, new SSEShiftDecoder("psllw", 21, 6, 19, 6, 17), new SSEShiftDecoder("pslld", 21, 6, 19, 6, 17), new SSEShiftDecoder("psllq", 21, 6, 19, 6, 17), new SSEArithmeticDecoder("pmuludq", 21, 6, 19, 6, 5), new SSEArithmeticDecoder("pmaddwd", 21, 6, 19, 6, 0), new SSEArithmeticDecoder("psadbw", 21, 6, 19, 6, 0), new SSEMoveDecoder("maskmovdqu", 21, 6, 19, 6), new SSEArithmeticDecoder("psubb", 21, 6, 19, 6, 2), new SSEArithmeticDecoder("psubw", 21, 6, 19, 6, 2), new SSEArithmeticDecoder("psubd", 21, 6, 19, 6, 2), new SSEArithmeticDecoder("psubq", 21, 6, 19, 6, 2), new SSEArithmeticDecoder("paddb", 21, 6, 19, 6, 0), new SSEArithmeticDecoder("paddw", 21, 6, 19, 6, 0), new SSEArithmeticDecoder("paddd", 21, 6, 19, 6, 0), null};

    public X86Disassembler(long startPc, byte[] code, X86InstructionFactory factory) {
        super(startPc, code);
        this.factory = factory;
    }

    public X86Disassembler(long startPc, byte[] code) {
        this(startPc, code, new X86InstructionFactoryImpl());
    }

    public void decode(InstructionVisitor visitor) {
        boolean enter_instruction = false;
        Instruction instr = null;
        visitor.prologue();
        InstructionDecoder instrDecoder = null;
        try {
            this.byteIndex = 0;
            int len = 0;
            int instrStartIndex = 0;
            while (len < this.code.length) {
                int prefixes = 0;
                instrStartIndex = this.byteIndex;
                prefixes = this.getPrefixes();
                int segmentOverride = 1;
                enter_instruction = this.code[this.byteIndex] == 200;
                int opcode = InstructionDecoder.readByte(this.code, this.byteIndex);
                ++this.byteIndex;
                if (opcode == 15) {
                    opcode = InstructionDecoder.readByte(this.code, this.byteIndex);
                    ++this.byteIndex;
                    instrDecoder = (prefixes & 2) != 0 ? twoBytePrefixF2Table[opcode] : ((prefixes & 1) != 0 ? twoBytePrefixF3Table[opcode] : ((prefixes & 0x200) != 0 ? twoBytePrefix66Table[opcode] : twoByteTable[opcode]));
                } else {
                    instrDecoder = oneByteTable[opcode];
                }
                if (instrDecoder != null) {
                    instr = instrDecoder.decode(this.code, this.byteIndex, instrStartIndex, segmentOverride, prefixes, this.factory);
                    visitor.visit(this.startPc + (long)len, instr);
                    len = instrDecoder.getCurrentIndex();
                }
                this.byteIndex = ++len;
            }
        }
        catch (Exception exp) {
            visitor.epilogue();
        }
    }

    private int getPrefixes() {
        int prefixByte = 0;
        int prefixes = 0;
        boolean isPrefix = true;
        while (isPrefix) {
            prefixByte = InstructionDecoder.readByte(this.code, this.byteIndex);
            switch (prefixByte) {
                case 243: {
                    prefixes |= 1;
                    break;
                }
                case 242: {
                    prefixes |= 2;
                    break;
                }
                case 240: {
                    prefixes |= 4;
                    break;
                }
                case 46: {
                    prefixes |= 8;
                    break;
                }
                case 54: {
                    prefixes |= 0x10;
                    break;
                }
                case 62: {
                    prefixes |= 0x20;
                    break;
                }
                case 38: {
                    prefixes |= 0x40;
                    break;
                }
                case 100: {
                    prefixes |= 0x80;
                    break;
                }
                case 101: {
                    prefixes |= 0x100;
                    break;
                }
                case 102: {
                    prefixes |= 0x200;
                    break;
                }
                case 103: {
                    prefixes |= 0x400;
                    break;
                }
                case 155: {
                    prefixes |= 0x800;
                    break;
                }
                default: {
                    isPrefix = false;
                }
            }
            if (!isPrefix) continue;
            ++this.byteIndex;
        }
        return prefixes;
    }
}

