/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ci;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciKlass;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ciInstanceKlass
extends ciKlass {
    private static CIntField initStateField;
    private static CIntField isSharedField;
    private static int CLASS_STATE_LINKED;
    private static int CLASS_STATE_FULLY_INITIALIZED;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ciInstanceKlass");
        initStateField = new CIntField(type.getCIntegerField("_init_state"), 0L);
        isSharedField = new CIntField(type.getCIntegerField("_is_shared"), 0L);
        CLASS_STATE_LINKED = db.lookupIntConstant("instanceKlass::linked");
        CLASS_STATE_FULLY_INITIALIZED = db.lookupIntConstant("instanceKlass::fully_initialized");
    }

    public ciInstanceKlass(Address addr) {
        super(addr);
    }

    public int initState() {
        int initState = (int)initStateField.getValue(this.getAddress());
        if (this.isShared() && initState < CLASS_STATE_LINKED) {
            InstanceKlass ik = (InstanceKlass)this.getOop();
            initState = ik.getInitStateAsInt();
        }
        return initState;
    }

    public boolean isShared() {
        return isSharedField.getValue(this.getAddress()) != 0L;
    }

    public boolean isLinked() {
        return this.initState() >= CLASS_STATE_LINKED;
    }

    public boolean isInitialized() {
        return this.initState() == CLASS_STATE_FULLY_INITIALIZED;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ciInstanceKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

