/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.AdapterBlob;
import sun.jvm.hotspot.code.BufferBlob;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.CodeCacheVisitor;
import sun.jvm.hotspot.code.DeoptimizationBlob;
import sun.jvm.hotspot.code.ExceptionBlob;
import sun.jvm.hotspot.code.MethodHandlesAdapterBlob;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.code.RicochetBlob;
import sun.jvm.hotspot.code.RuntimeStub;
import sun.jvm.hotspot.code.SafepointBlob;
import sun.jvm.hotspot.code.UncommonTrapBlob;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CodeHeap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.runtime.VirtualConstructor;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class CodeCache {
    private static AddressField heapField;
    private static AddressField scavengeRootNMethodsField;
    private static VirtualConstructor virtualConstructor;
    private CodeHeap heap = (CodeHeap)VMObjectFactory.newObject(CodeHeap.class, heapField.getValue());

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("CodeCache");
        heapField = type.getAddressField("_heap");
        scavengeRootNMethodsField = type.getAddressField("_scavenge_root_nmethods");
        virtualConstructor = new VirtualConstructor(db);
        virtualConstructor.addMapping("BufferBlob", BufferBlob.class);
        virtualConstructor.addMapping("nmethod", NMethod.class);
        virtualConstructor.addMapping("RuntimeStub", RuntimeStub.class);
        virtualConstructor.addMapping("RicochetBlob", RicochetBlob.class);
        virtualConstructor.addMapping("AdapterBlob", AdapterBlob.class);
        virtualConstructor.addMapping("MethodHandlesAdapterBlob", MethodHandlesAdapterBlob.class);
        virtualConstructor.addMapping("SafepointBlob", SafepointBlob.class);
        virtualConstructor.addMapping("DeoptimizationBlob", DeoptimizationBlob.class);
        if (VM.getVM().isServerCompiler()) {
            virtualConstructor.addMapping("ExceptionBlob", ExceptionBlob.class);
            virtualConstructor.addMapping("UncommonTrapBlob", UncommonTrapBlob.class);
        }
    }

    public NMethod scavengeRootMethods() {
        return (NMethod)VMObjectFactory.newObject(NMethod.class, scavengeRootNMethodsField.getValue());
    }

    public boolean contains(Address p) {
        return this.getHeap().contains(p);
    }

    public CodeBlob findBlob(Address start) {
        CodeBlob result = this.findBlobUnsafe(start);
        if (result == null) {
            return null;
        }
        if (VM.getVM().isDebugging()) {
            return result;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!result.isZombie() && !result.isLockedByVM(), "unsafe access to zombie method");
        }
        return result;
    }

    public CodeBlob findBlobUnsafe(Address start) {
        CodeBlob result = null;
        try {
            result = (CodeBlob)virtualConstructor.instantiateWrapperFor(this.getHeap().findStart(start));
        }
        catch (WrongTypeException wte) {
            Address cbAddr = null;
            try {
                cbAddr = this.getHeap().findStart(start);
            }
            catch (Exception findEx) {
                findEx.printStackTrace();
            }
            String message = "Couldn't deduce type of CodeBlob ";
            if (cbAddr != null) {
                message = message + "@" + cbAddr + " ";
            }
            message = message + "for PC=" + start;
            throw new RuntimeException(message, wte);
        }
        if (result == null) {
            return null;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(result.blobContains(start) || result.blobContains(start.addOffsetTo(8L)), "found wrong CodeBlob");
        }
        if (result.isRicochetBlob()) {
            return VM.getVM().ricochetBlob();
        }
        return result;
    }

    public NMethod findNMethod(Address start) {
        CodeBlob cb = this.findBlob(start);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(cb == null || cb.isNMethod(), "did not find an nmethod");
        }
        return (NMethod)cb;
    }

    public NMethod findNMethodUnsafe(Address start) {
        CodeBlob cb = this.findBlobUnsafe(start);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(cb == null || cb.isNMethod(), "did not find an nmethod");
        }
        return (NMethod)cb;
    }

    public CodeBlob createCodeBlobWrapper(Address codeBlobAddr) {
        try {
            return (CodeBlob)virtualConstructor.instantiateWrapperFor(codeBlobAddr);
        }
        catch (Exception e) {
            String message = "Unable to deduce type of CodeBlob from address " + codeBlobAddr + " (expected type nmethod, RuntimeStub, ";
            if (VM.getVM().isClientCompiler()) {
                message = message + " or ";
            }
            message = message + "SafepointBlob";
            if (VM.getVM().isServerCompiler()) {
                message = message + ", DeoptimizationBlob, or ExceptionBlob";
            }
            message = message + ")";
            throw new RuntimeException(message);
        }
    }

    public void iterate(CodeCacheVisitor visitor) {
        CodeHeap heap = this.getHeap();
        Address ptr = heap.begin();
        Address end = heap.end();
        visitor.prologue(ptr, end);
        CodeBlob lastBlob = null;
        while (ptr != null && ptr.lessThan(end)) {
            try {
                CodeBlob blob = this.findBlobUnsafe(heap.findStart(ptr));
                if (blob != null) {
                    visitor.visit(blob);
                    if (blob == lastBlob) {
                        throw new InternalError("saw same blob twice");
                    }
                    lastBlob = blob;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            Address next = heap.nextBlock(ptr);
            if (next != null && next.lessThan(ptr)) {
                throw new InternalError("pointer moved backwards");
            }
            ptr = next;
        }
        visitor.epilogue();
    }

    private CodeHeap getHeap() {
        return this.heap;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CodeCache.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

