/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.code.ScopeDesc;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class PCDesc
extends VMObject {
    private static CIntegerField pcOffsetField;
    private static CIntegerField scopeDecodeOffsetField;
    private static CIntegerField objDecodeOffsetField;
    private static CIntegerField pcFlagsField;
    private static int reexecuteMask;
    private static int isMethodHandleInvokeMask;
    private static int returnOopMask;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("PcDesc");
        pcOffsetField = type.getCIntegerField("_pc_offset");
        scopeDecodeOffsetField = type.getCIntegerField("_scope_decode_offset");
        objDecodeOffsetField = type.getCIntegerField("_obj_decode_offset");
        pcFlagsField = type.getCIntegerField("_flags");
        reexecuteMask = db.lookupIntConstant("PcDesc::PCDESC_reexecute");
        isMethodHandleInvokeMask = db.lookupIntConstant("PcDesc::PCDESC_is_method_handle_invoke");
        returnOopMask = db.lookupIntConstant("PcDesc::PCDESC_return_oop");
    }

    public PCDesc(Address addr) {
        super(addr);
    }

    public int getPCOffset() {
        return (int)pcOffsetField.getValue(this.addr);
    }

    public int getScopeDecodeOffset() {
        return (int)scopeDecodeOffsetField.getValue(this.addr);
    }

    public int getObjDecodeOffset() {
        return (int)objDecodeOffsetField.getValue(this.addr);
    }

    public Address getRealPC(NMethod code) {
        return code.codeBegin().addOffsetTo(this.getPCOffset());
    }

    public boolean getReexecute() {
        int flags = (int)pcFlagsField.getValue(this.addr);
        return (flags & reexecuteMask) != 0;
    }

    public boolean isMethodHandleInvoke() {
        int flags = (int)pcFlagsField.getValue(this.addr);
        return (flags & isMethodHandleInvokeMask) != 0;
    }

    public void print(NMethod code) {
        this.printOn(System.out, code);
    }

    public void printOn(PrintStream tty, NMethod code) {
        tty.println("PCDesc(" + this.getRealPC(code) + "):");
        for (ScopeDesc sd = code.getScopeDescAt(this.getRealPC(code)); sd != null; sd = sd.sender()) {
            tty.print(" ");
            sd.getMethod().printValueOn(tty);
            tty.print("  @" + sd.getBCI());
            tty.print("  reexecute=" + sd.getReexecute());
            tty.println();
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                PCDesc.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

