/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.SingletonBlob;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class RicochetBlob
extends SingletonBlob {
    private static CIntegerField bounceOffsetField;
    private static CIntegerField exceptionOffsetField;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("RicochetBlob");
        bounceOffsetField = type.getCIntegerField("_bounce_offset");
        exceptionOffsetField = type.getCIntegerField("_exception_offset");
    }

    public RicochetBlob(Address addr) {
        super(addr);
    }

    public boolean isRicochetBlob() {
        return true;
    }

    public Address bounceAddr() {
        return this.codeBegin().addOffsetTo(bounceOffsetField.getValue(this.addr));
    }

    public boolean returnsToBounceAddr(Address pc) {
        Address bouncePc = this.bounceAddr();
        return ((Object)pc).equals(bouncePc) || ((Object)pc.addOffsetTo(Frame.pcReturnOffset())).equals(bouncePc);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                RicochetBlob.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

