/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.cdbg.BlockSym;
import sun.jvm.hotspot.debugger.cdbg.CDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.GlobalSym;
import sun.jvm.hotspot.debugger.cdbg.LineNumberInfo;
import sun.jvm.hotspot.debugger.cdbg.LineNumberVisitor;
import sun.jvm.hotspot.debugger.cdbg.Sym;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicLineNumberInfo;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicLineNumberMapping;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicSym;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.LazyBlockSym;
import sun.jvm.hotspot.debugger.cdbg.basic.LazyType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class BasicCDebugInfoDataBase
implements CDebugInfoDataBase {
    private static final int INITIALIZED_STATE = 0;
    private static final int CONSTRUCTION_STATE = 1;
    private static final int RESOLVED_STATE = 2;
    private static final int COMPLETE_STATE = 3;
    private int state = 0;
    private Map lazyTypeMap;
    private List types;
    private Map nameToTypeMap;
    private Map lazySymMap;
    private List blocks;
    private Map nameToSymMap;
    private BasicLineNumberMapping lineNumbers;

    public void beginConstruction() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 0, "wrong state");
        }
        this.state = 1;
        this.lazyTypeMap = new HashMap();
        this.types = new ArrayList();
        this.lazySymMap = new HashMap();
        this.blocks = new ArrayList();
        this.nameToSymMap = new HashMap();
        this.lineNumbers = new BasicLineNumberMapping();
    }

    public void addType(Object lazyKey, Type type) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 1, "wrong state");
        }
        if (lazyKey != null) {
            if (this.lazyTypeMap.put(lazyKey, type) != null) {
                throw new RuntimeException("Type redefined for lazy key " + lazyKey);
            }
        } else {
            this.types.add(type);
        }
    }

    public void resolve(ResolveListener listener) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 1, "wrong state");
        }
        this.resolveLazyMap(listener);
        Iterator<Object> iter = this.types.listIterator();
        while (iter.hasNext()) {
            BasicType t2;
            BasicType t = (BasicType)iter.next();
            if (t == (t2 = (BasicType)t.resolveTypes(this, listener))) continue;
            iter.set(t2);
        }
        iter = this.blocks.iterator();
        while (iter.hasNext()) {
            ((BasicSym)iter.next()).resolve(this, listener);
        }
        iter = this.nameToSymMap.values().iterator();
        while (iter.hasNext()) {
            ((BasicSym)iter.next()).resolve(this, listener);
        }
        Collections.sort(this.blocks, new Comparator(){

            public int compare(Object o1, Object o2) {
                Address a2;
                BlockSym b1 = (BlockSym)o1;
                BlockSym b2 = (BlockSym)o2;
                Address a1 = b1.getAddress();
                if (AddressOps.lt(a1, a2 = b2.getAddress())) {
                    return -1;
                }
                if (AddressOps.gt(a1, a2)) {
                    return 1;
                }
                return 0;
            }
        });
        this.state = 2;
    }

    public void endConstruction() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 2, "wrong state");
        }
        Iterator<Object> iter = this.lazyTypeMap.values().iterator();
        while (iter.hasNext()) {
            this.types.add(iter.next());
        }
        this.nameToTypeMap = new HashMap();
        for (Type t : this.types) {
            if (t.isConst() || t.isVolatile()) continue;
            this.nameToTypeMap.put(t.getName(), t);
        }
        this.lazyTypeMap = null;
        this.lazySymMap = null;
        this.lineNumbers.sort();
        this.lineNumbers.recomputeEndPCs();
        this.state = 3;
    }

    public Type lookupType(String name) {
        return this.lookupType(name, 0);
    }

    public Type lookupType(String name, int cvAttributes) {
        BasicType t;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 3, "wrong state");
        }
        if ((t = (BasicType)this.nameToTypeMap.get(name)) != null && cvAttributes != 0) {
            t = (BasicType)t.getCVVariant(cvAttributes);
        }
        return t;
    }

    public void iterate(TypeVisitor v) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 3, "wrong state");
        }
        for (BasicType t : this.types) {
            t.visit(v);
        }
    }

    public void addBlock(Object key, BlockSym block) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(key != null, "key must be non-null");
        }
        this.lazySymMap.put(key, block);
        this.blocks.add(block);
    }

    public void addGlobalSym(GlobalSym sym) {
        this.nameToSymMap.put(sym.getName(), sym);
    }

    public BlockSym debugInfoForPC(Address pc) {
        return this.searchBlocks(pc, 0, this.blocks.size() - 1);
    }

    public GlobalSym lookupSym(String name) {
        return (GlobalSym)this.nameToSymMap.get(name);
    }

    public void addLineNumberInfo(BasicLineNumberInfo info) {
        this.lineNumbers.addLineNumberInfo(info);
    }

    public LineNumberInfo lineNumberForPC(Address pc) throws DebuggerException {
        return this.lineNumbers.lineNumberForPC(pc);
    }

    public void iterate(LineNumberVisitor v) {
        this.lineNumbers.iterate(v);
    }

    public Type resolveType(Type containingType, Type targetType, ResolveListener listener, String detail) {
        BasicType basicTargetType = (BasicType)targetType;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 1, "wrong state");
        }
        if (basicTargetType.isLazy()) {
            BasicType resolved = (BasicType)this.lazyTypeMap.get(((LazyType)targetType).getKey());
            if (resolved == null) {
                listener.resolveFailed(containingType, (LazyType)targetType, detail + " because target type was not found");
                return targetType;
            }
            if (resolved.isLazy()) {
                if (resolved.isConst() || resolved.isVolatile()) {
                    resolved = (BasicType)resolved.resolveTypes(this, listener);
                }
                if (resolved.isLazy()) {
                    listener.resolveFailed(containingType, (LazyType)targetType, detail + " because target type (with key " + (Integer)((LazyType)resolved).getKey() + (resolved.isConst() ? ", const" : ", not const") + (resolved.isVolatile() ? ", volatile" : ", not volatile") + ") was lazy");
                }
            }
            return resolved;
        }
        return targetType;
    }

    public Type resolveType(Sym containingSymbol, Type targetType, ResolveListener listener, String detail) {
        BasicType basicTargetType = (BasicType)targetType;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 1, "wrong state");
        }
        if (basicTargetType.isLazy()) {
            BasicType resolved = (BasicType)this.lazyTypeMap.get(((LazyType)targetType).getKey());
            if (resolved == null) {
                listener.resolveFailed(containingSymbol, (LazyType)targetType, detail);
                return targetType;
            }
            if (resolved.isLazy()) {
                if (resolved.isConst() || resolved.isVolatile()) {
                    resolved = (BasicType)resolved.resolveTypes(this, listener);
                }
                if (resolved.isLazy()) {
                    listener.resolveFailed(containingSymbol, (LazyType)targetType, detail);
                }
            }
            return resolved;
        }
        return targetType;
    }

    public Sym resolveSym(Sym containingSymbol, Sym targetSym, ResolveListener listener, String detail) {
        if (targetSym == null) {
            return null;
        }
        BasicSym basicTargetSym = (BasicSym)targetSym;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.state == 1, "wrong state");
        }
        if (basicTargetSym.isLazy()) {
            BasicSym resolved = (BasicSym)this.lazySymMap.get(((LazyBlockSym)targetSym).getKey());
            if (resolved == null) {
                listener.resolveFailed(containingSymbol, (LazyBlockSym)targetSym, detail);
                return targetSym;
            }
            if (resolved.isLazy()) {
                listener.resolveFailed(containingSymbol, (LazyBlockSym)targetSym, detail);
            }
            return resolved;
        }
        return targetSym;
    }

    private void resolveLazyMap(ResolveListener listener) {
        for (Map.Entry entry : this.lazyTypeMap.entrySet()) {
            BasicType t = (BasicType)entry.getValue();
            BasicType t2 = (BasicType)t.resolveTypes(this, listener);
            if (t2 == t) continue;
            entry.setValue(t2);
        }
    }

    private BlockSym searchBlocks(Address addr, int lowIdx, int highIdx) {
        if (highIdx < lowIdx) {
            return null;
        }
        if (lowIdx == highIdx || lowIdx == highIdx - 1) {
            Address lastAddr = null;
            BlockSym ret = null;
            for (int i = highIdx; i >= 0; --i) {
                BlockSym block = (BlockSym)this.blocks.get(i);
                if (!AddressOps.lte(block.getAddress(), addr)) continue;
                if (lastAddr != null && !AddressOps.equal(block.getAddress(), lastAddr)) break;
                lastAddr = block.getAddress();
                ret = block;
            }
            return ret;
        }
        int midIdx = lowIdx + highIdx >> 1;
        BlockSym block = (BlockSym)this.blocks.get(midIdx);
        if (AddressOps.lte(block.getAddress(), addr)) {
            return this.searchBlocks(addr, midIdx, highIdx);
        }
        return this.searchBlocks(addr, lowIdx, midIdx);
    }
}

