/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.g1;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.g1.HeapRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapRegionSeq
extends VMObject {
    private static AddressField regionsField;
    private static CIntegerField lengthField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("HeapRegionSeq");
        regionsField = type.getAddressField("_regions");
        lengthField = type.getCIntegerField("_length");
    }

    private HeapRegion at(long index) {
        Address arrayAddr = regionsField.getValue(this.addr);
        long offset = index * VM.getVM().getAddressSize();
        Address regionAddr = arrayAddr.getAddressAt(offset);
        return (HeapRegion)VMObjectFactory.newObject(HeapRegion.class, regionAddr);
    }

    public long length() {
        return lengthField.getValue(this.addr);
    }

    public Iterator<HeapRegion> heapRegionIterator() {
        return new HeapRegionIterator(this.addr);
    }

    public HeapRegionSeq(Address addr) {
        super(addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                HeapRegionSeq.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HeapRegionIterator
    implements Iterator<HeapRegion> {
        private long index = 0L;
        private long length;

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public HeapRegion next() {
            return HeapRegionSeq.this.at(this.index++);
        }

        @Override
        public void remove() {
        }

        HeapRegionIterator(Address addr) {
            this.length = HeapRegionSeq.this.length();
        }
    }
}

