/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.shared;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.shared.ImmutableSpace;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class MutableSpace
extends ImmutableSpace {
    private static AddressField topField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("MutableSpace");
        topField = type.getAddressField("_top");
    }

    public MutableSpace(Address addr) {
        super(addr);
    }

    public Address top() {
        return topField.getValue(this.addr);
    }

    public long used() {
        return this.top().minus(this.bottom());
    }

    public List getLiveRegions() {
        ArrayList<MemRegion> res = new ArrayList<MemRegion>();
        res.add(new MemRegion(this.bottom(), this.top()));
        return res;
    }

    public void printOn(PrintStream tty) {
        tty.print(" [" + this.bottom() + "," + this.top() + "," + this.end() + "] ");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                MutableSpace.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

