/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.CharValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import sun.jvm.hotspot.jdi.PrimitiveValueImpl;

public class CharValueImpl
extends PrimitiveValueImpl
implements CharValue {
    private char value;

    CharValueImpl(VirtualMachine aVm, char aValue) {
        super(aVm);
        this.value = aValue;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CharValue) {
            return this.value == ((CharValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int compareTo(CharValue charVal) {
        return this.value() - charVal.value();
    }

    public Type type() {
        return this.vm.theCharType();
    }

    public char value() {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value != '\u0000';
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > '\u007f') {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    short checkedShortValue() throws InvalidTypeException {
        if (this.value > Short.MAX_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }
}

