/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.FloatValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import sun.jvm.hotspot.jdi.PrimitiveValueImpl;

public class FloatValueImpl
extends PrimitiveValueImpl
implements FloatValue {
    private float value;

    FloatValueImpl(VirtualMachine aVm, float aValue) {
        super(aVm);
        this.value = aValue;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FloatValue) {
            return this.value == ((FloatValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int compareTo(FloatValue floatVal) {
        float other = floatVal.value();
        if (this.value() < other) {
            return -1;
        }
        if (this.value() == other) {
            return 0;
        }
        return 1;
    }

    public Type type() {
        return this.vm.theFloatType();
    }

    public float value() {
        return this.value;
    }

    public boolean booleanValue() {
        return (double)this.value != 0.0;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127.0f || this.value < -128.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535.0f || this.value < 0.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    short checkedShortValue() throws InvalidTypeException {
        if (this.value > 32767.0f || this.value < -32768.0f) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    int checkedIntValue() throws InvalidTypeException {
        int intValue = (int)this.value;
        if ((float)intValue != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to int");
        }
        return super.checkedIntValue();
    }

    long checkedLongValue() throws InvalidTypeException {
        long longValue = (long)this.value;
        if ((float)longValue != this.value) {
            throw new InvalidTypeException("Can't convert " + this.value + " to long");
        }
        return super.checkedLongValue();
    }

    public String toString() {
        return "" + this.value;
    }
}

