/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import sun.jvm.hotspot.jdi.PrimitiveValueImpl;

public class IntegerValueImpl
extends PrimitiveValueImpl
implements IntegerValue {
    private int value;

    IntegerValueImpl(VirtualMachine aVm, int aValue) {
        super(aVm);
        this.value = aValue;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IntegerValue) {
            return this.value == ((IntegerValue)obj).value() && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int compareTo(IntegerValue integerVal) {
        return this.value() - integerVal.value();
    }

    public Type type() {
        return this.vm.theIntegerType();
    }

    public int value() {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127 || this.value < -128) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    short checkedShortValue() throws InvalidTypeException {
        if (this.value > Short.MAX_VALUE || this.value < Short.MIN_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    public String toString() {
        return "" + this.value;
    }
}

