/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.memory.BinaryTreeDictionary;
import sun.jvm.hotspot.memory.CMSCollector;
import sun.jvm.hotspot.memory.CompactibleSpace;
import sun.jvm.hotspot.memory.FreeChunk;
import sun.jvm.hotspot.memory.FreeList;
import sun.jvm.hotspot.memory.LinearAllocBlock;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class CompactibleFreeListSpace
extends CompactibleSpace {
    private static AddressField collectorField;
    private static AddressField indexedFreeListField;
    private static AddressField dictionaryField;
    private static long smallLinearAllocBlockFieldOffset;
    private static long indexedFreeListSizeOf;
    private int heapWordSize;
    private int IndexSetStart;
    private int IndexSetSize;
    private int IndexSetStride;
    private static long MinChunkSizeInBytes;

    private static synchronized void initialize(TypeDataBase db) {
        long sizeofFreeChunk = db.lookupType("FreeChunk").getSize();
        VM vm = VM.getVM();
        MinChunkSizeInBytes = CompactibleFreeListSpace.numQuanta(sizeofFreeChunk, vm.getMinObjAlignmentInBytes()) * (long)vm.getMinObjAlignmentInBytes();
        Type type = db.lookupType("CompactibleFreeListSpace");
        collectorField = type.getAddressField("_collector");
        collectorField = type.getAddressField("_collector");
        dictionaryField = type.getAddressField("_dictionary");
        indexedFreeListField = type.getAddressField("_indexedFreeList[0]");
        smallLinearAllocBlockFieldOffset = type.getField("_smallLinearAllocBlock").getOffset();
    }

    public CompactibleFreeListSpace(Address addr) {
        super(addr);
        VM vm = VM.getVM();
        this.heapWordSize = vm.getHeapWordSize();
        this.IndexSetStride = this.IndexSetStart = vm.getMinObjAlignmentInBytes() / this.heapWordSize;
        this.IndexSetSize = 257;
    }

    public CMSCollector collector() {
        return (CMSCollector)VMObjectFactory.newObject(CMSCollector.class, collectorField.getValue(this.addr));
    }

    public long free0() {
        return this.capacity() - this.used0();
    }

    public long used() {
        return this.capacity() - this.free();
    }

    public long used0() {
        List regions = this.getLiveRegions();
        long usedSize = 0L;
        for (MemRegion mr : regions) {
            usedSize += mr.byteSize();
        }
        return usedSize;
    }

    public long free() {
        long size = 0L;
        Address cur = this.addr.addOffsetTo(indexedFreeListField.getOffset());
        cur = cur.addOffsetTo((long)this.IndexSetStart * FreeList.sizeOf());
        for (int i = this.IndexSetStart; i < this.IndexSetSize; i += this.IndexSetStride) {
            FreeList freeList = (FreeList)VMObjectFactory.newObject(FreeList.class, cur);
            size += (long)i * freeList.count();
            cur = cur.addOffsetTo((long)this.IndexSetStride * FreeList.sizeOf());
        }
        BinaryTreeDictionary bfbd = (BinaryTreeDictionary)VMObjectFactory.newObject(BinaryTreeDictionary.class, dictionaryField.getValue(this.addr));
        size += bfbd.size();
        LinearAllocBlock lab = (LinearAllocBlock)VMObjectFactory.newObject(LinearAllocBlock.class, this.addr.addOffsetTo(smallLinearAllocBlockFieldOffset));
        return (size += lab.word_size()) * (long)this.heapWordSize;
    }

    public void printOn(PrintStream tty) {
        tty.print("free-list-space");
        tty.print("[ " + this.bottom() + " , " + this.end() + " ) ");
        long cap = this.capacity();
        long used_size = this.used();
        long free_size = this.free();
        int used_perc = (int)((double)used_size / (double)cap * 100.0);
        tty.print("space capacity = " + cap + " used(" + used_perc + "%)= " + used_size + " ");
        tty.print("free= " + free_size);
        tty.print("\n");
    }

    public Address skipBlockSizeUsingPrintezisBits(Address pos) {
        CMSCollector collector = this.collector();
        long size = 0L;
        Address addr = null;
        if (collector != null && (size = collector.blockSizeUsingPrintezisBits(pos)) >= 3L) {
            addr = pos.addOffsetTo(CompactibleFreeListSpace.adjustObjectSizeInBytes(size));
        }
        return addr;
    }

    public List getLiveRegions() {
        Address cur;
        ArrayList<MemRegion> res = new ArrayList<MemRegion>();
        VM vm = VM.getVM();
        JVMDebugger dbg = vm.getDebugger();
        ObjectHeap heap = vm.getObjectHeap();
        Address regionStart = cur = this.bottom();
        Address limit = this.end();
        long addressSize = vm.getAddressSize();
        while (cur.lessThan(limit)) {
            Address klassOop = cur.getAddressAt(addressSize);
            if (FreeChunk.indicatesFreeChunk(cur)) {
                if (!((Object)cur).equals(regionStart)) {
                    res.add(new MemRegion(regionStart, cur));
                }
                FreeChunk fc = (FreeChunk)VMObjectFactory.newObject(FreeChunk.class, cur);
                long chunkSize = fc.size();
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(chunkSize > 0L, "invalid FreeChunk size");
                }
                regionStart = cur = cur.addOffsetTo(chunkSize * addressSize);
                continue;
            }
            if (klassOop != null) {
                Oop obj = heap.newOop(cur.addOffsetToAsOopHandle(0L));
                long objectSize = obj.getObjectSize();
                cur = cur.addOffsetTo(CompactibleFreeListSpace.adjustObjectSizeInBytes(objectSize));
                continue;
            }
            long size = this.collector().blockSizeUsingPrintezisBits(cur);
            if (size == -1L) {
                System.err.println("Printezis bits not set...");
                break;
            }
            cur = cur.addOffsetTo(CompactibleFreeListSpace.adjustObjectSizeInBytes(size));
        }
        return res;
    }

    private static long numQuanta(long x, long y) {
        return (x + y - 1L) / y;
    }

    public static long adjustObjectSizeInBytes(long sizeInBytes) {
        return Oop.alignObjectSize(Math.max(sizeInBytes, MinChunkSizeInBytes));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CompactibleFreeListSpace.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

