/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.Dictionary;
import sun.jvm.hotspot.memory.LoaderConstraintTable;
import sun.jvm.hotspot.memory.PlaceholderTable;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class SystemDictionary {
    private static AddressField dictionaryField;
    private static AddressField sharedDictionaryField;
    private static AddressField placeholdersField;
    private static AddressField loaderConstraintTableField;
    private static OopField javaSystemLoaderField;
    private static OopField objectKlassField;
    private static OopField classLoaderKlassField;
    private static OopField stringKlassField;
    private static OopField systemKlassField;
    private static OopField threadKlassField;
    private static OopField threadGroupKlassField;
    private static OopField methodHandleKlassField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("SystemDictionary");
        dictionaryField = type.getAddressField("_dictionary");
        sharedDictionaryField = type.getAddressField("_shared_dictionary");
        placeholdersField = type.getAddressField("_placeholders");
        loaderConstraintTableField = type.getAddressField("_loader_constraints");
        javaSystemLoaderField = type.getOopField("_java_system_loader");
        objectKlassField = type.getOopField(SystemDictionary.WK_KLASS("Object_klass"));
        classLoaderKlassField = type.getOopField(SystemDictionary.WK_KLASS("ClassLoader_klass"));
        stringKlassField = type.getOopField(SystemDictionary.WK_KLASS("String_klass"));
        systemKlassField = type.getOopField(SystemDictionary.WK_KLASS("System_klass"));
        threadKlassField = type.getOopField(SystemDictionary.WK_KLASS("Thread_klass"));
        threadGroupKlassField = type.getOopField(SystemDictionary.WK_KLASS("ThreadGroup_klass"));
        methodHandleKlassField = type.getOopField(SystemDictionary.WK_KLASS("MethodHandle_klass"));
    }

    private static String WK_KLASS(String name) {
        return "_well_known_klasses[SystemDictionary::" + SystemDictionary.WK_KLASS_ENUM_NAME(name) + "]";
    }

    private static String WK_KLASS_ENUM_NAME(String kname) {
        return kname + "_knum";
    }

    public Dictionary dictionary() {
        Address tmp = dictionaryField.getValue();
        return (Dictionary)VMObjectFactory.newObject(Dictionary.class, tmp);
    }

    public Dictionary sharedDictionary() {
        Address tmp = sharedDictionaryField.getValue();
        return (Dictionary)VMObjectFactory.newObject(Dictionary.class, tmp);
    }

    public PlaceholderTable placeholders() {
        Address tmp = placeholdersField.getValue();
        return (PlaceholderTable)VMObjectFactory.newObject(PlaceholderTable.class, tmp);
    }

    public LoaderConstraintTable constraints() {
        Address tmp = placeholdersField.getValue();
        return (LoaderConstraintTable)VMObjectFactory.newObject(LoaderConstraintTable.class, tmp);
    }

    public static InstanceKlass getThreadKlass() {
        return (InstanceKlass)SystemDictionary.newOop(threadKlassField.getValue());
    }

    public static InstanceKlass getThreadGroupKlass() {
        return (InstanceKlass)SystemDictionary.newOop(threadGroupKlassField.getValue());
    }

    public static InstanceKlass getObjectKlass() {
        return (InstanceKlass)SystemDictionary.newOop(objectKlassField.getValue());
    }

    public static InstanceKlass getStringKlass() {
        return (InstanceKlass)SystemDictionary.newOop(stringKlassField.getValue());
    }

    public static InstanceKlass getClassLoaderKlass() {
        return (InstanceKlass)SystemDictionary.newOop(classLoaderKlassField.getValue());
    }

    public static InstanceKlass getSystemKlass() {
        return (InstanceKlass)SystemDictionary.newOop(systemKlassField.getValue());
    }

    public static InstanceKlass getMethodHandleKlass() {
        return (InstanceKlass)SystemDictionary.newOop(methodHandleKlassField.getValue());
    }

    public InstanceKlass getAbstractOwnableSynchronizerKlass() {
        return (InstanceKlass)this.find("java/util/concurrent/locks/AbstractOwnableSynchronizer", null, null);
    }

    public static Oop javaSystemLoader() {
        return SystemDictionary.newOop(javaSystemLoaderField.getValue());
    }

    private static Oop newOop(OopHandle handle) {
        return VM.getVM().getObjectHeap().newOop(handle);
    }

    public Klass find(String className, Oop classLoader, Oop protectionDomain) {
        Symbol sym = VM.getVM().getSymbolTable().probe(className);
        if (sym == null) {
            return null;
        }
        return this.find(sym, classLoader, protectionDomain);
    }

    public Klass find(Symbol className, Oop classLoader, Oop protectionDomain) {
        Dictionary dict = this.dictionary();
        long hash = dict.computeHash(className, classLoader);
        int index = dict.hashToIndex(hash);
        return dict.find(index, hash, className, classLoader, protectionDomain);
    }

    public void allClassesDo(final ClassVisitor v) {
        ClassVisitor visitor = new ClassVisitor(){

            public void visit(Klass k) {
                for (Klass l = k; l != null; l = l.arrayKlassOrNull()) {
                    v.visit(l);
                }
            }
        };
        this.classesDo(visitor);
        VM.getVM().getUniverse().basicTypeClassesDo(visitor);
    }

    public void classesDo(ClassVisitor v) {
        this.dictionary().classesDo(v);
    }

    public void classesDo(ClassAndLoaderVisitor v) {
        this.dictionary().classesDo(v);
    }

    public void primArrayClassesDo(ClassAndLoaderVisitor v) {
        this.placeholders().primArrayClassesDo(v);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                SystemDictionary.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static interface ClassAndLoaderVisitor {
        public void visit(Klass var1, Oop var2);
    }

    public static interface ClassVisitor {
        public void visit(Klass var1);
    }
}

