/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.ProfileData;

abstract class ArrayData
extends ProfileData {
    static final int arrayLenOffSet = 0;
    static final int arrayStartOffSet = 1;

    int arrayUintAt(int index) {
        int aindex = index + 1;
        return this.uintAt(aindex);
    }

    int arrayIntAt(int index) {
        int aindex = index + 1;
        return this.intAt(aindex);
    }

    Oop arrayOopAt(int index) {
        int aindex = index + 1;
        return this.oopAt(aindex);
    }

    static int arrayElementOffset(int index) {
        return ArrayData.cellOffset(1 + index);
    }

    ArrayData(DataLayout layout) {
        super(layout);
    }

    static int staticCellCount() {
        return -1;
    }

    int arrayLen() {
        return this.intAt(0);
    }

    public int cellCount() {
        return this.arrayLen() + 1;
    }

    static int arrayLenOffset() {
        return ArrayData.cellOffset(0);
    }

    static int arrayStartOffset() {
        return ArrayData.cellOffset(1);
    }
}

