/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCacheEntry;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class ConstantPoolCache
extends Oop {
    private static OopField constants;
    private static long baseOffset;
    private static long elementSize;
    private static CIntField length;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("constantPoolCacheOopDesc");
        constants = new OopField(type.getOopField("_constant_pool"), 0L);
        baseOffset = type.getSize();
        Type elType = db.lookupType("ConstantPoolCacheEntry");
        elementSize = elType.getSize();
        length = new CIntField(type.getCIntegerField("_length"), 0L);
    }

    ConstantPoolCache(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public boolean isConstantPoolCache() {
        return true;
    }

    public ConstantPool getConstants() {
        return (ConstantPool)constants.getValue(this);
    }

    public long getObjectSize() {
        return ConstantPoolCache.alignObjectSize(baseOffset + (long)this.getLength() * elementSize);
    }

    public ConstantPoolCacheEntry getEntryAt(int i) {
        if (i < 0 || i >= this.getLength()) {
            throw new IndexOutOfBoundsException(i + " " + this.getLength());
        }
        return new ConstantPoolCacheEntry(this, i);
    }

    public static boolean isSecondaryIndex(int i) {
        return i < 0;
    }

    public static int decodeSecondaryIndex(int i) {
        return ConstantPoolCache.isSecondaryIndex(i) ? ~i : i;
    }

    public static int encodeSecondaryIndex(int i) {
        return !ConstantPoolCache.isSecondaryIndex(i) ? ~i : i;
    }

    public ConstantPoolCacheEntry getSecondaryEntryAt(int i) {
        int rawIndex = i;
        if (ConstantPoolCache.isSecondaryIndex(i)) {
            rawIndex = ConstantPoolCache.decodeSecondaryIndex(i);
        }
        ConstantPoolCacheEntry e = this.getEntryAt(rawIndex);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(e.isSecondaryEntry(), "must be a secondary entry:" + rawIndex);
        }
        return e;
    }

    public ConstantPoolCacheEntry getMainEntryAt(int i) {
        int primaryIndex = i;
        if (ConstantPoolCache.isSecondaryIndex(i)) {
            int rawIndex = ConstantPoolCache.decodeSecondaryIndex(i);
            primaryIndex = this.getEntryAt(rawIndex).getMainEntryIndex();
        }
        ConstantPoolCacheEntry e = this.getEntryAt(primaryIndex);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!e.isSecondaryEntry(), "must not be a secondary entry:" + primaryIndex);
        }
        return e;
    }

    public int getIntAt(int entry, int fld) {
        long offset = baseOffset + (long)entry * elementSize + (long)fld * this.getHeap().getIntSize();
        return (int)this.getHandle().getCIntegerAt(offset, this.getHeap().getIntSize(), true);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("ConstantPoolCache for " + this.getConstants().getPoolHolder().getName().asString());
    }

    public int getLength() {
        return (int)length.getValue(this);
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(constants, true);
            for (int i = 0; i < this.getLength(); ++i) {
                ConstantPoolCacheEntry entry = this.getEntryAt(i);
                entry.iterateFields(visitor);
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ConstantPoolCache.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

