/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.BitData;
import sun.jvm.hotspot.oops.DataLayout;

public class CounterData
extends BitData {
    static final int countOff = 0;
    static final int counterCellCount = 1;

    public CounterData(DataLayout layout) {
        super(layout);
    }

    static int staticCellCount() {
        return 1;
    }

    public int cellCount() {
        return CounterData.staticCellCount();
    }

    int count() {
        return this.uintAt(0);
    }

    static int countOffset() {
        return CounterData.cellOffset(0);
    }

    static int counterDataSize() {
        return CounterData.cellOffset(1);
    }

    public void printDataOn(PrintStream st) {
        this.printShared(st, "CounterData");
        st.println("count(" + this.count() + ")");
    }
}

