/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopUtilities;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Instance
extends Oop {
    private static long typeSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("instanceOopDesc");
        typeSize = type.getSize();
    }

    Instance(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public static long getHeaderSize() {
        if (VM.getVM().isCompressedOopsEnabled()) {
            return typeSize - VM.getVM().getIntSize();
        }
        return typeSize;
    }

    public boolean isInstance() {
        return true;
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        ((InstanceKlass)this.getKlass()).iterateNonStaticFields(visitor, this);
    }

    public void printValueOn(PrintStream tty) {
        if (this.getKlass().getName().asString().equals("java/lang/String")) {
            tty.print("\"" + OopUtilities.stringOopToString(this) + "\"");
        } else {
            super.printValueOn(tty);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Instance.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

