/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.SymbolTable;
import sun.jvm.hotspot.oops.AccessFlags;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.BreakpointInfo;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.Field;
import sun.jvm.hotspot.oops.FieldType;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.NarrowOopField;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.runtime.vmSymbols;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class InstanceKlass
extends Klass {
    private static int ACCESS_FLAGS_OFFSET;
    private static int NAME_INDEX_OFFSET;
    private static int SIGNATURE_INDEX_OFFSET;
    private static int INITVAL_INDEX_OFFSET;
    private static int LOW_OFFSET;
    private static int HIGH_OFFSET;
    private static int GENERIC_SIGNATURE_INDEX_OFFSET;
    private static int FIELD_SLOTS;
    public static int IMPLEMENTORS_LIMIT;
    private static int CLASS_STATE_UNPARSABLE_BY_GC;
    private static int CLASS_STATE_ALLOCATED;
    private static int CLASS_STATE_LOADED;
    private static int CLASS_STATE_LINKED;
    private static int CLASS_STATE_BEING_INITIALIZED;
    private static int CLASS_STATE_FULLY_INITIALIZED;
    private static int CLASS_STATE_INITIALIZATION_ERROR;
    private static OopField arrayKlasses;
    private static OopField methods;
    private static OopField methodOrdering;
    private static OopField localInterfaces;
    private static OopField transitiveInterfaces;
    private static CIntField nofImplementors;
    private static OopField[] implementors;
    private static OopField fields;
    private static CIntField javaFieldsCount;
    private static OopField constants;
    private static OopField classLoader;
    private static OopField protectionDomain;
    private static OopField signers;
    private static AddressField sourceFileName;
    private static AddressField sourceDebugExtension;
    private static OopField innerClasses;
    private static CIntField nonstaticFieldSize;
    private static CIntField staticFieldSize;
    private static CIntField staticOopFieldCount;
    private static CIntField nonstaticOopMapSize;
    private static CIntField isMarkedDependent;
    private static CIntField initState;
    private static CIntField vtableLen;
    private static CIntField itableLen;
    private static AddressField breakpoints;
    private static AddressField genericSignature;
    private static CIntField majorVersion;
    private static CIntField minorVersion;
    private static long headerSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("instanceKlass");
        arrayKlasses = new OopField(type.getOopField("_array_klasses"), Oop.getHeaderSize());
        methods = new OopField(type.getOopField("_methods"), Oop.getHeaderSize());
        methodOrdering = new OopField(type.getOopField("_method_ordering"), Oop.getHeaderSize());
        localInterfaces = new OopField(type.getOopField("_local_interfaces"), Oop.getHeaderSize());
        transitiveInterfaces = new OopField(type.getOopField("_transitive_interfaces"), Oop.getHeaderSize());
        nofImplementors = new CIntField(type.getCIntegerField("_nof_implementors"), Oop.getHeaderSize());
        IMPLEMENTORS_LIMIT = db.lookupIntConstant("instanceKlass::implementors_limit");
        implementors = new OopField[IMPLEMENTORS_LIMIT];
        for (int i = 0; i < IMPLEMENTORS_LIMIT; ++i) {
            long arrayOffset = Oop.getHeaderSize() + (long)i * db.getAddressSize();
            InstanceKlass.implementors[i] = new OopField(type.getOopField("_implementors[0]"), arrayOffset);
        }
        fields = new OopField(type.getOopField("_fields"), Oop.getHeaderSize());
        javaFieldsCount = new CIntField(type.getCIntegerField("_java_fields_count"), Oop.getHeaderSize());
        constants = new OopField(type.getOopField("_constants"), Oop.getHeaderSize());
        classLoader = new OopField(type.getOopField("_class_loader"), Oop.getHeaderSize());
        protectionDomain = new OopField(type.getOopField("_protection_domain"), Oop.getHeaderSize());
        signers = new OopField(type.getOopField("_signers"), Oop.getHeaderSize());
        sourceFileName = type.getAddressField("_source_file_name");
        sourceDebugExtension = type.getAddressField("_source_debug_extension");
        innerClasses = new OopField(type.getOopField("_inner_classes"), Oop.getHeaderSize());
        nonstaticFieldSize = new CIntField(type.getCIntegerField("_nonstatic_field_size"), Oop.getHeaderSize());
        staticFieldSize = new CIntField(type.getCIntegerField("_static_field_size"), Oop.getHeaderSize());
        staticOopFieldCount = new CIntField(type.getCIntegerField("_static_oop_field_count"), Oop.getHeaderSize());
        nonstaticOopMapSize = new CIntField(type.getCIntegerField("_nonstatic_oop_map_size"), Oop.getHeaderSize());
        isMarkedDependent = new CIntField(type.getCIntegerField("_is_marked_dependent"), Oop.getHeaderSize());
        initState = new CIntField(type.getCIntegerField("_init_state"), Oop.getHeaderSize());
        vtableLen = new CIntField(type.getCIntegerField("_vtable_len"), Oop.getHeaderSize());
        itableLen = new CIntField(type.getCIntegerField("_itable_len"), Oop.getHeaderSize());
        breakpoints = type.getAddressField("_breakpoints");
        genericSignature = type.getAddressField("_generic_signature");
        majorVersion = new CIntField(type.getCIntegerField("_major_version"), Oop.getHeaderSize());
        minorVersion = new CIntField(type.getCIntegerField("_minor_version"), Oop.getHeaderSize());
        headerSize = InstanceKlass.alignObjectOffset(Oop.getHeaderSize() + type.getSize());
        ACCESS_FLAGS_OFFSET = db.lookupIntConstant("FieldInfo::access_flags_offset");
        NAME_INDEX_OFFSET = db.lookupIntConstant("FieldInfo::name_index_offset");
        SIGNATURE_INDEX_OFFSET = db.lookupIntConstant("FieldInfo::signature_index_offset");
        INITVAL_INDEX_OFFSET = db.lookupIntConstant("FieldInfo::initval_index_offset");
        LOW_OFFSET = db.lookupIntConstant("FieldInfo::low_offset");
        HIGH_OFFSET = db.lookupIntConstant("FieldInfo::high_offset");
        GENERIC_SIGNATURE_INDEX_OFFSET = db.lookupIntConstant("FieldInfo::generic_signature_offset");
        FIELD_SLOTS = db.lookupIntConstant("FieldInfo::field_slots");
        CLASS_STATE_UNPARSABLE_BY_GC = db.lookupIntConstant("instanceKlass::unparsable_by_gc");
        CLASS_STATE_ALLOCATED = db.lookupIntConstant("instanceKlass::allocated");
        CLASS_STATE_LOADED = db.lookupIntConstant("instanceKlass::loaded");
        CLASS_STATE_LINKED = db.lookupIntConstant("instanceKlass::linked");
        CLASS_STATE_BEING_INITIALIZED = db.lookupIntConstant("instanceKlass::being_initialized");
        CLASS_STATE_FULLY_INITIALIZED = db.lookupIntConstant("instanceKlass::fully_initialized");
        CLASS_STATE_INITIALIZATION_ERROR = db.lookupIntConstant("instanceKlass::initialization_error");
    }

    InstanceKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
        if (this.getJavaFieldsCount() != this.getAllFieldsCount()) {
            for (int i = this.getJavaFieldsCount(); i < this.getAllFieldsCount(); ++i) {
                this.getFieldName(i);
                this.getFieldSignature(i);
            }
        }
    }

    public int getInitStateAsInt() {
        return (int)initState.getValue(this);
    }

    public ClassState getInitState() {
        int state = this.getInitStateAsInt();
        if (state == CLASS_STATE_UNPARSABLE_BY_GC) {
            return ClassState.UNPARSABLE_BY_GC;
        }
        if (state == CLASS_STATE_ALLOCATED) {
            return ClassState.ALLOCATED;
        }
        if (state == CLASS_STATE_LOADED) {
            return ClassState.LOADED;
        }
        if (state == CLASS_STATE_LINKED) {
            return ClassState.LINKED;
        }
        if (state == CLASS_STATE_BEING_INITIALIZED) {
            return ClassState.BEING_INITIALIZED;
        }
        if (state == CLASS_STATE_FULLY_INITIALIZED) {
            return ClassState.FULLY_INITIALIZED;
        }
        if (state == CLASS_STATE_INITIALIZATION_ERROR) {
            return ClassState.INITIALIZATION_ERROR;
        }
        throw new RuntimeException("should not reach here");
    }

    public boolean isLoaded() {
        return this.getInitStateAsInt() >= CLASS_STATE_LOADED;
    }

    public boolean isLinked() {
        return this.getInitStateAsInt() >= CLASS_STATE_LINKED;
    }

    public boolean isInitialized() {
        return this.getInitStateAsInt() == CLASS_STATE_FULLY_INITIALIZED;
    }

    public boolean isNotInitialized() {
        return this.getInitStateAsInt() < CLASS_STATE_BEING_INITIALIZED;
    }

    public boolean isBeingInitialized() {
        return this.getInitStateAsInt() == CLASS_STATE_BEING_INITIALIZED;
    }

    public boolean isInErrorState() {
        return this.getInitStateAsInt() == CLASS_STATE_INITIALIZATION_ERROR;
    }

    public int getClassStatus() {
        int result = 0;
        if (this.isLinked()) {
            result |= 3;
        }
        if (this.isInitialized()) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(this.isLinked(), "Class status is not consistent");
            }
            result |= 4;
        }
        if (this.isInErrorState()) {
            result |= 8;
        }
        return result;
    }

    public long getObjectSize(Oop object) {
        return this.getSizeHelper() * VM.getVM().getAddressSize();
    }

    public static long getHeaderSize() {
        return headerSize;
    }

    public short getFieldAccessFlags(int index) {
        return this.getFields().getShortAt(index * FIELD_SLOTS + ACCESS_FLAGS_OFFSET);
    }

    public short getFieldNameIndex(int index) {
        if (index >= this.getJavaFieldsCount()) {
            throw new IndexOutOfBoundsException("not a Java field;");
        }
        return this.getFields().getShortAt(index * FIELD_SLOTS + NAME_INDEX_OFFSET);
    }

    public Symbol getFieldName(int index) {
        short nameIndex = this.getFields().getShortAt(index * FIELD_SLOTS + NAME_INDEX_OFFSET);
        if (index < this.getJavaFieldsCount()) {
            return this.getConstants().getSymbolAt(nameIndex);
        }
        return vmSymbols.symbolAt(nameIndex);
    }

    public short getFieldSignatureIndex(int index) {
        if (index >= this.getJavaFieldsCount()) {
            throw new IndexOutOfBoundsException("not a Java field;");
        }
        return this.getFields().getShortAt(index * FIELD_SLOTS + SIGNATURE_INDEX_OFFSET);
    }

    public Symbol getFieldSignature(int index) {
        short signatureIndex = this.getFields().getShortAt(index * FIELD_SLOTS + SIGNATURE_INDEX_OFFSET);
        if (index < this.getJavaFieldsCount()) {
            return this.getConstants().getSymbolAt(signatureIndex);
        }
        return vmSymbols.symbolAt(signatureIndex);
    }

    public short getFieldGenericSignatureIndex(int index) {
        return this.getFields().getShortAt(index * FIELD_SLOTS + GENERIC_SIGNATURE_INDEX_OFFSET);
    }

    public Symbol getFieldGenericSignature(int index) {
        short genericSignatureIndex = this.getFieldGenericSignatureIndex(index);
        if (genericSignatureIndex != 0) {
            return this.getConstants().getSymbolAt(genericSignatureIndex);
        }
        return null;
    }

    public short getFieldInitialValueIndex(int index) {
        if (index >= this.getJavaFieldsCount()) {
            throw new IndexOutOfBoundsException("not a Java field;");
        }
        return this.getFields().getShortAt(index * FIELD_SLOTS + INITVAL_INDEX_OFFSET);
    }

    public int getFieldOffset(int index) {
        TypeArray fields = this.getFields();
        return VM.getVM().buildIntFromShorts(fields.getShortAt(index * FIELD_SLOTS + LOW_OFFSET), fields.getShortAt(index * FIELD_SLOTS + HIGH_OFFSET));
    }

    public Klass getArrayKlasses() {
        return (Klass)arrayKlasses.getValue(this);
    }

    public ObjArray getMethods() {
        return (ObjArray)methods.getValue(this);
    }

    public TypeArray getMethodOrdering() {
        return (TypeArray)methodOrdering.getValue(this);
    }

    public ObjArray getLocalInterfaces() {
        return (ObjArray)localInterfaces.getValue(this);
    }

    public ObjArray getTransitiveInterfaces() {
        return (ObjArray)transitiveInterfaces.getValue(this);
    }

    public long nofImplementors() {
        return nofImplementors.getValue(this);
    }

    public Klass getImplementor() {
        return (Klass)implementors[0].getValue(this);
    }

    public Klass getImplementor(int i) {
        return (Klass)implementors[i].getValue(this);
    }

    public TypeArray getFields() {
        return (TypeArray)fields.getValue(this);
    }

    public int getJavaFieldsCount() {
        return (int)javaFieldsCount.getValue(this);
    }

    public int getAllFieldsCount() {
        return (int)this.getFields().getLength() / FIELD_SLOTS;
    }

    public ConstantPool getConstants() {
        return (ConstantPool)constants.getValue(this);
    }

    public Oop getClassLoader() {
        return classLoader.getValue(this);
    }

    public Oop getProtectionDomain() {
        return protectionDomain.getValue(this);
    }

    public ObjArray getSigners() {
        return (ObjArray)signers.getValue(this);
    }

    public Symbol getSourceFileName() {
        return this.getSymbol(sourceFileName);
    }

    public Symbol getSourceDebugExtension() {
        return this.getSymbol(sourceDebugExtension);
    }

    public TypeArray getInnerClasses() {
        return (TypeArray)innerClasses.getValue(this);
    }

    public long getNonstaticFieldSize() {
        return nonstaticFieldSize.getValue(this);
    }

    public long getStaticOopFieldCount() {
        return staticOopFieldCount.getValue(this);
    }

    public long getNonstaticOopMapSize() {
        return nonstaticOopMapSize.getValue(this);
    }

    public boolean getIsMarkedDependent() {
        return isMarkedDependent.getValue(this) != 0L;
    }

    public long getVtableLen() {
        return vtableLen.getValue(this);
    }

    public long getItableLen() {
        return itableLen.getValue(this);
    }

    public Symbol getGenericSignature() {
        return this.getSymbol(genericSignature);
    }

    public long majorVersion() {
        return majorVersion.getValue(this);
    }

    public long minorVersion() {
        return minorVersion.getValue(this);
    }

    public long getSizeHelper() {
        int lh = this.getLayoutHelper();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(lh > 0, "layout helper initialized for instance class");
        }
        return (long)lh / VM.getVM().getAddressSize();
    }

    public long computeModifierFlags() {
        int length;
        long access = this.getAccessFlags();
        TypeArray innerClassList = this.getInnerClasses();
        int n = length = innerClassList == null ? 0 : (int)innerClassList.getLength();
        if (length > 0) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(length % 4 == 0, "just checking");
            }
            for (int i = 0; i < length; i += 4) {
                short ioff = innerClassList.getShortAt(i + 0);
                if (ioff == 0) continue;
                ConstantPool.CPSlot classInfo = this.getConstants().getSlotAt(ioff);
                Symbol name = null;
                if (classInfo.isOop()) {
                    name = ((Klass)classInfo.getOop()).getName();
                } else if (classInfo.isMetaData()) {
                    name = classInfo.getSymbol();
                } else {
                    throw new RuntimeException("should not reach here");
                }
                if (!name.equals(this.getName())) continue;
                access = innerClassList.getShortAt(i + 3);
                break;
            }
        }
        return access & 0xFFFFFFFFFFFFFFDFL & 0x7FFFL;
    }

    public boolean isInnerClassName(Symbol sym) {
        return this.isInInnerClasses(sym, false);
    }

    public boolean isInnerOrLocalClassName(Symbol sym) {
        return this.isInInnerClasses(sym, true);
    }

    private boolean isInInnerClasses(Symbol sym, boolean includeLocals) {
        int length;
        TypeArray innerClassList = this.getInnerClasses();
        int n = length = innerClassList == null ? 0 : (int)innerClassList.getLength();
        if (length > 0) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(length % 4 == 0, "just checking");
            }
            for (int i = 0; i < length; i += 4) {
                short ioff = innerClassList.getShortAt(i + 0);
                if (ioff == 0) continue;
                ConstantPool.CPSlot iclassInfo = this.getConstants().getSlotAt(ioff);
                Symbol innerName = null;
                if (iclassInfo.isOop()) {
                    innerName = ((Klass)iclassInfo.getOop()).getName();
                } else if (iclassInfo.isMetaData()) {
                    innerName = iclassInfo.getSymbol();
                } else {
                    throw new RuntimeException("should not reach here");
                }
                Symbol myname = this.getName();
                short ooff = innerClassList.getShortAt(i + 1);
                short innerNameIndex = innerClassList.getShortAt(i + 2);
                if (ooff == 0) {
                    if (!includeLocals || !innerName.equals(sym) || !innerName.asString().startsWith(myname.asString())) continue;
                    return innerNameIndex != 0;
                }
                ConstantPool.CPSlot oclassInfo = this.getConstants().getSlotAt(ooff);
                Symbol outerName = null;
                if (oclassInfo.isOop()) {
                    outerName = ((Klass)oclassInfo.getOop()).getName();
                } else if (oclassInfo.isMetaData()) {
                    outerName = oclassInfo.getSymbol();
                } else {
                    throw new RuntimeException("should not reach here");
                }
                if (!outerName.equals(myname) || !innerName.equals(sym)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean implementsInterface(Klass k) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(k.isInterface(), "should not reach here");
        }
        ObjArray interfaces = this.getTransitiveInterfaces();
        int len = (int)interfaces.getLength();
        for (int i = 0; i < len; ++i) {
            if (!interfaces.getObjAt(i).equals(k)) continue;
            return true;
        }
        return false;
    }

    boolean computeSubtypeOf(Klass k) {
        if (k.isInterface()) {
            return this.implementsInterface(k);
        }
        return super.computeSubtypeOf(k);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("InstanceKlass for " + this.getName().asString());
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(arrayKlasses, true);
            visitor.doOop(methods, true);
            visitor.doOop(methodOrdering, true);
            visitor.doOop(localInterfaces, true);
            visitor.doOop(transitiveInterfaces, true);
            visitor.doCInt(nofImplementors, true);
            for (int i = 0; i < IMPLEMENTORS_LIMIT; ++i) {
                visitor.doOop(implementors[i], true);
            }
            visitor.doOop(fields, true);
            visitor.doOop(constants, true);
            visitor.doOop(classLoader, true);
            visitor.doOop(protectionDomain, true);
            visitor.doOop(signers, true);
            visitor.doOop(innerClasses, true);
            visitor.doCInt(nonstaticFieldSize, true);
            visitor.doCInt(staticFieldSize, true);
            visitor.doCInt(staticOopFieldCount, true);
            visitor.doCInt(nonstaticOopMapSize, true);
            visitor.doCInt(isMarkedDependent, true);
            visitor.doCInt(initState, true);
            visitor.doCInt(vtableLen, true);
            visitor.doCInt(itableLen, true);
        }
    }

    public void iterateStaticFields(OopVisitor visitor) {
        visitor.setObj(this.getJavaMirror());
        visitor.prologue();
        this.iterateStaticFieldsInternal(visitor);
        visitor.epilogue();
    }

    void iterateStaticFieldsInternal(OopVisitor visitor) {
        int length = this.getJavaFieldsCount();
        for (int index = 0; index < length; ++index) {
            short accessFlags = this.getFieldAccessFlags(index);
            FieldType type = new FieldType(this.getFieldSignature(index));
            AccessFlags access = new AccessFlags(accessFlags);
            if (!access.isStatic()) continue;
            this.visitField(visitor, type, index);
        }
    }

    public Klass getJavaSuper() {
        return this.getSuper();
    }

    public void iterateNonStaticFields(OopVisitor visitor, Oop obj) {
        if (this.getSuper() != null) {
            ((InstanceKlass)this.getSuper()).iterateNonStaticFields(visitor, obj);
        }
        int length = this.getJavaFieldsCount();
        for (int index = 0; index < length; ++index) {
            short accessFlags = this.getFieldAccessFlags(index);
            FieldType type = new FieldType(this.getFieldSignature(index));
            AccessFlags access = new AccessFlags(accessFlags);
            if (access.isStatic()) continue;
            this.visitField(visitor, type, index);
        }
    }

    public Field findLocalField(Symbol name, Symbol sig) {
        int length = this.getJavaFieldsCount();
        for (int i = 0; i < length; ++i) {
            Symbol f_name = this.getFieldName(i);
            Symbol f_sig = this.getFieldSignature(i);
            if (!name.equals(f_name) || !sig.equals(f_sig)) continue;
            return this.newField(i);
        }
        return null;
    }

    public Field findInterfaceField(Symbol name, Symbol sig) {
        ObjArray interfaces = this.getLocalInterfaces();
        int n = (int)interfaces.getLength();
        for (int i = 0; i < n; ++i) {
            Field f;
            InstanceKlass intf1 = (InstanceKlass)interfaces.getObjAt(i);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(intf1.isInterface(), "just checking type");
            }
            if ((f = intf1.findLocalField(name, sig)) != null) {
                if (Assert.ASSERTS_ENABLED) {
                    Assert.that(f.getAccessFlagsObj().isStatic(), "interface field must be static");
                }
                return f;
            }
            f = intf1.findInterfaceField(name, sig);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public Field findField(Symbol name, Symbol sig) {
        Field f = this.findLocalField(name, sig);
        if (f != null) {
            return f;
        }
        f = this.findInterfaceField(name, sig);
        if (f != null) {
            return f;
        }
        InstanceKlass supr = (InstanceKlass)this.getSuper();
        if (supr != null) {
            return supr.findField(name, sig);
        }
        return null;
    }

    public Field findField(String name, String sig) {
        SymbolTable symbols = VM.getVM().getSymbolTable();
        Symbol nameSym = symbols.probe(name);
        Symbol sigSym = symbols.probe(sig);
        if (nameSym == null || sigSym == null) {
            return null;
        }
        return this.findField(nameSym, sigSym);
    }

    public Field findFieldDbg(String name, String sig) {
        return this.findField(name, sig);
    }

    public Field getFieldByIndex(int fieldIndex) {
        return this.newField(fieldIndex);
    }

    public List getImmediateFields() {
        int length = this.getJavaFieldsCount();
        ArrayList<Field> immediateFields = new ArrayList<Field>(length);
        for (int index = 0; index < length; ++index) {
            immediateFields.add(this.getFieldByIndex(index));
        }
        return immediateFields;
    }

    public List getAllFields() {
        InstanceKlass supr;
        List allFields = this.getImmediateFields();
        ObjArray interfaces = this.getTransitiveInterfaces();
        int n = (int)interfaces.getLength();
        for (int i = 0; i < n; ++i) {
            InstanceKlass intf1 = (InstanceKlass)interfaces.getObjAt(i);
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(intf1.isInterface(), "just checking type");
            }
            allFields.addAll(intf1.getImmediateFields());
        }
        if (!this.isInterface() && (supr = (InstanceKlass)this.getSuper()) != null) {
            allFields.addAll(supr.getImmediateFields());
        }
        return allFields;
    }

    public List getImmediateMethods() {
        ObjArray methods = this.getMethods();
        int length = (int)methods.getLength();
        Object[] tmp = new Object[length];
        TypeArray methodOrdering = this.getMethodOrdering();
        if (methodOrdering.getLength() != (long)length) {
            for (int index = 0; index < length; ++index) {
                tmp[index] = methods.getObjAt(index);
            }
        } else {
            for (int index = 0; index < length; ++index) {
                int originalIndex = this.getMethodOrdering().getIntAt(index);
                tmp[originalIndex] = methods.getObjAt(index);
            }
        }
        return Arrays.asList(tmp);
    }

    public List getDirectImplementedInterfaces() {
        ObjArray interfaces = this.getLocalInterfaces();
        int length = (int)interfaces.getLength();
        ArrayList<Oop> directImplementedInterfaces = new ArrayList<Oop>(length);
        for (int index = 0; index < length; ++index) {
            directImplementedInterfaces.add(interfaces.getObjAt(index));
        }
        return directImplementedInterfaces;
    }

    public long getObjectSize() {
        long bodySize = InstanceKlass.alignObjectOffset(this.getVtableLen() * this.getHeap().getOopSize()) + InstanceKlass.alignObjectOffset(this.getItableLen() * this.getHeap().getOopSize()) + this.getNonstaticOopMapSize() * this.getHeap().getOopSize();
        return InstanceKlass.alignObjectSize(headerSize + bodySize);
    }

    public Klass arrayKlassImpl(boolean orNull, int n) {
        if (this.getArrayKlasses() == null) {
            return null;
        }
        ObjArrayKlass oak = (ObjArrayKlass)this.getArrayKlasses();
        if (orNull) {
            return oak.arrayKlassOrNull(n);
        }
        return oak.arrayKlass(n);
    }

    public Klass arrayKlassImpl(boolean orNull) {
        return this.arrayKlassImpl(orNull, 1);
    }

    public String signature() {
        return "L" + super.signature() + ";";
    }

    public Method findMethod(String name, String sig) {
        SymbolTable syms = VM.getVM().getSymbolTable();
        Symbol nameSym = syms.probe(name);
        Symbol sigSym = syms.probe(sig);
        if (nameSym == null || sigSym == null) {
            return null;
        }
        return this.findMethod(nameSym, sigSym);
    }

    public Method findMethod(Symbol name, Symbol sig) {
        return InstanceKlass.findMethod(this.getMethods(), name, sig);
    }

    public BreakpointInfo getBreakpoints() {
        Address addr = this.getHandle().getAddressAt(Oop.getHeaderSize() + breakpoints.getOffset());
        return (BreakpointInfo)VMObjectFactory.newObject(BreakpointInfo.class, addr);
    }

    private void visitField(OopVisitor visitor, FieldType type, int index) {
        Field f = this.newField(index);
        if (type.isOop()) {
            visitor.doOop((OopField)f, false);
            return;
        }
        if (type.isByte()) {
            visitor.doByte((ByteField)f, false);
            return;
        }
        if (type.isChar()) {
            visitor.doChar((CharField)f, false);
            return;
        }
        if (type.isDouble()) {
            visitor.doDouble((DoubleField)f, false);
            return;
        }
        if (type.isFloat()) {
            visitor.doFloat((FloatField)f, false);
            return;
        }
        if (type.isInt()) {
            visitor.doInt((IntField)f, false);
            return;
        }
        if (type.isLong()) {
            visitor.doLong((LongField)f, false);
            return;
        }
        if (type.isShort()) {
            visitor.doShort((ShortField)f, false);
            return;
        }
        if (type.isBoolean()) {
            visitor.doBoolean((BooleanField)f, false);
            return;
        }
    }

    private Field newField(int index) {
        FieldType type = new FieldType(this.getFieldSignature(index));
        if (type.isOop()) {
            if (VM.getVM().isCompressedOopsEnabled()) {
                return new NarrowOopField(this, index);
            }
            return new OopField(this, index);
        }
        if (type.isByte()) {
            return new ByteField(this, index);
        }
        if (type.isChar()) {
            return new CharField(this, index);
        }
        if (type.isDouble()) {
            return new DoubleField(this, index);
        }
        if (type.isFloat()) {
            return new FloatField(this, index);
        }
        if (type.isInt()) {
            return new IntField(this, index);
        }
        if (type.isLong()) {
            return new LongField(this, index);
        }
        if (type.isShort()) {
            return new ShortField(this, index);
        }
        if (type.isBoolean()) {
            return new BooleanField(this, index);
        }
        throw new RuntimeException("Illegal field type at index " + index);
    }

    private static Method findMethod(ObjArray methods, Symbol name, Symbol signature) {
        int index;
        int len = (int)methods.getLength();
        int l = 0;
        int h = len - 1;
        while (l <= h) {
            int mid = l + h >> 1;
            Method m = (Method)methods.getObjAt(mid);
            int res = m.getName().fastCompare(name);
            if (res == 0) {
                int index2;
                Method m1;
                int i;
                if (m.getSignature().equals(signature)) {
                    return m;
                }
                for (i = mid - 1; i >= l && (m1 = (Method)methods.getObjAt(i)).getName().equals(name); --i) {
                    if (!m1.getSignature().equals(signature)) continue;
                    return m1;
                }
                for (i = mid + 1; i <= h && (m1 = (Method)methods.getObjAt(i)).getName().equals(name); ++i) {
                    if (!m1.getSignature().equals(signature)) continue;
                    return m1;
                }
                if (Assert.ASSERTS_ENABLED && (index2 = InstanceKlass.linearSearch(methods, name, signature)) != -1) {
                    throw new DebuggerException("binary search bug: should have found entry " + index2);
                }
                return null;
            }
            if (res < 0) {
                l = mid + 1;
                continue;
            }
            h = mid - 1;
        }
        if (Assert.ASSERTS_ENABLED && (index = InstanceKlass.linearSearch(methods, name, signature)) != -1) {
            throw new DebuggerException("binary search bug: should have found entry " + index);
        }
        return null;
    }

    private static int linearSearch(ObjArray methods, Symbol name, Symbol signature) {
        int len = (int)methods.getLength();
        for (int index = 0; index < len; ++index) {
            Method m = (Method)methods.getObjAt(index);
            if (!m.getSignature().equals(signature) || !m.getName().equals(name)) continue;
            return index;
        }
        return -1;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                InstanceKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static class StaticField {
        public AccessFlags flags;
        public Field field;

        StaticField(Field field, AccessFlags flags) {
            this.field = field;
            this.flags = flags;
        }
    }

    public static interface InnerClassAttributeOffset {
        public static final int innerClassInnerClassInfoOffset = 0;
        public static final int innerClassOuterClassInfoOffset = 1;
        public static final int innerClassInnerNameOffset = 2;
        public static final int innerClassAccessFlagsOffset = 3;
        public static final int innerClassNextOffset = 4;
    }

    public static class ClassState {
        public static final ClassState UNPARSABLE_BY_GC = new ClassState("unparsable_by_gc");
        public static final ClassState ALLOCATED = new ClassState("allocated");
        public static final ClassState LOADED = new ClassState("loaded");
        public static final ClassState LINKED = new ClassState("linked");
        public static final ClassState BEING_INITIALIZED = new ClassState("beingInitialized");
        public static final ClassState FULLY_INITIALIZED = new ClassState("fullyInitialized");
        public static final ClassState INITIALIZATION_ERROR = new ClassState("initializationError");
        private String value;

        private ClassState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

