/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.ProfileData;

public class JumpData
extends ProfileData {
    static final int takenOffSet = 0;
    static final int displacementOffSet = 1;
    static final int jumpCellCount = 2;

    public JumpData(DataLayout layout) {
        super(layout);
    }

    static int staticCellCount() {
        return 2;
    }

    public int cellCount() {
        return JumpData.staticCellCount();
    }

    int taken() {
        return this.uintAt(0);
    }

    int displacement() {
        return this.intAt(1);
    }

    static int takenOffset() {
        return JumpData.cellOffset(0);
    }

    static int displacementOffset() {
        return JumpData.cellOffset(1);
    }

    public void printDataOn(PrintStream st) {
        this.printShared(st, "JumpData");
        st.println("taken(" + this.taken() + ") displacement(" + this.displacement() + ")");
    }
}

