/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.CounterData;
import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.MethodData;
import sun.jvm.hotspot.oops.Oop;

public class ReceiverTypeData
extends CounterData {
    static final int receiver0Offset = 1;
    static final int count0Offset = 2;
    static final int receiverTypeRowCellCount = 2;

    public ReceiverTypeData(DataLayout layout) {
        super(layout);
    }

    boolean isReceivertypedata() {
        return true;
    }

    static int staticCellCount() {
        return 1 + MethodData.TypeProfileWidth * 2;
    }

    public int cellCount() {
        return ReceiverTypeData.staticCellCount();
    }

    public static int rowLimit() {
        return MethodData.TypeProfileWidth;
    }

    public static int receiverCellIndex(int row) {
        return 1 + row * 2;
    }

    public static int receiverCountCellIndex(int row) {
        return 2 + row * 2;
    }

    Klass receiverUnchecked(int row) {
        Oop recv = this.oopAt(ReceiverTypeData.receiverCellIndex(row));
        return (Klass)recv;
    }

    public Klass receiver(int row) {
        Klass recv = this.receiverUnchecked(row);
        return recv;
    }

    public int receiverCount(int row) {
        return this.uintAt(ReceiverTypeData.receiverCountCellIndex(row));
    }

    static int receiverOffset(int row) {
        return ReceiverTypeData.cellOffset(ReceiverTypeData.receiverCellIndex(row));
    }

    static int receiverCountOffset(int row) {
        return ReceiverTypeData.cellOffset(ReceiverTypeData.receiverCountCellIndex(row));
    }

    static int receiverTypeDataSize() {
        return ReceiverTypeData.cellOffset(ReceiverTypeData.staticCellCount());
    }

    void printReceiverDataOn(PrintStream st) {
        int row;
        int entries = 0;
        for (row = 0; row < ReceiverTypeData.rowLimit(); ++row) {
            if (this.receiver(row) == null) continue;
            ++entries;
        }
        st.println("count(" + this.count() + ") entries(" + entries + ")");
        for (row = 0; row < ReceiverTypeData.rowLimit(); ++row) {
            if (this.receiver(row) == null) continue;
            this.tab(st);
            this.receiver(row).printValueOn(st);
            st.println("(" + this.receiverCount(row) + ")");
        }
    }

    public void printDataOn(PrintStream st) {
        this.printShared(st, "ReceiverTypeData");
        this.printReceiverDataOn(st);
    }
}

