/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.BooleanField;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CharField;
import sun.jvm.hotspot.oops.DoubleField;
import sun.jvm.hotspot.oops.FloatField;
import sun.jvm.hotspot.oops.IndexableFieldIdentifier;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.LongField;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.ShortField;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class TypeArray
extends Array {
    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("typeArrayOopDesc");
    }

    TypeArray(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public boolean isTypeArray() {
        return true;
    }

    public byte getByteAt(long index) {
        if (index < 0L || index >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException(index + " " + this.getLength());
        }
        long offset = TypeArray.baseOffsetInBytes(BasicType.T_BYTE) + index * this.getHeap().getByteSize();
        return this.getHandle().getJByteAt(offset);
    }

    public boolean getBooleanAt(long index) {
        long offset = TypeArray.baseOffsetInBytes(BasicType.T_BOOLEAN) + index * this.getHeap().getBooleanSize();
        return this.getHandle().getJBooleanAt(offset);
    }

    public char getCharAt(long index) {
        long offset = TypeArray.baseOffsetInBytes(BasicType.T_CHAR) + index * this.getHeap().getCharSize();
        return this.getHandle().getJCharAt(offset);
    }

    public int getIntAt(long index) {
        long offset = TypeArray.baseOffsetInBytes(BasicType.T_INT) + index * this.getHeap().getIntSize();
        return this.getHandle().getJIntAt(offset);
    }

    public short getShortAt(long index) {
        long offset = TypeArray.baseOffsetInBytes(BasicType.T_SHORT) + index * this.getHeap().getShortSize();
        return this.getHandle().getJShortAt(offset);
    }

    public long getLongAt(long index) {
        long offset = TypeArray.baseOffsetInBytes(BasicType.T_LONG) + index * this.getHeap().getLongSize();
        return this.getHandle().getJLongAt(offset);
    }

    public float getFloatAt(long index) {
        long offset = TypeArray.baseOffsetInBytes(BasicType.T_FLOAT) + index * this.getHeap().getFloatSize();
        return this.getHandle().getJFloatAt(offset);
    }

    public double getDoubleAt(long index) {
        long offset = TypeArray.baseOffsetInBytes(BasicType.T_DOUBLE) + index * this.getHeap().getDoubleSize();
        return this.getHandle().getJDoubleAt(offset);
    }

    public void printValueOn(PrintStream tty) {
        TypeArrayKlass klass = (TypeArrayKlass)this.getKlass();
        tty.print(klass.getTypeName());
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        TypeArrayKlass klass = (TypeArrayKlass)this.getKlass();
        int length = (int)this.getLength();
        int type = klass.getElementType();
        block10: for (int index = 0; index < length; ++index) {
            IndexableFieldIdentifier id = new IndexableFieldIdentifier(index);
            switch (type) {
                case 4: {
                    long offset = TypeArray.baseOffsetInBytes(BasicType.T_BOOLEAN) + (long)index * this.getHeap().getBooleanSize();
                    visitor.doBoolean(new BooleanField(id, offset, false), false);
                    continue block10;
                }
                case 5: {
                    long offset = TypeArray.baseOffsetInBytes(BasicType.T_CHAR) + (long)index * this.getHeap().getCharSize();
                    visitor.doChar(new CharField(id, offset, false), false);
                    continue block10;
                }
                case 6: {
                    long offset = TypeArray.baseOffsetInBytes(BasicType.T_FLOAT) + (long)index * this.getHeap().getFloatSize();
                    visitor.doFloat(new FloatField(id, offset, false), false);
                    continue block10;
                }
                case 7: {
                    long offset = TypeArray.baseOffsetInBytes(BasicType.T_DOUBLE) + (long)index * this.getHeap().getDoubleSize();
                    visitor.doDouble(new DoubleField(id, offset, false), false);
                    continue block10;
                }
                case 8: {
                    long offset = TypeArray.baseOffsetInBytes(BasicType.T_BYTE) + (long)index * this.getHeap().getByteSize();
                    visitor.doByte(new ByteField(id, offset, false), false);
                    continue block10;
                }
                case 9: {
                    long offset = TypeArray.baseOffsetInBytes(BasicType.T_SHORT) + (long)index * this.getHeap().getShortSize();
                    visitor.doShort(new ShortField(id, offset, false), false);
                    continue block10;
                }
                case 10: {
                    long offset = TypeArray.baseOffsetInBytes(BasicType.T_INT) + (long)index * this.getHeap().getIntSize();
                    visitor.doInt(new IntField(id, offset, false), false);
                    continue block10;
                }
                case 11: {
                    long offset = TypeArray.baseOffsetInBytes(BasicType.T_LONG) + (long)index * this.getHeap().getLongSize();
                    visitor.doLong(new LongField(id, offset, false), false);
                    continue block10;
                }
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                TypeArray.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

