/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.opto.JVMState;
import sun.jvm.hotspot.opto.SafePointNode;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class CallNode
extends SafePointNode {
    private static AddressField entryPointField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("CallNode");
        entryPointField = type.getAddressField("_entry_point");
    }

    public Address entryPoint() {
        return entryPointField.getValue(this.getAddress());
    }

    public CallNode(Address addr) {
        super(addr);
    }

    public void dumpSpec(PrintStream out) {
        out.print(" ");
        JVMState jvms = this.jvms();
        if (jvms != null) {
            jvms.dumpSpec(out);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CallNode.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

