/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.opto;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciMethod;
import sun.jvm.hotspot.ci.ciObjectFactory;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class JVMState
extends VMObject {
    private static AddressField mapField;
    private static AddressField methodField;
    private static CIntField bciField;
    private static CIntField spField;
    private static CIntField endoffField;
    private static CIntField scloffField;
    private static CIntField monoffField;
    private static CIntField stkoffField;
    private static CIntField locoffField;
    private static CIntField depthField;
    private static AddressField callerField;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("JVMState");
        mapField = type.getAddressField("_map");
        methodField = type.getAddressField("_method");
        bciField = new CIntField(type.getCIntegerField("_bci"), 0L);
        spField = new CIntField(type.getCIntegerField("_sp"), 0L);
        endoffField = new CIntField(type.getCIntegerField("_endoff"), 0L);
        try {
            scloffField = new CIntField(type.getCIntegerField("_scloff"), 0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        monoffField = new CIntField(type.getCIntegerField("_monoff"), 0L);
        stkoffField = new CIntField(type.getCIntegerField("_stkoff"), 0L);
        locoffField = new CIntField(type.getCIntegerField("_locoff"), 0L);
        depthField = new CIntField(type.getCIntegerField("_depth"), 0L);
        callerField = type.getAddressField("_caller");
    }

    public static JVMState create(Address addr) {
        if (addr == null) {
            return null;
        }
        return new JVMState(addr);
    }

    public JVMState(Address addr) {
        super(addr);
    }

    public ciMethod method() {
        return (ciMethod)ciObjectFactory.get(methodField.getValue(this.getAddress()));
    }

    public int bci() {
        return (int)bciField.getValue(this.getAddress());
    }

    public JVMState caller() {
        return JVMState.create(callerField.getValue(this.getAddress()));
    }

    public void dumpSpec(PrintStream out) {
        ciMethod m = this.method();
        if (m != null) {
            Method meth = m.method();
            out.print(" " + meth.getMethodHolder().getName().asString().replace('/', '.') + "::" + meth.getName().asString() + " @ bci:" + this.bci());
        } else {
            out.print(" runtime stub");
        }
        if (this.caller() != null) {
            this.caller().dumpSpec(out);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                JVMState.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

