/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.PerfDataEntry;
import sun.jvm.hotspot.runtime.PerfDataPrologue;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class PerfMemory {
    private static AddressField startField;
    private static AddressField endField;
    private static AddressField topField;
    private static CIntegerField capacityField;
    private static AddressField prologueField;
    private static JIntField initializedField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("PerfMemory");
        startField = type.getAddressField("_start");
        endField = type.getAddressField("_end");
        topField = type.getAddressField("_top");
        capacityField = type.getCIntegerField("_capacity");
        prologueField = type.getAddressField("_prologue");
        initializedField = type.getJIntField("_initialized");
    }

    public static Address start() {
        return startField.getValue();
    }

    public static Address end() {
        return endField.getValue();
    }

    public static Address top() {
        return topField.getValue();
    }

    public static long capacity() {
        return capacityField.getValue();
    }

    public static boolean initialized() {
        return initializedField.getValue() != 0;
    }

    public static PerfDataPrologue prologue() {
        return (PerfDataPrologue)VMObjectFactory.newObject(PerfDataPrologue.class, prologueField.getValue());
    }

    public static boolean contains(Address addr) {
        return PerfMemory.start() != null && addr.minus(PerfMemory.start()) >= 0L && PerfMemory.end().minus(addr) > 0L;
    }

    public static void iterate(PerfDataEntryVisitor visitor) {
        PerfDataPrologue header = PerfMemory.prologue();
        int off = header.entryOffset();
        int num = header.numEntries();
        Address addr = header.getAddress();
        for (int i = 0; i < num; ++i) {
            PerfDataEntry pde = (PerfDataEntry)VMObjectFactory.newObject(PerfDataEntry.class, addr.addOffsetTo(off));
            off += pde.entryLength();
            if (visitor.visit(pde)) continue;
            return;
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                PerfMemory.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static interface PerfDataEntryVisitor {
        public boolean visit(PerfDataEntry var1);
    }
}

