/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.AddressVisitor;
import sun.jvm.hotspot.runtime.JNIHandleBlock;
import sun.jvm.hotspot.runtime.ObjectMonitor;
import sun.jvm.hotspot.runtime.ThreadLocalAllocBuffer;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class Thread
extends VMObject {
    private static long tlabFieldOffset;
    private static CIntegerField suspendFlagsField;
    private static int EXTERNAL_SUSPEND;
    private static int EXT_SUSPENDED;
    private static int HAS_ASYNC_EXCEPTION;
    private static AddressField activeHandlesField;
    private static AddressField currentPendingMonitorField;
    private static AddressField currentWaitingMonitorField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Thread");
        suspendFlagsField = type.getCIntegerField("_suspend_flags");
        EXTERNAL_SUSPEND = db.lookupIntConstant("Thread::_external_suspend");
        EXT_SUSPENDED = db.lookupIntConstant("Thread::_ext_suspended");
        HAS_ASYNC_EXCEPTION = db.lookupIntConstant("Thread::_has_async_exception");
        tlabFieldOffset = type.getField("_tlab").getOffset();
        activeHandlesField = type.getAddressField("_active_handles");
        currentPendingMonitorField = type.getAddressField("_current_pending_monitor");
        currentWaitingMonitorField = type.getAddressField("_current_waiting_monitor");
    }

    public Thread(Address addr) {
        super(addr);
    }

    public int suspendFlags() {
        return (int)suspendFlagsField.getValue(this.addr);
    }

    public boolean isExternalSuspend() {
        return (this.suspendFlags() & EXTERNAL_SUSPEND) != 0;
    }

    public boolean isExtSuspended() {
        return (this.suspendFlags() & EXT_SUSPENDED) != 0;
    }

    public boolean isBeingExtSuspended() {
        return this.isExtSuspended() || this.isExternalSuspend();
    }

    public boolean isAnySuspended() {
        return this.isExtSuspended();
    }

    public boolean hasAsyncException() {
        return (this.suspendFlags() & HAS_ASYNC_EXCEPTION) != 0;
    }

    public ThreadLocalAllocBuffer tlab() {
        return new ThreadLocalAllocBuffer(this.addr.addOffsetTo(tlabFieldOffset));
    }

    public JNIHandleBlock activeHandles() {
        Address a = activeHandlesField.getAddress(this.addr);
        if (a == null) {
            return null;
        }
        return new JNIHandleBlock(a);
    }

    public boolean isVMThread() {
        return false;
    }

    public boolean isJavaThread() {
        return false;
    }

    public boolean isCompilerThread() {
        return false;
    }

    public boolean isHiddenFromExternalView() {
        return false;
    }

    public boolean isJvmtiAgentThread() {
        return false;
    }

    public boolean isWatcherThread() {
        return false;
    }

    public boolean isConcurrentMarkSweepThread() {
        return false;
    }

    public boolean isServiceThread() {
        return false;
    }

    public void oopsDo(AddressVisitor oopVisitor) {
    }

    public ObjectMonitor getCurrentPendingMonitor() {
        Address monitorAddr = currentPendingMonitorField.getValue(this.addr);
        if (monitorAddr == null) {
            return null;
        }
        return new ObjectMonitor(monitorAddr);
    }

    public ObjectMonitor getCurrentWaitingMonitor() {
        Address monitorAddr = currentWaitingMonitorField.getValue(this.addr);
        if (monitorAddr == null) {
            return null;
        }
        return new ObjectMonitor(monitorAddr);
    }

    public boolean isLockOwned(Address lock) {
        return this.isInStack(lock);
    }

    public boolean isInStack(Address a) {
        return false;
    }

    Address threadObjectAddress() {
        return this.addr;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Thread.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

