/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HighPrecisionJScrollBar
extends JScrollBar {
    private BigInteger valueHP;
    private BigInteger visibleHP;
    private BigInteger minimumHP;
    private BigInteger maximumHP;
    private BigInteger unitIncrementHP;
    private BigInteger blockIncrementHP;
    private BigDecimal scaleFactor;
    private BigInteger rangeHP;
    private static final int BIG_RANGE = 10000;
    private boolean down;
    private List changeListeners = new ArrayList();
    private static final int SCALE = 20;
    private static final int UNIT_INCREMENT = 1;
    private static final int BLOCK_INCREMENT = 2;
    private static final int MINIMUM = 0;
    private static final int MAXIMUM = 65536;
    private boolean updating = false;
    private int lastValueSeen = -1;

    public HighPrecisionJScrollBar() {
        this.initialize();
        this.installListener();
    }

    public HighPrecisionJScrollBar(int orientation) {
        super(orientation);
        this.initialize();
        this.installListener();
    }

    public HighPrecisionJScrollBar(int orientation, BigInteger value, BigInteger minimum, BigInteger maximum) {
        super(orientation);
        this.initialize(value, minimum, maximum);
        this.installListener();
    }

    public BigInteger getValueHP() {
        return this.valueHP;
    }

    public void setValueHP(BigInteger value) {
        if (value.compareTo(this.getMaximumHP()) > 0) {
            value = this.getMaximumHP();
        } else if (value.compareTo(this.getMinimumHP()) < 0) {
            value = this.getMinimumHP();
        }
        this.valueHP = value.subtract(value.mod(this.unitIncrementHP));
        int lpValue = this.toUnderlyingRange(this.valueHP);
        if (this.getValueHP().add(this.getVisibleAmountHP()).compareTo(this.getMaximumHP()) >= 0) {
            lpValue = 10000 - this.getVisibleAmount();
        }
        this.lastValueSeen = lpValue;
        this.setValue(lpValue);
        this.fireStateChanged();
    }

    public BigInteger getMinimumHP() {
        return this.minimumHP;
    }

    public void setMinimumHP(BigInteger minimum) {
        this.setRange(minimum, this.maximumHP);
        this.updateScrollBarValues();
    }

    public BigInteger getMaximumHP() {
        return this.maximumHP;
    }

    public void setMaximumHP(BigInteger maximum) {
        this.setRange(this.minimumHP, maximum);
        this.updateScrollBarValues();
    }

    public BigInteger getVisibleAmountHP() {
        return this.visibleHP;
    }

    public void setVisibleAmountHP(BigInteger visibleAmount) {
        int lpVisAmt;
        this.visibleHP = visibleAmount;
        if (visibleAmount.compareTo(this.rangeHP) < 0) {
            lpVisAmt = this.scaleToUnderlying(visibleAmount);
            if (lpVisAmt == 0) {
                lpVisAmt = 1;
            }
            this.setVisible(true);
        } else {
            lpVisAmt = 10000;
            this.setVisible(false);
        }
        this.setVisibleAmount(lpVisAmt);
    }

    public BigInteger getBlockIncrementHP() {
        return this.blockIncrementHP;
    }

    public void setBlockIncrementHP(BigInteger blockIncrement) {
        this.blockIncrementHP = blockIncrement;
    }

    public BigInteger getUnitIncrementHP() {
        return this.unitIncrementHP;
    }

    public void setUnitIncrementHP(BigInteger unitIncrement) {
        this.unitIncrementHP = unitIncrement;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void scrollUpOrLeft() {
        if (this.updating) {
            return;
        }
        this.beginUpdate();
        this.setValueHP(this.getValueHP().subtract(this.getUnitIncrementHP()));
        this.endUpdate();
    }

    public void scrollDownOrRight() {
        if (this.updating) {
            return;
        }
        this.beginUpdate();
        this.setValueHP(this.getValueHP().add(this.getUnitIncrementHP()));
        this.endUpdate();
    }

    public void pageUpOrLeft() {
        if (this.updating) {
            return;
        }
        this.beginUpdate();
        this.setValueHP(this.getValueHP().subtract(this.getBlockIncrementHP()));
        this.endUpdate();
    }

    public void pageDownOrRight() {
        if (this.updating) {
            return;
        }
        this.beginUpdate();
        this.setValueHP(this.getValueHP().add(this.getBlockIncrementHP()));
        this.endUpdate();
    }

    private void beginUpdate() {
        this.updating = true;
    }

    private void endUpdate() {
        this.updating = false;
    }

    private void initialize(BigInteger value, BigInteger minimum, BigInteger maximum) {
        this.setMinimum(0);
        this.setMaximum(9999);
        this.setValue(0);
        this.setVisibleAmount(1);
        this.setUnitIncrement(1);
        this.setBlockIncrement(2);
        this.setUnitIncrementHP(new BigInteger(Integer.toString(this.getUnitIncrement())));
        this.setBlockIncrementHP(new BigInteger(Integer.toString(this.getBlockIncrement())));
        this.setRange(minimum, maximum);
        this.setVisibleAmountHP(new BigInteger(Integer.toString(this.getVisibleAmount())));
        this.setValueHP(value);
    }

    private void initialize() {
        BigInteger min = new BigInteger(Integer.toString(this.getMinimum()));
        BigInteger max = new BigInteger(Integer.toString(this.getMaximum()));
        this.initialize(min, min, max);
    }

    private void setRange(BigInteger minimum, BigInteger maximum) {
        if (minimum.compareTo(maximum) > 0) {
            throw new RuntimeException("Bad scrollbar range " + minimum + " > " + maximum);
        }
        this.minimumHP = minimum;
        this.maximumHP = maximum;
        this.rangeHP = maximum.subtract(minimum).add(BigInteger.ONE);
        BigInteger range2 = new BigInteger(Integer.toString(10000));
        if (this.rangeHP.compareTo(range2) >= 0) {
            this.down = true;
            this.scaleFactor = new BigDecimal(this.rangeHP, 20).divide(new BigDecimal(range2, 20), 1).max(new BigDecimal(BigInteger.ONE));
        } else {
            this.down = false;
            this.scaleFactor = new BigDecimal(range2, 20).divide(new BigDecimal(this.rangeHP, 20), 1).max(new BigDecimal(BigInteger.ONE));
        }
    }

    private void updateScrollBarValues() {
        this.setValueHP(this.getValueHP());
        this.setVisibleAmountHP(this.getVisibleAmountHP());
        this.setBlockIncrementHP(this.getBlockIncrementHP());
        this.setUnitIncrementHP(this.getUnitIncrementHP());
    }

    private BigDecimal getScaleFactor() {
        return this.scaleFactor;
    }

    private BigInteger scaleToHP(int i) {
        BigDecimal ib = new BigDecimal(Integer.toString(i));
        if (this.down) {
            return ib.multiply(this.getScaleFactor()).toBigInteger();
        }
        return ib.divide(this.getScaleFactor(), 1).toBigInteger();
    }

    private int scaleToUnderlying(BigInteger i) {
        BigDecimal d = new BigDecimal(i);
        if (this.down) {
            return d.divide(this.getScaleFactor(), 1).intValue();
        }
        return d.multiply(this.getScaleFactor()).intValue();
    }

    private BigInteger toHPRange(int i) {
        return this.scaleToHP(i).add(this.minimumHP);
    }

    private int toUnderlyingRange(BigInteger i) {
        return this.scaleToUnderlying(i.subtract(this.minimumHP));
    }

    private void installListener() {
        super.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (HighPrecisionJScrollBar.this.updating) {
                    return;
                }
                HighPrecisionJScrollBar.this.beginUpdate();
                switch (e.getAdjustmentType()) {
                    case 5: {
                        int val = e.getValue();
                        int diff = val - HighPrecisionJScrollBar.this.lastValueSeen;
                        int absDiff = Math.abs(diff);
                        if (absDiff == 1) {
                            if (diff > 0) {
                                HighPrecisionJScrollBar.this.setValueHP(HighPrecisionJScrollBar.this.getValueHP().add(HighPrecisionJScrollBar.this.getUnitIncrementHP()));
                                break;
                            }
                            HighPrecisionJScrollBar.this.setValueHP(HighPrecisionJScrollBar.this.getValueHP().subtract(HighPrecisionJScrollBar.this.getUnitIncrementHP()));
                            break;
                        }
                        if (absDiff == 2) {
                            if (diff > 0) {
                                HighPrecisionJScrollBar.this.setValueHP(HighPrecisionJScrollBar.this.getValueHP().add(HighPrecisionJScrollBar.this.getBlockIncrementHP()));
                                break;
                            }
                            HighPrecisionJScrollBar.this.setValueHP(HighPrecisionJScrollBar.this.getValueHP().subtract(HighPrecisionJScrollBar.this.getBlockIncrementHP()));
                            break;
                        }
                        if (absDiff == 0) break;
                        BigInteger i = null;
                        i = e.getValue() == HighPrecisionJScrollBar.this.getMinimum() ? HighPrecisionJScrollBar.this.getMinimumHP() : (e.getValue() >= HighPrecisionJScrollBar.this.getMaximum() - 1 ? HighPrecisionJScrollBar.this.getMaximumHP() : HighPrecisionJScrollBar.this.toHPRange(e.getValue()));
                        HighPrecisionJScrollBar.this.setValueHP(i);
                        break;
                    }
                }
                HighPrecisionJScrollBar.this.endUpdate();
            }
        });
    }

    private void fireStateChanged() {
        ChangeEvent e = null;
        for (ChangeListener l : this.changeListeners) {
            if (e == null) {
                e = new ChangeEvent(this);
            }
            l.stateChanged(e);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(300, 300);
        HighPrecisionJScrollBar hpsb = new HighPrecisionJScrollBar(1, new BigInteger(1, new byte[]{-128, 0, 0, 0, 0, 0, 0, 0}), new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 0}), new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}));
        hpsb.setUnitIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 1}));
        hpsb.setBlockIncrementHP(new BigInteger(1, new byte[]{0, 0, 0, 0, 0, 0, 0, 16}));
        hpsb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                HighPrecisionJScrollBar h = (HighPrecisionJScrollBar)e.getSource();
                System.out.println("New value = 0x" + h.getValueHP().toString(16));
            }
        });
        frame.getContentPane().add(hpsb);
        frame.setVisible(true);
    }
}

