/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import com.sun.java.swing.action.ActionManager;
import com.sun.java.swing.action.DelegateAction;
import com.sun.java.swing.ui.CommonToolBar;
import com.sun.java.swing.ui.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHistogram;
import sun.jvm.hotspot.oops.ObjectHistogramElement;
import sun.jvm.hotspot.ui.action.HSDBActionManager;
import sun.jvm.hotspot.ui.table.LongCellRenderer;
import sun.jvm.hotspot.ui.table.SortHeaderCellRenderer;
import sun.jvm.hotspot.ui.table.SortHeaderMouseAdapter;
import sun.jvm.hotspot.ui.table.SortableTableModel;
import sun.jvm.hotspot.ui.table.TableModelComparator;

public class ObjectHistogramPanel
extends JPanel
implements ActionListener {
    private ObjectHistogramTableModel dataModel;
    private ObjectHistogramToolBar toolbar;
    private StatusBar statusBar;
    private JTable table;
    private List listeners;

    public ObjectHistogramPanel(ObjectHistogram histo) {
        this.dataModel = new ObjectHistogramTableModel(histo);
        this.statusBar = new StatusBar();
        this.table = new JTable(this.dataModel, new ObjectHistogramColummModel());
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ObjectHistogramPanel.this.fireShowObjectsOfType();
                }
            }
        });
        JTableHeader header = this.table.getTableHeader();
        header.setDefaultRenderer(new SortHeaderCellRenderer(header, this.dataModel));
        header.addMouseListener(new SortHeaderMouseAdapter(this.table, this.dataModel));
        this.setLayout(new BorderLayout());
        this.toolbar = new ObjectHistogramToolBar(this.statusBar);
        this.add((Component)this.toolbar, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.statusBar, "South");
        this.registerActions();
    }

    public void actionPerformed(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("show-command")) {
            this.fireShowObjectsOfType();
        } else if (command.equals("find-command")) {
            this.findObject();
        }
    }

    protected void registerActions() {
        this.registerAction("find-command");
        this.registerAction("show-command");
    }

    private void registerAction(String actionName) {
        ActionManager manager = ActionManager.getInstance();
        DelegateAction action = manager.getDelegateAction(actionName);
        action.addActionListener(this);
    }

    public void addPanelListener(Listener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removePanelListener(Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void findObject() {
        String value;
        int i;
        String findText = this.toolbar.getFindText();
        if (findText == null || findText.equals("")) {
            return;
        }
        TableModel model = this.table.getModel();
        int row = this.table.getSelectedRow();
        row = row == model.getRowCount() ? 0 : ++row;
        for (i = row; i < model.getRowCount(); ++i) {
            value = (String)model.getValueAt(i, 2);
            if (value == null || !value.startsWith(findText)) continue;
            this.table.setRowSelectionInterval(i, i);
            Rectangle cellBounds = this.table.getCellRect(i, 0, true);
            this.table.scrollRectToVisible(cellBounds);
            return;
        }
        for (i = 0; i < row; ++i) {
            value = (String)model.getValueAt(i, 2);
            if (value == null || !value.startsWith(findText)) continue;
            this.table.setRowSelectionInterval(i, i);
            Rectangle cellBounds = this.table.getCellRect(i, 0, true);
            this.table.scrollRectToVisible(cellBounds);
            return;
        }
    }

    private void fireShowObjectsOfType() {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        ObjectHistogramElement el = this.dataModel.getElement(i);
        for (Listener listener : this.listeners) {
            listener.showObjectsOfType(el.getKlass());
        }
    }

    public static void main(String[] args) {
    }

    public static interface Listener {
        public void showObjectsOfType(Klass var1);
    }

    private class ObjectHistogramTableModel
    extends SortableTableModel {
        private String[] columnNames = new String[]{"Size", "Count", "Class Description"};
        private Class[] columnClasses = new Class[]{Long.class, Long.class, String.class};

        public ObjectHistogramTableModel(ObjectHistogram histo) {
            this.elements = histo.getElements();
            this.setComparator(new ObjectHistogramComparator(this));
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.elements.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int col) {
            return this.columnClasses[col];
        }

        public Object getValueAt(int row, int col) {
            return this.getValueForColumn(this.getElement(row), col);
        }

        public Object getValueForColumn(Object obj, int col) {
            ObjectHistogramElement el = (ObjectHistogramElement)obj;
            switch (col) {
                case 0: {
                    return new Long(el.getSize());
                }
                case 1: {
                    return new Long(el.getCount());
                }
                case 2: {
                    return el.getDescription();
                }
            }
            throw new RuntimeException("Index (" + col + ") out of bounds");
        }

        public ObjectHistogramElement getElement(int index) {
            return (ObjectHistogramElement)this.elements.get(index);
        }

        private class ObjectHistogramComparator
        extends TableModelComparator {
            public ObjectHistogramComparator(ObjectHistogramTableModel model) {
                super(model);
            }

            public Object getValueForColumn(Object obj, int column) {
                ObjectHistogramTableModel omodel = (ObjectHistogramTableModel)this.model;
                return omodel.getValueForColumn(obj, column);
            }
        }
    }

    private class ObjectHistogramColummModel
    extends DefaultTableColumnModel {
        private final String LABEL_SIZE = "Size";
        private final String LABEL_COUNT = "Count";
        private final String LABEL_DESC = "Class Description";

        public ObjectHistogramColummModel() {
            int PREF_WIDTH = 80;
            int MAX_WIDTH = 100;
            int HUGE_WIDTH = 140;
            LongCellRenderer lcRender = new LongCellRenderer();
            TableColumn column = new TableColumn(0, PREF_WIDTH);
            column.setHeaderValue("Size");
            column.setMaxWidth(MAX_WIDTH);
            column.setResizable(false);
            column.setCellRenderer(lcRender);
            this.addColumn(column);
            column = new TableColumn(1, PREF_WIDTH);
            column.setHeaderValue("Count");
            column.setMaxWidth(MAX_WIDTH);
            column.setResizable(false);
            column.setCellRenderer(lcRender);
            this.addColumn(column);
            column = new TableColumn(2, HUGE_WIDTH);
            column.setHeaderValue("Class Description");
            this.addColumn(column);
        }
    }

    private class ObjectHistogramToolBar
    extends CommonToolBar {
        private JTextField searchTF;

        public ObjectHistogramToolBar(StatusBar status) {
            super(HSDBActionManager.getInstance(), status);
        }

        protected void addComponents() {
            this.searchTF = new JTextField();
            this.searchTF.setToolTipText("Find in Class Description");
            InputMap im = this.searchTF.getInputMap();
            im.put(KeyStroke.getKeyStroke("ENTER"), "enterPressed");
            ActionMap am = this.searchTF.getActionMap();
            am.put("enterPressed", this.manager.getAction("find-command"));
            this.add(this.searchTF);
            this.addButton(this.manager.getAction("find-command"));
            this.addButton(this.manager.getAction("show-command"));
        }

        public String getFindText() {
            return this.searchTF.getText();
        }
    }
}

