/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.ui.SAListener;
import sun.jvm.hotspot.ui.SAPanel;
import sun.jvm.hotspot.ui.table.SortHeaderCellRenderer;
import sun.jvm.hotspot.ui.table.SortHeaderMouseAdapter;
import sun.jvm.hotspot.ui.table.SortableTableModel;
import sun.jvm.hotspot.ui.table.TableModelComparator;
import sun.jvm.hotspot.ui.tree.OopTreeNodeAdapter;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.HeapProgressThunk;
import sun.jvm.hotspot.utilities.LivenessAnalysis;
import sun.jvm.hotspot.utilities.LivenessPathList;
import sun.jvm.hotspot.utilities.ReversePtrsAnalysis;
import sun.jvm.hotspot.utilities.WorkerThread;

public class ObjectListPanel
extends SAPanel {
    private ObjectListTableModel dataModel;
    private JTable table;
    private List elements;
    private HeapProgressThunk thunk;
    private boolean checkedForArrays;
    private boolean hasArrays;
    private int numColumns;
    private JButton livenessButton;
    private ActionListener livenessButtonListener;
    private static final String showLivenessText = "Show Liveness";

    public ObjectListPanel(List els, HeapProgressThunk thunk) {
        this.elements = els;
        this.thunk = thunk;
        this.computeNumColumns();
        this.setLayout(new BorderLayout());
        this.dataModel = new ObjectListTableModel();
        this.table = new JTable(this.dataModel);
        this.table.setSelectionMode(0);
        JTableHeader header = this.table.getTableHeader();
        header.setDefaultRenderer(new SortHeaderCellRenderer(header, this.dataModel));
        header.addMouseListener(new SortHeaderMouseAdapter(this.table, this.dataModel));
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        JButton button = new JButton("Inspect");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectListPanel.this.fireShowInspector();
            }
        });
        box.add(button);
        box.add(Box.createHorizontalStrut(20));
        this.livenessButton = button = new JButton();
        if (VM.getVM().getRevPtrs() == null) {
            button.setText("Compute Liveness");
            this.livenessButtonListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ObjectListPanel.this.fireComputeLiveness();
                }
            };
        } else {
            button.setText("Show Liveness Path");
            this.livenessButtonListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ObjectListPanel.this.fireShowLiveness();
                }
            };
        }
        button.addActionListener(this.livenessButtonListener);
        box.add(button);
        box.add(Box.createGlue());
        panel.add(box);
        this.add((Component)panel, "South");
    }

    private void fireShowInspector() {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        Oop oop = (Oop)this.elements.get(i);
        for (SAListener listener : this.listeners) {
            listener.showInspector(new OopTreeNodeAdapter(oop, null));
        }
    }

    private void fireComputeLiveness() {
        final Runnable cutoverButtonRunnable = new Runnable(){

            public void run() {
                ObjectListPanel.this.livenessButton.removeActionListener(ObjectListPanel.this.livenessButtonListener);
                ObjectListPanel.this.livenessButtonListener = null;
                ObjectListPanel.this.livenessButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ObjectListPanel.this.fireShowLiveness();
                    }
                });
                ObjectListPanel.this.computeNumColumns();
                ObjectListPanel.this.livenessButton.setEnabled(true);
                ObjectListPanel.this.livenessButton.setText(ObjectListPanel.showLivenessText);
                ObjectListPanel.this.dataModel.fireTableStructureChanged();
            }
        };
        if (VM.getVM().getRevPtrs() != null) {
            cutoverButtonRunnable.run();
        } else {
            final WorkerThread worker = new WorkerThread();
            worker.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ReversePtrsAnalysis rev = new ReversePtrsAnalysis();
                        if (ObjectListPanel.this.thunk != null) {
                            rev.setHeapProgressThunk(ObjectListPanel.this.thunk);
                        }
                        rev.run();
                        cutoverButtonRunnable.run();
                    }
                    finally {
                        worker.shutdown();
                    }
                }
            });
        }
    }

    private void fireShowLiveness() {
        if (VM.getVM().getRevPtrs() == null) {
            return;
        }
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        Oop oop = (Oop)this.elements.get(i);
        LivenessPathList list = LivenessAnalysis.computeAllLivenessPaths(oop);
        if (list == null) {
            return;
        }
        for (SAListener listener : this.listeners) {
            listener.showLiveness(oop, list);
        }
    }

    private void checkForArrays() {
        if (this.checkedForArrays) {
            return;
        }
        this.checkedForArrays = true;
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof Array)) continue;
            this.hasArrays = true;
            return;
        }
    }

    private void computeNumColumns() {
        this.checkForArrays();
        this.numColumns = 3;
        if (this.hasArrays) {
            ++this.numColumns;
        }
        if (VM.getVM().getRevPtrs() != null) {
            ++this.numColumns;
        }
    }

    private class ObjectListTableModel
    extends SortableTableModel {
        public ObjectListTableModel() {
            this.elements = ObjectListPanel.this.elements;
            this.setComparator(new ObjectListComparator(this));
        }

        public int getColumnCount() {
            return ObjectListPanel.this.numColumns;
        }

        public int getRowCount() {
            return this.elements.size();
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Address";
                }
                case 1: {
                    return "Oop";
                }
                case 2: {
                    if (ObjectListPanel.this.hasArrays) {
                        return "Length";
                    }
                    return "Class Description";
                }
                case 3: {
                    if (ObjectListPanel.this.hasArrays) {
                        return "Class Description";
                    }
                    if (VM.getVM().getRevPtrs() != null) {
                        return "Liveness";
                    }
                }
                case 4: {
                    if (!ObjectListPanel.this.hasArrays || VM.getVM().getRevPtrs() == null) break;
                    return "Liveness";
                }
            }
            throw new RuntimeException("Index " + col + " out of bounds");
        }

        public Object getValueAt(int row, int col) {
            Oop oop = (Oop)this.elements.get(row);
            return this.getValueForColumn(oop, col);
        }

        public Object getValueForColumn(Oop oop, int col) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            switch (col) {
                case 0: {
                    return new AddressWrapper(oop.getHandle());
                }
                case 1: {
                    oop.printValueOn(new PrintStream(bos));
                    break;
                }
                case 2: {
                    if (ObjectListPanel.this.hasArrays) {
                        if (oop instanceof Array) {
                            return new Long(((Array)oop).getLength());
                        }
                        return null;
                    }
                    oop.getKlass().printValueOn(new PrintStream(bos));
                    break;
                }
                case 3: {
                    if (ObjectListPanel.this.hasArrays) {
                        oop.getKlass().printValueOn(new PrintStream(bos));
                        break;
                    }
                    if (VM.getVM().getRevPtrs() != null) {
                        if (VM.getVM().getRevPtrs().get(oop) != null) {
                            return "Alive";
                        }
                        return "Dead";
                    }
                }
                case 4: {
                    if (ObjectListPanel.this.hasArrays && VM.getVM().getRevPtrs() != null) {
                        if (VM.getVM().getRevPtrs().get(oop) != null) {
                            return "Alive";
                        }
                        return "Dead";
                    }
                }
                default: {
                    throw new RuntimeException("Column " + col + " out of bounds");
                }
            }
            return bos.toString();
        }

        private class ObjectListComparator
        extends TableModelComparator {
            public ObjectListComparator(ObjectListTableModel model) {
                super(model);
            }

            public Object getValueForColumn(Object obj, int column) {
                ObjectListTableModel omodel = (ObjectListTableModel)this.model;
                return omodel.getValueForColumn((Oop)obj, column);
            }
        }
    }

    private static class AddressWrapper
    implements Comparable {
        private Address address;

        private AddressWrapper(Address address) {
            this.address = address;
        }

        public String toString() {
            return this.address.toString();
        }

        public int compareTo(Object o) {
            AddressWrapper wrapper = (AddressWrapper)o;
            Address addr = wrapper.address;
            if (AddressOps.lessThan(this.address, addr)) {
                return -1;
            }
            if (AddressOps.greaterThan(this.address, addr)) {
                return 1;
            }
            return 0;
        }
    }
}

