/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.BasicHashtable;
import sun.jvm.hotspot.utilities.HashtableEntry;

public class Hashtable
extends BasicHashtable {
    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("Hashtable<intptr_t>");
    }

    protected Class getHashtableEntryClass() {
        return HashtableEntry.class;
    }

    public int hashToIndex(long fullHash) {
        return (int)(fullHash % (long)this.tableSize());
    }

    public Hashtable(Address addr) {
        super(addr);
    }

    protected static long hashSymbol(byte[] buf) {
        long h = 0L;
        int s = 0;
        int len = buf.length;
        while (len-- > 0) {
            h = 31L * h + (0xFFFFFFFFL & (long)buf[s]);
            ++s;
        }
        return h & 0xFFFFFFFFL;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Hashtable.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

