/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orb;

import com.sun.corba.se.impl.orb.ParserAction;
import com.sun.corba.se.impl.orb.PropertyCallback;
import com.sun.corba.se.impl.orbutil.GetPropertyAction;
import com.sun.corba.se.spi.orb.DataCollector;
import com.sun.corba.se.spi.orb.PropertyParser;
import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class DataCollectorBase
implements DataCollector {
    private PropertyParser parser;
    private Set propertyNames;
    private Set propertyPrefixes;
    private Set URLPropertyNames = new HashSet();
    protected String localHostName;
    protected String configurationHostName;
    private boolean setParserCalled;
    private Properties originalProps;
    private Properties resultProps;

    public DataCollectorBase(Properties properties, String string, String string2) {
        this.URLPropertyNames.add("org.omg.CORBA.ORBInitialServices");
        this.propertyNames = new HashSet();
        this.propertyNames.add("org.omg.CORBA.ORBInitRef");
        this.propertyPrefixes = new HashSet();
        this.originalProps = properties;
        this.localHostName = string;
        this.configurationHostName = string2;
        this.setParserCalled = false;
        this.resultProps = new Properties();
    }

    public boolean initialHostIsLocal() {
        this.checkSetParserCalled();
        return this.localHostName.equals(this.resultProps.getProperty("org.omg.CORBA.ORBInitialHost"));
    }

    public void setParser(PropertyParser propertyParser) {
        Iterator iterator = propertyParser.iterator();
        while (iterator.hasNext()) {
            ParserAction parserAction = (ParserAction)iterator.next();
            if (parserAction.isPrefix()) {
                this.propertyPrefixes.add(parserAction.getPropertyName());
                continue;
            }
            this.propertyNames.add(parserAction.getPropertyName());
        }
        this.collect();
        this.setParserCalled = true;
    }

    public Properties getProperties() {
        this.checkSetParserCalled();
        return this.resultProps;
    }

    public abstract boolean isApplet();

    protected abstract void collect();

    protected void checkPropertyDefaults() {
        String string;
        String string2 = this.resultProps.getProperty("org.omg.CORBA.ORBInitialHost");
        if (string2 == null || string2.equals("")) {
            this.setProperty("org.omg.CORBA.ORBInitialHost", this.configurationHostName);
        }
        if ((string = this.resultProps.getProperty("com.sun.CORBA.ORBServerHost")) == null || string.equals("") || string.equals("0.0.0.0") || string.equals("::") || string.toLowerCase().equals("::ffff:0.0.0.0")) {
            this.setProperty("com.sun.CORBA.ORBServerHost", this.localHostName);
            this.setProperty("com.sun.CORBA.INTERNAL USE ONLY: listen on all interfaces", "com.sun.CORBA.INTERNAL USE ONLY: listen on all interfaces");
        }
    }

    protected void findPropertiesFromArgs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = null;
            String string3 = null;
            if (stringArray[i] != null && stringArray[i].startsWith("-ORB") && (string3 = this.findMatchingPropertyName(this.propertyNames, string = stringArray[i].substring(1))) != null && i + 1 < stringArray.length && stringArray[i + 1] != null) {
                string2 = stringArray[++i];
            }
            if (string2 == null) continue;
            this.setProperty(string3, string2);
        }
    }

    protected void findPropertiesFromApplet(final Applet applet) {
        if (applet == null) {
            return;
        }
        PropertyCallback propertyCallback = new PropertyCallback(){

            public String get(String string) {
                return applet.getParameter(string);
            }
        };
        this.findPropertiesByName(this.propertyNames.iterator(), propertyCallback);
        PropertyCallback propertyCallback2 = new PropertyCallback(){

            public String get(String string) {
                String string2 = DataCollectorBase.this.resultProps.getProperty(string);
                if (string2 == null) {
                    return null;
                }
                try {
                    URL uRL = new URL(applet.getDocumentBase(), string2);
                    return uRL.toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    return string2;
                }
            }
        };
        this.findPropertiesByName(this.URLPropertyNames.iterator(), propertyCallback2);
    }

    private void doProperties(final Properties properties) {
        PropertyCallback propertyCallback = new PropertyCallback(){

            public String get(String string) {
                return properties.getProperty(string);
            }
        };
        this.findPropertiesByName(this.propertyNames.iterator(), propertyCallback);
        this.findPropertiesByPrefix(this.propertyPrefixes, DataCollectorBase.makeIterator(properties.propertyNames()), propertyCallback);
    }

    protected void findPropertiesFromFile() {
        Properties properties = this.getFileProperties();
        if (properties == null) {
            return;
        }
        this.doProperties(properties);
    }

    protected void findPropertiesFromProperties() {
        if (this.originalProps == null) {
            return;
        }
        this.doProperties(this.originalProps);
    }

    protected void findPropertiesFromSystem() {
        Set set = this.getCORBAPrefixes(this.propertyNames);
        Set set2 = this.getCORBAPrefixes(this.propertyPrefixes);
        PropertyCallback propertyCallback = new PropertyCallback(){

            public String get(String string) {
                return DataCollectorBase.getSystemProperty(string);
            }
        };
        this.findPropertiesByName(set.iterator(), propertyCallback);
        this.findPropertiesByPrefix(set2, DataCollectorBase.getSystemPropertyNames(), propertyCallback);
    }

    private void setProperty(String string, String string2) {
        if (string.equals("org.omg.CORBA.ORBInitRef")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
            if (stringTokenizer.countTokens() != 2) {
                throw new IllegalArgumentException();
            }
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            this.resultProps.setProperty(string + "." + string3, string4);
        } else {
            this.resultProps.setProperty(string, string2);
        }
    }

    private void checkSetParserCalled() {
        if (!this.setParserCalled) {
            throw new IllegalStateException("setParser not called.");
        }
    }

    private void findPropertiesByPrefix(Set set, Iterator iterator, PropertyCallback propertyCallback) {
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            for (String string2 : set) {
                if (!string.startsWith(string2)) continue;
                String string3 = propertyCallback.get(string);
                this.setProperty(string, string3);
            }
        }
    }

    private void findPropertiesByName(Iterator iterator, PropertyCallback propertyCallback) {
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = propertyCallback.get(string);
            if (string2 == null) continue;
            this.setProperty(string, string2);
        }
    }

    private static String getSystemProperty(String string) {
        return (String)AccessController.doPrivileged(new GetPropertyAction(string));
    }

    private String findMatchingPropertyName(Set set, String string) {
        for (String string2 : set) {
            if (!string2.endsWith(string)) continue;
            return string2;
        }
        return null;
    }

    private static Iterator makeIterator(final Enumeration enumeration) {
        return new Iterator(){

            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            public Object next() {
                return enumeration.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static Iterator getSystemPropertyNames() {
        Enumeration enumeration = (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties().propertyNames();
            }
        });
        return DataCollectorBase.makeIterator(enumeration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPropertiesFromFile(Properties properties, String string) {
        try {
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Properties getFileProperties() {
        Properties properties = new Properties();
        String string = DataCollectorBase.getSystemProperty("java.home");
        String string2 = string + File.separator + "lib" + File.separator + "orb.properties";
        this.getPropertiesFromFile(properties, string2);
        Properties properties2 = new Properties(properties);
        String string3 = DataCollectorBase.getSystemProperty("user.home");
        string2 = string3 + File.separator + "orb.properties";
        this.getPropertiesFromFile(properties2, string2);
        return properties2;
    }

    private boolean hasCORBAPrefix(String string) {
        return string.startsWith("org.omg.") || string.startsWith("com.sun.CORBA.") || string.startsWith("com.sun.corba.") || string.startsWith("com.sun.corba.se.");
    }

    private Set getCORBAPrefixes(Set set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : set) {
            if (!this.hasCORBAPrefix(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }
}

