/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ReaderThread;
import com.sun.corba.se.pept.transport.Selector;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.threadpool.Work;

public class ReaderThreadImpl
implements ReaderThread,
Work {
    private ORB orb;
    private Connection connection;
    private Selector selector;
    private boolean keepRunning;
    private long enqueueTime;

    public ReaderThreadImpl(ORB oRB, Connection connection, Selector selector) {
        this.orb = oRB;
        this.connection = connection;
        this.selector = selector;
        this.keepRunning = true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void close() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".close: " + this.connection);
        }
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doWork() {
        block9: {
            try {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".doWork: Start ReaderThread: " + this.connection);
                }
                while (true) {
                    block10: {
                        if (!this.keepRunning) break block9;
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork: Start ReaderThread cycle: " + this.connection);
                        }
                        if (!this.connection.read()) break block10;
                        Object var3_2 = null;
                        if (!this.orb.transportDebugFlag) return;
                        this.dprint(".doWork: Terminated ReaderThread: " + this.connection);
                        return;
                    }
                    try {
                        if (!this.orb.transportDebugFlag) continue;
                        this.dprint(".doWork: End ReaderThread cycle: " + this.connection);
                    }
                    catch (Throwable throwable) {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".doWork: exception in read: " + this.connection, throwable);
                        }
                        this.orb.getTransportManager().getSelector(0).unregisterForEvent(this.getConnection().getEventHandler());
                        this.getConnection().close();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (!this.orb.transportDebugFlag) throw throwable;
                this.dprint(".doWork: Terminated ReaderThread: " + this.connection);
                throw throwable;
            }
        }
        Object var3_3 = null;
        if (!this.orb.transportDebugFlag) return;
        this.dprint(".doWork: Terminated ReaderThread: " + this.connection);
    }

    public void setEnqueueTime(long l) {
        this.enqueueTime = l;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public String getName() {
        return "ReaderThread";
    }

    private void dprint(String string) {
        ORBUtility.dprint("ReaderThreadImpl", string);
    }

    protected void dprint(String string, Throwable throwable) {
        this.dprint(string);
        throwable.printStackTrace(System.out);
    }
}

