/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Histogram;
import com.sun.java.util.jar.pack.PopulationCoding;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class CodingChooser {
    int verbose;
    int effort;
    boolean optUseHistogram = true;
    boolean optUsePopulationCoding = true;
    boolean optUseAdaptiveCoding = true;
    boolean disablePopCoding;
    boolean disableRunCoding;
    boolean topLevel = true;
    double fuzz;
    Coding[] allCodingChoices;
    Choice[] choices;
    ByteArrayOutputStream context;
    CodingChooser popHelper;
    CodingChooser runHelper;
    Random stress;
    private int[] values;
    private int start;
    private int end;
    private int[] deltas;
    private int min;
    private int max;
    private Histogram vHist;
    private Histogram dHist;
    private int searchOrder;
    private Choice regularChoice;
    private Choice bestChoice;
    private CodingMethod bestMethod;
    private int bestByteSize;
    private int bestZipSize;
    private int targetSize;
    public static final int MIN_EFFORT = 1;
    public static final int MID_EFFORT = 5;
    public static final int MAX_EFFORT = 9;
    public static final int POP_EFFORT = 4;
    public static final int RUN_EFFORT = 3;
    public static final int BYTE_SIZE = 0;
    public static final int ZIP_SIZE = 1;
    private Sizer zipSizer = new Sizer();
    private Deflater zipDef = new Deflater();
    private DeflaterOutputStream zipOut = new DeflaterOutputStream(this.zipSizer, this.zipDef);
    private Sizer byteSizer = new Sizer(this.zipOut);
    private Sizer byteOnlySizer = new Sizer();

    CodingChooser(int n, Coding[] codingArray) {
        Object object;
        int n2;
        int n3;
        PropMap propMap = Utils.currentPropMap();
        if (propMap != null) {
            this.verbose = Math.max(propMap.getInteger("com.sun.java.util.jar.pack.verbose"), propMap.getInteger("com.sun.java.util.jar.pack.verbose.coding"));
            this.optUseHistogram = !propMap.getBoolean("com.sun.java.util.jar.pack.no.histogram");
            this.optUsePopulationCoding = !propMap.getBoolean("com.sun.java.util.jar.pack.no.population.coding");
            this.optUseAdaptiveCoding = !propMap.getBoolean("com.sun.java.util.jar.pack.no.adaptive.coding");
            n3 = propMap.getInteger("com.sun.java.util.jar.pack.stress.coding");
            if (n3 != 0) {
                this.stress = new Random(n3);
            }
        }
        this.effort = n;
        this.allCodingChoices = codingArray;
        this.fuzz = 1.0 + 0.0025 * (double)(n - 5);
        n3 = 0;
        for (n2 = 0; n2 < codingArray.length; ++n2) {
            if (codingArray[n2] == null) continue;
            ++n3;
        }
        this.choices = new Choice[n3];
        n3 = 0;
        for (n2 = 0; n2 < codingArray.length; ++n2) {
            if (codingArray[n2] == null) continue;
            object = new int[this.choices.length];
            this.choices[n3++] = new Choice(codingArray[n2], n2, (int[])object);
        }
        for (n2 = 0; n2 < this.choices.length; ++n2) {
            object = this.choices[n2].coding;
            assert (((Coding)object).distanceFrom((Coding)object) == 0);
            for (int i = 0; i < n2; ++i) {
                Coding coding = this.choices[i].coding;
                int n4 = ((Coding)object).distanceFrom(coding);
                assert (n4 > 0);
                assert (n4 == coding.distanceFrom((Coding)object));
                this.choices[n2].distance[i] = n4;
                this.choices[i].distance[n2] = n4;
            }
        }
    }

    Choice makeExtraChoice(Coding coding) {
        int[] nArray = new int[this.choices.length];
        for (int i = 0; i < nArray.length; ++i) {
            Coding coding2 = this.choices[i].coding;
            int n = coding.distanceFrom(coding2);
            assert (n > 0);
            assert (n == coding2.distanceFrom(coding));
            nArray[i] = n;
        }
        Choice choice = new Choice(coding, -1, nArray);
        choice.reset();
        return choice;
    }

    ByteArrayOutputStream getContext() {
        if (this.context == null) {
            this.context = new ByteArrayOutputStream(65536);
        }
        return this.context;
    }

    private void reset(int[] nArray, int n, int n2) {
        this.values = nArray;
        this.start = n;
        this.end = n2;
        this.deltas = null;
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.vHist = null;
        this.dHist = null;
        this.searchOrder = 0;
        this.regularChoice = null;
        this.bestChoice = null;
        this.bestMethod = null;
        this.bestZipSize = Integer.MAX_VALUE;
        this.bestByteSize = Integer.MAX_VALUE;
        this.targetSize = Integer.MAX_VALUE;
    }

    CodingMethod choose(int[] nArray, int n, int n2, Coding coding, int[] nArray2) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.reset(nArray, n, n2);
        if (this.effort <= 1 || n >= n2) {
            if (nArray2 != null) {
                int[] nArray3 = this.computeSizePrivate(coding);
                nArray2[0] = nArray3[0];
                nArray2[1] = nArray3[1];
            }
            return coding;
        }
        if (this.optUseHistogram) {
            this.getValueHistogram();
            this.getDeltaHistogram();
        }
        for (n6 = n; n6 < n2; ++n6) {
            n5 = nArray[n6];
            if (this.min > n5) {
                this.min = n5;
            }
            if (this.max >= n5) continue;
            this.max = n5;
        }
        n6 = this.markUsableChoices(coding);
        if (this.stress != null) {
            n5 = this.stress.nextInt(n6 * 2 + 4);
            CodingMethod codingMethod = null;
            for (int i = 0; i < this.choices.length; ++i) {
                Choice choice = this.choices[i];
                if (choice.searchOrder < 0 || n5-- != 0) continue;
                codingMethod = choice.coding;
                break;
            }
            if (codingMethod == null) {
                codingMethod = (n5 & 7) != 0 ? coding : this.stressCoding(this.min, this.max);
            }
            if (!this.disablePopCoding && this.optUsePopulationCoding && this.effort >= 4) {
                codingMethod = this.stressPopCoding(codingMethod);
            }
            if (!this.disableRunCoding && this.optUseAdaptiveCoding && this.effort >= 3) {
                codingMethod = this.stressAdaptiveCoding(codingMethod);
            }
            return codingMethod;
        }
        double d = 1.0;
        for (n4 = this.effort; n4 < 9; ++n4) {
            d /= 1.414;
        }
        n4 = (int)Math.ceil((double)n6 * d);
        this.bestChoice = this.regularChoice;
        this.evaluate(this.regularChoice);
        int n7 = this.updateDistances(this.regularChoice);
        int n8 = this.bestZipSize;
        int n9 = this.bestByteSize;
        if (this.regularChoice.coding == coding && this.topLevel && coding.canRepresentSigned(n3 = BandStructure.encodeEscapeValue(115, coding))) {
            int n10 = coding.getLength(n3);
            this.regularChoice.zipSize -= n10;
            this.bestByteSize = this.regularChoice.byteSize;
            this.bestZipSize = this.regularChoice.zipSize;
        }
        n3 = 1;
        while (this.searchOrder < n4) {
            int n11;
            int n12;
            Choice choice;
            if (n3 > n7) {
                n3 = 1;
            }
            if ((choice = this.findChoiceNear(this.bestChoice, n12 = n7 / n3, n11 = n7 / (n3 *= 2) + 1)) == null) continue;
            assert (choice.coding.canRepresent(this.min, this.max));
            this.evaluate(choice);
            int n13 = this.updateDistances(choice);
            if (choice != this.bestChoice) continue;
            n7 = n13;
            if (this.verbose <= 5) continue;
            Utils.log.info("maxd = " + n7);
        }
        Coding coding2 = this.bestChoice.coding;
        assert (coding2 == this.bestMethod);
        if (this.verbose > 2) {
            Utils.log.info("chooser: plain result=" + this.bestChoice + " after " + this.bestChoice.searchOrder + " rounds, " + (this.regularChoice.zipSize - this.bestZipSize) + " fewer bytes than regular " + coding);
        }
        this.bestChoice = null;
        if (!this.disablePopCoding && this.optUsePopulationCoding && this.effort >= 4 && this.bestMethod instanceof Coding) {
            this.tryPopulationCoding(coding2);
        }
        if (!this.disableRunCoding && this.optUseAdaptiveCoding && this.effort >= 3 && this.bestMethod instanceof Coding) {
            this.tryAdaptiveCoding(coding2);
        }
        if (nArray2 != null) {
            nArray2[0] = this.bestByteSize;
            nArray2[1] = this.bestZipSize;
        }
        if (this.verbose > 1) {
            Utils.log.info("chooser: result=" + this.bestMethod + " " + (n8 - this.bestZipSize) + " fewer bytes than regular " + coding + "; win=" + CodingChooser.pct(n8 - this.bestZipSize, n8));
        }
        CodingMethod codingMethod = this.bestMethod;
        this.reset(null, 0, 0);
        return codingMethod;
    }

    CodingMethod choose(int[] nArray, int n, int n2, Coding coding) {
        return this.choose(nArray, n, n2, coding, null);
    }

    CodingMethod choose(int[] nArray, Coding coding, int[] nArray2) {
        return this.choose(nArray, 0, nArray.length, coding, nArray2);
    }

    CodingMethod choose(int[] nArray, Coding coding) {
        return this.choose(nArray, 0, nArray.length, coding, null);
    }

    private int markUsableChoices(Coding coding) {
        Choice choice;
        int n;
        int n2 = 0;
        for (n = 0; n < this.choices.length; ++n) {
            choice = this.choices[n];
            choice.reset();
            if (!choice.coding.canRepresent(this.min, this.max)) {
                choice.searchOrder = -1;
                if (this.verbose <= 1 || choice.coding != coding) continue;
                Utils.log.info("regular coding cannot represent [" + this.min + ".." + this.max + "]: " + coding);
                continue;
            }
            if (choice.coding == coding) {
                this.regularChoice = choice;
            }
            ++n2;
        }
        if (this.regularChoice == null && coding.canRepresent(this.min, this.max)) {
            this.regularChoice = this.makeExtraChoice(coding);
            if (this.verbose > 1) {
                Utils.log.info("*** regular choice is extra: " + this.regularChoice.coding);
            }
        }
        if (this.regularChoice == null) {
            for (n = 0; n < this.choices.length; ++n) {
                choice = this.choices[n];
                if (choice.searchOrder == -1) continue;
                this.regularChoice = choice;
                break;
            }
            if (this.verbose > 1) {
                Utils.log.info("*** regular choice does not apply " + coding);
                Utils.log.info("    using instead " + this.regularChoice.coding);
            }
        }
        if (this.verbose > 2) {
            Utils.log.info("chooser: #choices=" + n2 + " [" + this.min + ".." + this.max + "]");
            if (this.verbose > 4) {
                for (n = 0; n < this.choices.length; ++n) {
                    choice = this.choices[n];
                    if (choice.searchOrder < 0) continue;
                    Utils.log.info("  " + choice);
                }
            }
        }
        return n2;
    }

    private Choice findChoiceNear(Choice choice, int n, int n2) {
        if (this.verbose > 5) {
            Utils.log.info("findChoice " + n + ".." + n2 + " near: " + choice);
        }
        int[] nArray = choice.distance;
        Choice choice2 = null;
        for (int i = 0; i < this.choices.length; ++i) {
            Choice choice3 = this.choices[i];
            if (choice3.searchOrder < this.searchOrder || nArray[i] < n2 || nArray[i] > n) continue;
            if (choice3.minDistance >= n2 && choice3.minDistance <= n) {
                if (this.verbose > 5) {
                    Utils.log.info("findChoice => good " + choice3);
                }
                return choice3;
            }
            choice2 = choice3;
        }
        if (this.verbose > 5) {
            Utils.log.info("findChoice => found " + choice2);
        }
        return choice2;
    }

    private void evaluate(Choice choice) {
        Object object;
        boolean bl;
        assert (choice.searchOrder == Integer.MAX_VALUE);
        choice.searchOrder = this.searchOrder++;
        if (choice == this.bestChoice || choice.isExtra()) {
            bl = true;
        } else if (this.optUseHistogram) {
            object = this.getHistogram(choice.coding.isDelta());
            choice.byteSize = choice.histSize = (int)Math.ceil(((Histogram)object).getBitLength(choice.coding) / 8.0);
            bl = choice.byteSize <= this.targetSize;
        } else {
            bl = true;
        }
        if (bl) {
            object = this.computeSizePrivate(choice.coding);
            choice.byteSize = object[0];
            choice.zipSize = (int)object[1];
            if (this.noteSizes(choice.coding, choice.byteSize, choice.zipSize)) {
                this.bestChoice = choice;
            }
        }
        if (choice.histSize >= 0) assert (choice.byteSize == choice.histSize);
        if (this.verbose > 4) {
            Utils.log.info("evaluated " + choice);
        }
    }

    private boolean noteSizes(CodingMethod codingMethod, int n, int n2) {
        boolean bl;
        assert (n2 > 0 && n > 0);
        boolean bl2 = bl = n2 < this.bestZipSize;
        if (this.verbose > 3) {
            Utils.log.info("computed size " + codingMethod + " " + n + "/zs=" + n2 + (bl && this.bestMethod != null ? " better by " + CodingChooser.pct(this.bestZipSize - n2, n2) : ""));
        }
        if (bl) {
            this.bestMethod = codingMethod;
            this.bestZipSize = n2;
            this.bestByteSize = n;
            this.targetSize = (int)((double)n * this.fuzz);
            return true;
        }
        return false;
    }

    private int updateDistances(Choice choice) {
        int[] nArray = choice.distance;
        int n = 0;
        for (int i = 0; i < this.choices.length; ++i) {
            int n2;
            Choice choice2 = this.choices[i];
            if (choice2.searchOrder < this.searchOrder) continue;
            int n3 = nArray[i];
            if (this.verbose > 5) {
                Utils.log.info("evaluate dist " + n3 + " to " + choice2);
            }
            if ((n2 = choice2.minDistance) > n3) {
                choice2.minDistance = n2 = n3;
            }
            if (n >= n3) continue;
            n = n3;
        }
        if (this.verbose > 5) {
            Utils.log.info("evaluate maxd => " + n);
        }
        return n;
    }

    public void computeSize(CodingMethod codingMethod, int[] nArray, int n, int n2, int[] nArray2) {
        if (n2 <= n) {
            nArray2[1] = 0;
            nArray2[0] = 0;
            return;
        }
        try {
            this.resetData();
            codingMethod.writeArrayTo(this.byteSizer, nArray, n, n2);
            nArray2[0] = this.getByteSize();
            nArray2[1] = this.getZipSize();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void computeSize(CodingMethod codingMethod, int[] nArray, int[] nArray2) {
        this.computeSize(codingMethod, nArray, 0, nArray.length, nArray2);
    }

    public int[] computeSize(CodingMethod codingMethod, int[] nArray, int n, int n2) {
        int[] nArray2 = new int[]{0, 0};
        this.computeSize(codingMethod, nArray, n, n2, nArray2);
        return nArray2;
    }

    public int[] computeSize(CodingMethod codingMethod, int[] nArray) {
        return this.computeSize(codingMethod, nArray, 0, nArray.length);
    }

    private int[] computeSizePrivate(CodingMethod codingMethod) {
        int[] nArray = new int[]{0, 0};
        this.computeSize(codingMethod, this.values, this.start, this.end, nArray);
        return nArray;
    }

    public int computeByteSize(CodingMethod codingMethod, int[] nArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            return 0;
        }
        if (codingMethod instanceof Coding) {
            int n4;
            Coding coding = (Coding)codingMethod;
            int n5 = coding.getLength(nArray, n, n2);
            assert (n5 == (n4 = this.countBytesToSizer(codingMethod, nArray, n, n2))) : codingMethod + " : " + n5 + " != " + n4;
            return n5;
        }
        return this.countBytesToSizer(codingMethod, nArray, n, n2);
    }

    private int countBytesToSizer(CodingMethod codingMethod, int[] nArray, int n, int n2) {
        try {
            this.byteOnlySizer.reset();
            codingMethod.writeArrayTo(this.byteOnlySizer, nArray, n, n2);
            return this.byteOnlySizer.getSize();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    int[] getDeltas(int n, int n2) {
        if ((n | n2) != 0) {
            return Coding.makeDeltas(this.values, this.start, this.end, n, n2);
        }
        if (this.deltas == null) {
            this.deltas = Coding.makeDeltas(this.values, this.start, this.end, 0, 0);
        }
        return this.deltas;
    }

    Histogram getValueHistogram() {
        if (this.vHist == null) {
            this.vHist = new Histogram(this.values, this.start, this.end);
            if (this.verbose > 3) {
                this.vHist.print("vHist", System.out);
            } else if (this.verbose > 1) {
                this.vHist.print("vHist", null, System.out);
            }
        }
        return this.vHist;
    }

    Histogram getDeltaHistogram() {
        if (this.dHist == null) {
            this.dHist = new Histogram(this.getDeltas(0, 0));
            if (this.verbose > 3) {
                this.dHist.print("dHist", System.out);
            } else if (this.verbose > 1) {
                this.dHist.print("dHist", null, System.out);
            }
        }
        return this.dHist;
    }

    Histogram getHistogram(boolean bl) {
        return bl ? this.getDeltaHistogram() : this.getValueHistogram();
    }

    private void tryPopulationCoding(Coding coding) {
        Iterator iterator;
        CodingMethod codingMethod;
        int n;
        Histogram histogram = this.getValueHistogram();
        Coding coding2 = coding.getValueCoding();
        Coding coding3 = BandStructure.UNSIGNED5.setL(64);
        Coding coding4 = coding.getValueCoding();
        int n2 = 4 + Math.max(coding2.getLength(this.min), coding2.getLength(this.max));
        int n3 = coding3.getLength(0);
        int n4 = n3 * (this.end - this.start);
        int n5 = (int)Math.ceil(histogram.getBitLength(coding4) / 8.0);
        int n6 = n2 + n4 + n5;
        int n7 = 0;
        int[] nArray = new int[1 + histogram.getTotalLength()];
        int n8 = -1;
        int n9 = -1;
        int[][] nArray2 = histogram.getMatrix();
        int n10 = -1;
        int n11 = 1;
        int n12 = 0;
        for (n = 1; n <= histogram.getTotalLength(); ++n) {
            int n13;
            if (n11 == 1) {
                n12 = nArray2[++n10][0];
                n11 = nArray2[n10].length;
            }
            nArray[n] = n13 = nArray2[n10][--n11];
            int n14 = coding2.getLength(n13);
            int n15 = n12;
            int n16 = n;
            int n17 = (n2 += n14) + (n4 += (coding3.getLength(n16) - n3) * n15) + (n5 -= n14 * n15);
            if (n6 <= n17) continue;
            if (n17 <= this.targetSize) {
                n9 = n;
                if (n8 < 0) {
                    n8 = n;
                }
                if (this.verbose > 4) {
                    Utils.log.info("better pop-size at fvc=" + n + " by " + CodingChooser.pct(n6 - n17, n6));
                }
            }
            n6 = n17;
            n7 = n;
        }
        if (n8 < 0) {
            if (this.verbose > 1 && this.verbose > 1) {
                Utils.log.info("no good pop-size; best was " + n6 + " at " + n7 + " worse by " + CodingChooser.pct(n6 - this.bestByteSize, this.bestByteSize));
            }
            return;
        }
        if (this.verbose > 1) {
            Utils.log.info("initial best pop-size at fvc=" + n7 + " in [" + n8 + ".." + n9 + "]" + " by " + CodingChooser.pct(this.bestByteSize - n6, this.bestByteSize));
        }
        n = this.bestZipSize;
        int[] nArray3 = PopulationCoding.LValuesCoded;
        ArrayList<Coding> arrayList = new ArrayList<Coding>();
        ArrayList<Coding> arrayList2 = new ArrayList<Coding>();
        ArrayList<Coding> arrayList3 = new ArrayList<Coding>();
        if (n7 <= 255) {
            arrayList.add(BandStructure.BYTE1);
        } else {
            boolean bl;
            int n18 = 5;
            boolean bl2 = bl = this.effort > 4;
            if (bl) {
                arrayList2.add(BandStructure.BYTE1.setS(1));
            }
            for (int i = nArray3.length - 1; i >= 1; --i) {
                int n19 = nArray3[i];
                Coding coding5 = PopulationCoding.fitTokenCoding(n8, n19);
                Coding coding6 = PopulationCoding.fitTokenCoding(n7, n19);
                codingMethod = PopulationCoding.fitTokenCoding(n9, n19);
                if (coding6 != null) {
                    if (!arrayList.contains(coding6)) {
                        arrayList.add(coding6);
                    }
                    if (n18 > coding6.B()) {
                        n18 = coding6.B();
                    }
                }
                if (!bl) continue;
                if (codingMethod == null) {
                    codingMethod = coding6;
                }
                for (int j = coding5.B(); j <= ((Coding)codingMethod).B(); ++j) {
                    Coding coding7;
                    if (j == coding6.B() || j == 1 || arrayList2.contains(coding7 = ((Coding)codingMethod).setB(j).setS(1))) continue;
                    arrayList2.add(coding7);
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Coding coding8 = (Coding)iterator.next();
                if (coding8.B() <= n18) continue;
                iterator.remove();
                arrayList3.add(0, coding8);
            }
        }
        ArrayList arrayList4 = new ArrayList();
        Iterator iterator2 = arrayList.iterator();
        iterator = arrayList2.iterator();
        Object object2 = arrayList3.iterator();
        while (iterator2.hasNext() || iterator.hasNext() || object2.hasNext()) {
            if (iterator2.hasNext()) {
                arrayList4.add(iterator2.next());
            }
            if (iterator.hasNext()) {
                arrayList4.add(iterator.next());
            }
            if (!object2.hasNext()) continue;
            arrayList4.add(object2.next());
        }
        arrayList.clear();
        arrayList2.clear();
        arrayList3.clear();
        int n20 = arrayList4.size();
        if (this.effort == 4) {
            n20 = 2;
        } else if (n20 > 4) {
            n20 -= 4;
            n20 = n20 * (this.effort - 4) / 5;
            n20 += 4;
        }
        if (arrayList4.size() > n20) {
            if (this.verbose > 4) {
                Utils.log.info("allFits before clip: " + arrayList4);
            }
            arrayList4.subList(n20, arrayList4.size()).clear();
        }
        if (this.verbose > 3) {
            Utils.log.info("allFits: " + arrayList4);
        }
        for (Object object2 : arrayList4) {
            int n21;
            boolean bl = false;
            if (((Coding)object2).S() == 1) {
                bl = true;
                object2 = ((Coding)object2).setS(0);
            }
            if (!bl) {
                n21 = n7;
                assert (((Coding)object2).umax() >= n21);
                assert (((Coding)object2).B() == 1 || ((Coding)object2).setB(((Coding)object2).B() - 1).umax() < n21);
            } else {
                n21 = Math.min(((Coding)object2).umax(), n9);
                if (n21 < n8 || n21 == n7) continue;
            }
            codingMethod = new PopulationCoding();
            ((PopulationCoding)codingMethod).setHistogram(histogram);
            ((PopulationCoding)codingMethod).setL(((Coding)object2).L());
            ((PopulationCoding)codingMethod).setFavoredValues(nArray, n21);
            assert (((PopulationCoding)codingMethod).tokenCoding == object2);
            ((PopulationCoding)codingMethod).resortFavoredValues();
            int[] nArray4 = this.computePopSizePrivate((PopulationCoding)codingMethod, coding2, coding4);
            this.noteSizes(codingMethod, nArray4[0], 4 + nArray4[1]);
        }
        if (this.verbose > 3) {
            Utils.log.info("measured best pop, size=" + this.bestByteSize + "/zs=" + this.bestZipSize + " better by " + CodingChooser.pct(n - this.bestZipSize, n));
            if (this.bestZipSize < n) {
                Utils.log.info(">>> POP WINS BY " + (n - this.bestZipSize));
            }
        }
    }

    private int[] computePopSizePrivate(PopulationCoding populationCoding, Coding coding, Coding coding2) {
        Object object;
        if (this.popHelper == null) {
            this.popHelper = new CodingChooser(this.effort, this.allCodingChoices);
            if (this.stress != null) {
                this.popHelper.addStressSeed(this.stress.nextInt());
            }
            this.popHelper.topLevel = false;
            --this.popHelper.verbose;
            this.popHelper.disablePopCoding = true;
            this.popHelper.disableRunCoding = this.disableRunCoding;
            if (this.effort < 5) {
                this.popHelper.disableRunCoding = true;
            }
        }
        int n = populationCoding.fVlen;
        if (this.verbose > 2) {
            Utils.log.info("computePopSizePrivate fvlen=" + n + " tc=" + populationCoding.tokenCoding);
            Utils.log.info("{ //BEGIN");
        }
        int[] nArray = populationCoding.fValues;
        int[][] nArray2 = populationCoding.encodeValues(this.values, this.start, this.end);
        int[] nArray3 = nArray2[0];
        int[] nArray4 = nArray2[1];
        if (this.verbose > 2) {
            Utils.log.info("-- refine on fv[" + n + "] fc=" + coding);
        }
        populationCoding.setFavoredCoding(this.popHelper.choose(nArray, 1, 1 + n, coding));
        if (populationCoding.tokenCoding instanceof Coding && (this.stress == null || this.stress.nextBoolean())) {
            if (this.verbose > 2) {
                Utils.log.info("-- refine on tv[" + nArray3.length + "] tc=" + populationCoding.tokenCoding);
            }
            if ((object = this.popHelper.choose(nArray3, (Coding)populationCoding.tokenCoding)) != populationCoding.tokenCoding) {
                if (this.verbose > 2) {
                    Utils.log.info(">>> refined tc=" + object);
                }
                populationCoding.setTokenCoding((CodingMethod)object);
            }
        }
        if (nArray4.length == 0) {
            populationCoding.setUnfavoredCoding(null);
        } else {
            if (this.verbose > 2) {
                Utils.log.info("-- refine on uv[" + nArray4.length + "] uc=" + populationCoding.unfavoredCoding);
            }
            populationCoding.setUnfavoredCoding(this.popHelper.choose(nArray4, coding2));
        }
        if (this.verbose > 3) {
            Utils.log.info("finish computePopSizePrivate fvlen=" + n + " fc=" + populationCoding.favoredCoding + " tc=" + populationCoding.tokenCoding + " uc=" + populationCoding.unfavoredCoding);
            object = new StringBuilder();
            ((StringBuilder)object).append("fv = {");
            for (int i = 1; i <= n; ++i) {
                if (i % 10 == 0) {
                    ((StringBuilder)object).append('\n');
                }
                ((StringBuilder)object).append(" ").append(nArray[i]);
            }
            ((StringBuilder)object).append('\n');
            ((StringBuilder)object).append("}");
            Utils.log.info(((StringBuilder)object).toString());
        }
        if (this.verbose > 2) {
            Utils.log.info("} //END");
        }
        if (this.stress != null) {
            return null;
        }
        try {
            this.resetData();
            populationCoding.writeSequencesTo(this.byteSizer, nArray3, nArray4);
            object = new int[]{this.getByteSize(), this.getZipSize()};
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int[] nArray5 = null;
        assert ((nArray5 = this.computeSizePrivate(populationCoding)) != null);
        assert (nArray5[0] == object[0]) : nArray5[0] + " != " + (int)object[0];
        return object;
    }

    private void tryAdaptiveCoding(Coding coding) {
        int n;
        int n2;
        int n3 = this.bestZipSize;
        int n4 = this.start;
        int n5 = this.end;
        int[] nArray = this.values;
        int n6 = n5 - n4;
        if (coding.isDelta()) {
            nArray = this.getDeltas(0, 0);
            n4 = 0;
            n5 = nArray.length;
        }
        int[] nArray2 = new int[n6 + 1];
        int n7 = 0;
        int n8 = 0;
        for (int i = n4; i < n5; ++i) {
            int n9 = nArray[i];
            nArray2[n7++] = n8;
            int n10 = coding.getLength(n9);
            assert (n10 < Integer.MAX_VALUE);
            n8 += n10;
        }
        nArray2[n7++] = n8;
        assert (n7 == nArray2.length);
        double d = (double)n8 / (double)n6;
        double d2 = this.effort >= 5 ? (this.effort > 6 ? 1.001 : 1.003) : (this.effort > 3 ? 1.01 : 1.03);
        d2 *= d2;
        double d3 = d2 * d2;
        double d4 = d2 * d2 * d2;
        double[] dArray = new double[1 + (this.effort - 3)];
        double d5 = Math.log(n6);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.exp(d5 * (double)(i + 1) / (double)(dArray.length + 1));
        }
        int[] nArray3 = new int[dArray.length];
        int n11 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            int n12 = (int)Math.round(dArray[i]);
            if ((n12 = AdaptiveCoding.getNextK(n12 - 1)) <= 0 || n12 >= n6 || n11 > 0 && n12 == nArray3[n11 - 1]) continue;
            nArray3[n11++] = n12;
        }
        nArray3 = BandStructure.realloc(nArray3, n11);
        int[] nArray4 = new int[nArray3.length];
        double[] dArray2 = new double[nArray3.length];
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            n = nArray3[n2];
            double d6 = n < 10 ? d4 : (n < 100 ? d3 : d2);
            dArray2[n2] = d6;
            nArray4[n2] = 4 + (int)Math.ceil((double)n * d * d6);
        }
        if (this.verbose > 1) {
            System.out.print("tryAdaptiveCoding [" + n6 + "]" + " avgS=" + d + " fuzz=" + d2 + " meshes: {");
            for (n2 = 0; n2 < nArray3.length; ++n2) {
                System.out.print(" " + nArray3[n2] + "(" + nArray4[n2] + ")");
            }
            Utils.log.info(" }");
        }
        if (this.runHelper == null) {
            this.runHelper = new CodingChooser(this.effort, this.allCodingChoices);
            if (this.stress != null) {
                this.runHelper.addStressSeed(this.stress.nextInt());
            }
            this.runHelper.topLevel = false;
            --this.runHelper.verbose;
            this.runHelper.disableRunCoding = true;
            this.runHelper.disablePopCoding = this.disablePopCoding;
            if (this.effort < 5) {
                this.runHelper.disablePopCoding = true;
            }
        }
        block5: for (n2 = 0; n2 < n6; ++n2) {
            if ((n2 = AdaptiveCoding.getNextK(n2 - 1)) > n6) {
                n2 = n6;
            }
            for (n = nArray3.length - 1; n >= 0; --n) {
                CodingMethod codingMethod;
                CodingMethod codingMethod2;
                CodingMethod codingMethod3;
                int n13;
                int n14;
                int n15 = nArray3[n];
                int n16 = nArray4[n];
                if (n2 + n15 > n6 || (n14 = nArray2[n2 + n15] - nArray2[n2]) < n16) continue;
                int n17 = n2 + n15;
                int n18 = n14;
                double d7 = d * dArray2[n];
                while (n17 < n6 && n17 - n2 <= n6 / 2) {
                    n13 = n17;
                    int n19 = n18;
                    n17 += n15;
                    if ((n17 = n2 + AdaptiveCoding.getNextK(n17 - n2 - 1)) < 0 || n17 > n6) {
                        n17 = n6;
                    }
                    if (!((double)(n18 = nArray2[n17] - nArray2[n2]) < 4.0 + (double)(n17 - n2) * d7)) continue;
                    n18 = n19;
                    n17 = n13;
                    break;
                }
                n13 = n17;
                if (this.verbose > 2) {
                    Utils.log.info("bulge at " + n2 + "[" + (n17 - n2) + "] of " + CodingChooser.pct((double)n18 - d * (double)(n17 - n2), d * (double)(n17 - n2)));
                    Utils.log.info("{ //BEGIN");
                }
                if ((codingMethod3 = this.runHelper.choose(this.values, this.start + n2, this.start + n17, coding)) == coding) {
                    codingMethod2 = coding;
                    codingMethod = coding;
                } else {
                    codingMethod2 = this.runHelper.choose(this.values, this.start, this.start + n2, coding);
                    codingMethod = this.runHelper.choose(this.values, this.start + n17, this.start + n6, coding);
                }
                if (this.verbose > 2) {
                    Utils.log.info("} //END");
                }
                if (codingMethod2 == codingMethod3 && n2 > 0 && AdaptiveCoding.isCodableLength(n17)) {
                    n2 = 0;
                }
                if (codingMethod3 == codingMethod && n17 < n6) {
                    n17 = n6;
                }
                if (codingMethod2 != coding || codingMethod3 != coding || codingMethod != coding) {
                    CodingMethod codingMethod4;
                    int n20 = 0;
                    if (n17 == n6) {
                        codingMethod4 = codingMethod3;
                    } else {
                        codingMethod4 = new AdaptiveCoding(n17 - n2, codingMethod3, codingMethod);
                        n20 += 4;
                    }
                    if (n2 > 0) {
                        codingMethod4 = new AdaptiveCoding(n2, codingMethod2, codingMethod4);
                        n20 += 4;
                    }
                    int[] nArray5 = this.computeSizePrivate(codingMethod4);
                    this.noteSizes(codingMethod4, nArray5[0], nArray5[1] + n20);
                }
                n2 = n13;
                continue block5;
            }
        }
        if (this.verbose > 3 && this.bestZipSize < n3) {
            Utils.log.info(">>> RUN WINS BY " + (n3 - this.bestZipSize));
        }
    }

    private static String pct(double d, double d2) {
        return (double)Math.round(d / d2 * 10000.0) / 100.0 + "%";
    }

    private void resetData() {
        this.flushData();
        this.zipDef.reset();
        if (this.context != null) {
            try {
                this.context.writeTo(this.byteSizer);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.zipSizer.reset();
        this.byteSizer.reset();
    }

    private void flushData() {
        try {
            this.zipOut.finish();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private int getByteSize() {
        return this.byteSizer.getSize();
    }

    private int getZipSize() {
        this.flushData();
        return this.zipSizer.getSize();
    }

    void addStressSeed(int n) {
        if (this.stress == null) {
            return;
        }
        this.stress.setSeed((long)n + ((long)this.stress.nextInt() << 32));
    }

    private CodingMethod stressPopCoding(CodingMethod codingMethod) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        assert (this.stress != null);
        if (!(codingMethod instanceof Coding)) {
            return codingMethod;
        }
        Coding coding = ((Coding)codingMethod).getValueCoding();
        Histogram histogram = this.getValueHistogram();
        int n5 = this.stressLen(histogram.getTotalLength());
        if (n5 == 0) {
            return codingMethod;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.stress.nextBoolean()) {
            object = new HashSet();
            for (n4 = this.start; n4 < this.end; ++n4) {
                if (!object.add(this.values[n4])) continue;
                arrayList.add(this.values[n4]);
            }
        } else {
            object = histogram.getMatrix();
            for (n4 = 0; n4 < ((int[][])object).length; ++n4) {
                int[] nArray = object[n4];
                for (int i = 1; i < nArray.length; ++i) {
                    arrayList.add(nArray[i]);
                }
            }
        }
        if (((n3 = this.stress.nextInt()) & 7) <= 2) {
            Collections.shuffle(arrayList, this.stress);
        } else {
            if (((n3 >>>= 3) & 7) <= 2) {
                Collections.sort(arrayList);
            }
            if (((n3 >>>= 3) & 7) <= 2) {
                Collections.reverse(arrayList);
            }
            if (((n3 >>>= 3) & 7) <= 2) {
                Collections.rotate(arrayList, this.stressLen(arrayList.size()));
            }
        }
        if (arrayList.size() > n5) {
            if (((n3 >>>= 3) & 7) <= 2) {
                arrayList.subList(n5, arrayList.size()).clear();
            } else {
                arrayList.subList(0, arrayList.size() - n5).clear();
            }
        }
        n5 = arrayList.size();
        int[] nArray = new int[1 + n5];
        for (int i = 0; i < n5; ++i) {
            nArray[1 + i] = (Integer)arrayList.get(i);
        }
        PopulationCoding populationCoding = new PopulationCoding();
        populationCoding.setFavoredValues(nArray, n5);
        int[] nArray2 = PopulationCoding.LValuesCoded;
        for (n2 = 0; n2 < nArray2.length / 2; ++n2) {
            n = nArray2[this.stress.nextInt(nArray2.length)];
            if (n < 0 || PopulationCoding.fitTokenCoding(n5, n) == null) continue;
            populationCoding.setL(n);
            break;
        }
        if (populationCoding.tokenCoding == null) {
            n = n2 = nArray[1];
            for (int i = 2; i <= n5; ++i) {
                int n6 = nArray[i];
                if (n2 > n6) {
                    n2 = n6;
                }
                if (n >= n6) continue;
                n = n6;
            }
            populationCoding.tokenCoding = this.stressCoding(n2, n);
        }
        this.computePopSizePrivate(populationCoding, coding, coding);
        return populationCoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodingMethod stressAdaptiveCoding(CodingMethod codingMethod) {
        assert (this.stress != null);
        if (!(codingMethod instanceof Coding)) {
            return codingMethod;
        }
        Coding coding = (Coding)codingMethod;
        int n = this.end - this.start;
        if (n < 2) {
            return codingMethod;
        }
        int n2 = this.stressLen(n - 1) + 1;
        if (n2 == n) {
            return codingMethod;
        }
        try {
            assert (!this.disableRunCoding);
            this.disableRunCoding = true;
            int[] nArray = (int[])this.values.clone();
            CodingMethod codingMethod2 = null;
            int n3 = this.end;
            int n4 = this.start;
            while (n3 > n4) {
                int n5;
                int n6;
                int n7 = n6 = n3 - n4 < 100 ? -1 : this.stress.nextInt();
                if ((n6 & 7) != 0) {
                    n5 = n2 == 1 ? n2 : this.stressLen(n2 - 1) + 1;
                } else {
                    int n8 = (n6 >>>= 3) & 3;
                    int n9 = (n6 >>>= 3) & 0xFF;
                    while ((n5 = AdaptiveCoding.decodeK(n8, n9)) > n3 - n4) {
                        if (n9 != 3) {
                            n9 = 3;
                            continue;
                        }
                        --n8;
                    }
                    assert (AdaptiveCoding.isCodableLength(n5));
                }
                if (n5 > n3 - n4) {
                    n5 = n3 - n4;
                }
                while (!AdaptiveCoding.isCodableLength(n5)) {
                    --n5;
                }
                int n10 = n3 - n5;
                assert (n10 < n3);
                assert (n10 >= n4);
                CodingMethod codingMethod3 = this.choose(nArray, n10, n3, coding);
                codingMethod2 = codingMethod2 == null ? codingMethod3 : new AdaptiveCoding(n3 - n10, codingMethod3, codingMethod2);
                n3 = n10;
            }
            CodingMethod codingMethod4 = codingMethod2;
            return codingMethod4;
        }
        finally {
            this.disableRunCoding = false;
        }
    }

    private Coding stressCoding(int n, int n2) {
        assert (this.stress != null);
        for (int i = 0; i < 100; ++i) {
            Coding coding;
            Coding coding2 = Coding.of(this.stress.nextInt(5) + 1, this.stress.nextInt(256) + 1, this.stress.nextInt(3));
            if (coding2.B() == 1) {
                coding2 = coding2.setH(256);
            }
            if (coding2.H() == 256 && coding2.B() >= 5) {
                coding2 = coding2.setB(4);
            }
            if (this.stress.nextBoolean() && (coding = coding2.setD(1)).canRepresent(n, n2)) {
                return coding;
            }
            if (!coding2.canRepresent(n, n2)) continue;
            return coding2;
        }
        return BandStructure.UNSIGNED5;
    }

    private int stressLen(int n) {
        assert (this.stress != null);
        assert (n >= 0);
        int n2 = this.stress.nextInt(100);
        if (n2 < 20) {
            return Math.min(n / 5, n2);
        }
        if (n2 < 40) {
            return n;
        }
        return this.stress.nextInt(n);
    }

    static class Sizer
    extends OutputStream {
        final OutputStream out;
        private int count;

        Sizer(OutputStream outputStream) {
            this.out = outputStream;
        }

        Sizer() {
            this(null);
        }

        public void write(int n) throws IOException {
            ++this.count;
            if (this.out != null) {
                this.out.write(n);
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.count += n2;
            if (this.out != null) {
                this.out.write(byArray, n, n2);
            }
        }

        public void reset() {
            this.count = 0;
        }

        public int getSize() {
            return this.count;
        }

        public String toString() {
            String string = super.toString();
            assert ((string = this.stringForDebug()) != null);
            return string;
        }

        String stringForDebug() {
            return "<Sizer " + this.getSize() + ">";
        }
    }

    static class Choice {
        final Coding coding;
        final int index;
        final int[] distance;
        int searchOrder;
        int minDistance;
        int zipSize;
        int byteSize;
        int histSize;

        Choice(Coding coding, int n, int[] nArray) {
            this.coding = coding;
            this.index = n;
            this.distance = nArray;
        }

        void reset() {
            this.searchOrder = Integer.MAX_VALUE;
            this.minDistance = Integer.MAX_VALUE;
            this.histSize = -1;
            this.byteSize = -1;
            this.zipSize = -1;
        }

        boolean isExtra() {
            return this.index < 0;
        }

        public String toString() {
            return this.stringForDebug();
        }

        private String stringForDebug() {
            String string = "";
            if (this.searchOrder < Integer.MAX_VALUE) {
                string = string + " so: " + this.searchOrder;
            }
            if (this.minDistance < Integer.MAX_VALUE) {
                string = string + " md: " + this.minDistance;
            }
            if (this.zipSize > 0) {
                string = string + " zs: " + this.zipSize;
            }
            if (this.byteSize > 0) {
                string = string + " bs: " + this.byteSize;
            }
            if (this.histSize > 0) {
                string = string + " hs: " + this.histSize;
            }
            return "Choice[" + this.index + "] " + string + " " + this.coding;
        }
    }
}

