/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;

final class Histogram {
    protected final int[][] matrix;
    protected final int totalWeight;
    protected final int[] values;
    protected final int[] counts;
    private static final long LOW32 = 0xFFFFFFFFL;
    private static double log2 = Math.log(2.0);
    private final BitMetric bitMetric = new BitMetric(){

        public double getBitLength(int n) {
            return Histogram.this.getBitLength(n);
        }
    };

    public Histogram(int[] nArray) {
        long[] lArray = Histogram.computeHistogram2Col(Histogram.maybeSort(nArray));
        int[][] nArray2 = Histogram.makeTable(lArray);
        this.values = nArray2[0];
        this.counts = nArray2[1];
        this.matrix = Histogram.makeMatrix(lArray);
        this.totalWeight = nArray.length;
        assert (this.assertWellFormed(nArray));
    }

    public Histogram(int[] nArray, int n, int n2) {
        this(Histogram.sortedSlice(nArray, n, n2));
    }

    public Histogram(int[][] nArray) {
        int n;
        nArray = this.normalizeMatrix(nArray);
        this.matrix = nArray;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i].length - 1;
            n2 += n;
            n3 += nArray[i][0] * n;
        }
        this.totalWeight = n3;
        long[] lArray = new long[n2];
        n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 1; j < nArray[i].length; ++j) {
                lArray[n++] = (long)nArray[i][j] << 32 | 0xFFFFFFFFL & (long)nArray[i][0];
            }
        }
        assert (n == lArray.length);
        Arrays.sort(lArray);
        int[][] nArray2 = Histogram.makeTable(lArray);
        this.values = nArray2[1];
        this.counts = nArray2[0];
        assert (this.assertWellFormed(null));
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public int getRowCount() {
        return this.matrix.length;
    }

    public int getRowFrequency(int n) {
        return this.matrix[n][0];
    }

    public int getRowLength(int n) {
        return this.matrix[n].length - 1;
    }

    public int getRowValue(int n, int n2) {
        return this.matrix[n][n2 + 1];
    }

    public int getRowWeight(int n) {
        return this.getRowFrequency(n) * this.getRowLength(n);
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public int getTotalLength() {
        return this.values.length;
    }

    public int[] getAllValues() {
        return this.values;
    }

    public int[] getAllFrequencies() {
        return this.counts;
    }

    public int getFrequency(int n) {
        int n2 = Arrays.binarySearch(this.values, n);
        if (n2 < 0) {
            return 0;
        }
        assert (this.values[n2] == n);
        return this.counts[n2];
    }

    public double getBitLength(int n) {
        double d = (double)this.getFrequency(n) / (double)this.getTotalWeight();
        return -Math.log(d) / log2;
    }

    public double getRowBitLength(int n) {
        double d = (double)this.getRowFrequency(n) / (double)this.getTotalWeight();
        return -Math.log(d) / log2;
    }

    public BitMetric getBitMetric() {
        return this.bitMetric;
    }

    public double getBitLength() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            d += this.getRowBitLength(i) * (double)this.getRowWeight(i);
        }
        assert (0.1 > Math.abs(d - this.getBitLength(this.bitMetric)));
        return d;
    }

    public double getBitLength(BitMetric bitMetric) {
        double d = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 1; j < this.matrix[i].length; ++j) {
                d += (double)this.matrix[i][0] * bitMetric.getBitLength(this.matrix[i][j]);
            }
        }
        return d;
    }

    private static double round(double d, double d2) {
        return (double)Math.round(d * d2) / d2;
    }

    public int[][] normalizeMatrix(int[][] object) {
        int n;
        long[] lArray = new long[((int[][])object).length];
        for (int i = 0; i < ((int[][])object).length; ++i) {
            if (object[i].length <= 1 || (n = object[i][0]) <= 0) continue;
            lArray[i] = (long)n << 32 | (long)i;
        }
        Arrays.sort(lArray);
        int[][] nArrayArray = new int[((int[][])object).length][];
        n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            block14: {
                int[] nArray;
                block15: {
                    block13: {
                        if (n4 >= ((int[][])object).length) break block13;
                        long l = lArray[lArray.length - n4 - 1];
                        if (l == 0L) break block14;
                        nArray = object[(int)l];
                        assert (l >>> 32 == (long)nArray[0]);
                        break block15;
                    }
                    nArray = new int[]{-1};
                }
                if (nArray[0] != n && n3 > n2) {
                    int n5;
                    int n6 = 0;
                    for (int i = n2; i < n3; ++i) {
                        int[] nArray2 = nArrayArray[i];
                        assert (nArray2[0] == n);
                        n6 += nArray2.length - 1;
                    }
                    int[] nArray3 = new int[1 + n6];
                    nArray3[0] = n;
                    int n7 = 1;
                    for (n5 = n2; n5 < n3; ++n5) {
                        int[] nArray4 = nArrayArray[n5];
                        assert (nArray4[0] == n);
                        System.arraycopy(nArray4, 1, nArray3, n7, nArray4.length - 1);
                        n7 += nArray4.length - 1;
                    }
                    if (!Histogram.isSorted(nArray3, 1, true)) {
                        Arrays.sort(nArray3, 1, nArray3.length);
                        n5 = 2;
                        for (int i = 2; i < nArray3.length; ++i) {
                            if (nArray3[i] == nArray3[i - 1]) continue;
                            nArray3[n5++] = nArray3[i];
                        }
                        if (n5 < nArray3.length) {
                            int[] nArray5 = new int[n5];
                            System.arraycopy(nArray3, 0, nArray5, 0, n5);
                            nArray3 = nArray5;
                        }
                    }
                    nArrayArray[n2++] = nArray3;
                    n3 = n2;
                }
                if (n4 == ((int[][])object).length) break;
                n = nArray[0];
                nArrayArray[n3++] = nArray;
            }
            ++n4;
        }
        assert (n2 == n3);
        object = nArrayArray;
        if (n2 < ((int[][])object).length) {
            nArrayArray = new int[n2][];
            System.arraycopy(object, 0, nArrayArray, 0, n2);
            object = nArrayArray;
        }
        return object;
    }

    public String[] getRowTitles(String string) {
        int n = this.getTotalLength();
        int n2 = this.getTotalWeight();
        String[] stringArray = new String[this.matrix.length];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.matrix.length; ++i) {
            int n5 = this.getRowFrequency(i);
            int n6 = this.getRowLength(i);
            int n7 = this.getRowWeight(i);
            long l = ((long)(n3 += n7) * 100L + (long)(n2 / 2)) / (long)n2;
            long l2 = ((long)(n4 += n6) * 100L + (long)(n / 2)) / (long)n;
            double d = this.getRowBitLength(i);
            assert (0.1 > Math.abs(d - this.getBitLength(this.matrix[i][1])));
            stringArray[i] = string + "[" + i + "]" + " len=" + Histogram.round(d, 10.0) + " (" + n5 + "*[" + n6 + "])" + " (" + n3 + ":" + l + "%)" + " [" + n4 + ":" + l2 + "%]";
        }
        return stringArray;
    }

    public void print(PrintStream printStream) {
        this.print("hist", printStream);
    }

    public void print(String string, PrintStream printStream) {
        this.print(string, this.getRowTitles(string), printStream);
    }

    public void print(String string, String[] stringArray, PrintStream printStream) {
        int n = this.getTotalLength();
        int n2 = this.getTotalWeight();
        double d = this.getBitLength();
        double d2 = d / (double)n2;
        double d3 = (double)n2 / (double)n;
        String string2 = string + " len=" + Histogram.round(d, 10.0) + " avgLen=" + Histogram.round(d2, 10.0) + " weight(" + n2 + ")" + " unique[" + n + "]" + " avgWeight(" + Histogram.round(d3, 100.0) + ")";
        if (stringArray == null) {
            printStream.println(string2);
        } else {
            printStream.println(string2 + " {");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.matrix.length; ++i) {
                stringBuffer.setLength(0);
                stringBuffer.append("  ").append(stringArray[i]).append(" {");
                for (int j = 1; j < this.matrix[i].length; ++j) {
                    stringBuffer.append(" ").append(this.matrix[i][j]);
                }
                stringBuffer.append(" }");
                printStream.println(stringBuffer);
            }
            printStream.println("}");
        }
    }

    private static int[][] makeMatrix(long[] lArray) {
        Arrays.sort(lArray);
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(lArray[i] >>> 32);
        }
        long[] lArray2 = Histogram.computeHistogram2Col(nArray);
        int[][] nArrayArray = new int[lArray2.length][];
        int n = 0;
        int n2 = 0;
        int n3 = nArrayArray.length;
        while (--n3 >= 0) {
            long l = lArray2[n2++];
            int n4 = (int)l;
            int n5 = (int)(l >>> 32);
            int[] nArray2 = new int[1 + n5];
            nArray2[0] = n4;
            for (int i = 0; i < n5; ++i) {
                long l2 = lArray[n++];
                assert (l2 >>> 32 == (long)n4);
                nArray2[1 + i] = (int)l2;
            }
            nArrayArray[n3] = nArray2;
        }
        assert (n == lArray.length);
        return nArrayArray;
    }

    private static int[][] makeTable(long[] lArray) {
        int[][] nArray = new int[2][lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[0][i] = (int)lArray[i];
            nArray[1][i] = (int)(lArray[i] >>> 32);
        }
        return nArray;
    }

    private static long[] computeHistogram2Col(int[] nArray) {
        switch (nArray.length) {
            case 0: {
                return new long[0];
            }
            case 1: {
                return new long[]{0x100000000L | 0xFFFFFFFFL & (long)nArray[0]};
            }
        }
        long[] lArray = null;
        boolean bl = true;
        while (true) {
            int n = -1;
            int n2 = ~nArray[0];
            int n3 = 0;
            for (int i = 0; i <= nArray.length; ++i) {
                int n4 = i < nArray.length ? nArray[i] : ~n2;
                if (n4 == n2) {
                    ++n3;
                    continue;
                }
                if (!bl && n3 != 0) {
                    lArray[n] = (long)n3 << 32 | 0xFFFFFFFFL & (long)n2;
                }
                n2 = n4;
                n3 = 1;
                ++n;
            }
            if (!bl) break;
            lArray = new long[n];
            bl = false;
        }
        return lArray;
    }

    private static int[][] regroupHistogram(int[][] nArray, int[] nArray2) {
        int n;
        int n2;
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l += (long)(nArray[i].length - 1);
        }
        long l2 = 0L;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            l2 += (long)nArray2[n2];
        }
        if (l2 > l) {
            n2 = nArray2.length;
            long l3 = l;
            for (n = 0; n < nArray2.length; ++n) {
                if (l3 < (long)nArray2[n]) {
                    int[] nArray3 = new int[n + 1];
                    System.arraycopy(nArray2, 0, nArray3, 0, n + 1);
                    nArray2 = nArray3;
                    nArray2[n] = (int)l3;
                    l3 = 0L;
                    break;
                }
                l3 -= (long)nArray2[n];
            }
        } else {
            long l4 = l - l2;
            int[] nArray4 = new int[nArray2.length + 1];
            System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
            nArray4[nArray2.length] = (int)l4;
            nArray2 = nArray4;
        }
        int[][] nArrayArray = new int[nArray2.length][];
        int n3 = 0;
        int n4 = 1;
        n = nArray[n3].length;
        for (int i = 0; i < nArray2.length; ++i) {
            int n5;
            int n6 = nArray2[i];
            int[] nArray5 = new int[1 + n6];
            long l5 = 0L;
            nArrayArray[i] = nArray5;
            for (int j = 1; j < nArray5.length; j += n5) {
                n5 = nArray5.length - j;
                while (n4 == n) {
                    n4 = 1;
                    n = nArray[++n3].length;
                }
                if (n5 > n - n4) {
                    n5 = n - n4;
                }
                l5 += (long)nArray[n3][0] * (long)n5;
                System.arraycopy(nArray[n3], n - n5, nArray5, j, n5);
                n -= n5;
            }
            Arrays.sort(nArray5, 1, nArray5.length);
            nArray5[0] = (int)((l5 + (long)(n6 / 2)) / (long)n6);
        }
        assert (n4 == n);
        assert (n3 == nArray.length - 1);
        return nArrayArray;
    }

    public static Histogram makeByteHistogram(InputStream inputStream) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[4096];
        int[] nArray = new int[256];
        while ((n2 = inputStream.read(byArray)) > 0) {
            for (n = 0; n < n2; ++n) {
                int n3 = byArray[n] & 0xFF;
                nArray[n3] = nArray[n3] + 1;
            }
        }
        int[][] nArray2 = new int[256][2];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n][0] = nArray[n];
            nArray2[n][1] = n;
        }
        return new Histogram(nArray2);
    }

    private static int[] sortedSlice(int[] nArray, int n, int n2) {
        if (n == 0 && n2 == nArray.length && Histogram.isSorted(nArray, 0, false)) {
            return nArray;
        }
        int[] nArray2 = new int[n2 - n];
        System.arraycopy(nArray, n, nArray2, 0, nArray2.length);
        Arrays.sort(nArray2);
        return nArray2;
    }

    private static boolean isSorted(int[] nArray, int n, boolean bl) {
        for (int i = n + 1; i < nArray.length; ++i) {
            if (!(bl ? nArray[i - 1] >= nArray[i] : nArray[i - 1] > nArray[i])) continue;
            return false;
        }
        return true;
    }

    private static int[] maybeSort(int[] nArray) {
        if (!Histogram.isSorted(nArray, 0, false)) {
            nArray = (int[])nArray.clone();
            Arrays.sort(nArray);
        }
        return nArray;
    }

    private boolean assertWellFormed(int[] nArray) {
        return true;
    }

    public static interface BitMetric {
        public double getBitLength(int var1);
    }
}

