/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Histogram;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;

class PopulationCoding
implements CodingMethod {
    Histogram vHist;
    int[] fValues;
    int fVlen;
    long[] symtab;
    CodingMethod favoredCoding;
    CodingMethod tokenCoding;
    CodingMethod unfavoredCoding;
    int L = -1;
    static final int[] LValuesCoded = new int[]{-1, 4, 8, 16, 32, 64, 128, 192, 224, 240, 248, 252};

    PopulationCoding() {
    }

    public void setFavoredValues(int[] nArray, int n) {
        assert (nArray[0] == 0);
        assert (this.fValues == null);
        this.fValues = nArray;
        this.fVlen = n;
        if (this.L >= 0) {
            this.setL(this.L);
        }
    }

    public void setFavoredValues(int[] nArray) {
        int n = nArray.length - 1;
        this.setFavoredValues(nArray, n);
    }

    public void setHistogram(Histogram histogram) {
        this.vHist = histogram;
    }

    public void setL(int n) {
        this.L = n;
        if (n >= 0 && this.fValues != null && this.tokenCoding == null) {
            this.tokenCoding = PopulationCoding.fitTokenCoding(this.fVlen, n);
            assert (this.tokenCoding != null);
        }
    }

    public static Coding fitTokenCoding(int n, int n2) {
        if (n < 256) {
            return BandStructure.BYTE1;
        }
        Coding coding = BandStructure.UNSIGNED5.setL(n2);
        if (!coding.canRepresentUnsigned(n)) {
            return null;
        }
        Coding coding2 = coding;
        Coding coding3 = coding;
        while ((coding3 = coding3.setB(coding3.B() - 1)).umax() >= n) {
            coding2 = coding3;
        }
        return coding2;
    }

    public void setFavoredCoding(CodingMethod codingMethod) {
        this.favoredCoding = codingMethod;
    }

    public void setTokenCoding(CodingMethod codingMethod) {
        Coding coding;
        this.tokenCoding = codingMethod;
        this.L = -1;
        if (codingMethod instanceof Coding && this.fValues != null && (coding = (Coding)codingMethod) == PopulationCoding.fitTokenCoding(this.fVlen, coding.L())) {
            this.L = coding.L();
        }
    }

    public void setUnfavoredCoding(CodingMethod codingMethod) {
        this.unfavoredCoding = codingMethod;
    }

    public int favoredValueMaxLength() {
        if (this.L == 0) {
            return Integer.MAX_VALUE;
        }
        return BandStructure.UNSIGNED5.setL(this.L).umax();
    }

    public void resortFavoredValues() {
        Coding coding = (Coding)this.tokenCoding;
        this.fValues = BandStructure.realloc(this.fValues, 1 + this.fVlen);
        int n = 1;
        for (int i = 1; i <= coding.B(); ++i) {
            int n2 = coding.byteMax(i);
            if (n2 > this.fVlen) {
                n2 = this.fVlen;
            }
            if (n2 < coding.byteMin(i)) break;
            int n3 = n2 + 1;
            int n4 = n;
            if (n3 == n4) continue;
            assert (n3 > n4) : n3 + "!>" + n4;
            assert (coding.getLength(n4) == i) : i + " != len(" + n4 + ") == " + coding.getLength(n4);
            assert (coding.getLength(n3 - 1) == i) : i + " != len(" + (n3 - 1) + ") == " + coding.getLength(n3 - 1);
            int n5 = n4 + (n3 - n4) / 2;
            int n6 = n4;
            int n7 = -1;
            int n8 = n4;
            for (int j = n4; j < n3; ++j) {
                int n9 = this.fValues[j];
                int n10 = this.vHist.getFrequency(n9);
                if (n7 == n10) continue;
                if (i == 1) {
                    Arrays.sort(this.fValues, n8, j);
                } else if (Math.abs(n6 - n5) > Math.abs(j - n5)) {
                    n6 = j;
                }
                n7 = n10;
                n8 = j;
            }
            if (i == 1) {
                Arrays.sort(this.fValues, n8, n3);
            } else {
                Arrays.sort(this.fValues, n4, n6);
                Arrays.sort(this.fValues, n6, n3);
            }
            assert (coding.getLength(n4) == coding.getLength(n6));
            assert (coding.getLength(n4) == coding.getLength(n3 - 1));
            n = n2 + 1;
        }
        assert (n == this.fValues.length);
        this.symtab = null;
    }

    public int getToken(int n) {
        int n2;
        if (this.symtab == null) {
            this.symtab = this.makeSymtab();
        }
        if ((n2 = Arrays.binarySearch(this.symtab, (long)n << 32)) < 0) {
            n2 = -n2 - 1;
        }
        if (n2 < this.symtab.length && n == (int)(this.symtab[n2] >>> 32)) {
            return (int)this.symtab[n2];
        }
        return 0;
    }

    public int[][] encodeValues(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int[] nArray2 = new int[n2 - n];
        int n5 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            n4 = nArray[n + i];
            n3 = this.getToken(n4);
            if (n3 != 0) {
                nArray2[i] = n3;
                continue;
            }
            ++n5;
        }
        int[] nArray3 = new int[n5];
        n5 = 0;
        for (n4 = 0; n4 < nArray2.length; ++n4) {
            if (nArray2[n4] != 0) continue;
            n3 = nArray[n + n4];
            nArray3[n5++] = n3;
        }
        assert (n5 == nArray3.length);
        return new int[][]{nArray2, nArray3};
    }

    private long[] makeSymtab() {
        long[] lArray = new long[this.fVlen];
        for (int i = 1; i <= this.fVlen; ++i) {
            lArray[i - 1] = (long)this.fValues[i] << 32 | (long)i;
        }
        Arrays.sort(lArray);
        return lArray;
    }

    private Coding getTailCoding(CodingMethod codingMethod) {
        while (codingMethod instanceof AdaptiveCoding) {
            codingMethod = ((AdaptiveCoding)codingMethod).tailCoding;
        }
        return (Coding)codingMethod;
    }

    public void writeArrayTo(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        int[][] nArray2 = this.encodeValues(nArray, n, n2);
        this.writeSequencesTo(outputStream, nArray2[0], nArray2[1]);
    }

    void writeSequencesTo(OutputStream outputStream, int[] nArray, int[] nArray2) throws IOException {
        this.favoredCoding.writeArrayTo(outputStream, this.fValues, 1, 1 + this.fVlen);
        this.getTailCoding(this.favoredCoding).writeTo(outputStream, this.computeSentinelValue());
        this.tokenCoding.writeArrayTo(outputStream, nArray, 0, nArray.length);
        if (nArray2.length > 0) {
            this.unfavoredCoding.writeArrayTo(outputStream, nArray2, 0, nArray2.length);
        }
    }

    int computeSentinelValue() {
        int n;
        Coding coding = this.getTailCoding(this.favoredCoding);
        if (coding.isDelta()) {
            return 0;
        }
        int n2 = n = this.fValues[1];
        for (int i = 2; i <= this.fVlen; ++i) {
            n2 = this.fValues[i];
            n = PopulationCoding.moreCentral(n, n2);
        }
        if (coding.getLength(n) <= coding.getLength(n2)) {
            return n;
        }
        return n2;
    }

    public void readArrayFrom(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        int n3;
        this.setFavoredValues(this.readFavoredValuesFrom(inputStream, n2 - n));
        this.tokenCoding.readArrayFrom(inputStream, nArray, n, n2);
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = nArray[i];
            if (n3 == 0) {
                if (n5 < 0) {
                    n4 = i;
                } else {
                    nArray[n5] = i;
                }
                n5 = i;
                ++n6;
                continue;
            }
            nArray[i] = this.fValues[n3];
        }
        int[] nArray2 = new int[n6];
        if (n6 > 0) {
            this.unfavoredCoding.readArrayFrom(inputStream, nArray2, 0, n6);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            int n7 = nArray[n4];
            nArray[n4] = nArray2[n3];
            n4 = n7;
        }
    }

    int[] readFavoredValuesFrom(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        CodingMethod codingMethod;
        int[] nArray = new int[1000];
        HashSet<Integer> hashSet = null;
        assert ((hashSet = new HashSet<Integer>()) != null);
        int n4 = 1;
        n += n4;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        CodingMethod codingMethod2 = this.favoredCoding;
        while (codingMethod2 instanceof AdaptiveCoding) {
            codingMethod = (AdaptiveCoding)codingMethod2;
            n3 = ((AdaptiveCoding)codingMethod).headLength;
            while (n4 + n3 > nArray.length) {
                nArray = BandStructure.realloc(nArray);
            }
            int n7 = n4 + n3;
            ((AdaptiveCoding)codingMethod).headCoding.readArrayFrom(inputStream, nArray, n4, n7);
            while (n4 < n7) {
                n2 = nArray[n4++];
                assert (hashSet.add(n2));
                assert (n4 <= n);
                n6 = n2;
                n5 = PopulationCoding.moreCentral(n5, n2);
            }
            codingMethod2 = ((AdaptiveCoding)codingMethod).tailCoding;
        }
        codingMethod = (Coding)codingMethod2;
        if (((Coding)codingMethod).isDelta()) {
            long l = 0L;
            while (true) {
                n2 = ((Coding)codingMethod).isSubrange() ? ((Coding)codingMethod).reduceToUnsignedRange(l) : (int)(l += (long)((Coding)codingMethod).readFrom(inputStream));
                l = n2;
                if (n4 <= 1 || n2 != n6 && n2 != n5) {
                    if (n4 == nArray.length) {
                        nArray = BandStructure.realloc(nArray);
                    }
                    nArray[n4++] = n2;
                    assert (hashSet.add(n2));
                    assert (n4 <= n);
                    n6 = n2;
                    n5 = PopulationCoding.moreCentral(n5, n2);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                n3 = ((Coding)codingMethod).readFrom(inputStream);
                if (n4 > 1 && (n3 == n6 || n3 == n5)) break;
                if (n4 == nArray.length) {
                    nArray = BandStructure.realloc(nArray);
                }
                nArray[n4++] = n3;
                assert (hashSet.add(n3));
                assert (n4 <= n);
                n6 = n3;
                n5 = PopulationCoding.moreCentral(n5, n3);
            }
        }
        return BandStructure.realloc(nArray, n4);
    }

    private static int moreCentral(int n, int n2) {
        int n3;
        int n4 = n >> 31 ^ n << 1;
        int n5 = n2 >> 31 ^ n2 << 1;
        int n6 = n3 = (n4 -= Integer.MIN_VALUE) < (n5 -= Integer.MIN_VALUE) ? n : n2;
        assert (n3 == PopulationCoding.moreCentralSlow(n, n2));
        return n3;
    }

    private static int moreCentralSlow(int n, int n2) {
        int n3 = n;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n3 < 0) {
            return n2;
        }
        int n4 = n2;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n4 < 0) {
            return n;
        }
        if (n3 < n4) {
            return n;
        }
        if (n3 > n4) {
            return n2;
        }
        return n < n2 ? n : n2;
    }

    public byte[] getMetaCoding(Coding coding) {
        int n;
        int n2;
        CodingMethod codingMethod;
        int n3 = this.fVlen;
        int n4 = 0;
        if (this.tokenCoding instanceof Coding) {
            codingMethod = (Coding)this.tokenCoding;
            if (((Coding)codingMethod).B() == 1) {
                n4 = 1;
            } else if (this.L >= 0) {
                assert (this.L == ((Coding)codingMethod).L());
                for (n2 = 1; n2 < LValuesCoded.length; ++n2) {
                    if (LValuesCoded[n2] != this.L) continue;
                    n4 = n2;
                    break;
                }
            }
        }
        codingMethod = null;
        if (n4 != 0 && this.tokenCoding == PopulationCoding.fitTokenCoding(this.fVlen, this.L)) {
            codingMethod = this.tokenCoding;
        }
        n2 = this.favoredCoding == coding ? 1 : 0;
        int n5 = this.unfavoredCoding == coding || this.unfavoredCoding == null ? 1 : 0;
        boolean bl = this.tokenCoding == codingMethod;
        int n6 = n = bl ? n4 : 0;
        assert (bl == n > 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        byteArrayOutputStream.write(141 + n2 + 2 * n5 + 4 * n);
        try {
            if (n2 == 0) {
                byteArrayOutputStream.write(this.favoredCoding.getMetaCoding(coding));
            }
            if (!bl) {
                byteArrayOutputStream.write(this.tokenCoding.getMetaCoding(coding));
            }
            if (n5 == 0) {
                byteArrayOutputStream.write(this.unfavoredCoding.getMetaCoding(coding));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int parseMetaCoding(byte[] byArray, int n, Coding coding, CodingMethod[] codingMethodArray) {
        int n2;
        if ((n2 = byArray[n++] & 0xFF) < 141 || n2 >= 189) {
            return n - 1;
        }
        int n3 = (n2 -= 141) % 2;
        int n4 = n2 / 2 % 2;
        int n5 = n2 / 4;
        boolean bl = n5 > 0;
        int n6 = LValuesCoded[n5];
        CodingMethod[] codingMethodArray2 = new CodingMethod[]{coding};
        CodingMethod[] codingMethodArray3 = new CodingMethod[]{null};
        CodingMethod[] codingMethodArray4 = new CodingMethod[]{coding};
        if (n3 == 0) {
            n = BandStructure.parseMetaCoding(byArray, n, coding, codingMethodArray2);
        }
        if (!bl) {
            n = BandStructure.parseMetaCoding(byArray, n, coding, codingMethodArray3);
        }
        if (n4 == 0) {
            n = BandStructure.parseMetaCoding(byArray, n, coding, codingMethodArray4);
        }
        PopulationCoding populationCoding = new PopulationCoding();
        populationCoding.L = n6;
        populationCoding.favoredCoding = codingMethodArray2[0];
        populationCoding.tokenCoding = codingMethodArray3[0];
        populationCoding.unfavoredCoding = codingMethodArray4[0];
        codingMethodArray[0] = populationCoding;
        return n;
    }

    private String keyString(CodingMethod codingMethod) {
        if (codingMethod instanceof Coding) {
            return ((Coding)codingMethod).keyString();
        }
        if (codingMethod == null) {
            return "none";
        }
        return codingMethod.toString();
    }

    public String toString() {
        PropMap propMap = Utils.currentPropMap();
        boolean bl = propMap != null && propMap.getBoolean("com.sun.java.util.jar.pack.verbose.pop");
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("pop(").append("fVlen=").append(this.fVlen);
        if (bl && this.fValues != null) {
            stringBuilder.append(" fV=[");
            for (int i = 1; i <= this.fVlen; ++i) {
                stringBuilder.append(i == 1 ? "" : ",").append(this.fValues[i]);
            }
            stringBuilder.append(";").append(this.computeSentinelValue());
            stringBuilder.append("]");
        }
        stringBuilder.append(" fc=").append(this.keyString(this.favoredCoding));
        stringBuilder.append(" tc=").append(this.keyString(this.tokenCoding));
        stringBuilder.append(" uc=").append(this.keyString(this.unfavoredCoding));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

