/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DescriptorCache;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.PerInterface;
import com.sun.jmx.mbeanserver.Util;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.WeakHashMap;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MBeanIntrospector<M> {
    MBeanIntrospector() {
    }

    abstract PerInterfaceMap<M> getPerInterfaceMap();

    abstract MBeanInfoMap getMBeanInfoMap();

    abstract MBeanAnalyzer<M> getAnalyzer(Class<?> var1) throws NotCompliantMBeanException;

    abstract boolean isMXBean();

    abstract M mFrom(Method var1);

    abstract String getName(M var1);

    abstract Type getGenericReturnType(M var1);

    abstract Type[] getGenericParameterTypes(M var1);

    abstract String[] getSignature(M var1);

    abstract void checkMethod(M var1) throws IllegalArgumentException;

    abstract Object invokeM2(M var1, Object var2, Object[] var3, Object var4) throws InvocationTargetException, IllegalAccessException, MBeanException;

    abstract boolean validParameter(M var1, Object var2, int var3, Object var4);

    abstract MBeanAttributeInfo getMBeanAttributeInfo(String var1, M var2, M var3);

    abstract MBeanOperationInfo getMBeanOperationInfo(String var1, M var2);

    abstract Descriptor getBasicMBeanDescriptor();

    abstract Descriptor getMBeanDescriptor(Class<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final PerInterface<M> getPerInterface(Class<?> clazz) throws NotCompliantMBeanException {
        PerInterfaceMap<M> perInterfaceMap;
        PerInterfaceMap<M> perInterfaceMap2 = perInterfaceMap = this.getPerInterfaceMap();
        synchronized (perInterfaceMap2) {
            PerInterface<M> perInterface;
            WeakReference<PerInterface<M>> weakReference = (WeakReference<PerInterface<M>>)perInterfaceMap.get(clazz);
            PerInterface<M> perInterface2 = perInterface = weakReference == null ? null : (PerInterface<M>)weakReference.get();
            if (perInterface == null) {
                try {
                    MBeanAnalyzer<M> mBeanAnalyzer = this.getAnalyzer(clazz);
                    MBeanInfo mBeanInfo = this.makeInterfaceMBeanInfo(clazz, mBeanAnalyzer);
                    perInterface = new PerInterface<M>(clazz, this, mBeanAnalyzer, mBeanInfo);
                    weakReference = new WeakReference<PerInterface<M>>(perInterface);
                    perInterfaceMap.put(clazz, weakReference);
                }
                catch (Exception exception) {
                    throw Introspector.throwException(clazz, exception);
                }
            }
            return perInterface;
        }
    }

    private MBeanInfo makeInterfaceMBeanInfo(Class<?> clazz, MBeanAnalyzer<M> mBeanAnalyzer) {
        MBeanInfoMaker mBeanInfoMaker = new MBeanInfoMaker();
        mBeanAnalyzer.visit(mBeanInfoMaker);
        return mBeanInfoMaker.makeMBeanInfo(clazz, "Information on the management interface of the MBean");
    }

    final boolean consistent(M m, M m2) {
        return m == null || m2 == null || this.getGenericReturnType(m).equals(this.getGenericParameterTypes(m2)[0]);
    }

    final Object invokeM(M m, Object object, Object[] objectArray, Object object2) throws MBeanException, ReflectionException {
        try {
            return this.invokeM2(m, object, objectArray, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            MBeanIntrospector.unwrapInvocationTargetException(invocationTargetException);
            throw new RuntimeException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, illegalAccessException.toString());
        }
    }

    final void invokeSetter(String string, M m, Object object, Object object2, Object object3) throws MBeanException, ReflectionException, InvalidAttributeValueException {
        try {
            this.invokeM2(m, object, new Object[]{object2}, object3);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, illegalAccessException.toString());
        }
        catch (RuntimeException runtimeException) {
            this.maybeInvalidParameter(string, m, object2, object3);
            throw runtimeException;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.maybeInvalidParameter(string, m, object2, object3);
            MBeanIntrospector.unwrapInvocationTargetException(invocationTargetException);
        }
    }

    private void maybeInvalidParameter(String string, M m, Object object, Object object2) throws InvalidAttributeValueException {
        if (!this.validParameter(m, object, 0, object2)) {
            String string2 = "Invalid value for attribute " + string + ": " + object;
            throw new InvalidAttributeValueException(string2);
        }
    }

    static boolean isValidParameter(Method method, Object object, int n) {
        Class<?> clazz = method.getParameterTypes()[n];
        try {
            Object object2 = Array.newInstance(clazz, 1);
            Array.set(object2, 0, object);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static void unwrapInvocationTargetException(InvocationTargetException invocationTargetException) throws MBeanException {
        Throwable throwable = invocationTargetException.getCause();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new MBeanException((Exception)throwable, throwable == null ? null : throwable.toString());
    }

    final MBeanInfo getMBeanInfo(Object object, PerInterface<M> perInterface) {
        MBeanInfo mBeanInfo = this.getClassMBeanInfo(object.getClass(), perInterface);
        MBeanNotificationInfo[] mBeanNotificationInfoArray = MBeanIntrospector.findNotifications(object);
        if (mBeanNotificationInfoArray == null || mBeanNotificationInfoArray.length == 0) {
            return mBeanInfo;
        }
        return new MBeanInfo(mBeanInfo.getClassName(), mBeanInfo.getDescription(), mBeanInfo.getAttributes(), mBeanInfo.getConstructors(), mBeanInfo.getOperations(), mBeanNotificationInfoArray, mBeanInfo.getDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MBeanInfo getClassMBeanInfo(Class<?> clazz, PerInterface<M> perInterface) {
        MBeanInfoMap mBeanInfoMap;
        MBeanInfoMap mBeanInfoMap2 = mBeanInfoMap = this.getMBeanInfoMap();
        synchronized (mBeanInfoMap2) {
            Class<?> clazz2;
            MBeanInfo mBeanInfo;
            WeakHashMap weakHashMap = (WeakHashMap)mBeanInfoMap.get(clazz);
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap();
                mBeanInfoMap.put(clazz, weakHashMap);
            }
            if ((mBeanInfo = (MBeanInfo)weakHashMap.get(clazz2 = perInterface.getMBeanInterface())) == null) {
                MBeanInfo mBeanInfo2 = perInterface.getMBeanInfo();
                ImmutableDescriptor immutableDescriptor = ImmutableDescriptor.union(mBeanInfo2.getDescriptor(), this.getMBeanDescriptor(clazz));
                mBeanInfo = new MBeanInfo(clazz.getName(), mBeanInfo2.getDescription(), mBeanInfo2.getAttributes(), MBeanIntrospector.findConstructors(clazz), mBeanInfo2.getOperations(), null, immutableDescriptor);
                weakHashMap.put(clazz2, mBeanInfo);
            }
            return mBeanInfo;
        }
    }

    static MBeanNotificationInfo[] findNotifications(Object object) {
        if (!(object instanceof NotificationBroadcaster)) {
            return null;
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray = ((NotificationBroadcaster)object).getNotificationInfo();
        if (mBeanNotificationInfoArray == null) {
            return null;
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = new MBeanNotificationInfo[mBeanNotificationInfoArray.length];
        for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
            MBeanNotificationInfo mBeanNotificationInfo = mBeanNotificationInfoArray[i];
            if (mBeanNotificationInfo.getClass() != MBeanNotificationInfo.class) {
                mBeanNotificationInfo = (MBeanNotificationInfo)mBeanNotificationInfo.clone();
            }
            mBeanNotificationInfoArray2[i] = mBeanNotificationInfo;
        }
        return mBeanNotificationInfoArray2;
    }

    private static MBeanConstructorInfo[] findConstructors(Class<?> clazz) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[constructorArray.length];
        for (int i = 0; i < constructorArray.length; ++i) {
            mBeanConstructorInfoArray[i] = new MBeanConstructorInfo("Public constructor of the MBean", constructorArray[i]);
        }
        return mBeanConstructorInfoArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MBeanInfoMap
    extends WeakHashMap<Class<?>, WeakHashMap<Class<?>, MBeanInfo>> {
        MBeanInfoMap() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MBeanInfoMaker
    implements MBeanAnalyzer.MBeanVisitor<M> {
        private final List<MBeanAttributeInfo> attrs = Util.newList();
        private final List<MBeanOperationInfo> ops = Util.newList();

        private MBeanInfoMaker() {
        }

        @Override
        public void visitAttribute(String string, M m, M m2) {
            MBeanAttributeInfo mBeanAttributeInfo = MBeanIntrospector.this.getMBeanAttributeInfo(string, m, m2);
            this.attrs.add(mBeanAttributeInfo);
        }

        @Override
        public void visitOperation(String string, M m) {
            MBeanOperationInfo mBeanOperationInfo = MBeanIntrospector.this.getMBeanOperationInfo(string, m);
            this.ops.add(mBeanOperationInfo);
        }

        MBeanInfo makeMBeanInfo(Class<?> clazz, String string) {
            MBeanAttributeInfo[] mBeanAttributeInfoArray = this.attrs.toArray(new MBeanAttributeInfo[0]);
            MBeanOperationInfo[] mBeanOperationInfoArray = this.ops.toArray(new MBeanOperationInfo[0]);
            String string2 = "interfaceClassName=" + clazz.getName();
            ImmutableDescriptor immutableDescriptor = new ImmutableDescriptor(string2);
            Descriptor descriptor = MBeanIntrospector.this.getBasicMBeanDescriptor();
            Descriptor descriptor2 = Introspector.descriptorForElement(clazz);
            ImmutableDescriptor immutableDescriptor2 = DescriptorCache.getInstance().union(immutableDescriptor, descriptor, descriptor2);
            return new MBeanInfo(clazz.getName(), string, mBeanAttributeInfoArray, null, mBeanOperationInfoArray, null, immutableDescriptor2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PerInterfaceMap<M>
    extends WeakHashMap<Class<?>, WeakReference<PerInterface<M>>> {
        PerInterfaceMap() {
        }
    }
}

