/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Random;
import sun.net.PortConfig;

class DNSDatagramSocketFactory {
    static final int DEVIATION = 3;
    static final int THRESHOLD = 6;
    static final int BIT_DEVIATION = 2;
    static final int HISTORY = 32;
    static final int MAX_RANDOM_TRIES = 5;
    int lastport = 0;
    int suitablePortCount;
    int unsuitablePortCount;
    final int thresholdCount;
    final int deviation;
    final Random random;
    final PortHistory history;

    DNSDatagramSocketFactory() {
        this(new Random());
    }

    DNSDatagramSocketFactory(Random random) {
        this(random, 3, 6);
    }

    DNSDatagramSocketFactory(Random random, int n, int n2) {
        if (random == null) {
            throw new NullPointerException();
        }
        this.random = random;
        this.history = new PortHistory(32, random);
        this.deviation = Math.max(1, n);
        this.thresholdCount = Math.max(2, n2);
    }

    public synchronized DatagramSocket open() throws SocketException {
        boolean bl;
        DatagramSocket datagramSocket;
        boolean bl2;
        int n = this.lastport;
        boolean bl3 = bl2 = this.unsuitablePortCount > this.thresholdCount;
        if (bl2) {
            datagramSocket = this.openRandom();
            if (datagramSocket != null) {
                return datagramSocket;
            }
            this.unsuitablePortCount = 0;
            this.suitablePortCount = 0;
            n = 0;
        }
        datagramSocket = this.openDefault();
        this.lastport = datagramSocket.getLocalPort();
        if (n == 0) {
            this.history.offer(this.lastport);
            return datagramSocket;
        }
        bl2 = this.suitablePortCount > this.thresholdCount;
        boolean bl4 = Integer.bitCount(n ^ this.lastport) > 2 && Math.abs(this.lastport - n) > this.deviation;
        boolean bl5 = this.history.contains(this.lastport);
        boolean bl6 = bl = bl2 || bl4 && !bl5;
        if (bl && !bl5) {
            this.history.add(this.lastport);
        }
        if (bl) {
            if (!bl2) {
                ++this.suitablePortCount;
            } else if (!bl4 || bl5) {
                this.unsuitablePortCount = 1;
                this.suitablePortCount = this.thresholdCount / 2;
            }
            return datagramSocket;
        }
        assert (!bl2);
        DatagramSocket datagramSocket2 = this.openRandom();
        if (datagramSocket2 == null) {
            return datagramSocket;
        }
        ++this.unsuitablePortCount;
        datagramSocket.close();
        return datagramSocket2;
    }

    private DatagramSocket openDefault() throws SocketException {
        return new DatagramSocket();
    }

    synchronized boolean isUsingNativePortRandomization() {
        return this.unsuitablePortCount <= this.thresholdCount && this.suitablePortCount > this.thresholdCount;
    }

    synchronized boolean isUsingJavaPortRandomization() {
        return this.unsuitablePortCount > this.thresholdCount;
    }

    synchronized boolean isUndecided() {
        return !this.isUsingJavaPortRandomization() && !this.isUsingNativePortRandomization();
    }

    private DatagramSocket openRandom() {
        int n = 5;
        while (n-- > 0) {
            int n2 = EphemeralPortRange.LOWER + this.random.nextInt(EphemeralPortRange.RANGE);
            try {
                return new DatagramSocket(n2);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    static final class PortHistory {
        final int capacity;
        final int[] ports;
        final Random random;
        int index;

        PortHistory(int n, Random random) {
            this.random = random;
            this.capacity = n;
            this.ports = new int[n];
        }

        public boolean contains(int n) {
            int n2 = 0;
            for (int i = 0; i < this.capacity && (n2 = this.ports[i]) != 0 && n2 != n; ++i) {
            }
            return n2 == n;
        }

        public boolean add(int n) {
            if (this.ports[this.index] != 0) {
                this.ports[this.random.nextInt((int)this.capacity)] = n;
            } else {
                this.ports[this.index] = n;
            }
            if (++this.index == this.capacity) {
                this.index = 0;
            }
            return true;
        }

        public boolean offer(int n) {
            if (this.contains(n)) {
                return false;
            }
            return this.add(n);
        }
    }

    static final class EphemeralPortRange {
        static final int LOWER = PortConfig.getLower();
        static final int UPPER = PortConfig.getUpper();
        static final int RANGE = UPPER - LOWER + 1;

        private EphemeralPortRange() {
        }
    }
}

