/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunCodec;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public final class AlawCodec
extends SunCodec {
    private static final byte[] ALAW_TABH = new byte[256];
    private static final byte[] ALAW_TABL = new byte[256];
    private static final AudioFormat.Encoding[] alawEncodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW, AudioFormat.Encoding.PCM_SIGNED};
    private static final short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};
    private static final int tempBufferSize = 64;
    private byte[] tempBuffer = null;

    public AlawCodec() {
        super(alawEncodings, alawEncodings);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (audioFormat.getSampleSizeInBits() == 16) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.ALAW};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        if (audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                AudioFormat.Encoding[] encodingArray = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
                return encodingArray;
            }
            return new AudioFormat.Encoding[0];
        }
        return new AudioFormat.Encoding[0];
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && audioFormat.getEncoding().equals(AudioFormat.Encoding.ALAW) || encoding.equals(AudioFormat.Encoding.ALAW) && audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return this.getOutputFormats(audioFormat);
        }
        return new AudioFormat[0];
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat.Encoding encoding2 = audioFormat.getEncoding();
        if (encoding2.equals(encoding)) {
            return audioInputStream;
        }
        AudioFormat audioFormat2 = null;
        if (!this.isConversionSupported(encoding, audioInputStream.getFormat())) {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        if (encoding2.equals(AudioFormat.Encoding.ALAW) && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 2 * audioFormat.getChannels(), audioFormat.getSampleRate(), audioFormat.isBigEndian());
        } else if (encoding2.equals(AudioFormat.Encoding.PCM_SIGNED) && encoding.equals(AudioFormat.Encoding.ALAW)) {
            audioFormat2 = new AudioFormat(encoding, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getChannels(), audioFormat.getSampleRate(), false);
        } else {
            throw new IllegalArgumentException("Unsupported conversion: " + audioInputStream.getFormat().toString() + " to " + encoding.toString());
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        return this.getConvertedStream(audioFormat, audioInputStream);
    }

    private AudioInputStream getConvertedStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioInputStream audioInputStream2 = null;
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (audioFormat2.matches(audioFormat)) {
            audioInputStream2 = audioInputStream;
        } else {
            audioInputStream2 = new AlawCodecStream(audioInputStream, audioFormat);
            this.tempBuffer = new byte[64];
        }
        return audioInputStream2;
    }

    private AudioFormat[] getOutputFormats(AudioFormat audioFormat) {
        AudioFormat audioFormat2;
        Vector<AudioFormat> vector = new Vector<AudioFormat>();
        if (AudioFormat.Encoding.PCM_SIGNED.equals(audioFormat.getEncoding())) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.ALAW, audioFormat.getSampleRate(), 8, audioFormat.getChannels(), audioFormat.getChannels(), audioFormat.getSampleRate(), false);
            vector.addElement(audioFormat2);
        }
        if (AudioFormat.Encoding.ALAW.equals(audioFormat.getEncoding())) {
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            vector.addElement(audioFormat2);
            audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), true);
            vector.addElement(audioFormat2);
        }
        AudioFormat[] audioFormatArray = new AudioFormat[vector.size()];
        for (int i = 0; i < audioFormatArray.length; ++i) {
            audioFormatArray[i] = (AudioFormat)vector.elementAt(i);
        }
        return audioFormatArray;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int n = i ^ 0x55;
            int n2 = (n & 0xF) << 4;
            int n3 = (n & 0x70) >> 4;
            int n4 = n2 + 8;
            if (n3 >= 1) {
                n4 += 256;
            }
            if (n3 > 1) {
                n4 <<= n3 - 1;
            }
            if ((n & 0x80) == 0) {
                n4 = -n4;
            }
            AlawCodec.ALAW_TABL[i] = (byte)n4;
            AlawCodec.ALAW_TABH[i] = (byte)(n4 >> 8);
        }
    }

    final class AlawCodecStream
    extends AudioInputStream {
        boolean encode;
        AudioFormat encodeFormat;
        AudioFormat decodeFormat;
        byte[] tabByte1;
        byte[] tabByte2;
        int highByte;
        int lowByte;

        AlawCodecStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
            boolean bl;
            super(audioInputStream, audioFormat, -1L);
            this.encode = false;
            this.tabByte1 = null;
            this.tabByte2 = null;
            this.highByte = 0;
            this.lowByte = 1;
            AudioFormat audioFormat2 = audioInputStream.getFormat();
            if (!AlawCodec.this.isConversionSupported(audioFormat, audioFormat2)) {
                throw new IllegalArgumentException("Unsupported conversion: " + audioFormat2.toString() + " to " + audioFormat.toString());
            }
            if (AudioFormat.Encoding.ALAW.equals(audioFormat2.getEncoding())) {
                this.encode = false;
                this.encodeFormat = audioFormat2;
                this.decodeFormat = audioFormat;
                bl = audioFormat.isBigEndian();
            } else {
                this.encode = true;
                this.encodeFormat = audioFormat;
                this.decodeFormat = audioFormat2;
                bl = audioFormat2.isBigEndian();
            }
            if (bl) {
                this.tabByte1 = ALAW_TABH;
                this.tabByte2 = ALAW_TABL;
                this.highByte = 0;
                this.lowByte = 1;
            } else {
                this.tabByte1 = ALAW_TABL;
                this.tabByte2 = ALAW_TABH;
                this.highByte = 1;
                this.lowByte = 0;
            }
            if (audioInputStream instanceof AudioInputStream) {
                this.frameLength = audioInputStream.getFrameLength();
            }
            this.framePos = 0L;
            this.frameSize = audioFormat2.getFrameSize();
            if (this.frameSize == -1) {
                this.frameSize = 1;
            }
        }

        private short search(short s, short[] sArray, short s2) {
            for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
                if (s > sArray[s3]) continue;
                return s3;
            }
            return s2;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 % this.frameSize != 0) {
                n2 -= n2 % this.frameSize;
            }
            if (this.encode) {
                int n4;
                int n5 = 15;
                int n6 = 4;
                int n7 = 0;
                int n8 = n;
                int n9 = n2 * 2;
                int n10 = n4 = n9 > 64 ? 64 : n9;
                while ((n7 = super.read(AlawCodec.this.tempBuffer, 0, n4)) > 0) {
                    for (int i = 0; i < n7; i += 2) {
                        byte by;
                        int n11;
                        short s = (short)(AlawCodec.this.tempBuffer[i + this.highByte] << 8 & 0xFF00);
                        if ((s = (short)(s | (short)(AlawCodec.this.tempBuffer[i + this.lowByte] & 0xFF))) >= 0) {
                            n11 = 213;
                        } else {
                            n11 = 85;
                            s = (short)(-s - 8);
                        }
                        short s2 = this.search(s, seg_end, (short)8);
                        if (s2 >= 8) {
                            by = (byte)(0x7F ^ n11);
                        } else {
                            by = (byte)(s2 << n6);
                            by = s2 < 2 ? (byte)(by | (byte)(s >> 4 & n5)) : (byte)(by | (byte)(s >> s2 + 3 & n5));
                            by = (byte)(by ^ n11);
                        }
                        byArray[n8] = by;
                        ++n8;
                    }
                    n4 = (n9 -= n7) > 64 ? 64 : n9;
                }
                if (n8 == n && n7 < 0) {
                    return n7;
                }
                return n8 - n;
            }
            int n12 = n2 / 2;
            int n13 = n + n2 / 2;
            int n14 = super.read(byArray, n13, n12);
            for (n3 = n; n3 < n + n14 * 2; n3 += 2) {
                byArray[n3] = this.tabByte1[byArray[n13] & 0xFF];
                byArray[n3 + 1] = this.tabByte2[byArray[n13] & 0xFF];
                ++n13;
            }
            if (n14 < 0) {
                return n14;
            }
            return n3 - n;
        }
    }
}

