/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AudioFloatConverter;
import com.sun.media.sound.AudioFloatInputStream;
import com.sun.media.sound.SoftAudioBuffer;
import com.sun.media.sound.SoftMixingDataLine;
import com.sun.media.sound.SoftMixingMixer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

public final class SoftMixingClip
extends SoftMixingDataLine
implements Clip {
    private AudioFormat format;
    private int framesize;
    private byte[] data;
    private final InputStream datastream = new InputStream(){

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n < 0) {
                return n;
            }
            return byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            if (SoftMixingClip.this._loopcount != 0) {
                n4 = SoftMixingClip.this._loopend * SoftMixingClip.this.framesize;
                n3 = SoftMixingClip.this._loopstart * SoftMixingClip.this.framesize;
                int n5 = SoftMixingClip.this._frameposition * SoftMixingClip.this.framesize;
                if (n5 + n2 >= n4 && n5 < n4) {
                    int n6;
                    int n7 = n + n2;
                    int n8 = n;
                    while (n != n7) {
                        if (n5 == n4) {
                            if (SoftMixingClip.this._loopcount == 0) break;
                            n5 = n3;
                            if (SoftMixingClip.this._loopcount != -1) {
                                SoftMixingClip.this._loopcount--;
                            }
                        }
                        if ((n2 = n7 - n) > (n6 = n4 - n5)) {
                            n2 = n6;
                        }
                        System.arraycopy(SoftMixingClip.this.data, n5, byArray, n, n2);
                        n += n2;
                    }
                    if (SoftMixingClip.this._loopcount == 0) {
                        n2 = n7 - n;
                        n6 = n4 - n5;
                        if (n2 > n6) {
                            n2 = n6;
                        }
                        System.arraycopy(SoftMixingClip.this.data, n5, byArray, n, n2);
                        n += n2;
                    }
                    SoftMixingClip.this._frameposition = n5 / SoftMixingClip.this.framesize;
                    return n8 - n;
                }
            }
            n4 = SoftMixingClip.this._frameposition * SoftMixingClip.this.framesize;
            n3 = SoftMixingClip.this.bufferSize - n4;
            if (n3 == 0) {
                return -1;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(SoftMixingClip.this.data, n4, byArray, n, n2);
            SoftMixingClip.this._frameposition += n2 / SoftMixingClip.this.framesize;
            return n2;
        }
    };
    private int offset;
    private int bufferSize;
    private float[] readbuffer;
    private boolean open = false;
    private AudioFormat outputformat;
    private int out_nrofchannels;
    private int in_nrofchannels;
    private int frameposition = 0;
    private boolean frameposition_sg = false;
    private boolean active_sg = false;
    private int loopstart = 0;
    private int loopend = -1;
    private boolean active = false;
    private int loopcount = 0;
    private boolean _active = false;
    private int _frameposition = 0;
    private boolean loop_sg = false;
    private int _loopcount = 0;
    private int _loopstart = 0;
    private int _loopend = -1;
    private float _rightgain;
    private float _leftgain;
    private float _eff1gain;
    private float _eff2gain;
    private AudioFloatInputStream afis;

    SoftMixingClip(SoftMixingMixer softMixingMixer, DataLine.Info info) {
        super(softMixingMixer, info);
    }

    protected void processControlLogic() {
        this._rightgain = this.rightgain;
        this._leftgain = this.leftgain;
        this._eff1gain = this.eff1gain;
        this._eff2gain = this.eff2gain;
        if (this.active_sg) {
            this._active = this.active;
            this.active_sg = false;
        } else {
            this.active = this._active;
        }
        if (this.frameposition_sg) {
            this._frameposition = this.frameposition;
            this.frameposition_sg = false;
            this.afis = null;
        } else {
            this.frameposition = this._frameposition;
        }
        if (this.loop_sg) {
            this._loopcount = this.loopcount;
            this._loopstart = this.loopstart;
            this._loopend = this.loopend;
        }
        if (this.afis == null) {
            this.afis = AudioFloatInputStream.getInputStream(new AudioInputStream(this.datastream, this.format, -1L));
            if ((double)Math.abs(this.format.getSampleRate() - this.outputformat.getSampleRate()) > 1.0E-6) {
                this.afis = new SoftMixingDataLine.AudioFloatInputStreamResampler(this.afis, this.outputformat);
            }
        }
    }

    protected void processAudioLogic(SoftAudioBuffer[] softAudioBufferArray) {
        if (this._active) {
            int n;
            float[] fArray = softAudioBufferArray[0].array();
            float[] fArray2 = softAudioBufferArray[1].array();
            int n2 = softAudioBufferArray[0].getSize();
            int n3 = n2 * this.in_nrofchannels;
            if (this.readbuffer == null || this.readbuffer.length < n3) {
                this.readbuffer = new float[n3];
            }
            int n4 = 0;
            try {
                n4 = this.afis.read(this.readbuffer);
                if (n4 == -1) {
                    this._active = false;
                    return;
                }
                if (n4 != this.in_nrofchannels) {
                    Arrays.fill(this.readbuffer, n4, n3, 0.0f);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n5 = this.in_nrofchannels;
            int n6 = 0;
            int n7 = 0;
            while (n6 < n2) {
                int n8 = n6++;
                fArray[n8] = fArray[n8] + this.readbuffer[n7] * this._leftgain;
                n7 += n5;
            }
            if (this.out_nrofchannels != 1) {
                if (this.in_nrofchannels == 1) {
                    n6 = 0;
                    n7 = 0;
                    while (n6 < n2) {
                        int n9 = n6++;
                        fArray2[n9] = fArray2[n9] + this.readbuffer[n7] * this._rightgain;
                        n7 += n5;
                    }
                } else {
                    n6 = 0;
                    n7 = 1;
                    while (n6 < n2) {
                        int n10 = n6++;
                        fArray2[n10] = fArray2[n10] + this.readbuffer[n7] * this._rightgain;
                        n7 += n5;
                    }
                }
            }
            if ((double)this._eff1gain > 2.0E-4) {
                float[] fArray3 = softAudioBufferArray[2].array();
                n7 = 0;
                n = 0;
                while (n7 < n2) {
                    int n11 = n7++;
                    fArray3[n11] = fArray3[n11] + this.readbuffer[n] * this._eff1gain;
                    n += n5;
                }
                if (this.in_nrofchannels == 2) {
                    n7 = 0;
                    n = 1;
                    while (n7 < n2) {
                        int n12 = n7++;
                        fArray3[n12] = fArray3[n12] + this.readbuffer[n] * this._eff1gain;
                        n += n5;
                    }
                }
            }
            if ((double)this._eff2gain > 2.0E-4) {
                float[] fArray4 = softAudioBufferArray[3].array();
                n7 = 0;
                n = 0;
                while (n7 < n2) {
                    int n13 = n7++;
                    fArray4[n13] = fArray4[n13] + this.readbuffer[n] * this._eff2gain;
                    n += n5;
                }
                if (this.in_nrofchannels == 2) {
                    n7 = 0;
                    n = 1;
                    while (n7 < n2) {
                        int n14 = n7++;
                        fArray4[n14] = fArray4[n14] + this.readbuffer[n] * this._eff2gain;
                        n += n5;
                    }
                }
            }
        }
    }

    public int getFrameLength() {
        return this.bufferSize / this.format.getFrameSize();
    }

    public long getMicrosecondLength() {
        return (long)((double)this.getFrameLength() * (1000000.0 / (double)this.getFormat().getSampleRate()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loop(int n) {
        LineEvent lineEvent = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.active) {
                    return;
                }
                this.active = true;
                this.active_sg = true;
                this.loopcount = n;
                lineEvent = new LineEvent(this, LineEvent.Type.START, this.getLongFramePosition());
            }
        }
        if (lineEvent != null) {
            this.sendEvent(lineEvent);
        }
    }

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        if (this.isOpen()) {
            throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
        }
        if (AudioFloatConverter.getConverter(audioInputStream.getFormat()) == null) {
            throw new IllegalArgumentException("Invalid format : " + audioInputStream.getFormat().toString());
        }
        if (audioInputStream.getFrameLength() != -1L) {
            int n;
            int n2;
            byte[] byArray = new byte[(int)audioInputStream.getFrameLength() * audioInputStream.getFormat().getFrameSize()];
            int n3 = 512 * audioInputStream.getFormat().getFrameSize();
            for (n = 0; n != byArray.length; n += n2) {
                if (n3 > byArray.length - n) {
                    n3 = byArray.length - n;
                }
                if ((n2 = audioInputStream.read(byArray, n, n3)) == -1) break;
                if (n2 != 0) continue;
                Thread.yield();
            }
            this.open(audioInputStream.getFormat(), byArray, 0, n);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[512 * audioInputStream.getFormat().getFrameSize()];
            int n = 0;
            while ((n = audioInputStream.read(byArray)) != -1) {
                if (n == 0) {
                    Thread.yield();
                }
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.open(audioInputStream.getFormat(), byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                throw new IllegalStateException("Clip is already open with format " + this.getFormat() + " and frame lengh of " + this.getFrameLength());
            }
            if (AudioFloatConverter.getConverter(audioFormat) == null) {
                throw new IllegalArgumentException("Invalid format : " + audioFormat.toString());
            }
            if (n2 % audioFormat.getFrameSize() != 0) {
                throw new IllegalArgumentException("Buffer size does not represent an integral number of sample frames!");
            }
            this.data = byArray;
            this.offset = n;
            this.bufferSize = n2;
            this.format = audioFormat;
            this.framesize = audioFormat.getFrameSize();
            this.loopstart = 0;
            this.loopend = -1;
            this.loop_sg = true;
            if (!this.mixer.isOpen()) {
                this.mixer.open();
                this.mixer.implicitOpen = true;
            }
            this.outputformat = this.mixer.getFormat();
            this.out_nrofchannels = this.outputformat.getChannels();
            this.in_nrofchannels = audioFormat.getChannels();
            this.open = true;
            this.mixer.getMainMixer().openLine(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFramePosition(int n) {
        Object object = this.control_mutex;
        synchronized (object) {
            this.frameposition_sg = true;
            this.frameposition = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoopPoints(int n, int n2) {
        Object object = this.control_mutex;
        synchronized (object) {
            if (n2 != -1) {
                if (n2 < n) {
                    throw new IllegalArgumentException("Invalid loop points : " + n + " - " + n2);
                }
                if (n2 * this.framesize > this.bufferSize) {
                    throw new IllegalArgumentException("Invalid loop points : " + n + " - " + n2);
                }
            }
            if (n * this.framesize > this.bufferSize) {
                throw new IllegalArgumentException("Invalid loop points : " + n + " - " + n2);
            }
            if (0 < n) {
                throw new IllegalArgumentException("Invalid loop points : " + n + " - " + n2);
            }
            this.loopstart = n;
            this.loopend = n2;
            this.loop_sg = true;
        }
    }

    public void setMicrosecondPosition(long l) {
        this.setFramePosition((int)((double)l * ((double)this.getFormat().getSampleRate() / 1000000.0)));
    }

    public int available() {
        return 0;
    }

    public void drain() {
    }

    public void flush() {
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFramePosition() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.frameposition;
        }
    }

    public float getLevel() {
        return -1.0f;
    }

    public long getLongFramePosition() {
        return this.getFramePosition();
    }

    public long getMicrosecondPosition() {
        return (long)((double)this.getFramePosition() * (1000000.0 / (double)this.getFormat().getSampleRate()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.control_mutex;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LineEvent lineEvent = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (this.active) {
                    return;
                }
                this.active = true;
                this.active_sg = true;
                this.loopcount = 0;
                lineEvent = new LineEvent(this, LineEvent.Type.START, this.getLongFramePosition());
            }
        }
        if (lineEvent != null) {
            this.sendEvent(lineEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LineEvent lineEvent = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (this.isOpen()) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                this.active_sg = true;
                lineEvent = new LineEvent(this, LineEvent.Type.STOP, this.getLongFramePosition());
            }
        }
        if (lineEvent != null) {
            this.sendEvent(lineEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LineEvent lineEvent = null;
        Object object = this.control_mutex;
        synchronized (object) {
            if (!this.isOpen()) {
                return;
            }
            this.stop();
            lineEvent = new LineEvent(this, LineEvent.Type.CLOSE, this.getLongFramePosition());
            this.open = false;
            this.mixer.getMainMixer().closeLine(this);
        }
        if (lineEvent != null) {
            this.sendEvent(lineEvent);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void open() throws LineUnavailableException {
        if (this.data == null) {
            throw new IllegalArgumentException("Illegal call to open() in interface Clip");
        }
        this.open(this.format, this.data, this.offset, this.bufferSize);
    }
}

