/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SMFParser;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;
import javax.sound.midi.spi.MidiFileReader;

public final class StandardMidiFileReader
extends MidiFileReader {
    private static final int MThd_MAGIC = 1297377380;
    private static final int bisBufferSize = 1024;

    public MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        return this.getMidiFileFormatFromStream(inputStream, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MidiFileFormat getMidiFileFormatFromStream(InputStream inputStream, int n, SMFParser sMFParser) throws InvalidMidiDataException, IOException {
        int n2;
        float f;
        short s;
        int n3 = 16;
        int n4 = -1;
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        if (sMFParser == null) {
            dataInputStream.mark(n3);
        } else {
            sMFParser.stream = dataInputStream;
        }
        try {
            int n5 = dataInputStream.readInt();
            if (n5 != 1297377380) {
                throw new InvalidMidiDataException("not a valid MIDI file");
            }
            int n6 = dataInputStream.readInt() - 6;
            s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            int n7 = dataInputStream.readShort();
            if (n7 > 0) {
                f = 0.0f;
                n2 = n7;
            } else {
                int n8 = -1 * n7 >> 8;
                switch (n8) {
                    case 24: {
                        f = 24.0f;
                        break;
                    }
                    case 25: {
                        f = 25.0f;
                        break;
                    }
                    case 29: {
                        f = 29.97f;
                        break;
                    }
                    case 30: {
                        f = 30.0f;
                        break;
                    }
                    default: {
                        throw new InvalidMidiDataException("Unknown frame code: " + n8);
                    }
                }
                n2 = n7 & 0xFF;
            }
            if (sMFParser != null) {
                dataInputStream.skip(n6);
                sMFParser.tracks = s2;
            }
        }
        finally {
            if (sMFParser == null) {
                dataInputStream.reset();
            }
        }
        MidiFileFormat midiFileFormat = new MidiFileFormat(s, f, n2, n, n4);
        return midiFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        InputStream inputStream = uRL.openStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        MidiFileFormat midiFileFormat = null;
        try {
            midiFileFormat = this.getMidiFileFormat(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
        return midiFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            l = -1L;
        }
        MidiFileFormat midiFileFormat = null;
        try {
            midiFileFormat = this.getMidiFileFormatFromStream(bufferedInputStream, (int)l, null);
        }
        finally {
            bufferedInputStream.close();
        }
        return midiFileFormat;
    }

    public Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        SMFParser sMFParser = new SMFParser();
        MidiFileFormat midiFileFormat = this.getMidiFileFormatFromStream(inputStream, -1, sMFParser);
        if (midiFileFormat.getType() != 0 && midiFileFormat.getType() != 1) {
            throw new InvalidMidiDataException("Invalid or unsupported file type: " + midiFileFormat.getType());
        }
        Sequence sequence = new Sequence(midiFileFormat.getDivisionType(), midiFileFormat.getResolution());
        for (int i = 0; i < sMFParser.tracks && sMFParser.nextTrack(); ++i) {
            sMFParser.readTrack(sequence.createTrack());
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        InputStream inputStream = uRL.openStream();
        inputStream = new BufferedInputStream(inputStream, 1024);
        Sequence sequence = null;
        try {
            sequence = this.getSequence(inputStream);
        }
        finally {
            inputStream.close();
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        InputStream inputStream = new FileInputStream(file);
        inputStream = new BufferedInputStream(inputStream, 1024);
        Sequence sequence = null;
        try {
            sequence = this.getSequence(inputStream);
        }
        finally {
            inputStream.close();
        }
        return sequence;
    }
}

