/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ApplyTemplates;
import com.sun.org.apache.xalan.internal.xsltc.compiler.AttributeValue;
import com.sun.org.apache.xalan.internal.xsltc.compiler.AttributeValueTemplate;
import com.sun.org.apache.xalan.internal.xsltc.compiler.CallTemplate;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Choose;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Comment;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Copy;
import com.sun.org.apache.xalan.internal.xsltc.compiler.CopyOf;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ForEach;
import com.sun.org.apache.xalan.internal.xsltc.compiler.If;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Instruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.LiteralAttribute;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Number;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Otherwise;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ProcessingInstruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SimpleAttributeValue;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Text;
import com.sun.org.apache.xalan.internal.xsltc.compiler.UseAttributeSets;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ValueOf;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Variable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.When;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XslAttribute;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XslElement;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import com.sun.org.apache.xml.internal.serializer.ElemDesc;
import com.sun.org.apache.xml.internal.serializer.ToHTMLStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LiteralElement
extends Instruction {
    private String _name;
    private LiteralElement _literalElemParent = null;
    private List<SyntaxTreeNode> _attributeElements = null;
    private Map<String, String> _accessedPrefixes = null;
    private boolean _allAttributesUnique = false;
    private static final String XMLNS_STRING = "xmlns";

    LiteralElement() {
    }

    public QName getName() {
        return this._qname;
    }

    @Override
    public void display(int indent) {
        this.indent(indent);
        Util.println("LiteralElement name = " + this._name);
        this.displayContents(indent + 4);
    }

    private String accessedNamespace(String prefix) {
        String result;
        if (this._literalElemParent != null && (result = this._literalElemParent.accessedNamespace(prefix)) != null) {
            return result;
        }
        return this._accessedPrefixes != null ? this._accessedPrefixes.get(prefix) : null;
    }

    public void registerNamespace(String prefix, String uri, SymbolTable stable, boolean declared) {
        String old;
        String parentUri;
        if (this._literalElemParent != null && (parentUri = this._literalElemParent.accessedNamespace(prefix)) != null && parentUri.equals(uri)) {
            return;
        }
        if (this._accessedPrefixes == null) {
            this._accessedPrefixes = new Hashtable<String, String>();
        } else if (!declared && (old = this._accessedPrefixes.get(prefix)) != null) {
            if (old.equals(uri)) {
                return;
            }
            prefix = stable.generateNamespacePrefix();
        }
        if (!prefix.equals("xml")) {
            this._accessedPrefixes.put(prefix, uri);
        }
    }

    private String translateQName(QName qname, SymbolTable stable) {
        String uri;
        String localname = qname.getLocalPart();
        String prefix = qname.getPrefix();
        if (prefix == null) {
            prefix = "";
        } else if (prefix.equals(XMLNS_STRING)) {
            return XMLNS_STRING;
        }
        String alternative = stable.lookupPrefixAlias(prefix);
        if (alternative != null) {
            stable.excludeNamespaces(prefix);
            prefix = alternative;
        }
        if ((uri = this.lookupNamespace(prefix)) == null) {
            return localname;
        }
        this.registerNamespace(prefix, uri, stable, false);
        if (prefix != "") {
            return prefix + ":" + localname;
        }
        return localname;
    }

    public void addAttribute(SyntaxTreeNode attribute) {
        if (this._attributeElements == null) {
            this._attributeElements = new ArrayList<SyntaxTreeNode>(2);
        }
        this._attributeElements.add(attribute);
    }

    public void setFirstAttribute(SyntaxTreeNode attribute) {
        if (this._attributeElements == null) {
            this._attributeElements = new ArrayList<SyntaxTreeNode>(2);
        }
        this._attributeElements.add(0, attribute);
    }

    @Override
    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._attributeElements != null) {
            for (SyntaxTreeNode node : this._attributeElements) {
                node.typeCheck(stable);
            }
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public Set<Map.Entry<String, String>> getNamespaceScope(SyntaxTreeNode node) {
        HashMap<String, String> all = new HashMap<String, String>();
        while (node != null) {
            Map<String, String> mapping = node.getPrefixMapping();
            if (mapping != null) {
                for (String prefix : mapping.keySet()) {
                    if (all.containsKey(prefix)) continue;
                    all.put(prefix, mapping.get(prefix));
                }
            }
            node = node.getParent();
        }
        return all.entrySet();
    }

    @Override
    public void parseContents(Parser parser) {
        String val;
        SymbolTable stable = parser.getSymbolTable();
        stable.setCurrentNode(this);
        SyntaxTreeNode parent = this.getParent();
        if (parent != null && parent instanceof LiteralElement) {
            this._literalElemParent = (LiteralElement)parent;
        }
        this._name = this.translateQName(this._qname, stable);
        int count = this._attributes.getLength();
        for (int i = 0; i < count; ++i) {
            QName qname = parser.getQName(this._attributes.getQName(i));
            String uri = qname.getNamespace();
            val = this._attributes.getValue(i);
            if (qname.equals(parser.getUseAttributeSets())) {
                if (!Util.isValidQNames(val)) {
                    ErrorMsg err = new ErrorMsg("INVALID_QNAME_ERR", (Object)val, this);
                    parser.reportError(3, err);
                }
                this.setFirstAttribute(new UseAttributeSets(val, parser));
                continue;
            }
            if (qname.equals(parser.getExtensionElementPrefixes())) {
                stable.excludeNamespaces(val);
                continue;
            }
            if (qname.equals(parser.getExcludeResultPrefixes())) {
                stable.excludeNamespaces(val);
                continue;
            }
            String prefix = qname.getPrefix();
            if (prefix != null && prefix.equals(XMLNS_STRING) || prefix == null && qname.getLocalPart().equals(XMLNS_STRING) || uri != null && uri.equals("http://www.w3.org/1999/XSL/Transform")) continue;
            String name = this.translateQName(qname, stable);
            LiteralAttribute attr = new LiteralAttribute(name, val, parser, this);
            this.addAttribute(attr);
            attr.setParent(this);
            attr.parseContents(parser);
        }
        Set<Map.Entry<String, String>> include = this.getNamespaceScope(this);
        for (Map.Entry<String, String> entry : include) {
            String uri;
            String prefix = entry.getKey();
            if (prefix.equals("xml") || (uri = this.lookupNamespace(prefix)) == null || stable.isExcludedNamespace(uri)) continue;
            this.registerNamespace(prefix, uri, stable, true);
        }
        this.parseChildren(parser);
        for (int i = 0; i < count; ++i) {
            QName qname = parser.getQName(this._attributes.getQName(i));
            val = this._attributes.getValue(i);
            if (qname.equals(parser.getExtensionElementPrefixes())) {
                stable.unExcludeNamespaces(val);
                continue;
            }
            if (!qname.equals(parser.getExcludeResultPrefixes())) continue;
            stable.unExcludeNamespaces(val);
        }
    }

    @Override
    protected boolean contextDependent() {
        return this.dependentContents();
    }

    @Override
    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        this._allAttributesUnique = this.checkAttributesUnique();
        il.append(methodGen.loadHandler());
        il.append(new PUSH(cpg, this._name));
        il.append(DUP2);
        il.append(methodGen.startElement());
        for (int j = 0; j < this.elementCount(); ++j) {
            SyntaxTreeNode item = (SyntaxTreeNode)this.elementAt(j);
            if (!(item instanceof Variable)) continue;
            item.translate(classGen, methodGen);
        }
        if (this._accessedPrefixes != null) {
            boolean declaresDefaultNS = false;
            for (Map.Entry<String, String> entry : this._accessedPrefixes.entrySet()) {
                String prefix = entry.getKey();
                String uri = entry.getValue();
                if (uri == "" && prefix == "") continue;
                if (prefix == "") {
                    declaresDefaultNS = true;
                }
                il.append(methodGen.loadHandler());
                il.append(new PUSH(cpg, prefix));
                il.append(new PUSH(cpg, uri));
                il.append(methodGen.namespace());
            }
            if (!declaresDefaultNS && this._parent instanceof XslElement && ((XslElement)this._parent).declaresDefaultNS()) {
                il.append(methodGen.loadHandler());
                il.append(new PUSH(cpg, ""));
                il.append(new PUSH(cpg, ""));
                il.append(methodGen.namespace());
            }
        }
        if (this._attributeElements != null) {
            for (SyntaxTreeNode node : this._attributeElements) {
                if (node instanceof XslAttribute) continue;
                node.translate(classGen, methodGen);
            }
        }
        this.translateContents(classGen, methodGen);
        il.append(methodGen.endElement());
    }

    private boolean isHTMLOutput() {
        return this.getStylesheet().getOutputMethod() == 2;
    }

    public ElemDesc getElemDesc() {
        if (this.isHTMLOutput()) {
            return ToHTMLStream.getElemDesc(this._name);
        }
        return null;
    }

    public boolean allAttributesUnique() {
        return this._allAttributesUnique;
    }

    private boolean checkAttributesUnique() {
        boolean hasHiddenXslAttribute = this.canProduceAttributeNodes(this, true);
        if (hasHiddenXslAttribute) {
            return false;
        }
        if (this._attributeElements != null) {
            int numAttrs = this._attributeElements.size();
            HashMap<String, Instruction> attrsTable = null;
            for (int i = 0; i < numAttrs; ++i) {
                XslAttribute xslAttr;
                AttributeValue attrName;
                SyntaxTreeNode node = this._attributeElements.get(i);
                if (node instanceof UseAttributeSets) {
                    return false;
                }
                if (!(node instanceof XslAttribute)) continue;
                if (attrsTable == null) {
                    attrsTable = new HashMap<String, Instruction>();
                    for (int k = 0; k < i; ++k) {
                        SyntaxTreeNode n = this._attributeElements.get(k);
                        if (!(n instanceof LiteralAttribute)) continue;
                        LiteralAttribute literalAttr = (LiteralAttribute)n;
                        attrsTable.put(literalAttr.getName(), literalAttr);
                    }
                }
                if ((attrName = (xslAttr = (XslAttribute)node).getName()) instanceof AttributeValueTemplate) {
                    return false;
                }
                if (!(attrName instanceof SimpleAttributeValue)) continue;
                SimpleAttributeValue simpleAttr = (SimpleAttributeValue)attrName;
                String name = simpleAttr.toString();
                if (name != null && attrsTable.get(name) != null) {
                    return false;
                }
                if (name == null) continue;
                attrsTable.put(name, xslAttr);
            }
        }
        return true;
    }

    private boolean canProduceAttributeNodes(SyntaxTreeNode node, boolean ignoreXslAttribute) {
        List<SyntaxTreeNode> contents = node.getContents();
        for (SyntaxTreeNode child : contents) {
            if (child instanceof Text) {
                Text text = (Text)child;
                if (text.isIgnore()) continue;
                return false;
            }
            if (child instanceof LiteralElement || child instanceof ValueOf || child instanceof XslElement || child instanceof Comment || child instanceof Number || child instanceof ProcessingInstruction) {
                return false;
            }
            if (child instanceof XslAttribute) {
                if (ignoreXslAttribute) continue;
                return true;
            }
            if (child instanceof CallTemplate || child instanceof ApplyTemplates || child instanceof Copy || child instanceof CopyOf) {
                return true;
            }
            if ((child instanceof If || child instanceof ForEach) && this.canProduceAttributeNodes(child, false)) {
                return true;
            }
            if (!(child instanceof Choose)) continue;
            List<SyntaxTreeNode> chooseContents = child.getContents();
            for (SyntaxTreeNode chooseChild : chooseContents) {
                if (!(chooseChild instanceof When) && !(chooseChild instanceof Otherwise) || !this.canProduceAttributeNodes(chooseChild, false)) continue;
                return true;
            }
        }
        return false;
    }
}

